// user define section based on VDSL_CPE_62.mem
//               CACHE_IRAM:    ORIGIN = 0x80000, LENGTH = 1024K
//         BOOTLOADER_CACHE:    ORIGIN = ADDR(CACHE_IRAM), LENGTH = 0x500
//               VDSL_CACHE:    ORIGIN = ADDR(BOOTLOADER_CACHE) + SIZEOF(BOOTLOADER_CACHE), LENGTH = 112K
//               ADSL_CACHE:    ORIGIN = ADDR(VDSL_CACHE) + SIZEOF(VDSL_CACHE), LENGTH = 200K

eval gl_StartOfCache = 0x80000
eval gl_LoaderCacheSize = 0x500
eval gl_VdslCacheSize = 112*1024

// boot loader already loaded in the simulator memory at the start of cache


// attaching vdsl cache
eval gl_CurImageEnd = gl_StartOfCache + gl_LoaderCacheSize
file2mem (long*)(*((long*)&gl_CurImageEnd)) obj\vcpe_cache.bin


// attaching adsl cache
eval gl_CurImageEnd = gl_CurImageEnd + gl_VdslCacheSize
file2mem (long*)(*((long*)&gl_CurImageEnd)) obj\adsl_cache.bin


// read adsl cache size from the adsl_cache.bin itself to figure out the end of the image
eval gl_CurImageEnd = *((long *)(*(long*)&gl_CurImageEnd)) + 8

eval gl_CurImageEnd = gl_CurImageEnd + (*(long*)gl_CurImageEnd + 8)


// attaching vdsl image
file2mem (long*)(*((long*)&gl_CurImageEnd)) obj\vcpe_hw.bin
// updating VDSL header entry of the bootloader swap header table
eval *(gl_StartOfCache + 9*4) = (gl_CurImageEnd - gl_StartOfCache)
                                                                  

// read vdsl FW size from the vcpe_hw.bin itself to figure out the end of the image
eval gl_CurImageEnd = gl_CurImageEnd + (*(long*)gl_CurImageEnd + 8)

// attaching adsl image
file2mem (long*)(*((long*)&gl_CurImageEnd)) obj\ModemHWE_hw.bin
// updating ADSL header entry of the bootloader swap header table
eval *(gl_StartOfCache + 15*4) = (gl_CurImageEnd - gl_StartOfCache)
                                                                  
// read adsl FW size from the ModemHWE_hw.bin itself to figure out the end of the image
eval gl_CurImageEnd = gl_CurImageEnd + (*(long*)gl_CurImageEnd + 8)
// calculate size of new image
eval gl_CurImageEnd = gl_CurImageEnd - gl_StartOfCache

mem2file gl_StartOfCache  gl_CurImageEnd obj\adsl_vdsl_cpe.bin
exit
