@echo off
rem **COPYRIGHT*****************************************************************
rem    INTEL CONFIDENTIAL
rem    Copyright (C) 2017 Intel Corporation
rem *****************************************************************COPYRIGHT**
rem **DISCLAIMER****************************************************************
rem  The source code contained or described herein and all documents related
rem  to the source code ("Material") are owned by Intel Corporation or its
rem  suppliers or licensors. Title to the Material remains with Intel
rem  Corporation or its suppliers and licensors. The Material may contain
rem  trade secrets and proprietary and confidential information of Intel
rem  Corporation and its suppliers and licensors, and is protected by
rem  worldwide copyright and trade secret laws and treaty provisions. No part
rem  of the Material may be used, copied, reproduced, modified, published,
rem  uploaded, posted, transmitted, distributed, or disclosed in any way
rem  without Intel's prior express written permission.
rem
rem  No license under any patent, copyright, trade secret or other
rem  intellectual property right is granted to or conferred upon you by
rem  disclosure or delivery of the Materials, either expressly, by
rem  implication, inducement, estoppel or otherwise. Any license under
rem  such intellectual property rights must be express and approved by
rem  Intel in writing.
rem ****************************************************************DISCLAIMER**
@echo on

set INC_PATH=-I../modem/source/Vdsl_Task/include -I../modem/source/vdsl_platform/include -I../modem/arc_src/include -I../modem/source/vdsl_hwexec_50/include -I../modem/source/hwengine_50/include
set BM_INC_PATH=@HWEngineLib_62.inc
rem set CFLAGS= -g -DLOADER_62_ASIM -Hoff=volatile_cache_bypass -Hnosdata -Hkeepasm -c -arc600 -Xbarrel_shifter -Hoff=Ldst_from_code -DTARGET_HW -DBOOTLOADER_62 -DVDSL_62

rem the released one
set CFLAGS=-g0 -Hoff=volatile_cache_bypass -Hnosdata -Hkeepasm -c -arc600 -Xbarrel_shifter -Hoff=Ldst_from_code -DTARGET_HW -DBOOTLOADER_62 -DVDSL_62 -DVRX518
rem end of the released one

rem set CFLAGS=-g0 -DVR9_BRING_UP_TEST -Hoff=volatile_cache_bypass -Hnosdata -Hkeepasm -c -arc600 -Xbarrel_shifter -Hoff=Ldst_from_code -DTARGET_HW -DBOOTLOADER_62 -DVDSL_62
set LDFLAGS= -arc600 -e hw_reset_isr -u hw_reset_isr -Hnocrt -Hldopt=-Cout=map\loader_VRx518_vdsl.map -Hldopt=-Cpage=0 -Hldopt=-Ccrossref -z stdout -m
set OBJ_DIR=obj

rm -f *.o %OBJ_DIR%\*.o %OBJ_DIR%\*_vdsl.bin %OBJ_DIR%\*_vdsl.out 



rem compile individual object files
hcac.exe %INC_PATH% %BM_INC_PATH% %CFLAGS% source\loader_62.c  -o %OBJ_DIR%\loader_62.o
hcac.exe %INC_PATH% %BM_INC_PATH% %CFLAGS% ..\modem\arc_src\platform\xdma_62.c  -o %OBJ_DIR%\xdma_62.o
hcac.exe -Hasmcpp %INC_PATH% %BM_INC_PATH% %CFLAGS% source\interrupts_62b.s -o %OBJ_DIR%\interrupts_62b.o

mv *.s asm\


rem creating linker command file
perl ..\modem\arc_bld_62\perl\ifdef_processing.pl ..\Modem\arc_bld_62\make_inputs\VRX518_VDSL_CPE_62.mem loader_62_hw_vdsl.cmd "." "AFE_IFX2870_TECH_C VDSL_62 DMT_SCOPE DO_NOT_USE_MDIO_HW"
perl ..\modem\arc_bld_62\perl\ifdef_processing.pl loader_62_inputs.cmd temp_loader_62_hw.cmd "." "VDSL_62"

rem generate timestamp
perl ..\modem\arc_bld_62\perl\timestamp.pl temp_loader_62_hw.cmd temp2_loader_62_hw.cmd

type temp2_loader_62_hw.cmd  >> loader_62_hw_vdsl.cmd 
del temp*_loader_62_hw.cmd


rem link object files to form image
hcac.exe %LDFLAGS% %OBJ_DIR%\loader_62.o %OBJ_DIR%\interrupts_62b.o %OBJ_DIR%\xdma_62.o loader_62_hw_vdsl.cmd -o %OBJ_DIR%\loader_VRx518_vdsl.out

rem invoke simulator to merge loader, vdsl and adsl images
scac.exe -cl -memext=0,0x4fffff -memextinit=0 -nogoifmain -nooptions  -cmd="read extractLoader_62.sc" %OBJ_DIR%/loader_VRx518_vdsl.out 
copy %OBJ_DIR%\loader_62.bin  %OBJ_DIR%\loader_VRx518_vdsl.bin 

cp -f %OBJ_DIR%\loader_VRx518_vdsl.bin  ..\modem\arc_bld_62\obj\loader_62\loader_VRx518.bin
cp -f %OBJ_DIR%\loader_VRx518_vdsl.out  ..\modem\arc_bld_62\obj\loader_62\loader_VRx518.out
