# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
// ***********************************************************************************************************
// loader_62_inputs.cmd
//
// History
//
// 07/11/2012 Kannan: 
// (1) MEI driver needs an information about the Bootloader binary size dynamically as on when the
//     boot loader binary changes, This is required for the MEI driver to copy 
//     the cache memory from external to PDBRAM for VRX318.
// (2) Boot loader size is available as a part of Boot loader image at Page 11. 
// (3) Though the boot loader binary size is required for VRX318, It can be common for  VR9
//     too, since VR9 MEI driver doesn't look for boot loader binary size and don't have impact on VR9.
// Grep for: "XDSLRTFW-547: Platform_VRX318_FlexibleBootLoader"
//11/07/2013 Kannan : Implemented New Memory Layout Type - 2
//         It is common for both VR9 & VRX318.
//         Grep for "XDSLRTFW-1022: Feature_VR9_VRX318_FirmwareNewMemoryLayoutType_2"
// ************************************************************************************************************

MEMORY {
   LOADER_IMAGE_HEADER_FADX:    ORIGIN = ADDR(BOOTLOADER_CACHE), LENGTH = ((SIZEOF(.LOADER_IMAGE_HEADER) + 3)/4)*4;

       LOADER_CACHE_FADX_PM:    ORIGIN = ADDR(LOADER_IMAGE_HEADER_FADX) + SIZEOF(LOADER_IMAGE_HEADER_FADX), LENGTH = ((SIZEOF(.PMSWAP_LOADER_CACHE) + 3)/4)*4;

  LOADER_INTVECS_FADX_PM_BT:    ORIGIN = ADDR(LOADER_CACHE_FADX_PM) + SIZEOF(LOADER_CACHE_FADX_PM), LENGTH = ((SIZEOF(.PMSWAP_LOADER_INTVECS) + 3)/4)*4;

     LOADER_DATA_FADX_DM_BT:    ORIGIN = ADDR(LOADER_INTVECS_FADX_PM_BT) + SIZEOF(LOADER_INTVECS_FADX_PM_BT), LENGTH = ((SIZEOF(.DMSWAP_LOADER_DATA)  + SIZEOF(.TIME_STAMP) + 3)/4)*4;

            MBOX_FADX_DM_BT:    ORIGIN = ADDR(LOADER_DATA_FADX_DM_BT) + SIZEOF(LOADER_DATA_FADX_DM_BT), LENGTH =  ((SIZEOF(.DMSWAP_MBOX) + 3)/4)*4;

                  LAST_FADX:    ORIGIN = ADDR(MBOX_FADX_DM_BT) + SIZEOF(MBOX_FADX_DM_BT), LENGTH =  0;
}

// the following are real pages including MAIN, training and showtime pages
SECTIONS {


    GROUP LOAD((ADDR(LOADER_IMAGE_HEADER_FADX))): {
        .LOADER_IMAGE_HEADER ALIGN(4): {
        _StartOfFlash = .;
            LONG(ADDR(LAST_FADX) - ADDR(LOADER_IMAGE_HEADER_FADX) - 8);   // IMAGE SIZE in bytes
            LONG(0x00000000)                      // image checksum

            LONG(11);    // num of swap pages  //XDSLRTFW-547: Platform_VRX318_FlexibleBootLoader (START_END)
            //XDSLRTFW-1022: Feature_VR9_VRX318_FirmwareNewMemoryLayoutType_2 (START)

            // Page 0: PortModeControlStructure
            LONG(0x00002468);       // uc_DualPortModeLock = 0; uc_XdslModeLock = 0; signature1 = 0x2468
            LONG(0xFFFF0000);       // uc_XdslModePreferred = 0x00(VDSL); uc_DualPortModePreferred = 0x00(single-port);
            LONG(0);                // size = 0 to prevent driver crash 
            LONG(0);
            LONG(0);
            LONG(0);
            
            //Page 1:               // PortModeControlStructure Future use
            LONG(0);
            LONG(0);
            LONG(0);
            LONG(0);
            LONG(0);
            LONG(0);
            //Page 2:     
            // Size of Resident Cache to maintain showtime.
            LONG(0);    //not used
            LONG(0);    //not used
            LONG(0);    //not used
            LONG(1);    //Revision - Number; 1-> FML type 2, 0->old legacy FW binaries
            LONG(2);    //Firmware Layout Type 2
                        //"Page 2: Must be 0 for ""old"" legacy FW binaries!
                        //Firmware Memory Layout (FML) requested by the Firmware to instruct Software (MEI Driver)
                        //FML-Type-0:
                        //   Straight mapping from FW binary to BAR register usage. BAR registers are mapped to both ADSL and VDSL cache as well as ADSL and VDSL fullimage.
                        //FML-Type-1:
                        //    Only valid for VRX318 because it is PDBRAM related.
                        //    Includes (ADSL OR VDSL) cache within PDBRAM and (ADSL AND VDSL) fullimage within SDRAM (starting at BAR3)
                        //FML-Type-2:
                        //    (ADSL cache AND fullimage) OR  (VDSL cache AND fullimage) are mapped via the BAR registers"

            LONG(0);    //Size of debug data requested from the Firmware to be allocated by the MEI driver for BAR16 in bytes
                        // will be filled out by combined image script

            //Page 3            
            LONG( ADDR(LAST_FADX) - ADDR(LOADER_IMAGE_HEADER_FADX) );   // Size of boot loader in bytes
            LONG(0);    //not used
            LONG(0);    //not used
            LONG(0);    //not used
            LONG(0);    //not used
            LONG(0);    //not used

            //Page 4
            // VDSL image offset to be filled out by combined image script
            LONG(0);
            LONG(0);
            LONG(0);
            // ADSL image offset to be filled out by combined image script
            LONG(0);
            LONG(0);
            LONG(0);

            // VDSL cache offset to be filled out by combined image script
            LONG(0);
            LONG(0);
            LONG(0);
            // ADSL cache offset to be filled out by combined image script            
            LONG(0);
            LONG(0);
            LONG(0);
            //XDSLRTFW-1022: Feature_VR9_VRX318_FirmwareNewMemoryLayoutType_2 (END)

            LONG(ADDR(LOADER_CACHE_FADX_PM) - ADDR(LOADER_IMAGE_HEADER_FADX));
            LONG(ADDR(.PMSWAP_LOADER_CACHE));
            LONG(SIZEOF(LOADER_CACHE_FADX_PM)/4);
            LONG(0);
            LONG(0);
            LONG(0);

            LONG(ADDR(LOADER_INTVECS_FADX_PM_BT) - ADDR(LOADER_IMAGE_HEADER_FADX));
            LONG(ADDR(.PMSWAP_LOADER_INTVECS));
            LONG(0x80000000 + (SIZEOF(LOADER_INTVECS_FADX_PM_BT)/4));
            LONG(0);
            LONG(0);
            LONG(0);

            LONG(0);
            LONG(0);
            LONG(0);
            LONG(ADDR(LOADER_DATA_FADX_DM_BT) - ADDR(LOADER_IMAGE_HEADER_FADX));
            LONG(ADDR(.DMSWAP_LOADER_DATA));
            LONG(0x80000000 + (SIZEOF(LOADER_DATA_FADX_DM_BT)/4));

            LONG(0);
            LONG(0);
            LONG(0);
            LONG(ADDR(MBOX_FADX_DM_BT) - ADDR(LOADER_IMAGE_HEADER_FADX));
            LONG(ADDR(.DMSWAP_MBOX));
            LONG(0x80000000 + (SIZEOF(MBOX_FADX_DM_BT)/4));

            //XDSLRTFW-547: Platform_VRX318_FlexibleBootLoader (START)
            //Size of the bootloader Binary for VRX318 Platform, This is required for the SW to load the ADSL/VDSL
            //executable properly into the PDBRAM
            LONG(0);
            LONG(0);
            LONG(ADDR(LAST_FADX) - ADDR(LOADER_IMAGE_HEADER_FADX));   // IMAGE SIZE in bytes
            LONG(0);
            LONG(0);
            LONG(0);	
            //XDSLRTFW-547: Platform_VRX318_FlexibleBootLoader (END) 
			
        }
    } > BOOTLOADER_CACHE

    GROUP LOAD((ADDR(LOADER_INTVECS_FADX_PM_BT))): {
        .PMSWAP_LOADER_INTVECS ALIGN(4): {
            interrupts_62b.o (.INTVECS)
        }
    } > INTVECS_IRAM

    GROUP LOAD((ADDR(LOADER_CACHE_FADX_PM))): {
        .PMSWAP_LOADER_CACHE ALIGN(4): {
                interrupts_62b.o (.INTVECS)
                loader_62.o(.text)
                xdma_62.o(.text)
                *(.text)
        }
    } > BOOTLOADER_CACHE

    GROUP LOAD((ADDR(LOADER_DATA_FADX_DM_BT))):{
        .DMSWAP_LOADER_DATA ALIGN(4): {
                *(.data)
                *(.LOCAL_LD_ST)
                *(.rodata)
                *(.bss)
                *(.init)
                *(.lit)
        }

        .TIME_STAMP ALIGN(4): {
        guca_TimeStampString = .;
            BYTE(DAY);          // day
            BYTE(MONTH);        // month
            BYTE(MINUTE);       // minute
            BYTE(HOUR);         // hour
            LONG(YEAR);         // year
        }
    } > BOOTLOADER_DATA

    GROUP :{
        .DMSWAP_PORTMODECONTROL ALIGN(4): {
                *(.PORTMODECONTROL_DATA)
        }
    } > PORT_MODE_CONTROL_DATA

    GROUP: {
        .stack SIZE(DEFINED _STACKSIZE?_STACKSIZE:2K):{}
    } > STACK_RAM

    
    GROUP LOAD((ADDR(MBOX_FADX_DM_BT))):{
        .DMSWAP_MBOX: {
            __gt_HmpHeader = .;
                SHORT((0x1 << 8) | 0x1);             // version, num_of_mbox_pairs
                SHORT((0x1 << 8) | 0x4);             // offset_to_first_desc, size_of_desc, 

            __gta_HmpMboxDescriptor = .;
                LONG(ADDR(ARC_TO_MEI_MBOX));
                LONG(SIZEOF(ARC_TO_MEI_MBOX)/2);
                LONG(ADDR(MEI_TO_ARC_MBOX));
                LONG(SIZEOF(MEI_TO_ARC_MBOX)/2);

            __gs_Me2ArcMboxCode = .;
            __gt_Me2ArcMboxMsg = .;
                SHORT(0);           // mbox_code
                SHORT(0);            // word0
                SHORT(0);            // word1
                SHORT(0);            // word2
                SHORT(0);            // word3
                SHORT(0);            // word4
                FILL(128*2);        // payload; FILL directive fills num of BYTES!
                
            __gs_Arc2MeMboxCode = .;
            __gt_Arc2MeMboxMsg = .;
                SHORT(0x0002)
                SHORT(0x4010)
                SHORT(0x0001)
                SHORT(0xFF02)
                SHORT(0x0000)
                SHORT(0x0001)
                FILL(128*2);        // payload; FILL directive fills num of BYTES!
        }
    } > HMP_MBOXES
}

