;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        interrupts_62b.s
;
; DESCRIPTION:     an extract from interrupts_62.s
;
;*************************************************************************

#define IN_ASM
;.include "asm.h"
;.include "interrupts.h"
#include "dsp_regs_62.h"


;**********************************************************
;   interrupt vector table
;**********************************************************

    .file "interrupts_62b.s"

    .extern main

    .global hw_reset_isr

    .global hw_reset

    .global _exit_halt

;    .global invalid_int_isr
;    .global reserved_int_isr


    .section .INTVECS, text
    .align 4

hw_reset:      j hw_reset_isr
mem_except:    j reserved_int_isr        ; MEMEX
instr_err:     j reserved_int_isr        ; INSTERR
ivect3:        j invalid_int_isr         ; not connected
ivect4:        j invalid_int_isr         ; not connected
ivect5:        j invalid_int_isr         ; ME_MSG
ivect6:        j invalid_int_isr         ; ADMA
ivect7:        j invalid_int_isr         ; XDMA

ivect8:        j invalid_int_isr         ; xdsl_1_port0
ivect9:        j invalid_int_isr         ; xdsl_2_port0; not used

ivectA:        j invalid_int_isr         ; xdsl_1_port1
ivectB:        j invalid_int_isr         ; xdsl_2_port1; not used

ivectC:        j invalid_int_isr         ; ME_GP_0
ivectD:        j invalid_int_isr         ; ME_GP_1
ivectE:        j invalid_int_isr         ; GPIO14_INT; connected to pin14
ivectF:        j invalid_int_isr         ; GPIO15_INT; connected to pin15



    .text
// for bad exceptions, the code eventually will be written to:
// 1. disable interrupts
// 2. lock the processor in infinite loop while still providing
//    MP message handling.

reserved_int_isr:
invalid_int_isr:
               j   invalid_int_isr                     ; trap loop

;**********************************************************
;   Hardware Reset
;**********************************************************

    ; Slightly modified of crt1.s from Metaware.
    ; Initialize the register file.  This is necessary because
    ; of an idiosyncracy of the register file implementation.
    ; Compiled code may generate sub  r0, r1, r1, expecting to
    ; load 0 into r0, but the individual reads of r1 for the two source
    ; operands may return different (garbage) values if r1 had never
    ; been written to since reset.
    ; NOTE: This initialization is required ONLY for Tangent ARC4 builds.
    ;       You may comment it out if not using an ARC4 build.

    .text
    .weak    _SDA_BASE_

    .type    hw_reset_isr, @function
    .align 4
hw_reset_isr:

    mov    sp, _estack              ; initialize stack pointer to end of .stack section
    mov    gp, _SDA_BASE_           ; initialize small-data base register

    ; setting INT_VECTOR_BASE just in case driver/loader mess it up.
    xor r0, r0, r0
    sr r0, [INT_VECTOR_BASE]
    st r0, [DSP_INT_MASK]           ; disable all interrutps
mov ilink2, 0xB001
    bl.d   main                     ; body of BootLoader62
    mov    fp, 0

    ; never return here
_exit_halt:
    flag    0x01                    ; halt the processor
    nop
    b    _exit_halt
    nop

    ; weak versions of small data symbols normally defined by the linker.
    .weak _fsbss
    .weak _esbss
    .set _fsbss,0
    .set _esbss,0

    ; weak versions of heap section boundaries.  If a .heap section
    ; is provided, our low-level allocator "sbrk" allocates within it.
    ; If no .heap is provided, we allocate from _end to the end of memory.
    .weak _fheap
    .weak _eheap
    .set _fheap,0
    .set _eheap,0

    .end
