/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1995-2003 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*     All Rights Reserved
*
*     40, Middlesex Turnpike , Bedford, MA 01730-1413
*     Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*     loader_62.c
*
*     Aware bootloader which will load and start vdsl/adsl modem depending
*       on hw configuration
*
*-------------------------------------------------------------------
*/
// ******************************************************************
// loader_62.c
//
// History
//
//
// 8/11/2012 Kannan: Byte offset 9 of portmode control structure "uc_AfePowerUp"
//                   bits b1-0 are used to indicate the AFE initialization status.
//                   This is common for both VR9 & VRX318
//                   Grep for: "XDSLRTFW-542: Platform_VR9_VRX318_AFE_InitStatus"
//
//11/07/2013 Kannan : Implemented New Memory Layout Type - 2
//         It is common for both VR9 & VRX318.
//         Grep for "XDSLRTFW-1022: Feature_VR9_VRX318_FirmwareNewMemoryLayoutType_2"
// ******************************************************************


/*******************************************************************
*
*     Include Files
*
*******************************************************************/

#include "common.h"
#include "codeswap.h"
#include "aux_regs.h"
#include "data_alloc.h"
#include "xdma.h"
#include "vdsl_xception.h"
#include "ll_iof.h"
#include "cri_memmap.h"




int32 gl_DetectedErrors;

extern int32 gl_XmemXstat;

void hw_reset(void);    // prototype of hw_reset interrupt vector
void _exit_halt(void);

typedef struct {
    int32 l_ImageSize;
    int32 l_ImageCheckSum;
    int32 l_NumOfSwaps;
} ImageHeader_t;

ImageHeader_t gt_ImageHeader;
int32 gl_StartOfCache;
int32 gl_CurImageStart;
int32 gl_CurImageEnd;
int32 gl_CurImageSize;

typedef struct {
    int32 l_PmSrcOffset;
    int32 l_PmDestAddr;
    int32 l_PmSize;

    int32 l_DmSrcOffset;
    int32 l_DmDestAddr;
    int32 l_DmSize;
} SwapPageHeader_t;

// offsets to entries/fields of the Combined Image Header
#define BIN_IMAGE_SIZE_IN_BYTES_OFFSET          0
#define IMAGE_CHECKSUM_OFFSET                   4
#define NUM_OF_PAGES_OFFSET                     8
#define PORT_MODE_CONTROL_OFFSET                0xC
//XDSLRTFW-1022: Feature_VR9_VRX318_FirmwareNewMemoryLayoutType_2 (START)
#define VDSL_IMAGE_ENTRY_OFFSET                 (PORT_MODE_CONTROL_OFFSET + 6*4*4)
#define ADSL_IMAGE_ENTRY_OFFSET                 (VDSL_IMAGE_ENTRY_OFFSET  + 3*4)
//XDSLRTFW-1022: Feature_VR9_VRX318_FirmwareNewMemoryLayoutType_2 (END)


typedef struct {
    int16 s_PageNum;
    int16 s_RunNum;
    int32 *pl_ErrorAtAddr;
} BootPageError1_t;


typedef struct {
    int32 *pl_ErrorAtAddr1;
    int32 *pl_ErrorAtAddr2;
} BootPageError2_t;

#define MAX_TEST_1_COUNT            0x20                // to be 2^N
#define MAX_TEST_2_COUNT            MAX_TEST_1_COUNT    // must be the same

#define MAX_BOOT_PAGE_ERROR_COUNT   (MAX_TEST_1_COUNT + MAX_TEST_2_COUNT)
#define ONE_PORT_TEST_MEM_START     0x55000
#define DESTINATION_BUF_ADDR        (ONE_PORT_TEST_MEM_START + MAX_TEST_1_COUNT*sizeof(BootPageError1_t)+ MAX_TEST_2_COUNT*sizeof(BootPageError2_t))




// Combined Image Header Layout
//
// Bin_Image_Size
// Image_CheckSum
// Num_of_Pages
//
// header_entry_0: PortModeControl structure
//
// header_entry_1: Vdsl ImageOffset
//
// header_entry_2: Adsl ImageOffset
//
// header_entry_3: Vdsl - size of external writeable DATA region [bytes]
//
// header_entry_4: Adsl - size of external writeable DATA region [bytes]



DATA_PORTMODECONTROL_BEGIN
    PortModeControl_t gt_PortModeControl;
DATA_MAP_END;


int32 gl_FirstTimeDiff;
int32 gl_XdmaStable = 1;
int32 l_ErrorIndex1 = 0;
int32 l_ErrorIndex2 = 0;
BootPageError1_t *gta_BootPageError1;
BootPageError2_t *gta_BootPageError2;
int32 gl_Test1FailCount;
int32 gl_BootWorkAround;

//SwapPageHeader_t gta_ImageHeaderTable[MAX_SUPPORTED_SWAP_PAGES];
SwapPageHeader_t gt_SwapHeader;

volatile int32 gl_ErrorLoopCnt;
int32 gl_ImageSize;
uint8 guc_ch_id;
uint8 guc_xdma_reg_offset;




// these variables are only used the loader build.
// recall that in the final bin image:
//      loader_image
//      vdsl_image
//      adsl_image


void LoadBootPages(int32 l_NumOfPorts);
int32 TestBootPages(int32 l_Port, int32 l_RunCount);
int32 TestOnePage(int32 l_Port, int32 l_PageNum);

#define BOOT_PAGE_MASK              0x80000000
#define BOOT_E_CODE_XDMA_ERROR      0x4
#define BOOT_E_CODE_BOOT_PAGES_MISMATCH     0xEB


void BootError(uint8 uc_BootExceptionCode)
{
    gt_PortModeControl.uc_BootError = uc_BootExceptionCode;
    _exit_halt();
}


void ReadXdmaBlock(int32 l_SourceStart, int32 l_DestStart, int32 l_NumOfBytes)
{
#if 1
    SetupReadXdmaBlock(l_SourceStart, l_DestStart, l_NumOfBytes);
    #ifdef LOADER_62_ASIM
    {
        int16 *ps_SourceStart;
        int16 *ps_ModSourceStart;
        int16 *ps_SourceEnd;
        int16 *ps_DestStart;

        ps_SourceStart = (int16*)GetDspReg(DSP_XDMA_SA_S);
        ps_ModSourceStart = (int16*)((int32)ps_SourceStart + 0x80000);

        // program source end
        ps_SourceEnd = (int16*)GetDspReg(DSP_XDMA_SA_E);

        // program destination start
        ps_DestStart = (int16*)GetDspReg(DSP_XDMA_DA_S);

        if ((int32)ps_SourceEnd > (int32)ps_SourceStart)
        {
            for(; (int32)ps_SourceStart <= (int32)ps_SourceEnd; ps_SourceStart++)
            {
                *ps_DestStart++ = *ps_ModSourceStart++;
            }
        }
    }
    #else
    WaitForXdmaDone();

    if (gl_XmemXstat & DSP_XDMA_STAT_ERR_MASK)
    {
        BootError(BOOT_ERROR_XDMA_FAILURE);
    }
    #endif
#else
    // using LD_ST, access SRAM directly (withour XDMA engine)

    int32 l_Count;
    int32 *pl_Src, *pl_Dest;

    pl_Src = (int32 *)(l_SourceStart + 0x80000);
    pl_Dest = (int32 *)l_DestStart;

    for (l_Count = 0; l_Count < (l_NumOfBytes >> 2); l_Count++)
    {
        pl_Dest[l_Count] = pl_Src[l_Count];
    }
#endif // if 0

}


void main(void)
{
    int32 l_SramOffset;
    int32 l_SramXdslImageSize;
//    int32 l_SwapHeaderOffset;
//    int32 l_PageSrcAddr, l_PageSize;
//    int32 l_Page, l_Port;
    int32 l_NumOfPorts;
    int32 l_Temp, l_ErrorCnt;
    int32 *pl_Temp;

    gl_BootWorkAround = 0;
    guc_xdma_reg_offset = 0;
    guc_ch_id = 0;

    // set xdma fields in PORT_SEL register
    // the macro DSP_PORT_0_SEL_MASK already contains correct XDMA setting for either ports.
    SetDspReg(DSP_PORT_SEL, DSP_PORT_0_SEL_MASK);

    // validate PortModeControl structure
    if ((gt_PortModeControl.us_Signature1 != BOOT_SIGNATURE_1) ||
        (gt_PortModeControl.us_Signature0 != BOOT_SIGNATURE_0))
    {
        // clear out gt_PortModeControl
        pl_Temp = (int32 *)&gt_PortModeControl; // the max size of this struct is 6 long words!
        for(l_Temp = 6; l_Temp > 0; l_Temp--)
        {
            *pl_Temp++ = 0;
        }

        // load PortModeControl structure from image
        ReadXdmaBlock(PORT_MODE_CONTROL_OFFSET, (int32)&gt_PortModeControl, sizeof(PortModeControl_t));
        gt_PortModeControl.us_Signature1 = BOOT_SIGNATURE_1;
        gt_PortModeControl.uc_DualPortModeCurrent = gt_PortModeControl.uc_DualPortModePreferred;
        gt_PortModeControl.uc_XdslModeCurrent = gt_PortModeControl.uc_XdslModePreferred;
        //XDSLRTFW-542: Platform_VR9_VRX318_AFE_InitStatus (START)
        gt_PortModeControl.uc_AfePowerUp = (gt_PortModeControl.uc_AfePowerUp & (~AFE_POWERUP_MASK)) | AFE_COLD_START;
        //XDSLRTFW-542: Platform_VR9_VRX318_AFE_InitStatus (END)
        gt_PortModeControl.uc_AfeInitState = NO_AFE_EVENT;
    }

    // clear the Mode Locks
    gt_PortModeControl.uc_DualPortModeLock = 0;
    gt_PortModeControl.uc_XdslModeLock = 0;

    // get preferred xdsl mode image offset
    if (gt_PortModeControl.uc_XdslModeCurrent == VDSL_PORT_MODE)
    {
        l_Temp = VDSL_IMAGE_ENTRY_OFFSET;
    }
    else
    {
        l_Temp = ADSL_IMAGE_ENTRY_OFFSET;
    }

    ReadXdmaBlock(l_Temp, (int32)&gt_SwapHeader, sizeof(SwapPageHeader_t));
    l_SramOffset = gt_SwapHeader.l_PmSrcOffset;
    l_SramXdslImageSize = gt_SwapHeader.l_PmSize;

    if ((l_SramOffset == 0) || (l_SramXdslImageSize == 0))
    {
        // invalid XDSL image
        BootError(BOOT_ERROR_INVALID_IMAGE);
    }

    l_Temp = GetDspReg(DSP_MEMEX_SEL);
    if (l_Temp & 0x3)
    {
        // incorrect MEMEXT setting
        BootError(BOOT_ERROR_INVALID_MEMEXT_SEL);
    }

    gt_PortModeControl.l_SRAMImageOffset = l_SramOffset;

    if (gt_PortModeControl.uc_DualPortModeCurrent == SINGLE_PORT_MODE)
    {
        l_NumOfPorts = 0;

        // program CRI_PORT_MODE
        SetDspReg(CRI_PORT_MODE_ADDR, 0);

    }
    else
    {
        l_NumOfPorts = 1;

        // program CRI_PORT_MODE
        SetDspReg(CRI_PORT_MODE_ADDR, -1);
    }


__ReloadingBootPages:
    gt_PortModeControl.uc_BootError = 0;
    LoadBootPages(l_NumOfPorts);

    if (gt_PortModeControl.uc_DualPortModeCurrent == SINGLE_PORT_MODE)
    {
        // byte reversal test/work-around code
        gl_FirstTimeDiff = -1;
        gl_XdmaStable = -1;
        gta_BootPageError1 = (BootPageError1_t *)ONE_PORT_TEST_MEM_START;
        gta_BootPageError2 = (BootPageError2_t *)&gta_BootPageError1[MAX_TEST_1_COUNT];
        gt_PortModeControl.uc_BootError = 0;
        gl_Test1FailCount = 0;

        for (l_Temp = 0; l_Temp < MAX_TEST_1_COUNT; l_Temp++)
        {
            gta_BootPageError1[l_Temp].s_RunNum = 0;
            gta_BootPageError1[l_Temp].s_PageNum = 0;
            gta_BootPageError1[l_Temp].pl_ErrorAtAddr = (int32 *)0;

            gta_BootPageError2[l_Temp].pl_ErrorAtAddr1 = (int32 *)0;
            gta_BootPageError2[l_Temp].pl_ErrorAtAddr2 = (int32 *)0;
        }

        l_ErrorIndex1 = 0;
        for (l_Temp = 0; l_Temp < 100; l_Temp++)
        {
            if (l_ErrorCnt = TestBootPages(0, l_Temp))
            {
                gl_DetectedErrors += l_ErrorCnt;

                if (gl_FirstTimeDiff == -1)
                {
                    gl_FirstTimeDiff = l_Temp;
                }

                gl_Test1FailCount++;
                if (gl_Test1FailCount > 40)
                {
                    break;  // goto test2
                }
                gt_PortModeControl.uc_BootError = 0xBE;
            }
            else
            {
                gl_Test1FailCount = 0;
                gl_FirstTimeDiff = -1;
            }
        }


        // only run test2 if test1 completes with at least one mismatched page
        if (l_ErrorIndex1 > 0)
        {
            l_ErrorIndex2 = 0;
            gl_XdmaStable = 1;
            for (l_Temp = 0; l_Temp < 50; l_Temp++)
            {
                if (TestOnePage(0, gta_BootPageError1[0].s_PageNum))
                {
                        gl_XdmaStable = 0;
                }
            }
        }



        if (gt_PortModeControl.uc_BootError == 0)
        {
            guc_xdma_reg_offset = 0;
            guc_ch_id = 0;
            // transition execution to Reset Vector

            hw_reset();
        }
        else if (gl_BootWorkAround++ < 5)
        {
            goto __ReloadingBootPages;
        }
        else
        {
            BootError(0xEB);
        }
    }
    else
    {
        if (gt_PortModeControl.uc_BootError == 0)
        {
            guc_xdma_reg_offset = 0;
            guc_ch_id = 0;
            // transition execution to Reset Vector

            hw_reset();
        }
        else
        {
            BootError(0xEB);
        }
    }
}

// return 0 - if all boot pages match.
// return 1 - if mismatch detected.
// the errored page will be logged into
// gta_BootPageError[20]
//  l_PageNum, l_ErrorAtAddr

int32 TestBootPages(int32 l_Port, int32 l_RunCount)
{
    int32 l_SwapHeaderOffset, l_Page, l_PageSrcAddr, l_PageSize, l_SramOffset;

    //int32 l_ErrorIndex, l_Count;
    int32 l_Count;
    int32 l_ErrorDetected = 0;

    int32 *la_DestBuf, *la_InternalDestBuf;

    l_SramOffset = gt_PortModeControl.l_SRAMImageOffset;
    la_DestBuf = (int32 *) DESTINATION_BUF_ADDR;
    //l_ErrorIndex = 0;

    guc_ch_id = l_Port;

    // setting port environment
    if (l_Port == 0)
    {
        guc_xdma_reg_offset = 0;
    }
    else
    {
        guc_xdma_reg_offset = DSP_XDMA1_CTRL - DSP_XDMA0_CTRL;
    }

    // read XDSL image header
    ReadXdmaBlock(l_SramOffset, (int32)&gt_ImageHeader, sizeof(ImageHeader_t));
    l_SwapHeaderOffset = l_SramOffset + sizeof(ImageHeader_t);


    // bring in boot page for this modem
    for (l_Page = 0; l_Page < gt_ImageHeader.l_NumOfSwaps; l_Page++)
    {
        // the swap header
        ReadXdmaBlock(l_SwapHeaderOffset, (int32)&gt_SwapHeader,  sizeof(SwapPageHeader_t));

        // after toggle the MSB, the boot page size should be > 0
        if ((l_PageSize = gt_SwapHeader.l_PmSize ^ BOOT_PAGE_MASK) > 0)
        {
            l_PageSrcAddr = l_SramOffset + gt_SwapHeader.l_PmSrcOffset;

            ReadXdmaBlock(l_PageSrcAddr, (int32)DESTINATION_BUF_ADDR, l_PageSize << 2);

            la_InternalDestBuf = (int32 *)gt_SwapHeader.l_PmDestAddr;

            for (l_Count = 0; l_Count < l_PageSize; l_Count++)
            {
                if (la_DestBuf[l_Count] != la_InternalDestBuf[l_Count])
                {
                    if (l_ErrorIndex1 < MAX_TEST_1_COUNT)
                    {
                        gta_BootPageError1[l_ErrorIndex1].s_RunNum = l_RunCount;
                        gta_BootPageError1[l_ErrorIndex1].s_PageNum = l_Page;
                        gta_BootPageError1[l_ErrorIndex1].pl_ErrorAtAddr = &la_InternalDestBuf[l_Count];
                        l_ErrorIndex1++;
                    }
                    l_ErrorDetected = 1;
                    break;
                }
            }
        }

        if ((l_PageSize = gt_SwapHeader.l_DmSize ^ BOOT_PAGE_MASK) > 0)
        {
            l_PageSrcAddr = l_SramOffset + gt_SwapHeader.l_DmSrcOffset;

            ReadXdmaBlock(l_PageSrcAddr, DESTINATION_BUF_ADDR, l_PageSize << 2);

            la_InternalDestBuf = (int32 *)gt_SwapHeader.l_DmDestAddr;

            for (l_Count = 0; l_Count < l_PageSize; l_Count++)
            {
                if (la_DestBuf[l_Count] != la_InternalDestBuf[l_Count])
                {
                    if (l_ErrorIndex1 < MAX_TEST_1_COUNT)
                    {
                        gta_BootPageError1[l_ErrorIndex1].s_RunNum = l_RunCount;
                        gta_BootPageError1[l_ErrorIndex1].s_PageNum = l_Page;
                        gta_BootPageError1[l_ErrorIndex1].pl_ErrorAtAddr = &la_InternalDestBuf[l_Count];
                        l_ErrorIndex1++;
                    }
                    l_ErrorDetected = 1;
                    break;
                }
            }
        }

        l_SwapHeaderOffset += sizeof(SwapPageHeader_t);
    }

    return(l_ErrorDetected);

}

int32 TestOnePage(int32 l_Port, int32 l_PageNum)
{
    int32 l_SwapHeaderOffset, l_Page, l_PageSrcAddr, l_PageSize, l_SramOffset;

    //int32 l_ErrorIndex, l_Count;
    int32 l_Count;

    int32 *la_DestBuf, *la_InternalDestBuf;

    l_SramOffset = gt_PortModeControl.l_SRAMImageOffset;
    la_DestBuf = (int32 *) DESTINATION_BUF_ADDR;
    //l_ErrorIndex = 0;

    guc_ch_id = l_Port;

    // setting port environment
    if (l_Port == 0)
    {
        guc_xdma_reg_offset = 0;
    }
    else
    {
        guc_xdma_reg_offset = DSP_XDMA1_CTRL - DSP_XDMA0_CTRL;
    }

    // read XDSL image header
    ReadXdmaBlock(l_SramOffset, (int32)&gt_ImageHeader, sizeof(ImageHeader_t));
    l_SwapHeaderOffset = l_SramOffset + sizeof(ImageHeader_t);


    // bring in boot page for this modem
    for (l_Page = 0; l_Page < gt_ImageHeader.l_NumOfSwaps; l_Page++)
    {
        // the swap header
        ReadXdmaBlock(l_SwapHeaderOffset, (int32)&gt_SwapHeader,  sizeof(SwapPageHeader_t));

        if (l_Page == l_PageNum)
        {
            // after toggle the MSB, the boot page size should be > 0
            if ((l_PageSize = gt_SwapHeader.l_PmSize ^ BOOT_PAGE_MASK) > 0)
            {
                l_PageSrcAddr = l_SramOffset + gt_SwapHeader.l_PmSrcOffset;

                ReadXdmaBlock(l_PageSrcAddr, (int32)DESTINATION_BUF_ADDR, l_PageSize << 2);
                ReadXdmaBlock(l_PageSrcAddr, (int32)DESTINATION_BUF_ADDR + (l_PageSize << 2), l_PageSize << 2);

                la_InternalDestBuf = (int32 *)((int32)DESTINATION_BUF_ADDR + (l_PageSize << 2));

                for (l_Count = 0; l_Count < l_PageSize; l_Count++)
                {
                    if (la_DestBuf[l_Count] != la_InternalDestBuf[l_Count])
                    {
                        if (l_ErrorIndex2 < MAX_TEST_2_COUNT)
                        {
                            gta_BootPageError2[l_ErrorIndex2].pl_ErrorAtAddr1 = &la_DestBuf[l_Count];
                            gta_BootPageError2[l_ErrorIndex2].pl_ErrorAtAddr2 = &la_InternalDestBuf[l_Count];
                            l_ErrorIndex2++;
                        }
                        return(TRUE);
                    }
                }
            }

            if ((l_PageSize = gt_SwapHeader.l_DmSize ^ BOOT_PAGE_MASK) > 0)
            {
                l_PageSrcAddr = l_SramOffset + gt_SwapHeader.l_DmSrcOffset;

                ReadXdmaBlock(l_PageSrcAddr, DESTINATION_BUF_ADDR, l_PageSize << 2);
                ReadXdmaBlock(l_PageSrcAddr, (int32)DESTINATION_BUF_ADDR + (l_PageSize << 2), l_PageSize << 2);

                la_InternalDestBuf = (int32 *)((int32)DESTINATION_BUF_ADDR + (l_PageSize << 2));

                for (l_Count = 0; l_Count < l_PageSize; l_Count++)
                {
                    if (la_DestBuf[l_Count] != la_InternalDestBuf[l_Count])
                    {
                        if (l_ErrorIndex2 < MAX_TEST_2_COUNT)
                        {
                            gta_BootPageError2[l_ErrorIndex2].pl_ErrorAtAddr1 = &la_DestBuf[l_Count];
                            gta_BootPageError2[l_ErrorIndex2].pl_ErrorAtAddr2 = &la_InternalDestBuf[l_Count];
                            l_ErrorIndex2++;
                        }
                        return(TRUE);
                    }
                }

            }
        }

        l_SwapHeaderOffset += sizeof(SwapPageHeader_t);
    }

    return(FALSE);
}

void LoadBootPages(int32 l_NumOfPorts)
{
    int32 l_SwapHeaderOffset, l_Page, l_PageSrcAddr, l_PageSize, l_SramOffset;
    int32 l_Port;


    l_SramOffset = gt_PortModeControl.l_SRAMImageOffset;


    for (l_Port = 0; l_Port <= l_NumOfPorts; l_Port++)
    {
        guc_ch_id = l_Port;

        // setting port environment
        if (l_Port == 0)
        {
            guc_xdma_reg_offset = 0;
        }
        else
        {
            guc_xdma_reg_offset = DSP_XDMA1_CTRL - DSP_XDMA0_CTRL;
        }

        // read XDSL image header
        ReadXdmaBlock(l_SramOffset, (int32)&gt_ImageHeader, sizeof(ImageHeader_t));
        l_SwapHeaderOffset = l_SramOffset + sizeof(ImageHeader_t);


        // bring in boot page for this modem
        for (l_Page = 0; l_Page < gt_ImageHeader.l_NumOfSwaps; l_Page++)
        {
            // the swap header
            ReadXdmaBlock(l_SwapHeaderOffset, (int32)&gt_SwapHeader,  sizeof(SwapPageHeader_t));

            // after toggle the MSB, the boot page size should be > 0
            if ((l_PageSize = gt_SwapHeader.l_PmSize ^ BOOT_PAGE_MASK) > 0)
            {
                l_PageSrcAddr = l_SramOffset + gt_SwapHeader.l_PmSrcOffset;

                ReadXdmaBlock(l_PageSrcAddr, gt_SwapHeader.l_PmDestAddr, l_PageSize << 2);
            }

            if ((l_PageSize = gt_SwapHeader.l_DmSize ^ BOOT_PAGE_MASK) > 0)
            {
                l_PageSrcAddr = l_SramOffset + gt_SwapHeader.l_DmSrcOffset;

                ReadXdmaBlock(l_PageSrcAddr, gt_SwapHeader.l_DmDestAddr, l_PageSize << 2);
            }

            l_SwapHeaderOffset += sizeof(SwapPageHeader_t);
        }


    }
}
