@echo off

REM ========================================
REM CONFIG
REM ========================================

set FIT_DIR=.\FlashImageTool\
set IBST_DIR=.\IbstTool\
set OUT_DIR=.\
set ROOT_KEY=%IBST_DIR%key_root_prv.pem
set CSK_KEY=%IBST_DIR%key_csk_prv.pem
set GBE=.\gbe.bin
set PDR=.\pdr.bin
set OEM_KEY=.\oemkeymn2.bin
set RCV_REGION=.\SpsRecovery.bin
set DER=.\DER.bin

rem OPTIONAL:


REM ========================================
REM END CONFIG
REM ========================================

set CUR_DIR=%~dp0
pushd %CUR_DIR%

IF "%1"=="" (
    echo Provide xml for UpdateCapsule generation
    GOTO ERROR
) else (
    set CFG_XML_PATH=%1
)

IF "%2"=="" (
    set BIOS_PATH=.\bios.ROM
    echo Default Bios used from: %BIOS_PATH%
) else (
    set BIOS_PATH=%2
    echo Bios used from: %2
)

IF "%CFG_XML_PATH%" == "" (
    set CFG_XML_PARAM=""
) ELSE (
    set CFG_XML_PARAM=-f %CFG_XML_PATH%
)

set PFM_PATH=%OUT_DIR%Int\PFM.bin
set PFM_SIGNED_PATH=%OUT_DIR%PFM_signed.bin
set CAPSULE_NAME=%CFG_XML_PATH:~0,-4%
set CAPSULE_PATH=%OUT_DIR%Int\UpdateCapsule.bin
set CAPSULE_SIGNED_PATH=%OUT_DIR%%CAPSULE_NAME%Capsule.bin

set IBST_EXE=c:\python36\python.exe %IBST_DIR%ibst.py %IBST_DIR%\PAC.xml --skip_valid -s root_key=%ROOT_KEY% csk_key=%CSK_KEY%

set FIT_EXE=%FIT_DIR%spsFITc.exe -b -pfr -rcv %RCV_REGION% -o %OUT_DIR%SPI_image.bin -bios %BIOS_PATH% %CFG_XML_PARAM% -gbe %GBE% -pdr %PDR% -der1 %DER% 

rem 1. Generate PFM
%FIT_EXE%
IF ERRORLEVEL 1 GOTO ERROR

rem 2. Sign PFM
%IBST_EXE% binary=%PFM_PATH% -o %PFM_SIGNED_PATH%  
IF ERRORLEVEL 1 GOTO ERROR

rem 3. Generate UpdateCapsule
%FIT_EXE% -pfm %PFM_SIGNED_PATH% 
IF ERRORLEVEL 1 GOTO ERROR

rem 4. Sign UpdateCapsule
%IBST_EXE% binary=%CAPSULE_PATH% pc_type=0x5 -o %CAPSULE_SIGNED_PATH%  
IF ERRORLEVEL 1 GOTO ERROR

GOTO BUILDDONE

:ERROR

ECHO.
ECHO ====================================================================
ECHO                           Error occurred!
ECHO ====================================================================
SET EXIT_CODE=1
GOTO END

:BUILDDONE

ECHO.
ECHO ====================================================================
ECHO           %CAPSULE_SIGNED_PATH% successfully generated
ECHO ====================================================================
SET EXIT_CODE=0

:END

popd
EXIT /b %EXIT_CODE%