## @file
# FmpDxe driver for uCode update.
#
#@copyright
#  INTEL CONFIDENTIAL
#  Copyright 2018 Intel Corporation.
#
#  The source code contained or described herein and all documents related to the
#  source code ("Material") are owned by Intel Corporation or its suppliers or
#  licensors. Title to the Material remains with Intel Corporation or its suppliers
#  and licensors. The Material may contain trade secrets and proprietary and
#  confidential information of Intel Corporation and its suppliers and licensors,
#  and is protected by worldwide copyright and trade secret laws and treaty
#  provisions. No part of the Material may be used, copied, reproduced, modified,
#  published, uploaded, posted, transmitted, distributed, or disclosed in any way
#  without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure or delivery
#  of the Materials, either expressly, by implication, inducement, estoppel or
#  otherwise. Any license under such intellectual property rights must be
#  express and approved by Intel in writing.
#
#  Unless otherwise agreed by Intel in writing, you may not remove or alter
#  this notice or any other notice embedded in Materials by Intel or
#  Intel's suppliers or licensors in any way.
#
#  This file contains a 'Sample Driver' and is licensed as such under the terms
#  of your license agreement with Intel or your vendor. This file may be modified
#  by the user, subject to the additional terms of the license agreement.
#
# @par Specification
##

  FmpDevicePkg/FmpDxe/FmpDxe.inf {
    <Defines>
      #
      # ESRT and FMP GUID for system firmware capsule update
      #
      FILE_GUID = $(FMP_CLIENT_PLATFORM_SYSTEM_UCODE)
    <PcdsFixedAtBuild>
      #
      # Unicode name string that is used to populate FMP Image Descriptor for this capsule update module
      #
      gFmpDevicePkgTokenSpaceGuid.PcdFmpDeviceImageIdName|L"TigerLake uCode Firmware Device"

      #
      # ESRT and FMP Lowest Support Version for this capsule update module
      # xxxx.xx (BIOS Major version, BIOS Minor version)
      gPlatformModuleTokenSpaceGuid.PcdSystemFirmwareFmpLowestSupportedVersion|0x000000

      gFmpDevicePkgTokenSpaceGuid.PcdFmpDeviceProgressWatchdogTimeInSeconds|0

      #
      # Capsule Update Progress Bar Color.  Set to red (RGB) (255, 0, 0)
      #
      gFmpDevicePkgTokenSpaceGuid.PcdFmpDeviceProgressColor|0x00FF0000

      #
      # Certificates used to authenticate capsule update image
      #
      #!include $(PLATFORM_PACKAGE)/Features/CapsuleUpdate/FmpCertificate.dsc
      gFmpDevicePkgTokenSpaceGuid.PcdFmpDevicePkcs7CertBufferXdr|{0x00, 0x00, 0x03, 0xf0, 0x30, 0x82, 0x03, 0xec, 0x30, 0x82, 0x02, 0xd4, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x09, 0x00, 0xc0, 0x91, 0xc5, 0xe2, 0xb7, 0x66, 0xc0, 0xf8, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x30, 0x81, 0x82, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x43, 0x4e, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x08, 0x0c, 0x02, 0x53, 0x48, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x07, 0x0c, 0x02, 0x53, 0x48, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x09, 0x54, 0x69, 0x61, 0x6e, 0x6f, 0x43, 0x6f, 0x72, 0x65, 0x31, 0x0e, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x05, 0x45, 0x44, 0x4b, 0x49, 0x49, 0x31, 0x11, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x08, 0x54, 0x65, 0x73, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x31, 0x22, 0x30, 0x20, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x09, 0x01, 0x16, 0x13, 0x65, 0x64, 0x6b, 0x69, 0x69, 0x40, 0x74, 0x69, 0x61, 0x6e, 0x6f, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x6f, 0x72, 0x67, 0x30, 0x1e, 0x17, 0x0d, 0x31, 0x37, 0x30, 0x34, 0x31, 0x30, 0x30, 0x38, 0x32, 0x37, 0x34, 0x30, 0x5a, 0x17, 0x0d, 0x31, 0x37, 0x30, 0x35, 0x31, 0x30, 0x30, 0x38, 0x32, 0x37, 0x34, 0x30, 0x5a, 0x30, 0x81, 0x82, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x43, 0x4e, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x08, 0x0c, 0x02, 0x53, 0x48, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x07, 0x0c, 0x02, 0x53, 0x48, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x09, 0x54, 0x69, 0x61, 0x6e, 0x6f, 0x43, 0x6f, 0x72, 0x65, 0x31, 0x0e, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x05, 0x45, 0x44, 0x4b, 0x49, 0x49, 0x31, 0x11, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x08, 0x54, 0x65, 0x73, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x31, 0x22, 0x30, 0x20, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x09, 0x01, 0x16, 0x13, 0x65, 0x64, 0x6b, 0x69, 0x69, 0x40, 0x74, 0x69, 0x61, 0x6e, 0x6f, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x6f, 0x72, 0x67, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0xb9, 0x29, 0x29, 0x6c, 0x60, 0x0c, 0xd7, 0x23, 0xf6, 0x7d, 0xee, 0xf0, 0x62, 0xff, 0xd9, 0xc9, 0xaa, 0x55, 0x8c, 0x81, 0x95, 0x56, 0x3f, 0xb7, 0x56, 0x53, 0xb0, 0xc2, 0x82, 0x12, 0xc5, 0x3b, 0x75, 0x23, 0xb9, 0x4d, 0xd6, 0xc4, 0x55, 0x73, 0xf3, 0xaa, 0x95, 0xa8, 0x1b, 0xf3, 0x93, 0x7e, 0x9e, 0x40, 0xe4, 0x1d, 0x22, 0x9c, 0x93, 0x07, 0x0b, 0xd7, 0xaa, 0x5b, 0xd7, 0xe4, 0x1a, 0x21, 0x84, 0xd7, 0x63, 0x59, 0x03, 0x50, 0x1f, 0xf5, 0x14, 0x55, 0x93, 0x91, 0x9b, 0xf5, 0x52, 0xb0, 0xbf, 0x0e, 0x5c, 0x68, 0x3b, 0x59, 0x52, 0x98, 0x96, 0x56, 0xe1, 0xab, 0xc4, 0x43, 0xbb, 0x05, 0x57, 0x78, 0x45, 0x01, 0x9f, 0x58, 0x15, 0x53, 0x0e, 0x11, 0x94, 0x2f, 0x0e, 0xf1, 0xa6, 0x19, 0xa2, 0x6e, 0x86, 0x39, 0x2b, 0x33, 0x8d, 0xc7, 0xc5, 0xeb, 0xee, 0x1e, 0x33, 0xd3, 0x32, 0x94, 0xc1, 0x59, 0xc4, 0x0c, 0x97, 0x0b, 0x12, 0x48, 0x5f, 0x33, 0xf6, 0x60, 0x74, 0x7d, 0x57, 0xc2, 0x13, 0x2d, 0x7d, 0xa9, 0x87, 0xa3, 0x35, 0xea, 0x91, 0x83, 0x3f, 0x67, 0x7a, 0x92, 0x1f, 0x01, 0x53, 0x9f, 0x62, 0x5f, 0x99, 0x12, 0xfd, 0x73, 0x1b, 0x2d, 0x9e, 0x2b, 0x6c, 0x34, 0x49, 0xaf, 0x4f, 0x07, 0x8f, 0xc0, 0xe9, 0x6b, 0x9e, 0x5f, 0x79, 0x35, 0xda, 0x2a, 0x5c, 0x88, 0xee, 0xf6, 0x48, 0x61, 0xda, 0x96, 0xe3, 0x48, 0x46, 0xa0, 0x94, 0x1c, 0x9d, 0xf6, 0x5c, 0x87, 0x0e, 0xef, 0x74, 0x09, 0x91, 0x0d, 0x3d, 0x5a, 0xe7, 0xc5, 0x4c, 0x8a, 0x7a, 0xac, 0xa1, 0x85, 0xb6, 0x67, 0x44, 0x17, 0x55, 0x52, 0x3a, 0xe8, 0x11, 0x4d, 0x58, 0xa2, 0x93, 0x00, 0x62, 0xea, 0x7b, 0x80, 0xed, 0xcf, 0xbd, 0xdf, 0x75, 0x80, 0x4b, 0xb9, 0x65, 0x63, 0xad, 0x0b, 0x4d, 0x74, 0xfa, 0x59, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x63, 0x30, 0x61, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x16, 0xaa, 0xd6, 0x8e, 0x1b, 0x2d, 0x43, 0xf3, 0x2d, 0xb0, 0x24, 0xad, 0x36, 0x65, 0x3f, 0xb2, 0xfa, 0xb1, 0x2c, 0xed, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x16, 0xaa, 0xd6, 0x8e, 0x1b, 0x2d, 0x43, 0xf3, 0x2d, 0xb0, 0x24, 0xad, 0x36, 0x65, 0x3f, 0xb2, 0xfa, 0xb1, 0x2c, 0xed, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x01, 0x86, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x95, 0xde, 0xdf, 0xa4, 0x14, 0xdb, 0x92, 0x22, 0x78, 0x1a, 0xbd, 0x31, 0x9d, 0x1e, 0xd7, 0x2f, 0x0a, 0x10, 0x11, 0x5d, 0x74, 0x61, 0xe8, 0x30, 0xc4, 0xf3, 0x15, 0xe9, 0x30, 0x54, 0xf4, 0xbb, 0x0c, 0x04, 0x78, 0x13, 0x5d, 0x2c, 0xdd, 0x8c, 0x92, 0x90, 0xd1, 0x9c, 0xd0, 0xd0, 0x18, 0xa3, 0xa3, 0xfc, 0x8c, 0x28, 0x5a, 0xd4, 0x91, 0x4d, 0x08, 0xc3, 0xf6, 0x1a, 0xc8, 0xdd, 0xa6, 0x08, 0x58, 0xe2, 0x15, 0x95, 0xfb, 0x2d, 0x2d, 0x8a, 0xb1, 0x30, 0x80, 0xbd, 0x9a, 0xb6, 0xe1, 0x2c, 0x20, 0x3e, 0xdd, 0xc4, 0xc7, 0x55, 0x65, 0xcf, 0x28, 0x17, 0xf4, 0xee, 0xda, 0xbe, 0x77, 0x70, 0xd5, 0x52, 0xd6, 0x15, 0x7a, 0xfb, 0xad, 0xaf, 0xfd, 0xd5, 0x45, 0x90, 0x5a, 0xe6, 0x31, 0x42, 0xd7, 0x84, 0xb3, 0x49, 0x56, 0x6a, 0xd3, 0x47, 0xf3, 0xbf, 0x68, 0x60, 0x8b, 0x0f, 0xe2, 0xaf, 0xf4, 0xe3, 0xec, 0x12, 0xb9, 0xe2, 0x3a, 0x16, 0x11, 0x4e, 0x4d, 0x73, 0x79, 0xaf, 0x47, 0x85, 0x4c, 0x76, 0x26, 0x9e, 0x8b, 0x32, 0xc0, 0x8e, 0xc2, 0xdc, 0x27, 0xa6, 0xef, 0xac, 0x93, 0x9e, 0xa1, 0x5e, 0xcf, 0x34, 0x45, 0xe0, 0x2a, 0xc7, 0x9d, 0x4d, 0xd7, 0xd7, 0x37, 0x72, 0x97, 0xf8, 0x58, 0xf9, 0xb6, 0x35, 0x48, 0xf1, 0xd1, 0x0a, 0x72, 0x7f, 0xfd, 0x4d, 0x7c, 0xe9, 0xcc, 0xd8, 0x48, 0x1b, 0x49, 0x52, 0x53, 0xde, 0x51, 0x01, 0x53, 0x35, 0xbc, 0x90, 0xcd, 0x8c, 0x8a, 0xcc, 0x43, 0x20, 0xa7, 0x45, 0xff, 0x2b, 0x55, 0xb0, 0x8b, 0x2d, 0xff, 0x55, 0x15, 0x4b, 0x84, 0xd0, 0xc3, 0xd3, 0x90, 0x9c, 0x94, 0x4b, 0x55, 0xd5, 0x62, 0xea, 0x22, 0xab, 0x62, 0x68, 0xdd, 0x53, 0xc6, 0xdc, 0xa5, 0xdd, 0x9a, 0x2d, 0x8e, 0x79, 0x7c, 0x2e, 0x9c, 0xe4, 0x66, 0x80, 0x8c, 0x1d}


    <LibraryClasses>
      #
      # Generic libraries that are used "as is" by all FMP modules
      #
      FmpPayloadHeaderLib|FmpDevicePkg/Library/FmpPayloadHeaderLibV1/FmpPayloadHeaderLibV1.inf
      FmpAuthenticationLib|SecurityPkg/Library/FmpAuthenticationLibPkcs7/FmpAuthenticationLibPkcs7.inf
      #
      # Platform specific capsule policy library
      #
      CapsuleUpdatePolicyLib|$(PLATFORM_FULL_PACKAGE)/Features/CapsuleUpdate/Library/CapsuleUpdatePolicyLib/CapsuleUpdatePolicyLib.inf
      #
      # Platform specific library that processes a capsule and updates the FW storage device
      #
      FmpDeviceLib|$(PLATFORM_FULL_PACKAGE)/Features/CapsuleUpdate/Library/FmpDeviceLibuCode/FmpDeviceLibuCode.inf
      MicroCodeUpdateHelpersLib|$(PLATFORM_FULL_PACKAGE)/Features/CapsuleUpdate/Library/MicroCodeUpdateHelpersLib/MicroCodeUpdateHelpersLib.inf
      IniParsingLib|$(PLATFORM_FEATURES_PATH)/CapsuleUpdate/Library/IniParsingLib/IniParsingLib.inf

    <BuildOptions>
      DEBUG_*_X64_CC_FLAGS = /Od /GL-

  }
