/** @file
  Declares the interface for TbtNvmDrvRetimerThruHr class.
  This class is in charge of providing the way to access the retimer through TBT integrated HR.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:

**/

#ifndef TBT_NVM_DRV_RETIMER_THRU_HR_
#define TBT_NVM_DRV_RETIMER_THRU_HR_

#include "TcI2cmDrvUtils.h"
#include "TcI2cmDrvDevice.h"
#include "TcI2cmDrvHr.h"

typedef enum {
  PORT_PA,
  PORT_PB
} DN_PORT;

typedef enum {
  FIRST_RETIMER   = 1,
  SECOND_RETIMER = 2,
  THIRD_RETIMER = 3,
  FORTH_RETIMER = 4
} RETIMER_INDEX;

/**
  Waits for completion of IECS command by polling the IECS CMD remote register.

  @param[in]  DevCom  Pointer to the device interface.
  @param[in]  Cmd     IECS CMD which was send.

  @retval  TBT_STATUS_SUCCESS                Command was successefully send.
  @retval  TBT_STATUS_NON_RECOVERABLE_ERROR  A device error has accured.
  @retval  TBT_STATUS_RETRY                  LC reported error, the command might be retried.
**/
STATIC
TBT_STATUS
TbtNvmDrvWaitForIecsCmdCpl (
  IN TARGET_DEVICE *DevCom,
  UINT32           Cmd
  );

/**
  Sends IECS command and waits for completion.

  @param[in]  DevCom  Pointer to the device interface.
  @param[in]  Cmd     IECS CMD to send.

  @retval  TBT_STATUS_SUCCESS                Command was successefully send.
  @retval  TBT_STATUS_NON_RECOVERABLE_ERROR  A device error has accured.
  @retval  TBT_STATUS_RETRY                  LC reported error, the command might be retried.
**/
TBT_STATUS
TbtNvmDrvSendCmd (
  IN TARGET_DEVICE *DevCom,
  UINT32           Cmd
  );

/**
  Constructs the Retimer thru HR module.
  Initializes all the internal data structures and initialize the required HW.

  @param[in]  PcieBdf       The BDF of the HR connected to the target retimer.
  @param[in]  DnFacingPort  The downstream port, connected to the target retimer.
  @param[in]  RetimerIndex  The index of the retimer in the path from HR to the target retimer.
  @param[in]  ForcePwrFunc  HR Force power function, applied if supplied.

  @retval  A pointer to the device interface.
**/
TARGET_DEVICE*
TbtNvmDrvRetimerThruHrCtor (
  IN PCIE_BDF       PcieBdf,
  IN DN_PORT        DnFacingPort,
  IN RETIMER_INDEX  RetimerIndex,
  IN FORCE_PWR_HR   ForcePwrFunc OPTIONAL
  );

#endif /* TBT_NVM_DRV_RETIMER_THRU_HR_ */
