import sys
import os
import fileinput
import array
import struct
import ConfigParser

#
#
# Data structures used in Retimer image payload
#
# #define RETIMER_PAYLOAD_HEADER_SIGNATURE SIGNATURE_32 ('R', 'T', 'M', 'R')

# #pragma pack(1)
# typedef struct {
#   UINT32  Signature;
#   UINT32  HeaderSize;
#   UINT32  RetimerCount;
#   UINT32  Reserved;
#   ///
#   /// Variable length array of dimension [EmbeddedDriverCount + PayloadItemCount]
#   /// containing offsets of each of the drivers and payload items contained within the capsule
#   ///
#   // RETIMER_ITEM RetimerItem[];
# } RETIMER_PAYLOAD_HEADER;
#
# typedef struct {
#   RETIMER_DEV_ADDRESS      RetimerDevAddress;
#   UINT32                   ImageOffest;
#   UINT32                   ImageSize;
#   UINT8                    Reserve[8];
# } RETIMER_ITEM;
#
# typedef struct {
#   //
#   // For TBT platform
#   //
#   struct {
#     UINT16  Bus;
#     UINT16  Device;
#     UINT16  Function;
#     UINT8   Port;
#     UINT8   RetimerIndex;
#   } PciInfo;
#   //
#   // For non-TBT platform
#   //
#   UINT64 SmbusAddress; // Unsupported for now.
# } RETIMER_DEV_ADDRESS;
#
#pragma pack()
#
def _SIGNATURE_32 (A, B, C, D):
    return struct.unpack ('=I',bytearray (A + B + C + D, 'ascii'))[0]

HeaderSignature = _SIGNATURE_32 ('R', 'T', 'M', 'R')
HeaderStruct    = '<IIII'
ItemStruct      = '<HHHBBQII8s'

def gen_retimer_header_from_ini (inifile):

  IniDir = os.path.dirname(inifile)
  config = ConfigParser.ConfigParser()
  config.read(inifile)
  UpdateNum = len(config.sections())
  print "UpdateNum is %d" % UpdateNum

  if (UpdateNum == 0):
    print "No sections found"
    sys.exit (1)

  if (UpdateNum > 1):
    print "Only supports single Retimer FW update as of now"
    sys.exit (1)

  HeaderSize = struct.calcsize (HeaderStruct) + (UpdateNum * struct.calcsize (ItemStruct))
  ImageOffset = HeaderSize
  ItemHeaderBuffer = b''
  RetimerFwBuffer = b''

  for Section in config.sections():
    BusNum = config.getint(Section, 'BusNumber')
    DevNum = config.getint(Section, 'DevNumber')
    FunNum = config.getint(Section, 'FunNumber')
    Addr   = config.getint(Section, 'I2CAddr')
    Index  = config.getint(Section, 'RetimerIndex')
    File   = config.get(Section, 'FileName')

    RetimerFwFile = os.path.join(IniDir,File)
    try:
      fin = open(RetimerFwFile, "rb")
      ImageSize = os.path.getsize(RetimerFwFile)
      # Read file to buffer
      RetimerFw = fin.read()
      fin.close()

    except:
      print "Failed to open %s" % RetimerFwFile
      sys.exit (1)

    RetimerItemHeader = struct.pack (ItemStruct, BusNum, DevNum, FunNum, Addr, Index, 0, ImageOffset, ImageSize, '')
    ImageOffset = ImageOffset + ImageSize
    ItemHeaderBuffer = ItemHeaderBuffer + RetimerItemHeader
    RetimerFwBuffer = RetimerFwBuffer + RetimerFw

  RetimerPayloadHeader = struct.pack (HeaderStruct, HeaderSignature, HeaderSize, UpdateNum, 0)
  Result = RetimerPayloadHeader + ItemHeaderBuffer + RetimerFwBuffer

  # Write output
  fout = open(os.path.join(IniDir,"RetimerPayload.bin"), "wb")
  fout.write(Result)
  fout.close()

  return 0

###################################################################################################
# Main
###################################################################################################

def main():
  if len(sys.argv) != 2:
    print "incorrent number of arguments"
    return 1

  ret = gen_retimer_header_from_ini(sys.argv[1])

  if ret != 0:
    return 1
  return 0

if __name__ == '__main__':
    sys.exit(main())
