/** @file
  RST One Click switching support

@copyright
  INTEL CONFIDENTIAL
  Copyright 2018 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef __RST_ONE_CLICK_ENABLE__
#define __RST_ONE_CLICK_ENABLE__

#include <Uefi.h>
#include <Uefi/UefiMultiPhase.h>
#include <Pi/PiMultiPhase.h>

#include <SetupVariable.h>
#include <PchPcieStorageDetectHob.h>

#include <Library/UefiDriverEntryPoint.h>
#include <Library/UefiLib.h>
#include <Library/DebugLib.h>
#include <Library/MemoryAllocationLib.h>
#include <Library/BaseMemoryLib.h>
#include <Library/IoLib.h>
#include <Library/PchInfoLib.h>
#include <Library/SataLib.h>
#include <Library/PciSegmentLib.h>
#include <Library/HobLib.h>
#include <Library/PchPcieRpLib.h>

#include <PcieRegs.h>

#include "RstConfigVariable.h"

typedef enum {
  None = 0,
  RaidSwitch,
  RemapEnable
} UPDATE_OPERATION;

GLOBAL_REMOVE_IF_UNREFERENCED EFI_RUNTIME_SERVICES *gRS;

extern EFI_GUID  gPchSetupVariableGuid;
extern EFI_GUID  gSetupVariableGuid;

/**
  Updates system configuration based on RST_CONFIG_VARIABLE recieved from OS

  @param RstConfigVariable  A pointer to an instance of RST_CONFIG_VARIABLE received from OS

  @retval EFI_STATUS  Returns EFI_SUCCESS only if update wasn't necessary, otherwise returns last error
**/
EFI_STATUS
UpdateSystemConfiguration (
  IN UPDATE_OPERATION  UpdateOperation
  );

/**
  Updates PchSetup variable based on information passed in RST_CONFIG_VARIABLE

  @retval EFI_STATUS  Returns EFI_SUCCESS if PchSetup was updated successfully, returns last error otherwise
**/
EFI_STATUS
UpdatePchSetupVariable (
  IN UPDATE_OPERATION  UpdateOperation
  );

/**
  Checks if the integrated SATA controller is in RAID mode

  @retval BOOLEAN  True if SATA controller is in RAID mode
**/
BOOLEAN
IsIntegratedSataControllerInRaidMode (
  VOID
  );

/**
  Switches SATA controller to RAID mode

  @param PchSetup  A pointer to PCH_SETUP instance
**/
VOID
SwitchSataControllerToRaid (
  OUT PCH_SETUP*  PchSetup
  );

/**
  Checks if given root port is remap capable based on information in SETUP_VOLATILE_DATA

  @param  SetupData  A pointer to an instance of SETUP_VOLATILE_DATA
  @param  RpNumber  Root port number to check

  @retval  BOOLEAN  Returns TRUE if root port is remap capable, returns false otherwise
**/
BOOLEAN
CheckIfRootPortIsRemapCapable (
  PCIE_STORAGE_INFO_HOB *PcieStorageInfoHob,
  UINT32  RpNumber
  );

/**
  Checks if system configuration needs update

  @param  RstConfigVariable  An instance of RST_CONFIG_VARIABLE passed from OS

  @retval  BOOLEAN  TRUE if system needs to be updated FALSE otherwise
**/
UPDATE_OPERATION
GetRequiredUpdateOperation (
  IN RST_CONFIG_VARIABLE  RstConfigVariable
  );

/**
  Enables NVMe remapping on all remap capable root ports

  @param PchSetup  An instance of PchSetup to be updated

  @retval EFI_STATUS  Returns EFI_SUCCESS if remapping has been successfully enabled, returns last error otherwise
**/
VOID
EnableRemapOnAllCapableRp (
  OUT PCH_SETUP  *PchSetup
  );

/**
  Creates an instance of RST_CONFIG_VARIABLE.
  Since this function initializes variable to 0 it can also be used to reseting the variable

  @retval EFI_STATUS  Returns status of SetVariable runtime service
**/
EFI_STATUS
CreateRstConfigVariable (
  VOID
  );

#endif
