/** @file
  Acpi Gnvs Init Library.

@copyright
  INTEL CONFIDENTIAL
  Copyright 1999 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#include <Uefi.h>
#include <Library/IoLib.h>
#include <Library/DebugLib.h>
#include <Library/BaseMemoryLib.h>
#include <Library/UefiBootServicesTableLib.h>

#include <Protocol/PlatformNvsArea.h>
#include <Library/DxeAcpiGnvsInitLib.h>

/**
@brief
  Global NVS initialize.

  @param[in] PlatformNvsAreaPtr    - Pointer of global NVS area

  @retval EFI_SUCCESS              - Allocate Global NVS completed.
  @retval EFI_OUT_OF_RESOURCES     - Failed to allocate required page for PlatformNvsAreaProtocol.
**/
EFI_STATUS
EFIAPI
AcpiGnvsInit (
  IN OUT VOID               **PlatformNvsAreaPtr
  )
{
  UINTN                         Pages;
  EFI_PHYSICAL_ADDRESS          Address;
  EFI_STATUS                    Status;
  PLATFORM_NVS_AREA_PROTOCOL    *PlatformNvsAreaProtocol;

  Pages = EFI_SIZE_TO_PAGES (sizeof (PLATFORM_NVS_AREA));
  Address = 0xffffffff; // allocate address below 4G.

  Status  = gBS->AllocatePages (
                   AllocateMaxAddress,
                   EfiACPIMemoryNVS,
                   Pages,
                   &Address
                   );
  ASSERT_EFI_ERROR (Status);
  if (EFI_ERROR(Status)) {
    return Status;
  }

  *PlatformNvsAreaPtr = (VOID *) (UINTN) Address;
  SetMem (*PlatformNvsAreaPtr, sizeof (PLATFORM_NVS_AREA), 0);

  //
  // PlatformNvsAreaProtocol default value init here...
  //
  PlatformNvsAreaProtocol = (PLATFORM_NVS_AREA_PROTOCOL *) &Address;

  //
  // Thermal trip points
  //
  PlatformNvsAreaProtocol->Area->Ac0TripPoint                = 71;
  PlatformNvsAreaProtocol->Area->Ac1TripPoint                = 55;
  PlatformNvsAreaProtocol->Area->Ac0FanSpeed                 = 100;
  PlatformNvsAreaProtocol->Area->Ac1FanSpeed                 = 75;
  PlatformNvsAreaProtocol->Area->PassiveThermalTripPoint     = 95;
  PlatformNvsAreaProtocol->Area->PassiveTc1Value             = 1;
  PlatformNvsAreaProtocol->Area->PassiveTc2Value             = 5;
  PlatformNvsAreaProtocol->Area->PassiveTspValue             = 10;
  PlatformNvsAreaProtocol->Area->CriticalThermalTripPoint    = 119;

  //
  // Intel(R) Dynamic Tuning Technology Devices and trip points
  //
  PlatformNvsAreaProtocol->Area->EnableDptf                   = 1;
  PlatformNvsAreaProtocol->Area->EnableSaDevice               = 1;
  PlatformNvsAreaProtocol->Area->PpccStepSize                 = 500;

  PlatformNvsAreaProtocol->Area->EnableChargerParticipant     = 1;

  PlatformNvsAreaProtocol->Area->EnableBatteryParticipant    = 1;
  PlatformNvsAreaProtocol->Area->EnableInt3400Device         = 1;

  PlatformNvsAreaProtocol->Area->EnableSen1Participant        = 1;

  PlatformNvsAreaProtocol->Area->EnableSen2Participant        = 1;

  PlatformNvsAreaProtocol->Area->EnableSen3Participant        = 1;

  PlatformNvsAreaProtocol->Area->EnableSen4Participant        = 1;

  PlatformNvsAreaProtocol->Area->EnableSen5Participant        = 1;

  PlatformNvsAreaProtocol->Area->EnablePowerParticipant       = 1;

  PlatformNvsAreaProtocol->Area->EnablePchFivrParticipant = 1;

  PlatformNvsAreaProtocol->Area->OemDesignVariable0           = 0;
  PlatformNvsAreaProtocol->Area->OemDesignVariable1           = 0;
  PlatformNvsAreaProtocol->Area->OemDesignVariable2           = 0;
  PlatformNvsAreaProtocol->Area->OemDesignVariable3           = 0;
  PlatformNvsAreaProtocol->Area->OemDesignVariable4           = 0;
  PlatformNvsAreaProtocol->Area->OemDesignVariable5           = 0;
  //
  // Wireless
  //
  PlatformNvsAreaProtocol->Area->PowerSharingManagerEnable    = 1;
  PlatformNvsAreaProtocol->Area->PsmSplcDomainType1           = 0x09;
  PlatformNvsAreaProtocol->Area->PsmSplcPowerLimit1           = 4000;
  PlatformNvsAreaProtocol->Area->PsmSplcTimeWindow1           = 30000;

  PlatformNvsAreaProtocol->Area->PsmDplcDomainType1           = 9;
  PlatformNvsAreaProtocol->Area->PsmDplcDomainPreference1     = 9;
  PlatformNvsAreaProtocol->Area->PsmDplcPowerLimitIndex1      = 0;
  PlatformNvsAreaProtocol->Area->PsmDplcDefaultPowerLimit1    = 1200;
  PlatformNvsAreaProtocol->Area->PsmDplcDefaultTimeWindow1    = 30000;
  PlatformNvsAreaProtocol->Area->PsmDplcMinimumPowerLimit1    = 1200;
  PlatformNvsAreaProtocol->Area->PsmDplcMaximumPowerLimit1    = 1200;
  PlatformNvsAreaProtocol->Area->PsmDplcMaximumTimeWindow1    = 1000;

  PlatformNvsAreaProtocol->Area->WifiEnable                   = 1;
  PlatformNvsAreaProtocol->Area->WifiDomainType1              = 0x7;
  PlatformNvsAreaProtocol->Area->WifiPowerLimit1              = 0xFFFF;
  PlatformNvsAreaProtocol->Area->WifiTimeWindow1              = 30000;
  PlatformNvsAreaProtocol->Area->TRxDelay0                    = 50;
  PlatformNvsAreaProtocol->Area->TRxCableLength0              = 50;
  PlatformNvsAreaProtocol->Area->TRxDelay1                    = 50;
  PlatformNvsAreaProtocol->Area->TRxCableLength1              = 50;
  PlatformNvsAreaProtocol->Area->WrddDomainType1              = 0x7;
  PlatformNvsAreaProtocol->Area->WrddCountryIndentifier1      = 0x4150; // "AP"
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarEnable            = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit1         = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit2         = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit3         = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit4         = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit5         = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit6         = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit7         = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit8         = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit9         = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit10        = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit11        = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit12        = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit13        = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit14        = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit15        = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit16        = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit17        = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit18        = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit19        = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit20        = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit21        = 0x0;
  PlatformNvsAreaProtocol->Area->WrdsWiFiSarTxPowerSet1Limit22        = 0x0;

  PlatformNvsAreaProtocol->Area->AntennaDiversity                     = 0x2;

  PlatformNvsAreaProtocol->Area->EwrdWiFiDynamicSarEnable             = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiDynamicSarRangeSets          = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit1         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit2         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit3         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit4         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit5         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit6         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit7         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit8         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit9         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit10        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit11        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit12        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit13        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit14        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit15        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit16        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit17        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit18        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit19        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit20        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit21        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet2Limit22        = 0x0;

  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit1         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit2         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit3         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit4         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit5         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit6         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit7         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit8         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit9         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit10        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit11        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit12        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit13        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit14        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit15        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit16        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit17        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit18        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit19        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit20        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit21        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet3Limit22        = 0x0;

  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit1         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit2         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit3         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit4         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit5         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit6         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit7         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit8         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit9         = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit10        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit11        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit12        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit13        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit14        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit15        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit16        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit17        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit18        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit19        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit20        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit21        = 0x0;
  PlatformNvsAreaProtocol->Area->EwrdWiFiSarTxPowerSet4Limit22        = 0x0;

  PlatformNvsAreaProtocol->Area->WiFiDynamicSarAntennaACurrentSet = 0x0;
  PlatformNvsAreaProtocol->Area->WiFiDynamicSarAntennaBCurrentSet = 0x0;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup1PowerMax1      = 0xFF;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup1PowerChainA1   = 0x0;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup1PowerChainB1   = 0x0;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup1PowerMax2      = 0xFF;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup1PowerChainA2   = 0x0;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup1PowerChainB2   = 0x0;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup1PowerMax3      = 0XFF;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup1PowerChainA3   = 0x00;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup1PowerChainB3   = 0x00;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup2PowerMax1      = 0xFF;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup2PowerChainA1   = 0x0;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup2PowerChainB1   = 0x0;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup2PowerMax2      = 0xFF;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup2PowerChainA2   = 0x0;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup2PowerChainB2   = 0x0;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup2PowerMax3      = 0XFF;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup2PowerChainA3   = 0x00;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup2PowerChainB3   = 0x00;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup3PowerMax1      = 0xFF;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup3PowerChainA1   = 0x0;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup3PowerChainB1   = 0x0;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup3PowerMax2      = 0xFF;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup3PowerChainA2   = 0x0;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup3PowerChainB2   = 0x0;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup3PowerMax3      = 0XFF;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup3PowerChainA3   = 0x00;
  PlatformNvsAreaProtocol->Area->WgdsWiFiSarDeltaGroup3PowerChainB3   = 0x00;

  PlatformNvsAreaProtocol->Area->WifiAntGainEnale                     = 0x0;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainA1                   = 0x18;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainA2                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainA3                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainA4                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainA5                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainA6                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainA7                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainA8                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainA9                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainA10                  = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainA11                  = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainB1                   = 0x18;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainB2                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainB3                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainB4                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainB5                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainB6                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainB7                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainB8                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainB9                   = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainB10                  = 0x28;
  PlatformNvsAreaProtocol->Area->WifiAntGainChainB11                  = 0x28;

  PlatformNvsAreaProtocol->Area->WifiActiveChannelSrd                 = 0x00;
  PlatformNvsAreaProtocol->Area->WifiIndonesia5GhzSupport             = 0x00;
  PlatformNvsAreaProtocol->Area->WifiUltraHighBandSupport             = 0x00;

  PlatformNvsAreaProtocol->Area->BluetoothSar                 = 0x0;
  PlatformNvsAreaProtocol->Area->BluetoothSarBr               = 0x0;
  PlatformNvsAreaProtocol->Area->BluetoothSarEdr2             = 0x0;
  PlatformNvsAreaProtocol->Area->BluetoothSarEdr3             = 0x0;
  PlatformNvsAreaProtocol->Area->BluetoothSarLe               = 0x0;
  PlatformNvsAreaProtocol->Area->BluetoothSarLe2Mhz           = 0x0;
  PlatformNvsAreaProtocol->Area->BluetoothSarLeLr             = 0x0;
  PlatformNvsAreaProtocol->Area->CoExistenceManager           = 0x0;
  PlatformNvsAreaProtocol->Area->CnvExtClock                  = 0x0;
  //
  // Miscellaneous
  //
  PlatformNvsAreaProtocol->Area->ConfigTdpBios = 0;
  PlatformNvsAreaProtocol->Area->PL1LimitCS = 0;
  PlatformNvsAreaProtocol->Area->PL1LimitCSValue = 4500;
  return EFI_SUCCESS;
}

