/** @file
 Intel PEI TBT Policy update by board configuration

@copyright
  INTEL CONFIDENTIAL
  Copyright 2017 - 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/
#include "PeiPolicyBoardConfig.h"
#include <PlatformBoardId.h>
#include <Acpi/AcpiTables/Fadt/Fadt6.1.h>
#include <Library/PmcLib.h>


/**
  This function performs PEI TBT Policy update by board configuration.

  @retval EFI_SUCCESS             The SI Policy is successfully updated.
  @retval Others                  The SI Policy is not successfully updated.
**/
EFI_STATUS
EFIAPI
UpdatePeiTbtPolicyBoardConfig (
  VOID
  )
{
  EFI_STATUS                         Status;
  UINT16                             BoardId;

  DEBUG ((DEBUG_INFO, "Updating TBT Policy by board config in Post-Mem\n"));

  Status = EFI_SUCCESS;
  BoardId = PcdGet16(PcdBoardId);

  switch (BoardId) {
    default:
      DEBUG ((DEBUG_INFO, "UpdatePeiTbtConfigBoardConfig - Unhandled BoardId 0x%04X\n", BoardId));
      break;
  }

  return Status;
}
