/** @file
  Header file for Reference code Firmware Version Telemetry Info implementation.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2018-2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _SI_FVI_H_
#define _SI_FVI_H_

///
/// Non-static SMBIOS table data to be filled later with a dynamically generated value
///
#define TO_BE_FILLED  0

#define FVI_NUMBER_OF_STRINGS  2
#define PCH_RECORD_COUNT 11
#define SA_RECORD_COUNT 7
#define CPU_RECORD_COUNT 3
#define ME_RECORD_COUNT 3

#pragma pack(1)



#define DEFAULT_FVI_TELEMETRY_VERSION       0X000000FFFFFFFFFF
#define FVI_PCH_ICL_LP_AX_HSIO_TEST_VERSION 0X0000000600000000
#define FVI_PCH_ICL_LP_BX_HSIO_TEST_VERSION 0X0000000800000000
#define FVI_PCH_ICL_LP_CX_HSIO_TEST_VERSION 0X0000000200000000
#define FVI_PCH_ICL_LP_DX_HSIO_TEST_VERSION 0X0000000100000000
#define FVI_PCH_ICL_N_AX_HSIO_TEST_VERSION  0X0000000500000000
#define FVI_PCH_ICL_N_BX_HSIO_TEST_VERSION  0X0000000100000000

#pragma pack()


///
/// CPU Data definitions
///
#define CPU_FVI_UNICODE_STRING              L"Reference Code - CPU"
#define UCODE_FVI_UNICODE_STRING            L"uCode Version"
#define TXT_FVI_UNICODE_STRING              L"TXT ACM version"


typedef enum {
  Cpu_Rc_Ver= 0,
  Ucode_Ver,
  Txt_Ver
} CPU_FVI_INDEX;

#define ME_FVI_UNICODE_STRING               L"Reference Code - ME"
#define MEBX_FVI_UNICODE_STRING             L"MEBx version"
#define ME_FW_FVI_UNICODE_STRING            L"ME Firmware Version"

typedef enum {
  EnumMeRc = 0,
  EnumMebx,
  EnumMeFw
} ME_FVI_INDEX;

///
/// PCH Unicode Data definitions
///
#define PCH_FVI_UNICODE_STRING               L"Reference Code - ICL PCH"
#define PCH_CRID_UNICODE_STATUS_STRING       L"PCH-CRID Status"
#define PCH_CRID_UNICODE_ORIGINAL_VALUE      L"PCH-CRID Original Value"
#define PCH_CRID_UNICODE_NEW_VALUE           L"PCH-CRID New Value"
#define ICL_PCH_LP_AX_HSIO_UNICODE_STRING    L"ICL PCH LP Ax Hsio Version"
#define ICL_PCH_LP_BX_HSIO_UNICODE_STRING    L"ICL PCH LP Bx Hsio Version"
#define ICL_PCH_LP_CX_HSIO_UNICODE_STRING    L"ICL PCH LP Cx Hsio Version"
#define ICL_PCH_LP_DX_HSIO_UNICODE_STRING    L"ICL PCH LP Dx Hsio Version"
#define ICL_PCH_N_AX_HSIO_UNICODE_STRING     L"ICL PCH N Ax Hsio Version"
#define ICL_PCH_N_BX_HSIO_UNICODE_STRING     L"ICL PCH N Bx Hsio Version"
#define RAID_FVI_UNICODE_STRING              L"OPROM - RST - RAID"
#define RST_DRIVER_NAME1            L"Intel RST"
#define RST_DRIVER_NAME2            L"Intel(R) RST"

typedef enum {
  Rc_Ver        = 0,
  Pch_Crid_Status,
  Pch_Crid_Original,
  Pch_Crid_New,
  Raid_Ver,
  Hsio_Cnlpchlpax_Ver,
  Hsio_CnlpchlpBx_Ver,
  Hsio_Cnlpchlpcx_Ver,
  Hsio_Cnlpchlpdx_Ver,
  Hsio_Cnlpchnax_Ver,
  Hsio_Cnlpchnbx_Ver
} PCH_FVI_INDEX;

///
/// SA Unicode Data definitions
///
#define SA_FVI_UNICODE_STRING               L"Reference Code - SA - System Agent"
#define MEM_FVI_UNICODE_STRING              L"Reference Code - MRC"
#define PCIE_FVI_UNICODE_STRING             L"SA - PCIe Version"
#define SA_CRID_UNICODE_STATUS              L"SA-CRID Status"
#define SA_CRID_UNICODE_ORIGINAL_VALUE      L"SA-CRID Original Value"
#define SA_CRID_UNICODE_NEW_VALUE           L"SA-CRID New Value"
#define VBIOS_FVI_UNICODE_STRING            L"OPROM - VBIOS"

#define CRID_DATA                   0x69
#define CRID_LOCK                   0x17

typedef enum {
  Sa_Rc_Ver = 0,
  Mem_Rc_Ver,
  Pcie_Ver,
  Crid_Status,
  Crid_Original,
  Crid_new,
  Vbios_Ver
} SA_FVI_INDEX;

#endif
