@REM @file
@REM Capsule build script.
@REM
@REM @copyright
@REM  INTEL CONFIDENTIAL
@REM  Copyright 2016 - 2020 Intel Corporation.
@REM
@REM  The source code contained or described herein and all documents related to the
@REM  source code ("Material") are owned by Intel Corporation or its suppliers or
@REM  licensors. Title to the Material remains with Intel Corporation or its suppliers
@REM  and licensors. The Material may contain trade secrets and proprietary and
@REM  confidential information of Intel Corporation and its suppliers and licensors,
@REM  and is protected by worldwide copyright and trade secret laws and treaty
@REM  provisions. No part of the Material may be used, copied, reproduced, modified,
@REM  published, uploaded, posted, transmitted, distributed, or disclosed in any way
@REM  without Intel's prior express written permission.
@REM
@REM  No license under any patent, copyright, trade secret or other intellectual
@REM  property right is granted to or conferred upon you by disclosure or delivery
@REM  of the Materials, either expressly, by implication, inducement, estoppel or
@REM  otherwise. Any license under such intellectual property rights must be
@REM  express and approved by Intel in writing.
@REM
@REM  Unless otherwise agreed by Intel in writing, you may not remove or alter
@REM  this notice or any other notice embedded in Materials by Intel or
@REM  Intel's suppliers or licensors in any way.
@REM
@REM  This file contains a 'Sample Driver' and is licensed as such under the terms
@REM  of your license agreement with Intel or your vendor. This file may be modified
@REM  by the user, subject to the additional terms of the license agreement.
@REM
@REM @par Specification Reference:
@REM

@set CAP_PLATFORM_PREFIX=Tgl
@set CAP_PLATFORM_FULLNAME=TigerLake

@REM
@REM Set BtGAcm FW LSV version in DEC.
@REM Format: NNMMmm (N:version number, M: major version, m: minor version)
@REM Example: 01.0B.00 -> 010B00
@REM
@set BTGACM_CAP_LSV=000000

@set CAPSULE_PREP_FLAG=c
@set BIOS_ROM_BUILD_TYPE=DEBUG
@set BUILD_MONOLITHIC_CAPSULE=TRUE
@set BUILD_BIOS_CAPSULE=FALSE
@set BUILD_BTGACM_CAPSULE=FALSE
@set BUILD_EC_CAPSULE=FALSE
@set BUILD_ME_CAPSULE=FALSE
@set BUILD_ISH_PDT_CAPSULE=FALSE
@set BUILD_TBTRETIMER_CAPSULE=FALSE
@set BUILD_I2CRETIMER_CAPSULE=FALSE
@set BUILD_UCODE_CAPSULE=FALSE
@set BIOS_MAJOR_VERSION=
@set BIOS_MINOR_VERSION=
@set BIOS_VERSION_DEC=
@set BTGACM_VERSION_DEC=
@set BTGACM_MAJOR_VERSION=
@set BTGACM_MINOR_VERSION=
@set BTGACM_VERSION_DEC=
@set EC_MAJOR_VERSION=
@set EC_MINOR_VERSION=
@set EC_VERSION_DEC=
@set ME_BUILD_VERSION=
@set ISH_PDT_VERSION_DEC=
@set RETIMER_VERSION_DEC=

@if not defined PYTHON_COMMAND (
  set PYTHON_COMMAND=py -3
)

:CmdLineParse
@if "" == "%1" (
  goto Continue
)else if /I "help" == "%1" (
  goto CapsuleHelp
)else if /I "all" == "%1" (
  set BUILD_MONOLITHIC_CAPSULE=TRUE
  set BUILD_BIOS_CAPSULE=TRUE
  set BUILD_EC_CAPSULE=TRUE
  set BUILD_ME_CAPSULE=TRUE
  set BUILD_ISH_PDT_CAPSULE=TRUE
  set BUILD_TBTRETIMER_CAPSULE=TRUE
) else if /I "ucode" == "%1" (
  set BUILD_MONOLITHIC_CAPSULE=FALSE
  set BUILD_UCODE_CAPSULE=TRUE
  goto Continue
)else if /I "bios" == "%1" (
  set BUILD_MONOLITHIC_CAPSULE=FALSE
  set BUILD_BIOS_CAPSULE=TRUE
)else if /I "ec" == "%1" (
  set BUILD_MONOLITHIC_CAPSULE=FALSE
  set BUILD_EC_CAPSULE=TRUE
)else if /I "me" == "%1" (
  set BUILD_MONOLITHIC_CAPSULE=FALSE
  set BUILD_ME_CAPSULE=TRUE
)else if /I "pdt" == "%1" (
  set BUILD_MONOLITHIC_CAPSULE=FALSE
  set BUILD_ISH_PDT_CAPSULE=TRUE
)else if /I "tbtretimer" == "%1" (
  set BUILD_MONOLITHIC_CAPSULE=FALSE
  set BUILD_TBTRETIMER_CAPSULE=TRUE
)else if /I "i2cretimer" == "%1" (
  set BUILD_MONOLITHIC_CAPSULE=FALSE
  set BUILD_I2CRETIMER_CAPSULE=TRUE
)else if /I "res" == "%1" (
  set RESILIENCY_BUILD=TRUE
  @set CAPSULE_PREP_FLAG=c res
)else if /I "-mever" == "%1" (
  set ME_BUILD_VERSION=%2
  SHIFT
)else if /I "-pdtver" == "%1" (
  set ISH_PDT_VERSION_DEC=%2
  SHIFT
)else if /I "-rtver" == "%1" (
  set RETIMER_VERSION_DEC=%2
  SHIFT
)else if /I "btgacm" == "%1" (
  set BUILD_MONOLITHIC_CAPSULE=FALSE
  set BUILD_BTGACM_CAPSULE=TRUE
)else if /I "-btgacmlsv" == "%1" (
  set BTGACM_CAP_LSV=%2
  SHIFT
)else (
  echo.
  echo Invalid input arguments: %1
  echo.
  goto CapsulePrepFail
)

SHIFT
goto CmdLineParse

:Continue
cd ../TigerLakeBoardPkg
@call prep.bat %CAPSULE_PREP_FLAG%
@If %SCRIPT_ERROR% EQU 1 goto CapsulePrepFail

@cd %WORKSPACE%

@REM
@REM Define environment variables for Capsule build usage
@REM
@REM Generic path and files
set CAPSULE_UPDATE_TOOL_PATH=%WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\Features\CapsuleUpdate\Tools
set CAPSULE_UPDATE_CONFIG_PATH=%WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\CapsuleUpdateConfig
set CAPSULE_OUTPUT_PATH=%CAPSULE_UPDATE_CONFIG_PATH%\CapsuleOutput
set CAPSULE_BUILD_RESULT=%CAPSULE_OUTPUT_PATH%\result.log

@REM BIOS Payload
set BIOS_ROM_FILE=%CAPSULE_UPDATE_CONFIG_PATH%\ClientBios.rom
set BIOS_ID_FILE=%CAPSULE_UPDATE_CONFIG_PATH%\biosid.env

@REM EC Payload
set EC_BIN_FILE=%CAPSULE_UPDATE_CONFIG_PATH%\Ec.bin
set EC_ID_FILE=%CAPSULE_UPDATE_CONFIG_PATH%\ecid.env

@REM ME Payload
set ME_BIN_FILE=%CAPSULE_UPDATE_CONFIG_PATH%\Me.bin

@REM PDT Payload
set PDT_BIN_FILE=%CAPSULE_UPDATE_CONFIG_PATH%\Pdt.bin

@REM BootGuard ACM Payload
set BTGACM_BIN_FILE=%CAPSULE_UPDATE_CONFIG_PATH%\BtGAcm.bin
set BTGACM_ID_FILE=%CAPSULE_UPDATE_CONFIG_PATH%\BtGAcmid.env
set BTGACM_HEADER_FILE=%CAPSULE_UPDATE_CONFIG_PATH%\BtGAcmHeader.bin
set RETIMER_PAYLOAD_CONFIG_FILE=%CAPSULE_UPDATE_CONFIG_PATH%\RetimerPayloadConfig.ini
set TCI2CRETIMER_PAYLOAD_CONFIG_FILE=%CAPSULE_UPDATE_CONFIG_PATH%\TcI2cRetimerPayloadConfig.ini
set RETIMER_CAPSULE_PAYLOAD=%CAPSULE_UPDATE_CONFIG_PATH%\RetimerPayload.bin

@set BTGACM_CAP_LSV=%BTGACM_CAP_LSV:~-6%

@if not exist %CAPSULE_OUTPUT_PATH% mkdir %CAPSULE_OUTPUT_PATH%
@del %CAPSULE_BUILD_RESULT% 1>NUL 2>&1
@echo ============= Capsule build result - Begin ============= >> %CAPSULE_BUILD_RESULT%
@echo. >> %CAPSULE_BUILD_RESULT%

@REM
@REM Check binaries before building Capsules
@REM
:CheckRetimerImage
@REM Skip checking Retimer config image if it's not requested.
@if "%BUILD_TBTRETIMER_CAPSULE%" == "FALSE"  (
  goto CheckI2cRetimerImage
)

@if not defined RETIMER_VERSION_DEC (
  @echo.
  @echo !! Retimer version is not assigned via -rtver argument
  @goto CapsuleNotBuilt
)

@if not exist %RETIMER_PAYLOAD_CONFIG_FILE% (
  @echo.
  @echo !! PDT binary does not exist.
  @goto CapsuleNotBuilt
)

@del %RETIMER_CAPSULE_PAYLOAD% 1>NUL 2>&1
@%PYTHON_COMMAND% %CAPSULE_UPDATE_TOOL_PATH%\GenerateCapsule\GenRetimerPayloadHeader.py %RETIMER_PAYLOAD_CONFIG_FILE%
@if errorlevel 1 (
  @echo.
  @echo !! Failed to generate Retimer Capsule payload from %RETIMER_PAYLOAD_CONFIG_FILE%.
  @goto CapsuleNotBuilt
)

@if not exist %RETIMER_CAPSULE_PAYLOAD% (
  @echo.
  @echo !! PDT binary does not exist.
  @goto CapsuleNotBuilt
)

:CheckI2cRetimerImage
@if "%BUILD_I2CRETIMER_CAPSULE%" == "FALSE"  (
  goto CheckPdtImage
)


@if not defined RETIMER_VERSION_DEC (
  @echo.
  @echo !! Retimer version is not assigned via -rtver argument
  @goto CapsuleNotBuilt
)

@if not exist %TCI2CRETIMER_PAYLOAD_CONFIG_FILE% (
  @echo.
  @echo !! PDT binary does not exist.
  @goto CapsuleNotBuilt
)

@del %RETIMER_CAPSULE_PAYLOAD% 1>NUL 2>&1
@%PYTHON_COMMAND% %CAPSULE_UPDATE_TOOL_PATH%\GenerateCapsule\GenTcI2cRetimerPayloadHeader.py %TCI2CRETIMER_PAYLOAD_CONFIG_FILE%
@if errorlevel 1 (
  @echo.
  @echo !! Failed to generate Retimer Capsule payload from %TCI2CRETIMER_PAYLOAD_CONFIG_FILE%.
  @goto CapsuleNotBuilt
)

@if not exist %RETIMER_CAPSULE_PAYLOAD% (
  @echo.
  @echo !! PDT binary does not exist.
  @goto CapsuleNotBuilt
)

:CheckPdtImage
@REM Skip checking PDT image if it's not requested.
@if "%BUILD_ISH_PDT_CAPSULE%" == "FALSE"  (
  goto CheckEcImage
)

@if not exist %PDT_BIN_FILE% (
  @echo.
  @echo !! PDT binary does not exist.
  @goto CapsuleNotBuilt
)

@REM Check PDT BIN: If file exists, does not have $DUM signature
FINDSTR "$DUM" %PDT_BIN_FILE% 1>NUL
@if not errorlevel 1 (
  @echo.
  @echo !! PDT binary is a dummy one.
  @echo Standalone PDT Capsule is NOT generated because Pdt binary is a dummy one >> %CAPSULE_BUILD_RESULT%
  @echo. >> %CAPSULE_BUILD_RESULT%
  set BUILD_ISH_PDT_CAPSULE=FALSE
  @goto CheckEcImage
)

@if not defined ISH_PDT_VERSION_DEC (
  @echo.
  @echo !! Virtual PDT version is not assigned via -pdtver argument
  @goto CapsuleNotBuilt
)

:CheckEcImage
@REM Skip checking EC image if it's not requested.
@if "%BUILD_EC_CAPSULE%" == "FALSE"  (
  goto CheckMeImage
)

@if not exist %EC_BIN_FILE% (
  @echo.
  @echo !! EC binary does not exist.
  @goto CapsuleNotBuilt
)

@REM Get EC Major version and Minor verison
@del %EC_ID_FILE% 1>NUL 2>&1
@%PYTHON_COMMAND% %CAPSULE_UPDATE_TOOL_PATH%\GetFwVersionFromBin\GetEcVerFromBin.py %EC_BIN_FILE% %EC_ID_FILE%
@if errorlevel 1 (
  @echo.
  @echo !! Failed to get EC information from EC binary.
  @goto CapsuleNotBuilt
)

@for /f "usebackq tokens=3" %%i in (`FINDSTR /b /c:"VERSION_MAJOR" %EC_ID_FILE%`) do (
   @for /f "usebackq tokens=3" %%j in (`FINDSTR /b /c:"VERSION_MINOR" %EC_ID_FILE%`) do (
      @set EC_MAJOR_VERSION=%%i
      @set EC_MINOR_VERSION=%%j
  )
)
@del %EC_ID_FILE% 1>NUL 2>&1

@REM
@REM Combine major and minor version to a single EC FW version
@REM Format: MMMmmm (M: major version, m: minor version). e.g., 1.18 -> 1018
@REM
set "EC_MINOR_VERSION=000%EC_MINOR_VERSION%"
set EC_VERSION_DEC=%EC_MAJOR_VERSION:~-3%%EC_MINOR_VERSION:~-3%

:CheckMeImage
@REM Skip checking ME image if it's not requested.
@if "%BUILD_ME_CAPSULE%" == "FALSE"  (
  goto CheckBiosImage
)

@if not defined ME_BUILD_VERSION (
  @echo.
  @echo !! ME build version is not assigned via -mever argument
  @goto CapsuleNotBuilt
)

@REM Check if inputting ME build version is valid
echo %ME_BUILD_VERSION:~-4% | FINDSTR /R "[0-9][0-9][0-9][0-9]" 1>NUL
@if errorlevel 1 (
  @echo.
  @echo !! ME Build version is invalid.
  @goto CapsuleNotBuilt
)

@if not exist %ME_BIN_FILE% (
  @echo.
  @echo !! ME binary does not exist.
  @goto CapsuleNotBuilt
)

@REM Check ME BIN: If file exists, does not have $DUM signature
FINDSTR "$DUM" %ME_BIN_FILE% 1>NUL
@if not errorlevel 1 (
  @echo.
  @echo !! ME binary is a dummy one.
  @goto CapsuleNotBuilt
)

:CheckBiosImage
@REM Skip checking BIOS image if it's not requested.
if "%BUILD_MONOLITHIC_CAPSULE%" == "TRUE" goto GenBiosUpdateImage
if "%BUILD_BIOS_CAPSULE%" == "TRUE" goto GenBiosUpdateImage
goto SkipGenBiosUpdateImage

:GenBiosUpdateImage
@REM Check BIOS ROM: If file exists and has $IBIOSI$ signature
@if not exist %BIOS_ROM_FILE% (
  @echo.
  @echo !! BIOS ROM does not exist.
  @goto CapsuleNotBuilt
)

@REM 1. Get BIOS Major version, Minor verison and Build Target
@del %BIOS_ID_FILE% 1>NUL 2>&1
@%PYTHON_COMMAND% %CAPSULE_UPDATE_TOOL_PATH%\GetFwVersionFromBin\GetBiosIdFromBin.py %BIOS_ROM_FILE% %BIOS_ID_FILE%
@if errorlevel 1 (
  @echo.
  @echo !! Failed to get BIOS information from BIOS ROM.
  @goto CapsuleNotBuilt
)

@for /f "usebackq tokens=3" %%i in (`FINDSTR /b /c:"VERSION_MAJOR" %BIOS_ID_FILE%`) do (
   @for /f "usebackq tokens=3" %%j in (`FINDSTR /b /c:"VERSION_MINOR" %BIOS_ID_FILE%`) do (
     @for /f "usebackq tokens=3" %%k in (`FINDSTR /b /c:"BUILD_TARGET" %BIOS_ID_FILE%`) do (
      @set BIOS_MAJOR_VERSION=%%i
      @set BIOS_MINOR_VERSION=%%j
      @set BIOS_ROM_BUILD_TYPE=%%k
    )
  )
)
@del %BIOS_ID_FILE% 1>NUL 2>&1

@REM
@REM Combine major and minor version to a single BIOS FW version
@REM Format: MMMMmm (M: major version, m: minor version). e.g., 2413.01 -> 241301
@REM
set "BIOS_MINOR_VERSION=00%BIOS_MINOR_VERSION%"
set BIOS_VERSION_DEC=%BIOS_MAJOR_VERSION:~-4%%BIOS_MINOR_VERSION:~-2%

@REM 2. Generate ClientBios_Ft.rom/BiosUpdate.ini/BiosBgup.bin
@call %CAPSULE_UPDATE_TOOL_PATH%\GenBiosUpdateImages\GenBiosUpdateImages.bat ^
                                                       %BIOS_ROM_FILE% ^
                                                       %BIOS_ROM_BUILD_TYPE% ^
                                                       %CAPSULE_UPDATE_CONFIG_PATH%

@if errorlevel 1 (
  @echo.
  @echo !! Failed to generate BIOS update image from BIOS ROM.
  @goto CapsuleNotBuilt
)

:SkipGenBiosUpdateImage

@REM
@REM Start building Capsule
@REM
@if "%BUILD_MONOLITHIC_CAPSULE%" == "TRUE" (
  @goto BuildMonolithicCapsule
) else (
  @goto BuildStandaloneCapsules
)

@REM ===================================================
@REM =             Build Monolithic Capsule            =
@REM ===================================================
:BuildMonolithicCapsule
@REM Clean directories and files from the previous output
@if exist %WORKSPACE%\Conf\.cache rmdir /q /s %WORKSPACE%\Conf\.cache
@if exist %WORKSPACE%\%BUILD_DIR%\FV rmdir /q /s %WORKSPACE%\%BUILD_DIR%\FV

@REM 1. Build Monolithic FMP FV Payload
@if %RESILIENCY_BUILD% EQU TRUE (
  call genfds ^
         -f %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\CapsulePkgRes.fdf ^
         -p %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\CapsulePkgRes.dsc ^
         -i CapsulePayloadMonolithic
  ) else (
  call genfds ^
         -f %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\CapsulePkg.fdf ^
         -p %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\CapsulePkg.dsc ^
         -i CapsulePayloadMonolithic
)
@if errorlevel 1 (
  @echo.
  @echo !! Error when generating Monolithic FMP FV Payload
  goto CapsuleNotBuilt
)

@REM 2. Generate Monolithic FMP Capsule
@cd %CAPSULE_UPDATE_TOOL_PATH%\GenerateCapsule
@call GenCapsuleSysFwMonolithic.bat ^
        %WORKSPACE%\%BUILD_DIR%\FV\CAPSULEPAYLOADMONOLITHIC.Fv ^
        %BIOS_VERSION_DEC% ^
        %CAPSULE_OUTPUT_PATH%

@if errorlevel 1 (
  @echo.
  @echo !! Error when generating Monolithic capsule
  goto CapsuleNotBuilt
)

@REM Write to build result
set CAPSULE_OUTPUT_NAME=%CAP_PLATFORM_PREFIX%SystemFwMono_%BIOS_VERSION_DEC%.Cap
if exist %CAPSULE_OUTPUT_PATH%\%CAPSULE_OUTPUT_NAME% (
  @echo Monolithic Capsule %CAPSULE_OUTPUT_NAME% is generated in >> %CAPSULE_BUILD_RESULT%
  @echo   %CAPSULE_OUTPUT_PATH% >> %CAPSULE_BUILD_RESULT%
  @echo. >> %CAPSULE_BUILD_RESULT%
)

:BuildStandaloneCapsules
@REM
@REM Build Standalone Capsules
@REM
:BuildBiosCapsule
@REM ===================================================
@REM =            Build BIOS Capsule                   =
@REM ===================================================
@REM Skip building standalone BIOS Capsule if it's not requested.
@if "%BUILD_BIOS_CAPSULE%" == "FALSE"  (
  goto CheckBtGAcmUpdateImage
)

@REM Clean directories and files from the previous output
if exist %WORKSPACE%\Conf\.cache rmdir /q /s %WORKSPACE%\Conf\.cache
if exist %WORKSPACE%\%BUILD_DIR%\FV rmdir /q /s %WORKSPACE%\%BUILD_DIR%\FV

@REM 1. Build BIOS FMP FV Payload
@if %RESILIENCY_BUILD% EQU TRUE (
  call genfds ^
         -f %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\CapsulePkgRes.fdf ^
         -p %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\CapsulePkgRes.dsc ^
         -i CapsulePayloadBios
  ) else (
  call genfds ^
         -f %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\CapsulePkg.fdf ^
         -p %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\CapsulePkg.dsc ^
         -i CapsulePayloadBios
  )
@if errorlevel 1 (
  @echo.
  @echo !! Error when generating BIOS FMP FV Payload
  goto CapsuleNotBuilt
)

@REM 2. Generate BIOS FMP Capsule
@cd %CAPSULE_UPDATE_TOOL_PATH%\GenerateCapsule
@call GenCapsuleSysFwBios.bat ^
        %WORKSPACE%\%BUILD_DIR%\FV\CAPSULEPAYLOADBIOS.Fv ^
        %BIOS_VERSION_DEC% ^
        %CAPSULE_OUTPUT_PATH%

@if errorlevel 1 (
  @echo.
  @echo !! Error when generating BIOS capsule
  goto CapsuleNotBuilt
)

@REM Write to build result
set CAPSULE_OUTPUT_NAME=%CAP_PLATFORM_PREFIX%SystemFwBios_%BIOS_VERSION_DEC%.Cap
if exist %CAPSULE_OUTPUT_PATH%\%CAPSULE_OUTPUT_NAME% (
  @echo Standalone BIOS Capsule %CAPSULE_OUTPUT_NAME% is generated in >> %CAPSULE_BUILD_RESULT%
  @echo   %CAPSULE_OUTPUT_PATH% >> %CAPSULE_BUILD_RESULT%
  @echo. >> %CAPSULE_BUILD_RESULT%
)

:CheckBtGAcmUpdateImage
REM Skip building BtGAcm Capsule if it's not requested.
if "%BUILD_BTGACM_CAPSULE%" == "TRUE" goto GenBtGAcmUpdateImage
goto BuilduCodeCapsule

:GenBtGAcmUpdateImage
@REM 1. Get BIOS Major version, Minor verison and Build Target
@del %BTGACM_ID_FILE% 1>NUL 2>&1
@%PYTHON_COMMAND% %CAPSULE_UPDATE_TOOL_PATH%\GetFwVersionFromBin\GetBtGAcmIdFromBin.py %BTGACM_BIN_FILE% %BTGACM_ID_FILE% %BTGACM_HEADER_FILE%
@if errorlevel 1 (
  @echo.
  @echo !! Failed to get BIOS information from BIOS ROM.
  @goto CapsuleNotBuilt
)

@for /f "usebackq tokens=3" %%i in (`FINDSTR /b /c:"VERSION_NUMBER" %BTGACM_ID_FILE%`) do (
   @for /f "usebackq tokens=3" %%j in (`FINDSTR /b /c:"VERSION_MAJOR" %BTGACM_ID_FILE%`) do (
     @for /f "usebackq tokens=3" %%k in (`FINDSTR /b /c:"VERSION_MINOR" %BTGACM_ID_FILE%`) do (
       @for /f "usebackq tokens=3" %%l in (`FINDSTR /b /c:"BUILD_TARGET" %BTGACM_ID_FILE%`) do (
         @set BTGACM_VERSION_NUMBER=%%i
         @set BTGACM_MAJOR_VERSION=%%j
         @set BTGACM_MINOR_VERSION=%%k
         @set BTGACM_BIN_BUILD_TYPE=%%l
       )
    )
  )
)
@del %BTGACM_ID_FILE% 1>NUL 2>&1

@REM
@REM Combine version number, major and minor to a single BtGAcm FW version
@REM Format: NNMMmm (N:version number, M: major version, m: minor version). e.g., 01.0B.00 -> 010B00
@REM
set BTGACM_VERSION_NUMBER=%BTGACM_VERSION_NUMBER%
@REM A tricky way to covert version data from DEC to HEX
call cmd /c exit /b %BTGACM_VERSION_NUMBER%
set BTGACM_VERSION_NUMBER=%=exitcode%

set BTGACM_MAJOR_VERSION=%BTGACM_MAJOR_VERSION%
@REM A tricky way to covert version data from DEC to HEX
call cmd /c exit /b %BTGACM_MAJOR_VERSION%
set BTGACM_MAJOR_VERSION=%=exitcode%

set BTGACM_MINOR_VERSION=%BTGACM_MINOR_VERSION%
@REM A tricky way to covert version data from DEC to HEX
call cmd /c exit /b %BTGACM_MINOR_VERSION%
set BTGACM_MINOR_VERSION=%=exitcode%

set BTGACM_VERSION_DEC=%BTGACM_VERSION_NUMBER:~-2%%BTGACM_MAJOR_VERSION:~-2%%BTGACM_MINOR_VERSION:~-2%

@REM 2. Generate StartupAcm.bin/Hash.bin/BtGAcmUpdate.ini/BtGAcmBgup.bin
@call %CAPSULE_UPDATE_TOOL_PATH%\GenBiosUpdateImages\GenBtGAcmUpdateImages.bat^
                                                       %BTGACM_BIN_FILE%^
                                                       %BTGACM_BIN_BUILD_TYPE%^
                                                       %CAPSULE_UPDATE_CONFIG_PATH%^
                                                       %BIOS_ROM_FILE%

@if errorlevel 1 (
  @echo.
  @echo !! Failed to generate BIOS update image from BIOS ROM.
  @goto CapsuleNotBuilt
)

:BuildBtGAcmCapsule
@REM ===================================================
@REM =            Build BtGAcm Capsule                 =
@REM ===================================================
@@REM Clean directories and files from the previous output
if exist %WORKSPACE%\Conf\.cache rmdir /q /s %WORKSPACE%\Conf\.cache
if exist %WORKSPACE%\%BUILD_DIR%\FV rmdir /q /s %WORKSPACE%\%BUILD_DIR%\FV

@REM 1. Build BtGAcm FMP FV Payload
call genfds ^
       -f %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\BtGAcmCapsulePkg.fdf ^
       -p %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\BtGAcmCapsulePkg.dsc ^
       -i CapsulePayloadBtGAcm

@if errorlevel 1 (
  @echo.
  @echo !! Error when generating BtGAcm FMP FV Payload
  goto CapsuleNotBuilt
)

@REM 2. Generate BtGAcm FMP Capsule
@cd %CAPSULE_UPDATE_TOOL_PATH%\GenerateCapsule
@call GenCapsuleSysFwBtGAcm.bat ^
        %WORKSPACE%\%BUILD_DIR%\FV\CAPSULEPAYLOADBTGACM.Fv ^
        %BTGACM_VERSION_DEC% ^
        %CAPSULE_OUTPUT_PATH% ^
        %BTGACM_CAP_LSV%

@if errorlevel 1 (
  @echo.
  @echo !! Error when generating BtGAcm capsule
  goto CapsuleNotBuilt
)

@REM Write to build result
set CAPSULE_OUTPUT_NAME=TglSystemFwBtGAcm_%BTGACM_VERSION_DEC%.Cap
if exist %CAPSULE_OUTPUT_PATH%\%CAPSULE_OUTPUT_NAME% (
  @echo BtGAcm Capsule %CAPSULE_OUTPUT_NAME% is generated in >> %CAPSULE_BUILD_RESULT%
  @echo   %CAPSULE_OUTPUT_PATH% >> %CAPSULE_BUILD_RESULT%
  @echo. >> %CAPSULE_BUILD_RESULT%
)

:BuilduCodeCapsule
@REM ===================================================
@REM =            Build uCode Capsule                  =
@REM =                                                 =
@REM = How to use NewGenCap.py                         =
@REM = Reference PlatSamplePkg\Features\CapsuleUpdate\Tools\NewGenCap\ReadMe.txt
@REM ===================================================
@if "%BUILD_UCODE_CAPSULE%" == "FALSE" (
  goto BuildEcCapsule
)

@cls
@cd %CAPSULE_UPDATE_TOOL_PATH%\NewGenCap
SHIFT
%PYTHON_COMMAND% NewGenCap.py %*
@if errorlevel 1 (
  @echo .
  @echo !! Error when generating uCode capsule
  goto CapsuleNotBuilt
)
@if errorlevel 0 (
  @echo !! Success to generate uCode capsule
  @echo !! The capsule file is saved under "%CAPSULE_UPDATE_TOOL_PATH%\NewGenCap\Output" folder
)

:BuildEcCapsule
@REM ===================================================
@REM =            Build EC Capsule                     =
@REM ===================================================
@REM Skip building standalone EC Capsule if it's not requested.
@if "%BUILD_EC_CAPSULE%" == "FALSE"  (
  goto BuildMeCapsule
)

@REM Generate EC FMP Capsule
@cd %CAPSULE_UPDATE_TOOL_PATH%\GenerateCapsule
@call GenCapsuleSysFwEc.bat ^
        %EC_BIN_FILE% ^
        %EC_VERSION_DEC% ^
        %CAPSULE_OUTPUT_PATH%

@if errorlevel 1 (
  @echo.
  @echo !! Error when generating EC capsule
  goto CapsuleNotBuilt
)

@REM Write to build result
set CAPSULE_OUTPUT_NAME=%CAP_PLATFORM_PREFIX%SystemFwEc_%EC_VERSION_DEC%.Cap
if exist %CAPSULE_OUTPUT_PATH%\%CAPSULE_OUTPUT_NAME% (
  @echo Standalone EC Capsule %CAPSULE_OUTPUT_NAME% is generated in >> %CAPSULE_BUILD_RESULT%
  @echo   %CAPSULE_OUTPUT_PATH% >> %CAPSULE_BUILD_RESULT%
  @echo. >> %CAPSULE_BUILD_RESULT%
)

:BuildMeCapsule
@REM ===================================================
@REM =            Build ME Capsule                     =
@REM ===================================================
@REM Skip building standalone ME Capsule if it's not requested.
@if "%BUILD_ME_CAPSULE%" == "FALSE"  (
  goto BuildPdtCapsule
)

@REM Generate ME FMP Capsule
@cd %CAPSULE_UPDATE_TOOL_PATH%\GenerateCapsule
@call GenCapsuleSysFwMe.bat ^
        %ME_BIN_FILE% ^
        %ME_BUILD_VERSION:~-4% ^
        %CAPSULE_OUTPUT_PATH%

@if errorlevel 1 (
  @echo.
  @echo !! Error when generating ME capsule
  goto CapsuleNotBuilt
)

@REM Write to build result
set CAPSULE_OUTPUT_NAME=%CAP_PLATFORM_PREFIX%SystemFwMe_%ME_BUILD_VERSION:~-4%.Cap
if exist %CAPSULE_OUTPUT_PATH%\%CAPSULE_OUTPUT_NAME% (
  @echo Standalone ME Capsule %CAPSULE_OUTPUT_NAME% is generated in >> %CAPSULE_BUILD_RESULT%
  @echo   %CAPSULE_OUTPUT_PATH% >> %CAPSULE_BUILD_RESULT%
  @echo. >> %CAPSULE_BUILD_RESULT%
)

:BuildPdtCapsule
@REM ===================================================
@REM =            Build PDT Capsule                    =
@REM ===================================================
@REM Skip building standalone PDT Capsule if it's not requested.
@if "%BUILD_ISH_PDT_CAPSULE%" == "FALSE"  (
  goto BuildRetimerCapsule
)

@REM Generate PDT FMP Capsule
@cd %CAPSULE_UPDATE_TOOL_PATH%\GenerateCapsule
@call GenCapsuleSysFwIshPdt.bat ^
        %PDT_BIN_FILE% ^
        %ISH_PDT_VERSION_DEC% ^
        %CAPSULE_OUTPUT_PATH%

@if errorlevel 1 (
  @echo.
  @echo !! Error when generating PDT capsule
  goto CapsuleNotBuilt
)

@REM Write to build result
set CAPSULE_OUTPUT_NAME=%CAP_PLATFORM_PREFIX%SystemFwIshPdt_%ISH_PDT_VERSION_DEC%.cap
if exist %CAPSULE_OUTPUT_PATH%\%CAPSULE_OUTPUT_NAME% (
  @echo Standalone ISH PDT Capsule %CAPSULE_OUTPUT_NAME% is generated in >> %CAPSULE_BUILD_RESULT%
  @echo   %CAPSULE_OUTPUT_PATH% >> %CAPSULE_BUILD_RESULT%
  @echo. >> %CAPSULE_BUILD_RESULT%
)

:BuildRetimerCapsule
@REM ===================================================
@REM =            Build Retimer Capsule                    =
@REM ===================================================
@REM Skip building Retimer Capsule if it's not requested.
@if "%BUILD_TBTRETIMER_CAPSULE%" == "FALSE"  (
  goto BuildTcI2cRetimerCapsule
)

@REM Generate PDT FMP Capsule
@cd %CAPSULE_UPDATE_TOOL_PATH%\GenerateCapsule
@call GenCapsuleTbtRetimer.bat ^
        %RETIMER_CAPSULE_PAYLOAD% ^
        %RETIMER_VERSION_DEC% ^
        %CAPSULE_OUTPUT_PATH%

@if errorlevel 1 (
  @echo.
  @echo !! Error when generating Retimer capsule
  goto CapsuleNotBuilt
)

@REM Write to build result
set CAPSULE_OUTPUT_NAME=TblTbtRetimer_%RETIMER_VERSION_DEC%.cap
if exist %CAPSULE_OUTPUT_PATH%\%CAPSULE_OUTPUT_NAME% (
  @echo TGL Retimer Capsule %CAPSULE_OUTPUT_NAME% is generated in >> %CAPSULE_BUILD_RESULT%
  @echo   %CAPSULE_OUTPUT_PATH% >> %CAPSULE_BUILD_RESULT%
  @echo. >> %CAPSULE_BUILD_RESULT%
)

:BuildTcI2cRetimerCapsule
@REM ===================================================
@REM =            Build TypeC I2C Retimer Capsule                    =
@REM ===================================================
@REM Skip building Retimer Capsule if it's not requested.
@if "%BUILD_I2CRETIMER_CAPSULE%" == "FALSE"  (
  goto EndOfBuildingCapsule
)

@REM Generate PDT FMP Capsule
@cd %CAPSULE_UPDATE_TOOL_PATH%\GenerateCapsule
@call GenCapsuleTcI2cRetimer.bat ^
        %RETIMER_CAPSULE_PAYLOAD% ^
        %RETIMER_VERSION_DEC% ^
        %CAPSULE_OUTPUT_PATH%

@if errorlevel 1 (
  @echo.
  @echo !! Error when generating Retimer capsule
  goto CapsuleNotBuilt
)

@REM Write to build result
set CAPSULE_OUTPUT_NAME=TglTcI2cRetimer_%RETIMER_VERSION_DEC%.cap
if exist %CAPSULE_OUTPUT_PATH%\%CAPSULE_OUTPUT_NAME% (
  @echo TGL Retimer Capsule %CAPSULE_OUTPUT_NAME% is generated in >> %CAPSULE_BUILD_RESULT%
  @echo   %CAPSULE_OUTPUT_PATH% >> %CAPSULE_BUILD_RESULT%
  @echo. >> %CAPSULE_BUILD_RESULT%
)
:EndOfBuildingCapsule
@echo.
@echo.
@echo.
if exist %CAPSULE_BUILD_RESULT% (
  @echo ============= Capsule build result - End =============== >> %CAPSULE_BUILD_RESULT%
  type %CAPSULE_BUILD_RESULT%
  @del %CAPSULE_BUILD_RESULT% 1>NUL 2>&1
)
@echo.
@echo Capsule build is completed.
@echo.
goto CapsuleBuildDone

@REM
@REM ============ Error handle ============
@REM
:CapsulePrepFail
@echo.
@echo !! The Capsule build has failed in prep phase!
@echo.
@goto CapsuleHelp

:CapsuleNotBuilt
@echo.
@echo !! CapsuleBuild failed.
@echo.

:CapsuleHelp
@echo.
@echo Build Capsules based on the binaries in CapsuleUpdateConfig
@echo Find more details in CapsuleUpdateConfig\ReadMe.txt
@echo.
@echo capsulebuild [target:all/bios/ec/me/pdt][-mever ^<ME Build Version^>][-pdtver ^<PDT Version^>][help]
@echo.
@echo   target   Assign Capsule build target: all/bios/me/ec
@echo.
@echo            default: If target is NOT assigned, build Monolithic Capsule
@echo                     (A single capsule covers BIOS+EC+ME+...)
@echo            all    : Build Monolithic Capsule + all standalone system FW Capsules
@echo            bios   : Build Standalone BIOS Capsule
@echo            ec     : Build Standalone EC Capsule
@echo            me     : Build Standalone ME Capsule
@echo            pdt    : Build Standalone PDT Capsule
@echo            retimer: Build Retimer device FW Capsule
@echo.
@echo   -mever   To indicate ME Build version of CapsuleUpdateConfig\Me.bin.
@echo            It's mandatory if building capsules with [all] or [me] target
@echo            e.g., "capsulebuild.bat me -mever 1033"
@echo   -pdtver  To assign a virtual PDT version of CapsuleUpdateConfig\Pdt.bin.
@echo            It's mandatory if building capsules with [all] or [pdt] target
@echo            e.g., "capsulebuild.bat pdt -pdtver 2"
@echo   -rtver   To assign a virtual Retimer version for Retimer Capsule
@echo            It's mandatory if building capsules with [retimer] target
@echo            e.g., "capsulebuild.bat retimer -rtver 14"
@echo.
@echo   Note: As of now we dont have the knowledge to parse ME version from
@echo         a given ME FW image.
@echo         So ME version needs to be provided manually by the user.
@echo.
@echo   Examples:
@echo      a. capsulebuild.bat
@echo           Build a Monolithic capsule. (default build)
@echo           %CAP_PLATFORM_PREFIX%SystemFwMono_xxxx.cap would be observed in CapsuleOutput directory.
@echo      b. capsulebuild.bat ec
@echo           Build a standalone ec capsule.
@echo           %CAP_PLATFORM_PREFIX%SystemFwEc_xxxx.cap would be observed in CapsuleOutput directory.
@echo      c. capsulebuild.bat bios me -mever 1033
@echo           Build both standalone ME capsule and BIOS capsule.
@echo           1033 indicates ME build verion of Me.bin
@echo           %CAP_PLATFORM_PREFIX%SystemFwMe_1033.cap and %CAP_PLATFORM_PREFIX%SystemFwBios_xxxx.cap would be observed
@echo           in CapsuleOutput directory.
@echo.
@goto CapsuleBuildDone

:CapsuleBuildDone
@if defined WORKSPACE_PLATFORM (
  if defined PLATFORM_FULL_PACKAGE (
    @cd %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%
  )
)
