/** @file
  This file contains the APs HWP SSDT Table ASL code.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2012 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#define AP_SCOPE_CPC_METHOD(INDEX) \
  External(\_SB.PR##INDEX, ProcessorObj) \
  Scope(\_SB.PR##INDEX) \
  { \
    Method(_CPC,0) \
    { \
      Return(\_SB.PR00._CPC) \
    } \
  }


DefinitionBlock (
  "ApHwp.aml",
  "SSDT",
  2,
  "PmRef",
  "ApHwp",
  0x3000
  )
{
  External(\_SB.PR00._CPC, MethodObj)

  AP_SCOPE_CPC_METHOD(01)
  AP_SCOPE_CPC_METHOD(02)
  AP_SCOPE_CPC_METHOD(03)
  AP_SCOPE_CPC_METHOD(04)
  AP_SCOPE_CPC_METHOD(05)
  AP_SCOPE_CPC_METHOD(06)
  AP_SCOPE_CPC_METHOD(07)
  AP_SCOPE_CPC_METHOD(08)
  AP_SCOPE_CPC_METHOD(09)
  AP_SCOPE_CPC_METHOD(10)
  AP_SCOPE_CPC_METHOD(11)
  AP_SCOPE_CPC_METHOD(12)
  AP_SCOPE_CPC_METHOD(13)
  AP_SCOPE_CPC_METHOD(14)
  AP_SCOPE_CPC_METHOD(15)
  AP_SCOPE_CPC_METHOD(16)
  AP_SCOPE_CPC_METHOD(17)
  AP_SCOPE_CPC_METHOD(18)
  AP_SCOPE_CPC_METHOD(19)
  AP_SCOPE_CPC_METHOD(20)
  AP_SCOPE_CPC_METHOD(21)
  AP_SCOPE_CPC_METHOD(22)
  AP_SCOPE_CPC_METHOD(23)
}// end of definition block

#undef AP_SCOPE_CPC_METHOD(INDEX)
