
/** @file
  AdlMsr.h

  @copyright
  INTEL CONFIDENTIAL
  Copyright 2019 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _ADLMSR_h
#define _ADLMSR_h
#include <Base.h>

/**
  Register to disable split locks, which are locked instructions that split a cache line.
**/
#define ADL_MSR_MEMORY_CONTROL 0x00000033

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 28;

                            /* Bits[27:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 UcLockDisable : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /*
                               If set to 1, a UC load lock will trigger a #GP
                               fault. If clear to 0, UC load locks proceed
                               normally.
                            */
    UINT32 SplitLockDisable : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /*
                               If set to 1, a split lock will trigger an #AC
                               fault. If clear to 0, split locks proceed
                               normally (subjected to the SUPPRESS_SPLIT_LOCK
                               behavior. If both this bit and
                               SUPPRESS_SPLIT_LOCK are set, then only this bit
                               will be honored (has priority).
                            */
    UINT32 Rsvd30 : 1;

                            /* Bits[30:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SuppressSplitLock : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /*
                               If set to 1, disables split locks. If clear to
                               0, enables split locks. Setting this bit will
                               cause split locks to be non-atomic, despite the
                               lock attribute of the instruction.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_MEMORY_CONTROL_REGISTER;

/**
  Virtual MSR to set/clear IBRS commands
**/
#define ADL_MSR_SPEC_CTRL 0x00000048

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ibrs : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* IBRS Mode Active */
    UINT32 Stibp : 1;

                            /* Bits[1:1], Access Type=RW, default=None*/

                            /* STIBP Mode Active */
    UINT32 Rsvd2 : 30;

                            /* Bits[31:2], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_SPEC_CTRL_REGISTER;

/**
  Write-only virtual MSR to activate BPU flush command
**/
#define ADL_MSR_PREDICT_CMD 0x00000049

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ibpb : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* IBRS Mode Active */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PREDICT_CMD_REGISTER;

/**
  new MSR to flush caches
**/
#define ADL_MSR_ADR_CACHE_FLUSH_CLNT 0x00000056

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboSlice0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* LLC slice mask */
    UINT32 CboSlice1 : 2;

                            /* Bits[33:32], Access Type=RW, default=0x00000000*/

                            /* LLC slice mask */
    UINT32 Rsvd34 : 30;

                            /* Bits[63:34], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_ADR_CACHE_FLUSH_CLNT_REGISTER;

/**
  Override MPX Fuse.
**/
#define ADL_MSR_MPX_FUSE_OVERRIDE 0x0000006A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MpxEnabled : 1;

                            /* Bits[0:0], Access Type=RO_V, default=None*/

                            /* MPX Enable */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO_V, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO_V, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_MPX_FUSE_OVERRIDE_REGISTER;

/**
  MSR to expose the MCHECK error code to BIOS
**/
#define ADL_MSR_SGX_MCU_ERRORCODE 0x000000A0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 McheckErrorCode : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* MCHECK error code from MCHECK-ucode API */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_SGX_MCU_ERRORCODE_REGISTER;

/**
  FIT BIOS and ACM error type and code
**/
#define ADL_MSR_FIT_BIOS_ERROR 0x000000A5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ErrorCode : 7;

                            /* Bits[6:0], Access Type=RW, default=None*/

                            /* error code optype */
    UINT32 AltFit : 1;

                            /* Bits[7:7], Access Type=RW, default=None*/

                            /*
                               indicates whether FIT error occured for
                               alternative FIT
                            */
    UINT32 EntryType : 8;

                            /* Bits[15:8], Access Type=RW, default=None*/

                            /* entry type optype */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 31;

                            /* Bits[62:32], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Lock : 1;

                            /* Bits[63:63], Access Type=RW, default=None*/

                            /* Lock bit - set when FIT error is written to FSCP */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_FIT_BIOS_ERROR_REGISTER;

/**
  Returns indication per thread whether PPPE load was successful or not (partial success)
**/
#define ADL_MSR_BIOS_DEBUG 0x000000A7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 31;

                            /* Bits[30:0], Access Type=RW, default=0x00000000*/

                            /* RESERVED */
    UINT32 PatchRevIdStatusPppeLoadFail : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /*
                               indication whether PPPE load was successful or
                               not (partial success)
                            */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_BIOS_DEBUG_REGISTER;

/**
  This register contains read-only package level ratio information
**/
#define ADL_MSR_PLATFORM_INFO 0x000000CE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 8;

                            /* Bits[7:0], Access Type=ROS_V, default=0x00000000*/

                            /* Reserved */
    UINT32 MaxNonTurboLimRatio : 8;

                            /* Bits[15:8], Access Type=ROS_V, default=0x00000000*/

                            /* The Maximum Non-Turbo Ratio */
    UINT32 SmmSaveCap : 1;

                            /* Bits[16:16], Access Type=RO_V, default=0x00000001*/

                            /*
                               When set to '1' indicates this feature exists
                               and is configured by SMM_SAVE_CONTROL
                            */
    UINT32 RarEn : 1;

                            /* Bits[17:17], Access Type=RO_V, default=0x00000000*/

                            /* When set to '1' indicates RAR feature exists */
    UINT32 Rsvd18 : 5;

                            /* Bits[22:18], Access Type=ROS_V, default=0x00000000*/

                            /* Reserved */
    UINT32 PpinCap : 1;

                            /* Bits[23:23], Access Type=ROS_V, default=0x00000000*/

                            /*
                               When set to 1, indicates that this part supports
                               the Protected Processor Inventory Number (PPIN)
                               feature.
                            */
    UINT32 OcvoltOvrdAvail : 1;

                            /* Bits[24:24], Access Type=RO_V, default=0x00000000*/

                            /*
                               0b Indicates that the part does not support
                               Voltage override overclocking. 1b Indicates that
                               the part supports Voltage override overclocking.
                            */
    UINT32 FivrRfiTuningAvail : 1;

                            /* Bits[25:25], Access Type=ROS_V, default=0x00000000*/

                            /* FIVR RFI Tuning Support */
    UINT32 Dcu16kModeAvail : 1;

                            /* Bits[26:26], Access Type=ROS_V, default=0x00000000*/

                            /*
                               0b Indicates that the part does not support the
                               16K DCU mode. 1b Indicates that the part
                               supports 16K DCU mode.
                            */
    UINT32 SamplePart : 1;

                            /* Bits[27:27], Access Type=ROS_V, default=0x00000000*/

                            /*
                               A value of 1 indicates the processor is a
                               preproduction sample and a property of Intel, a
                               value of 0 indicates the part is intended for
                               production.
                            */
    UINT32 PrgTurboRatioEn : 1;

                            /* Bits[28:28], Access Type=RO_V, default=0x00000001*/

                            /*
                               Programmable Turbo Ratios per number of Active
                               Cores 0 = Programming Not Allowed 1 =
                               Programming Allowed
                            */
    UINT32 PrgTdpLimEn : 1;

                            /* Bits[29:29], Access Type=ROS_V, default=0x00000001*/

                            /*
                               Programmable TDP Limits for Turbo Mode. 0 =
                               Programming Not Allowed 1 = Programming Allowed
                            */
    UINT32 PrgTjOffsetEn : 1;

                            /* Bits[30:30], Access Type=ROS_V, default=0x00000001*/

                            /*
                               Programmable TJ Offset Enable. 0 = Programming
                               Not Allowed 1 = Programming Allowed
                            */
    UINT32 CpuidFaultingEn : 1;

                            /* Bits[31:31], Access Type=ROS_V, default=0x00000001*/

                            /*
                               When set to 1 indicates that the processor
                               supports raising a #GP if CPUID is executed when
                               not in SMM and the CPL > 0. When this bit is
                               set, it indicates that MISC_FEATURE_ENABLES[0]
                               can be written by a VMM.
                            */
    UINT32 LpmSupport : 1;

                            /* Bits[32:32], Access Type=ROS_V, default=0x00000000*/

                            /*
                               0 - Low Power Mode not Supported 1 - Low Power
                               Mode Supported
                            */
    UINT32 ConfigTdpLevels : 2;

                            /* Bits[34:33], Access Type=ROS_V, default=0x00000000*/

                            /*
                               Configurable TDP Levels 00 Config TDP not
                               supported 01 One additional TDP level supported
                               10 Two additional TDP levels supported 11
                               Reserved
                            */
    UINT32 PfatEnable : 1;

                            /* Bits[35:35], Access Type=ROS_V, default=0x00000000*/

                            /*
                               BIOS GUARD (PFAT) Enable. 0 = PFAT is disabled 1
                               = PFAT is enabled
                            */
    UINT32 Peg2dmidisEn : 1;

                            /* Bits[36:36], Access Type=RO_V, default=0x00000001*/

                            /*
                               0 = PEG2DMIDIS is disabled 1 = PEG2DMIDIS is
                               enabled
                            */
    UINT32 TimedMwaitEnable : 1;

                            /* Bits[37:37], Access Type=ROS_V, default=0x00000000*/

                            /*
                               Timed MWAIT Enable. 0 = Timed MWAIT is disabled
                               1 = Timed MWAIT is enabled
                            */
    UINT32 AsaEn : 1;

                            /* Bits[38:38], Access Type=ROS_V, default=0x00000001*/

                            /*
                               ASA Enable. 0 = ASA is disabled 1 = ASA is
                               enabled
                            */
    UINT32 Rsvd39 : 1;

                            /* Bits[39:39], Access Type=ROS_V, default=0x00000000*/

                            /* Reserved */
    UINT32 MaxEfficiencyRatio : 8;

                            /* Bits[47:40], Access Type=ROS_V, default=0x00000000*/

                            /*
                               Maximum Efficiency Ratio. This is given in units
                               of 100 MHz.
                            */
    UINT32 MinOperatingRatio : 8;

                            /* Bits[55:48], Access Type=RO_V, default=0x00000008*/

                            /* Minimum Supported Ratio in units of 100MHz */
    UINT32 Rsvd56 : 1;

                            /* Bits[56:56], Access Type=ROS_V, default=0x00000000*/

                            /* Reserved */
    UINT32 EdramEnable : 1;

                            /* Bits[57:57], Access Type=ROS_V, default=0x00000000*/

                            /*
                               Indicates to BIOS that memory-side ACPI tables
                               can be used
                            */
    UINT32 Sxp2lmEnable : 1;

                            /* Bits[58:58], Access Type=ROS_V, default=0x00000000*/

                            /*
                               Indicates to BIOS that the FME_ACTIVATE MSR can
                               be setup Indicates to BIOS that the FZM
                               functionality can be enabled
                            */
    UINT32 SmmSupovrStateLockEnable : 1;

                            /* Bits[59:59], Access Type=ROS_V, default=0x00000001*/

                            /*
                               Indicates to BIOS that the SMM_SUPOVR_STATE_LOCK
                               MSR can be setup. This bit is unconditionally
                               set. [IntelRsvd]This bit is unconditionally set
                               for SoCs that support SNC[/IntelRsvd]
                            */
    UINT32 TioEnable : 1;

                            /* Bits[60:60], Access Type=ROS_V, default=0x00000000*/

                            /*
                               Indicates to BIOS that the Trusted IO (TIO) MSRs
                               can be accessed Indicates to BIOS that the
                               Trusted IO (TIO) functionality can be enabled
                               The value of this bit is the same as FUSE_TIO
                            */
    UINT32 Rsvd61 : 3;

                            /* Bits[63:61], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PLATFORM_INFO_REGISTER;

/**
  architectural MSR to enumerate model-specific features
**/
#define ADL_MSR_CORE_CAPABILITIES 0x000000CF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 StlbQosSupported : 1;

                            /* Bits[0:0], Access Type=RO_V, default=0x00000000*/

                            /*
                               Indicates that processor supports STLB QoS
                               functionality
                            */
    UINT32 RarSupported : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates that processor supports Remote Action
                               Request functionality
                            */
    UINT32 FusaSupported : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates that processor supports Functional
                               Safety
                            */
    UINT32 Rsvd3 : 1;

                            /* Bits[3:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 UcLockDisableSupported : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               When set to 1, processor supports UC load lock
                               disable feature.
                            */
    UINT32 Rsvd5 : 27;

                            /* Bits[31:5], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CORE_CAPABILITIES_REGISTER;

/**
  Allows the OS to control the maximum allowed time to nap in C0 sub-state, and to control whether C0.2 is supported.
**/
#define ADL_MSR_UMWAIT_CONTROL 0x000000E1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 C01Only : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /*
                               C0.2 is not allowed: 0 means allowed, 1 means
                               all C0.2 requests revert to C0.1
                            */
    UINT32 Rsvd1 : 1;

                            /* Bits[1:1], Access Type=RW, default=None*/

                            /* Reserved MBZ */
    UINT32 MaxNap : 30;

                            /* Bits[31:2], Access Type=RW, default=None*/

                            /*
                               MAX allowed nap time in TSC units. All-zero
                               value indicates OS posed no limit on nap time.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_UMWAIT_CONTROL_REGISTER;

/**
  Various controls for RAR and Virtual RAR
**/
#define ADL_MSR_RAR_CONTROL 0x000000ED

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reserved0 : 28;

                            /* Bits[27:0], Access Type=RW, default=0x00000000*/

                            /* Reserved bits */
    UINT32 VrarIgnoreIf : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /*
                               When set virtual RAR event will not be masked by
                               EFLAAGS.IF
                            */
    UINT32 Rsvd29 : 1;

                            /* Bits[29:29], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RarIgnoreIf : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /*
                               When set RAR event will not be masked by
                               EFLAAGS.IF
                            */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_RAR_CONTROL_REGISTER;

/**
  Physical address to the base of RAR action vector
**/
#define ADL_MSR_RAR_ACTION_VECTOR_BASE 0x000000EE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reserved0 : 6;

                            /* Bits[5:0], Access Type=RW, default=None*/

                            /*
                               Lower bits of physical address to the base of
                               RAR action vector. Must be zero to maintain
                               alignment to cacheline of 64B.
                            */
    UINT32 PhysicalAddr0 : 26;

                            /* Bits[31:6], Access Type=RW, default=None*/

                            /*
                               Physical address to the base of RAR action
                               vector
                            */
    UINT32 PhysicalAddr1 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /*
                               Physical address to the base of RAR action
                               vector
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_RAR_ACTION_VECTOR_BASE_REGISTER;

/**
  Physical address to the base of RAR payload table
**/
#define ADL_MSR_RAR_PAYLOAD_TABLE_BASE 0x000000EF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reserved0 : 12;

                            /* Bits[11:0], Access Type=RW, default=None*/

                            /*
                               Lower bits of physical address to the base of
                               RAR action vector. Must be zero to maintain
                               alignment to 4KB page.
                            */
    UINT32 PhysicalAddr0 : 20;

                            /* Bits[31:12], Access Type=RW, default=None*/

                            /*
                               Physical address to the base of RAR payload
                               table
                            */
    UINT32 PhysicalAddr1 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /*
                               Physical address to the base of RAR payload
                               table
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_RAR_PAYLOAD_TABLE_BASE_REGISTER;

/**
  Virtual RO MSR for RAR capabilities information.
**/
#define ADL_MSR_RAR_INFO 0x000000F0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PayloadTypeSupport : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x0000003F*/

                            /*
                               Supported payloads vector. A value of 1 inbit
                               position i indicates that payload i is supported
                            */
    UINT32 MaxPayloadIndexSupported : 32;

                            /* Bits[63:32], Access Type=RO_V, default=0x0000003F*/

                            /* Maximum supported payload index */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_RAR_INFO_REGISTER;

/**
  Control for RAR UC load timeout. Write of 0 value will disable UC load timeout. Write of non 0 value, will set a threshold for RAR UC load timeout.
**/
#define ADL_MSR_RAR_TIMER_CONFIG 0x000000F1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threshold : 8;

                            /* Bits[7:0], Access Type=RW, default=None*/

                            /*
                               Threashold in micro seconds for RAR UC load
                               timeout
                            */
    UINT32 Rsvd8 : 24;

                            /* Bits[31:8], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_RAR_TIMER_CONFIG_REGISTER;

/**
  MTRR Capabilities MSR
**/
#define ADL_MSR_MTRRCAP 0x000000FE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Vcnt : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* Number of variable range registers */
    UINT32 Fix : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /* Fixed range registers supported if set */
    UINT32 Rsvd9 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Wc : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /* Write-Combining memory type supported if set. */
    UINT32 Smrr : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* SMRRs are supported if set. */
    UINT32 Prmrr : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /* PRMRR MSRs are supported. */
    UINT32 Smrr2 : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /* SMRR2 is supported if set. */
    UINT32 SmrrLock : 1;

                            /* Bits[14:14], Access Type=RW, default=0x00000000*/

                            /* SMRRs can be locked if set. */
    UINT32 Seamrr : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* SEAMRR register exists if set */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_MTRRCAP_REGISTER;

/**
  Controls Array PBIST triggered from ucode as part of FUSA.
**/
#define ADL_MSR_CORE_BIST 0x00000105

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 BistArray : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Array to apply PBIST (WRITE). Array not
                               processed (READ).
                            */
    UINT32 Bank : 8;

                            /* Bits[39:32], Access Type=RW, default=0x00000000*/

                            /*
                               Array bank of the [least significant set bit]
                               array indicated in EAX to start BIST (WRITE).
                               Array bank interrupted (READ)
                            */
    UINT32 Dword : 8;

                            /* Bits[47:40], Access Type=RW, default=0x00000000*/

                            /*
                               Array dword of the [least significant set bit]
                               array indicated in EAX to start BIST (WRITE).
                               Array dword interrupted (READ)
                            */
    UINT32 Rsvd48 : 15;

                            /* Bits[62:48], Access Type=RW, default=0x00000000*/

                            /* Reserved. */
    UINT32 CtrlResult : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /*
                               Bit to indicate if the operation cannot be
                               interrupted (WRITE). Result PASS/FAIL (READ)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CORE_BIST_REGISTER;

/**
  Controls error injections to FUSA BIST Arrays
**/
#define ADL_MSR_CORE_ARRAY_ERROR_INJECTION 0x00000106

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 BistArray : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               BIST Array to inject error. restrictions: This
                               MSR can ONLY be accessed from FUSA ACM.
                            */
    UINT32 ErrorAddr : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /*
                               Array address to inject error. restrictions:
                               This MSR can ONLY be accessed from FUSA ACM.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CORE_ARRAY_ERROR_INJECTION_REGISTER;

/**
  Specified IDI Parity Error Injection SRC Agent
**/
#define ADL_MSR_PERRINJ_AT_IP 0x00000107

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 SrcAgent : 31;

                            /* Bits[30:0], Access Type=RW, default=0x00000000*/

                            /*
                               Source Agent of FUSA IDI Parity Injection.
                               restrictions: BIOS Boot SW will set and clear
                               the value.
                            */
    UINT32 Enable : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /* LOCK bit to indicate the MSR has been programmed */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PERRINJ_AT_IP_REGISTER;

/**
  Control Parity Error Injection
**/
#define ADL_MSR_PERRINJ_CTRL 0x00000108

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Payload : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Payload for Parity Injection */
    UINT32 GenMcerr : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /*
                               If set, then injects MCERR instead of injecting
                               parity error for MLC/Core
                            */
    UINT32 Rsvd33 : 31;

                            /* Bits[63:33], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PERRINJ_CTRL_REGISTER;

/**

**/
#define ADL_MSR_ARCH_CAPABILITIES 0x0000010A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Gpzv3L1tfHwMit : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 EnhIbrs : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Rsvd2 : 30;

                            /* Bits[31:2], Access Type=RW, default=None*/

                            /*  */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_ARCH_CAPABILITIES_REGISTER;

/**
  mmcfg rule
**/
#define ADL_MSR_MMCFG_RULE_CFG 0x00000129

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RuleEnable : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Enable for this MMCFG interleave decoder */
    UINT32 LengthField : 3;

                            /* Bits[3:1], Access Type=RW, default=0x00000004*/

                            /* documents max bus # */
    UINT32 Rsvd4 : 2;

                            /* Bits[5:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ValidTargets : 8;

                            /* Bits[13:6], Access Type=RW, default=0x000000FF*/

                            /* valid targets */
    UINT32 Rsvd14 : 12;

                            /* Bits[25:14], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BaseAddress0 : 6;

                            /* Bits[31:26], Access Type=RW, default=0x00000000*/

                            /* base addr */
    UINT32 BaseAddress1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* base addr */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_MMCFG_RULE_CFG_REGISTER;

/**
  mmcfg rule
**/
#define ADL_MSR_MMCFG_RULE_TARGET_LIST 0x0000012A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Package0 : 4;

                            /* Bits[3:0], Access Type=RW, default=0x00000008*/

                            /* target 0 */
    UINT32 Package1 : 4;

                            /* Bits[7:4], Access Type=RW, default=0x00000008*/

                            /* target 1 */
    UINT32 Package2 : 4;

                            /* Bits[11:8], Access Type=RW, default=0x00000008*/

                            /* target 2 */
    UINT32 Package3 : 4;

                            /* Bits[15:12], Access Type=RW, default=0x00000008*/

                            /* target 3 */
    UINT32 Package4 : 4;

                            /* Bits[19:16], Access Type=RW, default=0x00000008*/

                            /* target 4 */
    UINT32 Package5 : 4;

                            /* Bits[23:20], Access Type=RW, default=0x00000008*/

                            /* target 5 */
    UINT32 Package6 : 4;

                            /* Bits[27:24], Access Type=RW, default=0x00000008*/

                            /* target 6 */
    UINT32 Package7 : 4;

                            /* Bits[31:28], Access Type=RW, default=0x00000008*/

                            /* target 7 */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_MMCFG_RULE_TARGET_LIST_REGISTER;

/**
  SNC_CONFIG_BASE register decription
**/
#define ADL_MSR_SNC_CONFIG 0x00000152

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 SncEnable : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* SNC Enable bit */
    UINT32 SncIndicationEnable : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* SNC Enable bit */
    UINT32 NumberOfClusters : 2;

                            /* Bits[3:2], Access Type=RW_V, default=0x00000000*/

                            /* Number Of Clusters */
    UINT32 Cluster1Base : 5;

                            /* Bits[8:4], Access Type=RW_V, default=0x00000000*/

                            /* Cluster 2 Base */
    UINT32 Cluster2Base : 5;

                            /* Bits[13:9], Access Type=RW_V, default=0x00000000*/

                            /* Cluster 3 Base */
    UINT32 Cluster3Base : 5;

                            /* Bits[18:14], Access Type=RW_V, default=0x00000000*/

                            /* Cluster 4 Base */
    UINT32 Rsvd19 : 9;

                            /* Bits[27:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SncLock : 1;

                            /* Bits[28:28], Access Type=RW_V, default=0x00000000*/

                            /*
                               Due to SKL B0 freeze this late arrving bit is
                               implemented in
                               FSCP_CR_MISC_FEATURE_ENABLES[SNC_LOCK]
                            */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_SNC_CONFIG_REGISTER;

/**
  Current performance status
**/
#define ADL_MSR_PERF_STATUS 0x00000198

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 8;

                            /* Bits[7:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Ratio : 7;

                            /* Bits[14:8], Access Type=RO_V, default=0x00000000*/

                            /* Current core P-state ratio value 14:8 */
    UINT32 Rsvd15 : 17;

                            /* Bits[31:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Voltage : 16;

                            /* Bits[47:32], Access Type=RO_V, default=0x00000000*/

                            /*
                               Indicates the current operating voltage in 3.13
                               format i.e. current voltage = float([47:32] /
                               (2^13)).
                            */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PERF_STATUS_REGISTER;

/**
  Legacy Performance Control MSR. SW requests a new Performance state (P-State) by writing to this MSR.
  [IntelRsvd]ARCH MSR in core - P-state control register reflected into P-STATE_REQ[/IntelRsvd]
**/
#define ADL_MSR_PERF_CTL 0x00000199

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 VReq : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* Voltage request - Not used = legacy */
    UINT32 PReq : 7;

                            /* Bits[14:8], Access Type=RW, default=0x00000000*/

                            /*
                               Requested P-state ratio value for this logical
                               processor.
                            */
    UINT32 Rsvd15 : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Pqosofst : 6;

                            /* Bits[21:16], Access Type=RW, default=0x00000000*/

                            /* P/H P-State QoS offset */
    UINT32 Rsvd22 : 10;

                            /* Bits[31:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 TurboDis : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /*
                               1 = Turbo Mode disabled, 0=Turbo Mode enabled.
                               Note: This Turbo Mode Disable exists on each
                               logical processor; however, setting the Turbo
                               Mode Disable on any logical processor forces
                               Turbo Mode to be disabled for all logical
                               processors in the entire processor package. BIOS
                               should not use this Turbo Mode Disable since it
                               does not change the Turbo Mode feature flag.
                               This Turbo Mode Disable is intended for OS use
                               only.
                            */
    UINT32 Rsvd33 : 31;

                            /* Bits[63:33], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PERF_CTL_REGISTER;

/**
  Contains status information about the processor's thermal sensor and automatic thermal monitoring facilities.
**/
#define ADL_MSR_THERM_STATUS 0x0000019C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ThermalMonitorStatus : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000000*/

                            /*
                               Status bit indicating that the Thermal Monitor
                               has tripped and is currently thermally
                               throttling.
                            */
    UINT32 ThermalMonitorLog : 1;

                            /* Bits[1:1], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Sticky log bit indicating that the core has seen
                               a thermal monitor event since the last time SW
                               cleared this bit. This bit is set by HW on a 0
                               to 1 transition of THERMAL_MONITOR_STATUS.
                            */
    UINT32 ProchotStatus : 1;

                            /* Bits[2:2], Access Type=RO, default=0x00000000*/

                            /*
                               Status bit indicating that xxPROCHOT# is
                               currently being asserted.
                            */
    UINT32 ProchotLog : 1;

                            /* Bits[3:3], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Sticky log bit indicating that xxPROCHOT# has
                               been asserted since the last time this bit was
                               cleared by SW. This bit is set by HW on a 0 to 1
                               transition of PROCHOT_STATUS.
                            */
    UINT32 OutOfSpecStatus : 1;

                            /* Bits[4:4], Access Type=RO, default=0x00000000*/

                            /*
                               Status bit indicating that the processor is
                               operating out of its thermal specification. Once
                               set, this bit should only clear on a reset.
                            */
    UINT32 OutOfSpecLog : 1;

                            /* Bits[5:5], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Sticky log bit indicating that the processor
                               operating out of its thermal specification since
                               the last time this bit was cleared. This bit is
                               set by HW on a 0 to 1 transition of
                               OUT_OF_SPEC_STATUS.
                            */
    UINT32 Threshold1Status : 1;

                            /* Bits[6:6], Access Type=RO, default=0x00000000*/

                            /*
                               Indicates that the current temperature is higher
                               than or equal to Threshold 1 temperature.
                            */
    UINT32 Threshold1Log : 1;

                            /* Bits[7:7], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Sticky log bit that asserts on a 0 to 1 or a 1
                               to 0 transition of the THRESHOLD1_STATUS bit.
                               This bit is set by HW and cleared by SW.
                            */
    UINT32 Threshold2Status : 1;

                            /* Bits[8:8], Access Type=RO, default=0x00000000*/

                            /*
                               Indicates that the current temperature is higher
                               than or equal to Threshold 2 temperature.
                            */
    UINT32 Threshold2Log : 1;

                            /* Bits[9:9], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Sticky log bit that asserts on a 0 to 1 or a 1
                               to 0 transition of the THRESHOLD2_STATUS bit.
                               This bit is set by HW and cleared by SW.
                            */
    UINT32 PowerLimitationStatus : 1;

                            /* Bits[10:10], Access Type=RO, default=0x00000000*/

                            /*
                               RO - Indicates whether the current P-state is
                               limited by power limitation. For legacy P state
                               method, this bit will be set only if the P-state
                               is limit below the guaranty level
                            */
    UINT32 PowerLimitationLog : 1;

                            /* Bits[11:11], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               R/WC0 - Sticky bit which indicates whether the
                               current P-state is limited by power limitation
                               since the last clearing of this bit or a reset.
                               SW may clear this bit by writing a zero (0). For
                               legacy P state method, this bit will be set only
                               if the P-state is limit below the guaranty level
                            */
    UINT32 CurrentLimitStatus : 1;

                            /* Bits[12:12], Access Type=RO, default=0x00000000*/

                            /*
                               RO - If set (1), indicates an electrical current
                               limit (e.g. Electrical Design Point/IccMax) is
                               being exceeded and is adversely impacting energy
                               efficiency optimizations
                            */
    UINT32 CurrentLimitLog : 1;

                            /* Bits[13:13], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               R/WC0 - If set (1), an electrical current limit
                               has been exceeded that has adversely impacted
                               energy efficiency optimizations since the last
                               clearing of this bit or a reset. This bit is
                               sticky, software may clear this bit by writing a
                               zero (0).
                            */
    UINT32 CrossDomainLimitStatus : 1;

                            /* Bits[14:14], Access Type=RO, default=0x00000000*/

                            /*
                               RO - If set (1), indicates another hardware
                               domain (e.g. processor graphics) is currently
                               limiting energy efficiency optimizations in the
                               processor core domain.
                            */
    UINT32 CrossDomainLimitLog : 1;

                            /* Bits[15:15], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               R/WC0 - If set (1), indicates another hardware
                               domain (e.g. processor graphics) has limited
                               energy efficiency optimizations in the processor
                               core domain since the last clearing of this bit
                               or a reset. This bit is sticky, software may
                               clear this bit by writing a zero (0).
                            */
    UINT32 Temperature : 8;

                            /* Bits[23:16], Access Type=RO, default=0x00000000*/

                            /*
                               This is a temperature offset in degrees C below
                               theTJ Max temperature. This number is meaningful
                               only if VALID bit in this register is set.
                            */
    UINT32 Rsvd24 : 3;

                            /* Bits[26:24], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Resolution : 4;

                            /* Bits[30:27], Access Type=RO, default=0x00000001*/

                            /* Supported resolution in degrees C. */
    UINT32 Valid : 1;

                            /* Bits[31:31], Access Type=RO, default=0x00000000*/

                            /*
                               This bit indicates that the TEMPERATURE field is
                               valid. It is set by PCODE if the temperature is
                               within valid thermal sensor range.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_THERM_STATUS_REGISTER;

/**
  Offcore Response Event Select Register
  " seq has 2 instances in addresses range 0x1A6 to 0x1A7"
**/
#define ADL_MSR_OFFCORE_RSP_0_0 0x000001A6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reqtype : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /*
                               Request Type: MSR Bit 0 = Demand Data Rd = DCU
                               reads (includes partials) MSR Bit 1 = Demand RFO
                               = DCU RFOs MSR Bit 2 = Demand Ifetch = IFU
                               Fetches MSR Bit 3 = Writeback = Core modified WB
                               MSR Bit 4 = PF Data Rd = MPL Reads MSR Bit 5 =
                               PF RFO = MPL RFOs MSR Bit 6 = PF Ifetch = MPL
                               Fetches MSR Bit 7 = MLC prefetch to LLC - Load
                               (exclude LRUhints) MSR Bit 8 = MLC prefetch to
                               LLC - RFO MSR Bit 9 = MLC prefetch to LLC - Code
                               MSR Bit 10 = L1 Prefetch MSR Bit 11 = Write
                               Combining MSR Bit 12 = Core non-modified WB MSR
                               Bit 13 = LLCpref of load/code/RFO MSR Bit 14 =
                               SPFW (GLC) MSR Bit 15 = Other
                            */
    UINT32 Any : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* Account for any snoop response from Uncore. */
    UINT32 NoSupplierDetails : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* No Supplier Details. */
    UINT32 L3HitMState : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /* L3 Hit M-State. */
    UINT32 L3HitEState : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /* L3 Hit E-State. */
    UINT32 L3HitSState : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /* L3 Hit S-State. */
    UINT32 L3HitFState : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /* L3 Hit F-State. */
    UINT32 L4HitLocalNode : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /* L4 Hit Local Node. */
    UINT32 L4HitRemote0hop : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 0 Hop */
    UINT32 L4HitRemote1hop : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 1 Hop */
    UINT32 L4HitRemote2hop : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 2 Hop. */
    UINT32 LlcMissLocalNode : 1;

                            /* Bits[26:26], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Local Node. */
    UINT32 LlcMissRemote0hop : 1;

                            /* Bits[27:27], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 0 Hop. */
    UINT32 LlcMissRemote1hop : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 1 Hop. */
    UINT32 LlcMissRemote2hop : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 2 or more Hop. */
    UINT32 SplHit : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* SPL Hit */
    UINT32 None : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /* No details as to Snoop-related info. */
    UINT32 NotNeeded : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* No snoop was neeeded to satisfy the request. */
    UINT32 Miss : 1;

                            /* Bits[33:33], Access Type=RW, default=0x00000000*/

                            /* No snoop was neeeded to satisfy the request. */
    UINT32 HitNoFwd : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and it Hits in at least one
                               snooped cache. Hit denotes a cache-line was
                               valid before snoop effect
                            */
    UINT32 HitWithFwd : 1;

                            /* Bits[35:35], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and data was Forwarded from a
                               remote socket.
                            */
    UINT32 Hitm : 1;

                            /* Bits[36:36], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and it HitMed in local or
                               remote cache. HitM denotes a cache-line was
                               modified before snoop effect.
                            */
    UINT32 NonDram : 1;

                            /* Bits[37:37], Access Type=RW, default=0x00000000*/

                            /* Target was non-DRAM system address. */
    UINT32 Spare : 3;

                            /* Bits[40:38], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Rsvd41 : 23;

                            /* Bits[63:41], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_OFFCORE_RSP_0_0_REGISTER;

/**
  Offcore Response Event Select Register
  " seq has 2 instances in addresses range 0x1A6 to 0x1A7"
**/
#define ADL_MSR_OFFCORE_RSP_1_1 0x000001A7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reqtype : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /*
                               Request Type: MSR Bit 0 = Demand Data Rd = DCU
                               reads (includes partials) MSR Bit 1 = Demand RFO
                               = DCU RFOs MSR Bit 2 = Demand Ifetch = IFU
                               Fetches MSR Bit 3 = Writeback = Core modified WB
                               MSR Bit 4 = PF Data Rd = MPL Reads MSR Bit 5 =
                               PF RFO = MPL RFOs MSR Bit 6 = PF Ifetch = MPL
                               Fetches MSR Bit 7 = MLC prefetch to LLC - Load
                               (exclude LRUhints) MSR Bit 8 = MLC prefetch to
                               LLC - RFO MSR Bit 9 = MLC prefetch to LLC - Code
                               MSR Bit 10 = L1 Prefetch MSR Bit 11 = Write
                               Combining MSR Bit 12 = Core non-modified WB MSR
                               Bit 13 = LLCpref of load/code/RFO MSR Bit 14 =
                               SPFW (GLC) MSR Bit 15 = Other
                            */
    UINT32 Any : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* Account for any snoop response from Uncore. */
    UINT32 NoSupplierDetails : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* No Supplier Details. */
    UINT32 L3HitMState : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /* L3 Hit M-State. */
    UINT32 L3HitEState : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /* L3 Hit E-State. */
    UINT32 L3HitSState : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /* L3 Hit S-State. */
    UINT32 L3HitFState : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /* L3 Hit F-State. */
    UINT32 L4HitLocalNode : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /* L4 Hit Local Node. */
    UINT32 L4HitRemote0hop : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 0 Hop */
    UINT32 L4HitRemote1hop : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 1 Hop */
    UINT32 L4HitRemote2hop : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 2 Hop. */
    UINT32 LlcMissLocalNode : 1;

                            /* Bits[26:26], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Local Node. */
    UINT32 LlcMissRemote0hop : 1;

                            /* Bits[27:27], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 0 Hop. */
    UINT32 LlcMissRemote1hop : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 1 Hop. */
    UINT32 LlcMissRemote2hop : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 2 or more Hop. */
    UINT32 SplHit : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* SPL Hit */
    UINT32 None : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /* No details as to Snoop-related info. */
    UINT32 NotNeeded : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* No snoop was neeeded to satisfy the request. */
    UINT32 Miss : 1;

                            /* Bits[33:33], Access Type=RW, default=0x00000000*/

                            /* No snoop was neeeded to satisfy the request. */
    UINT32 HitNoFwd : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and it Hits in at least one
                               snooped cache. Hit denotes a cache-line was
                               valid before snoop effect
                            */
    UINT32 HitWithFwd : 1;

                            /* Bits[35:35], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and data was Forwarded from a
                               remote socket.
                            */
    UINT32 Hitm : 1;

                            /* Bits[36:36], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and it HitMed in local or
                               remote cache. HitM denotes a cache-line was
                               modified before snoop effect.
                            */
    UINT32 NonDram : 1;

                            /* Bits[37:37], Access Type=RW, default=0x00000000*/

                            /* Target was non-DRAM system address. */
    UINT32 Spare : 3;

                            /* Bits[40:38], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Rsvd41 : 23;

                            /* Bits[63:41], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_OFFCORE_RSP_1_1_REGISTER;

/**
  Contains status information about the package's thermal sensor.
**/
#define ADL_MSR_PACKAGE_THERM_STATUS 0x000001B1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ThermalMonitorStatus : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000000*/

                            /*
                               Status bit indicating that any of the package
                               thermal monitor have tripped and the package is
                               currently thermally throttling.
                            */
    UINT32 ThermalMonitorLog : 1;

                            /* Bits[1:1], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Sticky log bit indicating that the package has
                               seen a thermal monitor event since the last time
                               SW cleared this bit. Set by HW on a 0 to 1
                               transition of Thermal_Monitor_Status.
                            */
    UINT32 ProchotStatus : 1;

                            /* Bits[2:2], Access Type=RO, default=0x00000000*/

                            /*
                               Status bit indicating that xxPROCHOT# is
                               currently being asserted.
                            */
    UINT32 ProchotLog : 1;

                            /* Bits[3:3], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Sticky log bit indicating that xxPROCHOT# has
                               been asserted since the last time this bit was
                               cleared by SW. Set by HW on a 0 to 1 transition
                               of Prochot_Status.
                            */
    UINT32 OutOfSpecStatus : 1;

                            /* Bits[4:4], Access Type=RO, default=0x00000000*/

                            /*
                               Status bit indicating that the processor is
                               operating out of its thermal specification.
                            */
    UINT32 OutOfSpecLog : 1;

                            /* Bits[5:5], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Sticky log bit indicating that the processor
                               operating out of its thermal specification since
                               the last time this bit was cleared. Set by HW on
                               a 0 to 1 transition of Out_of_Spec_Status
                            */
    UINT32 Threshold1Status : 1;

                            /* Bits[6:6], Access Type=RO, default=0x00000000*/

                            /*
                               Indicates that the current temperature (bits
                               22:16 in this register) is higher than or equal
                               to the Threshold1 defined in the
                               IA32_PACKAGE_THERM_INTERRUPT MSR. Note that
                               because temperature and thresholds are defined
                               as negative offsets, a higher number means a
                               lower temperature.
                            */
    UINT32 Threshold1Log : 1;

                            /* Bits[7:7], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Sticky log bit that asserts on a 0 to 1 or 1 to
                               0 transition of the Threshold1_Status bit. HW
                               controls this transition.
                            */
    UINT32 Threshold2Status : 1;

                            /* Bits[8:8], Access Type=RO, default=0x00000000*/

                            /*
                               Indicates that the current temperature (bits
                               22:16 of this register) is higher than or equal
                               to the Threshold2 defined in the
                               IA32_PACKAGE_THERM_INTERRUPT MSR. Note that
                               because temperature and thresholds are defined
                               as negative offsets, a higher number means a
                               lower temperature.
                            */
    UINT32 Threshold2Log : 1;

                            /* Bits[9:9], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Sticky log bit that asserts on a 0 to 1 or 1 to
                               0 transition of the Threshold2_Status bit. HW
                               controls this transition.
                            */
    UINT32 PowerLimitationStatus : 1;

                            /* Bits[10:10], Access Type=RO, default=0x00000000*/

                            /*
                               Status log bit that notifies that either IA is
                               running at P-state below the (max P-state -
                               offset) or that GT is running at P-state below
                               its P1 frequency.
                            */
    UINT32 PowerLimitationLog : 1;

                            /* Bits[11:11], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Sticky log bit that asserts when either IA is
                               running at P-state below the (max P-state -
                               offset) or that Graphics is running at P-state
                               below its P1 frequency. Set by HW on a 0 to 1
                               transition of Power Limitation Status. Cleared
                               by SW.
                            */
    UINT32 Rsvd12 : 4;

                            /* Bits[15:12], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Temperature : 8;

                            /* Bits[23:16], Access Type=RO, default=0x00000000*/

                            /*
                               Temperature in degrees C, relative to the
                               thermal monitor trip temperature.
                            */
    UINT32 Rsvd24 : 3;

                            /* Bits[26:24], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Resolution : 4;

                            /* Bits[30:27], Access Type=RO, default=0x00000001*/

                            /* Supported resolution in degrees C. */
    UINT32 Valid : 1;

                            /* Bits[31:31], Access Type=RO, default=0x00000000*/

                            /*
                               Set if temperature is within the valid thermal
                               sensor range.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PACKAGE_THERM_STATUS_REGISTER;

/**
  Thermal Limitation Interrupt Control.
**/
#define ADL_MSR_PACKAGE_THERM_INTERRUPT 0x000001B2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 HighTempIntEnable : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Enables a thermal interrupt to be generated on
                               the transition from a low-temperature to a high-
                               temperature when set, where 'high temperature'
                               is dicated by the thermal monitor trip
                               temperature minus offset as defined in
                               IA32_TEMPERATURE_TARGET.
                            */
    UINT32 LowTempIntEnable : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               Enables a thermal interrupt to be generated on
                               the transition from a high-temperature to a low-
                               temperature when set, where 'high temperature'
                               is dicated by the thermal monitor trip
                               temperature minus offset as defined in
                               IA32_TEMPERATURE_TARGET.
                            */
    UINT32 ProchotIntEnable : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               Bidirectional PROCHOT# assertion interrupt
                               enable. If set, a thermal interrupt is delivered
                               on the rising edge of xxPROCHOT#.
                            */
    UINT32 Rsvd3 : 1;

                            /* Bits[3:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 OutOfSpecIntEnable : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               Thermal interrupt enable for the Out Of Spec
                               condition which is stored in the Out Of
                               Spec/Critical Temperature status bit in
                               PACKAGE_THERM_STATUS.
                            */
    UINT32 Rsvd5 : 3;

                            /* Bits[7:5], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Threshold1RelTemp : 7;

                            /* Bits[14:8], Access Type=RW, default=0x00000000*/

                            /*
                               This value indicates the offset in degrees below
                               TJ Max Temperature that should trigger a Thermal
                               Threshold 1 trip.
                            */
    UINT32 Threshold1IntEnable : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               Controls the generation of a thermal interrupt
                               whenever the Thermal Threshold 1 Temperature is
                               crossed.
                            */
    UINT32 Threshold2RelTemp : 7;

                            /* Bits[22:16], Access Type=RW, default=0x00000000*/

                            /*
                               This value indicates the offset in degrees below
                               TJ Max Temperature that should trigger a Thermal
                               Threshold 2 trip.
                            */
    UINT32 Threshold2IntEnable : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Controls the generation of a thermal interrupt
                               whenever the Thermal Threshold 2 Temperature is
                               crossed.
                            */
    UINT32 PowerIntEnable : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /*
                               When this bit is set, a thermal interrupt will
                               be sent upon throttling due to power
                               limitations.
                            */
    UINT32 Rsvd25 : 7;

                            /* Bits[31:25], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PACKAGE_THERM_INTERRUPT_REGISTER;

/**
  XFD (which stands for 'Extended Feature Disable') is a new OS capability to avoid the need to allocate XSAVE area memory till first use of a feature. For any bit j supported (where CPUID[0xD][j].ECX[2] == 1, an example for that is the XTILEDATA bit 18), OS will get #NM on first attempt to restore XTILEDATA xsave area if bit j in XFD is set. Then OS can enlarge the OS XSAVE allocated area for the feature j.
**/
#define ADL_MSR_XFD 0x000001C4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mbz0 : 18;

                            /* Bits[17:0], Access Type=RW, default=0x00000000*/

                            /* filter out ring 0 branches */
    UINT32 Xtiledata : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /* disable for xtiledata */
    UINT32 Mbz1 : 13;

                            /* Bits[31:19], Access Type=RW, default=0x00000000*/

                            /* filter out taken conditional branches */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_XFD_REGISTER;

/**
  XFD (which stands for 'Extended Feature Disable') is a new OS capability to avoid the need to allocate XSAVE area memory till first use of a feature. For any bit j supported (where CPUID[0xD][j].ECX[2] == 1, an example for that is the XTILEDATA bit 18), XFD_ERR[j] indicates that we got #NM on first attempt to restore XTILEDATA xsave area where bit j in XFD is set. Then OS can enlarge the OS XSAVE allocated area for the feature and clear the XFD_ERR[j] bit.
**/
#define ADL_MSR_XFD_ERR 0x000001C5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mbz0 : 18;

                            /* Bits[17:0], Access Type=RW, default=0x00000000*/

                            /* filter out ring 0 branches */
    UINT32 Xtiledata : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /* disable for xtiledata */
    UINT32 Mbz1 : 13;

                            /* Bits[31:19], Access Type=RW, default=0x00000000*/

                            /* filter out taken conditional branches */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_XFD_ERR_REGISTER;

/**
  command reg in ACE IP
**/
#define ADL_MSR_DD_THROTTLE_DEACTIVATE 0x000001C7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DedupthrottleCtl : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_DD_THROTTLE_DEACTIVATE_REGISTER;

/**
  Debug MSR for model specific debug features.
**/
#define ADL_MSR_DEBUGCTLMSR 0x000001D9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 1;

                            /* Bits[0:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Btf : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* BTF Branch Trap Flag. */
    UINT32 BusLockDetect : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               Indication to set pend #DB for instruction that
                               acquires BUS_LOCK
                            */
    UINT32 Reserved3 : 3;

                            /* Bits[5:3], Access Type=RW, default=0x00000000*/

                            /* These bits are reserved for future use. */
    UINT32 Tr : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* TR Enable/Disable Execution Trace Messages. */
    UINT32 Bts : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /* Branch trace store */
    UINT32 Btint : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /* Branch trace interrupt */
    UINT32 BtsOffOs : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /* BTS_OFF_OS */
    UINT32 BtsOffUsr : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /* BTS_OFF_USR */
    UINT32 FreezeLbrsOnPmi : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* FREEZE_LBRS_ON_PMI */
    UINT32 FreezePerfmonCtrsOnPmi : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /* FREEZE_PERFMON_CTRS_ON_PMI */
    UINT32 EnablePmiFromUncore : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /*
                               Setting this bit enables a PMI for this thread
                               when the Uncore signals a PMI. For PERFMON
                            */
    UINT32 MachineMonitoringOffInSmm : 1;

                            /* Bits[14:14], Access Type=RW, default=0x00000000*/

                            /*
                               Setting this bit disables Machine Monitoring in
                               SMM
                            */
    UINT32 HlepDebug : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* Enables DR7 debug bit on XBEGIN */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_DEBUGCTLMSR_REGISTER;
/**
  Last Event Record destination IP register (R/W)
**/
#define ADL_MSR_LER_FROM_IP 0x000001DD
/**
  Last Event Record destination IP register (R/W)
**/
#define ADL_MSR_LER_TO_IP 0x000001DE

/**
  Last Event Record info register (R/W)
**/
#define ADL_MSR_LER_INFO 0x000001E0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 32;

                            /* Bits[31:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings
                               match those of IA32_LBR_x_INFO
                            */
    UINT32 Rsvd60 : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /*
                               Undefined, may be zero or non-zero. Writes of
                               non-zero values do not fault, but reads may
                               return a different value.
                            */
    UINT32 TsxAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTsx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined.
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch taken/not-taken resolution
                               (for JCCs) or target (for any indirect branch,
                               including RETs) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LER_INFO_REGISTER;

/**
  Valid PRMRR configurations
**/
#define ADL_MSR_PRMRR_VALID_CONFIG 0x000001FB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Config1m : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* 1M supported MEE size */
    UINT32 Config2m : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* 2M supported MEE size */
    UINT32 Rsvd2 : 3;

                            /* Bits[4:2], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Config32m : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /* 32M supported MEE size */
    UINT32 Config64m : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* 64M supported MEE size */
    UINT32 Config128m : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /* 128M supported MEE size */
    UINT32 Config256m : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /* 256M supported MEE size */
    UINT32 Config512m : 1;

                            /* Bits[9:9], Access Type=RW, default=None*/

                            /* 512M supported MEE size */
    UINT32 Config1g : 1;

                            /* Bits[10:10], Access Type=RW, default=None*/

                            /* 1G supported MEE size */
    UINT32 Rsvd11 : 21;

                            /* Bits[31:11], Access Type=RW, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PRMRR_VALID_CONFIG_REGISTER;
/**
  MC_CTL2 MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_MDF_MERGE0_MC_CTL2 0x00000287
/**
  MC_CTL2 MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_MDF_MERGE1_MC_CTL2 0x00000288
/**
  MC_CTL2 MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_CBO_MERGE0_MC_CTL2 0x00000289
/**
  MC_CTL2 MSR defn for merging of CBo MC banks
  MERGE1 bank will merge CBos 1, 4, 7, 10, 13, 16, 19, 22, 25
**/
#define ADL_MSR_CBO_MERGE1_MC_CTL2 0x0000028A
/**
  MC_CTL2 MSR defn for merging of CBo MC banks
  MERGE2 bank will merge CBos 2, 5, 8, 11, 14, 17, 20, 23, 26
**/
#define ADL_MSR_CBO_MERGE2_MC_CTL2 0x0000028B
/**
  MC_CTL2 MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_M2M_MERGE0_MC_CTL2 0x0000028C
/**
  MC_CTL2 MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_CTL2_0 0x0000028D
/**
  MC_CTL2 MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_CTL2_1 0x0000028E
/**
  MC_CTL2 MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_CTL2_2 0x0000028F
/**
  MC_CTL2 MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_CTL2_3 0x00000290
/**
  MC_CTL2 MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_CTL2_4 0x00000291
/**
  MC_CTL2 MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_CTL2_6 0x00000293
/**
  MC_CTL2 MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_CTL2_7 0x00000294
/**
  MC_CTL2 MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_DEDUP_MERGE0_MC_CTL2 0x0000029D

/**
  Address Match Range Register - Physical Base Control Register for Hidden Lake
**/
#define ADL_MSR_FUSARR_BASE 0x000002C0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 12;

                            /* Bits[11:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /*
                               The 4K-aligned platform physical base addresses
                               of the FUSARR registers. This register protects
                               the IMR/FUSA memory range. restrictions : Set
                               corresponding FUSARR_MASK appropriately for the
                               address.
                            */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               The 4K-aligned platform physical base addresses
                               of the FUSARR registers. This register protects
                               the IMR/FUSA memory range. restrictions : Set
                               corresponding FUSARR_MASK appropriately for the
                               address.
                            */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_FUSARR_BASE_REGISTER;

/**
  Address Match Range Register - Physical Mask Control Register for Hidden Lake
**/
#define ADL_MSR_FUSARR_MASK 0x000002C1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 9;

                            /* Bits[8:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Assist : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               If set, FUSARR matches to the programmed address
                               will invoke ucode's address match handler. If
                               clear, FUSARR matches will "abort" and redirect
                               the access to the abort page and a UC memory
                               type. restrictions : Set corresponding
                               FUSARR_BASE appropriately for the address. Set
                               VLD, ASSIST and MASK.
                            */
    UINT32 L : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /* Lock bit for the FUSARR */
    UINT32 Vld : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* Valid bit for FUSARR */
    UINT32 Mask0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /*
                               The mask value used in MTRR-like address
                               matching of platform. Minimum granularity for
                               matches is 4K (aligned). restrictions : Set
                               corresponding FUSARR_BASE appropriately for the
                               address. Set VLD, MASK.
                            */
    UINT32 Mask1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               The mask value used in MTRR-like address
                               matching of platform. Minimum granularity for
                               matches is 4K (aligned). restrictions : Set
                               corresponding FUSARR_BASE appropriately for the
                               address. Set VLD, MASK.
                            */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_FUSARR_MASK_REGISTER;

/**
  Execute Step #1 of copying and authenticating Scan Program
**/
#define ADL_MSR_COPY_SCAN_HASHES 0x000002C2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ScanProgramSourceAddress0 : 32;

                            /* Bits[31:0], Access Type=RW, default=None*/

                            /* Linear address to base of Scan Program */
    UINT32 ScanProgramSourceAddress1 : 31;

                            /* Bits[62:32], Access Type=RW, default=None*/

                            /* Linear address to base of Scan Program */
    UINT32 Rsvd63 : 1;

                            /* Bits[63:63], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_COPY_SCAN_HASHES_REGISTER;

/**
  Holds result of latest WRMSR(COPY_SCAN_HASHES)
**/
#define ADL_MSR_SCAN_HASHES_STATUS 0x000002C3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ChunkSizeKb : 16;

                            /* Bits[15:0], Access Type=RW, default=None*/

                            /* Chunk Size in KB */
    UINT32 TotalNumberOfChunks : 8;

                            /* Bits[23:16], Access Type=RW, default=None*/

                            /* Total number of chunks in Scan Program */
    UINT32 Rsvd24 : 8;

                            /* Bits[31:24], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ErrorCode : 8;

                            /* Bits[39:32], Access Type=RW, default=None*/

                            /*
                               Error Core of most recent
                               WRMSR(COPY_SCAN_HASHES) execution
                            */
    UINT32 Rsvd40 : 23;

                            /* Bits[62:40], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Lock : 1;

                            /* Bits[63:63], Access Type=RW, default=None*/

                            /*
                               Indication that WRMSR(COPY_SCAN_HASHES) copleted
                               successfully
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_SCAN_HASHES_STATUS_REGISTER;

/**
  Execute Step #2 of copying and authenticating Scan Program - Authenticate and copy single chunk
**/
#define ADL_MSR_AUTHENTICATE_AND_COPY_CHUNK 0x000002C4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ChunkIndex : 8;

                            /* Bits[7:0], Access Type=RW, default=None*/

                            /* Chunk Index */
    UINT32 ScanProgramSourceAddress0 : 24;

                            /* Bits[31:8], Access Type=RW, default=None*/

                            /* Linear address to base of Scan Program */
    UINT32 ScanProgramSourceAddress1 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /* Linear address to base of Scan Program */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_AUTHENTICATE_AND_COPY_CHUNK_REGISTER;

/**
  Holds result of latest WRMSR(AUTHENTICATE_AND_COPY_CHUNK)
**/
#define ADL_MSR_CHUNKS_AUTHENTICATION_STATUS 0x000002C5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 NumValidChunks : 8;

                            /* Bits[7:0], Access Type=RW, default=None*/

                            /*
                               Total number of Valid chunks in Chunks Status
                               bytes
                            */
    UINT32 TotalNumberOfChunks : 8;

                            /* Bits[15:8], Access Type=RW, default=None*/

                            /* Total number of chunks in Scan Program */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ErrorCode : 8;

                            /* Bits[39:32], Access Type=RW, default=None*/

                            /*
                               Error Core of most recent
                               WRMSR(COPY_SCAN_HASHES) execution
                            */
    UINT32 Rsvd40 : 24;

                            /* Bits[63:40], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CHUNKS_AUTHENTICATION_STATUS_REGISTER;

/**
  Runs FUSA scan program
**/
#define ADL_MSR_FUSA_ACTIVATE_SCAN 0x000002C6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 StartChunkIndex : 8;

                            /* Bits[7:0], Access Type=RW, default=None*/

                            /* First chunk index to perform scan */
    UINT32 StopChunkIndex : 8;

                            /* Bits[15:8], Access Type=RW, default=None*/

                            /* Last chunk index to scan */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=None*/

                            /* Reserved - must be zero */
    UINT32 WaitOtherThreadTime : 31;

                            /* Bits[62:32], Access Type=RW, default=None*/

                            /*
                               Time to wait the other thread to join FUSA scan
                               before aborting
                            */
    UINT32 McOnSafError : 1;

                            /* Bits[63:63], Access Type=RW, default=None*/

                            /*
                               Indicates whether we should signal MC as result
                               of SAF error
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_FUSA_ACTIVATE_SCAN_REGISTER;

/**
  Returns the result of most recent WRMSR(ACTIVATE_SCAN)
**/
#define ADL_MSR_FUSA_SCAN_STATUS 0x000002C7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ChunkIndexReached : 8;

                            /* Bits[7:0], Access Type=RW, default=None*/

                            /*
                               Chunk index that was reached in latest scan, can
                               be used as START_CHUNK_INDEX for next
                               WRMSR(ACTIVATE_SCAN)
                            */
    UINT32 StopChunkIndex : 8;

                            /* Bits[15:8], Access Type=RW, default=None*/

                            /*
                               STOP_CHUNK_INDEX that was provided in latest
                               scan, can be used as STOP_CHUNK_INDEX for next
                               WRMSR(ACTIVATE_SCAN)
                            */
    UINT32 NotUsed3116 : 16;

                            /* Bits[31:16], Access Type=RW, default=None*/

                            /* Not used, will be 0x0 */
    UINT32 ErrorCode : 8;

                            /* Bits[39:32], Access Type=RW, default=None*/

                            /*
                               SCAN operation did not start Other thread did
                               not join on time. [error code 0x1] Interrupt
                               occurred prior SCAN start. [error code 0x2]
                               Acode sent Abort_SCAN as a response. [error code
                               0x3] There are non-valid chunks in the range to
                               be performed [error code 0x4] Mismatch in
                               arguments between T0/T1 [error code 0x5] Core is
                               currently not capable of performing SCAN [error
                               code 0x6]
                            */
    UINT32 NotUsed6140 : 22;

                            /* Bits[61:40], Access Type=RW, default=None*/

                            /* Not used, will be 0x0 */
    UINT32 SscMalfunction : 1;

                            /* Bits[62:62], Access Type=RW, default=None*/

                            /*
                               SSC malfunction, in case we didn?t fail due to
                               ECC-error.
                            */
    UINT32 ScanErrorObservedInMisr : 1;

                            /* Bits[63:63], Access Type=RW, default=None*/

                            /*
                               SCAN error observed in the MISR, in case we
                               didn't fail due to ECC-error.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_FUSA_SCAN_STATUS_REGISTER;

/**

**/
#define ADL_MSR_FUSA_CAPABILITIES 0x000002D9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 StartupScanBist : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /*
                               Startup SCAN BIST supported when set to 1.
                               Reports state of fuse FUSA_STARTUP_SCAN_BIST_EN
                            */
    UINT32 StartupMemBist : 1;

                            /* Bits[1:1], Access Type=RW, default=None*/

                            /*
                               Startup MEM BIST supported when set to 1 Reports
                               state of fuse FUSA_STARTUP_MEM_BIST_EN
                            */
    UINT32 Pbist : 1;

                            /* Bits[2:2], Access Type=RW, default=None*/

                            /* FUSA PBIST Supported */
    UINT32 Lockstep : 1;

                            /* Bits[3:3], Access Type=RW, default=None*/

                            /*
                               Lockstep mode supported when set to 1 Reports
                               state of fuse FUSA_LSM_EN
                            */
    UINT32 PeriodicScanBist : 1;

                            /* Bits[4:4], Access Type=RW, default=None*/

                            /*
                               Periodic SCAN BIST supported when set to 1
                               Reports state of fuse FUSA_PERIODIC_SCAN_BIST_EN
                            */
    UINT32 Unused65 : 2;

                            /* Bits[6:5], Access Type=RW, default=None*/

                            /* Not Used */
    UINT32 Perrinj : 1;

                            /* Bits[7:7], Access Type=RW, default=None*/

                            /* FUSA PERRINJ Supported */
    UINT32 Unused148 : 7;

                            /* Bits[14:8], Access Type=RW, default=None*/

                            /*  */
    UINT32 FusaPreserveMemory : 1;

                            /* Bits[15:15], Access Type=RW, default=None*/

                            /* FUSARR_BASE and FUSARR_MASK MSRs supported */
    UINT32 Unused2316 : 8;

                            /* Bits[23:16], Access Type=RW, default=None*/

                            /*  */
    UINT32 FusaProgramId : 8;

                            /* Bits[31:24], Access Type=RW, default=None*/

                            /* Processor Fusa program ID */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_FUSA_CAPABILITIES_REGISTER;

/**
  PERFCNTD OCCUPANCY COUNTER
**/
#define ADL_MSR_PERF_OCCUPANCY_CTRS 0x00000305

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ctr0 : 7;

                            /* Bits[6:0], Access Type=RW_V, default=0x00000000*/

                            /* OCCUPANCY CTR 0 */
    UINT32 Ctr1 : 7;

                            /* Bits[13:7], Access Type=RW_V, default=0x00000000*/

                            /* OCCUPANCY CTR 1 */
    UINT32 Ctr2 : 7;

                            /* Bits[20:14], Access Type=RW_V, default=0x00000000*/

                            /* OCCUPANCY CTR 2 */
    UINT32 Ctr3 : 7;

                            /* Bits[27:21], Access Type=RW_V, default=0x00000000*/

                            /* OCCUPANCY CTR 3 */
    UINT32 Rsvd28 : 4;

                            /* Bits[31:28], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PERF_OCCUPANCY_CTRS_REGISTER;

/**
  Perfmon msr for exposure metrics on several emons
**/
#define ADL_MSR_PERF_METRICS 0x00000329

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Retiring : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* retired */
    UINT32 BadSpeculation : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /* bad speculation */
    UINT32 FrontendBound : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000000*/

                            /* frontend bound */
    UINT32 BackendBound : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000000*/

                            /* backend bound */
    UINT32 MultiUops : 8;

                            /* Bits[39:32], Access Type=RW, default=0x00000000*/

                            /* frontend bound */
    UINT32 BranchMispredicts : 8;

                            /* Bits[47:40], Access Type=RW, default=0x00000000*/

                            /* frontend bound */
    UINT32 FrontendLatency : 8;

                            /* Bits[55:48], Access Type=RW, default=0x00000000*/

                            /* frontend bound */
    UINT32 MemoryBound : 8;

                            /* Bits[63:56], Access Type=RW, default=0x00000000*/

                            /* frontend bound */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PERF_METRICS_REGISTER;

/**
  Uncore fixed counter control
**/
#define ADL_MSR_NCUPMONCTLFIX 0x00000394

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 20;

                            /* Bits[19:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enable generation of Overflow indiation when
                               this counter overflows. 0 : PMI Event for this
                               counter is disabled 1 : PMI event is enabled
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active. 0 : counter is disabled and
                               will not count when global enable is set. 1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Rsvd23 : 9;

                            /* Bits[31:23], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_NCUPMONCTLFIX_REGISTER;

/**
  Uncore fixed counter
**/
#define ADL_MSR_NCUPMONCTRFX 0x00000395

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_NCUPMONCTRFX_REGISTER;

/**
  This is MSR that shows to user configuration of uncore PMON's.
**/
#define ADL_MSR_NCUPMONCONFIG 0x00000396

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Numofcbopmon : 4;

                            /* Bits[3:0], Access Type=RWS, default=0x00000005*/

                            /*  */
    UINT32 Rsvd4 : 4;

                            /* Bits[7:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Numofidppmon : 1;

                            /* Bits[8:8], Access Type=RWS, default=0x00000000*/

                            /*  */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_NCUPMONCONFIG_REGISTER;

/**
  Controls the operation of the the PMON Counter 1 in IDP 1.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCtrClr] is set to 1b.
**/
#define ADL_MSR_PERFEVTSEL0 0x000003BA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               a selector for measured signals Details of
                               events are TBD
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               A set of qualifiers defined for each of the
                               events. Details for the counter are TBD.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Enubp : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the generation of micro-breakpoint event
                               on event occurrence. 0b Do not assert micro-
                               breakpoint on event occurrence 1b Assert micro-
                               breakpoint on event occurrence
                            */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Enable generation of Overfolow indiation when
                               this counter overflows. 0 : PMI Event for this
                               counter is disabled 1 : PMI event is enabled
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RO, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active. 0 : counter is disabled and
                               will not count when global enable is set. 1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Invert the event for counting purposes : 0 :
                               Count when the event is asserted or on it's
                               rising edge 1. : Count when the event is de-
                               asserted or on it's falling edge
                            */
    UINT32 Threshold : 5;

                            /* Bits[28:24], Access Type=RW, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming increment value from event increment
                               bus. The width of this field is determined by
                               the widest event in the iMPH (which is 5 bits
                               for queue occupancy). The result of the
                               comparison is effectively a 1 bit wide event,
                               i.e., the counter will be incremented by 1 when
                               the comparison is true (the type of comparison
                               depends on the setting of the Invert bit) no
                               matter how wide the original event was. When
                               this field is zero, threshold comparison is
                               disabled and the event is passed without
                               modification (i.e. the counter will adevance by
                               the specified increment value).
                            */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PERFEVTSEL0_REGISTER;

/**
  Controls the operation of the the PMON Counte 2 in IDP 1.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCtrClr] is set to 1b.
**/
#define ADL_MSR_PERFEVTSEL1 0x000003BB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               a selector for measured signals Details of
                               events are TBD
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               A set of qualifiers defined for each of the
                               events. Details for the counter are TBD.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Enubp : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the generation of micro-breakpoint event
                               on event occurrence. 0b Do not assert micro-
                               breakpoint on event occurrence 1b Assert micro-
                               breakpoint on event occurrence
                            */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Enable generation of Overfolow indiation when
                               this counter overflows. 0 : PMI Event for this
                               counter is disabled 1 : PMI event is enabled
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RO, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active. 0 : counter is disabled and
                               will not count when global enable is set. 1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Invert the event for counting purposes : 0 :
                               Count when the event is asserted or on it's
                               rising edge 1. : Count when the event is de-
                               asserted or on it's falling edge
                            */
    UINT32 Threshold : 5;

                            /* Bits[28:24], Access Type=RW, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming increment value from event increment
                               bus. The width of this field is determined by
                               the widest event in the iMPH (which is 5 bits
                               for queue occupancy). The result of the
                               comparison is effectively a 1 bit wide event,
                               i.e., the counter will be incremented by 1 when
                               the comparison is true (the type of comparison
                               depends on the setting of the Invert bit) no
                               matter how wide the original event was.
                            */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PERFEVTSEL1_REGISTER;

/**
  Holds global control fields for the NCU PMON counters for IDP 1.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCtrClr] is set to 1b.
**/
#define ADL_MSR_PERF_CTRL 0x000003BD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lpid : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd3 : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 ModuleId : 5;

                            /* Bits[8:4], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd9 : 3;

                            /* Bits[11:9], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Gtid : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Wrcid : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd14 : 18;

                            /* Bits[31:14], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PERF_CTRL_REGISTER;

/**
  Processor Event Based Sampling (PEBS) for front-end precise .  This register is read-write.
**/
#define ADL_MSR_PEBS_FRONTEND 0x000003F7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EventId : 4;

                            /* Bits[3:0], Access Type=RW, default=0x00000000*/

                            /*
                               Choose which event to monitor (ie. 1: IFU_MISS,
                               2: MLC_MISS, 3: ITLB_MISS, 4: STLB_MISS, 5:
                               DSB_MISS, 6: IDQ_READ_BUBBLES)
                            */
    UINT32 CriticalFilter : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               When asserted, cycles occurring while IDQ is
                               empty are filtered, otherwise they are
                               monitored.
                            */
    UINT32 Rsvd5 : 3;

                            /* Bits[7:5], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 FeLatency : 12;

                            /* Bits[19:8], Access Type=RW, default=0x00000008*/

                            /*
                               Number of consecutive cycles not having less
                               than FE_THRESHOLD bubbles which must occur
                               before logging the event.
                            */
    UINT32 FeThreshold : 3;

                            /* Bits[22:20], Access Type=RW, default=0x00000000*/

                            /*
                               Number of delivery bubbles (or more) of cycles
                               to count. If number of delivery bubbles is
                               greater than or equal to this field, then count
                               it.
                            */
    UINT32 Rsvd23 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PEBS_FRONTEND_REGISTER;

/**
  Machine Check Status Register
**/
#define ADL_MSR_MC0_STATUS 0x00000401

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mcacod : 11;

                            /* Bits[10:0], Access Type=RW_V, default=None*/

                            /* Machine Check Architecture Error Code */
    UINT32 EnhMcaAvail0 : 5;

                            /* Bits[15:11], Access Type=RW_V, default=None*/

                            /* Reserved bits */
    UINT32 Mscod : 5;

                            /* Bits[20:16], Access Type=RW_V, default=None*/

                            /* Machine Specific Architecture Error Code */
    UINT32 EnhMcaAvail10 : 11;

                            /* Bits[31:21], Access Type=RW_V, default=None*/

                            /* Reserved bits */
    UINT32 EnhMcaAvail11 : 6;

                            /* Bits[37:32], Access Type=RW_V, default=None*/

                            /* Reserved bits */
    UINT32 CorrectedErrCnt : 14;

                            /* Bits[51:38], Access Type=RW_V, default=None*/

                            /*
                               Corrected error count since last clear of mc
                               regs
                            */
    UINT32 Sticky : 1;

                            /* Bits[52:52], Access Type=RW_V, default=None*/

                            /* Sticky bit set when error count overflows */
    UINT32 EnhMcaAvail2 : 2;

                            /* Bits[54:53], Access Type=RW_V, default=None*/

                            /* Reserved bits */
    UINT32 Ar : 1;

                            /* Bits[55:55], Access Type=RW_V, default=None*/

                            /* Action required */
    UINT32 S : 1;

                            /* Bits[56:56], Access Type=RW_V, default=None*/

                            /* Signaling */
    UINT32 Pcc : 1;

                            /* Bits[57:57], Access Type=RW_V, default=None*/

                            /* Processor Context Corrupt */
    UINT32 Addrv : 1;

                            /* Bits[58:58], Access Type=RW_V, default=None*/

                            /* MC0_ADDR register valid */
    UINT32 Miscv : 1;

                            /* Bits[59:59], Access Type=RW_V, default=None*/

                            /* MC0_MISC register valid */
    UINT32 En : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* Error Enabled */
    UINT32 Uc : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* Uncorrectable Error */
    UINT32 Over : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Machine Check Overflow */
    UINT32 Val : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Status register Valid */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_MC0_STATUS_REGISTER;

/**
  Machine Check Control Register
**/
#define ADL_MSR_MC3_CTL 0x0000040C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MlcTagError : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Enable machine check signaling */
    UINT32 MlcSqdbIdiParError : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* Enable machine check signaling */
    UINT32 MlcDataError : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* Enable machine check signaling */
    UINT32 MlcMesiStateError : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* Enable machine check signaling */
    UINT32 MlcDpfPoisonError : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* Enable machine check signaling */
    UINT32 MlcIdiAddrParError : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /* Enable machine check signaling */
    UINT32 PmError : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* Enable machine check signaling */
    UINT32 Rsvd7 : 25;

                            /* Bits[31:7], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_MC3_CTL_REGISTER;

/**
  Machine Check Status Register
**/
#define ADL_MSR_MC3_STATUS 0x0000040D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mcacod : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* Machine Check Architecture Error Code */
    UINT32 Mscod : 16;

                            /* Bits[31:16], Access Type=RW_V, default=None*/

                            /* Model Specific Error Code */
    UINT32 EnhMcaAvail0 : 6;

                            /* Bits[37:32], Access Type=RW_V, default=None*/

                            /* Available when Enhanced MCA is in use */
    UINT32 Cec : 15;

                            /* Bits[52:38], Access Type=RW_V, default=None*/

                            /* Correctable Error Count */
    UINT32 BitfixAllocated : 1;

                            /* Bits[53:53], Access Type=RW_V, default=None*/

                            /*
                               Status tracking is Green if this bit is set when
                               a logged error is allocated into bitfix CAM
                            */
    UINT32 BitfixOvercapacity : 1;

                            /* Bits[54:54], Access Type=RW_V, default=None*/

                            /*
                               Status tracking is Yellow if this bit is set
                               when a logged error overflows bitfix CAM (and
                               bitfixing is enabled)
                            */
    UINT32 Ar : 1;

                            /* Bits[55:55], Access Type=RW_V, default=None*/

                            /* set on SRAR error type */
    UINT32 S : 1;

                            /* Bits[56:56], Access Type=RW_V, default=None*/

                            /* set on SRAR and SRAO error types */
    UINT32 Pcc : 1;

                            /* Bits[57:57], Access Type=RW_V, default=None*/

                            /* Processor Context Corrupt */
    UINT32 Addrv : 1;

                            /* Bits[58:58], Access Type=RW_V, default=None*/

                            /* MC3_ADDR register valid */
    UINT32 Miscv : 1;

                            /* Bits[59:59], Access Type=RW_V, default=None*/

                            /* MC3_MISC register valid */
    UINT32 En : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* Error Enabled */
    UINT32 Uc : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* Uncorrectable Error */
    UINT32 Over : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Machine Check Overflow */
    UINT32 Val : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Status register Valid */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_MC3_STATUS_REGISTER;

/**
  Machine Check Misc Register
**/
#define ADL_MSR_MC3_MISC 0x0000040F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Recaddrlsb : 6;

                            /* Bits[5:0], Access Type=RW_V, default=None*/

                            /* Const: 000101 */
    UINT32 Addrmode : 3;

                            /* Bits[8:6], Access Type=RW_V, default=None*/

                            /* Const: 010 */
    UINT32 Opcode : 7;

                            /* Bits[15:9], Access Type=RW_V, default=None*/

                            /* Opcode */
    UINT32 Sqid : 6;

                            /* Bits[21:16], Access Type=RW_V, default=None*/

                            /* SQID */
    UINT32 Way : 5;

                            /* Bits[26:22], Access Type=RW_V, default=None*/

                            /* Way */
    UINT32 Thread : 1;

                            /* Bits[27:27], Access Type=RW_V, default=None*/

                            /* Thread */
    UINT32 EnhMcaAvail0 : 4;

                            /* Bits[31:28], Access Type=RW_V, default=None*/

                            /* Available when Enhnaced MCA is in use */
    UINT32 EnhMcaAvail1 : 32;

                            /* Bits[63:32], Access Type=RW_V, default=None*/

                            /* Available when Enhnaced MCA is in use */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_MC3_MISC_REGISTER;

/**
  The MCiCTL MSR controls the signalling of machine check exceptions generated by the bank.
**/
#define ADL_MSR_UBOX_MC_CTL 0x00000418

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 IosfFatalmcaen : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 IosfNonfatalmcaen : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 UboxMcaen : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 M2uboxMcaen : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_UBOX_MC_CTL_REGISTER;

/**
  Ubox MCA bank: Status register
**/
#define ADL_MSR_UBOX_MC_STATUS 0x00000419

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mcacod : 16;

                            /* Bits[15:0], Access Type=RWS_V, default=0x00000000*/

                            /* MCA error code */
    UINT32 Mscod : 16;

                            /* Bits[31:16], Access Type=RWS_V, default=0x00000000*/

                            /* Model specific error code */
    UINT32 OtherInfo : 6;

                            /* Bits[37:32], Access Type=RWS_V, default=0x00000000*/

                            /* Other info */
    UINT32 CorrectedErrorCount : 15;

                            /* Bits[52:38], Access Type=RWS_V, default=0x00000000*/

                            /* Correctable error count */
    UINT32 Cesi : 2;

                            /* Bits[54:53], Access Type=ROS_V, default=0x00000000*/

                            /* threshold based error status */
    UINT32 Ar : 1;

                            /* Bits[55:55], Access Type=RWS_V, default=0x00000000*/

                            /* Available when Enhanced MCA is in use */
    UINT32 S : 1;

                            /* Bits[56:56], Access Type=RWS_V, default=0x00000000*/

                            /* Available when Enhanced MCA is in use */
    UINT32 Pcc : 1;

                            /* Bits[57:57], Access Type=RWS_V, default=0x00000000*/

                            /* PCC: Processor context corrupt */
    UINT32 Addrv : 1;

                            /* Bits[58:58], Access Type=RWS_V, default=0x00000000*/

                            /*
                               ADDRV: The address held in the MC4_ADDR_MSR is
                               valid
                            */
    UINT32 Miscv : 1;

                            /* Bits[59:59], Access Type=RWS_V, default=0x00000000*/

                            /*
                               MISCV: The value held in the MC4_MISC_MSR is
                               valid
                            */
    UINT32 En : 1;

                            /* Bits[60:60], Access Type=RWS_V, default=0x00000000*/

                            /*
                               EN: Error enabled flag Indicates (when set) that
                               signaling of the machine check exception for
                               this error was enabled by an associated flag bit
                               of the Mci_CTL register.
                            */
    UINT32 Uc : 1;

                            /* Bits[61:61], Access Type=RWS_V, default=0x00000000*/

                            /*
                               UC: Error uncorrected flag Indicates (when set)
                               that the processor did not correct the error
                               condition. When clear, this flag indicates that
                               the processor was able to correct the error
                               condition.
                            */
    UINT32 Over : 1;

                            /* Bits[62:62], Access Type=RWS_V, default=0x00000000*/

                            /* OVER: Machine check overflow */
    UINT32 Val : 1;

                            /* Bits[63:63], Access Type=RWS_V, default=0x00000000*/

                            /*
                               VAL: Valid flag Indicates (when set) that the
                               information within the Mci_STATUS register is
                               valid. When this flag is set, the processor
                               follows the rules given for the OVER flag in the
                               Mci_STATUS register when overwriting previously
                               valid entries. The processor sets the VAL flag
                               and software is responsible for clearing it.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_UBOX_MC_STATUS_REGISTER;

/**
  The MCiMISC MSR contains additional micro-architecture specific information describing the machine check error if the MISCV flag in the MCiSTATUS register is set. It is also possible to use the Other Info field in the MCiSTATUS register for the same type of model specific error reporting
**/
#define ADL_MSR_UBOX_MC_MISC 0x0000041B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 13;

                            /* Bits[12:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SegmentLog : 3;

                            /* Bits[15:13], Access Type=RWS_V, default=0x00000000*/

                            /* segment of IOSF error */
    UINT32 FunctionLog : 3;

                            /* Bits[18:16], Access Type=RWS_V, default=0x00000000*/

                            /* func of IOSF error */
    UINT32 DeviceLog : 5;

                            /* Bits[23:19], Access Type=RWS_V, default=0x00000000*/

                            /* device of IOSF error */
    UINT32 BusLog : 8;

                            /* Bits[31:24], Access Type=RWS_V, default=0x00000000*/

                            /* bus of IOSF error */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_UBOX_MC_MISC_REGISTER;

/**
  MC_CTL MSR defn for merging of CBo MC banks MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_MDF_MERGE0_MC_CTL 0x0000041C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboErrors : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd9 : 1;

                            /* Bits[9:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors1 : 9;

                            /* Bits[18:10], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors2 : 2;

                            /* Bits[21:20], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd22 : 1;

                            /* Bits[22:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors3 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved Non implemented field */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_MDF_MERGE0_MC_CTL_REGISTER;
/**
  MC_STATUS MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_MDF_MERGE0_MC_STATUS 0x0000041D
/**
  MC_ADDR MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_MDF_MERGE0_MC_ADDR 0x0000041E
/**
  MC_MISC MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_MDF_MERGE0_MC_MISC 0x0000041F

/**
  MC_CTL MSR defn for merging of CBo MC banks MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_MDF_MERGE1_MC_CTL 0x00000420

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboErrors : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd9 : 1;

                            /* Bits[9:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors1 : 9;

                            /* Bits[18:10], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors2 : 2;

                            /* Bits[21:20], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd22 : 1;

                            /* Bits[22:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors3 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved Non implemented field */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_MDF_MERGE1_MC_CTL_REGISTER;
/**
  MC_STATUS MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_MDF_MERGE1_MC_STATUS 0x00000421
/**
  MC_ADDR MSR defn for merging of KTI MC banks
  MERGE0 bank will merge KTIs 0,1,2,3
**/
#define ADL_MSR_MDF_MERGE1_MC_ADDR 0x00000422
/**
  MC_MISC MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_MDF_MERGE1_MC_MISC 0x00000423

/**
  MC_CTL MSR defn for merging of CBo MC banks MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_CBO_MERGE0_MC_CTL 0x00000424

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboErrors : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd9 : 1;

                            /* Bits[9:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors1 : 9;

                            /* Bits[18:10], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors2 : 2;

                            /* Bits[21:20], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd22 : 1;

                            /* Bits[22:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors3 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved Non implemented field */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBO_MERGE0_MC_CTL_REGISTER;
/**
  MC_STATUS MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_CBO_MERGE0_MC_STATUS 0x00000425
/**
  MC_ADDR MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_CBO_MERGE0_MC_ADDR 0x00000426
/**
  MC_MISC MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_CBO_MERGE0_MC_MISC 0x00000427

/**
  MC_CTL MSR defn for merging of CBo MC banks
  MERGE1 bank will merge CBos 1, 4, 7, 10, 13, 16, 19, 22, 25
**/
#define ADL_MSR_CBO_MERGE1_MC_CTL 0x00000428

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboErrors : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd9 : 1;

                            /* Bits[9:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors1 : 9;

                            /* Bits[18:10], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors2 : 2;

                            /* Bits[21:20], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd22 : 1;

                            /* Bits[22:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors3 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved Non implemented field */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBO_MERGE1_MC_CTL_REGISTER;
/**
  MC_STATUS MSR defn for merging of CBo MC banks
  MERGE1 bank will merge CBos 1, 4, 7, 10, 13, 16, 19, 22, 25
**/
#define ADL_MSR_CBO_MERGE1_MC_STATUS 0x00000429
/**
  MC_ADDR MSR defn for merging of CBo MC banks
  MERGE1 bank will merge CBos 1, 4, 7, 10, 13, 16, 19, 22, 25
**/
#define ADL_MSR_CBO_MERGE1_MC_ADDR 0x0000042A
/**
  MC_MISC MSR defn for merging of CBo MC banks
  MERGE1 bank will merge CBos 1, 4, 7, 10, 13, 16, 19, 22, 25
**/
#define ADL_MSR_CBO_MERGE1_MC_MISC 0x0000042B

/**
  MC_CTL MSR defn for merging of CBo MC banks
  MERGE2 bank will merge CBos 2, 5, 8, 11, 14, 17, 20, 23, 26
**/
#define ADL_MSR_CBO_MERGE2_MC_CTL 0x0000042C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboErrors : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd9 : 1;

                            /* Bits[9:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors1 : 9;

                            /* Bits[18:10], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors2 : 2;

                            /* Bits[21:20], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd22 : 1;

                            /* Bits[22:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors3 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved Non implemented field */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBO_MERGE2_MC_CTL_REGISTER;
/**
  MC_STATUS MSR defn for merging of CBo MC banks
  MERGE2 bank will merge CBos 2, 5, 8, 11, 14, 17, 20, 23, 26
**/
#define ADL_MSR_CBO_MERGE2_MC_STATUS 0x0000042D
/**
  MC_ADDR MSR defn for merging of CBo MC banks
  MERGE2 bank will merge CBos 2, 5, 8, 11, 14, 17, 20, 23, 26
**/
#define ADL_MSR_CBO_MERGE2_MC_ADDR 0x0000042E
/**
  MC_MISC MSR defn for merging of CBo MC banks
  MERGE2 bank will merge CBos 2, 5, 8, 11, 14, 17, 20, 23, 26
**/
#define ADL_MSR_CBO_MERGE2_MC_MISC 0x0000042F

/**
  MC_CTL MSR defn for merging of CBo MC banks MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_M2M_MERGE0_MC_CTL 0x00000430

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboErrors : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd9 : 1;

                            /* Bits[9:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors1 : 9;

                            /* Bits[18:10], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors2 : 2;

                            /* Bits[21:20], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd22 : 1;

                            /* Bits[22:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors3 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved Non implemented field */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_M2M_MERGE0_MC_CTL_REGISTER;
/**
  MC_STATUS MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_M2M_MERGE0_MC_STATUS 0x00000431
/**
  MC_ADDR MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_M2M_MERGE0_MC_ADDR 0x00000432
/**
  MC_MISC MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_M2M_MERGE0_MC_MISC 0x00000433

/**
  MC_CTL MSR defn for merging of CBo MC banks MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_CTL_0 0x00000434

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboErrors : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd9 : 1;

                            /* Bits[9:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors1 : 9;

                            /* Bits[18:10], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors2 : 2;

                            /* Bits[21:20], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd22 : 1;

                            /* Bits[22:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors3 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved Non implemented field */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_IMC0_MC_CTL_0_REGISTER;
/**
  MC_STATUS MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_STATUS_0 0x00000435
/**
  MC_ADDR MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_ADDR_0 0x00000436
/**
  MC_MISC MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_MISC_0 0x00000437

/**
  MC_CTL MSR defn for merging of CBo MC banks MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_CTL_1 0x00000438

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboErrors : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd9 : 1;

                            /* Bits[9:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors1 : 9;

                            /* Bits[18:10], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors2 : 2;

                            /* Bits[21:20], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd22 : 1;

                            /* Bits[22:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors3 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved Non implemented field */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_IMC0_MC_CTL_1_REGISTER;
/**
  MC_STATUS MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_STATUS_1 0x00000439
/**
  MC_ADDR MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_ADDR_1 0x0000043A
/**
  MC_MISC MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_MISC_1 0x0000043B

/**
  MC_CTL MSR defn for merging of CBo MC banks MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_CTL_2 0x0000043C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboErrors : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd9 : 1;

                            /* Bits[9:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors1 : 9;

                            /* Bits[18:10], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors2 : 2;

                            /* Bits[21:20], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd22 : 1;

                            /* Bits[22:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors3 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved Non implemented field */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_IMC0_MC_CTL_2_REGISTER;
/**
  MC_STATUS MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_STATUS_2 0x0000043D
/**
  MC_ADDR MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_ADDR_2 0x0000043E
/**
  MC_MISC MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_MISC_2 0x0000043F

/**
  MC_CTL MSR defn for merging of CBo MC banks MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_CTL_3 0x00000440

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboErrors : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd9 : 1;

                            /* Bits[9:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors1 : 9;

                            /* Bits[18:10], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors2 : 2;

                            /* Bits[21:20], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd22 : 1;

                            /* Bits[22:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors3 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved Non implemented field */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_IMC0_MC_CTL_3_REGISTER;
/**
  MC_STATUS MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_STATUS_3 0x00000441
/**
  MC_ADDR MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_ADDR_3 0x00000442
/**
  MC_MISC MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_MISC_3 0x00000443

/**
  MC_CTL MSR defn for merging of CBo MC banks MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_CTL_4 0x00000444

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboErrors : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd9 : 1;

                            /* Bits[9:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors1 : 9;

                            /* Bits[18:10], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors2 : 2;

                            /* Bits[21:20], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd22 : 1;

                            /* Bits[22:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors3 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved Non implemented field */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_IMC0_MC_CTL_4_REGISTER;
/**
  MC_STATUS MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_STATUS_4 0x00000445
/**
  MC_ADDR MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_ADDR_4 0x00000446
/**
  MC_MISC MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_MISC_4 0x00000447

/**
  2LM MCA bank: Control register
**/
#define ADL_MSR_MC_CTL 0x00000448

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EnUncorrectableTcMultipleTagMatchError : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Enable bit for MC signaling */
    UINT32 EnUncorrectableTcTagError : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* Enable bit for MC signaling */
    UINT32 EnUncorrectableSdtCorruptionError : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* Enable bit for MC signaling */
    UINT32 EnUncorrectableAddressRangeError : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* Enable bit for MC signaling */
    UINT32 EnCorrectableTcTagError : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* Enable bit for MC signaling */
    UINT32 Rsvd5 : 27;

                            /* Bits[31:5], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_MC_CTL_REGISTER;

/**
  2LM MCA bank: Miscellaneous register
**/
#define ADL_MSR_MC_MISC 0x0000044B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ErrorAddress : 16;

                            /* Bits[15:0], Access Type=RWS_V, default=0x00000000*/

                            /*
                               This field contains the address of uncorrected
                               error seen in the 2LMC/MLMc. It is updated on an
                               uncorrectable error. To maintain e-MCA support
                               this register must be writable.
                            */
    UINT32 CorrectedErrorCount : 8;

                            /* Bits[23:16], Access Type=RWS_V, default=0x00000000*/

                            /* Corrected Error Count */
    UINT32 EnhMcaAvail0 : 8;

                            /* Bits[31:24], Access Type=RWS_V, default=0x00000000*/

                            /* Available when enhanced MCA is in use */
    UINT32 EnhMcaAvail1 : 32;

                            /* Bits[63:32], Access Type=RWS_V, default=0x00000000*/

                            /* Available when enhanced MCA is in use */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_MC_MISC_REGISTER;

/**
  MC_CTL MSR defn for merging of CBo MC banks MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_CTL_6 0x0000044C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboErrors : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd9 : 1;

                            /* Bits[9:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors1 : 9;

                            /* Bits[18:10], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors2 : 2;

                            /* Bits[21:20], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd22 : 1;

                            /* Bits[22:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors3 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved Non implemented field */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_IMC0_MC_CTL_6_REGISTER;
/**
  MC_STATUS MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_STATUS_6 0x0000044D
/**
  MC_ADDR MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_ADDR_6 0x0000044E
/**
  MC_MISC MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_MISC_6 0x0000044F

/**
  MC_CTL MSR defn for merging of CBo MC banks MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_CTL_7 0x00000450

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboErrors : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd9 : 1;

                            /* Bits[9:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors1 : 9;

                            /* Bits[18:10], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors2 : 2;

                            /* Bits[21:20], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd22 : 1;

                            /* Bits[22:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors3 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved Non implemented field */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_IMC0_MC_CTL_7_REGISTER;
/**
  MC_STATUS MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_STATUS_7 0x00000451
/**
  MC_ADDR MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_ADDR_7 0x00000452
/**
  MC_MISC MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_IMC0_MC_MISC_7 0x00000453

/**
  MC_CTL MSR defn for merging of CBo MC banks MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_DEDUP_MERGE0_MC_CTL 0x00000474

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboErrors : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd9 : 1;

                            /* Bits[9:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors1 : 9;

                            /* Bits[18:10], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors2 : 2;

                            /* Bits[21:20], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Rsvd22 : 1;

                            /* Bits[22:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CboErrors3 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Cbo errors - for details see CBO_MC_CTL CR defn */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved Non implemented field */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_DEDUP_MERGE0_MC_CTL_REGISTER;
/**
  MC_STATUS MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_DEDUP_MERGE0_MC_STATUS 0x00000475
/**
  MC_ADDR MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_DEDUP_MERGE0_MC_ADDR 0x00000476
/**
  MC_MISC MSR defn for merging of CBo MC banks
  MERGE0 bank will merge CBos 0, 3, 6, 9, 12, 15, 18, 21, 24, 27
**/
#define ADL_MSR_DEDUP_MERGE0_MC_MISC 0x00000477
/**
  Allowed 1-settings of tertiary processor-based VM-execution controls.
**/
#define ADL_MSR_VMX_PROCBASED_CTLS3 0x00000492

/**
  This register contains bit per logical processor indicating
  whether the logical processor is in the middle of long flow and hence
  will delay servicing of SMI. SMI will be serviced after the long flow
  completes execution.
**/
#define ADL_MSR_SMM_DELAYED 0x000004E2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 LogProc : 16;

                            /* Bits[15:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit will be set at the start of the events
                               listed below and cleared at the end of the
                               events. Patch load C6 entry C6 exit WBINVD Ratio
                               Change/Throttle/S1
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_SMM_DELAYED_REGISTER;

/**
  This register contains bit per logical processor indicating
  whether the logical processor is in state where SMIs are blocked and hence
  will not be able to service SMI. SMI can be serviced after the logical
  processor exits the state in which SMIs are blocked
**/
#define ADL_MSR_SMM_BLOCKED 0x000004E3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 LogProc : 16;

                            /* Bits[15:0], Access Type=RW_V, default=0x0000FFFF*/

                            /*
                               This bit will be set when the logical processor
                               is in the following states Wait For SIPI SENTER
                               Sleep VMX Abort Error Shutdown (Machine check in
                               WFS state)
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_SMM_BLOCKED_REGISTER;

/**
  Extended Page Table Pointer
**/
#define ADL_MSR_EPTP 0x00000510

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* EPT Memory Type */
    UINT32 Rsvd3 : 3;

                            /* Bits[5:3], Access Type=RW, default=0x00000000*/

                            /* Reserved bits */
    UINT32 EptADEnable : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* EPT A/D enable */
    UINT32 EptSssEnable : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               Enable bit for EPT enabling supervisor shadow
                               stack pages
                            */
    UINT32 HlatEnable : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /* Enable bit for HLAT */
    UINT32 PlrDisable : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               Disables PLR match in HLAT. If set under HLAT,
                               all memory should be translated through HLAT
                               tables.
                            */
    UINT32 PagingWriteEnable : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               Enable Paging Write in EPT. This bit gives EPT
                               A/D assists write permissions to an EPT page
                               with no eptW.
                            */
    UINT32 GuestPagingVerification : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               Enable Verify Paging Write in EPT. If set all
                               EPT translation of all IA steps should have
                               Paging Write bit set.
                            */
    UINT32 Address0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /*
                               Page-Map Level-4/5 Address restrictions : The
                               PMH2_EPTP creg is not a real creg. It is shadow
                               so that a write to the CORE_EPTP will update the
                               ASID_EPTP in the pmh. So if you do a Write then
                               Read of the PMH2_EPTP you will receive Xs.
                            */
    UINT32 Address1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               Page-Map Level-4/5 Address restrictions : The
                               PMH2_EPTP creg is not a real creg. It is shadow
                               so that a write to the CORE_EPTP will update the
                               ASID_EPTP in the pmh. So if you do a Write then
                               Read of the PMH2_EPTP you will receive Xs.
                            */
    UINT32 Rsvd52 : 8;

                            /* Bits[59:52], Access Type=RW, default=0x00000000*/

                            /* Reserved bits */
    UINT32 Seam : 1;

                            /* Bits[60:60], Access Type=RW, default=0x00000000*/

                            /* In SEAM mode bit */
    UINT32 EptMbeEnable : 1;

                            /* Bits[61:61], Access Type=RW, default=0x00000000*/

                            /*
                               Enable bit for EPT Mode Based Execution
                               (required also paging is ON in guest)
                            */
    UINT32 Ept5l : 1;

                            /* Bits[62:62], Access Type=RW, default=0x00000000*/

                            /* Enable 5L EPT */
    UINT32 Enable : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /*
                               EPT enable bit restrictions : The PMH2_EPTP creg
                               is not a real creg. It is shadow so that a write
                               to the CORE_EPTP will update the ASID_EPTP in
                               the pmh. So if you do a Write then Read of the
                               PMH2_EPTP you will receive Xs.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_EPTP_REGISTER;

/**
  THREAD_UARCH_CTL
**/
#define ADL_MSR_THREAD_UARCH_CTL 0x00000540

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 WbMemStrmLdDisable : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Disable streaming behavior for MOVNTDQA loads to
                               WB memory type. If set, these accesses will be
                               treated like regular cacheable loads (Data will
                               be cached).
                            */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_THREAD_UARCH_CTL_REGISTER;

/**
  CORE_UARCH_CTL
**/
#define ADL_MSR_CORE_UARCH_CTL 0x00000541

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ScrubDis : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               L1 scrubbing disable restrictions : This bit
                               should be statically set at the time of reset.
                               It cannot be changed during execution.
                            */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CORE_UARCH_CTL_REGISTER;

/**
  RTIT Control MSR
**/
#define ADL_MSR_RTIT_CTL 0x00000570

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 TraceEn : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Enable RTIT Trace on thread */
    UINT32 CycEn : 1;

                            /* Bits[1:1], Access Type=RW, default=None*/

                            /* Enable Cycle Pkt */
    UINT32 Os : 1;

                            /* Bits[2:2], Access Type=RW, default=None*/

                            /*
                               When set, only branches in ring 0 (OS mode) will
                               get tracked for RTIT. When both CPL_EQ_0 and
                               CPL_NEQ_0 bits are set, all branches will get
                               tracked for RTIT.
                            */
    UINT32 Usr : 1;

                            /* Bits[3:3], Access Type=RW, default=None*/

                            /*
                               When set, only branches in non-ring 0 (User
                               mode) will get tracked for RTIT. When both
                               CPL_EQ_0 and CPL_NEQ_0 bits are set, all
                               branches will get tracked for RTIT.
                            */
    UINT32 Rsvd4 : 1;

                            /* Bits[4:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Fuponptw : 1;

                            /* Bits[5:5], Access Type=RW, default=None*/

                            /* enable FUP as part of PTWRITE packet */
    UINT32 Rsvd6 : 1;

                            /* Bits[6:6], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Cr3FilterEn : 1;

                            /* Bits[7:7], Access Type=RW, default=None*/

                            /*
                               Enable CR3 filtering, such that tracing is
                               enabled only if CR3 matches the value in
                               IA32_RTIT_CR3
                            */
    UINT32 TopaEn : 1;

                            /* Bits[8:8], Access Type=RW, default=None*/

                            /*
                               When set causes the RTIT output to be in memory
                               via ToPA, else to a single address range
                            */
    UINT32 MtcEn : 1;

                            /* Bits[9:9], Access Type=RW, default=None*/

                            /* Enable mini time stamp counter */
    UINT32 TscEn : 1;

                            /* Bits[10:10], Access Type=RW, default=None*/

                            /*
                               Enable TSC packets, on RTIT enable as well as on
                               bus ratio changes (with CBR). Implies that CBR
                               is also enabled.
                            */
    UINT32 DisableRetComp : 1;

                            /* Bits[11:11], Access Type=RW, default=None*/

                            /* When set, RETURN compression will be disabled */
    UINT32 PtwEn : 1;

                            /* Bits[12:12], Access Type=RW, default=None*/

                            /* enable PTWRITE */
    UINT32 BranchEn : 1;

                            /* Bits[13:13], Access Type=RW, default=None*/

                            /*
                               0: Disable COFI-based packets; 1: Enable COFI-
                               based packets (FUP, TIP, TNT, PIP, CSB);
                            */
    UINT32 MtcFreq : 4;

                            /* Bits[17:14], Access Type=RW, default=None*/

                            /*
                               Defines MTC Frequency, which is based on the HW
                               Crystal Clock (CTC). MTC will be sent each time
                               the selected CTC bit toggles. Encodings: 0:
                               CTC[0] 4: CTC[4] 8: CTC[8] 12: CTC[12] 1: CTC[1]
                               5: CTC[5] 9: CTC[9] 13: CTC[13] 2: CTC[2] 6:
                               CTC[6] 10: CTC[10] 14: CTC[14] 3: CTC[3] 7:
                               CTC[7] 11: CTC[11] 15: CTC[15]
                            */
    UINT32 Rsvd18 : 1;

                            /* Bits[18:18], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CycThresh : 4;

                            /* Bits[22:19], Access Type=RW, default=None*/

                            /*
                               CYC packet threshold, see 4.53.4 for details.
                               CYC packets will be sent with the first eligible
                               packet after N cycles have passed since the last
                               CYC packet. If CycThresh is 0 then N=0,
                               otherwise N is defined as 2(CycThresh-1).
                               Encodings: 0: 0 4: 8 8: 128 12: 2048 1: 1 5: 16
                               9: 256 13: 4096 2: 2 6: 32 10: 512 14: 8192 3: 4
                               7: 64 11: 1024 15: 16384
                            */
    UINT32 Rsvd23 : 1;

                            /* Bits[23:23], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PsbFreq : 4;

                            /* Bits[27:24], Access Type=RW, default=None*/

                            /*
                               Indicates the frequency of PSB packets. PSB
                               packet frequency is based on the number of RTIT
                               packet bytes output, so this field allows the
                               user to determine the increment of
                               IA32_IA32_RTIT_STATUS. PacketByteCnt that should
                               cause a PSB to be generated. Note that PSB
                               insertion is not precise, but the average output
                               bytes per PSB should approximate the SW selected
                               period. The average PSB period, in RTIT output
                               bytes, can be expressed as 2(PSBFreq+11).
                               Encodings: 0: 2K 4: 32K 8: 512K 12: 8M 1: 4K 5:
                               64K 9: 1M 13: 16M 2: 8K 6: 128K 10: 2M 14: 32M
                               3: 16K 7: 256K 11: 4M 15: 64M
                            */
    UINT32 Rsvd28 : 4;

                            /* Bits[31:28], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Addr0Cfg : 4;

                            /* Bits[35:32], Access Type=RW, default=None*/

                            /*
                               0x0 No address filtering 0x1 Enable tracing when
                               IP in [A..B] range 0x2 Stop tracing when IP in
                               [A..B] range 0x3..0xf Reserved
                            */
    UINT32 Addr1Cfg : 4;

                            /* Bits[39:36], Access Type=RW, default=None*/

                            /*
                               0x0 No address filtering 0x1 Enable tracing when
                               IP in [A..B] range 0x2 Stop tracing when IP in
                               [A..B] range 0x3..0xf Reserved
                            */
    UINT32 Rsvd40 : 16;

                            /* Bits[55:40], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 InjectPsbPmiOnEnable : 1;

                            /* Bits[56:56], Access Type=RW, default=None*/

                            /*
                               Enable preservation of PMI/PSB over
                               xsaves/xrstors. [IntelRsvd]Note: #GP on SNC. May
                               be enabled by patch later. See ticket 1405267396
                               [/IntelRsvd]
                            */
    UINT32 Rsvd57 : 7;

                            /* Bits[63:57], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_RTIT_CTL_REGISTER;
/**
  addr conver msr in dedup for dlid
**/
#define ADL_MSR_DD_HASH_SEED_INIT 0x000005F0

/**
  command reg in ACE IP
**/
#define ADL_MSR_DD_THROTTLE_DISABLE 0x000005F1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Dedupthdisabled : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_DD_THROTTLE_DISABLE_REGISTER;

/**
  addr conv msr in dedup
**/
#define ADL_MSR_DD_REVERSE_ADDR_CONV_SA 0x000005F2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ca0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* channel address */
    UINT32 Ca1 : 14;

                            /* Bits[45:32], Access Type=RW, default=0x00000000*/

                            /* channel address */
    UINT32 Rsvd46 : 12;

                            /* Bits[57:46], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Uniqueid : 6;

                            /* Bits[63:58], Access Type=RW, default=0x00000000*/

                            /* ID of dedup IP */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_DD_REVERSE_ADDR_CONV_SA_REGISTER;

/**
  addr conver msr in dedup for dlid
**/
#define ADL_MSR_DD_REVERSE_ADDR_CONV_DLID 0x000005F3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 OpaqueHandle0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Interpreted based on region type */
    UINT32 OpaqueHandle1 : 6;

                            /* Bits[37:32], Access Type=RW, default=0x00000000*/

                            /* Interpreted based on region type */
    UINT32 Rsvd38 : 16;

                            /* Bits[53:38], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Uniqueid : 6;

                            /* Bits[59:54], Access Type=RW, default=0x00000000*/

                            /* id of dedup IP */
    UINT32 RegionType : 3;

                            /* Bits[62:60], Access Type=RW, default=0x00000000*/

                            /*
                               type of region 011 - non dedup region 000 -
                               translation table 100/110/111 - data region rest
                               of the values are rsvd
                            */
    UINT32 Valid : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /* set after conversion is complete */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_DD_REVERSE_ADDR_CONV_DLID_REGISTER;

/**
  addr conver msr in dedup SA1
**/
#define ADL_MSR_DD_REVERSE_ADDR_CONV_SA1 0x000005F4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Sa0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* system address */
    UINT32 Sa1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* system address */
    UINT32 Rsvd52 : 11;

                            /* Bits[62:52], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Valid : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /* valid address */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_DD_REVERSE_ADDR_CONV_SA1_REGISTER;

/**
  addr conver msr in dedup SA2
**/
#define ADL_MSR_DD_REVERSE_ADDR_CONV_SA2 0x000005F5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Sa0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* system address */
    UINT32 Sa1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* system address */
    UINT32 Rsvd52 : 11;

                            /* Bits[62:52], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Valid : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /* valid address */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_DD_REVERSE_ADDR_CONV_SA2_REGISTER;

/**
  remap list msr
**/
#define ADL_MSR_DD_REMAP_LIST 0x000005F6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Opaquehandle0 : 32;

                            /* Bits[31:0], Access Type=WO, default=0x00000000*/

                            /* write only opaque handle */
    UINT32 Opaquehandle1 : 6;

                            /* Bits[37:32], Access Type=WO, default=0x00000000*/

                            /* write only opaque handle */
    UINT32 Rsvd38 : 16;

                            /* Bits[53:38], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Uniqueid : 6;

                            /* Bits[59:54], Access Type=WO, default=0x00000000*/

                            /* ID of dedup IP */
    UINT32 Rsvd60 : 3;

                            /* Bits[62:60], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Valid : 1;

                            /* Bits[63:63], Access Type=RO, default=0x00000000*/

                            /*
                               read only, indicates whether h/w accepted the
                               handle or not
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_DD_REMAP_LIST_REGISTER;

/**
  Input voltage regulator configuration parameters.
**/
#define ADL_MSR_VR_MISC_CONFIG 0x00000603

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DynamicLoadLineR : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000036*/

                            /*
                               The Dynamic load line value in 10/256 mOhm
                               increments. Values range from 0 mOhm to 10 mOhm.
                            */
    UINT32 IdleLoadLineR : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000036*/

                            /*
                               The Idle load line value in 10/256 mOhm
                               increments. Values range from 0 mOhm to 10 mOhm.
                            */
    UINT32 LeakLoadLineR : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000036*/

                            /*
                               The Leakage load line value in 10/256 mOhm
                               increments. Values range from 0 mOhm to 10 mOhm.
                            */
    UINT32 MinVid : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000000*/

                            /*
                               Used to constrain the CPU's minimum voltage
                               during package C6/C7 C-states. The default
                               setting of 0x00 will result in full CPU control
                               over the minimum VID. VID resolution is 10mV /
                               LSB. This is internally clipped by fuses to the
                               C6/C7 voltage.
                            */
    UINT32 IoutOffset : 8;

                            /* Bits[39:32], Access Type=RW, default=0x00000000*/

                            /*
                               Signed offset added to VR dIout readings for
                               correction. 2s-complement signed number
                               expressed as a fraction of the IccMax of the VR.
                               Format: S8.-4.11 (8bits, floating point shifted
                               by 4 points). Precision: 0.049% (1/2^11) Range:
                               +/-6.25% of IccMax of the VR. Allowable range
                               may be clipped by processor on a per-SKU basis.
                            */
    UINT32 IoutSlope : 10;

                            /* Bits[49:40], Access Type=RW, default=0x00000200*/

                            /*
                               This is a slope correction for VR dIout readings
                               for postitive/negative correction. This scalar
                               is applied to every dIout reading before it is
                               consumed by the CPU. This scalar represents a
                               1.x number in U10.1.9 format (0.0 to 2.0 scalar
                               in ~0.19% increments)
                            */
    UINT32 IdleExitRampRate : 1;

                            /* Bits[50:50], Access Type=RW, default=0x00000001*/

                            /*
                               Controls the VR ramp rate on package C-state
                               wake events. 1 == fast, 0 == slow. Note that
                               fast will only apply to the Fast Ramp Voltage in
                               VR_MISC_CONFIG2[7:0]
                            */
    UINT32 IdleEntryRampRate : 1;

                            /* Bits[51:51], Access Type=RW, default=0x00000000*/

                            /*
                               Controls the VR ramp rate on package C-state
                               entry events. 1 == fast, 0 == slow. If Decay is
                               set, it has priority. These are used in package
                               C6/C7/C8/C9/C10.
                            */
    UINT32 IdleEntryDecayEnable : 1;

                            /* Bits[52:52], Access Type=RW, default=0x00000001*/

                            /*
                               Enables decay mode on package C-state entry.
                               Decay mode implies PS2 or deeper. When Decay is
                               enabled, it has priority over the
                               IDLE_ENTRY_RAMP_RATE. These are used in package
                               C6/C7/C8/C9/C10.
                            */
    UINT32 SlowSlewRateConfig : 2;

                            /* Bits[54:53], Access Type=RW, default=0x00000001*/

                            /*
                               Defines the desired ratio between the VR fast
                               slope and slow slope. Pcode programs the VR on
                               BIOS complition 00 - slow = fast/2 01 - slow =
                               fast/4 (default) 10 - slow = fast/8 11 - slow =
                               fast/16
                            */
    UINT32 Rsvd55 : 9;

                            /* Bits[63:55], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_VR_MISC_CONFIG_REGISTER;
/**
  Reports the actual energy used by the platform
**/
#define ADL_MSR_PLATFORM_ENERGY_STATUS 0x0000064D

/**
  Platform power limit
**/
#define ADL_MSR_PLATFORM_POWER_LIMIT_SRVR 0x0000065C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
   UINT32 PowerLimit1 : 15;

                            /* Bits[14:0], Access Type=RW_L, default=0x00000000*/

                            /*
                               Average Power limit value which the Platform
                               must not exceed over a time window as specified
                               by Power_Limit_1_TIME field above.
                            */
    UINT32 PowerLimit1En : 1;

                            /* Bits[15:15], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, enables processor to apply control
                               policies such that the Platform average power
                               does not exceed Power_Limit_1 value over an
                               exponential weighted moving average of the time
                               window.
                            */
    UINT32 CriticalPowerClamp1 : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, allows processor to go below the OS
                               requested P States in order to maintain the
                               power below Power_Limit_1 value specified below.
                            */
    UINT32 PowerLimit1Time : 7;

                            /* Bits[23:17], Access Type=RW_L, default=0x0000000A*/

                            /*
                               This indicates the time window over which
                               Power_Limit_1 value should be maintained.
                            */
    UINT32 Rsvd24 : 8;

                            /* Bits[31:24], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PowerLimit2 : 15;

                            /* Bits[46:32], Access Type=RW_L, default=0x00000000*/

                            /*
                               Duration Power limit value which the Platform
                               must not exceed. This field is specified in the
                               units as identified by the
                               PALTFORM_POWER_SKU_UNIT (MSR606h).
                            */
    UINT32 PowerLimit2En : 1;

                            /* Bits[47:47], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, enables processor to apply control
                               policies such that the platform power does not
                               exceed Power_Limit_2 value.
                            */
    UINT32 CriticalPowerClamp2 : 1;

                            /* Bits[48:48], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, allows processor to go below the OS
                               requested P States in order to maintain the
                               power below Power_Limit_2 value specified below.
                            */
    UINT32 Rsvd49 : 14;

                            /* Bits[62:51], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Lock : 1;

                            /* Bits[63:63], Access Type=RW_KL, default=0x00000000*/

                            /* Locks all other fields. */
  } Bits;

  // struct {
    // UINT32 PowerLimit1 : 17;

                            // /* Bits[16:0], Access Type=RW_L, default=0x00000000*/

                            // /*
                               // Average Power limit value which the Platform
                               // must not exceed over a time window as specified
                               // by Power_Limit_1_TIME field above.
                            // */
    // UINT32 PowerLimit1En : 1;

                            // /* Bits[17:17], Access Type=RW_L, default=0x00000000*/

                            // /*
                               // When set, enables processor to apply control
                               // policies such that the Platform average power
                               // does not exceed Power_Limit_1 value over an
                               // exponential weighted moving average of the time
                               // window.
                            // */
    // UINT32 CriticalPowerClamp1 : 1;

                            // /* Bits[18:18], Access Type=RW_L, default=0x00000000*/

                            // /*
                               // When set, allows processor to go below the OS
                               // requested P States in order to maintain the
                               // power below Power_Limit_1 value specified below.
                            // */
    // UINT32 PowerLimit1Time : 7;

                            // /* Bits[25:19], Access Type=RW_L, default=0x0000000A*/

                            // /*
                               // This indicates the time window over which
                               // Power_Limit_1 value should be maintained.
                            // */
    // UINT32 Rsvd26 : 6;

                            // /* Bits[31:26], Access Type=RO, default=None*/

                            // /* Reserved */
    // UINT32 PowerLimit2 : 17;

                            // /* Bits[48:32], Access Type=RW_L, default=0x00000000*/

                            // /*
                               // Duration Power limit value which the Platform
                               // must not exceed. This field is specified in the
                               // units as identified by the
                               // PALTFORM_POWER_SKU_UNIT (MSR606h).
                            // */
    // UINT32 PowerLimit2En : 1;

                            // /* Bits[49:49], Access Type=RW_L, default=0x00000000*/

                            // /*
                               // When set, enables processor to apply control
                               // policies such that the platform power does not
                               // exceed Power_Limit_2 value.
                            // */
    // UINT32 CriticalPowerClamp2 : 1;

                            // /* Bits[50:50], Access Type=RW_L, default=0x00000000*/

                            // /*
                               // When set, allows processor to go below the OS
                               // requested P States in order to maintain the
                               // power below Power_Limit_2 value specified below.
                            // */
    // UINT32 Rsvd51 : 12;

                            // /* Bits[62:51], Access Type=RO, default=None*/

                            // /* Reserved */
    // UINT32 Lock : 1;

                            // /* Bits[63:63], Access Type=RW_KL, default=0x00000000*/

                            // /* Locks all other fields. */

  // } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PLATFORM_POWER_LIMIT_SRVR_REGISTER;

/**
  Package energy consumed by the entire CPU (including IA, GT and uncore).  The counter will wrap around and continue counting when it reaches its limit.
  The energy status is reported in units which are defined in PACKAGE_POWER_SKU_UNIT_MSR[ENERGY_UNIT].
**/
#define ADL_MSR_PLATFORM_POWER_INFO 0x00000665

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MaxPpl1 : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* Max PP L1 value */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MinPpl1 : 15;

                            /* Bits[31:17], Access Type=RW, default=0x00000000*/

                            /* Min PP L1 value */
    UINT32 MaxPpL2 : 17;

                            /* Bits[48:32], Access Type=RW, default=0x00000000*/

                            /* Max PP L2 value */
    UINT32 MaxTw : 7;

                            /* Bits[55:49], Access Type=RW, default=0x00000000*/

                            /* Max Time Window */
    UINT32 Rsvd56 : 8;

                            /* Bits[63:56], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PLATFORM_POWER_INFO_REGISTER;
/**
  Package energy consumed by the entire CPU (including IA, GT and uncore).  The counter will wrap around and continue counting when it reaches its limit.
  The energy status is reported in units which are defined in PACKAGE_POWER_SKU_UNIT_MSR[ENERGY_UNIT].
**/
#define ADL_MSR_PLATFORM_RAPL_SOCKET_PERF_STATUS 0x00000666

/**
  CET user configuration MSR
**/
#define ADL_MSR_U_CET 0x000006A0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ShStkEn : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Enable shadow stacks */
    UINT32 WrShstkEn : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* Enable WRSS instruction */
    UINT32 EndbrEn : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* Enable indirect call/jmp tracking */
    UINT32 LegiwEn : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               Enable legacy interworking for indirect
                               calls/jumps tracking
                            */
    UINT32 NoTrackEn : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               Enables use of 3E byte as "no-track" prefix for
                               indirect calls and jumps
                            */
    UINT32 SuppressDis : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               disables suppression of CET indirect branch
                               tracking on legacy interwork (each violation
                               requires re-check via bitmap)
                            */
    UINT32 Rsvd6 : 4;

                            /* Bits[9:6], Access Type=RW, default=0x00000000*/

                            /* reserved */
    UINT32 Suppress : 1;

                            /* Bits[10:10], Access Type=RW_V, default=0x00000000*/

                            /* Suppresses state of ENDBRANCH tracker4 */
    UINT32 Tracker : 1;

                            /* Bits[11:11], Access Type=RW_V, default=0x00000000*/

                            /*
                               State of ENDBRANCH tracker [0: idle, 1: wait for
                               endbranch]
                            */
    UINT32 EbLegBitmapBase0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* Linear address of bitmap of legacy code pages */
    UINT32 EbLegBitmapBase1 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Linear address of bitmap of legacy code pages */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_U_CET_REGISTER;

/**
  CET supervisor configuration MSR
**/
#define ADL_MSR_S_CET 0x000006A2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ShStkEn : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Enable shadow stacks */
    UINT32 WrShstkEn : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* Enable WRSS instruction */
    UINT32 EndbrEn : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* Enable indirect call/jmp tracking */
    UINT32 LegiwEn : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               Enable legacy interworking for indirect
                               calls/jumps tracking
                            */
    UINT32 NoTrackEn : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               Enables use of 3E byte as "no-track" prefix for
                               indirect calls and jumps
                            */
    UINT32 SuppressDis : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               disables suppression of CET indirect branch
                               tracking on legacy interwork (each violation
                               requires re-check via bitmap)
                            */
    UINT32 Rsvd6 : 4;

                            /* Bits[9:6], Access Type=RW, default=0x00000000*/

                            /* reserved */
    UINT32 Suppress : 1;

                            /* Bits[10:10], Access Type=RW_V, default=0x00000000*/

                            /* Suppresses state of ENDBRANCH tracker4 */
    UINT32 Tracker : 1;

                            /* Bits[11:11], Access Type=RW_V, default=0x00000000*/

                            /*
                               State of ENDBRANCH tracker [0: idle, 1: wait for
                               endbranch]
                            */
    UINT32 EbLegBitmapBase0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* Linear address of bitmap of legacy code pages */
    UINT32 EbLegBitmapBase1 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Linear address of bitmap of legacy code pages */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_S_CET_REGISTER;
/**
  CET register to hold CPL0s shadow stack pointer on transition to CPL3
**/
#define ADL_MSR_PL0_SSP 0x000006A4
/**
  CET register to hold CPL1s shadow stack pointer on transition to CPL3
**/
#define ADL_MSR_PL1_SSP 0x000006A5
/**
  CET register to hold CPL2s shadow stack pointer on transition to CPL3
**/
#define ADL_MSR_PL2_SSP 0x000006A6
/**
  CET register to hold CPL3s shadow stack pointer on transition to CPL smaller than 3
**/
#define ADL_MSR_PL3_SSP 0x000006A7
/**
  linear address of the table of pointers to shadow stacks to be switched to when initiating a stack switch in 64 bit mode through IST mechanism. Must be machine canonical when written in 64 bit mode. On parts that do not support 64 bit mode, this MSR is not present.
**/
#define ADL_MSR_INTERRUPT_SSP_TABLE 0x000006A8

/**
  Controls the operation of the the PMON Counter 1 in IDP 0.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCtrClr] is set to 1b.
**/
#define ADL_MSR_PERFEVTSEL0_0 0x00000705

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               a selector for measured signals Details of
                               events are TBD
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               A set of qualifiers defined for each of the
                               events. Details for the counter are TBD.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Enubp : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the generation of micro-breakpoint event
                               on event occurrence. 0b Do not assert micro-
                               breakpoint on event occurrence 1b Assert micro-
                               breakpoint on event occurrence
                            */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Enable generation of Overfolow indiation when
                               this counter overflows. 0 : PMI Event for this
                               counter is disabled 1 : PMI event is enabled
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RO, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active. 0 : counter is disabled and
                               will not count when global enable is set. 1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Invert the event for counting purposes : 0 :
                               Count when the event is asserted or on it's
                               rising edge 1. : Count when the event is de-
                               asserted or on it's falling edge
                            */
    UINT32 Threshold : 5;

                            /* Bits[28:24], Access Type=RW, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming increment value from event increment
                               bus. The width of this field is determined by
                               the widest event in the iMPH (which is 5 bits
                               for queue occupancy). The result of the
                               comparison is effectiv When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification (i.e. the counter
                               will adevance by the specified increment value).
                            */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PERFEVTSEL0_0_REGISTER;

/**
  Controls the operation of the the PMON Counte 2 in IDP 0.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCtrClr] is set to 1b.
**/
#define ADL_MSR_PERFEVTSEL1_1 0x00000706

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               a selector for measured signals Details of
                               events are TBD
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               A set of qualifiers defined for each of the
                               events. Details for the counter are TBD.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Enubp : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the generation of micro-breakpoint event
                               on event occurrence. 0b Do not assert micro-
                               breakpoint on event occurrence 1b Assert micro-
                               breakpoint on event occurrence
                            */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Enable generation of Overfolow indiation when
                               this counter overflows. 0 : PMI Event for this
                               counter is disabled 1 : PMI event is enabled
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RO, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active. 0 : counter is disabled and
                               will not count when global enable is set. 1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Invert the event for counting purposes : 0 :
                               Count when the event is asserted or on it's
                               rising edge 1. : Count when the event is de-
                               asserted or on it's falling edge
                            */
    UINT32 Threshold : 5;

                            /* Bits[28:24], Access Type=RW, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming increment value from event increment
                               bus. The width of this field is determined by
                               the widest event in the iMPH (which is 5 bits
                               for queue occupancy). The result of the
                               comparison is effectivly a 1 bit wide event,
                               i.e., the counter will be incremented by 1 when
                               the comparison is true (the type of comparison
                               depends on the setting of the Invert bit) no
                               matter how wide the original event was.
                            */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PERFEVTSEL1_1_REGISTER;

/**
  IDP 0 PMON Counter 1  data register
  The Fix counter is counting UCLK cycles.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCntClr] is set to 1b.
**/
#define ADL_MSR_PERFCTR0_0 0x00000709

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PERFCTR0_0_REGISTER;

/**
  IDP 0 PMON Counter 2  data register
  The Fix counter is counting UCLK cycles.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCntClr] is set to 1b.
**/
#define ADL_MSR_PERFCTR1_1 0x0000070A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PERFCTR1_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0 0x00000738

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1 0x00000739

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0 0x0000073A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1 0x0000073B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_REGISTER;

/**
  Has only one field with one bit - Defines which HWP Request MSR is used whether Thread level or package level. When package MSR is used, the thread MSR valid bits define which thread MSR fields override the package (default 0)
**/
#define ADL_MSR_IA32_HWP_CTL 0x00000776

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PkgCtlPolarity : 1;

                            /* Bits[0:0], Access Type=RO_V, default=None*/

                            /*
                               Defines which HWP Request MSR is used whether
                               Thread level or package level. When package MSR
                               is used, the thread MSR valid bits define which
                               thread MSR fields override the package (default
                               0)
                            */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_IA32_HWP_CTL_REGISTER;

/**
  Equivalent to architectural DR6 reg. 16 bit.
  (Mrm roctlregc/roctlregd/{tmpdr6lowSM306L|tmpdr6hiSM306L})
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  !!!                                                                            !!!
  !!! CAUTION: Adding more bits to this creg or changing the layout of this creg !!!
  !!! will require MSR ucode changes. Talk to MSR ucode owner (rpartha on NHM) if!!!
  !!! you want to make changes to this creg                                      !!!
  !!!                                                                            !!!
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
**/
#define ADL_MSR_TMPDR6 0x00000902

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 B0 : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6B0 */
    UINT32 B1 : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6B1 */
    UINT32 B2 : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6B2 */
    UINT32 B3 : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6B3 */
    UINT32 Rsvd4 : 6;

                            /* Bits[9:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 NoCommitStart : 1;

                            /* Bits[10:10], Access Type=RW_V, default=0x00000000*/

                            /* indication that NO_COMMIT counting started */
    UINT32 BusLock : 1;

                            /* Bits[11:11], Access Type=RW_V, default=0x00000000*/

                            /* pending #DB due BUS LOCK */
    UINT32 Rsvd12 : 1;

                            /* Bits[12:12], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Bd : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /* ROBTMPDR6BD */
    UINT32 Bs : 1;

                            /* Bits[14:14], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6BS */
    UINT32 Bt : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* ROBTMPDR6BT */
    UINT32 Hled : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6HLED */
    UINT32 EnclaveInterruption : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enclave interruption indication. Cleared by HW
                               on retired EOM
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_TMPDR6_REGISTER;

/**
  Holds address bits [11:0] of a guest load/store access that hit the AVRR range
  C6NoSave Candidate
  FSCP Crunch:  12:32 Used only 12 bits out of 32
**/
#define ADL_MSR_VMX_VMENTRY_AVRR_UTT_MAILBOX 0x00000907

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MailboxOffset : 12;

                            /* Bits[11:0], Access Type=RW, default=None*/

                            /*
                               Mailbox address bits [11:0] of a guest
                               load/store access that hit the AVRR range
                            */
    UINT32 Reserved12 : 19;

                            /* Bits[30:12], Access Type=RW, default=None*/

                            /* Unused */
    UINT32 Senduipi : 1;

                            /* Bits[31:31], Access Type=RW, default=None*/

                            /*
                               Indicates that this is a VAPIC write from
                               SENDUIPI instruction
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_VMX_VMENTRY_AVRR_UTT_MAILBOX_REGISTER;

/**
  Holds XSAVE_AREA XCompaction vector for the XMODIFIED optimization.
**/
#define ADL_MSR_XRSTOR_XCOMPACTION_VECTOR 0x00000911

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 XcompactionVector : 10;

                            /* Bits[9:0], Access Type=RW, default=None*/

                            /*
                               Bit 0 => FP Bit 1 => SSE Bit 2 => GSSE Bit 3 =>
                               PL BNDREGS Bit 4 => PL BNDCFS Bit 5 => KMASK Bit
                               6 => AVX3(15:0) Bit 7 => AVX3(31:16) Bit 8 =>
                               RTIT (reserved - actual bit in IA_XSS) Bit 9 =>
                               PKRU
                            */
    UINT32 Rsvd10 : 21;

                            /* Bits[30:10], Access Type=RW, default=None*/

                            /* Available for use */
    UINT32 XcompInUse : 1;

                            /* Bits[31:31], Access Type=RW, default=None*/

                            /*
                               Save area for XRSTOR_INFO used XCOMPACTION, or
                               VECTOR in this MSR is valid.
                            */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /* Available for use */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_XRSTOR_XCOMPACTION_VECTOR_REGISTER;

/**
  Maps to ML3_CR_PIC_EVENT_STATUS (lower 32b) and ROB1_CR_PIC_EVENT_STATUS (upper 32b)
**/
#define ADL_MSR_PPPE_EVENT_STATUS 0x00000925

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Intr : 1;

                            /* Bits[0:0], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : INTR */
    UINT32 Rsvd1 : 1;

                            /* Bits[1:1], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : A20M */
    UINT32 Init : 1;

                            /* Bits[2:2], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : INIT */
    UINT32 Nmi : 1;

                            /* Bits[3:3], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : NMI */
    UINT32 Smi : 1;

                            /* Bits[4:4], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : SMI */
    UINT32 Psmi : 1;

                            /* Bits[5:5], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : PSMI */
    UINT32 Monitor : 1;

                            /* Bits[6:6], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : MONITOR */
    UINT32 Sipi : 1;

                            /* Bits[7:7], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : SIPI */
    UINT32 LtDoorbell : 1;

                            /* Bits[8:8], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : LT_DOORBELL */
    UINT32 VmxTimer : 1;

                            /* Bits[9:9], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : VMX_TIMER */
    UINT32 Preq : 1;

                            /* Bits[10:10], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : PREQ */
    UINT32 Mcakind : 1;

                            /* Bits[11:11], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : MCAKIND */
    UINT32 CpdEnter : 1;

                            /* Bits[12:12], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : CPD_ENTER */
    UINT32 CpdExit : 1;

                            /* Bits[13:13], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : CPD_EXIT */
    UINT32 UncoreTrap : 1;

                            /* Bits[14:14], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : UNCORE_TRAP */
    UINT32 AsyncMca : 1;

                            /* Bits[15:15], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : ASYNC_MCA */
    UINT32 GoCore : 1;

                            /* Bits[16:16], Access Type=RO_V, default=0x00000000*/

                            /* Event Status GO CORE */
    UINT32 GoThread : 1;

                            /* Bits[17:17], Access Type=RO_V, default=0x00000000*/

                            /* Event Status GO THREAD */
    UINT32 Rar : 1;

                            /* Bits[18:18], Access Type=RO_V, default=0x00000000*/

                            /* Event Status RAR */
    UINT32 Vrar : 1;

                            /* Bits[19:19], Access Type=RO_V, default=0x00000000*/

                            /* Event Status VRAR */
    UINT32 MceSmi : 1;

                            /* Bits[20:20], Access Type=RO_V, default=0x00000000*/

                            /*
                               When Set indicates SMI is pended due to MCE_CTL
                               setting in core or uncore MCi_Ctl2 register
                            */
    UINT32 CmciSmi : 1;

                            /* Bits[21:21], Access Type=RO_V, default=0x00000000*/

                            /*
                               When Set indicates SMI is pended due to CMCI_CTL
                               setting in core or uncore MCi_Ctl2 register
                            */
    UINT32 MwaitTimerMonitor : 1;

                            /* Bits[22:22], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : MWAIT_TIMER_MONITOR */
    UINT32 Rmca : 1;

                            /* Bits[23:23], Access Type=RO_V, default=0x00000000*/

                            /*
                               When Set indicates MCKIND is pended due to rMCA
                               setting in core or uncore register
                            */
    UINT32 Rmsmi : 1;

                            /* Bits[24:24], Access Type=RO_V, default=0x00000000*/

                            /*
                               When Set indicates SMI is pended due to rMSMI
                               setting in core or uncore register
                            */
    UINT32 Rsvd25 : 7;

                            /* Bits[31:25], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 1;

                            /* Bits[32:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RestartMicro : 1;

                            /* Bits[33:33], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for Restart micro */
    UINT32 Rsvd34 : 2;

                            /* Bits[35:34], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CorrectableMc : 1;

                            /* Bits[36:36], Access Type=RO_V, default=0x00000000*/

                            /*
                               Pending status for Machine Check event. set when
                               Parity Error is detected.
                            */
    UINT32 RtitMem : 1;

                            /* Bits[37:37], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for RTIT mem event */
    UINT32 Monitortrap : 1;

                            /* Bits[38:38], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for Monitor trap */
    UINT32 Btm : 1;

                            /* Bits[39:39], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for Branch trace message */
    UINT32 Smc : 1;

                            /* Bits[40:40], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for SMC */
    UINT32 Virtualnuke : 1;

                            /* Bits[41:41], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for Virtual Nuke */
    UINT32 PeMicrotrap : 1;

                            /* Bits[42:42], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for PE microtrap */
    UINT32 UcodeMacrotrap : 1;

                            /* Bits[43:43], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for Ucode macrotrap */
    UINT32 Crd : 1;

                            /* Bits[44:44], Access Type=RO_V, default=0x00000000*/

                            /*
                               Pending status for Core Retirement Detector
                               (CRD) event
                            */
    UINT32 Rop : 1;

                            /* Bits[45:45], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for ROP event */
    UINT32 UcodeThreadTrap : 1;

                            /* Bits[46:46], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for UCODE_THREAD_TRAP event */
    UINT32 RtitFlush : 1;

                            /* Bits[47:47], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for RTIT flush event */
    UINT32 Nmip : 1;

                            /* Bits[48:48], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for NMIP */
    UINT32 TxAbortMisspec : 1;

                            /* Bits[49:49], Access Type=RO_V, default=0x00000000*/

                            /*
                               Pending status for TX_ABORT due to MEU
                               Misspeculation
                            */
    UINT32 TxAbortWatchdog : 1;

                            /* Bits[50:50], Access Type=RO_V, default=0x00000000*/

                            /*
                               Pending status for TX_ABORT due to Watchdog Time
                               out
                            */
    UINT32 TxCatastrophicAbort : 1;

                            /* Bits[51:51], Access Type=RO_V, default=0x00000000*/

                            /*
                               Pending status for TX catatrophic abort which is
                               taken as soon as it's posted
                            */
    UINT32 Pebs : 12;

                            /* Bits[63:52], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for PEBS event per counter */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PPPE_EVENT_STATUS_REGISTER;

/**
  Maps to ML3_CR_PIC_EVENT_SET (lower 32b) and ROB1_CR_PIC_EVENT_SET (upper 32b)
**/
#define ADL_MSR_PPPE_EVENT_SET 0x00000926

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Intr : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /* Event Set : INTR */
    UINT32 Rsvd1 : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /* used to be A20M */
    UINT32 Init : 1;

                            /* Bits[2:2], Access Type=WO, default=0x00000000*/

                            /* Event Set : INIT */
    UINT32 Nmi : 1;

                            /* Bits[3:3], Access Type=WO, default=0x00000000*/

                            /* Event Set : NMI */
    UINT32 Smi : 1;

                            /* Bits[4:4], Access Type=WO, default=0x00000000*/

                            /* Event Set : SMI */
    UINT32 Psmi : 1;

                            /* Bits[5:5], Access Type=WO, default=0x00000000*/

                            /* Event Set : PSMI */
    UINT32 Monitor : 1;

                            /* Bits[6:6], Access Type=WO, default=0x00000000*/

                            /* Event Set : MONITOR */
    UINT32 Sipi : 1;

                            /* Bits[7:7], Access Type=WO, default=0x00000000*/

                            /* Event Set : SIPI */
    UINT32 LtDoorbell : 1;

                            /* Bits[8:8], Access Type=WO, default=0x00000000*/

                            /* Event Set : LT_DOORBELL */
    UINT32 VmxTimer : 1;

                            /* Bits[9:9], Access Type=WO, default=0x00000000*/

                            /* Event Set : VMX_TIMER */
    UINT32 Preq : 1;

                            /* Bits[10:10], Access Type=WO, default=0x00000000*/

                            /* Event Set : PREQ */
    UINT32 Mcakind : 1;

                            /* Bits[11:11], Access Type=WO, default=0x00000000*/

                            /* Event Set : MCAKIND */
    UINT32 CpdEnter : 1;

                            /* Bits[12:12], Access Type=WO, default=0x00000000*/

                            /* Event Set : CPD_ENTER */
    UINT32 CpdExit : 1;

                            /* Bits[13:13], Access Type=WO, default=0x00000000*/

                            /* Event Set : CPD_EXIT */
    UINT32 UncoreTrap : 1;

                            /* Bits[14:14], Access Type=WO, default=0x00000000*/

                            /* Event Set : UNCORE_TRAP */
    UINT32 AsyncMca : 1;

                            /* Bits[15:15], Access Type=WO, default=0x00000000*/

                            /* Event Set : ASYNC_MCA */
    UINT32 GoCore : 1;

                            /* Bits[16:16], Access Type=WO, default=0x00000000*/

                            /* Event Set GO CORE */
    UINT32 GoThread : 1;

                            /* Bits[17:17], Access Type=WO, default=0x00000000*/

                            /* Event Set GO THREAD */
    UINT32 Rar : 1;

                            /* Bits[18:18], Access Type=WO, default=0x00000000*/

                            /* Event Set RAR */
    UINT32 Vrar : 1;

                            /* Bits[19:19], Access Type=WO, default=0x00000000*/

                            /* Event Set VRAR */
    UINT32 MceSmi : 1;

                            /* Bits[20:20], Access Type=WO, default=0x00000000*/

                            /* Event set MCE_SMI */
    UINT32 CmciSmi : 1;

                            /* Bits[21:21], Access Type=WO, default=0x00000000*/

                            /* Event set CMCI_SMI */
    UINT32 MwaitTimerMonitor : 1;

                            /* Bits[22:22], Access Type=WO, default=0x00000000*/

                            /* Event set : MWAIT_TIMER_MONITOR */
    UINT32 Rmca : 1;

                            /* Bits[23:23], Access Type=WO, default=0x00000000*/

                            /* Event set RMCA */
    UINT32 Rmsmi : 1;

                            /* Bits[24:24], Access Type=WO, default=0x00000000*/

                            /* Event set RMSMI */
    UINT32 Rsvd25 : 7;

                            /* Bits[31:25], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 1;

                            /* Bits[32:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RestartMicro : 1;

                            /* Bits[33:33], Access Type=WO, default=0x00000000*/

                            /* Pending state for Restart micro */
    UINT32 Rsvd34 : 2;

                            /* Bits[35:34], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CorrectableMc : 1;

                            /* Bits[36:36], Access Type=WO, default=0x00000000*/

                            /*
                               Pending status for Machine Check event. set when
                               Parity Error is detected.
                            */
    UINT32 RtitMem : 1;

                            /* Bits[37:37], Access Type=WO, default=0x00000000*/

                            /* Pending status for RTIT mem event */
    UINT32 Monitortrap : 1;

                            /* Bits[38:38], Access Type=WO, default=0x00000000*/

                            /* Pending state for Monitor trap */
    UINT32 Btm : 1;

                            /* Bits[39:39], Access Type=WO, default=0x00000000*/

                            /* Pending state for Branch trace message */
    UINT32 Smc : 1;

                            /* Bits[40:40], Access Type=WO, default=0x00000000*/

                            /* Pending state for SMC */
    UINT32 Virtualnuke : 1;

                            /* Bits[41:41], Access Type=WO, default=0x00000000*/

                            /* Pending state for Virtual Nuke */
    UINT32 PeMicrotrap : 1;

                            /* Bits[42:42], Access Type=WO, default=0x00000000*/

                            /* Pending status for PE microtrap */
    UINT32 UcodeMacrotrap : 1;

                            /* Bits[43:43], Access Type=WO, default=0x00000000*/

                            /* Pending state for Ucode macrotrap */
    UINT32 Crd : 1;

                            /* Bits[44:44], Access Type=WO, default=0x00000000*/

                            /* Set Core Retirement Detector (CRD) pending state */
    UINT32 Rop : 1;

                            /* Bits[45:45], Access Type=WO, default=0x00000000*/

                            /* Pending state for FERR_OVERFLOW event */
    UINT32 UcodeThreadTrap : 1;

                            /* Bits[46:46], Access Type=WO, default=0x00000000*/

                            /* Pending status for UCODE_THREAD_TRAP event */
    UINT32 RtitFlush : 1;

                            /* Bits[47:47], Access Type=WO, default=0x00000000*/

                            /* Pending status for RTIT event */
    UINT32 Nmip : 1;

                            /* Bits[48:48], Access Type=WO, default=0x00000000*/

                            /* Pending status for NMIP */
    UINT32 TxAbortMisspec : 1;

                            /* Bits[49:49], Access Type=WO, default=0x00000000*/

                            /*
                               Pending status for TX_ABORT due to MEU
                               Misspeculation
                            */
    UINT32 TxAbortWatchdog : 1;

                            /* Bits[50:50], Access Type=WO, default=0x00000000*/

                            /*
                               Pending status for TX_ABORT due to Watchdog Time
                               out
                            */
    UINT32 TxCatastrophicAbort : 1;

                            /* Bits[51:51], Access Type=WO, default=0x00000000*/

                            /*
                               Pending status for TX catatrophic abort which is
                               taken as soon as it's posted
                            */
    UINT32 Pebs : 12;

                            /* Bits[63:52], Access Type=WO, default=0x00000000*/

                            /* Pending status for PEBS event per counter */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PPPE_EVENT_SET_REGISTER;

/**
  Maps to ML3_CR_PIC_EVENT_RESET (lower 32b) and ROB1_CR_PIC_EVENT_RESET (upper 32b)
**/
#define ADL_MSR_PPPE_EVENT_RESET 0x00000927

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Intr : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /* Reset Event INTR */
    UINT32 Rsvd1 : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /* Event Reset : A20M */
    UINT32 Init : 1;

                            /* Bits[2:2], Access Type=WO, default=0x00000000*/

                            /* Event Reset : INIT */
    UINT32 Nmi : 1;

                            /* Bits[3:3], Access Type=WO, default=0x00000000*/

                            /* Event Reset : NMI */
    UINT32 Smi : 1;

                            /* Bits[4:4], Access Type=WO, default=0x00000000*/

                            /* Event Reset : SMI */
    UINT32 Psmi : 1;

                            /* Bits[5:5], Access Type=WO, default=0x00000000*/

                            /* Event Reset : PSMI */
    UINT32 Monitor : 1;

                            /* Bits[6:6], Access Type=WO, default=0x00000000*/

                            /*
                               Event Reset : MONITOR: Doesn't write
                               ML3_CR_PIC_EVENT_RESET_MONITOR but clears the
                               MONITOR FSM with a spcl cycle
                            */
    UINT32 Sipi : 1;

                            /* Bits[7:7], Access Type=WO, default=0x00000000*/

                            /* Event Reset : SIPI */
    UINT32 LtDoorbell : 1;

                            /* Bits[8:8], Access Type=WO, default=0x00000000*/

                            /* Event Reset : LT_DOORBELL */
    UINT32 VmxTimer : 1;

                            /* Bits[9:9], Access Type=WO, default=0x00000000*/

                            /* Event Reset : VMX_TIMER */
    UINT32 Preq : 1;

                            /* Bits[10:10], Access Type=WO, default=0x00000000*/

                            /* Event Reset : PREQ */
    UINT32 Mcakind : 1;

                            /* Bits[11:11], Access Type=WO, default=0x00000000*/

                            /* Event Reset : MCAKIND */
    UINT32 CpdEnter : 1;

                            /* Bits[12:12], Access Type=WO, default=0x00000000*/

                            /* Event Reset : CPD_ENTER */
    UINT32 CpdExit : 1;

                            /* Bits[13:13], Access Type=WO, default=0x00000000*/

                            /* Event Reset : CPD_EXIT */
    UINT32 UncoreTrap : 1;

                            /* Bits[14:14], Access Type=WO, default=0x00000000*/

                            /* Event Reset : UNCORE_TRAP */
    UINT32 AsyncMca : 1;

                            /* Bits[15:15], Access Type=WO, default=0x00000000*/

                            /* Event Reset : ASYNC_MCA */
    UINT32 GoCore : 1;

                            /* Bits[16:16], Access Type=WO, default=0x00000000*/

                            /* Event Reset GO CORE */
    UINT32 GoThread : 1;

                            /* Bits[17:17], Access Type=WO, default=0x00000000*/

                            /* Event Reset GO THREAD */
    UINT32 Rar : 1;

                            /* Bits[18:18], Access Type=WO, default=0x00000000*/

                            /* Event Reset RAR */
    UINT32 Vrar : 1;

                            /* Bits[19:19], Access Type=WO, default=0x00000000*/

                            /* Event Reset VRAR */
    UINT32 MceSmi : 1;

                            /* Bits[20:20], Access Type=WO, default=0x00000000*/

                            /* Event Reset MCE_SMI */
    UINT32 CmciSmi : 1;

                            /* Bits[21:21], Access Type=WO, default=0x00000000*/

                            /* Event Reset CMCI_SMI */
    UINT32 MwaitTimerMonitor : 1;

                            /* Bits[22:22], Access Type=WO, default=0x00000000*/

                            /* Event Reset : MWAIT_TIMER_MONITOR */
    UINT32 Rmca : 1;

                            /* Bits[23:23], Access Type=WO, default=0x00000000*/

                            /* Event Reset RMCA */
    UINT32 Rmsmi : 1;

                            /* Bits[24:24], Access Type=WO, default=0x00000000*/

                            /* Event Reset RMSMI */
    UINT32 Rsvd25 : 7;

                            /* Bits[31:25], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 1;

                            /* Bits[32:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RestartMicro : 1;

                            /* Bits[33:33], Access Type=WO, default=0x00000000*/

                            /* Pending state for Restart micro */
    UINT32 Rsvd34 : 2;

                            /* Bits[35:34], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CorrectableMc : 1;

                            /* Bits[36:36], Access Type=WO, default=0x00000000*/

                            /* Clear state correctable mc */
    UINT32 RtitMem : 1;

                            /* Bits[37:37], Access Type=WO, default=0x00000000*/

                            /* Pending status for RTIT memory event */
    UINT32 Monitortrap : 1;

                            /* Bits[38:38], Access Type=WO, default=0x00000000*/

                            /* Pending state for Monitor trap */
    UINT32 Btm : 1;

                            /* Bits[39:39], Access Type=WO, default=0x00000000*/

                            /* Pending state for Branch trace message */
    UINT32 Smc : 1;

                            /* Bits[40:40], Access Type=WO, default=0x00000000*/

                            /* Pending state for SMC */
    UINT32 Virtualnuke : 1;

                            /* Bits[41:41], Access Type=WO, default=0x00000000*/

                            /* Pending state for Virtual Nuke */
    UINT32 PeMicrotrap : 1;

                            /* Bits[42:42], Access Type=WO, default=0x00000000*/

                            /* Pending status for PE microtrap */
    UINT32 UcodeMacrotrap : 1;

                            /* Bits[43:43], Access Type=WO, default=0x00000000*/

                            /* Pending state for Ucode macrotrap */
    UINT32 Crd : 1;

                            /* Bits[44:44], Access Type=WO, default=0x00000000*/

                            /*
                               Clear Core Retirement Detector (CRD) pending
                               state
                            */
    UINT32 Rop : 1;

                            /* Bits[45:45], Access Type=WO, default=0x00000000*/

                            /* Pending state for ROP event */
    UINT32 UcodeThreadTrap : 1;

                            /* Bits[46:46], Access Type=WO, default=0x00000000*/

                            /* Clear state for UCODE_THREAD_TRAP event */
    UINT32 RtitFlush : 1;

                            /* Bits[47:47], Access Type=WO, default=0x00000000*/

                            /* Clear state for RTIT event */
    UINT32 Nmip : 1;

                            /* Bits[48:48], Access Type=WO, default=0x00000000*/

                            /* Clear state for NMIP */
    UINT32 TxAbortMisspec : 1;

                            /* Bits[49:49], Access Type=WO, default=0x00000000*/

                            /*
                               Clear state for TX_ABORT due to MEU
                               Misspeculation
                            */
    UINT32 TxAbortWatchdog : 1;

                            /* Bits[50:50], Access Type=WO, default=0x00000000*/

                            /*
                               Clear state for TX_ABORT due to Watchdog Time
                               out
                            */
    UINT32 TxCatastrophicAbort : 1;

                            /* Bits[51:51], Access Type=WO, default=0x00000000*/

                            /*
                               Clear state for TX catatrophic abort which is
                               taken as soon as it's posted
                            */
    UINT32 Pebs : 12;

                            /* Bits[63:52], Access Type=WO, default=0x00000000*/

                            /* Clear state for PEBS event per counter */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PPPE_EVENT_RESET_REGISTER;

/**
  This is a new PerfMon register is used for future user-invisible controls to be shadowed in all PerfMon units.
**/
#define ADL_MSR_PERMON_EVNTSEL_AUX 0x00000966

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 BlkCnt : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               manageable by x/ucode. Suppress PMON/ROP
                               counting in SE restrictions : None
                            */
    UINT32 BlkRtitTrc : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               manageable by x/ucode. used to suppress
                               ContextEn on opt-out enclave entries
                               restrictions : None
                            */
    UINT32 BlkRop : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               manageable by x/ucode. used to suppress ROP
                               counters on opt-out enclave entries restrictions
                               : None
                            */
    UINT32 BlkLbr : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               manageable by x/ucode. used to suppress LBR on
                               opt-out enclave entries restrictions : None
                            */
    UINT32 InC02 : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               indication that core in C0.2 state restrictions
                               : None
                            */
    UINT32 DisableCounting : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               when this bit is set the pmon events
                               THREADS_ACTIVE.IN_C0E2 and
                               THREADS_ACTIVE.IN_C0E1 will not be active
                            */
    UINT32 Rsvd6 : 26;

                            /* Bits[31:6], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PERMON_EVNTSEL_AUX_REGISTER;

/**
  Holds XCR0 and XSAVE Compaction Vector (used for XMODIFIED optimization check)
**/
#define ADL_MSR_XCR0 0x0000096D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 X87 : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* Bit 0 => FP */
    UINT32 Sse : 1;

                            /* Bits[1:1], Access Type=RW, default=None*/

                            /* Bit 1 => SSE */
    UINT32 Gsse : 1;

                            /* Bits[2:2], Access Type=RW, default=None*/

                            /* Bit 2 => GSSE */
    UINT32 PlBndregs : 1;

                            /* Bits[3:3], Access Type=RW, default=None*/

                            /* Bit 3 => PL BNDREGS */
    UINT32 PlBndcfs : 1;

                            /* Bits[4:4], Access Type=RW, default=None*/

                            /* Bit 4 => PL BNDCFS */
    UINT32 Kmask : 1;

                            /* Bits[5:5], Access Type=RW, default=None*/

                            /* Bit 5 => KMASK */
    UINT32 Avx3150 : 1;

                            /* Bits[6:6], Access Type=RW, default=None*/

                            /* Bit 6 => AVX3(15:0) */
    UINT32 Avx33116 : 1;

                            /* Bits[7:7], Access Type=RW, default=None*/

                            /* Bit 7 => AVX3(31:16) */
    UINT32 RsvdIaXssRtit8 : 1;

                            /* Bits[8:8], Access Type=RW, default=None*/

                            /*
                               Bit 8 is reserved because of use as RTIT bit in
                               IA_XSS.
                            */
    UINT32 Pkru : 1;

                            /* Bits[9:9], Access Type=RW, default=None*/

                            /* Bit 9 => Page Protection Keys User. */
    UINT32 Rsvd10 : 7;

                            /* Bits[16:10], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Xtileconfig : 1;

                            /* Bits[17:17], Access Type=RW, default=None*/

                            /* Bit 17 => XTILECONFIG */
    UINT32 Xtiledata : 1;

                            /* Bits[18:18], Access Type=RW, default=None*/

                            /* Bit 18 => XTILEDATA */
    UINT32 Rsvd19 : 13;

                            /* Bits[31:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_XCR0_REGISTER;

/**
  Read only register for encryption policies supported by TME
**/
#define ADL_MSR_TME_CAPABILITY 0x00000981

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 AesXts128 : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000001*/

                            /* Enumerate support for AES-XTS */
    UINT32 AesXts128WithIntegrity : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000001*/

                            /* Enumerate support for AES-XTS */
    UINT32 AesXts256 : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000001*/

                            /* Enumerate support for AES-XTS */
    UINT32 Rsvd3 : 29;

                            /* Bits[31:3], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 MkTmeMaxKeyidBits : 4;

                            /* Bits[35:32], Access Type=RW, default=0x00000000*/

                            /*
                               Number of bits which can be allocated for usage
                               as key identifiers for multi-key memory
                               encryption. Zero if MK-TME is not support
                            */
    UINT32 MkTmeMaxKeys : 15;

                            /* Bits[50:36], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates the maximum number of keys which are
                               available for usage and may be a non-power of 2.
                               This maximum value of this field will be
                               (2^MK_TME_MAX_KEYID_BITS)-1. Zero if MK-TME is
                               not supported
                            */
    UINT32 NmEncryptionDisable : 1;

                            /* Bits[51:51], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd52 : 11;

                            /* Bits[62:52], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 ImplicitBitMask : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000001*/

                            /* Uarch bit: KeyID Mask size selector */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_TME_CAPABILITY_REGISTER;

/**
  Rd/Wr register to generate or restore Keys for TME
**/
#define ADL_MSR_TME_ACTIVATE 0x00000982

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lock : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Will be set upon successful WRMSR; written
                               valuei gnored Lock for MSRs: IA32_TME_ACTIVATE
                               IA32_TME_EXCLUDE_MASK IA32_TME_EXCLUDE_BASE
                            */
    UINT32 TmeEnable : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               Set to enable TME Encryption using DRNG
                               operation
                            */
    UINT32 KeySelect : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               0 - Create a new ke (expected cold/warm boot) 1
                               - Restore the key from storage (Expected when
                               resume from standby)
                            */
    UINT32 SaveKeyForStandby : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               Save key into storage to be used when resume
                               from standby
                            */
    UINT32 TmePolicy : 4;

                            /* Bits[7:4], Access Type=RW, default=0x00000000*/

                            /* 0000 = AES-XTS Other Values are reserved */
    UINT32 SgxTemEnable : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /* Enables TME for SGX-TEM. */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RW, default=0x00000000*/

                            /*
                               Reserved Bits; Must be 0, Upper 32 bits are
                               enforced through reserved checking
                            */
    UINT32 MkTmeKeyidBits : 4;

                            /* Bits[35:32], Access Type=RW, default=0x00000000*/

                            /*
                               the number of key identifier bits to allocate to
                               MK-TME usage. Similar to enumeration, this is an
                               encoded value. Writing a value greater than
                               MK_TME_MAX_KEYID_BITS will result in #GP.
                               Writing a non-zero value to this field will #GP
                               if bit 1 (TME Enable) is not set to '1, as TME
                               must be enabled to use MK-TME.
                            */
    UINT32 TdxHkidThreshold : 4;

                            /* Bits[39:36], Access Type=RW, default=0x00000000*/

                            /*
                               N Total # of KIDs bits and L # of bits below
                               MAX_PA that are "Reserved"
                            */
    UINT32 Rsvd40 : 8;

                            /* Bits[47:40], Access Type=RW, default=0x00000000*/

                            /*
                               Reserved Bits; Must be 0, Upper 32 bits are
                               enforced through reserved checking
                            */
    UINT32 MkTmeCryptoAlgs : 16;

                            /* Bits[63:48], Access Type=RW, default=0x00000000*/

                            /*
                               Bitmask for BIOS to set which encryption
                               algorithms are allowed for MK-TME, would be
                               later enforced by the key loading ISA ('1 =
                               allowed). #GP if corresponding algorithm bits
                               are zero in TME Capability MSR</description
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_TME_ACTIVATE_REGISTER;
/**
  User interrupt request register
**/
#define ADL_MSR_IA32_UINT_RR 0x00000985
/**
  This is a read/write MSR that will control the ucode emulation of the PM_TMR.  BIOS will program this register.
**/
#define ADL_MSR_UINT_HANDLER 0x00000986

/**
  This is a read/write MSR that will control the ucode emulation of the PM_TMR.  BIOS will program this register.
**/
#define ADL_MSR_UINT_STACKADJUST 0x00000987

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mode : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* UINT STACK Mode. */
    UINT32 Rsvd1 : 2;

                            /* Bits[2:1], Access Type=RW, default=None*/

                            /* Reserve bits */
    UINT32 Addr0 : 29;

                            /* Bits[31:3], Access Type=RW, default=None*/

                            /* UINT STACK linear address */
    UINT32 Addr1 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /* UINT STACK linear address */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_UINT_STACKADJUST_REGISTER;

/**
  This is a read/write MSR that will control the ucode emulation of the PM_TMR.  BIOS will program this register.
**/
#define ADL_MSR_IA32_CR_UINT_MISC 0x00000988

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Uittsz : 32;

                            /* Bits[31:0], Access Type=RW, default=None*/

                            /*
                               holds the value of the highest index of valid
                               entry in the UITT
                            */
    UINT32 Uinv : 8;

                            /* Bits[39:32], Access Type=RW, default=None*/

                            /* ULI noticiation vector */
    UINT32 Rsvd40 : 24;

                            /* Bits[63:40], Access Type=RW, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_IA32_CR_UINT_MISC_REGISTER;

/**
  This is a read/write MSR that will control the ucode emulation of the PM_TMR.  BIOS will program this register.
**/
#define ADL_MSR_UINT_PD 0x00000989

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 6;

                            /* Bits[5:0], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Addr0 : 26;

                            /* Bits[31:6], Access Type=RW, default=None*/

                            /*
                               user-interrupt notification processing accesses
                               a UPID at the linear address in the IA32_UINT_PD
                               MSR
                            */
    UINT32 Addr1 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /*
                               user-interrupt notification processing accesses
                               a UPID at the linear address in the IA32_UINT_PD
                               MSR
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_UINT_PD_REGISTER;

/**
  This is a read/write MSR that will control the ucode emulation of the PM_TMR.  BIOS will program this register.
**/
#define ADL_MSR_UINT_TT 0x0000098A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Valid : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* UINT_TT is valid */
    UINT32 Rsvd1 : 3;

                            /* Bits[3:1], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Addr0 : 28;

                            /* Bits[31:4], Access Type=RW, default=None*/

                            /* UINT_TT linear address */
    UINT32 Addr1 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /* UINT_TT linear address */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_UINT_TT_REGISTER;

/**
  FSCP To hold keylocker information
**/
#define ADL_MSR_COPY_STATUS 0x00000990

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CopyStatus : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* Bit to hold COPY_STATUS bit for the MSR */
    UINT32 HandlePtr : 1;

                            /* Bits[1:1], Access Type=RW, default=None*/

                            /* Bit to hold Handle lookup */
    UINT32 Rsvd2 : 2;

                            /* Bits[3:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HandleValidMask : 2;

                            /* Bits[5:4], Access Type=RW, default=None*/

                            /*
                               Mask to indicate whether the handles are valid
                               or not. Two bits currently for 2 handles
                            */
    UINT32 Rsvd6 : 26;

                            /* Bits[31:6], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_COPY_STATUS_REGISTER;

/**
  Status of IWKey Backup in PCH
**/
#define ADL_MSR_IWKEYBACKUP_STATUS 0x00000991

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 BackupRestoreValid : 1;

                            /* Bits[0:0], Access Type=RO_V, default=0x00000000*/

                            /*
                               Indication of a successful backup or restore of
                               IWKEY
                            */
    UINT32 BackupKeyCorrupted : 1;

                            /* Bits[1:1], Access Type=RO_V, default=0x00000000*/

                            /*
                               Indicates if ICV/Tag Check passes or fails for
                               IWKey
                            */
    UINT32 BackupKeyStorageRwError : 1;

                            /* Bits[2:2], Access Type=RO_V, default=0x00000000*/

                            /*
                               Indicates if there was a read/write error
                               to/from SPI Flash
                            */
    UINT32 IwkeybackupConsumed : 1;

                            /* Bits[3:3], Access Type=RO_V, default=0x00000000*/

                            /*
                               Indicates if the CSE has consume the IWKeybackup
                               written by Core
                            */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_IWKEYBACKUP_STATUS_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_M2PPMONCNTRCFG_0 0x00000B16

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_M2PPMONCNTRCFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_M2PPMONCNTRCFG_1 0x00000B17

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_M2PPMONCNTRCFG_1_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_0 0x00000B60

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_0 0x00000B61

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_0 0x00000B62

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_0 0x00000B63

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_0 0x00000B64

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_0_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_0 0x00000B65

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_0_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_0 0x00000B67

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_0_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_0 0x00000B68

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_0_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_0 0x00000B69

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_0_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_0 0x00000B6A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_0_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_0 0x00000B6B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_0_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_1 0x00000B6E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_1 0x00000B6F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_1 0x00000B70

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_1 0x00000B71

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_1 0x00000B72

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_1_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_1 0x00000B73

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_1_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_1 0x00000B75

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_1_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_1 0x00000B76

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_1_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_1 0x00000B77

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_1_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_1 0x00000B78

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_1_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_1 0x00000B79

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_1_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_2 0x00000B7C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_2 0x00000B7D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_2 0x00000B7E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_2 0x00000B7F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_2 0x00000B80

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_2_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_2 0x00000B81

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_2_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_2 0x00000B83

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_2_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_2 0x00000B84

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_2_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_2 0x00000B85

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_2_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_2 0x00000B86

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_2_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_2 0x00000B87

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_2_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_3 0x00000B8A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_3_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_3 0x00000B8B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_3_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_3 0x00000B8C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_3_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_3 0x00000B8D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_3_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_3 0x00000B8E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_3_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_3 0x00000B8F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_3_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_3 0x00000B91

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_3_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_3 0x00000B92

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_3_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_3 0x00000B93

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_3_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_3 0x00000B94

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_3_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_3 0x00000B95

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_3_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_4 0x00000B98

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_4_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_4 0x00000B99

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_4_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_4 0x00000B9A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_4_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_4 0x00000B9B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_4_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_4 0x00000B9C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_4_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_4 0x00000B9D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_4_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_4 0x00000B9F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_4_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_4 0x00000BA0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_4_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_4 0x00000BA1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_4_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_4 0x00000BA2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_4_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_4 0x00000BA3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_4_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_5 0x00000BA6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_5_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_5 0x00000BA7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_5_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_5 0x00000BA8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_5_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_5 0x00000BA9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_5_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_5 0x00000BAA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_5_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_5 0x00000BAB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_5_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_5 0x00000BAD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_5_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_5 0x00000BAE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_5_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_5 0x00000BAF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_5_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_5 0x00000BB0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_5_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_5 0x00000BB1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_5_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_6 0x00000BB4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_6_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_6 0x00000BB5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_6_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_6 0x00000BB6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_6_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_6 0x00000BB7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_6_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_6 0x00000BB8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_6_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_6 0x00000BB9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_6_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_6 0x00000BBB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_6_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_6 0x00000BBC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_6_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_6 0x00000BBD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_6_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_6 0x00000BBE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_6_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_6 0x00000BBF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_6_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_7 0x00000BC2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_7_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_7 0x00000BC3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_7_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_7 0x00000BC4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_7_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_7 0x00000BC5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_7_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_7 0x00000BC6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_7_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_7 0x00000BC7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_7_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_7 0x00000BC9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_7_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_7 0x00000BCA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_7_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_7 0x00000BCB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_7_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_7 0x00000BCC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_7_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_7 0x00000BCD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_7_REGISTER;
/**
  Available only in SMM. SMRAM copy of SSP saved by SMI
**/
#define ADL_MSR_SMRAM_SSP 0x00000C26

/**
  MLC Class Of Service Configuration Register
**/
#define ADL_MSR_L2_QOS_CFG 0x00000C82

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CdpEn : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               CDP (code data prioritization) enable control.
                               '0 indicates no CDP, '1 indicates CDP is
                               enabled.
                            */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_L2_QOS_CFG_REGISTER;

/**
  STLB QoS MASK configuration
**/
#define ADL_MSR_SF_QOS_INFO 0x00000C87

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 NumSnoopFilterWays : 6;

                            /* Bits[5:0], Access Type=RO_V, default=None*/

                            /*
                               Indicates the number of STLB_QOS_MASK MSRs
                               available. Required for SW since this is a non-
                               architectural feature
                            */
    UINT32 Rsvd6 : 26;

                            /* Bits[31:6], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_SF_QOS_INFO_REGISTER;

/**
  Way Mask for IIO accesses (SF and LLC)
**/
#define ADL_MSR_IIO_LLC_WAYS 0x00000C8B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Iiocosways : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000C0000*/

                            /*
                               available LLC/SF way vectors for class of
                               service of IIO (default is top 2 ways)
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_IIO_LLC_WAYS_REGISTER;

/**
  Platform QoS Register - Association
**/
#define ADL_MSR_PQR_ASSOC 0x00000C8F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rmid : 10;

                            /* Bits[9:0], Access Type=RW, default=0x00000000*/

                            /* Resource Monitoring ID */
    UINT32 Rsvd10 : 22;

                            /* Bits[31:10], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Clos : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Class of Service selector */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PQR_ASSOC_REGISTER;

/**
  available ways vectors for class of service of IA core
  " seq has 12 instances in addresses range 0x94 to 0x9F"
**/
#define ADL_MSR_LLC_QOS_MASK_15_15 0x00000C9F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LLC_QOS_MASK_15_15_REGISTER;

/**
  Spare for WLC
  Spare for WLC
**/
#define ADL_MSR_L2_QOS_MASK_0_0 0x00000D10

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 WayMask : 16;

                            /* Bits[15:0], Access Type=RW, default=0x0000FFFF*/

                            /*
                               Way Allocation Mask per way in MLC. '1 in bit
                               indicates allocation to the way is allowed. '0
                               indicates allocation to the way is not allowed.
                               restrictions: Only contiguous 1s are allowed.
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RW, default=None*/

                            /* RSVD restrictions: None */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_L2_QOS_MASK_0_0_REGISTER;

/**
  Spare for WLC
  Spare for WLC
**/
#define ADL_MSR_L2_QOS_MASK_1_1 0x00000D11

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 WayMask : 16;

                            /* Bits[15:0], Access Type=RW, default=0x0000FFFF*/

                            /*
                               Way Allocation Mask per way in MLC. '1 in bit
                               indicates allocation to the way is allowed. '0
                               indicates allocation to the way is not allowed.
                               restrictions: Only contiguous 1s are allowed.
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RW, default=None*/

                            /* RSVD restrictions: None */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_L2_QOS_MASK_1_1_REGISTER;

/**
  Spare for WLC
  Spare for WLC
**/
#define ADL_MSR_L2_QOS_MASK_2_2 0x00000D12

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 WayMask : 16;

                            /* Bits[15:0], Access Type=RW, default=0x0000FFFF*/

                            /*
                               Way Allocation Mask per way in MLC. '1 in bit
                               indicates allocation to the way is allowed. '0
                               indicates allocation to the way is not allowed.
                               restrictions: Only contiguous 1s are allowed.
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RW, default=None*/

                            /* RSVD restrictions: None */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_L2_QOS_MASK_2_2_REGISTER;

/**
  Spare for WLC
  Spare for WLC
**/
#define ADL_MSR_L2_QOS_MASK_3_3 0x00000D13

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 WayMask : 16;

                            /* Bits[15:0], Access Type=RW, default=0x0000FFFF*/

                            /*
                               Way Allocation Mask per way in MLC. '1 in bit
                               indicates allocation to the way is allowed. '0
                               indicates allocation to the way is not allowed.
                               restrictions: Only contiguous 1s are allowed.
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RW, default=None*/

                            /* RSVD restrictions: None */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_L2_QOS_MASK_3_3_REGISTER;

/**
  Spare for WLC
  Spare for WLC
**/
#define ADL_MSR_L2_QOS_MASK_4_4 0x00000D14

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 WayMask : 16;

                            /* Bits[15:0], Access Type=RW, default=0x0000FFFF*/

                            /*
                               Way Allocation Mask per way in MLC. '1 in bit
                               indicates allocation to the way is allowed. '0
                               indicates allocation to the way is not allowed.
                               restrictions: Only contiguous 1s are allowed.
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RW, default=None*/

                            /* RSVD restrictions: None */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_L2_QOS_MASK_4_4_REGISTER;

/**
  Spare for WLC
  Spare for WLC
**/
#define ADL_MSR_L2_QOS_MASK_5_5 0x00000D15

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 WayMask : 16;

                            /* Bits[15:0], Access Type=RW, default=0x0000FFFF*/

                            /*
                               Way Allocation Mask per way in MLC. '1 in bit
                               indicates allocation to the way is allowed. '0
                               indicates allocation to the way is not allowed.
                               restrictions: Only contiguous 1s are allowed.
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RW, default=None*/

                            /* RSVD restrictions: None */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_L2_QOS_MASK_5_5_REGISTER;

/**
  Spare for WLC
  Spare for WLC
**/
#define ADL_MSR_L2_QOS_MASK_6_6 0x00000D16

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 WayMask : 16;

                            /* Bits[15:0], Access Type=RW, default=0x0000FFFF*/

                            /*
                               Way Allocation Mask per way in MLC. '1 in bit
                               indicates allocation to the way is allowed. '0
                               indicates allocation to the way is not allowed.
                               restrictions: Only contiguous 1s are allowed.
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RW, default=None*/

                            /* RSVD restrictions: None */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_L2_QOS_MASK_6_6_REGISTER;

/**
  Spare for WLC
  Spare for WLC
**/
#define ADL_MSR_L2_QOS_MASK_7_7 0x00000D17

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 WayMask : 16;

                            /* Bits[15:0], Access Type=RW, default=0x0000FFFF*/

                            /*
                               Way Allocation Mask per way in MLC. '1 in bit
                               indicates allocation to the way is allowed. '0
                               indicates allocation to the way is not allowed.
                               restrictions: Only contiguous 1s are allowed.
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RW, default=None*/

                            /* RSVD restrictions: None */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_L2_QOS_MASK_7_7_REGISTER;

/**
  Initiatate copy of IWKEY from Core to PCH for Keylocker
**/
#define ADL_MSR_COPY_LOCAL_TO_PLATFORM 0x00000D91

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CopyIwkeyToPltfrmPersStorage : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               Command bit to initiate copy IWKEY from Core to
                               PCH
                            */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_COPY_LOCAL_TO_PLATFORM_REGISTER;

/**
  Initiatate copy of IWKEY from PCH to Core for Keylocker
**/
#define ADL_MSR_COPY_PLATFORM_TO_LOCAL 0x00000D92

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CopyIwkeyFromPltfrmPersStorage : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               Command bit to initiate copy IWKEY from PCH to
                               Core
                            */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_COPY_PLATFORM_TO_LOCAL_REGISTER;

/**
  PASID MSR programmed by OS for ENQ* instruction (AiA)
**/
#define ADL_MSR_PASID 0x00000D93

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PasidValue : 20;

                            /* Bits[19:0], Access Type=RW, default=0x00000000*/

                            /*
                               Specifies the Process Address Space Identifier
                               (PASID) value for the currently running thread
                            */
    UINT32 Rsvd20 : 11;

                            /* Bits[30:20], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PasidValid : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /*
                               If set, bits 19:0 of this MSR contains a valid
                               PASID Value
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_PASID_REGISTER;

/**
  Extensible Supervisor State MSR
**/
#define ADL_MSR_IA32_XSS 0x00000DA0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mbz : 8;

                            /* Bits[7:0], Access Type=RW, default=None*/

                            /* Must be zero */
    UINT32 RtitSupport : 1;

                            /* Bits[8:8], Access Type=RW, default=None*/

                            /* RTIT X* support */
    UINT32 Mbz2 : 1;

                            /* Bits[9:9], Access Type=RW, default=None*/

                            /* Must-Be-Zero */
    UINT32 AiaWsniSupport : 1;

                            /* Bits[10:10], Access Type=RW, default=None*/

                            /* AiA/WSNI support */
    UINT32 UCetSupport : 1;

                            /* Bits[11:11], Access Type=RW, default=None*/

                            /* U_CET support */
    UINT32 SCetSupport : 1;

                            /* Bits[12:12], Access Type=RW, default=None*/

                            /* S_CET support */
    UINT32 HdcSupport : 1;

                            /* Bits[13:13], Access Type=RW, default=None*/

                            /* HDC support */
    UINT32 Uint : 1;

                            /* Bits[14:14], Access Type=RW, default=None*/

                            /* HDC support */
    UINT32 ArchLbrsSupport : 1;

                            /* Bits[15:15], Access Type=RW, default=None*/

                            /* Support X* for ARCH LBRS */
    UINT32 HwpSupport : 1;

                            /* Bits[16:16], Access Type=RW, default=None*/

                            /* HWP_SUPPORT */
    UINT32 Rsvd17 : 15;

                            /* Bits[31:17], Access Type=RW, default=None*/

                            /* Reserved for future growth */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_IA32_XSS_REGISTER;

/**
  Uncore PMU global control
**/
#define ADL_MSR_NCUPMONGLCTRL 0x00000E01

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmiselc0 : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc1 : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc2 : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc3 : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc4 : 1;

                            /* Bits[4:4], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc5 : 1;

                            /* Bits[5:5], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc6 : 1;

                            /* Bits[6:6], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc7 : 1;

                            /* Bits[7:7], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc8 : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 PmiselRsrv : 7;

                            /* Bits[15:9], Access Type=RO, default=0x00000000*/

                            /*  */
    UINT32 Rsvd16 : 12;

                            /* Bits[27:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pmiovfenubp : 1;

                            /* Bits[28:28], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enable the generation of uBP event when set. 0 -
                               Does not assert uBP event with the PMI Overflow.
                               1 - Assert uBP event with the PMI Overflow is
                               set.
                            */
    UINT32 Pmongen : 1;

                            /* Bits[29:29], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enable all PMON Counter. This is sent as to all
                               unCore units using the global enable line. 0 -
                               All PrefMon are disabled (default) 1 - Enable
                               all PrefMon that their local enable bit is set.
                               This field is reset if Bit 31 in this register
                               (FrzCountr) is set and any one of the bits in
                               UNCORE_PERF_GLOBAL_STATUS_MSR is set.
                            */
    UINT32 Wkonpmi : 1;

                            /* Bits[30:30], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit determines whether PMI event is sent to
                               waken cores only or is broadcast to all cores
                               after waking up any sleeping core. 0 : Avoid
                               waking a core for PMI event - send event to
                               waken cores only. 1 : Wake any sleeping core and
                               send PMI event to all cores
                            */
    UINT32 Frzcountr : 1;

                            /* Bits[31:31], Access Type=RW_V, default=0x00000000*/

                            /*
                               FreezCounter : This bit, when asserted, cause
                               all of the global enables for the UnCore PerfMon
                               Counters and fixed counters to get freeze on any
                               PMI caused by UnCore PerfMon events.
                               Effectively, this causes all of the UnCore
                               counters to freeze simultaneously. 0 : Do not
                               assert Freeze on PMON event 1 : Assert Freeze on
                               PMON event
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_NCUPMONGLCTRL_REGISTER;

/**
  Uncore PMU main status
**/
#define ADL_MSR_NCUPMONGLSTS 0x00000E02

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Fixctrovf : 1;

                            /* Bits[0:0], Access Type=RW1C_FW, default=0x00000000*/

                            /*
                               Indicates that an overflow event occured on the
                               Fix Event. read 0 - No overflow detected 1 -
                               Event overflow event was detected (sticky) Write
                               0 - Ignore 1 - Clear this bit
                            */
    UINT32 Ncuctrovf : 1;

                            /* Bits[1:1], Access Type=RW1C_FW, default=0x00000000*/

                            /*
                               Indicates that an overflow event occured on the
                               NCU and IMPH Event. read 0 - No overflow
                               detected 1 - Event overflow event was detected
                               (sticky) Write 0 - Ignore 1 - Clear this bit
                            */
    UINT32 Chapovf : 1;

                            /* Bits[2:2], Access Type=RW1C_FW, default=0x00000000*/

                            /*
                               Indicates that an overflow event occured on the
                               Chap. read 0 - No overflow detected 1 - Event
                               overflow event was detected (sticky) Write 0 -
                               Ignore 1 - Clear this bit
                            */
    UINT32 Ringovf : 1;

                            /* Bits[3:3], Access Type=RW1C_FW, default=0x00000000*/

                            /*
                               Indicates that an overflow event occured on the
                               Ring Event signal. read 0 - No overflow detected
                               1 - Event overflow event was detected (sticky)
                               Write 0 - Ignore 1 - Clear this bit
                            */
    UINT32 Ncuctrovf1 : 1;

                            /* Bits[4:4], Access Type=RW1C_FW, default=0x00000000*/

                            /*
                               Indicates that an overflow event occured on the
                               Ring Event signal. Indicates that an overflow
                               event occured on the NCU and IDP1 Event. read 0
                               - No overflow detected 1 - Event overflow event
                               was detected (sticky) Write 0 - Ignore 1 - Clear
                               this bit
                            */
    UINT32 Rsvd5 : 27;

                            /* Bits[31:5], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_NCUPMONGLSTS_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_16 0x00000EE0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_16_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_16 0x00000EE1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_16_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_16 0x00000EE2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_16_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_16 0x00000EE3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_16_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_16 0x00000EE4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_16_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_16 0x00000EE5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_16_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_16 0x00000EE7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_16_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_16 0x00000EE8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_16_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_16 0x00000EE9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_16_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_16 0x00000EEA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_16_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_16 0x00000EEB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_16_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_17 0x00000EEE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_17_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_17 0x00000EEF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_17_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_17 0x00000EF0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_17_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_17 0x00000EF1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_17_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_17 0x00000EF2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_17_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_17 0x00000EF3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_17_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_17 0x00000EF5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_17_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_17 0x00000EF6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_17_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_17 0x00000EF7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_17_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_17 0x00000EF8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_17_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_17 0x00000EF9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_17_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_8 0x00000F7A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_8_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_8 0x00000F7B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_8_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_8 0x00000F7C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_8_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_8 0x00000F7D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_8_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_8 0x00000F7E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_8_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_8 0x00000F7F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_8_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_8 0x00000F81

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_8_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_8 0x00000F82

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_8_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_8 0x00000F83

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_8_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_8 0x00000F84

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_8_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_8 0x00000F85

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_8_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_9 0x00000F88

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_9_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_9 0x00000F89

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_9_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_9 0x00000F8A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_9_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_9 0x00000F8B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_9_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_9 0x00000F8C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_9_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_9 0x00000F8D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_9_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_9 0x00000F8F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_9_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_9 0x00000F90

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_9_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_9 0x00000F91

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_9_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_9 0x00000F92

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_9_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_9 0x00000F93

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_9_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_10 0x00000F96

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_10_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_10 0x00000F97

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_10_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_10 0x00000F98

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_10_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_10 0x00000F99

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_10_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_10 0x00000F9A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_10_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_10 0x00000F9B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_10_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_10 0x00000F9D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_10_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_10 0x00000F9E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_10_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_10 0x00000F9F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_10_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_10 0x00000FA0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_10_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_10 0x00000FA1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_10_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_11 0x00000FA4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_11_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_11 0x00000FA5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_11_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_11 0x00000FA6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_11_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_11 0x00000FA7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_11_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_11 0x00000FA8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_11_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_11 0x00000FA9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_11_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_11 0x00000FAB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_11_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_11 0x00000FAC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_11_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_11 0x00000FAD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_11_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_11 0x00000FAE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_11_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_11 0x00000FAF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_11_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_12 0x00000FB2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_12_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_12 0x00000FB3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_12_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_12 0x00000FB4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_12_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_12 0x00000FB5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_12_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_12 0x00000FB6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_12_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_12 0x00000FB7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_12_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_12 0x00000FB9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_12_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_12 0x00000FBA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_12_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_12 0x00000FBB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_12_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_12 0x00000FBC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_12_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_12 0x00000FBD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_12_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_13 0x00000FC0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_13_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_13 0x00000FC1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_13_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_13 0x00000FC2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_13_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_13 0x00000FC3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_13_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_13 0x00000FC4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_13_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_13 0x00000FC5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_13_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_13 0x00000FC7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_13_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_13 0x00000FC8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_13_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_13 0x00000FC9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_13_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_13 0x00000FCA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_13_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_13 0x00000FCB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_13_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_14 0x00000FCE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_14_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_14 0x00000FCF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_14_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_14 0x00000FD0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_14_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_14 0x00000FD1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_14_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_14 0x00000FD2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_14_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_14 0x00000FD3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_14_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_14 0x00000FD5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_14_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_14 0x00000FD6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_14_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_14 0x00000FD7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_14_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_14 0x00000FD8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_14_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_14 0x00000FD9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_14_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONUNITCTRL_15 0x00000FDC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONUNITCTRL_15_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_0_15 0x00000FDD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_0_15_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_1_15 0x00000FDE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_1_15_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_2_15 0x00000FDF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_2_15_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define ADL_MSR_CBOPMONCTRCTRL_3_15 0x00000FE0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRCTRL_3_15_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRLGLCTR_15 0x00000FE1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRLGLCTR_15_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define ADL_MSR_CBOPMONCTRSTATUS_15 0x00000FE3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCTRSTATUS_15_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_0_15 0x00000FE4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_0_15_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_1_15 0x00000FE5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_1_15_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_2_15 0x00000FE6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_2_15_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define ADL_MSR_CBOPMONCT_3_15 0x00000FE7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_CBOPMONCT_3_15_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_0_INFO_0 0x00001200

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_0_INFO_0_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_1_INFO_1 0x00001201

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_1_INFO_1_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_2_INFO_2 0x00001202

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_2_INFO_2_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_3_INFO_3 0x00001203

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_3_INFO_3_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_4_INFO_4 0x00001204

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_4_INFO_4_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_5_INFO_5 0x00001205

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_5_INFO_5_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_6_INFO_6 0x00001206

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_6_INFO_6_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_7_INFO_7 0x00001207

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_7_INFO_7_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_8_INFO_8 0x00001208

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_8_INFO_8_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_9_INFO_9 0x00001209

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_9_INFO_9_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_10_INFO_10 0x0000120A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_10_INFO_10_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_11_INFO_11 0x0000120B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_11_INFO_11_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_12_INFO_12 0x0000120C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_12_INFO_12_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_13_INFO_13 0x0000120D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_13_INFO_13_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_14_INFO_14 0x0000120E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_14_INFO_14_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_15_INFO_15 0x0000120F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_15_INFO_15_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_16_INFO_16 0x00001210

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_16_INFO_16_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_17_INFO_17 0x00001211

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_17_INFO_17_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_18_INFO_18 0x00001212

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_18_INFO_18_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_19_INFO_19 0x00001213

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_19_INFO_19_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_20_INFO_20 0x00001214

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_20_INFO_20_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_21_INFO_21 0x00001215

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_21_INFO_21_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_22_INFO_22 0x00001216

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_22_INFO_22_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_23_INFO_23 0x00001217

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_23_INFO_23_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_24_INFO_24 0x00001218

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_24_INFO_24_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_25_INFO_25 0x00001219

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_25_INFO_25_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_26_INFO_26 0x0000121A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_26_INFO_26_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_27_INFO_27 0x0000121B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_27_INFO_27_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_28_INFO_28 0x0000121C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_28_INFO_28_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_29_INFO_29 0x0000121D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_29_INFO_29_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_30_INFO_30 0x0000121E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_30_INFO_30_REGISTER;

/**
  Last Branch Record entry X info register (R/W).  An attempt to read or write IA32_LBR_x_INFO such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_31_INFO_31 0x0000121F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /*
                               The elapsed CPU cycles (saturating) since the
                               last LBR was recorded
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 24;

                            /* Bits[55:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BrType : 4;

                            /* Bits[59:56], Access Type=RW_V, default=None*/

                            /*
                               The branch type recorded by this LBR. Encodings:
                               0000B: JCC 0001B: JMP Indirect 0010B: JMP Direct
                               0011B: CALL Indirect 0100B: CALL Direct 0101B:
                               RET 011xB: Reserved 1xxxB: Far Branch
                            */
    UINT32 CycleCntValid : 1;

                            /* Bits[60:60], Access Type=RW_V, default=None*/

                            /* indicate if CYC_COUNT field has a valid value */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /*
                               This LBR record is a TSX abort. On processors
                               that do not support Intel TSX
                               (CPUID.07H.EBX.HLE[bit 4]=0 and
                               CPUID.07H.EBX.RTM[bit 11]=0), this bit is
                               undefined.
                            */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /*
                               This LBR record records a branch that retired
                               during a TSX transaction. On processors that do
                               not support Intel TSX (CPUID.07H.EBX.HLE[bit
                               4]=0 and CPUID.07H.EBX.RTM[bit 11]=0), this bit
                               is undefined
                            */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /*
                               The recorded branch direction (Jcc) or target
                               (indirect branch) was mispredicted.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_31_INFO_31_REGISTER;

/**
  SEAM memory range register for TDx - Base address
**/
#define ADL_MSR_SEAMRR_BASE 0x00001400

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 3;

                            /* Bits[2:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* SEAMRR BASE Configured */
    UINT32 Rsvd4 : 21;

                            /* Bits[24:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 7;

                            /* Bits[31:25], Access Type=RW, default=0x00000000*/

                            /* Base Address */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_SEAMRR_BASE_REGISTER;

/**
  SEAM memory range register for TDx - mask address
**/
#define ADL_MSR_SEAMRR_MASK 0x00001401

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 9;

                            /* Bits[8:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Assist : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               If set, SEAMRR matches to the programmed address
                               will invoke ucode's address match handler. If
                               clear, SEAMRR matches will "abort" and redirect
                               the access to the abort page and a UC memory
                               type. restrictions : Set corresponding
                               SEAMRR_BASE appropriately for the address. Set
                               VLD, ASSIST, and MASK.
                            */
    UINT32 L : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /* Lock bit for SEAMRR */
    UINT32 Vld : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* Enables the SEAMRR for matching. */
    UINT32 Rsvd12 : 13;

                            /* Bits[24:12], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Mask0 : 7;

                            /* Bits[31:25], Access Type=RW, default=0x00000000*/

                            /*
                               Mask value for SEAMRR matching. Lowest
                               granulatiry is 32M
                            */
    UINT32 Mask1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               Mask value for SEAMRR matching. Lowest
                               granulatiry is 32M
                            */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_SEAMRR_MASK_REGISTER;
/**

**/
#define ADL_MSR_SEAM_EXTEND 0x00001402

/**
  Last Branch Record enabling and configuration register (R/W)
**/
#define ADL_MSR_LBR_CTL 0x000014CE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lbren : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* When set, enables LBR recording */
    UINT32 Os : 1;

                            /* Bits[1:1], Access Type=RW, default=None*/

                            /* When set, allows LBR recording when CPL == 0 */
    UINT32 Usr : 1;

                            /* Bits[2:2], Access Type=RW, default=None*/

                            /* When set, allows LBR recording when CPL != 0 */
    UINT32 CallStack : 1;

                            /* Bits[3:3], Access Type=RW, default=None*/

                            /* When set, records branches in call-stack mode */
    UINT32 Rsvd4 : 12;

                            /* Bits[15:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Jcc : 1;

                            /* Bits[16:16], Access Type=RW, default=None*/

                            /* When set, records taken conditional branches */
    UINT32 NearRelJmp : 1;

                            /* Bits[17:17], Access Type=RW, default=None*/

                            /* When set, records near relative JMPs. */
    UINT32 NearIndirectJmp : 1;

                            /* Bits[18:18], Access Type=RW, default=None*/

                            /* When set, records near indirect JMPs. */
    UINT32 NearRelCall : 1;

                            /* Bits[19:19], Access Type=RW, default=None*/

                            /* When set, records near relative CALLs. */
    UINT32 NearIndirectCall : 1;

                            /* Bits[20:20], Access Type=RW, default=None*/

                            /* When set, records near indirect CALLs. */
    UINT32 NearRet : 1;

                            /* Bits[21:21], Access Type=RW, default=None*/

                            /* When set, records near RETs. */
    UINT32 FarBranch : 1;

                            /* Bits[22:22], Access Type=RW, default=None*/

                            /* When set, records far branches. */
    UINT32 Rsvd23 : 9;

                            /* Bits[31:23], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_CTL_REGISTER;

/**
  Last Branch Record maximum stack depth register (R/W)
**/
#define ADL_MSR_LBR_DEPTH 0x000014CF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Depth : 6;

                            /* Bits[5:0], Access Type=RW, default=0x00000020*/

                            /*
                               The number of LBRs to be used for recording.
                               Supported values are indicated by the bitmap in
                               CPUID.(EAX=01CH,ECX=0):EAX[7:0]. The reset value
                               will match the maximum supported by the CPU.
                               Writes of unsupported values will #GP fault.
                            */
    UINT32 Rsvd6 : 26;

                            /* Bits[31:6], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_DEPTH_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_0_FROM_IP_0 0x00001500

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_0_FROM_IP_0_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_1_FROM_IP_1 0x00001501

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_1_FROM_IP_1_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_2_FROM_IP_2 0x00001502

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_2_FROM_IP_2_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_3_FROM_IP_3 0x00001503

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_3_FROM_IP_3_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_4_FROM_IP_4 0x00001504

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_4_FROM_IP_4_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_5_FROM_IP_5 0x00001505

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_5_FROM_IP_5_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_6_FROM_IP_6 0x00001506

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_6_FROM_IP_6_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_7_FROM_IP_7 0x00001507

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_7_FROM_IP_7_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_8_FROM_IP_8 0x00001508

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_8_FROM_IP_8_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_9_FROM_IP_9 0x00001509

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_9_FROM_IP_9_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_10_FROM_IP_10 0x0000150A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_10_FROM_IP_10_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_11_FROM_IP_11 0x0000150B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_11_FROM_IP_11_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_12_FROM_IP_12 0x0000150C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_12_FROM_IP_12_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_13_FROM_IP_13 0x0000150D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_13_FROM_IP_13_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_14_FROM_IP_14 0x0000150E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_14_FROM_IP_14_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_15_FROM_IP_15 0x0000150F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_15_FROM_IP_15_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_16_FROM_IP_16 0x00001510

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_16_FROM_IP_16_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_17_FROM_IP_17 0x00001511

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_17_FROM_IP_17_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_18_FROM_IP_18 0x00001512

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_18_FROM_IP_18_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_19_FROM_IP_19 0x00001513

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign-extension based on the maximum linear
                               address width supported by the processor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} ADL_MSR_LBR_19_FROM_IP_19_REGISTER;

/**
  Last Branch Record entry X source IP register (R/W).  An attempt to read or write IA32_LBR_x_FROM_IP such that x >= IA32_LBR_DEPTH.DEPTH will #GP.
**/
#define ADL_MSR_LBR_20_FROM_IP_20 0x00001514

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /*
                               The source IP of the recorded branch or event,
                               in canonical form (lower bits 56:0)
                            */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /*
         