/** @file
  Header file for 2LM initialization library.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef TWOLM_INIT_FRU_LIB_H_
#define TWOLM_INIT_FRU_LIB_H_

#include <Library/PeiDxeSmmTwoLmLib.h>
#include <Ppi/SiPolicy.h>


#define MEM_EQU_1GB        0x40000000ULL

/**
  This function initializes Astro Near Memory Controller.

  @param[in]    TwoLmInfo    2LM HOB which will have necessary values to initialize Astro.

  @retval       EFI_SUCCESS      Successfully initialized Astro Near Memory Controller.
**/
EFI_STATUS
EFIAPI
AstroInit (
  IN TWOLM_INFO    *TwoLmInfo
  );

/**
  This function is to return Astro DDR_config reg field value based on Memory Size in GB.

  @param[in]  MemorySize  Memory Size in GB from MC0 or MC1.

  @retval     UINT8       Retruns DDR_Config field values.
**/
UINT8
GetDdrCondigValue (
  IN UINT8     MemorySize
  );

/**
  This function is to return Astro mc-org value for MC_Select_Config register based on MC0/MC1 sizes.

  @param[in]  Mc0Size  Total Size on Memory Controller 0.
  @param[in]  Mc1Size  Total Size on Memory Controller 1.

  @retval     UINT8       Retruns DDR_Config field values.
**/
UINT8
GetMcOrgValue (
  IN UINT32     Mc0Size,
  IN UINT32     Mc1Size
  );

#endif /* TWOLM_INIT_FRU_LIB_H_ */
