/** @file
  CPU DMI Information library

  All function in this library is available for PEI, DXE, and SMM,
  But do not support UEFI RUNTIME environment call.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#include <Uefi.h>
#include <Library/BaseLib.h>
#include <Library/DebugLib.h>
#include <Library/IoLib.h>
#include <Library/BaseMemoryLib.h>
#include <Library/SaPlatformLib.h>
#include <Register/SaRegsHostBridge.h>
#include <Library/CpuDmiInfoLib.h>
#include <Library/CpuPlatformLib.h>



/**
  Determine if PCH Link is DMI/OPI

  @retval TRUE                    DMI
  @retval FALSE                   OPI
**/
BOOLEAN
IsPchLinkDmi (
  VOID
  )
{
  if (!IsMobileSku ()) {
    return TRUE; // DMI
  }
  return FALSE;  // OPI
}

/**
  Returns the number of DMI lanes for current CPU

  @retval UINT8       Number of DMI lanes
**/
UINT8
GetMaxDmiLanes (
  )
{
  CPU_GENERATION  CpuGeneration;

  CpuGeneration = GetCpuGeneration();

  if (CpuGeneration == EnumCmlCpu) {
    return SA_DMI_MAX_LANE_VER1;
  } else {
    return SA_DMI_MAX_LANE;
  }
}

/**
  Returns the number of DMI bundles for current CPU

  @retval UINT8       Number of DMI bundles
**/
UINT8
GetMaxDmiBundles (
  )
{
  CPU_GENERATION  CpuGeneration;

  CpuGeneration = GetCpuGeneration();

  if (CpuGeneration == EnumCmlCpu) {
    return SA_DMI_MAX_BUNDLE_VER1;
  } else {
    return SA_DMI_MAX_BUNDLE;
  }
}
