/** @file
  This file provides services for CpuDmi PreMem Policy function

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#include <Library/DebugLib.h>
#include <Library/SiConfigBlockLib.h>
#include <Library/ConfigBlockLib.h>
#include <Ppi/SiPolicy.h>
#include <CpuDmiPreMemConfig.h>
#include <Library/CpuPlatformLib.h>
#include <Library/CpuDmiInfoLib.h>

/**
  Print CPU_DMI_PREMEM_CONFIG and serial out.

  @param[in] SiPreMemPolicyPpi            Pointer to a SI_PREMEM_POLICY_PPI
**/
VOID
CpuDmiPreMemPrintConfig (
  IN SI_PREMEM_POLICY_PPI     *SiPreMemPolicyPpi
  )
{
  EFI_STATUS            Status;
  CPU_DMI_PREMEM_CONFIG *CpuDmiPreMemConfig;
  UINT32                Index;

  Status = GetConfigBlock ((VOID *) SiPreMemPolicyPpi, &gCpuDmiPreMemConfigGuid, (VOID *) &CpuDmiPreMemConfig);
  ASSERT_EFI_ERROR (Status);

  DEBUG ((DEBUG_INFO, "------------------ DMI PreMem Config ------------------\n"));
  ASSERT (CpuDmiPreMemConfig->Header.Revision == DMI_CONFIG_REVISION);
  DEBUG ((DEBUG_INFO, " DmiMaxLinkSpeed : 0x%x\n", CpuDmiPreMemConfig->DmiMaxLinkSpeed));
  DEBUG ((DEBUG_INFO, " DmiAspm : 0x%x\n", CpuDmiPreMemConfig->DmiAspm));
  DEBUG ((DEBUG_INFO, " DmiGen3EqPh2Enable : 0x%x\n", CpuDmiPreMemConfig->DmiGen3EqPh2Enable));
  DEBUG ((DEBUG_INFO, " DmiGen3EqPh3Method : 0x%x\n", CpuDmiPreMemConfig->DmiGen3EqPh3Method));
  DEBUG ((DEBUG_INFO, " DmiGen3ProgramStaticEq : 0x%x\n", CpuDmiPreMemConfig->DmiGen3ProgramStaticEq));
  DEBUG ((DEBUG_INFO, " DmiGen3RootPortPreset[%d] :", GetMaxDmiLanes()));
  for (Index = 0; Index < GetMaxDmiLanes(); Index++) {
    DEBUG ((DEBUG_INFO, " 0x%x", CpuDmiPreMemConfig->DmiGen3RootPortPreset[Index]));
  }
  DEBUG ((DEBUG_INFO, "\n DmiGen3EndPointPreset[%d] :", GetMaxDmiLanes()));
  for (Index = 0; Index < GetMaxDmiLanes(); Index++) {
    DEBUG ((DEBUG_INFO, " 0x%x", CpuDmiPreMemConfig->DmiGen3EndPointPreset[Index]));
  }
  DEBUG ((DEBUG_INFO, "\n DmiGen3EndPointHint[%d] :", GetMaxDmiLanes()));
  for (Index = 0; Index < GetMaxDmiLanes(); Index++) {
    DEBUG ((DEBUG_INFO, " 0x%x", CpuDmiPreMemConfig->DmiGen3EndPointHint[Index]));
  }
  DEBUG ((DEBUG_INFO, "\n DmiGen3RxCtlePeaking[%d] :", GetMaxDmiBundles()));
  for (Index = 0; Index < GetMaxDmiBundles(); Index++) {
    DEBUG ((DEBUG_INFO, " 0x%x", CpuDmiPreMemConfig->DmiGen3RxCtlePeaking[Index]));
  }

  DEBUG ((DEBUG_INFO, " DmiDeEmphasis : 0x%x\n", CpuDmiPreMemConfig->DmiDeEmphasis));
}

/**
  Load Config block default

  @param[in] ConfigBlockPointer         Pointer to config block
**/
VOID
CpuDmiPreMemLoadConfigDefault (
  IN VOID          *ConfigBlockPointer
  )
{
  UINTN                  Index;
  CPU_DMI_PREMEM_CONFIG  *CpuDmiPreMemConfig;

  CpuDmiPreMemConfig = ConfigBlockPointer;

  DEBUG ((DEBUG_INFO, "CpuDmiPreMemConfig->Header.GuidHob.Name = %g\n", &CpuDmiPreMemConfig->Header.GuidHob.Name));
  DEBUG ((DEBUG_INFO, "CpuDmiPreMemConfig->Header.GuidHob.Header.HobLength = 0x%x\n", CpuDmiPreMemConfig->Header.GuidHob.Header.HobLength));

  //
  // Initialize the DMI Configuration
  //
  CpuDmiPreMemConfig->DmiAspmCtrl                    = DmiAspmAutoConfig;
  CpuDmiPreMemConfig->DmiGen3EqPh2Enable             = 2;
  CpuDmiPreMemConfig->DmiGen3ProgramStaticEq         = 1;
  CpuDmiPreMemConfig->DmiMaxLinkSpeed = 3;


  for (Index = 0; Index < GetMaxDmiLanes(); Index++) {
    CpuDmiPreMemConfig->DmiGen3RootPortPreset[Index] = 4;
    CpuDmiPreMemConfig->DmiGen3EndPointPreset[Index] = 7;
    CpuDmiPreMemConfig->DmiGen3EndPointHint[Index]   = 2;
  }
  for (Index = 0; Index < GetMaxDmiBundles(); Index++) {
    ///
    /// Gen3 RxCTLE peaking default is 0 for DMI
    ///
    CpuDmiPreMemConfig->DmiGen3RxCtlePeaking[Index]  = 0;
  }
}

STATIC COMPONENT_BLOCK_ENTRY  mCpuDmiPreMemBlocks = {
  &gCpuDmiPreMemConfigGuid,
  sizeof (CPU_DMI_PREMEM_CONFIG),
  DMI_CONFIG_REVISION,
  CpuDmiPreMemLoadConfigDefault
};

/**
  Get CpuDmi config block table size.

  @retval      Size of config block
**/
UINT16
CpuDmiPreMemGetConfigBlockTotalSize (
  VOID
  )
{
  return mCpuDmiPreMemBlocks.Size;
}

/**
  Add CpuDmi ConfigBlock.

  @param[in] ConfigBlockTableAddress    The pointer to config block table

  @retval EFI_SUCCESS                   The policy default is initialized.
  @retval EFI_OUT_OF_RESOURCES          Insufficient resources to create buffer
**/
EFI_STATUS
CpuDmiPreMemAddConfigBlock (
  IN VOID           *ConfigBlockTableAddress
  )
{
  return AddComponentConfigBlocks (ConfigBlockTableAddress, &mCpuDmiPreMemBlocks, 1);
}
