/** @file
  Register names for PCH DCI device

  Conventions:

  - Register definition format:
    Prefix_[GenerationName]_[ComponentName]_SubsystemName_RegisterSpace_RegisterName
  - Prefix:
    Definitions beginning with "R_" are registers
    Definitions beginning with "B_" are bits within registers
    Definitions beginning with "V_" are meaningful values within the bits
    Definitions beginning with "S_" are register size
    Definitions beginning with "N_" are the bit position
  - [GenerationName]:
    Three letter acronym of the generation is used (e.g. SKL,KBL,CNL etc.).
    Register name without GenerationName applies to all generations.
  - [ComponentName]:
    This field indicates the component name that the register belongs to (e.g. PCH, SA etc.)
    Register name without ComponentName applies to all components.
    Register that is specific to -H denoted by "_PCH_H_" in component name.
    Register that is specific to -LP denoted by "_PCH_LP_" in component name.
  - SubsystemName:
    This field indicates the subsystem name of the component that the register belongs to
    (e.g. PCIE, USB, SATA, GPIO, PMC etc.).
  - RegisterSpace:
    MEM - MMIO space register of subsystem.
    IO  - IO space register of subsystem.
    PCR - Private configuration register of subsystem.
    CFG - PCI configuration space register of subsystem.
  - RegisterName:
    Full register name.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2014 - 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _DCI_REGS_H_
#define _DCI_REGS_H_

//
// DCI PCR Registers
//

#define R_DCI_PCR_ECTRL                                   0x04            ///< DCI Control Register

#define B_DCI_PCR_ECTRL_HDCIEN_LOCK                       BIT0            ///< Host DCI Enable Lock
#define B_DCI_PCR_ECTRL_HDCIEN                            BIT4            ///< Host DCI Enable
#define B_DCI_PCR_ECTRL_USB2DBCEN                         BIT5            ///< Enable USB2 DbC
#define B_DCI_PCR_ECTRL_USB3DBCEN                         BIT6            ///< Enable USB3 DbC
#define B_DCI_PCR_ECTRL_DBG_EN                            BIT8            ///< Debug Enable
#define B_DCI_PCR_ECTRL_EGRANT                            BIT9            ///< DCI connection is granted
#define B_DCI_PCR_ECTRL_UFP2DFP                           BIT14           ///< Enable UFP2DFP for connection

#define R_DCI_PCR_ECKPWRCTL                               0x08            ///< DCI Power Control
#define B_DCI_PCR_ECKPWRCTL_ROSC_SLOW_CLK_GATE_DISABLE    BIT19           ///< ROSC slow clock gate disable
#define B_DCI_PCR_ECKPWRCTL_ROSC_FAST_CLK_GATE_DISABLE    BIT18           ///< ROSC fast clock gate disable

#define R_DCI_PCR_EARBCTRL                                0x0C            ///< DCI Arbitration Control
#define B_DCI_PCR_EARBCTRL_ARB_GNT_S_DBC                  BIT17           ///< Arbitration grant status for PCH DbC
#define B_DCI_PCR_EARBCTRL_ARB_GNT_DCI_OOB                BIT16           ///< Arbitration grant status for DCI OOB

#define R_DCI_PCR_PORT_ID                                 0x300C          ///< DCI Port ID Register
#define B_DCI_PCR_PORT_ID_MASK                            0x001F          ///< DCI Port ID Mask
#define V_DCI_PCR_PORT_ID_MISC                            15              ///< DCI Port ID number 0~15 could be 4-wire DCI OOB, USB3, USB2
#define V_DCI_PCR_PORT_ID_DCI_OOB_2_WIRE                  23              ///< DCI Port ID number 16~23 is 2-wire DCI OOB

#define R_DCI_PCR_ESRCCLK                                 0x30C8          ///< DCI Clock Override
#define B_DCI_PCR_ESRCCLK_S0I3P4_OVR                      BIT0            ///< DCI Clock Request Override for S0i3.4. 1:Disabled; 0:Enabled(HW default)
#define B_DCI_PCR_ESRCCLK_SRCCLK_RO_FAST_CLK_OVR          BIT1            ///< DCI Clock Request Override             1:Disabled; 0:Enabled(HW default)


#define R_DCI_PCR_EMODPHY_LANE                            0x30D0          ///< DCI ModPhy Override Per Lane
#define V_DCI_PCR_EMODPHY_LANE_PG_OVR_DIS                 0xFFFF          ///< DCI ModPhy Override Per Lane Disabled
#define R_DCI_PCR_EMODPHY_CMNLANE                         0x30D4          ///< DCI Modphy Override Per Common Lane
#define V_DCI_PCR_EMODPHY_CMNLANE_PG_OVR_DIS              0xFFFF          ///< DCI Modphy Override Per Common Lane Disabled

#endif
