/** @file
  Contains functions that are used outside of the DdrIo Library.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2018 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _MrcDdrIoApi_h_
#define _MrcDdrIoApi_h_

/// Defines
#define MRC_DDRIO_RX_TO_FIFO_GB_PS  (500)

/// Functions
/**
  This function runs Comp Calibration.

  @param[in, out] MrcData - Include all MRC global data.

  @retval MrcStatus - mrcSuccess if successful or an error status
**/
MrcStatus
MrcDdrCompCalPre (
  IN OUT MrcParameters *const MrcData
  );

/**
  This function train the current supply for the DCO such that the FLL is able to hit 4 GHz.

  @param[in]  MrcData - Pointer to global data.

  @retval MrcStatus - mrcFail if Inputs->ExitOnFailure is set and we cannot reach 4 GHz; otherwise mrcSuccess.
**/
MrcStatus
MrcFllInit (
  IN  MrcParameters *const  MrcData
  );

/**
  This function runs DDRIO Offset Correction - PreTraining
  (VsxHi FB/FF Offset Correction & VccDLL Per Partition Nbias Vref Offset Correction)

  @param[in, out] MrcData - Include all MRC global data.

  @retval mrcSuccess
**/
MrcStatus
MrcOffsetCorrectionPre (
  IN OUT MrcParameters *const MrcData
  );

/**
  This function trains VccDll for Write, Read and Idle FeedForward timing.
  Idle isnt coded for A0

  @param[in]  MrcData - Pointer to global MRC data.

  @retval MrcStatus - mrcSuccess
**/
MrcStatus
MrcVccDllFFTiming (
  IN  MrcParameters *const  MrcData
  );

/**
  This function trains VccDll Per Module FF Offset Correction

  @param[in]  MrcData - Pointer to global MRC data.

  @retval MrcStatus - mrcSuccess
**/
MrcStatus
MrcVccDllFFOffsetCorrection (
  IN MrcParameters    *const MrcData
  );

/**
  This function sets up DCC steps prior to JEDEC init
  MRC:RestrictedContent - Step 1 of Section 3.1.6.1.2 of TGL DDR MAS 1.15 (except for 1a which is done as part of PBD in MrcDdrCompCalPre function)

  @param[in, out] MrcData - Include all MRC global data.

  @retval mrcSuccess
**/
MrcStatus
MrcDccInitPreJedec (
  IN OUT MrcParameters *const MrcData
  );

/**
  This function runs DCC steps prior to Early Command Training
  MRC:RestrictedContent - Step 2 of Section 3.1.6.1.2 of TGL DDR MAS 1.15

  @param[in, out] MrcData - Include all MRC global data.

  @retval mrcSuccess
**/
MrcStatus
MrcDccPreEct (
  IN OUT MrcParameters *const MrcData
  );

/**
  This routine returns the TX FIFO separation based on technology

  @param[in]  MrcData           - Pointer to MRC global data.

  @retval TxFifoSeparation.
**/

INT32
MrcGetTxFifoSeparation (
  IN OUT MrcParameters *const MrcData
  );

/**
  This routine computes the read and write fifo pointer delays

  @param[in]  MrcData           - Pointer to MRC global data.
  @param[in]  Controller        - Controller to get timings
  @param[in]  Channel           - Controller to get timings
  @param[in]  tCWL              - Write Latency for current channel
  @param[in]  AddTcwl           - Current AddTcwl value
  @param[in]  DecTcwl           - Current DecTcwl value
  @param[out] tCWL4TxDqFifoWrEn - Pointer to the write TX DQ fifo delay
  @param[out] tCWL4TxDqFifoRdEn - Pointer to the read TX DQ fifo delay

  @retval N/A.
**/
VOID
MrcGetTxDqFifoDelays (
  IN OUT MrcParameters *const MrcData,
  IN     UINT32        Controller,
  IN     UINT32        Channel,
  IN     INT32         tCWL,
  IN     UINT32        AddTcwl,
  IN     UINT32        DecTcwl,
     OUT INT64         *tCWL4TxDqFifoWrEn,
     OUT INT64         *tCWL4TxDqFifoRdEn
  );
#endif //_MrcDdrIoApi_h_
