/** @file
  Register names for PCH GPIO

Conventions:

  - Register definition format:
    Prefix_[GenerationName]_[ComponentName]_SubsystemName_RegisterSpace_RegisterName
  - Prefix:
    Definitions beginning with "R_" are registers
    Definitions beginning with "B_" are bits within registers
    Definitions beginning with "V_" are meaningful values within the bits
    Definitions beginning with "S_" are register size
    Definitions beginning with "N_" are the bit position
  - [GenerationName]:
    Three letter acronym of the generation is used (e.g. SKL,KBL,CNL etc.).
    Register name without GenerationName applies to all generations.
  - [ComponentName]:
    This field indicates the component name that the register belongs to (e.g. PCH, SA etc.)
    Register name without ComponentName applies to all components.
    Register that is specific to -H denoted by "_PCH_H_" in component name.
    Register that is specific to -LP denoted by "_PCH_LP_" in component name.
  - SubsystemName:
    This field indicates the subsystem name of the component that the register belongs to
    (e.g. PCIE, USB, SATA, GPIO, PMC etc.).
  - RegisterSpace:
    MEM - MMIO space register of subsystem.
    IO  - IO space register of subsystem.
    PCR - Private configuration register of subsystem.
    CFG - PCI configuration space register of subsystem.
  - RegisterName:
    Full register name.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2013 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _PCH_REGS_GPIO_H_
#define _PCH_REGS_GPIO_H_

//
// GPIO Common Private Configuration Registers
//
#define R_GPIO_PCR_REV_ID               0x00
#define R_GPIO_PCR_CAP_LIST             0x04
#define R_GPIO_PCR_FAMBAR               0x08
#define R_GPIO_PCR_PADBAR               0x0C
#define B_GPIO_PCR_PADBAR               0x0000FFFF
#define R_GPIO_PCR_MISCCFG              0x10
#define B_GPIO_PCR_MISCCFG_GPE0_DW2     (MRC_BIT19 | MRC_BIT18 | MRC_BIT17 | MRC_BIT16)
#define N_GPIO_PCR_MISCCFG_GPE0_DW2     16
#define B_GPIO_PCR_MISCCFG_GPE0_DW1     (MRC_BIT15 | MRC_BIT14 | MRC_BIT13 | MRC_BIT12)
#define N_GPIO_PCR_MISCCFG_GPE0_DW1     12
#define B_GPIO_PCR_MISCCFG_GPE0_DW0     (MRC_BIT11 | MRC_BIT10 | MRC_BIT9 | MRC_BIT8)
#define N_GPIO_PCR_MISCCFG_GPE0_DW0     8
#define B_GPIO_PCR_MISCCFG_GPSIDEDPCGEN    MRC_BIT5
#define B_GPIO_PCR_MISCCFG_GPRCOMPCDLCGEN  MRC_BIT4
#define B_GPIO_PCR_MISCCFG_GPRTCDLCGEN     MRC_BIT3
#define B_GPIO_PCR_MISCCFG_GPDPCGEN     MRC_BIT1
#define B_GPIO_PCR_MISCCFG_GPDLCGEN     MRC_BIT0
#define R_GPIO_PCR_MISCSECCFG           0x14

//
// GPIO Community 1 Private Configuration Registers
//
#define R_GPIO_PCR_CAP_LIST_1_PWM         0x0200
#define R_GPIO_PCR_PWMC                   0x0204
#define R_GPIO_PCR_CAP_LIST_2_SER_BLINK   0x0208
#define R_GPIO_PCR_GP_SER_BLINK           0x020C
#define B_GPIO_PCR_GP_SER_BLINK           0x1F
#define R_GPIO_PCR_GP_SER_CMDSTS          0x0210
#define B_GPIO_PCR_GP_SER_CMDSTS_DLS      (MRC_BIT23 | MRC_BIT22)
#define N_GPIO_PCR_GP_SER_CMDSTS_DLS      22
#define B_GPIO_PCR_GP_SER_CMDSTS_DRS      0x003F0000
#define N_GPIO_PCR_GP_SER_CMDSTS_DRS      16
#define B_GPIO_PCR_GP_SER_CMDSTS_BUSY     MRC_BIT8
#define B_GPIO_PCR_GP_SER_CMDSTS_GO       MRC_BIT0
#define R_GPIO_PCR_GP_SER_DATA            0x0210

//
// Host Software Pad Ownership modes
//
#define V_GPIO_PCR_HOSTSW_OWN_ACPI      0x00
#define V_GPIO_PCR_HOSTSW_OWN_GPIO      0x01

//
// Pad Ownership modes
//
#define V_GPIO_PCR_PAD_OWN_HOST         0x00
#define V_GPIO_PCR_PAD_OWN_CSME         0x01
#define V_GPIO_PCR_PAD_OWN_ISH          0x02


//
// Pad Configuration Register DW0
//

//Pad Reset Config
#define B_GPIO_PCR_RST_CONF             (MRC_BIT31 | MRC_BIT30)
#define N_GPIO_PCR_RST_CONF             30
#define V_GPIO_PCR_RST_CONF_POW_GOOD    0x00
#define V_GPIO_PCR_RST_CONF_DEEP_RST    0x01
#define V_GPIO_PCR_RST_CONF_GPIO_RST    0x02
#define V_GPIO_PCR_RST_CONF_RESUME_RST  0x03  // Only for GPD Group

//RX Pad State Select
#define B_GPIO_PCR_RX_PAD_STATE         MRC_BIT29
#define N_GPIO_PCR_RX_PAD_STATE         29
#define V_GPIO_PCR_RX_PAD_STATE_RAW     0x00
#define V_GPIO_PCR_RX_PAD_STATE_INT     0x01

//RX Raw Overrride to 1
#define B_GPIO_PCR_RX_RAW1              MRC_BIT28
#define N_GPIO_PCR_RX_RAW1              28
#define V_GPIO_PCR_RX_RAW1_DIS          0x00
#define V_GPIO_PCR_RX_RAW1_EN           0x01

//RX Level/Edge Configuration
#define B_GPIO_PCR_RX_LVL_EDG           (MRC_BIT26 | MRC_BIT25)
#define N_GPIO_PCR_RX_LVL_EDG           25
#define V_GPIO_PCR_RX_LVL_EDG_LVL       0x00
#define V_GPIO_PCR_RX_LVL_EDG_EDG       0x01
#define V_GPIO_PCR_RX_LVL_EDG_0         0x02
#define V_GPIO_PCR_RX_LVL_EDG_RIS_FAL   0x03

//RX Invert
#define B_GPIO_PCR_RXINV                MRC_BIT23
#define N_GPIO_PCR_RXINV                23
#define V_GPIO_PCR_RXINV_NO             0x00
#define V_GPIO_PCR_RXINV_YES            0x01

//GPIO Input Route IOxAPIC
#define B_GPIO_PCR_RX_APIC_ROUTE        MRC_BIT20
#define N_GPIO_PCR_RX_APIC_ROUTE        20
#define V_GPIO_PCR_RX_APIC_ROUTE_DIS    0x00
#define V_GPIO_PCR_RX_APIC_ROUTE_EN     0x01

//GPIO Input Route SCI
#define B_GPIO_PCR_RX_SCI_ROUTE         MRC_BIT19
#define N_GPIO_PCR_RX_SCI_ROUTE         19
#define V_GPIO_PCR_RX_SCI_ROUTE_DIS     0x00
#define V_GPIO_PCR_RX_SCI_ROUTE_EN      0x01

//GPIO Input Route SMI
#define B_GPIO_PCR_RX_SMI_ROUTE         MRC_BIT18
#define N_GPIO_PCR_RX_SMI_ROUTE         18
#define V_GPIO_PCR_RX_SMI_ROUTE_DIS     0x00
#define V_GPIO_PCR_RX_SMI_ROUTE_EN      0x01

//GPIO Input Route NMI
#define B_GPIO_PCR_RX_NMI_ROUTE         MRC_BIT17
#define N_GPIO_PCR_RX_NMI_ROUTE         17
#define V_GPIO_PCR_RX_NMI_ROUTE_DIS     0x00
#define V_GPIO_PCR_RX_NMI_ROUTE_EN      0x01

//GPIO Pad Mode
#define B_GPIO_PCR_PAD_MODE             (MRC_BIT12 | MRC_BIT11 | MRC_BIT10)
#define N_GPIO_PCR_PAD_MODE             10
#define V_GPIO_PCR_PAD_MODE_GPIO        0
#define V_GPIO_PCR_PAD_MODE_NAT_1       1
#define V_GPIO_PCR_PAD_MODE_NAT_2       2
#define V_GPIO_PCR_PAD_MODE_NAT_3       3
#define V_GPIO_PCR_PAD_MODE_NAT_4       4 // SPT-H only

//GPIO RX Disable
#define B_GPIO_PCR_RXDIS                MRC_BIT9
#define N_GPIO_PCR_RXDIS                9
#define V_GPIO_PCR_RXDIS_EN             0x00
#define V_GPIO_PCR_RXDIS_DIS            0x01

//GPIO TX Disable
#define B_GPIO_PCR_TXDIS                MRC_BIT8
#define N_GPIO_PCR_TXDIS                8
#define V_GPIO_PCR_TXDIS_EN             0x00
#define V_GPIO_PCR_TXDIS_DIS            0x01

//GPIO RX State
#define B_GPIO_PCR_RX_STATE             MRC_BIT1
#define N_GPIO_PCR_RX_STATE             1
#define V_GPIO_PCR_RX_STATE_LOW         0x00
#define V_GPIO_PCR_RX_STATE_HIGH        0x01

//GPIO TX State
#define B_GPIO_PCR_TX_STATE             MRC_BIT0
#define N_GPIO_PCR_TX_STATE             0
#define V_GPIO_PCR_TX_STATE_LOW         0x00
#define V_GPIO_PCR_TX_STATE_HIGH        0x01

//
// Pad Configuration Register DW1
//

//Padtol
#define B_GPIO_PCR_PADTOL               MRC_BIT25
#define N_GPIO_PCR_PADTOL               25
#define V_GPIO_PCR_PADTOL_NONE          0x00
#define V_GPIO_PCR_PADTOL_CLEAR         0x00
#define V_GPIO_PCR_PADTOL_SET           0x01

//Termination
#define B_GPIO_PCR_TERM                (MRC_BIT13 | MRC_BIT12 | MRC_BIT11 | MRC_BIT10)
#define N_GPIO_PCR_TERM                 10
#define V_GPIO_PCR_TERM_WPD_NONE        0x00
#define V_GPIO_PCR_TERM_WPD_5K          0x02
#define V_GPIO_PCR_TERM_WPD_20K         0x04
#define V_GPIO_PCR_TERM_WPU_NONE        0x08
#define V_GPIO_PCR_TERM_WPU_1K          0x09
#define V_GPIO_PCR_TERM_WPU_2K          0x0B
#define V_GPIO_PCR_TERM_WPU_5K          0x0A
#define V_GPIO_PCR_TERM_WPU_20K         0x0C
#define V_GPIO_PCR_TERM_WPU_1K_2K       0x0D
#define V_GPIO_PCR_TERM_NATIVE          0x0F

//Interrupt number
#define B_GPIO_PCR_INTSEL               0x7F
#define N_GPIO_PCR_INTSEL               0

//
// Pad Configuration Register DW2
//

// VCCIOSEL
#define B_GPIO_PCR_VCCIOSEL              MRC_BIT8
#define N_GPIO_PCR_VCCIOSEL              8

//Debounce
#define B_GPIO_PCR_DEBOUNCE             (MRC_BIT4 | MRC_BIT3 | MRC_BIT2 | MRC_BIT1)
#define N_GPIO_PCR_DEBOUNCE              1

//Debounce Enable
#define B_GPIO_PCR_DEBEN                 MRC_BIT0
#define N_GPIO_PCR_DEBEN                 0

//
// Ownership
//
#define V_GPIO_PCR_OWN_GPIO             0x01
#define V_GPIO_PCR_OWN_ACPI             0x00

//
// GPE
//
#define V_GPIO_PCR_GPE_EN               0x01
#define V_GPIO_PCR_GPE_DIS              0x00
//
// SMI
//
#define V_GPIO_PCR_SMI_EN               0x01
#define V_GPIO_PCR_SMI_DIS              0x00
//
// NMI
//
#define V_GPIO_PCR_NMI_EN               0x01
#define V_GPIO_PCR_NMI_DIS              0x00

//
// GPIO native features pins data
//
#define PCH_GPIO_HDA_LINK_NUMBER_OF_PINS     6
#define PCH_GPIO_HDA_DMIC_NUMBER_OF_PINS     2
#define PCH_GPIO_HDA_SSP_NUMBER_OF_PINS      4
#define PCH_GPIO_HDA_SNDW_NUMBER_OF_PINS     2
#define PCH_GPIO_SMBUS_NUMBER_OF_PINS        2
#define PCH_GPIO_CPU_GP_NUMBER_OF_PINS       4
#define PCH_GPIO_DDSP_HPD_NUMBER_OF_PINS     4
#define PCH_GPIO_DDP_NUMBER_OF_INTERFACES    4
#define PCH_GPIO_DDP_NUMBER_OF_PINS          2
#define PCH_GPIO_CNVI_UART_NUMBER_OF_PINS    4
#define PCH_GPIO_CNVI_SSP_NUMBER_OF_PINS     4
#define PCH_GPIO_CNVI_BRI_RGI_NUMBER_OF_PINS 4


///
/// GPIO SMI data used for EFI_SMM_GPI_DISPATCH2_PROTOCOL
/// Below defines are to be used internally by PCH SMI dispatcher only
///
#define PCH_GPIO_NUM_SUPPORTED_GPIS       512
#define S_GPIO_PCR_GP_SMI_EN                4
#define S_GPIO_PCR_GP_SMI_STS               4

///
/// Groups mapped to 2-tier General Purpose Event will all be under
/// one master GPE_111 (0x6F)
///
#define PCH_GPIO_2_TIER_MASTER_GPE_NUMBER  0x6F

#endif
