/** @file
  Register names for PCH private chipset register

  Conventions:

  - Prefixes:
    Definitions beginning with "R_" are registers
    Definitions beginning with "B_" are bits within registers
    Definitions beginning with "V_" are meaningful values within the bits
    Definitions beginning with "S_" are register sizes
    Definitions beginning with "N_" are the bit position
  - In general, PCH registers are denoted by "_PCH_" in register names
  - Registers / bits that are different between PCH generations are denoted by
    "_PCH_[generation_name]_" in register/bit names.
  - Registers / bits that are specific to PCH-H denoted by "_H_" in register/bit names.
    Registers / bits that are specific to PCH-LP denoted by "_LP_" in register/bit names.
    e.g., "_PCH_H_", "_PCH_LP_"
    Registers / bits names without _H_ or _LP_ apply for both H and LP.
  - Registers / bits that are different between SKUs are denoted by "_[SKU_name]"
    at the end of the register/bit names
  - Registers / bits of new devices introduced in a PCH generation will be just named
    as "_PCH_" without [generation_name] inserted.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2013 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _PCH_REGS_PCR_H_
#define _PCH_REGS_PCR_H_

#include "MrcOemPlatform.h"

///
/// Definition for PCR base address (defined in PchReservedResources.h)
///
#define PCH_PCR_BASE_ADDRESS            0xFD000000
//#define PCH_PCR_MMIO_SIZE               0x01000000
/**
  Definition for PCR address
  The PCR address is used to the PCR MMIO programming
**/
#define PCH_PCR_ADDRESS(Pid, Offset)    (PCH_PCR_BASE_ADDRESS | ((UINT8)(Pid) << 16) | (UINT16)(Offset))

/**
  PCH PCR boot script accessing macro
  Those macros are only available for DXE phase.
**/
#define PCH_PCR_BOOT_SCRIPT_WRITE(Width, Pid, Offset, Count, Buffer) \
          S3BootScriptSaveMemWrite (Width, PCH_PCR_ADDRESS (Pid, Offset), Count, Buffer); \
          S3BootScriptSaveMemPoll (Width, PCH_PCR_ADDRESS (Pid, Offset), Buffer, Buffer, 1, 1);

#define PCH_PCR_BOOT_SCRIPT_READ_WRITE(Width, Pid, Offset, DataOr, DataAnd) \
          S3BootScriptSaveMemReadWrite (Width, PCH_PCR_ADDRESS (Pid, Offset), DataOr, DataAnd); \
          S3BootScriptSaveMemPoll (Width, PCH_PCR_ADDRESS (Pid, Offset), DataOr, DataOr, 1, 1);


/**
  Definition for SBI PID
  The PCH_SBI_PID defines the PID for PCR MMIO programming and PCH SBI programming as well.
**/
// SKL/KBL
#define  SKL_PID_DMI                          0xEF
#define  SKL_PID_ESPISPI                      0xEE
#define  SKL_PID_OPIPHY                       0xEC
#define  SKL_PID_MODPHY0                      0xEA
#define  SKL_PID_MODPHY1                      0xE9
#define  SKL_PID_OTG                          0xE5
#define  SKL_PID_SPF                          0xC9 // Available only in KBL PCH H
#define  SKL_PID_SPE                          0xE4 // Reserved in SKL PCH LP
#define  SKL_PID_SPD                          0xE3 // Reserved in SKL PCH LP
#define  SKL_PID_SPC                          0xE2
#define  SKL_PID_SPB                          0xE1
#define  SKL_PID_SPA                          0xE0
#define  SKL_PID_ICC                          0xDC
#define  SKL_PID_DSP                          0xD7
#define  SKL_PID_FIA                          0xCF
#define  SKL_PID_SERIALIO                     0xCB
#define  SKL_PID_USB2                         0xCA
#define  SKL_PID_LPC                          0xC7
#define  SKL_PID_SMB                          0xC6
#define  SKL_PID_ITSS                         0xC4
#define  SKL_PID_RTC                          0xC3
#define  SKL_PID_SCS                          0xC0 // Reserved in SKL PCH H
#define  SKL_PID_ISHBR                        0xBF
#define  SKL_PID_ISH                          0xBE
#define  SKL_PID_PSF4                         0xBD
#define  SKL_PID_PSF3                         0xBC
#define  SKL_PID_PSF2                         0xBB
#define  SKL_PID_PSF1                         0xBA
#define  SKL_PID_DCI                          0xB8
#define  SKL_PID_MMP0                         0xB0 // for SKL-LP only
#define  SKL_PID_MODPHY4                      0xB0 // for KBL-H only
#define  SKL_PID_GPIOCOM0                     0xAF
#define  SKL_PID_GPIOCOM1                     0xAE
#define  SKL_PID_GPIOCOM2                     0xAD
#define  SKL_PID_GPIOCOM3                     0xAC
#define  SKL_PID_CAM_FLS                      0xAA
#define  SKL_PID_MODPHY2                      0xA9
#define  SKL_PID_MODPHY3                      0xA8
#define  SKL_PID_CAM_CHC                      0xA1
#define  SKL_PID_CSME12                       0x9C
#define  SKL_PID_CSME0                        0x90
#define  SKL_PID_CSME_PSF                     0x8F
#define  SKL_PID_PSTH                         0x89

//CNL
#define  CNL_PID_BROADCAST1                        0xFF // @todo CNL PCH, check CNL cspec
#define  CNL_PID_BROADCAST2                        0xFE // @todo CNL PCH, check CNL cspec
#define  CNL_PID_CNVI                              0x73
#define  CNL_PID_ICLK                              0xAD
#define  CNL_PID_OPIPHY                            0xAC
#define  CNL_PID_MODPHY0                           0xAB
#define  CNL_PID_MODPHY1                           0xAA
#define  CNL_PID_MODPHY2                           0xA9
#define  CNL_PID_MODPHY3                           0xA8
#define  CNL_PID_SD4MPHY                           0xAE
#define  CNL_PID_USB2                              0xCA
#define  CNL_PID_DMI                               0x88
#define  CNL_PID_PSTH                              0x89
#define  CNL_PID_SATA                              0xD9
#define  CNL_PID_DSP                               0xD7
#define  CNL_PID_ESPISPI                           0x72
#define  CNL_PID_FIA                               0xCF
#define  CNL_PID_SPF                               0x85
#define  CNL_PID_SPE                               0x84
#define  CNL_PID_SPD                               0x83
#define  CNL_PID_SPC                               0x82
#define  CNL_PID_SPB                               0x81
#define  CNL_PID_SPA                               0x80
#define  CNL_PID_PNCRA3                            0xA5
#define  CNL_PID_PNCRA2                            0xA4
#define  CNL_PID_PNCRA1                            0xA3
#define  CNL_PID_PNCRB                             0xA2
#define  CNL_PID_XHCI                              0x70
#define  CNL_PID_OTG                               0x71
#define  CNL_PID_SERIALIO                          0xCB
#define  CNL_PID_ISH                               0xBE
#define  CNL_PID_ISHBR                             0xBF
#define  CNL_PID_ADC_IEC                           0xC8
#define  CNL_PID_SDX                               0x53
#define  CNL_PID_EMMC                              0x52
#define  CNL_PID_UFSX1                             0x51
#define  CNL_PID_UFSX2                             0x50
#define  CNL_PID_LPC                               0xC7
#define  CNL_PID_SMB                               0xC6
#define  CNL_PID_P2S                               0xC5
#define  CNL_PID_ITSS                              0xC4
#define  CNL_PID_RTC                               0xC3 // @todo CNL PCH, should be removed and replaced by RTC_HOST
#define  CNL_PID_RTC_HOST                          0xC3
#define  CNL_PID_RTC_IEC                           0xC2
#define  CNL_PID_TRSB                              0xDD
#define  CNL_PID_GBE                               0xDB
#define  CNL_PID_P2D                               0xA0
#define  CNL_PID_ICC                               0xDC
#define  CNL_PID_MMP_UFSX1                         0xB2
#define  CNL_PID_MMP_UFSX2                         0xB1
#define  CNL_PID_PMC                               0xCC
#define  CNL_PID_PMCBR                             0xCD
//#define  PID_PPBR                              0xCE
#define  CNL_PID_TAP2IOSFSB                        0xDF
#define  CNL_PID_DCI                               0xB8
#define  CNL_PID_DFXAGG                            0xB7
#define  CNL_PID_CTB2                              0x68
#define  CNL_PID_CTB1                              0x67
#define  CNL_PID_CTB0                              0x66
#define  CNL_PID_NPK                               0xB6
#define  CNL_PID_FUSE                              0xD5
#define  CNL_PID_DRNG                              0xD2
#define  CNL_PID_FSPROX3                           0x63
#define  CNL_PID_FSPROX2                           0x62
#define  CNL_PID_FSPROX1                           0x61
#define  CNL_PID_FSPROX0                           0x60
#define  CNL_PID_PSF6                              0x7F
#define  CNL_PID_PSF7                              0x7E
#define  CNL_PID_PSF8                              0x7D
#define  CNL_PID_PSF4                              0xBD
#define  CNL_PID_PSF3                              0xBC
#define  CNL_PID_PSF2                              0xBB
#define  CNL_PID_PSF1                              0xBA
#define  CNL_PID_GPIOCOM0                          0x6E
#define  CNL_PID_GPIOCOM1                          0x6D
#define  CNL_PID_GPIOCOM2                          0x6C
#define  CNL_PID_GPIOCOM3                          0x6B
#define  CNL_PID_GPIOCOM4                          0x6A
#define  CNL_PID_CSME15                            0x9F
#define  CNL_PID_CSME14                            0x9E
#define  CNL_PID_CSME13                            0x9D
#define  CNL_PID_CSME12                            0x9C
#define  CNL_PID_CSME11                            0x9B
#define  CNL_PID_CSME10                            0x9A
#define  CNL_PID_CSME9                             0x99
#define  CNL_PID_CSME8                             0x98
#define  CNL_PID_CSME7                             0x97
#define  CNL_PID_CSME6                             0x96
#define  CNL_PID_CSME5                             0x95
#define  CNL_PID_CSME4                             0x94
#define  CNL_PID_CSME3                             0x93
#define  CNL_PID_CSME2                             0x92
#define  CNL_PID_CSME1                             0x91
#define  CNL_PID_CSME0                             0x90
#define  CNL_PID_CSME_PSF                          0x8F
#define  CNL_PID_HOTHAM                            0xB9
#define  CNL_PID_CSMERTC                           0x8E
#define  CNL_PID_CAM_FLS                           0xAA// @todo CNL PCH, should be removed
#define  CNL_PID_CAM_CHC                           0xA1// @todo CNL PCH, should be removed

typedef  UINT8                            PCH_SBI_PID;
#endif
