/** @file
  Register names for PCH Serial IO Controllers

  Conventions:

  - Register definition format:
    Prefix_[GenerationName]_[ComponentName]_SubsystemName_RegisterSpace_RegisterName
  - Prefix:
    Definitions beginning with "R_" are registers
    Definitions beginning with "B_" are bits within registers
    Definitions beginning with "V_" are meaningful values within the bits
    Definitions beginning with "S_" are register size
    Definitions beginning with "N_" are the bit position
  - [GenerationName]:
    Three letter acronym of the generation is used (e.g. SKL,KBL,CNL etc.).
    Register name without GenerationName applies to all generations.
  - [ComponentName]:
    This field indicates the component name that the register belongs to (e.g. PCH, SA etc.)
    Register name without ComponentName applies to all components.
    Register that is specific to -H denoted by "_PCH_H_" in component name.
    Register that is specific to -LP denoted by "_PCH_LP_" in component name.
  - SubsystemName:
    This field indicates the subsystem name of the component that the register belongs to
    (e.g. PCIE, USB, SATA, GPIO, PMC etc.).
  - RegisterSpace:
    MEM - MMIO space register of subsystem.
    IO  - IO space register of subsystem.
    PCR - Private configuration register of subsystem.
    CFG - PCI configuration space register of subsystem.
  - RegisterName:
    Full register name.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2012 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _PCH_REGS_SERIAL_IO_
#define _PCH_REGS_SERIAL_IO_

//
//  Serial IO I2C0 Controller Registers (D21:F0)
//
#define PCI_DEVICE_NUMBER_PCH_SERIAL_IO_I2C0            21
#define PCI_FUNCTION_NUMBER_PCH_SERIAL_IO_I2C0          0

#define V_PCH_LP_SERIAL_IO_CFG_I2C0_DEVICE_ID               0x9DE8
#define V_PCH_H_SERIAL_IO_CFG_I2C0_DEVICE_ID                0xA368
//
//  Serial IO I2C1 Controller Registers (D21:F1)
//
#define PCI_DEVICE_NUMBER_PCH_SERIAL_IO_I2C1            21
#define PCI_FUNCTION_NUMBER_PCH_SERIAL_IO_I2C1          1
#define V_PCH_LP_SERIAL_IO_CFG_I2C1_DEVICE_ID               0x9DE9
#define V_PCH_H_SERIAL_IO_CFG_I2C1_DEVICE_ID                0xA369
//
//  Serial IO I2C2 Controller Registers (D21:F2)
//
#define PCI_DEVICE_NUMBER_PCH_SERIAL_IO_I2C2            21
#define PCI_FUNCTION_NUMBER_PCH_SERIAL_IO_I2C2          2
#define V_PCH_LP_SERIAL_IO_CFG_I2C2_DEVICE_ID               0x9DEA
#define V_PCH_H_SERIAL_IO_CFG_I2C2_DEVICE_ID                0xA36A
//
//  Serial IO I2C3 Controller Registers (D21:F3)
//
#define PCI_DEVICE_NUMBER_PCH_SERIAL_IO_I2C3            21
#define PCI_FUNCTION_NUMBER_PCH_SERIAL_IO_I2C3          3
#define V_PCH_LP_SERIAL_IO_CFG_I2C3_DEVICE_ID               0x9DEB
#define V_PCH_H_SERIAL_IO_CFG_I2C3_DEVICE_ID                0xA36B
//
//  Serial IO I2C4 Controller Registers (D25:F2)
//
#define PCI_DEVICE_NUMBER_PCH_SERIAL_IO_I2C4            25
#define PCI_FUNCTION_NUMBER_PCH_SERIAL_IO_I2C4          0
#define V_PCH_LP_SERIAL_IO_CFG_I2C4_DEVICE_ID               0x9DC5
//
//  Serial IO I2C5 Controller Registers (D25:F1)
//
#define PCI_DEVICE_NUMBER_PCH_SERIAL_IO_I2C5            25
#define PCI_FUNCTION_NUMBER_PCH_SERIAL_IO_I2C5          1
#define V_PCH_LP_SERIAL_IO_CFG_I2C5_DEVICE_ID               0x9DC6
//
//  Serial IO SPI0 Controller Registers (D30:F2)
//
#define PCI_DEVICE_NUMBER_PCH_SERIAL_IO_SPI0            30
#define PCI_FUNCTION_NUMBER_PCH_SERIAL_IO_SPI0          2
#define V_PCH_LP_SERIAL_IO_CFG_SPI0_DEVICE_ID               0x9DAA
#define V_PCH_H_SERIAL_IO_CFG_SPI0_DEVICE_ID                0xA32A
//
//  Serial IO SPI1 Controller Registers (D30:F3)
//
#define PCI_DEVICE_NUMBER_PCH_SERIAL_IO_SPI1            30
#define PCI_FUNCTION_NUMBER_PCH_SERIAL_IO_SPI1          3
#define V_PCH_LP_SERIAL_IO_CFG_SPI1_DEVICE_ID               0x9DAB
#define V_PCH_H_SERIAL_IO_CFG_SPI1_DEVICE_ID                0xA32B
//
//  Serial IO SPI2 Controller Registers (D18:F6)
//
#define PCI_DEVICE_NUMBER_PCH_SERIAL_IO_SPI2            18
#define PCI_FUNCTION_NUMBER_PCH_SERIAL_IO_SPI2          6
#define V_PCH_LP_SERIAL_IO_CFG_SPI2_DEVICE_ID               0x9DFB
#define V_PCH_H_SERIAL_IO_CFG_SPI2_DEVICE_ID                0xA37B
//
//  Serial IO UART0 Controller Registers (D30:F0)
//
#define PCI_DEVICE_NUMBER_PCH_SERIAL_IO_UART0           30
#define PCI_FUNCTION_NUMBER_PCH_SERIAL_IO_UART0         0
#define V_PCH_LP_SERIAL_IO_CFG_UART0_DEVICE_ID              0x9DA8
#define V_PCH_H_SERIAL_IO_CFG_UART0_DEVICE_ID               0xA328
//
//  Serial IO UART1 Controller Registers (D30:F1)
//
#define PCI_DEVICE_NUMBER_PCH_SERIAL_IO_UART1           30
#define PCI_FUNCTION_NUMBER_PCH_SERIAL_IO_UART1         1
#define V_PCH_LP_SERIAL_IO_CFG_UART1_DEVICE_ID              0x9DA9
#define V_PCH_H_SERIAL_IO_CFG_UART1_DEVICE_ID               0xA329
//
//  Serial IO UART2 Controller Registers (D25:F0)
//
#define PCI_DEVICE_NUMBER_PCH_SERIAL_IO_UART2           25
#define PCI_FUNCTION_NUMBER_PCH_SERIAL_IO_UART2         2
#define V_PCH_LP_SERIAL_IO_CFG_UART2_DEVICE_ID              0x9DC7
#define V_PCH_H_SERIAL_IO_CFG_UART2_DEVICE_ID               0xA347

//
// Serial IO Controllers General PCI Configuration Registers
// registers accessed using PciD21FxRegBase + offset
//
#define R_SERIAL_IO_CFG_BAR0_LOW                        0x10
#define B_SERIAL_IO_CFG_BAR0_LOW_BAR                    0xFFFFF000
#define R_SERIAL_IO_CFG_BAR0_HIGH                       0x14
#define R_SERIAL_IO_CFG_BAR1_LOW                        0x18
#define B_SERIAL_IO_CFG_BAR1_LOW_BAR                    0xFFFFF000
#define R_SERIAL_IO_CFG_BAR1_HIGH                       0x1C
#define V_SERIAL_IO_CFG_BAR_SIZE                        (4 * 1024)
#define N_SERIAL_IO_CFG_BAR_ALIGNMENT                   12

#define R_SERIAL_IO_CFG_PME_CTRL_STS                    0x84
#define B_SERIAL_IO_CFG_PME_CTRL_STS_PWR_ST             (MRC_BIT1| MRC_BIT0)

#define R_SERIAL_IO_CFG_D0I3MAXDEVPG                    0xA0
#define B_SERIAL_IO_CFG_D0I3MAXDEVPG_PMCRE              MRC_BIT16
#define B_SERIAL_IO_CFG_D0I3MAXDEVPG_I3E                MRC_BIT17
#define B_SERIAL_IO_CFG_D0I3MAXDEVPG_PGE                MRC_BIT18

#define R_SERIAL_IO_CFG_INTERRUPTREG                    0x3C
#define B_SERIAL_IO_CFG_INTERRUPTREG_INTLINE            0x000000FF

//
// Serial IO Controllers MMIO Registers
// registers accessed : BAR0 + offset
//
#define R_SERIAL_IO_MEM_SSCR1                           0x4
#define B_SERIAL_IO_MEM_SSCR1_IFS                       MRC_BIT16

#define R_SERIAL_IO_MEM_PPR_CLK                         0x200
#define B_SERIAL_IO_MEM_PPR_CLK_EN                      MRC_BIT0
#define B_SERIAL_IO_MEM_PPR_CLK_UPDATE                  MRC_BIT31
#define V_SERIAL_IO_MEM_PPR_CLK_M_DIV                   0x30
#define V_SERIAL_IO_MEM_PPR_CLK_N_DIV                   0xC35

#define R_SERIAL_IO_MEM_PPR_RESETS                      0x204
#define B_SERIAL_IO_MEM_PPR_RESETS_FUNC                 MRC_BIT0
#define B_SERIAL_IO_MEM_PPR_RESETS_APB                  MRC_BIT1
#define B_SERIAL_IO_MEM_PPR_RESETS_IDMA                 MRC_BIT2

#define R_SERIAL_IO_MEM_ACTIVE_LTR                      0x210
#define R_SERIAL_IO_MEM_IDLE_LTR                        0x214
#define B_SERIAL_IO_MEM_LTR_SNOOP_VALUE                 0x000003FF
#define B_SERIAL_IO_MEM_LTR_SNOOP_SCALE                 0x00001C00
#define B_SERIAL_IO_MEM_LTR_SNOOP_REQUIREMENT           MRC_BIT15

#define R_SERIAL_IO_MEM_SPI_CS_CONTROL                  0x224
#define B_SERIAL_IO_MEM_SPI_CS_CONTROL_STATE            MRC_BIT1
#define B_SERIAL_IO_MEM_SPI_CS_CONTROL_MODE             MRC_BIT0

#define R_SERIAL_IO_MEM_REMAP_ADR_LOW                   0x240
#define R_SERIAL_IO_MEM_REMAP_ADR_HIGH                  0x244

#define R_SERIAL_IO_MEM_I2C_SDA_HOLD                    0x7C
#define V_SERIAL_IO_MEM_I2C_SDA_HOLD_VALUE              0x002C002C

//
// I2C Controller
// Registers accessed through BAR0 + offset
//
#define    R_IC_CON                            0x00 // I2c Control
#define    B_IC_MASTER_MODE                    MRC_BIT0
#define    B_IC_RESTART_EN                     MRC_BIT5
#define    B_IC_SLAVE_DISABLE                  MRC_BIT6
#define    V_IC_SPEED_STANDARD                 0x02
#define    V_IC_SPEED_FAST                     0x04
#define    V_IC_SPEED_HIGH                     0x06

#define    R_IC_TAR                            0x04 // I2c Target Address
#define    B_IC_TAR_10BITADDR_MASTER           MRC_BIT12

#define    R_IC_DATA_CMD                       0x10  // I2c Rx/Tx Data Buffer and Command
#define    B_IC_CMD_READ                       MRC_BIT8    // 1 = read, 0 = write
#define    B_IC_CMD_STOP                       MRC_BIT9    // 1 = STOP
#define    B_IC_CMD_RESTART                    MRC_BIT10   // 1 = IC_RESTART_EN
#define    V_IC_WRITE_CMD_MASK                 0xFF

#define    R_IC_SS_SCL_HCNT                    0x14 // Standard Speed I2c Clock SCL High Count
#define    R_IC_SS_SCL_LCNT                    0x18 // Standard Speed I2c Clock SCL Low Count
#define    R_IC_FS_SCL_HCNT                    0x1C // Full Speed I2c Clock SCL High Count
#define    R_IC_FS_SCL_LCNT                    0x20 // Full Speed I2c Clock SCL Low Count
#define    R_IC_HS_SCL_HCNT                    0x24 // High Speed I2c Clock SCL High Count
#define    R_IC_HS_SCL_LCNT                    0x28 // High Speed I2c Clock SCL Low Count
#define    R_IC_INTR_STAT                      0x2C // I2c Inetrrupt Status
#define    R_IC_INTR_MASK                      0x30 // I2c Interrupt Mask
#define    B_IC_INTR_GEN_CALL                  MRC_BIT11  // General call received
#define    B_IC_INTR_START_DET                 MRC_BIT10
#define    B_IC_INTR_STOP_DET                  MRC_BIT9
#define    B_IC_INTR_ACTIVITY                  MRC_BIT8
#define    B_IC_INTR_TX_ABRT                   MRC_BIT6   // Set on NACK
#define    B_IC_INTR_TX_EMPTY                  MRC_BIT4
#define    B_IC_INTR_TX_OVER                   MRC_BIT3
#define    B_IC_INTR_RX_FULL                   MRC_BIT2   // Data bytes in RX FIFO over threshold
#define    B_IC_INTR_RX_OVER                   MRC_BIT1
#define    B_IC_INTR_RX_UNDER                  MRC_BIT0
#define    R_IC_RAW_INTR_STAT                ( 0x34) // I2c Raw Interrupt Status
#define    R_IC_RX_TL                        ( 0x38) // I2c Receive FIFO Threshold
#define    R_IC_TX_TL                        ( 0x3C) // I2c Transmit FIFO Threshold
#define    R_IC_CLR_INTR                     ( 0x40) // Clear Combined and Individual Interrupts
#define    R_IC_CLR_RX_UNDER                 ( 0x44) // Clear RX_UNDER Interrupt
#define    R_IC_CLR_RX_OVER                  ( 0x48) // Clear RX_OVERinterrupt
#define    R_IC_CLR_TX_OVER                  ( 0x4C) // Clear TX_OVER interrupt
#define    R_IC_CLR_RD_REQ                   ( 0x50) // Clear RD_REQ interrupt
#define    R_IC_CLR_TX_ABRT                  ( 0x54) // Clear TX_ABRT interrupt
#define    R_IC_CLR_RX_DONE                  ( 0x58) // Clear RX_DONE interrupt
#define    R_IC_CLR_ACTIVITY                 ( 0x5C) // Clear ACTIVITY interrupt
#define    R_IC_CLR_STOP_DET                 ( 0x60) // Clear STOP_DET interrupt
#define    R_IC_CLR_START_DET                ( 0x64) // Clear START_DET interrupt
#define    R_IC_CLR_GEN_CALL                 ( 0x68) // Clear GEN_CALL interrupt
#define    R_IC_ENABLE                       ( 0x6C) // I2c Enable

#define    R_IC_STATUS                         0x70  // I2c Status
#define    B_IC_STATUS_RFF                     MRC_BIT4   // RX FIFO is completely full
#define    B_IC_STATUS_RFNE                    MRC_BIT3   // RX FIFO is not empty
#define    B_IC_STATUS_TFE                     MRC_BIT2   // TX FIFO is completely empty
#define    B_IC_STATUS_TFNF                    MRC_BIT1   // TX FIFO is not full
#define    B_IC_STATUS_ACTIVITY                MRC_BIT0   // Controller Activity Status.

#define    R_IC_TXFL R                       ( 0x74) // Transmit FIFO Level Register
#define    R_IC_RXFLR                        ( 0x78) // Receive FIFO Level Register
#define    R_IC_SDA_HOLD                     ( 0x7C)
#define    R_IC_TX_ABRT_SOURCE               ( 0x80) // I2c Transmit Abort Status Register
#define    B_IC_TX_ABRT_7B_ADDR_NACK          MRC_BIT0 // NACK on 7-bit address

#define    R_IC_SDA_SETUP                    ( 0x94) // I2c SDA Setup Register
#define    R_IC_ACK_GENERAL_CALL             ( 0x98) // I2c ACK General Call Register
#define    R_IC_ENABLE_STATUS                ( 0x9C) // I2c Enable Status Register
#define    B_IC_EN                            MRC_BIT0   // I2c enable status

#define    R_IC_CLK_GATE                     ( 0xC0)
#define    R_IC_COMP_PARAM                   ( 0xF4) // Component Parameter Register
#define    R_IC_COMP_VERSION                 ( 0xF8) // Component Version ID
#define    R_IC_COMP_TYPE                    ( 0xFC) // Component Type

#define    R_IC_GENERAL                      (0x208) // I2C Convergence Layer General
#define    B_IC_GENERAL_SDA_LINE_STATE        MRC_BIT26  // I2C SDA Line State: 0 - Low, 1 - High
#define    B_IC_GENERAL_SCL_LINE_STATE        MRC_BIT24  // I2C SCL Line State: 0 - Low, 1 - High

//
// Bridge Private Configuration Registers
// accessed only through SB messaging. SB access = SerialIo IOSF2OCP Bridge Port ID + offset
//
#define R_SERIAL_IO_PCR_PMCTL                        0x1D0
#define V_SERIAL_IO_PCR_PMCTL_PWR_GATING             0x3F

#define R_SERIAL_IO_PCR_PCICFGCTRLx                 0x200
#define V_SERIAL_IO_PCR_PCICFGCTRL_N_OFFS           0x04
#define R_SERIAL_IO_PCR_PCICFGCTRL1                 0x200 //I2C0
#define R_SERIAL_IO_PCR_PCICFGCTRL2                 0x204 //I2C1
#define R_SERIAL_IO_PCR_PCICFGCTRL3                 0x208 //I2C2
#define R_SERIAL_IO_PCR_PCICFGCTRL4                 0x20C //I2C3
#define R_SERIAL_IO_PCR_PCICFGCTRL5                 0x210 //I2C4
#define R_SERIAL_IO_PCR_PCICFGCTRL6                 0x214 //I2C5
#define R_SERIAL_IO_PCR_PCICFGCTRL9                 0x218 //UA00
#define R_SERIAL_IO_PCR_PCICFGCTRL10                0x21C //UA01
#define R_SERIAL_IO_PCR_PCICFGCTRL11                0x220 //UA02
#define R_SERIAL_IO_PCR_PCICFGCTRL13                0x224 //SPI0
#define R_SERIAL_IO_PCR_PCICFGCTRL14                0x228 //SPI1
#define R_SERIAL_IO_PCR_PCICFGCTRL15                0x22C //SPI2

#define B_SERIAL_IO_PCR_PCICFGCTRL_PCI_CFG_DIS      MRC_BIT0
#define B_SERIAL_IO_PCR_PCICFGCTRL_ACPI_INTR_EN     MRC_BIT1
#define B_SERIAL_IO_PCR_PCICFGCTRL_BAR1_DIS         MRC_BIT7
#define B_SERIAL_IO_PCR_PCICFGCTRL_INT_PIN          (MRC_BIT11 | MRC_BIT10 | MRC_BIT9 | MRC_BIT8)
#define N_SERIAL_IO_PCR_PCICFGCTRL_INT_PIN          8
#define V_SERIAL_IO_PCR_PCICFGCTRL_INTA             0x01
#define V_SERIAL_IO_PCR_PCICFGCTRL_INTB             0x02
#define V_SERIAL_IO_PCR_PCICFGCTRL_INTC             0x03
#define V_SERIAL_IO_PCR_PCICFGCTRL_INTD             0x04
#define B_SERIAL_IO_PCR_PCICFGCTRL_ACPI_IRQ         0x000FF000
#define N_SERIAL_IO_PCR_PCICFGCTRL_ACPI_IRQ         12
#define B_SERIAL_IO_PCR_PCICFGCTRL_PCI_IRQ          0x0FF00000
#define N_SERIAL_IO_PCR_PCICFGCTRL_PCI_IRQ          20

#define R_SERIAL_IO_PCR_GPPRVRW2                            0x604
#define B_SERIAL_IO_PCR_GPPRVRW2_PGCB_FRC_CLK_CP_EN         MRC_BIT1
#define B_SERIAL_IO_PCR_GPPRVRW2_CDC_SIDE_CFG_CG_EN         MRC_BIT5
#define B_SERIAL_IO_PCR_GPPRVRW2_CDC_SIDE_CFG_CLKREQ_CTL_EN MRC_BIT11
#define V_SERIAL_IO_PCR_GPPRVRW2_CLK_GATING                 (B_SERIAL_IO_PCR_GPPRVRW2_PGCB_FRC_CLK_CP_EN | B_SERIAL_IO_PCR_GPPRVRW2_CDC_SIDE_CFG_CG_EN | B_SERIAL_IO_PCR_GPPRVRW2_CDC_SIDE_CFG_CLKREQ_CTL_EN)


#define R_SERIAL_IO_PCR_GPPRVRW7                    0x618
#define B_SERIAL_IO_PCR_GPPRVRW7_UART0_BYTE_ADDR_EN MRC_BIT0
#define B_SERIAL_IO_PCR_GPPRVRW7_UART1_BYTE_ADDR_EN MRC_BIT1
#define B_SERIAL_IO_PCR_GPPRVRW7_UART2_BYTE_ADDR_EN MRC_BIT2

//
// Number of pins used by SerialIo controllers
//
#define PCH_SERIAL_IO_PINS_PER_I2C_CONTROLLER               2
#define PCH_SERIAL_IO_PINS_PER_UART_CONTROLLER              4
#define PCH_SERIAL_IO_PINS_PER_UART_CONTROLLER_NO_FLOW_CTRL 2
#define PCH_SERIAL_IO_PINS_PER_SPI_CONTROLLER               4

#endif
