/** @file
  This file contains routines for GPIO native and chipset specific usage

@copyright
  INTEL CONFIDENTIAL
  Copyright 2014 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#include "MrcOemPlatform.h"
#include "GpioNativeLib.h"
#include "PchRegsPmcCnl.h"
#include "PchRegsGpio.h"
#include "PchRegsGpioCnl.h"
#include "PchLimits.h"
#include "PchRegsSerialIo.h"
#include "GpioPinsCnlH.h"
#include "GpioPinsCnlLp.h"


//
// Chipset specific data
//
GLOBAL_REMOVE_IF_UNREFERENCED GPIO_GROUP_INFO mPchLpGpioGroupInfo[] = {
  {CNL_PID_GPIOCOM0, R_CNL_PCH_LP_GPIO_PCR_GPP_A_PAD_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_A_HOSTSW_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_A_GPI_IS, R_CNL_PCH_LP_GPIO_PCR_GPP_A_GPI_IE, R_CNL_PCH_LP_GPIO_PCR_GPP_A_GPI_GPE_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_A_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_CNL_PCH_LP_GPIO_PCR_GPP_A_PADCFGLOCK,   R_CNL_PCH_LP_GPIO_PCR_GPP_A_PADCFGLOCKTX,   R_CNL_PCH_LP_GPIO_PCR_GPP_A_PADCFG_OFFSET, CNL_PCH_LP_GPIO_GPP_A_PAD_MAX, V_CNL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_A, V_CNL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_A}, //CNL PCH-LP GPP_A
  {CNL_PID_GPIOCOM0, R_CNL_PCH_LP_GPIO_PCR_GPP_B_PAD_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_B_HOSTSW_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_B_GPI_IS, R_CNL_PCH_LP_GPIO_PCR_GPP_B_GPI_IE, R_CNL_PCH_LP_GPIO_PCR_GPP_B_GPI_GPE_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_B_GPI_GPE_EN, R_CNL_PCH_LP_GPIO_PCR_GPP_B_SMI_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_B_SMI_EN, R_CNL_PCH_LP_GPIO_PCR_GPP_B_NMI_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_B_NMI_EN, R_CNL_PCH_LP_GPIO_PCR_GPP_B_PADCFGLOCK,   R_CNL_PCH_LP_GPIO_PCR_GPP_B_PADCFGLOCKTX,   R_CNL_PCH_LP_GPIO_PCR_GPP_B_PADCFG_OFFSET, CNL_PCH_LP_GPIO_GPP_B_PAD_MAX, V_CNL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_B, V_CNL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_B}, //CNL PCH-LP GPP_B
  {CNL_PID_GPIOCOM4, R_CNL_PCH_LP_GPIO_PCR_GPP_C_PAD_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_C_HOSTSW_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_C_GPI_IS, R_CNL_PCH_LP_GPIO_PCR_GPP_C_GPI_IE, R_CNL_PCH_LP_GPIO_PCR_GPP_C_GPI_GPE_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_C_GPI_GPE_EN, R_CNL_PCH_LP_GPIO_PCR_GPP_C_SMI_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_C_SMI_EN, R_CNL_PCH_LP_GPIO_PCR_GPP_C_NMI_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_C_NMI_EN, R_CNL_PCH_LP_GPIO_PCR_GPP_C_PADCFGLOCK,   R_CNL_PCH_LP_GPIO_PCR_GPP_C_PADCFGLOCKTX,   R_CNL_PCH_LP_GPIO_PCR_GPP_C_PADCFG_OFFSET, CNL_PCH_LP_GPIO_GPP_C_PAD_MAX, V_CNL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_C, V_CNL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_C}, //CNL PCH-LP GPP_C
  {CNL_PID_GPIOCOM1, R_CNL_PCH_LP_GPIO_PCR_GPP_D_PAD_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_D_HOSTSW_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_D_GPI_IS, R_CNL_PCH_LP_GPIO_PCR_GPP_D_GPI_IE, R_CNL_PCH_LP_GPIO_PCR_GPP_D_GPI_GPE_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_D_GPI_GPE_EN, R_CNL_PCH_LP_GPIO_PCR_GPP_D_SMI_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_D_SMI_EN, R_CNL_PCH_LP_GPIO_PCR_GPP_D_NMI_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_D_NMI_EN, R_CNL_PCH_LP_GPIO_PCR_GPP_D_PADCFGLOCK,   R_CNL_PCH_LP_GPIO_PCR_GPP_D_PADCFGLOCKTX,   R_CNL_PCH_LP_GPIO_PCR_GPP_D_PADCFG_OFFSET, CNL_PCH_LP_GPIO_GPP_D_PAD_MAX, V_CNL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_D, V_CNL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_D}, //CNL PCH-LP GPP_D
  {CNL_PID_GPIOCOM4, R_CNL_PCH_LP_GPIO_PCR_GPP_E_PAD_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_E_HOSTSW_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_E_GPI_IS, R_CNL_PCH_LP_GPIO_PCR_GPP_E_GPI_IE, R_CNL_PCH_LP_GPIO_PCR_GPP_E_GPI_GPE_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_E_GPI_GPE_EN, R_CNL_PCH_LP_GPIO_PCR_GPP_E_SMI_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_E_SMI_EN, R_CNL_PCH_LP_GPIO_PCR_GPP_E_NMI_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_E_NMI_EN, R_CNL_PCH_LP_GPIO_PCR_GPP_E_PADCFGLOCK,   R_CNL_PCH_LP_GPIO_PCR_GPP_E_PADCFGLOCKTX,   R_CNL_PCH_LP_GPIO_PCR_GPP_E_PADCFG_OFFSET, CNL_PCH_LP_GPIO_GPP_E_PAD_MAX, V_CNL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_E, V_CNL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_E}, //CNL PCH-LP GPP_E
  {CNL_PID_GPIOCOM1, R_CNL_PCH_LP_GPIO_PCR_GPP_F_PAD_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_F_HOSTSW_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_F_GPI_IS, R_CNL_PCH_LP_GPIO_PCR_GPP_F_GPI_IE, R_CNL_PCH_LP_GPIO_PCR_GPP_F_GPI_GPE_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_F_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_CNL_PCH_LP_GPIO_PCR_GPP_F_PADCFGLOCK,   R_CNL_PCH_LP_GPIO_PCR_GPP_F_PADCFGLOCKTX,   R_CNL_PCH_LP_GPIO_PCR_GPP_F_PADCFG_OFFSET, CNL_PCH_LP_GPIO_GPP_F_PAD_MAX, V_CNL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_F, V_CNL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_F}, //CNL PCH-LP GPP_F
  {CNL_PID_GPIOCOM0, R_CNL_PCH_LP_GPIO_PCR_GPP_G_PAD_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_G_HOSTSW_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_G_GPI_IS, R_CNL_PCH_LP_GPIO_PCR_GPP_G_GPI_IE, R_CNL_PCH_LP_GPIO_PCR_GPP_G_GPI_GPE_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_G_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_CNL_PCH_LP_GPIO_PCR_GPP_G_PADCFGLOCK,   R_CNL_PCH_LP_GPIO_PCR_GPP_G_PADCFGLOCKTX,   R_CNL_PCH_LP_GPIO_PCR_GPP_G_PADCFG_OFFSET, CNL_PCH_LP_GPIO_GPP_G_PAD_MAX, V_CNL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_G, V_CNL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_G}, //CNL PCH-LP GPP_G
  {CNL_PID_GPIOCOM1, R_CNL_PCH_LP_GPIO_PCR_GPP_H_PAD_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_H_HOSTSW_OWN, R_CNL_PCH_LP_GPIO_PCR_GPP_H_GPI_IS, R_CNL_PCH_LP_GPIO_PCR_GPP_H_GPI_IE, R_CNL_PCH_LP_GPIO_PCR_GPP_H_GPI_GPE_STS, R_CNL_PCH_LP_GPIO_PCR_GPP_H_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_CNL_PCH_LP_GPIO_PCR_GPP_H_PADCFGLOCK,   R_CNL_PCH_LP_GPIO_PCR_GPP_H_PADCFGLOCKTX,   R_CNL_PCH_LP_GPIO_PCR_GPP_H_PADCFG_OFFSET, CNL_PCH_LP_GPIO_GPP_H_PAD_MAX, V_CNL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_H, V_CNL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_H}, //CNL PCH-LP GPP_H
  {CNL_PID_GPIOCOM2, R_CNL_PCH_LP_GPIO_PCR_GPD_PAD_OWN,   R_CNL_PCH_LP_GPIO_PCR_GPD_HOSTSW_OWN,   R_CNL_PCH_LP_GPIO_PCR_GPD_GPI_IS,   R_CNL_PCH_LP_GPIO_PCR_GPD_GPI_IE,   R_CNL_PCH_LP_GPIO_PCR_GPD_GPI_GPE_STS,   R_CNL_PCH_LP_GPIO_PCR_GPD_GPI_GPE_EN,   NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_CNL_PCH_LP_GPIO_PCR_GPD_PADCFGLOCK,     R_CNL_PCH_LP_GPIO_PCR_GPD_PADCFGLOCKTX,     R_CNL_PCH_LP_GPIO_PCR_GPD_PADCFG_OFFSET,   CNL_PCH_LP_GPIO_GPD_PAD_MAX,   V_CNL_PCH_LP_PMC_PWRM_GPIO_CFG_GPD,   V_CNL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPD},   //CNL PCH-LP GPD
  {CNL_PID_GPIOCOM1, R_CNL_PCH_LP_GPIO_PCR_VGPIO_PAD_OWN, R_CNL_PCH_LP_GPIO_PCR_VGPIO_HOSTSW_OWN, R_CNL_PCH_LP_GPIO_PCR_VGPIO_GPI_IS, R_CNL_PCH_LP_GPIO_PCR_VGPIO_GPI_IE, R_CNL_PCH_LP_GPIO_PCR_VGPIO_GPI_GPE_STS, R_CNL_PCH_LP_GPIO_PCR_VGPIO_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_CNL_PCH_LP_GPIO_PCR_VGPIO_0_PADCFGLOCK, R_CNL_PCH_LP_GPIO_PCR_VGPIO_0_PADCFGLOCKTX, R_CNL_PCH_LP_GPIO_PCR_VGPIO_PADCFG_OFFSET, CNL_PCH_LP_GPIO_VGPIO_PAD_MAX, V_CNL_PCH_LP_PMC_PWRM_GPIO_CFG_VGPIO, V_CNL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_VGPIO}, //CNL PCH-LP vGPIO
  {CNL_PID_GPIOCOM0, R_CNL_PCH_LP_GPIO_PCR_SPI_PAD_OWN,   R_CNL_PCH_LP_GPIO_PCR_SPI_HOSTSW_OWN,   R_CNL_PCH_LP_GPIO_PCR_SPI_GPI_IS,   R_CNL_PCH_LP_GPIO_PCR_SPI_GPI_IE,   R_CNL_PCH_LP_GPIO_PCR_SPI_GPI_GPE_STS,   R_CNL_PCH_LP_GPIO_PCR_SPI_GPI_GPE_EN,   NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_CNL_PCH_LP_GPIO_PCR_SPI_PADCFGLOCK,     R_CNL_PCH_LP_GPIO_PCR_SPI_PADCFGLOCKTX,     R_CNL_PCH_LP_GPIO_PCR_SPI_PADCFG_OFFSET,   CNL_PCH_LP_GPIO_SPI_PAD_MAX,   V_CNL_PCH_LP_PMC_PWRM_GPIO_CFG_SPI,   V_CNL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_SPI},   //CNL PCH-LP SPI
  {CNL_PID_GPIOCOM3, R_CNL_PCH_LP_GPIO_PCR_AZA_PAD_OWN,   R_CNL_PCH_LP_GPIO_PCR_AZA_HOSTSW_OWN,   R_CNL_PCH_LP_GPIO_PCR_AZA_GPI_IS,   R_CNL_PCH_LP_GPIO_PCR_AZA_GPI_IE,   R_CNL_PCH_LP_GPIO_PCR_AZA_GPI_GPE_STS,   R_CNL_PCH_LP_GPIO_PCR_AZA_GPI_GPE_EN,   NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_CNL_PCH_LP_GPIO_PCR_AZA_PADCFGLOCK,     R_CNL_PCH_LP_GPIO_PCR_AZA_PADCFGLOCKTX,     R_CNL_PCH_LP_GPIO_PCR_AZA_PADCFG_OFFSET,   CNL_PCH_LP_GPIO_AZA_PAD_MAX,   V_CNL_PCH_LP_PMC_PWRM_GPIO_CFG_AZA,   V_CNL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_AZA},   //CNL PCH-LP AZA
  {CNL_PID_GPIOCOM3, R_CNL_PCH_LP_GPIO_PCR_CPU_PAD_OWN,   R_CNL_PCH_LP_GPIO_PCR_CPU_HOSTSW_OWN,   NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,                NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_CNL_PCH_LP_GPIO_PCR_CPU_PADCFGLOCK,     R_CNL_PCH_LP_GPIO_PCR_CPU_PADCFGLOCKTX,     R_CNL_PCH_LP_GPIO_PCR_CPU_PADCFG_OFFSET,   CNL_PCH_LP_GPIO_CPU_PAD_MAX,   NO_REGISTER_FOR_PROPERTY,     V_CNL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_CPU},   //CNL PCH-LP CPU
  {CNL_PID_GPIOCOM4, R_CNL_PCH_LP_GPIO_PCR_JTAG_PAD_OWN,  R_CNL_PCH_LP_GPIO_PCR_JTAG_HOSTSW_OWN,  NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,                NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_CNL_PCH_LP_GPIO_PCR_JTAG_PADCFGLOCK,    R_CNL_PCH_LP_GPIO_PCR_JTAG_PADCFGLOCKTX,    R_CNL_PCH_LP_GPIO_PCR_JTAG_PADCFG_OFFSET,  CNL_PCH_LP_GPIO_JTAG_PAD_MAX,  V_CNL_PCH_LP_PMC_PWRM_GPIO_CFG_JTAG,  V_CNL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_JTAG},  //CNL PCH-LP JTAG
  {CNL_PID_GPIOCOM4, R_CNL_PCH_LP_GPIO_PCR_HVMOS_PAD_OWN, R_CNL_PCH_LP_GPIO_PCR_HVMOS_HOSTSW_OWN, R_CNL_PCH_LP_GPIO_PCR_HVMOS_GPI_IS, R_CNL_PCH_LP_GPIO_PCR_HVMOS_GPI_IE, R_CNL_PCH_LP_GPIO_PCR_HVMOS_GPI_GPE_STS, R_CNL_PCH_LP_GPIO_PCR_HVMOS_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_CNL_PCH_LP_GPIO_PCR_HVMOS_PADCFGLOCK,   R_CNL_PCH_LP_GPIO_PCR_HVMOS_PADCFGLOCKTX,   R_CNL_PCH_LP_GPIO_PCR_HVMOS_PADCFG_OFFSET, CNL_PCH_LP_GPIO_HVMOS_PAD_MAX, NO_REGISTER_FOR_PROPERTY,     V_CNL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_HVMOS}  //CNL PCH-LP HVMOS
};

GLOBAL_REMOVE_IF_UNREFERENCED GPIO_GROUP_INFO mPchHGpioGroupInfo[] = {
  {CNL_PID_GPIOCOM0, R_CNL_PCH_H_GPIO_PCR_GPP_A_PAD_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_A_HOSTSW_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_A_GPI_IS, R_CNL_PCH_H_GPIO_PCR_GPP_A_GPI_IE, R_CNL_PCH_H_GPIO_PCR_GPP_A_GPI_GPE_STS, R_CNL_PCH_H_GPIO_PCR_GPP_A_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_CNL_PCH_H_GPIO_PCR_GPP_A_PADCFGLOCK,   R_CNL_PCH_H_GPIO_PCR_GPP_A_PADCFGLOCKTX,   R_CNL_PCH_H_GPIO_PCR_GPP_A_PADCFG_OFFSET, CNL_PCH_H_GPIO_GPP_A_PAD_MAX, V_CNL_PCH_H_PMC_PWRM_GPIO_CFG_GPP_A, V_CNL_PCH_H_GPIO_PCR_MISCCFG_GPE0_GPP_A}, //CNL PCH-H GPP_A
  {CNL_PID_GPIOCOM0, R_CNL_PCH_H_GPIO_PCR_GPP_B_PAD_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_B_HOSTSW_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_B_GPI_IS, R_CNL_PCH_H_GPIO_PCR_GPP_B_GPI_IE, R_CNL_PCH_H_GPIO_PCR_GPP_B_GPI_GPE_STS, R_CNL_PCH_H_GPIO_PCR_GPP_B_GPI_GPE_EN, R_CNL_PCH_H_GPIO_PCR_GPP_B_SMI_STS, R_CNL_PCH_H_GPIO_PCR_GPP_B_SMI_EN, R_CNL_PCH_H_GPIO_PCR_GPP_B_NMI_STS, R_CNL_PCH_H_GPIO_PCR_GPP_B_NMI_EN, R_CNL_PCH_H_GPIO_PCR_GPP_B_PADCFGLOCK,   R_CNL_PCH_H_GPIO_PCR_GPP_B_PADCFGLOCKTX,   R_CNL_PCH_H_GPIO_PCR_GPP_B_PADCFG_OFFSET, CNL_PCH_H_GPIO_GPP_B_PAD_MAX, V_CNL_PCH_H_PMC_PWRM_GPIO_CFG_GPP_B, V_CNL_PCH_H_GPIO_PCR_MISCCFG_GPE0_GPP_B}, //CNL PCH-H GPP_B
  {CNL_PID_GPIOCOM1, R_CNL_PCH_H_GPIO_PCR_GPP_C_PAD_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_C_HOSTSW_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_C_GPI_IS, R_CNL_PCH_H_GPIO_PCR_GPP_C_GPI_IE, R_CNL_PCH_H_GPIO_PCR_GPP_C_GPI_GPE_STS, R_CNL_PCH_H_GPIO_PCR_GPP_C_GPI_GPE_EN, R_CNL_PCH_H_GPIO_PCR_GPP_C_SMI_STS, R_CNL_PCH_H_GPIO_PCR_GPP_C_SMI_EN, R_CNL_PCH_H_GPIO_PCR_GPP_C_NMI_STS, R_CNL_PCH_H_GPIO_PCR_GPP_C_NMI_EN, R_CNL_PCH_H_GPIO_PCR_GPP_C_PADCFGLOCK,   R_CNL_PCH_H_GPIO_PCR_GPP_C_PADCFGLOCKTX,   R_CNL_PCH_H_GPIO_PCR_GPP_C_PADCFG_OFFSET, CNL_PCH_H_GPIO_GPP_C_PAD_MAX, V_CNL_PCH_H_PMC_PWRM_GPIO_CFG_GPP_C, V_CNL_PCH_H_GPIO_PCR_MISCCFG_GPE0_GPP_C}, //CNL PCH-H GPP_C
  {CNL_PID_GPIOCOM1, R_CNL_PCH_H_GPIO_PCR_GPP_D_PAD_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_D_HOSTSW_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_D_GPI_IS, R_CNL_PCH_H_GPIO_PCR_GPP_D_GPI_IE, R_CNL_PCH_H_GPIO_PCR_GPP_D_GPI_GPE_STS, R_CNL_PCH_H_GPIO_PCR_GPP_D_GPI_GPE_EN, R_CNL_PCH_H_GPIO_PCR_GPP_D_SMI_STS, R_CNL_PCH_H_GPIO_PCR_GPP_D_SMI_EN, R_CNL_PCH_H_GPIO_PCR_GPP_D_NMI_STS, R_CNL_PCH_H_GPIO_PCR_GPP_D_NMI_EN, R_CNL_PCH_H_GPIO_PCR_GPP_D_PADCFGLOCK,   R_CNL_PCH_H_GPIO_PCR_GPP_D_PADCFGLOCKTX,   R_CNL_PCH_H_GPIO_PCR_GPP_D_PADCFG_OFFSET, CNL_PCH_H_GPIO_GPP_D_PAD_MAX, V_CNL_PCH_H_PMC_PWRM_GPIO_CFG_GPP_D, V_CNL_PCH_H_GPIO_PCR_MISCCFG_GPE0_GPP_D}, //CNL PCH-H GPP_D
  {CNL_PID_GPIOCOM3, R_CNL_PCH_H_GPIO_PCR_GPP_E_PAD_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_E_HOSTSW_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_E_GPI_IS, R_CNL_PCH_H_GPIO_PCR_GPP_E_GPI_IE, R_CNL_PCH_H_GPIO_PCR_GPP_E_GPI_GPE_STS, R_CNL_PCH_H_GPIO_PCR_GPP_E_GPI_GPE_EN, R_CNL_PCH_H_GPIO_PCR_GPP_E_SMI_STS, R_CNL_PCH_H_GPIO_PCR_GPP_E_SMI_EN, R_CNL_PCH_H_GPIO_PCR_GPP_E_NMI_STS, R_CNL_PCH_H_GPIO_PCR_GPP_E_NMI_EN, R_CNL_PCH_H_GPIO_PCR_GPP_E_PADCFGLOCK,   R_CNL_PCH_H_GPIO_PCR_GPP_E_PADCFGLOCKTX,   R_CNL_PCH_H_GPIO_PCR_GPP_E_PADCFG_OFFSET, CNL_PCH_H_GPIO_GPP_E_PAD_MAX, V_CNL_PCH_H_PMC_PWRM_GPIO_CFG_GPP_E, V_CNL_PCH_H_GPIO_PCR_MISCCFG_GPE0_GPP_E}, //CNL PCH-H GPP_E
  {CNL_PID_GPIOCOM3, R_CNL_PCH_H_GPIO_PCR_GPP_F_PAD_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_F_HOSTSW_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_F_GPI_IS, R_CNL_PCH_H_GPIO_PCR_GPP_F_GPI_IE, R_CNL_PCH_H_GPIO_PCR_GPP_F_GPI_GPE_STS, R_CNL_PCH_H_GPIO_PCR_GPP_F_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_CNL_PCH_H_GPIO_PCR_GPP_F_PADCFGLOCK,   R_CNL_PCH_H_GPIO_PCR_GPP_F_PADCFGLOCKTX,   R_CNL_PCH_H_GPIO_PCR_GPP_F_PADCFG_OFFSET, CNL_PCH_H_GPIO_GPP_F_PAD_MAX, V_CNL_PCH_H_PMC_PWRM_GPIO_CFG_GPP_F, V_CNL_PCH_H_GPIO_PCR_MISCCFG_GPE0_GPP_F}, //CNL PCH-H GPP_F
  {CNL_PID_GPIOCOM1, R_CNL_PCH_H_GPIO_PCR_GPP_G_PAD_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_G_HOSTSW_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_G_GPI_IS, R_CNL_PCH_H_GPIO_PCR_GPP_G_GPI_IE, R_CNL_PCH_H_GPIO_PCR_GPP_G_GPI_GPE_STS, R_CNL_PCH_H_GPIO_PCR_GPP_G_GPI_GPE_EN, R_CNL_PCH_H_GPIO_PCR_GPP_G_SMI_STS, R_CNL_PCH_H_GPIO_PCR_GPP_G_SMI_EN, NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_CNL_PCH_H_GPIO_PCR_GPP_G_PADCFGLOCK,   R_CNL_PCH_H_GPIO_PCR_GPP_G_PADCFGLOCKTX,   R_CNL_PCH_H_GPIO_PCR_GPP_G_PADCFG_OFFSET, CNL_PCH_H_GPIO_GPP_G_PAD_MAX, V_CNL_PCH_H_PMC_PWRM_GPIO_CFG_GPP_G, V_CNL_PCH_H_GPIO_PCR_MISCCFG_GPE0_GPP_G}, //CNL PCH-H GPP_G
  {CNL_PID_GPIOCOM3, R_CNL_PCH_H_GPIO_PCR_GPP_H_PAD_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_H_HOSTSW_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_H_GPI_IS, R_CNL_PCH_H_GPIO_PCR_GPP_H_GPI_IE, R_CNL_PCH_H_GPIO_PCR_GPP_H_GPI_GPE_STS, R_CNL_PCH_H_GPIO_PCR_GPP_H_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_CNL_PCH_H_GPIO_PCR_GPP_H_PADCFGLOCK,   R_CNL_PCH_H_GPIO_PCR_GPP_H_PADCFGLOCKTX,   R_CNL_PCH_H_GPIO_PCR_GPP_H_PADCFG_OFFSET, CNL_PCH_H_GPIO_GPP_H_PAD_MAX, V_CNL_PCH_H_PMC_PWRM_GPIO_CFG_GPP_H, V_CNL_PCH_H_GPIO_PCR_MISCCFG_GPE0_GPP_H}, //CNL PCH-H GPP_H
  {CNL_PID_GPIOCOM4, R_CNL_PCH_H_GPIO_PCR_GPP_I_PAD_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_I_HOSTSW_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_I_GPI_IS, R_CNL_PCH_H_GPIO_PCR_GPP_I_GPI_IE, R_CNL_PCH_H_GPIO_PCR_GPP_I_GPI_GPE_STS, R_CNL_PCH_H_GPIO_PCR_GPP_I_GPI_GPE_EN, R_CNL_PCH_H_GPIO_PCR_GPP_I_SMI_STS, R_CNL_PCH_H_GPIO_PCR_GPP_I_SMI_EN, R_CNL_PCH_H_GPIO_PCR_GPP_I_NMI_STS, R_CNL_PCH_H_GPIO_PCR_GPP_I_NMI_EN, R_CNL_PCH_H_GPIO_PCR_GPP_I_PADCFGLOCK,   R_CNL_PCH_H_GPIO_PCR_GPP_I_PADCFGLOCKTX,   R_CNL_PCH_H_GPIO_PCR_GPP_I_PADCFG_OFFSET, CNL_PCH_H_GPIO_GPP_I_PAD_MAX, V_CNL_PCH_H_PMC_PWRM_GPIO_CFG_GPP_I, V_CNL_PCH_H_GPIO_PCR_MISCCFG_GPE0_GPP_I}, //CNL PCH-H GPP_I
  {CNL_PID_GPIOCOM4, R_CNL_PCH_H_GPIO_PCR_GPP_J_PAD_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_J_HOSTSW_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_J_GPI_IS, R_CNL_PCH_H_GPIO_PCR_GPP_J_GPI_IE, R_CNL_PCH_H_GPIO_PCR_GPP_J_GPI_GPE_STS, R_CNL_PCH_H_GPIO_PCR_GPP_J_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_CNL_PCH_H_GPIO_PCR_GPP_J_PADCFGLOCK,   R_CNL_PCH_H_GPIO_PCR_GPP_J_PADCFGLOCKTX,   R_CNL_PCH_H_GPIO_PCR_GPP_J_PADCFG_OFFSET, CNL_PCH_H_GPIO_GPP_J_PAD_MAX, V_CNL_PCH_H_PMC_PWRM_GPIO_CFG_GPP_J, V_CNL_PCH_H_GPIO_PCR_MISCCFG_GPE0_GPP_J}, //CNL PCH-H GPP_J
  {CNL_PID_GPIOCOM3, R_CNL_PCH_H_GPIO_PCR_GPP_K_PAD_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_K_HOSTSW_OWN, R_CNL_PCH_H_GPIO_PCR_GPP_K_GPI_IS, R_CNL_PCH_H_GPIO_PCR_GPP_K_GPI_IE, R_CNL_PCH_H_GPIO_PCR_GPP_K_GPI_GPE_STS, R_CNL_PCH_H_GPIO_PCR_GPP_K_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_CNL_PCH_H_GPIO_PCR_GPP_K_PADCFGLOCK,   R_CNL_PCH_H_GPIO_PCR_GPP_K_PADCFGLOCKTX,   R_CNL_PCH_H_GPIO_PCR_GPP_K_PADCFG_OFFSET, CNL_PCH_H_GPIO_GPP_K_PAD_MAX, V_CNL_PCH_H_PMC_PWRM_GPIO_CFG_GPP_K, V_CNL_PCH_H_GPIO_PCR_MISCCFG_GPE0_GPP_K}, //CNL PCH-H GPP_K
  {CNL_PID_GPIOCOM2, R_CNL_PCH_H_GPIO_PCR_GPD_PAD_OWN,   R_CNL_PCH_H_GPIO_PCR_GPD_HOSTSW_OWN,   R_CNL_PCH_H_GPIO_PCR_GPD_GPI_IS,   R_CNL_PCH_H_GPIO_PCR_GPD_GPI_IE,   R_CNL_PCH_H_GPIO_PCR_GPD_GPI_GPE_STS,   R_CNL_PCH_H_GPIO_PCR_GPD_GPI_GPE_EN,   NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_CNL_PCH_H_GPIO_PCR_GPD_PADCFGLOCK,     R_CNL_PCH_H_GPIO_PCR_GPD_PADCFGLOCKTX,     R_CNL_PCH_H_GPIO_PCR_GPD_PADCFG_OFFSET,   CNL_PCH_H_GPIO_GPD_PAD_MAX,   V_CNL_PCH_H_PMC_PWRM_GPIO_CFG_GPD,   V_CNL_PCH_H_GPIO_PCR_MISCCFG_GPE0_GPD},   //CNL PCH-H GPD
  {CNL_PID_GPIOCOM1, R_CNL_PCH_H_GPIO_PCR_VGPIO_PAD_OWN, R_CNL_PCH_H_GPIO_PCR_VGPIO_HOSTSW_OWN, R_CNL_PCH_H_GPIO_PCR_VGPIO_GPI_IS, R_CNL_PCH_H_GPIO_PCR_VGPIO_GPI_IE, R_CNL_PCH_H_GPIO_PCR_VGPIO_GPI_GPE_STS, R_CNL_PCH_H_GPIO_PCR_VGPIO_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_CNL_PCH_H_GPIO_PCR_VGPIO_0_PADCFGLOCK, R_CNL_PCH_H_GPIO_PCR_VGPIO_0_PADCFGLOCKTX, R_CNL_PCH_H_GPIO_PCR_VGPIO_PADCFG_OFFSET, CNL_PCH_H_GPIO_VGPIO_PAD_MAX, V_CNL_PCH_H_PMC_PWRM_GPIO_CFG_VGPIO, V_CNL_PCH_H_GPIO_PCR_MISCCFG_GPE0_VGPIO}, //CNL PCH-H vGPIO
  {CNL_PID_GPIOCOM3, R_CNL_PCH_H_GPIO_PCR_SPI_PAD_OWN,   R_CNL_PCH_H_GPIO_PCR_SPI_HOSTSW_OWN,   NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_CNL_PCH_H_GPIO_PCR_SPI_PADCFGLOCK,     R_CNL_PCH_H_GPIO_PCR_SPI_PADCFGLOCKTX,     R_CNL_PCH_H_GPIO_PCR_SPI_PADCFG_OFFSET,   CNL_PCH_H_GPIO_SPI_PAD_MAX,   NO_REGISTER_FOR_PROPERTY,    NO_REGISTER_FOR_PROPERTY}, //CNL PCH-H SPI
  {CNL_PID_GPIOCOM1, R_CNL_PCH_H_GPIO_PCR_AZA_PAD_OWN,   R_CNL_PCH_H_GPIO_PCR_AZA_HOSTSW_OWN,   NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_CNL_PCH_H_GPIO_PCR_AZA_PADCFGLOCK,     R_CNL_PCH_H_GPIO_PCR_AZA_PADCFGLOCKTX,     R_CNL_PCH_H_GPIO_PCR_AZA_PADCFG_OFFSET,   CNL_PCH_H_GPIO_AZA_PAD_MAX,   NO_REGISTER_FOR_PROPERTY,    NO_REGISTER_FOR_PROPERTY}, //CNL PCH-H AZA
  {CNL_PID_GPIOCOM4, R_CNL_PCH_H_GPIO_PCR_CPU_PAD_OWN,   R_CNL_PCH_H_GPIO_PCR_CPU_HOSTSW_OWN,   NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_CNL_PCH_H_GPIO_PCR_CPU_PADCFGLOCK,     R_CNL_PCH_H_GPIO_PCR_CPU_PADCFGLOCKTX,     R_CNL_PCH_H_GPIO_PCR_CPU_PADCFG_OFFSET,   CNL_PCH_H_GPIO_CPU_PAD_MAX,   NO_REGISTER_FOR_PROPERTY,    NO_REGISTER_FOR_PROPERTY}, //CNL PCH-H CPU
  {CNL_PID_GPIOCOM4, R_CNL_PCH_H_GPIO_PCR_JTAG_PAD_OWN,  R_CNL_PCH_H_GPIO_PCR_JTAG_HOSTSW_OWN,  NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_CNL_PCH_H_GPIO_PCR_JTAG_PADCFGLOCK,    R_CNL_PCH_H_GPIO_PCR_JTAG_PADCFGLOCKTX,    R_CNL_PCH_H_GPIO_PCR_JTAG_PADCFG_OFFSET,  CNL_PCH_H_GPIO_JTAG_PAD_MAX,  NO_REGISTER_FOR_PROPERTY,    NO_REGISTER_FOR_PROPERTY}  //CNL PCH-H JTAG
};

// SerialIo
GLOBAL_REMOVE_IF_UNREFERENCED GPIO_PAD_NATIVE_FUNCTION mPchLpUartGpio [PCH_SERIALIO_MAX_UART_CONTROLLERS + 1][PCH_SERIAL_IO_PINS_PER_UART_CONTROLLER]=
{
  { // UART0
    {GPIO_CNL_LP_GPP_C8,  GpioPadModeNative1},
    {GPIO_CNL_LP_GPP_C9,  GpioPadModeNative1},
    {GPIO_CNL_LP_GPP_C10, GpioPadModeNative1},
    {GPIO_CNL_LP_GPP_C11, GpioPadModeNative1}
  },
  { // UART1
    {GPIO_CNL_LP_GPP_C12, GpioPadModeNative1},
    {GPIO_CNL_LP_GPP_C13, GpioPadModeNative1},
    {GPIO_CNL_LP_GPP_C14, GpioPadModeNative1},
    {GPIO_CNL_LP_GPP_C15, GpioPadModeNative1}
  },
  { // UART2
    {GPIO_CNL_LP_GPP_C20, GpioPadModeNative1},
    {GPIO_CNL_LP_GPP_C21, GpioPadModeNative1},
    {GPIO_CNL_LP_GPP_C22, GpioPadModeNative1},
    {GPIO_CNL_LP_GPP_C23, GpioPadModeNative1},
  },
  { // UART0 (2nd pin set)
    {GPIO_CNL_LP_GPP_F5, GpioPadModeNative2},
    {GPIO_CNL_LP_GPP_F6, GpioPadModeNative2},
    {GPIO_CNL_LP_GPP_F4, GpioPadModeNative2},
    {GPIO_CNL_LP_GPP_F7, GpioPadModeNative2}
  }
};

GLOBAL_REMOVE_IF_UNREFERENCED GPIO_PAD_NATIVE_FUNCTION mPchHUartGpio [PCH_SERIALIO_MAX_UART_CONTROLLERS + 1][PCH_SERIAL_IO_PINS_PER_UART_CONTROLLER]=
{
  { // UART0
    {GPIO_CNL_H_GPP_C8,  GpioPadModeNative1},
    {GPIO_CNL_H_GPP_C9,  GpioPadModeNative1},
    {GPIO_CNL_H_GPP_C10, GpioPadModeNative1},
    {GPIO_CNL_H_GPP_C11, GpioPadModeNative1}
  },
  { // UART1
    {GPIO_CNL_H_GPP_C12, GpioPadModeNative1},
    {GPIO_CNL_H_GPP_C13, GpioPadModeNative1},
    {GPIO_CNL_H_GPP_C14, GpioPadModeNative1},
    {GPIO_CNL_H_GPP_C15, GpioPadModeNative1}
  },
  { // UART2
    {GPIO_CNL_H_GPP_C20, GpioPadModeNative1},
    {GPIO_CNL_H_GPP_C21, GpioPadModeNative1},
    {GPIO_CNL_H_GPP_C22, GpioPadModeNative1},
    {GPIO_CNL_H_GPP_C23, GpioPadModeNative1}
  },
  { // UART0 (2nd pin set)
    {GPIO_CNL_H_GPP_J5, GpioPadModeNative2},
    {GPIO_CNL_H_GPP_J6, GpioPadModeNative2},
    {GPIO_CNL_H_GPP_J4, GpioPadModeNative2},
    {GPIO_CNL_H_GPP_J7, GpioPadModeNative2}
  }
};

/**
  This procedure will set GPIO mode

  @param[in]  GpioPad             GPIO pad
  @param[out] PadModeValue        GPIO pad mode value

  @retval EFI_SUCCESS             The function completed successfully
  @retval EFI_INVALID_PARAMETER   Invalid group or pad number
**/
EFI_STATUS
SetGpioPadMode (
  IN GPIO_PAD                GpioPad,
  IN GPIO_PAD_MODE           PadModeValue
  )
{
  UINT32               PadCfgOrMask;

/*  if (!GpioIsPadValid (GpioPad)) {
    return EFI_INVALID_PARAMETER;
  }

  if (!GpioIsPadHostOwned (GpioPad)) {
    return EFI_UNSUPPORTED;
  }*/

  if (PadModeValue != (GPIO_PAD_MODE)GpioHardwareDefault) {

    PadCfgOrMask = (((PadModeValue & B_GPIO_PAD_MODE_MASK) >> (N_GPIO_PAD_MODE_BIT_POS + 1)) << N_GPIO_PCR_PAD_MODE);

    GpioWritePadCfgReg (
      GpioPad,
      0,
      (UINT32)~B_GPIO_PCR_PAD_MODE,
      PadCfgOrMask
      );
  }

  return EFI_SUCCESS;
}

/**
  This procedure will retrieve address and length of GPIO info table

  @param[out]  GpioGroupInfoTableLength   Length of GPIO group table

  @retval Pointer to GPIO group table

**/
CONST GPIO_GROUP_INFO*
GpioGetGroupInfoTable (
  OUT UINTN               *GpioGroupInfoTableLength
  )
{
  if (MrcGetPchSeries () == PchSeriesLp) {
    *GpioGroupInfoTableLength = sizeof (mPchLpGpioGroupInfo) / sizeof (GPIO_GROUP_INFO);
    return mPchLpGpioGroupInfo;
  } else {
    *GpioGroupInfoTableLength = sizeof (mPchHGpioGroupInfo) / sizeof (GPIO_GROUP_INFO);
    return mPchHGpioGroupInfo;
  }
}

/**
  This procedure will get group index (0 based)

  @param[in] GpioPad          Gpio Pad

  @retval Value               Group Index
**/
UINT32
GpioGetGroupIndexFromGpioPad (
  IN GPIO_PAD        GpioPad
  )
{
  return (UINT32) GPIO_GET_GROUP_INDEX_FROM_PAD (GpioPad);
}


/**
  This procedure will get pad number (0 based) from Gpio Pad

  @param[in] GpioPad          Gpio Pad

  @retval Value               Pad Number
**/
UINT32
GpioGetPadNumberFromGpioPad (
  IN GPIO_PAD        GpioPad
  )
{
  return (UINT32) GPIO_GET_PAD_NUMBER (GpioPad);
}

/**
  This function sets SerialIo UART controller pins into native mode

  @param[in]  SerialIoUartControllerNumber   UART controller
  @param[in]  HardwareFlowControl            Hardware Flow control
  @param[in]  PinMuxing                      UART controller pin muxing
                                             CNL: 0:defaut pins, 1:pins muxed with CNV_BRI/RGI

  @retval Status
**/
EFI_STATUS
GpioEnableSerialIoUart (
  IN  UINT32            SerialIoUartControllerNumber,
  IN  BOOLEAN           HardwareFlowControl,
  IN  UINT32            PinMuxing
  )
{
  //EFI_STATUS               Status;
  UINTN                    Index;
  UINTN                    PinsUsed;
  GPIO_PAD_NATIVE_FUNCTION *UartGpio;
  UINTN                    UartGpioIndex;

//  ASSERT (SerialIoUartControllerNumber < PCH_SERIALIO_MAX_UART_CONTROLLERS);

  UartGpioIndex = SerialIoUartControllerNumber;


  if (MrcGetPchSeries () == PchSeriesLp) {
    UartGpio = mPchLpUartGpio[UartGpioIndex];
  } else {
    UartGpio = mPchHUartGpio[UartGpioIndex];
  }

  PinsUsed = PCH_SERIAL_IO_PINS_PER_UART_CONTROLLER;
  for (Index = 0; Index < PinsUsed; Index++) {
    SetGpioPadMode (UartGpio[Index].Pad, UartGpio[Index].Mode);
    //GpioSetInputInversion (UartGpio[Index].Pad, 0);
  }

  return EFI_SUCCESS;
}
