/** @file
  Defines Platform BoardIds

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2011 - 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _PLATFORM_BOARD_ID_H_
#define _PLATFORM_BOARD_ID_H_

#define FlavorUnknown                       0x0
#define FlavorMobile                        0x1
#define FlavorDesktop                       0x2
#define FlavorWorkstation                   0x3
#define FlavorUpServer                      0x4
#define FlavorEmbedded                      0x5
#define FlavorPlatformMax                   0x6

#define TypeUnknown                         0x0
#define TypeTrad                            0x1
#define TypeUlt                             0x2

//
// CometLake Board Id 0x00 - 0xF
//
//#define BoardIdCometLakeX0Lpddr3            0x00 // In order to adopt the SkuId, BoardID 0 should be reserved
#define BoardIdCometLakeULpddr3Rvp            0x01
//#define BoardIdCometLakeULpddr3Rvp          0x02 // Reserved
#define   BomIdCometLakeULpddr3Erb            0x00
#define   BomIdCometLakeULpddr3Crb            0x01
#define BoardIdCometLakeUDdr4HrRvp            0x03
//#define BoardIdCometLakeUDdr4HrRvp          0x04 // Reserved
#define   BomIdCometLakeUDdr4HrErb            0x00
#define   BomIdCometLakeUDdr4HrCrb            0x01
#define   BomIdCometLakeUDdr4HrPpv            0x02
#define BoardIdCometLakeUDdr4HrAep            0x05
#define BoardIdCometLakeUDdr4SrRvp            0x06
//#define BoardIdCometLakeUDdr4SrRvp          0x07 // Reserved
#define   BomIdCometLakeUDdr4SrErb            0x00
//#define BoardIdCometLakeLpdimmDoe           0x08 // Reserved
//#define BoardIdCometLakeIdv1                0x09 // Reserved
#define BoardIdCometLakeULpddr4xRvp           0x0A
#define   BomIdCometLakeULpDdr4SrErb          0x00
#define   BomIdCometLakeULpDdr4SrCrb          0x01
#define   BomIdCometLakeULpDdr4Sr1R           0x04
//#define BoardIdCometLakeULpddr4X32Rvp       0x0B // Reserved
//#define BoardIdCometLakeYLpddr4X64Erb       0x0C // Reserved
//#define BoardIdCometLakeYLpddr4X64Rvp       0x0D // Reserved
#define BoardIdCometLakeSUdimm                0x11
#define   BomIdCometLakeSUdimmErb             0x00
#define   BomIdCometLakeSUdimmCrb             0x01
#define BoardIdCometLakeSSodimm               0x13
#define   BomIdCometLakeSSodimmErb            0x00
#define   BomIdCometLakeSSodimmCrb            0x01
#define BoardIdCometLakeVUdimm                0x15 // CML-S + KBP-H (derivative)
#define   BomIdCometLakeVUdimmErb             0x00
#define   BomIdCometLakeVUdimmCrb             0x01
#define BoardIdCometLakeHDdr4                 0x1A // CML-H RVP4
#define   BomIdCometLakeHDdr4Erb              0x00
#define   BomIdCometLakeHDdr4Crb              0x01
#define BoardIdCometLakeHDdr4DualTbt          0x1B // CML-H RVP5 Dual Tbt
#define   BomIdCometLakeHDdr4DualTbtErb       0x00
#define   BomIdCometLakeHDdr4DualTbtCrb       0x01


// CoffeeLake Board Id's 0x10 - 0x1F
#define BoardIdCoffeeLakeULpddr3CpuBrd      0x10 // This is KC PnP skew and has two board's one for CPU and one for Companion Card
#define BoardIdCoffeeLakeUDdr4              0x12 // PI/merged power plane board
#define BoardIdWhiskeyLakeErb               0x14 // WhiskeyLake ERB
#define BoardIdWhiskeyLakeAep               0x115 // Virtual Board id for WhiskeyLake AEP
#define BoardIdCoffeeLakeHDdr4              0x16
#define BoardIdCoffeeLakeHDdr4mDvpCfgC      0x117
#define BoardIdCoffeeLakeHDdr4mDvpCfgD      0x217
#define BoardIdCoffeeLakeSUdimm             0x18 // PI/merged power plane board
#define BoardIdCoffeeLakeSSodimm            0x19 // PnP board
//0x1B reserved for S
//0x1C reserved for Generic use
//0x1D reserved for Generic use
//0x1E reserved for Generic use
//0x1F reserved for Generic use

//  Skylake Board Id's
/*
#define BoardIdSkylakeSds                   0x20
#define BoardIdSkylakePantherMtn            0x21
#define BoardIdSkylakePhabletPoc            0x23

#define BoardIdSkylakeAioRvp10Erb           0x40
#define BoardIdSkylakeAioRvp9Crb            0x41
#define BoardIdSkylakeDtRvp8Crb             0x42
#define BoardIdSkylakeAioRvp10Crb           0x43
#define BoardIdSkylakeHaloDdr4Rvp11         0x44
#define BoardIdSkylakeHaloDdr4Rvp11Ppv      0x45
#define BoardIdSkylakeAioRvp10CrbPpv        0x46
#define BoardIdSkylakeHaloLpddr3Rvp16       0x48
#define BoardIdSkylakeSlpfPpv               0x49
#define BoardIdSkylakeSdlBrk                0x50
*/


//60-6F reserved for KBL RVPs
#define BoardIdKabyLakeYLpddr3Rvp3          0x60
#define BoardIdKabylakeGrizzlyMtn           0x61
#define BoardIdKabylakeUDdr3lRvp7           0x64
#define BoardIdKabyLakeSDdr4UdimmEvErb      0x66
#define BoardIdKabyLakeSDdr4UdimmEvCrb      0x67
#define BoardIdKabyLakeOc                   0x68
#define BoardIdKabyLakeSDdr4UdimmCrb        0x69
#define BoardIdKabylakeSUdimmCpv            0x6A
#define BoardIdBasinFallsEv                 0x6B
#define BoardIdBasinFallsCrb                0x6C
#define BoardIdBasinFallsPpv                0x6D
#define BoardIdBasinFallsRsvd               0x6E

#define BoardIdZumbaBeachServerEv           0x73
#define BoardIdZumbaBeachServerCrb          0x74

#define BoardIdMobileMax                    0x3f
#define BoardIdDesktopMax                   0x4f
#define BoardIdTradMobileMax                0x1f

#define BoardIdUnknown1                     0xffff
#define BoardIdPlatformMax                  0xff
#define BOARD_ID_MASK_5BIT                  0x1f
#define BOARD_ID_MASK_8BIT                  0xff
#define FAB_ID_MASK                         0x7
#define BOM_ID_MASK                         0x7
#define GENERATION_MASK                     0x100

#endif
