/** @file
Defines Platform BoardIds
This file is a local MRC copy of Intel\RocketLakeBoardPkg\Include\PlatformBoardId.h

@copyright
  INTEL CONFIDENTIAL
  Copyright 2017 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _PLATFORM_BOARD_ID_H_
#define _PLATFORM_BOARD_ID_H_

#define FlavorUnknown                       0x0
#define FlavorMobile                        0x1
#define FlavorDesktop                       0x2
#define FlavorWorkstation                   0x3
#define FlavorUpServer                      0x4
#define FlavorEmbedded                      0x5
#define FlavorPlatformMax                   0x6

#define TypeUnknown                         0x0
#define TypeTrad                            0x1
#define TypeUltUlx                          0x2

// RocketLake Sku IDs
#define SkuIdRklU                           0x1
#define SkuIdRklS                           0x2

// BoardId Reserved for PCD Default SkuId usage
#define BoardIdReserved                     0x00

//
// RocketLake U Board Id's
//
#define BoardIdRklUDdr4                     0x09
#define   BomIdRklUDdr4Main                 0x00
#define   BomIdRklUDdr4Ppv                  0x07
#define BoardIdRklULp4Type4                 0x0E
#define   BomIdRklULp4Type4Main             0x00
#define   BomIdRklULp4Type4Ppv              0x07

// RocketLake ERB Board Id's
#define BoardIdRklUDdr4Erb                  0x10  // RKL U DDR4 ERB (ICL U42 with interposer)
#define BoardIdRklULpddr4Erb                0x0D  // RKL U LPDDR4X ERB (CML-S CPU and CNP-H with interposer)

#define BoardIdRklSUdimm4Erb                0x20  // RKL S UDIMM 4L ERB
#define BoardIdRklSUdimm4Rvp                0x21  // RKL S UDIMM 4L RVP
#define   BomIdRklSUdimm4Crb                0x00
#define   BomIdRklSUdimm4Cpv                0x06

#define BoardIdRklSUdimm6Erb                0x24  // RKL S UDIMM 6L ERB
#define BoardIdRklSUdimm6Rvp                0x25  // RKL S UDIMM 6L RVP
#define   BomIdRklSUdimm6Crb                0x00
#define   BomIdRklSUdimm6Ppv                0x07

#define BoardIdRklSSodimmErb                0x28  // RKL S SODIMM ERB
#define BoardIdRklSSodimmRvp                0x29  // RKL S SODIMM RVP

#define BoardIdRklSPciex8x4x4Rvp            0x2A  // RKL S UDIMM 4L RVP with Pcie x8x4x4 trifurcation

#define BoardIdUnknown1                     0xffff

// The following definitions should match MrcBoardType enum in Intel\IceLakeSiliconPkg\SystemAgent\MemoryInit\Include\MrcInterface.h
#define MrcBoardTypeMobile                0  // Mobile: Y/U/YN/UN (default)
#define MrcBoardTypeMobileLp4Limit3200    1  // Mobile: Y/U/YN/UN, with LP4/x limited to 3200
#define MrcBoardTypeDesktop               2  // Desktop: DT/Halo with DDR4 2DPC
#define MrcBoardTypeUpServer              3  // UP Server

#endif // _PLATFORM_BOARD_ID_H_
