/** @file
  Source code file for Compatibility Support PPI Consumer Library

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification
**/
#include <Library/DebugLib.h>
#include <Library/MemoryAllocationLib.h>
#include <Library/PeiServicesLib.h>
#include <CompatibilitySupportProdLib.h>

/**
  Consumes the MRC functions PPI
  This call support X-compatibility module to locate Compatibility Memory Init PPI and run.

  @retval    EFI_SUCCESS         The function was successfully registered.
  @retval    EFI_NOT_FOUND       No compatibile MRC is found.
**/
EFI_STATUS
EFIAPI
InstallMrcCallback (
  VOID
  )
{
  INSTALL_MEMORY_INIT_FUNC   *CompatibleMemoryInit;
  EFI_STATUS Status;

  Status = PeiServicesLocatePpi(
                       &gCompatibleMemoryInitPpiGuid,
                       0,
                       NULL,
                       (VOID **)&CompatibleMemoryInit
                        );
  ASSERT_EFI_ERROR (Status);
  if (CompatibleMemoryInit->CompatibleInstallMrcCallback == NULL) {
    DEBUG ((DEBUG_ERROR, "X-Compatibility Support Library ERROR : No MRC found!\n"));
    ASSERT (!EFI_ERROR (Status));
    return EFI_NOT_FOUND;
  }
  CompatibleMemoryInit->CompatibleInstallMrcCallback ();
  return EFI_SUCCESS;
}

/**
  Consumes the MRC functions PPI
  This call support X-compatibility module to locate Compatibility Memory Policy PPI and run.

  @retval    EFI_SUCCESS         The function was successfully registered.
  @retval    EFI_NOT_FOUND       No compatibile MRC is found.
*/
VOID
LoadMemConfigNoCrcDefault (
  IN VOID    *ConfigBlockPointer
  )
{
  INSTALL_MEMORY_INIT_FUNC   *CompatibleMemoryInit;
  EFI_STATUS Status;
  Status = PeiServicesLocatePpi(
                      &gCompatibleMemoryInitPpiGuid,
                      0,
                      NULL,
                      (VOID **)&CompatibleMemoryInit
                      );
  ASSERT_EFI_ERROR (Status);
  if (CompatibleMemoryInit->CompatibleLoadMemConfigNoCrcDefault == NULL) {
    DEBUG ((DEBUG_ERROR, "X-Compatibility Support Library ERROR : No LoadMemConfigNoCrcDefault found!\n"));
    ASSERT (!EFI_ERROR (Status));
    return;
  }
  CompatibleMemoryInit->CompatibleLoadMemConfigNoCrcDefault (ConfigBlockPointer);
  return;
}

/**
  Consumes the MRC functions PPI
  This call support X-compatibility module to locate Compatibility Memory Policy PPI and run.

  @retval    EFI_SUCCESS         The function was successfully registered.
  @retval    EFI_NOT_FOUND       No compatibile MRC is found.
*/
VOID
LoadMemConfigDefault (
  IN VOID    *ConfigBlockPointer
  )
{
  INSTALL_MEMORY_INIT_FUNC   *CompatibleMemoryInit;
  EFI_STATUS Status;
  Status = PeiServicesLocatePpi(
                      &gCompatibleMemoryInitPpiGuid,
                      0,
                      NULL,
                      (VOID **)&CompatibleMemoryInit
                      );
  ASSERT_EFI_ERROR (Status);
  if (CompatibleMemoryInit->CompatibleLoadMemConfigDefault == NULL) {
    DEBUG ((DEBUG_ERROR, "X-Compatibility Support Library ERROR : No LoadMemConfigDefault found!\n"));
    ASSERT (!EFI_ERROR (Status));
    return;
  }
  CompatibleMemoryInit->CompatibleLoadMemConfigDefault (ConfigBlockPointer);
  return;
}

/**
  Consumes the MRC functions PPI
  This call support X-compatibility module to locate Compatibility Memory Policy PPI and run.

  @retval    EFI_SUCCESS         The function was successfully registered.
  @retval    EFI_NOT_FOUND       No compatibile MRC is found.
*/
VOID
SaLoadSamplePolicyPreMem (
  IN VOID    *ConfigBlockTableAddress
  )
{
  INSTALL_MEMORY_INIT_FUNC   *CompatibleMemoryInit;
  EFI_STATUS Status;
  Status = PeiServicesLocatePpi(
                      &gCompatibleMemoryInitPpiGuid,
                      0,
                      NULL,
                      (VOID **)&CompatibleMemoryInit
                      );
  ASSERT_EFI_ERROR (Status);
  if (CompatibleMemoryInit->CompatibleSaLoadSamplePolicyPreMem == NULL) {
    DEBUG ((DEBUG_ERROR, "X-Compatibility Support Library ERROR : No SaLoadSamplePolicyPreMem found!\n"));
    ASSERT (!EFI_ERROR (Status));
    return;
  }
  CompatibleMemoryInit->CompatibleSaLoadSamplePolicyPreMem (ConfigBlockTableAddress);
  return;
}
