/** @file
  Contains functions that are used outside of the DdrIo Library.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _MrcDdrIoApiInt_h_
#define _MrcDdrIoApiInt_h_
/// Defines
#define MRC_NUM_OF_VSSHI_COMPS (14)
#define FLL_REF_CLK            (400) // MHz
#define MRC_NUI_READ           (TRUE)
#define MRC_NUI_CLEAR          (FALSE)

/// Functions
/**
  This function updates the Gear specific fields in the DDRIO

  @param[in]  MrcData - Pointer to global MRC data.
  @param[in]  Gear2   - TRUE for Gear2, FALSE for Gear1
**/
VOID
DdrIoConfigGear2 (
  IN  MrcParameters *MrcData,
  IN  BOOLEAN       Gear2
  );

extern
MrcStatus
MrcTranslateSystemToIp (
  IN      MrcParameters *const  MrcData,
  IN OUT  UINT32        *const  Controller,
  IN OUT  UINT32        *const  Channel,
  IN OUT  UINT32        *const  Rank,
  IN OUT  UINT32        *const  Strobe,
  IN OUT  UINT32        *const  Lane,
  IN      GSM_GT        const   Group
  );

/**
  DCC Training step for running after training steps

  @param[in] MrcData         - Include all MRC global data.
  @param[in] Traffic         - Type of traffic required (if none, use MRC_IGNORE_ARG)
  @param[in] ParamMask       - Bit Mask of parameters to be run.  (See defines at top of .c file)
  #param[in] NumOfCompCycles - # of Comp Cycles needed
  @param[in] Print           - Whether to print (TRUE) or not (FALSE)

  @retval mrcSuccess if DCC converged otherwise mrcFail
  **/
MrcStatus
MrcDccTrainingStep (
  IN MrcParameters *const MrcData,
  IN UINT32               Traffic,
  IN UINT32               ParamMask,
  IN UINT32               NumOfCompCycles,
  IN BOOLEAN              Print
  );

/**
  This function configures the memory controller MC0_CH0_CR_SPID_LOW_POWER_CTL register using
  the register definition compatible with TGL A0

  @param[in] MrcData    - Include all MRC global data.
  @param[in] Controller - The target controller to configure
  @param[in] IpChannel  - The target IP Channel to configure.

  @retval Nothing.
**/
void
ConfigA0SpidLowPowerCtl (
  IN MrcParameters *const MrcData,
  IN UINT32         Controller,
  IN UINT32         IpChannel
  );

/**
  This function configures the memory controller MC0_CH0_CR_SPID_LOW_POWER_CTL register using
  the register definition compatible with TGL B0 and TGL P0.

  @param[in] MrcData    - Include all MRC global data.
  @param[in] Controller - The target controller to configure
  @param[in] IpChannel  - The target IP Channel to configure.

  @retval Nothing.
**/
void
ConfigSpidLowPowerCtl (
  IN MrcParameters *const MrcData,
  IN UINT32        Controller,
  IN UINT32        IpChannel
  );

#endif //_MrcDdrIoApiInt_h_
