/** @file
  Register names for PCIe SIP specific registers

  Conventions:

  - Register definition format:
  Prefix_[GenerationName]_[ComponentName]_SubsystemName_RegisterSpace_RegisterName
  - Prefix:
  Definitions beginning with "R_" are registers
  Definitions beginning with "B_" are bits within registers
  Definitions beginning with "V_" are meaningful values within the bits
  Definitions beginning with "S_" are register size
  Definitions beginning with "N_" are the bit position
  - [GenerationName]:
  Three letter acronym of the generation is used (e.g. SKL,KBL,CNL etc.).
  Register name without GenerationName applies to all generations.
  - [ComponentName]:
  This field indicates the component name that the register belongs to (e.g. PCH, SA etc.)
  Register name without ComponentName applies to all components.
  Register that is specific to -H denoted by "_PCH_H_" in component name.
  Register that is specific to -LP denoted by "_PCH_LP_" in component name.
  - SubsystemName:
  This field indicates the subsystem name of the component that the register belongs to
    (e.g. PCIE, USB, SATA, GPIO, PMC etc.).
  - RegisterSpace:
  MEM - MMIO space register of subsystem.
  IO  - IO space register of subsystem.
  PCR - Private configuration register of subsystem.
  CFG - PCI configuration space register of subsystem.
  - RegisterName:
  Full register name.

  @copyright
  INTEL CONFIDENTIAL
  Copyright 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary    and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _PCIE_SIP_RP_REGS_H_
#define _PCIE_SIP_RP_REGS_H_

#include <PcieRegs.h>

#define  R_PCIE_CFG_CLIST                             0x40
#define  R_PCIE_DCAP2                                 (R_PCIE_CFG_CLIST + R_PCIE_DCAP2_OFFSET)
#define  R_PCIE_DCTL2                                 (R_PCIE_CFG_CLIST + R_PCIE_DCTL2_OFFSET)
#define  R_PCIE_LCAP2                                 (R_PCIE_CFG_CLIST + R_PCIE_LCAP2_OFFSET)

#define R_PCIE_CFG_CCFG                               0xD0
#define B_PCIE_CFG_CCFG_UMRPD                         BIT26
#define B_PCIE_CFG_CCFG_UPMWPD                        BIT25
#define B_PCIE_CFG_CCFG_UPSD                          BIT24
#define B_PCIE_CFG_CCFG_UNSD                          BIT23
#define B_PCIE_CFG_CCFG_DCGEISMA                      BIT15
#define B_PCIE_CFG_CCFG_UNRD                          (BIT13 | BIT12)
#define N_PCIE_CFG_CCFG_UNRD                          12
#define B_PCIE_CFG_CCFG_UNRS                          (BIT6 | BIT5 | BIT4)
#define N_PCIE_CFG_CCFG_UNRS                          4
#define V_PCIE_CFG_CCFG_UNRS_128B                     0
#define V_PCIE_CFG_CCFG_UNRS_256B                     1
#define V_PCIE_CFG_CCFG_UNRS_64B                      7
#define B_PCIE_CFG_CCFG_UPRS                          (BIT2 | BIT1 | BIT0)
#define N_PCIE_CFG_CCFG_UPRS                          0
#define V_PCIE_CFG_CCFG_UPRS_128B                     0
#define V_PCIE_CFG_CCFG_UPRS_256B                     1
#define V_PCIE_CFG_CCFG_UPRS_64B                      7

//
// Coalescing registers. From PCIe SIP 16
//
#define  R_PCIE_COCTL                             0x594
#define  B_PCIE_COCTL_NPCLM                       BIT15
#define  N_PCIE_COCTL_NPCLM_OFFSET                15
#define  B_PCIE_COCTL_NPCLM_MASK                  (BIT15 | BIT16)
#define  B_PCIE_COCTL_PCLM                        BIT13
#define  N_PCIE_COCTL_PCLM_OFFSET                 13
#define  B_PCIE_COCTL_PCLM_MASK                   (BIT13 | BIT14)
#define  B_PCIE_COCTL_MAGPARCD                    BIT12
#define  N_PCIE_COCTL_MAGPARCD_OFFSET             12
#define  B_PCIE_COCTL_ROAOP                       BIT11
#define  N_PCIE_COCTL_ROAOP_OFFSET                11
#define  B_PCIE_COCTL_CTE                         BIT10
#define  N_PCIE_COCTL_CTE_OFFSET                  10
#define  B_PCIE_COCTL_CT                          BIT2
#define  N_PCIE_COCTL_CT_OFFSET                   2
#define  B_PCIE_COCTL_CT_MASK                     0x3FC
#define  B_PCIE_COCTL_DDCE                        BIT1
#define  N_PCIE_COCTL_DDCE_OFFSET                 1
#define  B_PCIE_COCTL_PWCE                        BIT0
#define  N_PCIE_COCTL_PWCE_OFFSET                 0

//
// LTR subtraction registers. Added in PCIe SIP 16
//
#define  R_PCIE_LTRSUBL1STD                           0xC5C
#define  R_PCIE_LTRSUBL11                             0xC60
#define  R_PCIE_LTRSUBL12                             0xC64
#define  B_PCIE_LTRSUB_LTRNSLSUBEN                    BIT31
#define  B_PCIE_LTRSUB_LTRNSLSSUBV                    BIT26
#define  N_PCIE_LTRSUB_LTRNSLSSUBV                    26
#define  B_PCIE_LTRSUB_LTRNSLSSUBV_MASK               (BIT28 | BIT27 | BIT26)
#define  B_PCIE_LTRSUB_LTRNSLSUBV                     BIT16
#define  N_PCIE_LTRSUB_LTRNSLSUBV                     16
#define  B_PCIE_LTRSUB_LTRNSLSUBV_MASK                0x03FF0000
#define  B_PCIE_LTRSUB_LTRSLSUBEN                     BIT15
#define  B_PCIE_LTRSUB_LTRSLSSUBV                     BIT10
#define  N_PCIE_LTRSUB_LTRSLSSUBV                     10
#define  B_PCIE_LTRSUB_LTRSLSSUBV_MASK                (BIT12 | BIT11 | BIT10)
#define  B_PCIE_LTRSUB_LTRSLSUBV                      BIT0
#define  N_PCIE_LTRSUB_LTRSLSUBV                      0
#define  B_PCIE_LTRSUB_LTRSLSUBV_MASK                 0x000003FF

#define  R_PCIE_LPCR                                  0xC8C
#define  B_PCIE_LPCR_DIDOVR_LOCK                      BIT24
#define  B_PCIE_LPCR_LTRCFGLOCK                       BIT16
#define  B_PCIE_LPCR_SERL                             BIT8
#define  B_PCIE_LPCR_SRL                              BIT0

//
// Advance Mode Control Register
//
#define  R_PCIE_ADVMCTRL                              0x5BC
#define  B_PCIE_ADVMCTRL_F10BTSE                      BIT24
#endif
