/** @file
  @This file implements the parser functions to parse 3DXP device Mailbox output
  payload and populate the 2LM Info HOB.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#include <Uefi.h>
#include <Pi/PiBootMode.h>
#include <Pi/PiHob.h>
#include <Library/PeiDxeSmmTwoLmLib.h>
#include <Library/FmssMbLib.h>
#include <Library/DebugLib.h>
#include <Library/PmcPrivateLib.h>
#include <Library/BaseLib.h>
#include <Library/PciSegmentLib.h>
#include <Library/BaseMemoryLib.h>
#include <Register/Msr.h>
#include <Register/SaRegsHostBridge.h>
#include <Library/IoLib.h>



UINT32 TwoLmGetEpoc (
  ) {
  return PmcGetCpuEpoc ();
}


VOID TwoLmSetEpoc (
  IN UINT32  EpocValue
  ) {
  PmcSetCpuEpoc (EpocValue);
  return;
}

/**
  Checks if TwoLm is supported or not.

  @retval FALSE  TwoLm is not supported
  @retval TRUE   TwoLm is supported
**/
BOOLEAN
IsTwoLmSupported (
  VOID
  )
{
  UINT32          CapIdValue;

  CapIdValue = PciSegmentRead32 (PCI_SEGMENT_LIB_ADDRESS(SA_SEG_NUM, SA_MC_BUS, SA_MC_DEV, SA_MC_FUN, R_SA_MC_CAPID0_A_OFFSET));
  if (CapIdValue & B_CAPID0_A_2LM_SUPPORT) {
    return TRUE;
  }
  return FALSE;
}


/**
This function returns the status of Boot Time Zero Memory feature.

@param[in]      None

@retval EFI_SUCCESS            if BZM is enabled.
@retval EFI_UNSUPPORTED        if BZM is not enabled.
**/

EFI_STATUS
IsBzmEnabled (
  ) {
  UINT64   Data64;
  // Check BZM status Bit21 of FEATURE_CONTROL MSR.
  Data64 = AsmReadMsr64 (MSR_IA32_FEATURE_CONTROL);
  if (Data64 & B_IA32_FEATURE_CONTROL_BZM) {
    return EFI_SUCCESS;
  }
  return EFI_UNSUPPORTED;
}

/**
  Checks if TwoLm is enabled or not.

  @retval FALSE  TwoLm is disabled
  @retval TRUE   TwoLm is enabled
**/
BOOLEAN
IsTwoLmEnabled (
  VOID
  )
{
  UINT32          CapIdValue;

  CapIdValue = PciSegmentRead32 (PCI_SEGMENT_LIB_ADDRESS(SA_SEG_NUM, SA_MC_BUS, SA_MC_DEV, SA_MC_FUN, R_SA_MC_CAPID0_B));
  if (CapIdValue & V_SA_MC_CAPID0_B_2LM_EN) {
    return TRUE;
  }
  return FALSE;
}


/**
  Get the EDRAM Bar value.

  @retval EDRAM Bar Value
**/
UINT64
GetEdramBarValue (
  VOID
  )
{
  UINT64            Edrambar;
  UINT32            MchBar;

  MchBar = PciSegmentRead32 (PCI_SEGMENT_LIB_ADDRESS (SA_SEG_NUM, SA_MC_DEV, 0, 0, 0) + R_SA_MCHBAR) & ~BIT0;
  Edrambar = MmioRead64 (MchBar +R_SA_MCHBAR_EDRAMBAR_OFFSET) & ~BIT0;
  if(!Edrambar) {
   return 0;
  }
  return Edrambar;
}
