/**@file

@copyright
INTEL CONFIDENTIAL
Copyright 2019 Intel Corporation.

The source code contained or described herein and all documents related to the
source code ("Material") are owned by Intel Corporation or its suppliers or
licensors. Title to the Material remains with Intel Corporation or its suppliers
and licensors. The Material may contain trade secrets and proprietary and
confidential information of Intel Corporation and its suppliers and licensors,
and is protected by worldwide copyright and trade secret laws and treaty
provisions. No part of the Material may be used, copied, reproduced, modified,
published, uploaded, posted, transmitted, distributed, or disclosed in any way
without Intel's prior express written permission.

No license under any patent, copyright, trade secret or other intellectual
property right is granted to or conferred upon you by disclosure or delivery
of the Materials, either expressly, by implication, inducement, estoppel or
otherwise. Any license under such intellectual property rights must be
express and approved by Intel in writing.

Unless otherwise agreed by Intel in writing, you may not remove or alter
this notice or any other notice embedded in Materials by Intel or
Intel's suppliers or licensors in any way.

This file contains a 'Sample Driver' and is licensed as such under the terms
of your license agreement with Intel or your vendor. This file may be modified
by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _NVDIMM_LABEL_DXE_DRIVER_H_
#define _NVDIMM_LABEL_DXE_DRIVER_H_

#include <PiDxe.h>
#include <Library/UefiBootServicesTableLib.h>
#include <Library/DebugLib.h>
#include <Protocol/NvdimmLabel.h>
#include <Library/FmssMbLib.h>
#include <Library/PeiDxeSmmTwoLmLib.h>
#include <Library/HobLib.h>
#include <Library/DxeServicesLib.h>
#include <Library/UefiBootServicesTableLib.h>
#include <Library/BaseMemoryLib.h>



/**
  Retrieves the Label Storage Area size and the maximum transfer size for the LabelStorageRead and
  LabelStorageWrite methods.

  @param  This                   A pointer to the EFI_NVDIMM_LABEL_PROTOCOL instance.
  @param  SizeOfLabelStorageArea The size of the Label Storage Area for the NVDIMM in bytes.
  @param  MaxTransferLength      The maximum number of bytes that can be transferred in a single call to
                                 LabelStorageRead or LabelStorageWrite.

  @retval EFI_SUCCESS            The size of theLabel Storage Area and maximum transfer size returned are valid.
  @retval EFI_ACCESS_DENIED      The Label Storage Area for the NVDIMM device is not currently accessible.
  @retval EFI_DEVICE_ERROR       A physical device error occurred and the data transfer failed to complete.
**/
EFI_STATUS
EFIAPI
NvdimmLabelStorageInformation (
  IN  EFI_NVDIMM_LABEL_PROTOCOL *This,
  OUT UINT32                    *SizeOfLabelStorageArea,
  OUT UINT32                    *MaxTransferLength
);

/**
  Retrieves the label data for the requested offset and length from within the Label Storage Area for
  the NVDIMM.

  @param  This                   A pointer to the EFI_NVDIMM_LABEL_PROTOCOL instance.
  @param  Offset                 The byte offset within the Label Storage Area to read from.
  @param  TransferLength         Number of bytes to read from the Label Storage Area beginning at the byte
                                 Offset specified. A TransferLength of 0 reads no data.
  @param  LabelData              The return label data read at the requested offset and length from within
                                 the Label Storage Area.

  @retval EFI_SUCCESS            The label data from the Label Storage Area for the NVDIMM was read successfully
                                 at the specified Offset and TransferLength and LabelData contains valid data.
  @retval EFI_INVALID_PARAMETER  Any of the following are true:
                                 - Offset > SizeOfLabelStorageArea reported in the LabelStorageInformation return data.
                                 - Offset + TransferLength is > SizeOfLabelStorageArea reported in the
                                   LabelStorageInformation return data.
                                 - TransferLength is > MaxTransferLength reported in the LabelStorageInformation return
                                   data.
  @retval EFI_ACCESS_DENIED      The Label Storage Area for the NVDIMM device is not currently accessible and labels
                                 cannot be read at this time.
  @retval EFI_DEVICE_ERROR       A physical device error occurred and the data transfer failed to complete.
**/
EFI_STATUS
EFIAPI
NvdimmLabelStorageRead (
  IN CONST EFI_NVDIMM_LABEL_PROTOCOL *This,
  IN UINT32                          Offset,
  IN UINT32                          TransferLength,
  OUT UINT8                          *LabelData
);

/**
  Writes the label data for the requested offset and length in to the Label Storage Area for the NVDIMM.

  @param  This                   A pointer to the EFI_NVDIMM_LABEL_PROTOCOL instance.
  @param  Offset                 The byte offset within the Label Storage Area to write to.
  @param  TransferLength         Number of bytes to write to the Label Storage Area beginning at the byte
                                 Offset specified. A TransferLength of 0 writes no data.
  @param  LabelData              The return label data write at the requested offset and length from within
                                 the Label Storage Area.

  @retval EFI_SUCCESS            The label data from the Label Storage Area for the NVDIMM written read successfully
                                 at the specified Offset and TransferLength.
  @retval EFI_INVALID_PARAMETER  Any of the following are true:
                                 - Offset > SizeOfLabelStorageArea reported in the LabelStorageInformation return data.
                                 - Offset + TransferLength is > SizeOfLabelStorageArea reported in the
                                   LabelStorageInformation return data.
                                 - TransferLength is > MaxTransferLength reported in the LabelStorageInformation return
                                   data.
  @retval EFI_ACCESS_DENIED      The Label Storage Area for the NVDIMM device is not currently accessible and labels
                                 cannot be written at this time.
  @retval EFI_DEVICE_ERROR       A physical device error occurred and the data transfer failed to complete.
**/
EFI_STATUS
EFIAPI
NvdimmLabelStorageWrite (
  IN CONST EFI_NVDIMM_LABEL_PROTOCOL *This,
  IN UINT32                          Offset,
  IN UINT32                          TransferLength,
  IN UINT8                           *LabelData
);

/**
  Entry Point

  @param[in] ImageHandle          Handle for this drivers loaded image protocol.
  @param[in] SystemTable          EFI system table.

  @retval EFI_SUCCESS             Always return EFI_SUCCESS
**/
EFI_STATUS
EFIAPI
NvdimmLabelDriverEntryPoint (
  IN EFI_HANDLE         ImageHandle,
  IN EFI_SYSTEM_TABLE   *SystemTable
);

#endif
