/** @file
  NV DIMM Root and child device support.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2019-2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#include <Register/TwoLmRegs.h>

#define  MMIO_SCRUBBER_PCODE_CTL                       VAR8
#define  MMIO_PCODE_CTL                                VAR9

#define PERFORMANCE_MODE                               0
#define DURABILITY_MODE                                1

#define ASTRO_PERFORMANCE_MODE                         1
#define ASTRO_DURABILITY_MODE                          2


DefinitionBlock (
  "NvDimm.aml",
  "SSDT",
  2,
  "INTEL ",
  "NvdmTabl",
  0x1000
  )
{

External(\_SB.PC00.GMHB, MethodObj)
External(\CMBM, IntObj) // Current Memory Boot Mode 0: BOOT_MODE_1LM(Default), 1: BOOT_MODE_2LM, 2: BOOT_MODE_PROVISION

  Scope (\_SB)
  {

    //
    // This file contains the definition of Device(NFIT) which would allow the NFIT
    // SCM Bus driver to load.
    //
    Device(NVDR){
      Name (_HID, "ACPI0012")

      Method (_STA){
        If(LEqual(\CMBM, 1)) // Current Memory Boot Mode 0: BOOT_MODE_1LM(Default), 1: BOOT_MODE_2LM, 2: BOOT_MODE_PROVISION
        {
          Return (0x0F)
        }
        Else
        {
          Return (0x00)
        }
      }

      //
      // Operational region for communication between ASL and SMM handler
      // Region Offset 0xFFFF0000 and Length 0x300 will be fixed in C code.
      //
      OperationRegion (NVDM, SystemMemory, 0xFFFF0000, 0x300)
      Field (NVDM, AnyAcc, NoLock, Preserve)
      {
        FISS,   8,  //   Software SMI for Firmware Interface Command interface
        FISF,   8,  //   Function number for Firmware Interface Command
        FIS1,   32, //   dword1
        FIS2,   32, //   dword2
        FIS3,   32, //   dword3
        BUFF,   4160 //  buffer (512+8) bytes
      }

      //
      // Operational region for Smi port access
      //
      OperationRegion (SMIP, SystemIO, 0xB2, 1)
      Field (SMIP, ByteAcc, NoLock, Preserve)
      {
        IOB2, 8
      }

      Method (CLAR, 1, Serialized)
      {
        OperationRegion (BUF0, SystemMemory, Arg0, 1)
        Field (BUF0, ByteAcc, NoLock, Preserve)
        {
          DATA, 8
        }
        Store (0, DATA)
      }

      Method (BITS, 1)
      {
        Return (Multiply (Arg0, 8))
      }

      //
      // Operation region defined to access the EDRAM BAR
      // Get the MCHBAR in offset 0x48 in B0:D0:F0
      // EDRAM Bar is in offset 0x5408 of MCHBAR.
      //
      OperationRegion (EBAR, SystemMemory, Add(\_SB.PC00.GMHB(), 0x5408), 0x8)
      Field (EBAR, ByteAcc, NoLock, Preserve)
      {
        EVAL, 64,   // MMIO address of EDRAM Bar
      }

      Method(EDRM, 0)
      {
        Return(And(EVAL, 0xFFFFFFFFFFFFFFFE))
      }

      //
      // Operation region defined to access the Astro register scrubber_pcode_ctl
      // Set durability mode DSM will modify the Scrubber type field in this register
      // Get durability mode DSM will read the Scrubber type field in this register
      //
      OperationRegion (PCTL, SystemMemory, Add(EDRM(), ( ASTRO_OFFSET + R_ASTRO_SCRUBBER_PCODE_CTL )), 0x4)
      Field (PCTL, DWordAcc, NoLock, Preserve)
      {
        PVAL, 32,
      }

      // Get scrubber mode
      Method(GETM, 0)
      {
        store ((And(PVAL, 0x0F000000) >> 24), Local2)
        if (LEqual (Local2, ASTRO_PERFORMANCE_MODE))
        {
          Return(PERFORMANCE_MODE)
        }
        if (LEqual (Local2, ASTRO_DURABILITY_MODE))
        {
          Return(DURABILITY_MODE)
        }
      }

      // Set scrubber mode
      Method(SETM, 1)
      {
        if (LEqual (Arg0, 0))
        {
          Store( And(PVAL, 0xF0FFFFFF), PVAL )
          Store( OR(PVAL, (1 << 24)), PVAL )
        }
        if (LEqual (Arg0, 1))
        {
          Store( And(PVAL, 0xF0FFFFFF), PVAL )
          Store( OR(PVAL, (2 << 24)), PVAL )
        }
      }

      Name (SCUB, 0)  // Variable to store scrubber type

      // Method to re-store scrubber type on s3 resume
      Method(RSTP, 0)
      {
        SETM(SCUB)  // restore srub type for S3 resume
      }


      // Root device _DSMs
      Method (_DSM, 4, Serialized, 0, UnknownObj, {BuffObj, IntObj, IntObj, PkgObj})
      {
        If(LEqual(Arg0, ToUUID ("2f10e7a4-9e91-11e4-89d3-123b93f75cba")))
        {
          Include("RootDsms.asl")
        }
        If(LEqual(Arg0, ToUUID ("1923E4D4-0E54-4726-9BE2-9883AD4F3DDD")))
        {
          Include("DurabilityDsms.asl")
        }
        Return (Package () {0x03})
      } //end of Root DSMs

      Device(NVD1) {
        // _ADR
        Name(_ADR, 0x1)

        Method (_STA) {
          If(LEqual(\CMBM, 1)) // Current Memory Boot Mode 0: BOOT_MODE_1LM(Default), 1: BOOT_MODE_2LM, 2: BOOT_MODE_PROVISION
          {
            Return (0x0F)
          }
          Else
          {
            Return (0x00)
          }
        }

        Method (_LSI, 0)
        {
          Store(31, FISF)  // Store LSI function number which has corresponding function in NvdimmSmm.c
          //
          // Triggle the SMI interrupt
          //
          Store (FISS, IOB2)

          if (LEqual (FIS1, 0)) {

            Store (Package () {0, 0, 0}, Local2)
            Store (ToInteger (FIS1), Index (Local2, 0))
            Store (ToInteger (FIS2), Index (Local2, 1))
            Store (ToInteger (FIS3), Index (Local2, 2))
            Return (Local2)
          }
          Else
          {
            Return (Package () {0x01, 0x00, 0x00})
          }
        }

        Method (_LSR, 2, Serialized)
        {
          Store(32, FISF) // Store LSR function number which has corresponding function in NvdimmSmm.c
          Store(Arg0, FIS1) // Offset in bytes
          Store(Arg1, FIS2) // Length in bytes
          //
          // Triggle the SMI interrupt
          //
          Store (FISS, IOB2)
          // After coming back from SMI, FIS1 will have status. 0 is success.
          // BUFF will be filled with data read from device of size in FIS2.
          if (LEqual (FIS1, 0)) {
            Store (Buffer (Add (Arg1, 4)) {}, Local1)
            CreateDWordField (Local1, 0, RSTS)
            Store(0, RSTS)
            CreateField (Local1, BITS (4), BITS (Arg1), RDTA)
            Mid (BUFF, 0,  Arg1, Local0) //Local0 has read buffer
            Store(Local0, RDTA)
            Name (INDX, 4)
            Store(Arg1, Local6)
            While(LLess(INDX, Local6)) {
              Store(DeRefOf(Index(Local1,INDX)), Local7)
              Increment(INDX)
            }
            return (Local1)
          }
          Else
          {
            Return (Package () {0x01, Buffer () {0}})
          }
        }

        Method (_LSW, 3, Serialized)
        {
          Mid (Arg2, 0,  Arg1, BUFF)
          Store(33, FISF) // Store LSW function number which has corresponding function in NvdimmSmm.c
          Store(Arg0, FIS1)  // offset
          Store(Arg1, FIS2)  // Length in bytes
          Name (INDX, 0)
          Store(Arg1, Local6)
          Store (Buffer (Arg1) {}, Local5)
          Mid (BUFF, 0,  Arg1, Local5) //Local0 has read buffer
          While(LLess(INDX, Local6)) {
            Store(DeRefOf(Index(Local5,INDX)), Local7)
            Increment(INDX)
          }
          //
          // Triggle the SMI interrupt
          //
          Store (FISS, IOB2)
          if (LEqual (FIS1, 0)) {
            Return (0x00)
          }
          Else
          {
            Return (0x01)
          }
        }
        // Device DSMs
        Method (_DSM, 4, Serialized, 0, UnknownObj, {BuffObj, IntObj, IntObj, PkgObj})
        {
          If(LNotEqual(Arg0, ToUUID ("4309AC30-0D11-11E4-9191-0800200C9A66")))
          {
            Return (Package () {0x03})
          }
          Name (INDX, 0)
          Switch(ToInteger(Arg2)) {
            Case(0) {
              Return(Buffer(){0x87, 0x1F,0x2})
            }
            Case(1) { // Get SMART and Health Info (Function Index 1)
              Store(1, FISF)
              Store (FISS, IOB2)
              if (LEqual (FIS1, 0)) {
                Store(FIS2, Local3) //store return length in Local3
                //copy data from Buff starting at 0 and of length Local3 to Local0
                Mid (BUFF, 0,  Local3, Local0) //Local0 has read buffer
                //create Local1 of size (Local3 + 4) = (128+4)
                Store (Buffer (Add (Local3, 4)) {}, Local1)
                //In Local1, define DW field RSTS from offset 0
                CreateDWordField (Local1, 0, RSTS)
                Store(0, RSTS)
                //create field RDTA in Local1 from offset 32bits and size Local3
                CreateField (Local1, BITS (4), BITS (Local3), RDTA)
                Store(Local0, RDTA)
                Store (0, INDX)
                Store(FIS2, Local6)
                While(LLess(INDX, Local6)) {
                  Store(DeRefOf(Index(Local1,INDX)), Local7)
                  Increment(INDX)
                }
                Return(Local1)
              }
              Else
              {
                Name(PDD1, Package() {Buffer (132) {}})
                CreateDWordField (DerefOf(Index(PDD1, 0)), 0, VARA)
                Store(FIS1, VARA)
                Return (PDD1)
              }
            }
            Case(2) { // Get SMART Threshold (Function Index 2)
              Store(2, FISF)
              Store (FISS, IOB2)
              if (LEqual (FIS1, 0)) {
                Store(FIS2, Local3) //store return length in Local3
                //copy data from Buff starting at 0 and of length Local3 to Local0
                Mid (BUFF, 0,  Local3, Local0) //Local0 has read buffer
                //create Local1 of size (Local3 + 4) = (8+4)
                Store (Buffer (Add (Local3, 4)) {}, Local1)
                //In Local1, define DW field RST2 from offset 0
                CreateDWordField (Local1, 0, RST2)
                Store(0, RST2)
                //create field RDTA in Local1 from offset 32bits and size Local3
                CreateField (Local1, BITS (4), BITS (Local3), RDT2)
                Store(Local0, RDT2)

                Store (0, INDX)
                Store(12, Local6)
                While(LLess(INDX, Local6)) {
                  Store(DeRefOf(Index(Local1,INDX)), Local7)
                }
                Return(Local1)
              }
              Else
              {
                Name(PDD2, Package() {Buffer (12) {}})
                CreateDWordField (DerefOf(Index(PDD2, 0)), 0, VARB)
                Store(FIS1, VARB)
                Return (PDD2)
              }
            }
            Case(7) {
              // Get Command Effect Log Info (Function Index 7)
              Store(7, FISF)
              Store (FISS, IOB2)
              if (LEqual (FIS1, 0)) {
                //copy data from Buff starting at 0 and of length 4 bytes to Local0
                Mid (BUFF, 0,  4, Local0) //Local0 has read buffer
                //create Local1 of size (4 + 4)
                Store (Buffer (Add (4, 4)) {}, Local1)
                //In Local1, define DW field RST7 from offset 0
                CreateDWordField (Local1, 0, RST7)
                Store (0, RST7)
                //create field RDT7 in Local1 from offset 32bits and size 4
                CreateField (Local1, BITS (4), BITS (4), RDT7)
                Store (Local0, RDT7)

                Store (0, INDX)
                Store (8, Local6)
                While(LLess(INDX, Local6)) {
                  Store(DeRefOf(Index(Local1,INDX)), Local7)
                  Increment(INDX)
                }
                Return(Local1)
              }
              Else
              {
                Name(PDD7, Package() {Buffer (8) {}})
                CreateDWordField (DerefOf(Index(PDD7, 0)), 0, VARC)
                Store(FIS1, VARC)
                Return (PDD7)
              }
            }
            Case(8) {
              // Get Command Effect Log (Function Index 8)
              Store(8, FISF)
              Store (FISS, IOB2)
              if (LEqual (FIS1, 0)) {
                Store(FIS2, Local3) //store return length in Local3
                Store(FIS3, Local4) //store opcode count in Local4
                //copy data from Buff starting at 0 and of length Local3 to Local0
                Mid (BUFF, 0,  Local3, Local0) //Local0 has read buffer
                //create Local1 of size (Local3 + 4 + 4 )
                Store (Buffer (Add (Local3, 8)) {}, Local1)
                //In Local1, define DW field RST8 from offset 0
                CreateDWordField (Local1, 0, RST8)
                Store(0, RST8)
                //now copy and return opcode cnt
                CreateDWordField (Local1, 4, RCNT)
                Store(Local4, RCNT)
                //create field RDT8 in Local1 from offset 32bits and size Local3
                CreateField (Local1, BITS (8), BITS (Local3), RDT8)
                Store(Local0, RDT8)

                Store (0, INDX)
                Store(Add (Local3, 8), Local6)
                While(LLess(INDX, Local6)) {
                  Store(DeRefOf(Index(Local1,INDX)), Local7)
                  Increment(INDX)
                }
                Return(Local1)
              }
              Else
              {
                Name(PDD8, Package() {Buffer (8) {}})
                CreateDWordField (DerefOf(Index(PDD8, 0)), 0, VARD)
                Store(FIS1, VARD)
                Return (PDD8)
              }
            }
            Case(9) {
              // Pass-Through Command (Function Index 9)
              Store(9, FISF)
              ToBuffer (DeRefOf (Index (Arg3, 0)), Local0)// Local0 has input
              Mid (Local0, 0, 4, FIS1)     // Opcode
              Mid (Local0, 4, 4, FIS2)     // Input data length
              Mid (Local0, 8, FIS2, BUFF)  //BUFF has input payload

              Store (0, INDX)
              Store (FIS2, Local6)
              Store (Buffer (FIS2) {}, Local5)
              Mid (BUFF, 0,  FIS2, Local5) //Local5 has read buffer
              While(LLess(INDX, Local6)) {
                Store(DeRefOf(Index(Local5,INDX)), Local7)
                Increment(INDX)
              }
              //
              // Triggle the SMI interrupt
              //
              Store (FISS, IOB2)
              if (LEqual (FIS1, 0)) {
                //copy data from Buff starting at 0 and of length 520 bytes to Local0
                Mid (BUFF, 0, 520, Local0) //Local0 has read buffer

                //create Local1 of size (520 + 4 + 4)
                Store (Buffer (Add (520, 8)) {}, Local1)
                //In Local1, define DW field RST9 from offset 0
                CreateDWordField (Local1, 0, RST9)
                Store(0, RST9)
                //In Local1, define DW field RDL9 from offset 4
                CreateDWordField (Local1, 4, RDL9)
                Store(520, RDL9)
                //create field RDT9 in Local1 from offset 8bytes and size 520
                CreateField (Local1, BITS (8), BITS (520), RDT9)
                Store(Local0, RDT9)

                Store (0, INDX)
                While(LLess(INDX, 528)) {
                  Store(DeRefOf(Index(Local1,INDX)), Local7)
                  Increment(INDX)
                }
                Return(Local1)
              }
              Else
              {
                Name(PDD9, Package() {Buffer (8) {}})
                CreateDWordField (DerefOf(Index(PDD9, 0)), 0, VARE)
                Store(FIS1, VARE)
                Return (PDD9)
              }
            }
            Case(10) {
              // Enable Latch System Shutdown Status
              Store(10, FISF)
              ToBuffer(DeRefOf(Index(Arg3, 0)), Local0)// Local0 has input
              Mid (Local0, 0, 1, BUFF) //BUFF has input payload
              //
              // Triggle the SMI interrupt
              //
              Store (FISS, IOB2)

              if (LEqual (FIS1, 0)) {
                Return (Buffer () {0, 0, 0, 0})
              }
              Else
              {
                Name(PD10, Package() {Buffer (4) {}})
                CreateDWordField (DerefOf(Index(PD10, 0)), 0, VARF)
                Store(FIS1, VARF)
                Return (PD10)
              }
            }
            Case(11) {
              // Get Supported Modes (Function Index 11)
              Store(11, FISF)
              Store (FISS, IOB2)
              if (LEqual (FIS1, 0)) {
                //copy data from Buff starting at 0 and of length 2 bytes to Local0
                Mid (BUFF, 0,  2, Local0) //Local0 has read buffer
                //create Local1 of size (4 + 2)
                Store (Buffer (Add (4, 2)) {}, Local1)
                //In Local1, define DW field RS11 from offset 0
                CreateDWordField (Local1, 0, RS11)
                Store(0, RS11)
                //create field RD11 in Local1 from offset 32bits and size 2
                CreateField (Local1, BITS (4), BITS (2), RD11)
                Store(Local0, RD11)

                Store (0, INDX)
                While(LLess(INDX, 2)) {
                  Store(DeRefOf(Index(Local1,INDX)), Local7)
                }
                Return(Local1)
              }
              Else
              {
                Name(PD11, Package() {Buffer (6) {}})
                CreateDWordField (DerefOf(Index(PD11, 0)), 0, VARG)
                Store(FIS1, VARG)
                Return (PD11)
              }
            }
            Case(12) {
              // Get FW Info (Function Index 12)
              Store(12, FISF)
              Store (FISS, IOB2)
              if (LEqual (FIS1, 0)) {
                Store(FIS2, Local3) //store return length in Local3
                //copy data from Buff starting at 0 and of length Local3 to Local0
                Mid (BUFF, 0, Local3, Local0) //Local0 has read buffer
                //create Local1 of size (Local3 + 4)
                Store (Buffer (Add (Local3, 4)) {}, Local1)
                //In Local1, define DW field RS12 from offset 0
                CreateDWordField (Local1, 0, RS12)
                Store(0, RS12)
                //create field RD12 in Local1 from offset 32bits and size Local3
                CreateField (Local1, BITS (4), BITS (Local3), RD12)
                Store(Local0, RD12)

                Store("Local6", Debug)
                Store (0, INDX)
                While(LLess(INDX, 44)) {
                  Store(DeRefOf(Index(Local1,INDX)), Local7)
                  Increment(INDX)
                  }
                Store(Local1, Debug)
                Return(Local1)
              }
              Else
              {
                Name(PD12, Package() {Buffer (44) {}})
                CreateDWordField (DerefOf(Index(PD12, 0)), 0, VARH)
                Store(FIS1, VARH)
                Return (PD12)
              }
            }
            Case(17) {
              // Set SMART Threshold (Function Index 17)
              Store(17, FISF)
              // read input payload of size 7 bytes from Arg3
              ToBuffer(DeRefOf(Index(Arg3, 0)), BUFF)
              Mid (BUFF, 0,  7, Local0) //Local0 has read buffer
              Store (0, INDX)
              While(LLess(INDX, 7)) {
                Store(DeRefOf(Index(Local0,INDX)), Local7)
                Increment(INDX)
              }
              ToBuffer (DeRefOf (Index (Arg3, 0)), Local6)
              //
              // Triggle the SMI interrupt
              //
              Store (FISS, IOB2)
              if (LEqual (FIS1, 0)) {
                Return (0x00)
              }
              Else
              {
                //03 Invalid Input Parameters Returned If any threshold value requested to be enabled is invalid.
               Return (0x03)
              }
            } //end of case17
            Default {
              Return (Buffer () {0, 0, 0, 0})
            }
          } //end of switch
        } //end of NVD1 DSM
      } // end of NVD1
    } // end of namespace
  }
}
