/**@file
  VMD device description

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2019 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

External(\_SB.PC00.VMD0, DeviceObj)

If(LAnd(CondRefOf(VMDE),CondRefOf(\_SB.PC00.VMD0))) {
  Scope(\_SB.PC00)
  {
    If(LEqual(VMDE,1)) {
      Scope(VMD0) {
        External(RP01, DeviceObj)
        External(RP02, DeviceObj)
        External(RP03, DeviceObj)
        External(RP04, DeviceObj)
        External(RP05, DeviceObj)
        External(RP06, DeviceObj)
        External(RP07, DeviceObj)
        External(RP08, DeviceObj)
        External(RP09, DeviceObj)
        External(RP10, DeviceObj)
        External(RP11, DeviceObj)
        External(RP12, DeviceObj)
        External(RP13, DeviceObj)
        External(RP14, DeviceObj)
        External(RP15, DeviceObj)
        External(RP16, DeviceObj)
        External(RP17, DeviceObj)
        External(RP18, DeviceObj)
        External(RP19, DeviceObj)
        External(RP20, DeviceObj)
        External(RP21, DeviceObj)
        External(RP22, DeviceObj)
        External(RP23, DeviceObj)
        External(RP24, DeviceObj)

        External(PEG0, DeviceObj)

        External(PRT0, DeviceObj)
        External(PRT1, DeviceObj)
        External(PRT2, DeviceObj)
        External(PRT3, DeviceObj)
        External(PRT4, DeviceObj)
        External(PRT5, DeviceObj)
        External(PRT6, DeviceObj)
        External(PRT7, DeviceObj)

        External(VMR1)
        External(VMR2)
        External(VMR3)
        External(VMCP)
        External(VMS0)
        External(VMS1)
        External(VMS2)
        External(VMS3)
        External(VMS4)
        External(VMS5)
        External(VMS6)
        External(VMS7)

        External(HBSL)

        If(LAnd(CondRefOf(VMR1),CondRefOf(HBSL))) {
          If(LAnd((VMR1 & 0x01),LNot((HBSL & 0x01)))) {
            Scope(RP01) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR1 & 0x02),LNot((HBSL & 0x01)))) {
            Scope(RP02) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR1 & 0x04),LNot((HBSL & 0x01)))) {
            Scope(RP03) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR1 & 0x08),LNot((HBSL & 0x01)))) {
            Scope(RP04) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR1 & 0x10),LNot((HBSL & 0x02)))) {
            Scope(RP05) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR1 & 0x20),LNot((HBSL & 0x02))))  {
            Scope(RP06) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR1 & 0x40),LNot((HBSL & 0x02))))  {
            Scope(RP07) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR1 & 0x80),LNot((HBSL & 0x02))))  {
            Scope(RP08) {
              Include("Rtd3VmdPciePort.asl")
            }
          }
        }

        If(LAnd(CondRefOf(VMR2),CondRefOf(HBSL))) {
          If(LAnd((VMR2 & 0x01),LNot((HBSL & 0x04)))) {
            Scope(RP09) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR2 & 0x02),LNot((HBSL & 0x04)))) {
            Scope(RP10) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR2 & 0x04),LNot((HBSL & 0x04)))) {
            Scope(RP11) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR2 & 0x08),LNot((HBSL & 0x04)))) {
            Scope(RP12) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR2 & 0x10),LNot((HBSL & 0x08)))) {
            Scope(RP13) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR2 & 0x20),LNot((HBSL & 0x08)))) {
            Scope(RP14) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR2 & 0x40),LNot((HBSL & 0x08)))) {
            Scope(RP15) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR2 & 0x80),LNot((HBSL & 0x08)))) {
            Scope(RP16) {
              Include("Rtd3VmdPciePort.asl")
            }
          }
        }

        If(LAnd(CondRefOf(VMR3),CondRefOf(HBSL))) {
          If(LAnd((VMR3 & 0x01),LNot((HBSL & 0x10)))) {
            Scope(RP17) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR3 & 0x02),LNot((HBSL & 0x10)))) {
            Scope(RP18) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR3 & 0x04),LNot((HBSL & 0x10)))) {
            Scope(RP19) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR3 & 0x08),LNot((HBSL & 0x10)))) {
            Scope(RP20) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR3 & 0x10),LNot((HBSL & 0x20)))) {
            Scope(RP21) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR3 & 0x20),LNot((HBSL & 0x20)))) {
            Scope(RP22) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR3 & 0x40),LNot((HBSL & 0x20)))) {
            Scope(RP23) {
              Include("Rtd3VmdPciePort.asl")
            }
          }

          If(LAnd((VMR3 & 0x80),LNot((HBSL & 0x20)))){
            Scope(RP24) {
              Include("Rtd3VmdPciePort.asl")
            }
          }
        }

        If(CondRefOf(VMCP)) {
          If(LEqual(VMCP,1)) {
            Scope(PEG0) {
              Include("Rtd3VmdPciePort.asl")
            }
          }
        }

        If(CondRefOf(VMS0)) {
          If(LEqual(VMS0,1)) {
            Scope(PRT0) {
              Include("Rtd3VmdSataPort.asl")
            }
          }
        }

        If(CondRefOf(VMS1)) {
          If(LEqual(VMS1,1)) {
            Scope(PRT1) {
              Include("Rtd3VmdSataPort.asl")
            }
          }
        }

        If(CondRefOf(VMS2)) {
          If(LEqual(VMS2,1)) {
            Scope(PRT2) {
              Include("Rtd3VmdSataPort.asl")
            }
          }
        }

        If(CondRefOf(VMS3)) {
          If(LEqual(VMS3,1)) {
            Scope(PRT3) {
              Include("Rtd3VmdSataPort.asl")
            }
          }
        }

        If(CondRefOf(VMS4)) {
          If(LEqual(VMS4,1)) {
            Scope(PRT4) {
              Include("Rtd3VmdSataPort.asl")
            }
          }
        }

        If(CondRefOf(VMS5)) {
          If(LEqual(VMS5,1)) {
            Scope(PRT5) {
              Include("Rtd3VmdSataPort.asl")
            }
          }
        }

        If(CondRefOf(VMS6)) {
          If(LEqual(VMS6,1)) {
            Scope(PRT6) {
              Include("Rtd3VmdSataPort.asl")
            }
          }
        }

        If(CondRefOf(VMS7)) {
          If(LEqual(VMS7,1)) {
            Scope(PRT7) {
              Include("Rtd3VmdSataPort.asl")
            }
          }
        }
      }
    }
  }
}
