/** @file
  ACPI RTD3 SSDT table for TGL H DDR4 RVP

@copyright
  INTEL CONFIDENTIAL
  Copyright 2017 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

DefinitionBlock (
    "Rtd3.aml",
    "SSDT",
    2,
    "Rtd3",
    "TglH_Rvp",
    0x1000
    )
{
External(RTD3, IntObj)
External(S0ID)
External(OSYS)
External(HGMD)
External(\ECON, IntObj)

External(GBED)
External(SDS9)
Include ("Rtd3Common.asl")

External(\_SB.PC00.HDAS, DeviceObj)
External(\_SB.PC00.HDAS.VDID)
External(PEPC)
External(WRTO)
External(PRST)
External(WPRP)
External(WFCP)
External(PFCP)
External(WWKP)
External(WBRS)
External(PBRS)
External(GPDI)
External(GPLI)
External(GPLP)
External(GPLR)
External(GPI1)
External(TPP1)
External(TPR1)
External(PPDI)
External(PPLI)
External(PPLP)
External(PPLR)
External(PPI1)
External(PPP1)
External(PPR1)
External(PSWP)
External(RPNB)
External(PSPE)
External(PPSP)
External(PSPR)
External(PPSR)
External(PSW2)
External(RPN2)
External(PSP2)
External(PS2P)
External(PSR2)
External(SR2P)
External(WLWK)
External(SATP)
External(STPP)
External(SSDP)
External(SDPP)
External(SSDR)
External(SDRP)
External(SD2P)
External(SDP1)
External(SD2R)
External(SDR1)
External(S2DR)
External(S2RP)
External(S2DP)
External(S2PP)
External(TPLS)
External(SLTS)
External(\_SB.PEPD, DeviceObj)
External(\_SB.GHPO, MethodObj)
External(\_SB.SHPO, MethodObj)

External(PAPE)
External(PAPP)
External(PARE)
External(PARP)
External(PAWK)
External(PART)
External(PBPE)
External(PBPP)
External(PBRE)
External(PBRP)
External(PBWK)
External(PBRT)
External(PCPE)
External(PCPP)
External(PCRE)
External(PCRP)
External(PCWK)
External(PCRT)

External(\_SB.PC00.XHCI.RHUB.HS03, DeviceObj)
External(\_SB.PC00.RP03.PXSX.WIST, MethodObj)
External(\_SB.GBTR, MethodObj)
External(\_SB.BTRK, MethodObj)
External(\_SB.PC00.UA00.BTH0, DeviceObj)
External(\_SB.PC00.I2C0, DeviceObj) //I2C0 Controller
External(\_SB.PC00.I2C0.TPD0, DeviceObj) // Touch pad
External(\_SB.PC00.I2C0.TPL1, DeviceObj) // Touch panel 2
External(\_SB.PC00.I2C2, DeviceObj) //I2C2 Controller
External(\_SB.PC00.I2C2.TPL1, DeviceObj) // Touch panel 2
External(\_SB.PC00.I2C0.TPL1._STA, MethodObj)
External(\_SB.PC00.I2C1.TPL1._STA, MethodObj)
External(\_SB.PC00.I2C2.TPL1._STA, MethodObj)
External(\_SB.PC00.I2C0.TPD0._STA, MethodObj)

External(\_SB.PC00.PEG0.PEGP, DeviceObj)
External(\_SB.PC00.RP01.PXSX, DeviceObj)
External(\_SB.PC00.RP08.PXSX, DeviceObj)
External(\_SB.PC00.RP09.PXSX, DeviceObj)
External(\_SB.PC00.RP17.PXSX, DeviceObj)
External(\_SB.PC00.RP21.PXSX, DeviceObj)

//
// PCIe root ports - START
//
    ///
    /// PEG PCIE RTD3 - PEG PCIE SLOT 1 - X4 CONNECTOR
    ///
    ///  PSWP, 32,     // [PcieSlot1WakeGpio                ] Pcie Slot Wake Gpio pin
    ///  PSPE, 32,     // [PcieSlot1PowerEnableGpio         ] Pcie Slot 1 Power Enable Gpio pin
    ///  PPSP, 8,      // [PcieSlot1PowerEnableGpioPolarity ] Pcie Slot 1 Power Enable Gpio pin polarity
    ///  PSPR, 32,     // [PcieSlot1RstGpio                 ] Pcie Slot 1 Rest Gpio pin
    ///  PPSR, 8,      // [PcieSlot1RstGpioPolarity         ] Pcie Slot 1 Rest Gpio pin polarity
    Scope(\_SB.PC00.PEG0) {
      Name(RSTG, Package() {0, 0})
      Store(PSPR, Index(RSTG, 0)) // Pcie Slot 1 Reset Gpio pin
      Store(PPSR, Index(RSTG, 1)) // Pcie Slot 1 Reset Gpio pin polarity
      Name(PWRG, Package() {0, 0})
      Store(PSPE, Index(PWRG, 0)) // Pcie Slot 1 Power Enable Gpio pin
      Store(PPSP, Index(PWRG, 1)) // Pcie Slot 1 Power Enable Gpio pin polarity
      Name(WAKG, 0)
      Store(PSWP, WAKG)           // Pcie Slot Wake Gpio pin
      Name(WAKP, 0)
      Name(SCLK, 7)
      Include("Rtd3CpuPcie.asl")
      ///
      /// PCIe RTD3 - CPU M.2 SSD RTD3
      ///
      ///  SD2P, 32,     // [M2Ssd2PowerEnableGpio         ] PCIe x4 M.2 SSD Power Enable Gpio pin
      ///  SDP1, 8,      // [M2Ssd2PowerEnableGpioPolarity ] PCIe x4 M.2 SSD Power Enable Gpio pin polarity
      ///  SD2R, 32,     // [M2Ssd2RstGpio                 ] PCIe x4 M.2 SSD Reset Gpio pin
      ///  SDR1, 8,      // [M2Ssd2RstGpioPolarity         ] PCIe x4 M.2 SSD Reset Gpio pin polarity
      Scope(\_SB.PC00.PEG0.PEGP) {
        ///
        /// If AHCI/NVMe drive connected to GEN4 PCIe controller, change GPIO configuration for it
        ///
        If(LEqual(SLTS,1)) {
          Store(SD2R, Index(RSTG, 0)) // PCIe x4 M.2 SSD Reset Gpio pin
          Store(SDR1, Index(RSTG, 1)) // PCIe x4 M.2 SSD Reset Gpio pin polarity
          Store(SD2P, Index(PWRG, 0)) // PCIe x4 M.2 SSD Power Enable Gpio pin
          Store(SDP1, Index(PWRG, 1)) // PCIe x4 M.2 SSD Power Enable Gpio pin polarity
          Store(0, WAKG)              // Pcie Slot Wake Gpio pin
        }
        Name (SD3E, 1)
        Include("Rtd3PcieSsdStorage.asl")
      }
    }

    ///  PAPE, 32,     // [PegSlotAPwrEnableGpioNo] PEG slot A power enable gpio
    ///  PAPP, 8,      // [PegSlotAPwrEnableGpioPolarity] power enable polarity
    ///  PARE, 32,     // [PegSlotARstGpioNo] PEG slot A reset gpio
    ///  PARP, 8,      // [PegSlotARstGpioPolarity] reset polarity
    ///  PAWK, 32,     // [PegSlotAWakeGpioPin] PEG slot A wake gpio
    ///  PART, 8,      // [PegSlotARootPort] PEG slot A Root Port
    Scope(\_SB.PC00.PEG1) {
      Name(RSTG, Package() {0, 0})
      Store(PARE, Index(RSTG, 0))
      Store(PARP, Index(RSTG, 1))
      Name(PWRG, Package() {0, 0})
      Store(PAPE, Index(PWRG, 0))
      Store(PAPP, Index(PWRG, 1))
      Name(WAKG, 0)
      Store(PAWK, WAKG)
      Name(WAKP, 0)
      Name(SCLK, 9)
      Include("Rtd3CpuPcie.asl")
    }

    ///  PBPE, 32,     // [PegSlotBPwrEnableGpioNo] PEG slot B power enable gpio
    ///  PBPP, 8,      // [PegSlotBPwrEnableGpioPolarity] power enable polarity
    ///  PBRE, 32,     // [PegSlotBRstGpioNo] PEG slot B reset gpio
    ///  PBRP, 8,      // [PegSlotBRstGpioPolarity] reset polarity
    ///  PBWK, 32,     // [PegSlotBWakeGpioPin] PEG slot B wake gpio
    ///  PBRT, 8,      // [PegSlotBRootPort] PEG slot B Root Port
    Scope(\_SB.PC00.PEG2) {
      Name(RSTG, Package() {0, 0})
      Store(PBRE, Index(RSTG, 0))
      Store(PBRP, Index(RSTG, 1))
      Name(PWRG, Package() {0, 0})
      Store(PBPE, Index(PWRG, 0))
      Store(PBPP, Index(PWRG, 1))
      Name(WAKG, 0)
      Store(PBWK, WAKG)
      Name(WAKP, 0)
      Name(SCLK, 3)
      Include("Rtd3CpuPcie.asl")
    }

    ///  PCPE, 32,     // [PegSlotCPwrEnableGpioNo] PEG slot C power enable gpio
    ///  PCPP, 8,      // [PegSlotCPwrEnableGpioPolarity] power enable polarity
    ///  PCRE, 32,     // [PegSlotCRstGpioNo] PEG slot C reset gpio
    ///  PCRP, 8,      // [PegSlotCRstGpioPolarity] reset polarity
    ///  PCWK, 32,     // [PegSlotCWakeGpioPin] PEG slot C wake gpio
    ///  PCRT, 8,      // [PegSlotCRootPort] PEG slot C Root Port
    ///
    Scope(\_SB.PC00.PEG3) {
      Name(RSTG, Package() {0, 0})
      Store(PCRE, Index(RSTG, 0))
      Store(PCRP, Index(RSTG, 1))
      Name(PWRG, Package() {0, 0})
      Store(PCPE, Index(PWRG, 0))
      Store(PCPP, Index(PWRG, 1))
      Name(WAKG, 0)
      Store(PCWK, WAKG)
      Name(WAKP, 0)
      Name(SCLK, 4)
      Include("Rtd3CpuPcie.asl")
    }

    ///
    /// PCH PCIe x4 SLOT 1
    ///
    If(LNotEqual(HGMD,2)) {
      Scope(\_SB.PC00.RP21) {
        Name(RSTG, Package() {0, 0})
        Store(PSPR, Index(RSTG, 0))
        Store(PPSR, Index(RSTG, 1))
        Name(PWRG, Package() {0, 0})
        Store(PSPE, Index(PWRG, 0))
        Store(PPSP, Index(PWRG, 1))
        Name(WAKG, 0)
        Store(PSWP, WAKG)
        Name(WAKP, 0)
        Name(SCLK, 0)
        Include("Rtd3Pcie.asl")
      }
    }

    ///
    /// PCH PCIE x4 SLOT 2
    ///
    If(LNotEqual(HGMD,2)) {
      Scope(\_SB.PC00.RP01) {
        Name(RSTG, Package() {0, 0})
        Store(PSR2, Index(RSTG, 0))
        Store(SR2P, Index(RSTG, 1))
        Name(PWRG, Package() {0, 0})
        Store(PSP2, Index(PWRG, 0))
        Store(PS2P, Index(PWRG, 1))
        Name(WAKG, 0)
        Store(PSW2, WAKG)
        Name(WAKP, 0)
        Name(SCLK, 1)
        Include("Rtd3Pcie.asl")
      }
    }

    ///
    /// PCH PCIe x4 M.2 SSD #1
    ///
    Scope(\_SB.PC00.RP17) {
      Name(RSTG, Package() {0, 0})
      Store(SSDR, Index(RSTG, 0))
      Store(SDRP, Index(RSTG, 1))
      Name(PWRG, Package() {0, 0})
      Store(SSDP, Index(PWRG, 0))
      Store(SDPP, Index(PWRG, 1))
      Name(WAKG, 0)
      Name(WAKP, 0)
      Name(SCLK, 5)
      Include("Rtd3Pcie.asl")
      Scope(\_SB.PC00.RP17.PXSX) {
        Name (SD3E, 1)
        Include("Rtd3PcieSsdStorage.asl")
      }
    }

    ///
    /// PCH PCIe x4 M.2 SSD #2
    ///
    Scope(\_SB.PC00.RP09) {
      Name(RSTG, Package() {0, 0})
      Store(S2DR, Index(RSTG, 0))
      Store(S2RP, Index(RSTG, 1))
      Name(PWRG, Package() {0, 0})
      Store(S2DP, Index(PWRG, 0))
      Store(S2PP, Index(PWRG, 1))
      Name(WAKG, 0)
      Name(WAKP, 0)
      Name(SCLK, 6)
      Include("Rtd3Pcie.asl")
      Scope(\_SB.PC00.RP09.PXSX) {
        Name (SD3E, 1)
        Include("Rtd3PcieSsdStorage.asl")
      }
    }
//
// PCIe root ports - END
//

//
// USB - START
//
// Note:- The USB3/2 Type-A ports doesnt require D3 cold. Since these are user connectable
// ports and needs device insertion detection to enumerate the device with screen off.
// USB3 controller should attain Link down state which is supported as part of spec for USB3.
Include ("Rtd3UsbCommon.asl")  // Do not remove this file.

If (LEqual(And(RCG0, 0x08), 0x08)) {
  Include ("Rtd3Cnvi.asl")
  If (LOr (LAnd (LEqual (\_SB.PC00.CNIP (), 1), LEqual (CBTC, 1)), LEqual (\_SB.PC00.RP03.PXSX.WIST (), 1))) {
    Scope(\_SB.PC00.XHCI.RHUB.HS14) {
      If (\_SB.PC00.RP03.PXSX.WIST ()){
        //
        // Power resource object for CNVd BT
        //
        PowerResource (DBTP, 0, 0)
        {
          Method(_STA, 0)
          {
            If(LEqual (\_SB.GBTR (), 1)) {
              Return (0x1)
            } Else {
              Return (0x0)
            }
          }
          Method(_ON, 0, Serialized) { // Turn on BT Core
            \_SB.BTRK (0x01)
          }
          Method(_OFF, 0, Serialized) { // Turn off BT Core
            \_SB.BTRK (0x00)
          }
        }
      }
      Name(_S0W, 2) // S0 Device Wake State
      Method(_PR0) {
        If (\_SB.PC00.CNIP ()) {
          Return (Package(){BTPR})
        }
        If (\_SB.PC00.RP03.PXSX.WIST ()){
          Return (Package(){DBTP})
        }
        Return(Package(){}) // - Return NULL Power Package if BT is not present.
      }
      Method(_PR2) {
        If (\_SB.PC00.CNIP ()) {
          Return (Package(){BTPR})
        }
        If (\_SB.PC00.RP03.PXSX.WIST ()){
          Return (Package(){DBTP})
        }
        Return(Package(){}) // - Return NULL Power Package if BT is not present.
      }
      Method(_PR3) {
        If (\_SB.PC00.CNIP ()) {
          Return (Package(){BTPR})
        }
        If (\_SB.PC00.RP03.PXSX.WIST ()){
          Return (Package(){DBTP})
        }
        Return(Package(){}) // - Return NULL Power Package if BT is not present.
      }
    } // Scope(\_SB.PC00.XHCI.RHUB.HS14)
  }

  //
  // Report BT power resource if CNVd BT is UART.
  //
  If (LEqual (SDS9, 2)) { // Only required for CNVd BT over UART selection
    Scope (\_SB.PC00.UA00.BTH0) {
      Method(_PS0, 0, Serialized)
      {
        \_SB.BTRK (0x01) // Turn on BT
      }
      Method(_PS3, 0, Serialized)
      {
        \_SB.BTRK (0x00) // Turn off BT
      }
    }
  }
}

External(XDCE)
//
// XDCI - start
//
  If(LEqual(XDCE,1)) {
    Scope(\_SB)
    {
      //
      // Dummy power resource for USB D3 cold support
      //
      PowerResource(USBC, 0, 0)
      {
        Method(_STA) { Return (0xF) }
        Method(_ON) {}
        Method(_OFF) {}
      }
    }

    Scope(\_SB.PC00.XDCI)
    {
      OperationRegion (GENR, SystemMemory, Add(And(XDCB, 0xFFFFFFFFFFFFFF00), 0x10F81C), 0x4)  //AON MMIO - 10F81C: APBFC_U3PMU_CFG5
      Field (GENR, WordAcc, NoLock, Preserve)
      {
            ,   2,
        CPME,   1,    //bit2 core_pme_en
        U3EN,   1,    //bit3 u3_pme_en
        U2EN,   1     //bit4 u2_pme_en
      }

      Method (_PS3, 0, NotSerialized)
      {
        Store (One, CPME)
        Store (One, U2EN)
        Store (One, U3EN)

        \_SB.CSD3(MODPHY_SPD_GATING_XDCI)
      }
      Method (_PS0, 0, NotSerialized)
      {
        Store (Zero, CPME)
        Store (Zero, U2EN)
        Store (Zero, U3EN)

        If(LEqual(DVID,0xFFFF)) {
          Return(Zero)
        }

        \_SB.CSD0(MODPHY_SPD_GATING_XDCI)
      }

      Method (_RMV, 0, NotSerialized)  // _RMV: Removal Status
      {
        Return (Zero)
      }

      Method (_PR3, 0, NotSerialized)  // _PR3: Power Resources for D3hot
      {
        Return (Package (0x01)
        {
          USBC // return dummy package
        })
      }
    } // Scope(\_SB.PC00.XDCI)
  } // XDCE
//
// XDCI - end
//
// USB - END
//

//
//GPE Event handling - Start
//
  Scope(\_GPE) {
    //
    // Alternate _L6F(), to handle 2-tier RTD3 GPE events here
    //
    Method(AL6F) {
      If(LNotEqual(HGMD,2)) {
        // X4 PCIe Connector (SLOT1) wake event
        If (\_SB.ISME(PSWP)) // check for wake event
        {
          \_SB.SHPO(PSWP, 1) // set gpio ownership to driver(0=ACPI mode, 1=GPIO mode)
          If(LNotEqual(\_SB.PC00.PEG0.VDID,0xFFFFFFFF)) { // If AHCI/NVMe drive is present on PEG0 port
            Notify(\_SB.PC00.PEG0, 0x02)   // device wake
          }
          If(LNotEqual(\_SB.PC00.PEG1.VDID,0xFFFFFFFF)) { // If Device is present on PEG1 port
            Notify(\_SB.PC00.PEG1, 0x02)   // device wake
          }
          If(LNotEqual(\_SB.PC00.PEG2.VDID,0xFFFFFFFF)) { // If Device is present on PEG2 port
            Notify(\_SB.PC00.PEG2, 0x02)   // device wake
          }
          If(LNotEqual(\_SB.PC00.PEG3.VDID,0xFFFFFFFF)) { // If Device is present on PEG3 port
            Notify(\_SB.PC00.PEG3, 0x02)   // device wake
          }
          If(LNotEqual(\_SB.PC00.RP05.VDID, 0xFFFFFFFF)) {
            Notify(\_SB.PC00.RP05, 0x02)   // device wake
          }
          \_SB.CAGS(PSWP)
        }
      }

      // PCH PCIE x4 SLOT 2
      If (\_SB.ISME(PSW2)) // check for wake event
      {
        \_SB.SHPO(PSW2, 1) // set gpio ownership to driver(0=ACPI mode, 1=GPIO mode)
        Notify(\_SB.PC00.RP01, 0x02)     // Device Wake
        \_SB.CAGS(PSW2)    // Pcie Slot 2 Wake Gpio pin
      }

      // PCH PCIe M.2 WiFi x1
      If (\_SB.ISME(WLWK)) // check for wake event
      {
        \_SB.SHPO(WLWK, 1) // set gpio ownership to driver(0=ACPI mode, 1=GPIO mode)
        Notify(\_SB.PC00.RP08, 0x02)     // Device Wake
        \_SB.CAGS(WLWK)    // WIFI_WAKE_N
      }

      // PCH PCIe x4 SLOT 1
      If (\_SB.ISME(PSWP)) // check for wake event
      {
        \_SB.SHPO(PSWP, 1) // set gpio ownership to driver(0=ACPI mode, 1=GPIO mode)
        Notify(\_SB.PC00.RP21, 0x02)     // Device Wake
        \_SB.CAGS(PSWP)    // PCIe x4 SLOT 1 wake pin
      }

    } // Method (AL6F)
  } //Scope(\_GPE)
//
//GPE Event handling - End
//
} // End SSDT
