## @file
#  This is the overall description file for the BoardPkg. This includes other scope-specific
#  description files such PCD scope or build options scope to help build the overall Board
#  support for the project.
#
#  Adding list of all Library Classes and Modules/Drivers needed to build this Platform.
#  For Example- Information file for BoardConfigLib.
#  BoardConfigLib|$(PLATFORM_BOARD_PACKAGE)/Library/PeiBoardConfigLib/PeiBoardConfigLib.inf
#
# @copyright
#  INTEL CONFIDENTIAL
#  Copyright 2018 - 2020 Intel Corporation.
#
#  The source code contained or described herein and all documents related to the
#  source code ("Material") are owned by Intel Corporation or its suppliers or
#  licensors. Title to the Material remains with Intel Corporation or its suppliers
#  and licensors. The Material may contain trade secrets and proprietary and
#  confidential information of Intel Corporation and its suppliers and licensors,
#  and is protected by worldwide copyright and trade secret laws and treaty
#  provisions. No part of the Material may be used, copied, reproduced, modified,
#  published, uploaded, posted, transmitted, distributed, or disclosed in any way
#  without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure or delivery
#  of the Materials, either expressly, by implication, inducement, estoppel or
#  otherwise. Any license under such intellectual property rights must be
#  express and approved by Intel in writing.
#
#  Unless otherwise agreed by Intel in writing, you may not remove or alter
#  this notice or any other notice embedded in Materials by Intel or
#  Intel's suppliers or licensors in any way.
#
#  This file contains a 'Sample Driver' and is licensed as such under the terms
#  of your license agreement with Intel or your vendor. This file may be modified
#  by the user, subject to the additional terms of the license agreement.
#
# @par Specification
##
[Defines]
  #
  # Set platform specific package/folder name, same as passed from PREBUILD script.
  # PLATFORM_PACKAGE would be the same as PLATFORM_NAME as well as package build folder
  # DEFINE only takes effect at R9 DSC and FDF.
  #
  DEFINE      PLATFORM_PACKAGE                = MinPlatformPkg
  DEFINE      PLATFORM_FULL_PACKAGE           = TigerLakePlatSamplePkg
  DEFINE      PLATFORM_SI_PACKAGE             = ClientOneSiliconPkg
  DEFINE      C1S_PRODUCT_PATH                = ClientOneSiliconPkg/Product/TigerLake
  DEFINE      CLIENT_COMMON_PACKAGE           = ClientCommonPkg
  DEFINE      PLATFORM_FSP_BIN_PACKAGE        = TigerLakeFspBinPkg
  DEFINE      PLATFORM_BOARD_PACKAGE          = TigerLakeBoardPkg
  DEFINE      PLATFORM_OPEN_BOARD_PACKAGE     = TigerLakeOpenBoardPkg
  DEFINE      PLATFORM_FEATURES_PATH          = $(PLATFORM_FULL_PACKAGE)/Features

#
# Define ESRT GUIDs for Firmware Management Protocol instances
#
  DEFINE FMP_CLIENT_PLATFORM_SYSTEM_MONO          = 7FEB1D5D-33F4-48D3-BD11-C4B36B6D0E57 # gFmpDevicePlatformMonolithicGuid
  DEFINE FMP_CLIENT_PLATFORM_SYSTEM_BIOS          = 6C8E136F-D3E6-4131-AC32-4687CB4ABD27 # gFmpDevicePlatformBiosGuid
  DEFINE FMP_CLIENT_PLATFORM_SYSTEM_BTGACM        = 4E88068B-41B2-4E05-893C-DB0B43F7D348 # gFmpDevicePlatformBtGAcmGuid
  DEFINE FMP_CLIENT_PLATFORM_SYSTEM_UCODE         = 69585D92-B50A-4AD7-B265-2EB1AE066574 # gFmpDevicePlatformuCodeGuid
  DEFINE FMP_CLIENT_PLATFORM_SYSTEM_ME            = 0EAB05C1-766A-4805-A039-3081DE0210C7 # gFmpDevicePlatformMeGuid
  DEFINE FMP_CLIENT_PLATFORM_SYSTEM_EC            = 3DD84775-EC79-4ECB-8404-74DE030C3F77 # gFmpDevicePlatformEcGuid
  DEFINE FMP_CLIENT_PLATFORM_SYSTEM_ISH_PDT       = 76CA0AD8-4A14-4389-B7E5-FD88791762AD # gFmpDevicePlatformIshPdtGuid
  DEFINE FMP_CLIENT_PLATFORM_SYSTEM_TSN_MAC_ADDR  = 6FEE88FF-49ED-48F1-B77B-EAD15771ABE7 # gFmpDevicePlatformTsnMacAddrGuid
  DEFINE FMP_CLIENT_PLATFORM_TBT_RETIMER          = 2FE2CBFC-B9AA-4A93-AB5B-40173B581C42
  DEFINE FMP_CLIENT_PLATFORM_TCI2C_RETIMER        = 9FE02F9C-5BDA-4971-A918-B79451B43E43
#
# Defines Boards paths
#
  DEFINE      BOARD_TGL_U_BOARDS                = TigerLakeUBoards
  DEFINE      PROJECT_TGL_U_BOARDS              = $(PLATFORM_BOARD_PACKAGE)/$(BOARD_TGL_U_BOARDS)
  DEFINE      BOARD_TGL_H_BOARDS                = TigerLakeHBoards
  DEFINE      PROJECT_TGL_H_BOARDS              = $(PLATFORM_BOARD_PACKAGE)/$(BOARD_TGL_H_BOARDS)
  DEFINE      BOARD_TGL_Y_BOARDS                = TigerLakeYBoards
  DEFINE      PROJECT_TGL_Y_BOARDS              = $(PLATFORM_BOARD_PACKAGE)/$(BOARD_TGL_Y_BOARDS)
  #
  # Platform On/Off features are defined here
  #
  !include BoardPkgConfigDefault.dsc
  !include BoardPkgConfig.dsc
  !include BoardPkgPcd.dsc

  #
  # @Todo: Need to check if the copies from TigerLakeSvRestrictedPkg are required or not
################################################################################
#
# Defines Section - statements that will be processed to create a Makefile.
#
################################################################################
[Defines]
  PLATFORM_NAME                       = $(PLATFORM_BOARD_PACKAGE)
  PLATFORM_GUID                       = EB89E595-7D9D-4422-A277-A50B5AFD3E16
  PLATFORM_VERSION                    = 0.1
  DSC_SPECIFICATION                   = 0x00010005
  OUTPUT_DIRECTORY                    = Build/$(PLATFORM_BOARD_PACKAGE)
  SUPPORTED_ARCHITECTURES             = IA32|X64
  BUILD_TARGETS                       = DEBUG|RELEASE
  SKUID_IDENTIFIER                    = ALL


  FLASH_DEFINITION                    = $(PLATFORM_BOARD_PACKAGE)/BoardPkg.fdf

  FIX_LOAD_TOP_MEMORY_ADDRESS         = 0x0
  DEFINE   TOP_MEMORY_ADDRESS         = 0x0

  #
  # Default value for BoardPkg.fdf use
  #
  DEFINE BIOS_SIZE_OPTION = SIZE_120

  #
  # Map Network Feature PCD to macro setting used in NetworkPkg/NetworkDefines.dsc.inc
  #
  !if gPlatformModuleTokenSpaceGuid.PcdNetworkEnable == TRUE
    DEFINE NETWORK_ENABLE                 = TRUE
  !else
    DEFINE NETWORK_ENABLE                 = FALSE
  !endif
  !if gPlatformModuleTokenSpaceGuid.PcdNetworkIp6Enable == TRUE
    DEFINE NETWORK_IP6_ENABLE             = TRUE
  !else
    DEFINE NETWORK_IP6_ENABLE             = FALSE
  !endif
  !if gPlatformModuleTokenSpaceGuid.PcdNetworkIscsiEnable == TRUE
    DEFINE NETWORK_ISCSI_ENABLE           = TRUE
  !else
    DEFINE NETWORK_ISCSI_ENABLE           = FALSE
  !endif
  !if gPlatformModuleTokenSpaceGuid.PcdNetworkVlanEnable == TRUE
    DEFINE NETWORK_VLAN_ENABLE            = TRUE
  !else
    DEFINE NETWORK_VLAN_ENABLE            = FALSE
  !endif
  DEFINE NETWORK_TLS_ENABLE               = TRUE
  DEFINE NETWORK_HTTP_BOOT_ENABLE         = TRUE
  !include NetworkPkg/NetworkDefines.dsc.inc

################################################################################
#
# SKU Identification section - list of all SKU IDs supported by this
#                              Platform.
#
################################################################################
[SkuIds]
  0x00|DEFAULT           # The entry: 0|DEFAULT is reserved and always required.
  0x01|SkuIdTglU
  0x02|SkuIdTglY
  0x03|SkuIdTglH


# Keeping this section as an example to define SKUs that can inherit parent
# properties and define a section by its own identifier as well.

# 0x04|BoardIdTglULp5Type4 | SkuIdTglU
# 0x0A|BoardIdTglUDdr4Erb | SkuIdTglU
# 0x03|BoardIdTglULp4Type4 | SkuIdTglU
# 0x07|BoardIdTglYLp4Sv | SkuIdTglY
# 0x06|BoardIdTglYLp4Type4 | SkuIdTglY
# 0x05|BoardIdTglYExsLp4Type4 | SkuIdTglY
# 0x0D|BoardIdTglULp4Aep | SkuIdTglU
# 0x20|BoardIdTglHDdr4SODimmErb | SkuIdTglH
# 0x30|BoardIdTglSDdr4UDimmErb | SkuIdTglH
################################################################################
#
# DefaultStores section - list of all default stores supported by this
#                              Platform.
#
################################################################################
[DefaultStores]
0|Standard
1|Manufacturing
2|Optimized
################################################################################
#
# Library Class section - list of all Library Classes needed by this Platform.
#
################################################################################

!include $(PLATFORM_PACKAGE)/Include/Dsc/CoreCommonLib.dsc
!include $(PLATFORM_PACKAGE)/Include/Dsc/CorePeiLib.dsc
!include $(PLATFORM_PACKAGE)/Include/Dsc/CoreDxeLib.dsc
!include $(PLATFORM_FULL_PACKAGE)/PlatformCommonLib.dsc
!include $(PLATFORM_FULL_PACKAGE)/PlatformPeiLib.dsc
!include $(PLATFORM_FULL_PACKAGE)/PlatformDxeLib.dsc

[LibraryClasses.common]
  PeiLib|$(PLATFORM_PACKAGE)/Library/PeiLib/PeiLib.inf
  ReportFvLib|$(PLATFORM_BOARD_PACKAGE)/Library/PeiReportFvLib/PeiReportFvLib.inf

  PciHostBridgeLib|$(PLATFORM_PACKAGE)/Pci/Library/PciHostBridgeLibSimple/PciHostBridgeLibSimple.inf
  PciSegmentInfoLib|$(PLATFORM_PACKAGE)/Pci/Library/PciSegmentInfoLibSimple/PciSegmentInfoLibSimple.inf
  PlatformHookLib|$(PLATFORM_BOARD_PACKAGE)/Library/BasePlatformHookLib/BasePlatformHookLib.inf
  PrintLib|MdePkg/Library/BasePrintLib/BasePrintLib.inf

  PeiGetVtdPmrAlignmentLib|IntelSiliconPkg/Library/PeiGetVtdPmrAlignmentLib/PeiGetVtdPmrAlignmentLib.inf

!if gSiPkgTokenSpaceGuid.PcdFspWrapperEnable == TRUE
  FspCommonLib|IntelFsp2Pkg/Library/BaseFspCommonLib/BaseFspCommonLib.inf
  FspWrapperApiLib|IntelFsp2WrapperPkg/Library/BaseFspWrapperApiLib/BaseFspWrapperApiLib.inf
  FspWrapperApiTestLib|IntelFsp2WrapperPkg/Library/PeiFspWrapperApiTestLib/PeiFspWrapperApiTestLib.inf
  SiliconPolicyInitLib|$(PLATFORM_PACKAGE)/PlatformInit/Library/SiliconPolicyInitLibNull/SiliconPolicyInitLibNull.inf
  SiliconPolicyUpdateLib|$(PLATFORM_BOARD_PACKAGE)/Library/PeiSiliconPolicyUpdateLib/PeiSiliconPolicyUpdateLibFsp.inf
  FspSwitchStackLib|IntelFsp2Pkg/Library/BaseFspSwitchStackLib/BaseFspSwitchStackLib.inf
!endif

  PeiBootModeLib|$(PLATFORM_BOARD_PACKAGE)/Library/PeiBootModeLib/PeiBootModeLib.inf

  ConfigBlockLib|IntelSiliconPkg/Library/BaseConfigBlockLib/BaseConfigBlockLib.inf
  SiliconInitLib|$(PLATFORM_BOARD_PACKAGE)/Library/SiliconInitLib/SiliconInitLib.inf
  MmioInitLib|$(PLATFORM_BOARD_PACKAGE)/Library/BaseMmioInitLib/BaseMmioInitLib.inf

  BoardInitLib|$(PLATFORM_PACKAGE)/PlatformInit/Library/BoardInitLibNull/BoardInitLibNull.inf
  TestPointCheckLib|$(PLATFORM_PACKAGE)/Test/Library/TestPointCheckLibNull/TestPointCheckLibNull.inf

  PciSegmentLib|$(PLATFORM_SI_PACKAGE)/Library/BasePciSegmentMultiSegLibPci/BasePciSegmentMultiSegLibPci.inf
  PciExpressLib|$(PLATFORM_SI_PACKAGE)/Library/BasePciExpressMultiSegLib/BasePciExpressMultiSegLib.inf
  PciLib|MdePkg/Library/BasePciLibPciExpress/BasePciLibPciExpress.inf
  BoardIdsLib|$(PLATFORM_BOARD_PACKAGE)/Library/PeiDxeBoardIdsLib/PeiDxeBoardIdsLib.inf
  WakeupEventLib|$(PLATFORM_BOARD_PACKAGE)/Library/WakeupEventLib/WakeupEventLib.inf
  DxeUpdatePlatformInfoLib|$(PLATFORM_BOARD_PACKAGE)/Library/DxeUpdatePlatformInfoLib/DxeUpdatePlatformInfoLib.inf

  PlatformPasswordLib|UserInterface/UserAuthFeaturePkg/Library/PlatformPasswordLibNull/PlatformPasswordLibNull.inf
  UserPasswordLib|UserInterface/UserAuthFeaturePkg/Library/UserPasswordLib/UserPasswordLib.inf
  UserPasswordUiLib|UserInterface/UserAuthFeaturePkg/Library/UserPasswordUiLib/UserPasswordUiLib.inf
  SiMtrrLib|$(PLATFORM_SI_PACKAGE)/Library/SiMtrrLib/SiMtrrLib.inf
!if gSiPkgTokenSpaceGuid.PcdFspWrapperEnable == TRUE
!if gPlatformModuleTokenSpaceGuid.PcdSkipFspTempRamInitAndExit == TRUE
  CacheAsRamLib|$(PLATFORM_SI_PACKAGE)/Library/BaseCacheAsRamLib/BaseCacheAsRamLib.inf
!else
  CacheAsRamLib|IntelFsp2Pkg/Library/BaseCacheAsRamLibNull/BaseCacheAsRamLibNull.inf
!endif
!endif

  DisplayUpdateProgressLib|MdeModulePkg/Library/DisplayUpdateProgressLibGraphics/DisplayUpdateProgressLibGraphics.inf
  PlatformPostCodeMapLib|$(CLIENT_COMMON_PACKAGE)/Library/BasePlatformPostCodeMapLib/BasePlatformPostCodeMapLib.inf
  PlatformBeepMapLib|$(CLIENT_COMMON_PACKAGE)/Library/BasePlatformBeepMapLib/BasePlatformBeepMapLib.inf

  Usb3DebugPortParameterLib|$(CLIENT_COMMON_PACKAGE)/Library/BaseUsb3DebugPortParameterLibCmos/BaseUsb3DebugPortParameterLibCmos.inf

  # TODO: This block of libraries is here because they are a dependency for TigerLakePlatSamplePkg/Setup/Setup.inf
  #       The Setup module needs to be refactored, these need to be refactored, and moved to TigerLakeBoardPkg
  #       over time.
  SerialPortParameterLib|$(CLIENT_COMMON_PACKAGE)/Library/BaseSerialPortParameterLibPcd/BaseSerialPortParameterLibPcd.inf
  PlatformNvRamHookLib|$(PLATFORM_FEATURES_PATH)/Cmos/Library/PlatformNvRamHookLibCmos/PlatformNvRamHookLibCmos.inf
  CmosAccessLib|$(PLATFORM_FEATURES_PATH)/Cmos/Library/CmosAccessLib/CmosAccessLib.inf
  PlatformCmosAccessLib|$(PLATFORM_FEATURES_PATH)/Cmos/Library/PlatformCmosAccessLib/PlatformCmosAccessLib.inf
  BiosIdLib|BoardModulePkg/Library/BiosIdLib/PeiBiosIdLib.inf
#
# Security
#
  !if gSiPkgTokenSpaceGuid.PcdTxtEnable == TRUE
    TpmPlatformHierarchyLib|$(PLATFORM_FEATURES_PATH)/Txt/Library/TpmPlatformHierarchyLib/TpmPlatformHierarchyLib.inf
  !else
    TpmPlatformHierarchyLib|$(PLATFORM_PACKAGE)/Tcg/Library/TpmPlatformHierarchyLib/TpmPlatformHierarchyLib.inf
  !endif # gSiPkgTokenSpaceGuid.PcdTxtEnable

  TpmCommLib|SecurityPkg/Library/TpmCommLib/TpmCommLib.inf

#
# Silicon Init Package
#
!include $(C1S_PRODUCT_PATH)/SiPkgCommonLib.dsc

#
# Features
#
!if gBoardModuleTokenSpaceGuid.PcdSetupEnable == TRUE
  !include $(PLATFORM_BOARD_PACKAGE)/Features/Setup/Include/Dsc/SetupBaseLib.dsc
!endif
!if gPlatformModuleTokenSpaceGuid.PcdRamDebugEnable == TRUE
  RamDebugLib|$(CLIENT_COMMON_PACKAGE)/Library/BaseRamDebugLib/BaseRamDebugLib.inf
!else
  RamDebugLib|$(CLIENT_COMMON_PACKAGE)/Library/BaseRamDebugLibNull/BaseRamDebugLibNull.inf
!endif
CmosAccessLib|$(PLATFORM_FEATURES_PATH)/Cmos/Library/CmosAccessLib/CmosAccessLib.inf
!if gPlatformModuleTokenSpaceGuid.PcdPlatformCmosAccessSupport == TRUE
  PlatformCmosAccessLib|$(PLATFORM_FEATURES_PATH)/Cmos/Library/PlatformCmosAccessLib/PlatformCmosAccessLib.inf
!else
  PlatformCmosAccessLibNull|$(PLATFORM_FEATURES_PATH)/Cmos/Library/PlatformCmosAccessLibNull/PlatformCmosAccessLibNull.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdAmtEnable == TRUE
  BaseAmtWrapperLib|$(PLATFORM_FEATURES_PATH)/Amt/Library/BaseAmtWrapperLib/BaseAmtWrapperLib.inf
!else
  BaseAmtWrapperLib|$(PLATFORM_FEATURES_PATH)/Amt/Library/BaseAmtWrapperLibNull/BaseAmtWrapperLibNull.inf
!endif

  ShellCommandLib|ShellPkg/Library/UefiShellCommandLib/UefiShellCommandLib.inf
  HandleParsingLib|ShellPkg/Library/UefiHandleParsingLib/UefiHandleParsingLib.inf
  BcfgCommandLib|ShellPkg/Library/UefiShellBcfgCommandLib/UefiShellBcfgCommandLib.inf

#
# S3
#
!if gSiPkgTokenSpaceGuid.PcdS3Enable == TRUE
  S3BootScriptLib|MdeModulePkg/Library/PiDxeS3BootScriptLib/DxeS3BootScriptLib.inf
!else
  S3BootScriptLib|MdePkg/Library/BaseS3BootScriptLibNull/BaseS3BootScriptLibNull.inf
!endif
  S3IoLib|MdePkg/Library/BaseS3IoLib/BaseS3IoLib.inf
  S3PciLib|MdePkg/Library/BaseS3PciLib/BaseS3PciLib.inf

  CapsuleLib|MdeModulePkg/Library/DxeCapsuleLibNull/DxeCapsuleLibNull.inf
  FmpAuthenticationLib|MdeModulePkg/Library/FmpAuthenticationLibNull/FmpAuthenticationLibNull.inf
  TcgStorageCoreLib|SecurityPkg/Library/TcgStorageCoreLib/TcgStorageCoreLib.inf
  TcgStorageOpalLib|SecurityPkg/Library/TcgStorageOpalLib/TcgStorageOpalLib.inf
!if gSiPkgTokenSpaceGuid.PcdEmbeddedEnable == 0x1
#
# Sub Region FVs
#
  PeiSubRegionLib|$(PLATFORM_FEATURES_PATH)/SubRegion/PeiSubRegionLib/PeiSubRegionLib.inf

#
# TSN
#
  PeiTsnFvLib|$(PLATFORM_FEATURES_PATH)/Tsn/PeiTsnFvLib/PeiTsnFvLib.inf
!else
  PeiSubRegionLib|$(PLATFORM_FEATURES_PATH)/SubRegion/PeiSubRegionLib/PeiSubRegionLibNull.inf
  PeiTsnFvLib|$(PLATFORM_FEATURES_PATH)/Tsn/PeiTsnFvLib/PeiTsnFvLibNull.inf
!endif

[LibraryClasses.common.PEIM]
  FirmwareBootMediaInfoLib|$(PLATFORM_BOARD_PACKAGE)/Library/PeiFirmwareBootMediaInfoLib/PeiFirmwareBootMediaInfoLib.inf
  # Override PostCodeLib to add trace hub output capability in release build
  PostCodeLib|$(PLATFORM_SI_PACKAGE)/Library/BasePostCodeLibPort80TraceHub/BasePostCodeLibPort80TraceHub.inf

[LibraryClasses.IA32]
#
# PEI phase common
#

  ResetSystemLib|MdeModulePkg/Library/PeiResetSystemLib/PeiResetSystemLib.inf

  TraceHubDebugLib|ClientOneSiliconPkg/Library/TraceHubDebugLibSvenTx/PeiTraceHubDebugLibSvenTx.inf
  PeiGetFvInfoLib|$(PLATFORM_FULL_PACKAGE)/Library/PeiGetFvInfoLib/PeiGetFvInfoLib.inf

!if $(TARGET) == DEBUG
  TestPointCheckLib|$(PLATFORM_PACKAGE)/Test/Library/TestPointCheckLib/PeiTestPointCheckLib.inf
  TestPointCheckLib|$(PLATFORM_PACKAGE)/Test/Library/TestPointCheckLibNull/TestPointCheckLibNull.inf
!endif
  TestPointLib|$(PLATFORM_PACKAGE)/Test/Library/TestPointLib/PeiTestPointLib.inf
  MultiBoardInitSupportLib|$(PLATFORM_PACKAGE)/PlatformInit/Library/MultiBoardInitSupportLib/PeiMultiBoardInitSupportLib.inf
  BoardInitLib|$(PLATFORM_PACKAGE)/PlatformInit/Library/MultiBoardInitSupportLib/PeiMultiBoardInitSupportLib.inf

  BoardConfigLib|$(PLATFORM_BOARD_PACKAGE)/Library/PeiBoardConfigLib/PeiBoardConfigLib.inf

#
# Silicon Init Package
#
!include $(C1S_PRODUCT_PATH)/SiPkgPeiLib.dsc

#
# Features
#
  FirmwareBootMediaLib|IntelSiliconPkg/Library/PeiDxeSmmBootMediaLib/PeiFirmwareBootMediaLib.inf
!if gBoardModuleTokenSpaceGuid.PcdSetupEnable == TRUE
  !include $(PLATFORM_BOARD_PACKAGE)/Features/Setup/Include/Dsc/SetupPeiLib.dsc
!endif

!if gPlatformModuleTokenSpaceGuid.PcdUsb3SerialStatusCodeEnable == TRUE
  Usb3DebugPortLib|Debugging/Usb3DebugFeaturePkg/Library/Usb3DebugPortLib/Usb3DebugPortLibPei.inf
!else
  Usb3DebugPortLib|Debugging/Usb3DebugFeaturePkg/Library/Usb3DebugPortLib/Usb3DebugPortLibNull.inf
!endif

  ProcessorTraceMemoryAllocationLib|$(PLATFORM_SI_PACKAGE)/Library/PeiProcessorTraceMemoryAllocationLib/PeiProcessorTraceMemoryAllocationLib.inf
  PeiOverClockLib|$(PLATFORM_FEATURES_PATH)/OverClocking/OverClockInit/PeiOverClockLib.inf

#
# SmmAccess
#
  SmmAccessLib|IntelSiliconPkg/Feature/SmmAccess/Library/PeiSmmAccessLib/PeiSmmAccessLib.inf

#
# S3
#
  S3BootScriptLib|MdePkg/Library/BaseS3BootScriptLibNull/BaseS3BootScriptLibNull.inf

  MpInitLib|UefiCpuPkg/Library/MpInitLib/PeiMpInitLib.inf

[LibraryClasses.IA32.SEC]
  DebugLib|MdePkg/Library/BaseDebugLibNull/BaseDebugLibNull.inf
  Usb3DebugPortLib|Debugging/Usb3DebugFeaturePkg/Library/Usb3DebugPortLib/Usb3DebugPortLibNull.inf
  TestPointCheckLib|$(PLATFORM_PACKAGE)/Test/Library/TestPointCheckLib/SecTestPointCheckLib.inf
  TestPointCheckLib|$(PLATFORM_PACKAGE)/Test/Library/TestPointCheckLibNull/TestPointCheckLibNull.inf
  SecBoardInitLib|$(PLATFORM_PACKAGE)/PlatformInit/Library/SecBoardInitLibNull/SecBoardInitLibNull.inf
  ResetSystemLib|MdeModulePkg/Library/BaseResetSystemLibNull/BaseResetSystemLibNull.inf
  SerialPortParameterLib|$(CLIENT_COMMON_PACKAGE)/Library/BaseSerialPortParameterLibPcd/BaseSerialPortParameterLibPcd.inf
  SecGetFsptApiParameterLib|$(PLATFORM_SI_PACKAGE)/Library/SecGetFsptApiParameterLib/SecGetFsptApiParameterLib.inf

[LibraryClasses.IA32.PEIM]

!if gSiPkgTokenSpaceGuid.PcdFspWrapperEnable == TRUE
  FspSwitchStackLib|IntelFsp2Pkg/Library/BaseFspSwitchStackLib/BaseFspSwitchStackLib.inf
!endif

!if $(TARGET) == DEBUG
  DebugLib|MdeModulePkg/Library/PeiDebugLibDebugPpi/PeiDebugLibDebugPpi.inf
!endif

  #
  # Use Null library instance to skip MTRR initialization from MinPlatformPkg PlatformInit modules.
  # MTRR configuration will be done by FSP or PlatformInitAdvanced modules.
  #
  SetCacheMtrrLib|$(PLATFORM_PACKAGE)/Library/SetCacheMtrrLib/SetCacheMtrrLibNull.inf

[LibraryClasses.X64]
  #
  # DXE phase common
  #
!if gSiPkgTokenSpaceGuid.PcdFspWrapperEnable == TRUE
  FspWrapperPlatformLib|$(PLATFORM_PACKAGE)/FspWrapper/Library/DxeFspWrapperPlatformLib/DxeFspWrapperPlatformLib.inf
!endif

 TraceHubDebugLib|ClientOneSiliconPkg/Library/TraceHubDebugLibSvenTx/DxeTraceHubDebugLibSvenTx.inf

!if $(TARGET) == DEBUG
  TestPointCheckLib|$(PLATFORM_PACKAGE)/Test/Library/TestPointCheckLib/DxeTestPointCheckLib.inf
  TestPointCheckLib|$(PLATFORM_PACKAGE)/Test/Library/TestPointCheckLibNull/TestPointCheckLibNull.inf
!endif
  TestPointLib|$(PLATFORM_PACKAGE)/Test/Library/TestPointLib/DxeTestPointLib.inf
  MultiBoardInitSupportLib|$(PLATFORM_PACKAGE)/PlatformInit/Library/MultiBoardInitSupportLib/DxeMultiBoardInitSupportLib.inf
  BoardInitLib|$(PLATFORM_PACKAGE)/PlatformInit/Library/MultiBoardInitSupportLib/DxeMultiBoardInitSupportLib.inf
  MultiBoardAcpiSupportLib|$(PLATFORM_PACKAGE)/Acpi/Library/MultiBoardAcpiSupportLib/DxeMultiBoardAcpiSupportLib.inf
  BoardAcpiTableLib|$(PLATFORM_PACKAGE)/Acpi/Library/MultiBoardAcpiSupportLib/DxeMultiBoardAcpiSupportLib.inf
  SiliconPolicyInitLib|$(PLATFORM_PACKAGE)/PlatformInit/Library/SiliconPolicyInitLibNull/SiliconPolicyInitLibNull.inf
  SiliconPolicyUpdateLib|$(PLATFORM_BOARD_PACKAGE)/Policy/Library/DxeSiliconPolicyUpdateLib/DxeSiliconPolicyUpdateLib.inf

  BiosIdLib|BoardModulePkg/Library/BiosIdLib/DxeBiosIdLib.inf
  LogoLib|$(CLIENT_COMMON_PACKAGE)/Library/DxeLogoLib/DxeLogoLib.inf
  TcgPhysicalPresenceLib|SecurityPkg/Library/DxeTcgPhysicalPresenceLib/DxeTcgPhysicalPresenceLib.inf
  TcgPpVendorLib|SecurityPkg/Library/TcgPpVendorLibNull/TcgPpVendorLibNull.inf

!if gSiPkgTokenSpaceGuid.PcdSmbiosEnable == TRUE
  DxeSmbiosProcessorLib|$(PLATFORM_SI_PACKAGE)/Library/DxeSmbiosProcessorLib/DxeSmbiosProcessorLib.inf
!else
  DxeSmbiosProcessorLib|$(PLATFORM_SI_PACKAGE)/Library/DxeSmbiosProcessorLibNull/DxeSmbiosProcessorLibNull.inf
!endif

  BoardConfigLib|$(PLATFORM_BOARD_PACKAGE)/Library/DxeBoardConfigLib/DxeBoardConfigLib.inf

#
# Silicon Init Package
#
!include $(C1S_PRODUCT_PATH)/SiPkgDxeLib.dsc

 FirmwareBootMediaLib|IntelSiliconPkg/Library/PeiDxeSmmBootMediaLib/DxeSmmFirmwareBootMediaLib.inf
!if gPlatformModuleTokenSpaceGuid.PcdUsb3SerialStatusCodeEnable == TRUE
  Usb3DebugPortLib|Debugging/Usb3DebugFeaturePkg/Library/Usb3DebugPortLib/Usb3DebugPortLibDxe.inf
!else
  Usb3DebugPortLib|Debugging/Usb3DebugFeaturePkg/Library/Usb3DebugPortLib/Usb3DebugPortLibNull.inf
!endif

  DxeOverClockLib|$(PLATFORM_FEATURES_PATH)/OverClocking/OverClockInit/DxeOverClockLib.inf
  BluetoothLib|BluetoothPkg/Library/BluetoothLib/BluetoothLib.inf
  HidLib|BluetoothPkg/Library/HidLib/HidLib.inf

  MpInitLib|UefiCpuPkg/Library/MpInitLib/DxeMpInitLib.inf
  TlsLib|CryptoPkg/Library/TlsLib/TlsLib.inf

[LibraryClasses.X64.DXE_SMM_DRIVER]
!if gSiPkgTokenSpaceGuid.PcdBiosGuardEnable == TRUE
  SpiFlashCommonLib|$(PLATFORM_FULL_PACKAGE)/Library/SmmSpiFlashCommonLib/SmmSpiFlashCommonLibBiosGuard.inf
!else
  SpiFlashCommonLib|$(PLATFORM_FULL_PACKAGE)/Library/SmmSpiFlashCommonLib/SmmSpiFlashCommonLib.inf
!endif

!if $(TARGET) == DEBUG
  TestPointCheckLib|$(PLATFORM_PACKAGE)/Test/Library/TestPointCheckLib/SmmTestPointCheckLib.inf
  TestPointCheckLib|$(PLATFORM_PACKAGE)/Test/Library/TestPointCheckLibNull/TestPointCheckLibNull.inf
  DebugLib|$(PLATFORM_FULL_PACKAGE)/Library/BaseDebugLibAllDebugPort/BaseDebugLibAllDebugPort.inf
  SerialIoUartDebugPropertyLib|$(PLATFORM_FULL_PACKAGE)/Library/SerialIoUartDebugPropertyLib/DxeSmmSerialIoUartDebugPropertyLib.inf
!endif
  TestPointLib|$(PLATFORM_PACKAGE)/Test/Library/TestPointLib/SmmTestPointLib.inf
  MultiBoardAcpiSupportLib|$(PLATFORM_PACKAGE)/Acpi/Library/MultiBoardAcpiSupportLib/SmmMultiBoardAcpiSupportLib.inf
  BoardAcpiEnableLib|$(PLATFORM_PACKAGE)/Acpi/Library/MultiBoardAcpiSupportLib/SmmMultiBoardAcpiSupportLib.inf
  DxeSmmAcpiCustomLib|$(PLATFORM_FULL_PACKAGE)/Library/DxeSmmAcpiCustomLib/DxeSmmAcpiCustomLib.inf
  DxeSmmScriptLib|$(PLATFORM_FULL_PACKAGE)/Library/DxeSmmScriptLib/DxeSmmScriptLib.inf
  CpuPcieRpLib|$(PLATFORM_SI_PACKAGE)/IpBlock/CpuPcieRp/Library/PeiDxeSmmCpuPcieRpLib/PeiDxeSmmCpuPcieRpLib.inf
  SmmIoLib|MdePkg/Library/SmmIoLib/SmmIoLib.inf

[LibraryClasses.X64.DXE_RUNTIME_DRIVER]

  ReportStatusCodeLib|MdeModulePkg/Library/RuntimeDxeReportStatusCodeLib/RuntimeDxeReportStatusCodeLib.inf
  DebugPrintErrorLevelLib|$(PLATFORM_FULL_PACKAGE)/Library/PeiDxeSmmDebugPrintErrorLevelLib/PeiDxeSmmDebugPrintErrorLevelLib.inf
  SerialPortParameterLib|$(PLATFORM_FULL_PACKAGE)/Library/DxeSmmSerialPortParameterLib/DxeSmmSerialPortParameterLib.inf

!if $(TARGET) == DEBUG
  SerialIoUartDebugPropertyLib|$(PLATFORM_FULL_PACKAGE)/Library/SerialIoUartDebugPropertyLib/DxeSmmSerialIoUartDebugPropertyLib.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
  CapsuleLib|MdeModulePkg/Library/DxeCapsuleLibFmp/DxeRuntimeCapsuleLib.inf
!endif

ResetSystemLib|$(PLATFORM_SI_PACKAGE)/Pch/Library/BaseResetSystemLib/BaseResetSystemLib.inf

[Components.IA32]

#
# Common
#
!include $(PLATFORM_PACKAGE)/Include/Dsc/CorePeiInclude.dsc
  MdeModulePkg/Universal/PCD/Pei/Pcd.inf {
    <LibraryClasses>
      !if $(TARGET) == DEBUG
        DebugLib|MdeModulePkg/Library/PeiDxeDebugLibReportStatusCode/PeiDxeDebugLibReportStatusCode.inf
      !endif
      PcdLib|MdePkg/Library/BasePcdLibNull/BasePcdLibNull.inf
  }
  MdeModulePkg/Universal/SectionExtractionPei/SectionExtractionPei.inf {
    <LibraryClasses>
      NULL|SecurityPkg/Library/PeiRsa2048Sha256GuidedSectionExtractLib/PeiRsa2048Sha256GuidedSectionExtractLib.inf
  }
  MdeModulePkg/Universal/StatusCodeHandler/Pei/StatusCodeHandlerPei.inf {
    <PcdsFeatureFlag>
      #
      #  Use Platform Status Code handler for serial I/O (EC COM port) to be compliance with FSP 2.1 specification.
      #
      gEfiMdeModulePkgTokenSpaceGuid.PcdStatusCodeUseSerial|FALSE
  }

  #
  # FSP wrapper SEC Core
  #
  UefiCpuPkg/SecCore/SecCore.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/PeiPcdLib/PeiPcdLib.inf
!if $(TARGET) == DEBUG
      DebugLib|$(PLATFORM_FULL_PACKAGE)/Library/BaseDebugLibAllDebugPort/BaseDebugLibAllDebugPort.inf
      TraceHubDebugLib|ClientOneSiliconPkg/Library/TraceHubDebugLibSvenTx/BaseTraceHubDebugLibSvenTx.inf
!endif
  }

!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
  MdeModulePkg/Universal/CapsulePei/CapsulePei.inf {
    <LibraryClasses>
!if ($(TARGET) == RELEASE) AND (gSiPkgTokenSpaceGuid.PcdSiCatalogDebugEnable == TRUE)
      DebugLib|$(PLATFORM_FULL_PACKAGE)/Library/BaseDebugLibAllDebugPort/BaseDebugLibAllDebugPort.inf
!endif
  }
!endif


#
# CpuMp PEIM for MpService PPI
#
!if gSiPkgTokenSpaceGuid.PcdFspWrapperEnable == FALSE
  UefiCpuPkg/CpuMpPei/CpuMpPei.inf
  #
  # Silicon
  #
  !include $(C1S_PRODUCT_PATH)/SiPkgPei.dsc
!else
!if gIntelFsp2WrapperTokenSpaceGuid.PcdFspModeSelection == 1
  UefiCpuPkg/CpuMpPei/CpuMpPei.inf {
    <LibraryClasses>
      NULL|$(PLATFORM_SI_PACKAGE)/Library/PeiReadyToInstallMpLib/PeiReadyToInstallMpLib.inf
  }
!endif #PcdFspModeSelection
!endif #PcdFspWrapperEnable

#
# This is for reducing NATIVE DEBUG binary size, replacing some library routines with PPI.
#
!if $(TARGET) == DEBUG
  MdeModulePkg/Universal/DebugServicePei/DebugServicePei.inf {
    <LibraryClasses>
      DebugLib|MdeModulePkg/Library/PeiDxeDebugLibReportStatusCode/PeiDxeDebugLibReportStatusCode.inf
  }
!endif

$(CLIENT_COMMON_PACKAGE)/Universal/PlatformStatusCodeHandler/Pei/PlatformStatusCodeHandlerPei.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|$(PLATFORM_FULL_PACKAGE)/Library/BaseDebugLibAllDebugPort/BaseDebugLibAllDebugPort.inf
!else
!if gSiPkgTokenSpaceGuid.PcdSiCatalogDebugEnable == TRUE
      DebugLib|$(PLATFORM_FULL_PACKAGE)/Library/BaseDebugLibAllDebugPort/BaseDebugLibAllDebugPort.inf
!endif
!endif
  }
$(PLATFORM_FEATURES_PATH)/PlatformStatusCodeHandler/Pei/PlatformStatusCodeHandlerPei.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|$(PLATFORM_FULL_PACKAGE)/Library/BaseDebugLibAllDebugPort/BaseDebugLibAllDebugPort.inf
!else
!if gSiPkgTokenSpaceGuid.PcdSiCatalogDebugEnable == TRUE
      DebugLib|$(PLATFORM_FULL_PACKAGE)/Library/BaseDebugLibAllDebugPort/BaseDebugLibAllDebugPort.inf
!endif
!endif
}

#
# Platform
#
  $(PLATFORM_PACKAGE)/PlatformInit/ReportFv/ReportFvPei.inf
  $(PLATFORM_PACKAGE)/PlatformInit/PlatformInitPei/PlatformInitPreMem.inf {
    <LibraryClasses>
      NULL|$(PROJECT_TGL_U_BOARDS)/Library/BoardInitLib/Pei/PeiMultiBoardInitPreMemLib.inf
      NULL|$(PROJECT_TGL_H_BOARDS)/Library/BoardInitLib/Pei/PeiMultiBoardInitPreMemLib.inf
      NULL|$(PROJECT_TGL_Y_BOARDS)/Library/BoardInitLib/Pei/PeiMultiBoardInitPreMemLib.inf
  }

!if gBoardModuleTokenSpaceGuid.PcdAdvancedFeatureEnable == TRUE
  $(PLATFORM_FULL_PACKAGE)/PlatformInitAdvanced/PlatformInitAdvancedPei/PlatformInitAdvancedPreMem.inf {
    <LibraryClasses>
      PeiPlatformRecoveryLib|$(PLATFORM_FULL_PACKAGE)/Library/PeiPlatformRecoveryLib/PeiPlatformRecoveryLib.inf
      PeiWdtAppLib|$(PLATFORM_FULL_PACKAGE)/Library/PeiWdtAppLib/PeiWdtAppLib.inf
      ProcessorTraceMemoryAllocationLib|$(PLATFORM_SI_PACKAGE)/Library/PeiProcessorTraceMemoryAllocationLib/PeiProcessorTraceMemoryAllocationLib.inf
  }
!endif  # PcdAdvancedFeatureEnable

  $(PLATFORM_PACKAGE)/PlatformInit/PlatformInitPei/PlatformInitPostMem.inf {
    <LibraryClasses>
      NULL|$(PROJECT_TGL_U_BOARDS)/Library/BoardInitLib/Pei/PeiMultiBoardInitPostMemLib.inf
      NULL|$(PROJECT_TGL_H_BOARDS)/Library/BoardInitLib/Pei/PeiMultiBoardInitPostMemLib.inf
      NULL|$(PROJECT_TGL_Y_BOARDS)/Library/BoardInitLib/Pei/PeiMultiBoardInitPostMemLib.inf
  }

!if gBoardModuleTokenSpaceGuid.PcdAdvancedFeatureEnable == TRUE
!if gSiPkgTokenSpaceGuid.PcdFspWrapperEnable == TRUE
  $(PLATFORM_FULL_PACKAGE)/PlatformInitAdvanced/PlatformInitAdvancedPei/PlatformInitAdvancedPostMemFsp.inf
!else
  $(PLATFORM_FULL_PACKAGE)/PlatformInitAdvanced/PlatformInitAdvancedPei/PlatformInitAdvancedPostMem.inf
!endif
!if gSiPkgTokenSpaceGuid.PcdS3Enable == TRUE
  PowerManagement/S3FeaturePkg/S3Pei/S3Pei.inf
!endif
!endif  # PcdAdvancedFeatureEnable

  BoardModulePkg/FirmwareBootMediaInfo/FirmwareBootMediaInfoPei.inf

  $(PLATFORM_BOARD_PACKAGE)/BiosInfo/BiosInfo.inf

!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
!if gPlatformModuleTokenSpaceGuid.PcdResiliencyEnable == FALSE
  $(PLATFORM_FEATURES_PATH)/CapsuleUpdate/BiosInfoRecovery/BiosInfoRecovery.inf
!endif
!endif

!if gMinPlatformPkgTokenSpaceGuid.PcdUefiSecureBootEnable == TRUE
  $(PLATFORM_FULL_PACKAGE)/Platform/BiosInfoChecker/BiosInfoChecker.inf
!endif
  $(PLATFORM_PACKAGE)/Services/StallServicePei/StallServicePei.inf

!if gSiPkgTokenSpaceGuid.PcdFspWrapperEnable == TRUE
  IntelFsp2WrapperPkg/FspmWrapperPeim/FspmWrapperPeim.inf {
    <LibraryClasses>
      SiliconPolicyInitLib|$(PLATFORM_PACKAGE)/PlatformInit/Library/SiliconPolicyInitLibNull/SiliconPolicyInitLibNull.inf
      SiliconPolicyUpdateLib|$(PLATFORM_PACKAGE)/PlatformInit/Library/SiliconPolicyUpdateLibNull/SiliconPolicyUpdateLibNull.inf
    !if (gPlatformModuleTokenSpaceGuid.PcdTpmEnable == TRUE) OR (gMinPlatformPkgTokenSpaceGuid.PcdTpm2Enable == TRUE)
      !if gSiPkgTokenSpaceGuid.PcdTxtEnable == TRUE
        NULL|$(PLATFORM_FULL_PACKAGE)/Features/Txt/Library/TpmInitDoneDepLib/TpmInitDoneDepLib.inf
      !endif
    !endif
    !if gIntelFsp2WrapperTokenSpaceGuid.PcdFspModeSelection == 0
      #
      # In FSP Dispatch mode below dummy library should be linked to bootloader PEIM
      # to build all DynamicEx PCDs that FSP consumes into bootloader PCD database.
      #
      NULL|$(PLATFORM_FSP_BIN_PACKAGE)/Library/FspPcdListLib/FspPcdListLibNull.inf
    !endif
  }
  IntelFsp2WrapperPkg/FspsWrapperPeim/FspsWrapperPeim.inf {
    <LibraryClasses>
      SiliconPolicyInitLib|$(PLATFORM_PACKAGE)/PlatformInit/Library/SiliconPolicyInitLibNull/SiliconPolicyInitLibNull.inf
      SiliconPolicyUpdateLib|$(PLATFORM_PACKAGE)/PlatformInit/Library/SiliconPolicyUpdateLibNull/SiliconPolicyUpdateLibNull.inf
  }
  $(PLATFORM_FULL_PACKAGE)/FspWrapper/FspWrapperPeim/FspWrapperPeim.inf
  #
  # Telemetry
  #
  $(PLATFORM_FULL_PACKAGE)/Telemetry/FspFirmwareVersionPeim/FspFirmwareVersionPeim.inf
!endif

#
# Telemetry
#
!if gIntelFsp2WrapperTokenSpaceGuid.PcdFspModeSelection == 1
  $(PLATFORM_FULL_PACKAGE)/Telemetry/BiosGuardFirmwareVersionPeim/BiosGuardFirmwareVersionPeimFsp.inf
!else
  $(PLATFORM_FULL_PACKAGE)/Telemetry/BiosGuardFirmwareVersionPeim/BiosGuardFirmwareVersionPeim.inf
!endif

!if gBoardModuleTokenSpaceGuid.PcdNvmeEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Nvme/NvmePciHcPei/NvmePciHcPei.inf
  MdeModulePkg/Bus/Pci/NvmExpressPei/NvmExpressPei.inf
!endif
!if gSiPkgTokenSpaceGuid.PcdAtaEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Sata/AhciPciHcPei/AhciPciHcPei.inf
  MdeModulePkg/Bus/Ata/AhciPei/AhciPei.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
  # Recovery module
  FatPkg/FatPei/FatPei.inf
!endif

#
# Security
#
!if gPlatformModuleTokenSpaceGuid.PcdTpmEnable == TRUE
  SecurityPkg/Tcg/PhysicalPresencePei/PhysicalPresencePei.inf

!if gMinPlatformPkgTokenSpaceGuid.PcdTpm2Enable == TRUE
  SecurityPkg/Tcg/Tcg2Config/Tcg2ConfigPei.inf {
    <LibraryClasses>
      Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2DeviceLibDTpm.inf
      Tpm2CommandLib|SecurityPkg/Library/Tpm2CommandLib/Tpm2CommandLib.inf
      Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibRouter/Tpm2DeviceLibRouterPei.inf
      NULL|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2InstanceLibDTpm.inf
      NULL|$(PLATFORM_FULL_PACKAGE)/Library/PeiBootGuardEventLogLib/PeiBootGuardEventLogLib.inf
      NULL|SecurityPkg/Library/HashInstanceLibSha1/HashInstanceLibSha1.inf
      NULL|SecurityPkg/Library/HashInstanceLibSha256/HashInstanceLibSha256.inf
!if gSiPkgTokenSpaceGuid.PcdEmbeddedEnable == 0x1
      NULL|SecurityPkg/Library/HashInstanceLibSha384/HashInstanceLibSha384.inf
      NULL|SecurityPkg/Library/HashInstanceLibSm3/HashInstanceLibSm3.inf
!endif
  }
  SecurityPkg/Tcg/Tcg2Pei/Tcg2Pei.inf {
    <LibraryClasses>
      Tpm2CommandLib|SecurityPkg/Library/Tpm2CommandLib/Tpm2CommandLib.inf
      Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibRouter/Tpm2DeviceLibRouterPei.inf
      NULL|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2InstanceLibDTpm.inf
      NULL|SecurityPkg/Library/HashInstanceLibSha1/HashInstanceLibSha1.inf
      NULL|SecurityPkg/Library/HashInstanceLibSha256/HashInstanceLibSha256.inf
!if gSiPkgTokenSpaceGuid.PcdEmbeddedEnable == 0x1
      NULL|SecurityPkg/Library/HashInstanceLibSha384/HashInstanceLibSha384.inf
      NULL|SecurityPkg/Library/HashInstanceLibSm3/HashInstanceLibSm3.inf
!endif
  }

  $(PLATFORM_PACKAGE)/Tcg/Tcg2PlatformPei/Tcg2PlatformPei.inf  {
    <LibraryClasses>
      Tpm2CommandLib|SecurityPkg/Library/Tpm2CommandLib/Tpm2CommandLib.inf
      Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibRouter/Tpm2DeviceLibRouterPei.inf
      NULL|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2InstanceLibDTpm.inf
  }
!endif

  SecurityPkg/Tcg/TcgPei/TcgPei.inf
!endif # gPlatformModuleTokenSpaceGuid.PcdTpmEnable


#
# Features
#
!if gBoardModuleTokenSpaceGuid.PcdSetupEnable == TRUE
  !include $(PLATFORM_BOARD_PACKAGE)/Features/Setup/Include/Dsc/SetupPei.dsc
!endif

 MdeModulePkg/Universal/ResetSystemPei/ResetSystemPei.inf {
   <LibraryClasses>
     ResetSystemLib|$(PLATFORM_SI_PACKAGE)/Pch/Library/BaseResetSystemLib/BaseResetSystemLib.inf
 }

#
# VTd Iommu Security for Pei
#
  $(PLATFORM_FEATURES_PATH)/VTd/PlatformVTdInfoSamplePei/PlatformVTdInfoSamplePei.inf
  IntelSiliconPkg/Feature/VTd/IntelVTdPmrPei/IntelVTdPmrPei.inf

!if gSiPkgTokenSpaceGuid.PcdAmtEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Amt/AmtStatusCodePei/AmtStatusCodePei.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdOverclockEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/OverClocking/OverClockInit/PeiOverClock.inf
!endif

#
# S3
#
!if gSiPkgTokenSpaceGuid.PcdS3Enable == TRUE
  UefiCpuPkg/Universal/Acpi/S3Resume2Pei/S3Resume2Pei.inf
  UefiCpuPkg/PiSmmCommunication/PiSmmCommunicationPei.inf
!if gPlatformModuleTokenSpaceGuid.PcdOpalPasswordEnable == TRUE
  SecurityPkg/Tcg/Opal/OpalPassword/OpalPasswordPei.inf
!endif
!if gSiPkgTokenSpaceGuid.PcdAtaEnable == TRUE
!if gPlatformModuleTokenSpaceGuid.PcdHddPasswordEnable == TRUE
  SecurityPkg/HddPassword/HddPasswordPei.inf
!endif
!endif
!endif



!if gMinPlatformPkgTokenSpaceGuid.PcdPerformanceEnable == TRUE
  MdeModulePkg/Universal/Acpi/FirmwarePerformanceDataTablePei/FirmwarePerformancePei.inf {
    <LibraryClasses>
      TimerLib|PcAtChipsetPkg/Library/AcpiTimerLib/BaseAcpiTimerLib.inf
  }
!endif

#
# DGR
#
!if gSiPkgTokenSpaceGuid.PcdPpamEnable == TRUE
  $(PLATFORM_FULL_PACKAGE)/Features/NiftyRock/MsegSmramPei/MsegSmramPei.inf
!endif

#
# PCT PEIM Parser
#
  $(PLATFORM_FULL_PACKAGE)/Features/Pct/PlatformConfigTool.inf

[Components.X64]

#
# Common
#
#
# Board specific instance of CoreDxeInclude.dsc from MinPlatformPkg
#
!include $(PLATFORM_BOARD_PACKAGE)/Include/Dsc/CoreDxeInclude.dsc

  #
  # Generic EDKII Driver
  #
  MdeModulePkg/Core/Dxe/DxeMain.inf {
    <LibraryClasses>
    !if gMinPlatformPkgTokenSpaceGuid.PcdUefiSecureBootEnable == TRUE
      NULL|SecurityPkg/Library/DxeRsa2048Sha256GuidedSectionExtractLib/DxeRsa2048Sha256GuidedSectionExtractLib.inf
    !endif
    !if gPlatformModuleTokenSpaceGuid.PcdLzmaEnable == TRUE
      NULL|MdeModulePkg/Library/LzmaCustomDecompressLib/LzmaCustomDecompressLib.inf
    !endif
  }

  MdeModulePkg/Universal/StatusCodeHandler/RuntimeDxe/StatusCodeHandlerRuntimeDxe.inf {
    <PcdsFeatureFlag>
      #
      #  Use Platform Status Code handler for serial I/O (EC COM port) to be compliance with FSP 2.1 specification.
      #
      gEfiMdeModulePkgTokenSpaceGuid.PcdStatusCodeUseSerial|FALSE
  }
  MdeModulePkg/Universal/StatusCodeHandler/Smm/StatusCodeHandlerSmm.inf {
    <PcdsFeatureFlag>
      #
      #  Use Platform Status Code handler for serial I/O (EC COM port) to be compliance with FSP 2.1 specification.
      #
      gEfiMdeModulePkgTokenSpaceGuid.PcdStatusCodeUseSerial|FALSE
  }

!if gMinPlatformPkgTokenSpaceGuid.PcdTpm2Enable == TRUE
  SecurityPkg/Tcg/Tcg2Smm/Tcg2Smm.inf {
    <LibraryClasses>
      Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibTcg2/Tpm2DeviceLibTcg2.inf
  }
!endif # gMinPlatformPkgTokenSpaceGuid.PcdTpm2Enable

!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
  MdeModulePkg/Universal/BdsDxe/BdsDxe.inf {
    <LibraryClasses>
!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
      CapsuleLib|MdeModulePkg/Library/DxeCapsuleLibFmp/DxeCapsuleLib.inf
      NULL|$(PLATFORM_FEATURES_PATH)/CapsuleUpdate/Library/SeamlessRecoverySupportLib/SeamlessRecoveryVarLockLib.inf
!endif
  }
!endif
  UefiCpuPkg/CpuDxe/CpuDxe.inf


!if gSiPkgTokenSpaceGuid.PcdEmbeddedEnable == 0x1
#PSDS Table
#
  $(PLATFORM_FEATURES_PATH)/PsdsAcpiDxe/PsdsAcpiDxe.inf
!endif

#
# S3
#
  UefiCpuPkg/CpuS3DataDxe/CpuS3DataDxe.inf

  MdeModulePkg/Bus/Pci/PciHostBridgeDxe/PciHostBridgeDxe.inf

  MdeModulePkg/Bus/Pci/SataControllerDxe/SataControllerDxe.inf
  MdeModulePkg/Bus/Ata/AtaBusDxe/AtaBusDxe.inf
  MdeModulePkg/Bus/Ata/AtaAtapiPassThru/AtaAtapiPassThru.inf
  MdeModulePkg/Universal/Console/GraphicsOutputDxe/GraphicsOutputDxe.inf
  MdeModulePkg/Bus/Pci/PciSioSerialDxe/PciSioSerialDxe.inf
  MdeModulePkg/Bus/Pci/NvmExpressDxe/NvmExpressDxe.inf
  $(CLIENT_COMMON_PACKAGE)/Sio/NationalPC8374LDxe/NationalPC8374L.inf
  $(CLIENT_COMMON_PACKAGE)/Sio/SmscLpc100xDxe/LpcSmsc100x.inf
  $(CLIENT_COMMON_PACKAGE)/Sio/HitachiH8s2113Dxe/HitachiH8s2113Dxe.inf
  $(CLIENT_COMMON_PACKAGE)/Sio/WinbondWpcn381uDxe/WinbondWpcn381u.inf

!if (gSiPkgTokenSpaceGuid.PcdAtaEnable == TRUE) OR (gBoardModuleTokenSpaceGuid.PcdNvmeEnable == TRUE)
!if gPlatformModuleTokenSpaceGuid.PcdOpalPasswordEnable == TRUE
  SecurityPkg/Tcg/Opal/OpalPassword/OpalPasswordDxe.inf
!endif
!endif

!if gBoardModuleTokenSpaceGuid.PcdTerminalEnable == TRUE
  MdeModulePkg/Universal/Console/TerminalDxe/TerminalDxe.inf
!endif

!if gBoardModuleTokenSpaceGuid.PcdUefiShellEnable == TRUE
#
#UEFI Shell
#
  ShellPkg/Application/Shell/Shell.inf {
    <LibraryClasses>
      NULL|ShellPkg/Library/UefiShellLevel2CommandsLib/UefiShellLevel2CommandsLib.inf
      NULL|ShellPkg/Library/UefiShellLevel1CommandsLib/UefiShellLevel1CommandsLib.inf
      NULL|ShellPkg/Library/UefiShellLevel3CommandsLib/UefiShellLevel3CommandsLib.inf
      NULL|ShellPkg/Library/UefiShellDriver1CommandsLib/UefiShellDriver1CommandsLib.inf
      NULL|ShellPkg/Library/UefiShellInstall1CommandsLib/UefiShellInstall1CommandsLib.inf
      NULL|ShellPkg/Library/UefiShellDebug1CommandsLib/UefiShellDebug1CommandsLib.inf
      NULL|ShellPkg/Library/UefiShellNetwork1CommandsLib/UefiShellNetwork1CommandsLib.inf

    <PcdsFixedAtBuild>
      gEfiShellPkgTokenSpaceGuid.PcdShellLibAutoInitialize|FALSE
  }
!endif

!if gPlatformModuleTokenSpaceGuid.PcdFatEnable == TRUE
  MdeModulePkg/Universal/Disk/RamDiskDxe/RamDiskDxe.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdCryptoEnable == TRUE
  SecurityPkg/RandomNumberGenerator/RngDxe/RngDxe.inf {
    <LibraryClasses>
      RngLib|MdePkg/Library/BaseRngLib/BaseRngLib.inf
  }
!endif

!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
  MdeModulePkg/Universal/CapsulePei/CapsuleX64.inf {
    <LibraryClasses>
      DebugLib|MdePkg/Library/BaseDebugLibNull/BaseDebugLibNull.inf
      TimerLib|PcAtChipsetPkg/Library/AcpiTimerLib/BaseAcpiTimerLib.inf
      HobLib|MdePkg/Library/PeiHobLib/PeiHobLib.inf
      MemoryAllocationLib|MdePkg/Library/PeiMemoryAllocationLib/PeiMemoryAllocationLib.inf
      !if gSiPkgTokenSpaceGuid.PcdSourceDebugEnable == TRUE
        PeiMeLib|$(PLATFORM_SI_PACKAGE)/Me/Library/PeiMeLib/PeiMeLib.inf
      !endif
  }
!endif

#
# I2C Stack:Start
#
!if gPlatformModuleTokenSpaceGuid.PcdPiI2cStackEnable == TRUE
  MdeModulePkg/Bus/I2c/I2cDxe/I2cDxe.inf
  $(PLATFORM_FEATURES_PATH)/I2c/I2cPlatformDxe/I2cPlatformDxe.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdI2cTouchDriverEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/I2c/I2cTouchPanelDxe/I2cTouchPanelDxe.inf
!endif
#
# I2C Stack:End
#

!if gMinPlatformPkgTokenSpaceGuid.PcdUefiSecureBootEnable == TRUE
  SecurityPkg/VariableAuthenticated/SecureBootConfigDxe/SecureBootConfigDxe.inf {
    <LibraryClasses>
      PlatformSecureLib|$(PLATFORM_FULL_PACKAGE)/Library/PlatformSecureLibTest/PlatformSecureLibTest.inf
      FileExplorerLib|MdeModulePkg/Library/FileExplorerLib/FileExplorerLib.inf
    <BuildOptions>
      #
      # Specify GUID gEfiIfrBootMaintenanceGuid, to install Secure Boot Configuration menu
      # into Boot Maintenance Manager menu
      #
      *_*_*_VFR_FLAGS   = -g b2dedc91-d59f-48d2-898a-12490c74a4e0
  }
!endif


!if gBoardModuleTokenSpaceGuid.PcdAdvancedFeatureEnable == TRUE
!if gSiPkgTokenSpaceGuid.PcdAcpiEnable == TRUE
  $(PLATFORM_FULL_PACKAGE)/PlatformInitAdvanced/PlatformInitAdvancedSmm/PlatformInitAdvancedSmm.inf {
     <BuildOptions>
       *_*_X64_CC_FLAGS      = -DDOCK_ENABLE
  }
!endif
!endif


#
# Silicon
#
!include $(C1S_PRODUCT_PATH)/SiPkgDxe.dsc

#
# Network
#
$(PLATFORM_FEATURES_PATH)/Cnv/CnvUefiVariables/CnvUefiVariables.inf

!if gPlatformModuleTokenSpaceGuid.PcdNetworkEnable == TRUE
!include NetworkPkg/NetworkComponents.dsc.inc

# Temporary workaround for GCC and Xcode build due to these drivers causes system hang.
!if ("MSFT" in $(FAMILY))
  $(PLATFORM_FEATURES_PATH)/WifiConnectionManagerDxe/WifiConnectionManagerDxe.inf
  BluetoothPkg/BluetoothConnectionManagerDxe/BluetoothConnectionManagerDxe.inf
!endif
  BluetoothPkg/UsbBtHciDxe/UsbBtHciDxe.inf
  BluetoothPkg/BluetoothBusDxe/BluetoothBusDxe.inf
  BluetoothPkg/BluetoothHidDxe/BluetoothHidDxe.inf
  BluetoothPkg/HidKbDxe/HidKbDxe.inf
  BluetoothPkg/HidMouseDxe/HidMouseDxe.inf
!endif # gPlatformModuleTokenSpaceGuid.PcdNetworkEnable

!if ("MSFT" in $(FAMILY))
!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
  # capsule related drivers and Application.
  MdeModulePkg/Universal/EsrtFmpDxe/EsrtFmpDxe.inf
  MdeModulePkg/Application/CapsuleApp/CapsuleApp.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }
  !include $(PLATFORM_FEATURES_PATH)/CapsuleUpdate/FmpPlatformMonolithic.dsc
  !include $(PLATFORM_FEATURES_PATH)/CapsuleUpdate/FmpPlatformBios.dsc
  !include $(PLATFORM_FEATURES_PATH)/CapsuleUpdate/FmpPlatformBtGAcm.dsc
  !include $(PLATFORM_FEATURES_PATH)/CapsuleUpdate/FmpPlatformMe.dsc
  !include $(PLATFORM_FEATURES_PATH)/CapsuleUpdate/FmpPlatformEc.dsc
  !include $(PLATFORM_FEATURES_PATH)/CapsuleUpdate/FmpPlatformIshPdt.dsc
  !include $(PLATFORM_FEATURES_PATH)/CapsuleUpdate/FmpPlatformuCode.dsc
  !include $(PLATFORM_FEATURES_PATH)/CapsuleUpdate/FmpPlatformTbtRetimer.dsc
  !include $(PLATFORM_FEATURES_PATH)/CapsuleUpdate/FmpPlatformTcI2cRetimer.dsc
  $(PLATFORM_FEATURES_PATH)/TcssRetimerCapsuleUpdate/RetimerCapsuleSupportDriver/RetimerCapsuleUpdate.inf
!endif
!endif

#
# SMBIOS
#
!if gSiPkgTokenSpaceGuid.PcdSmbiosEnable == TRUE
  MdeModulePkg/Universal/SmbiosDxe/SmbiosDxe.inf
  $(PLATFORM_FULL_PACKAGE)/Platform/SmbiosPlatformInfo/SmbiosPlatformInfo.inf
  $(PLATFORM_FEATURES_PATH)/Smbios/SmbiosMiscDxe/SmbiosMiscDxe.inf

  !if gMinPlatformPkgTokenSpaceGuid.PcdTpm2Enable == TRUE
    $(PLATFORM_FEATURES_PATH)/Smbios/SmbiosTpmDeviceInfo/SmbiosTpmDeviceInfo.inf
  !endif

    $(PLATFORM_FEATURES_PATH)/Me/MeSmbiosUpdateConfigDxe/MeSmbiosUpdateConfigDxe.inf
!endif

#
# VTd Iommu Security
#
  $(PLATFORM_FEATURES_PATH)/VTd/PlatformVTdSampleDxe/PlatformVTdSampleDxe.inf
  IntelSiliconPkg/Feature/VTd/IntelVTdDxe/IntelVTdDxe.inf

#
# SmmAccess
#
  IntelSiliconPkg/Feature/SmmAccess/SmmAccessDxe/SmmAccess.inf

#
# Telemetry
#
  $(PLATFORM_FULL_PACKAGE)/Telemetry/PlatformFirmwareVersionDxe/PlatformFirmwareVersionDxe.inf
  $(PLATFORM_FULL_PACKAGE)/Telemetry/GopFirmwareVersionDxe/GopFirmwareVersionDxe.inf
  $(PLATFORM_FULL_PACKAGE)/Telemetry/UndiFirmwareVersionDxe/UndiFirmwareVersionDxe.inf
  $(PLATFORM_FULL_PACKAGE)/Telemetry/SiFirmwareVersionDxe/SiFirmwareVersionDxe.inf

#
# Platform
#
  $(PLATFORM_PACKAGE)/PlatformInit/SiliconPolicyDxe/SiliconPolicyDxe.inf
  $(PLATFORM_PACKAGE)/PlatformInit/PlatformInitDxe/PlatformInitDxe.inf {
    <LibraryClasses>
    NULL|$(PROJECT_TGL_U_BOARDS)/Library/BoardInitLib/Dxe/DxeMultiBoardInitlib.inf
    NULL|$(PROJECT_TGL_Y_BOARDS)/Library/BoardInitLib/Dxe/DxeMultiBoardInitlib.inf
    NULL|$(PROJECT_TGL_H_BOARDS)/Library/BoardInitLib/Dxe/DxeMultiBoardInitlib.inf
  }
  $(PLATFORM_FULL_PACKAGE)/PlatformInitAdvanced/PlatformInitAdvancedDxe/PlatformInitAdvancedDxe.inf {
    <LibraryClasses>
    BootGuardRevocationLib|$(PLATFORM_FULL_PACKAGE)/Library/BootGuardRevocationLib/BootGuardRevocationLib.inf
    DxeFirmwareVersionInfoLib|$(PLATFORM_FULL_PACKAGE)/Library/DxeFirmwareVersionInfoLib/DxeFirmwareVersionInfoLib.inf
    DxeSmbiosDataHobLib|IntelSiliconPkg/Library/DxeSmbiosDataHobLib/DxeSmbiosDataHobLib.inf
    DxeSmbiosFirmwareVersionInfoLib|$(CLIENT_COMMON_PACKAGE)/Library/DxeSmbiosFirmwareVersionInfoLib/DxeSmbiosFirmwareVersionInfoLib.inf
    DxeTelemetryAcpiLib|$(PLATFORM_FULL_PACKAGE)/Telemetry/Library/DxeTelemetryAcpiLib/DxeTelemetryAcpiLib.inf
  }

!if gPlatformModuleTokenSpaceGuid.PcdResiliencyEnable == TRUE
  $(PLATFORM_FULL_PACKAGE)/Features/CapsuleUpdate/Resiliency/Dxe/ResiliencyDxe.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
!if gPlatformModuleTokenSpaceGuid.PcdMeResiliencyEnable == TRUE
  $(PLATFORM_FULL_PACKAGE)/Features/CapsuleUpdate/Resiliency/MeResiliencyDxe/MeResiliencyDxe.inf {
    <LibraryClasses>
      FmpPayloadHeaderLib|FmpDevicePkg/Library/FmpPayloadHeaderLibV1/FmpPayloadHeaderLibV1.inf
  }
!endif
!endif

!if gSiPkgTokenSpaceGuid.PcdFspWrapperEnable == TRUE
!if gIntelFsp2WrapperTokenSpaceGuid.PcdFspModeSelection == 1
  $(PLATFORM_FULL_PACKAGE)/FspWrapper/CheckFspErrorInfoHob/CheckFspErrorInfoHobDxe.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|$(PLATFORM_FULL_PACKAGE)/Library/BaseDebugLibAllDebugPort/BaseDebugLibAllDebugPort.inf
!endif
  }
  IntelFsp2WrapperPkg/FspWrapperNotifyDxe/FspWrapperNotifyDxe.inf
!endif
!endif
  $(PLATFORM_FULL_PACKAGE)/Platform/SaveMemoryConfig/Dxe/SaveMemoryConfig.inf

  $(PLATFORM_PACKAGE)/Test/TestPointStubDxe/TestPointStubDxe.inf
  $(PLATFORM_PACKAGE)/Test/TestPointDumpApp/TestPointDumpApp.inf

!if gBoardModuleTokenSpaceGuid.PcdSetupEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/UiApp/UiApp.inf {
  <Defines>
  FILE_GUID = D89A7D8B-D016-4D26-93E3-EAB6B4D3B0A2
  }
!endif #PcdSetupEnable == TRUE

!if gBoardModuleTokenSpaceGuid.PcdSetupEnable == TRUE
  !include $(PLATFORM_BOARD_PACKAGE)/Features/Setup/Include/Dsc/SetupDxe.dsc

!if gPlatformModuleTokenSpaceGuid.PcdUserAuthenticationEnable == TRUE
  UserInterface/UserAuthFeaturePkg/UserAuthenticationDxeSmm//UserAuthenticationDxe.inf {
    <LibraryClasses>
      PlatformPasswordLib|UserInterface/UserAuthFeaturePkg/Library/PlatformPasswordLibNull/PlatformPasswordLibNull.inf
    }
  UserInterface/UserAuthFeaturePkg/UserAuthenticationDxeSmm//UserAuthenticationSmm.inf {
    <LibraryClasses>
      PlatformPasswordLib|UserInterface/UserAuthFeaturePkg/Library/PlatformPasswordLibNull/PlatformPasswordLibNull.inf
    }
!endif
!endif
  $(PLATFORM_BOARD_PACKAGE)/BootMediaInfo/BootMediaInfo.inf

!if gMinPlatformPkgTokenSpaceGuid.PcdStopAfterMemInit == FALSE
  UefiCpuPkg/PiSmmCpuDxeSmm/PiSmmCpuDxeSmm.inf {
  <LibraryClasses>
      SmmCpuFeaturesLib|$(PLATFORM_SI_PACKAGE)/Cpu/Library/SmmCpuFeaturesLib/SmmCpuFeaturesLib.inf
  }
!endif #PcdStopAfterMemInit

#
# OS Boot
#
!if gMinPlatformPkgTokenSpaceGuid.PcdBootToShellOnly == FALSE
!if gBoardModuleTokenSpaceGuid.PcdAdvancedFeatureEnable == TRUE
  $(PLATFORM_BOARD_PACKAGE)/Acpi/AdvancedAcpiDxe/AdvancedAcpiDxe.inf
  $(PLATFORM_FEATURES_PATH)/Acpi/AcpiTables/AcpiFeatures.inf
  $(PLATFORM_BOARD_PACKAGE)/Acpi/AcpiTables/AcpiTables.inf
  $(PLATFORM_FEATURES_PATH)/Dptf/AcpiTables/DptfAcpiTables.inf
  $(PLATFORM_FEATURES_PATH)/Dptf/AcpiTables/Sds/DptfAcpiTablesSds.inf
  $(PLATFORM_FEATURES_PATH)/Dptf/Dxe/Dptf.inf
!if gSiPkgTokenSpaceGuid.PcdAcpiEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Pep/Smm/PepBccdSmm.inf
!endif
#
# DGR
#
!if gSiPkgTokenSpaceGuid.PcdPpamEnable == TRUE
  $(PLATFORM_FULL_PACKAGE)/Features/NiftyRock/PpamPlatformSmm/PpamPlatformSmm.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdOverclockEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/OverClocking/OverClockInit/DxeOverClock.inf
  $(PLATFORM_FEATURES_PATH)/OverClocking/OverclockInterface/OverclockInterface.inf
  $(PLATFORM_FEATURES_PATH)/OverClocking/OverclockInterface/OverclockInterfaceACPI.inf
  $(PLATFORM_FEATURES_PATH)/OverClocking/OverclockInterface/OverClockSmiHandler.inf
!endif #PcdOverclockEnable
!else
  $(PLATFORM_PACKAGE)/Acpi/AcpiTables/AcpiPlatform.inf {
    <LibraryClasses>
      NULL|$(PROJECT_TGL_U_BOARDS)/Library/BoardAcpiLib/BaseMultiBoardAcpiSupportLib.inf
      NULL|$(PROJECT_TGL_H_BOARDS)/Library/BoardAcpiLib/BaseMultiBoardAcpiSupportLib.inf
      NULL|$(PROJECT_TGL_Y_BOARDS)/Library/BoardAcpiLib/BaseMultiBoardAcpiSupportLib.inf
  }
  $(PLATFORM_BOARD_PACKAGE)/Acpi/BoardAcpiDxe/BoardAcpiDxe.inf {
    <LibraryClasses>
      NULL|$(PROJECT_TGL_U_BOARDS)/Library/BoardAcpiLib/BaseMultiBoardAcpiSupportLib.inf
      NULL|$(PROJECT_TGL_H_BOARDS)/Library/BoardAcpiLib/BaseMultiBoardAcpiSupportLib.inf
      NULL|$(PROJECT_TGL_Y_BOARDS)/Library/BoardAcpiLib/BaseMultiBoardAcpiSupportLib.inf
  }
  $(PLATFORM_PACKAGE)/PlatformInit/PlatformInitSmm/PlatformInitSmm.inf
  $(PLATFORM_PACKAGE)/Acpi/AcpiSmm/AcpiSmm.inf {
    <LibraryClasses>
      NULL|$(PLATFORM_BOARD_PACKAGE)/SmmMultiBoardAcpiSupportLib/SmmMultiBoardAcpiSupportLib.inf
  }
!endif #PcdAdvancedFeatureEnable

  $(PLATFORM_FULL_PACKAGE)/Platform/SpiFvbService/SpiFvbServiceDxe.inf
!if gSiPkgTokenSpaceGuid.PcdSmmVariableEnable == TRUE
  $(PLATFORM_PACKAGE)/Flash/SpiFvbService/SpiFvbServiceSmm.inf
!endif # gSiPkgTokenSpaceGuid.PcdSmmVariableEnable

!if gSiPkgTokenSpaceGuid.PcdSmmVariableEnable == TRUE
  !if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
  MdeModulePkg/Universal/FaultTolerantWriteDxe/FaultTolerantWriteDxe.inf
  !endif
!else
  MdeModulePkg/Universal/FaultTolerantWriteDxe/FaultTolerantWriteDxe.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdUsbEnable == TRUE
  MdeModulePkg/Bus/Usb/UsbMouseDxe/UsbMouseDxe.inf
!endif

  $(PLATFORM_FEATURES_PATH)/Me/MeUlvCheckDxe/MeUlvCheckDxe.inf

!endif #PcdBootToShellOnly

#
# S3
#
!if gSiPkgTokenSpaceGuid.PcdS3Enable == TRUE
  MdeModulePkg/Universal/LockBox/SmmLockBox/SmmLockBox.inf
  UefiCpuPkg/PiSmmCommunication/PiSmmCommunicationSmm.inf
  MdeModulePkg/Universal/Acpi/S3SaveStateDxe/S3SaveStateDxe.inf
  MdeModulePkg/Universal/Acpi/SmmS3SaveState/SmmS3SaveState.inf
  MdeModulePkg/Universal/Acpi/BootScriptExecutorDxe/BootScriptExecutorDxe.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|$(PLATFORM_FULL_PACKAGE)/Library/BaseDebugLibAllDebugPort/BaseDebugLibAllDebugPort.inf
      TraceHubDebugLib|ClientOneSiliconPkg/Library/TraceHubDebugLibSvenTx/BaseTraceHubDebugLibSvenTx.inf
!endif
  }
!endif # gSiPkgTokenSpaceGuid.PcdS3Enable

#
# Security
#

!if gPlatformModuleTokenSpaceGuid.PcdTpmEnable == TRUE
  SecurityPkg/Tcg/TcgConfigDxe/TcgConfigDxe.inf {
    <BuildOptions>
      #
      # specify GUID gEfiIfrNotInTPVPageGuid, this page will not
      # be showed in TPV page.
      #
      *_*_*_VFR_FLAGS   = -g 1947c034-062f-44c0-bcc4-19927afe9ea4
  }

!if gMinPlatformPkgTokenSpaceGuid.PcdTpm2Enable == TRUE
  SecurityPkg/Tcg/Tcg2Dxe/Tcg2Dxe.inf {
    <LibraryClasses>
      Tpm2CommandLib|SecurityPkg/Library/Tpm2CommandLib/Tpm2CommandLib.inf
      Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibRouter/Tpm2DeviceLibRouterDxe.inf
      NULL|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2InstanceLibDTpm.inf
      NULL|SecurityPkg/Library/HashInstanceLibSha1/HashInstanceLibSha1.inf
      NULL|SecurityPkg/Library/HashInstanceLibSha256/HashInstanceLibSha256.inf
!if gSiPkgTokenSpaceGuid.PcdEmbeddedEnable == 0x1
      NULL|SecurityPkg/Library/HashInstanceLibSha384/HashInstanceLibSha384.inf
      NULL|SecurityPkg/Library/HashInstanceLibSm3/HashInstanceLibSm3.inf
!endif
!if $(TARGET) == DEBUG
      DebugLib|$(PLATFORM_FULL_PACKAGE)/Library/BaseDebugLibAllDebugPort/BaseDebugLibAllDebugPort.inf
      SerialIoUartDebugPropertyLib|$(PLATFORM_FULL_PACKAGE)/Library/SerialIoUartDebugPropertyLib/DxeSmmSerialIoUartDebugPropertyLib.inf
!endif
  }
  SecurityPkg/Tcg/Tcg2Config/Tcg2ConfigDxe.inf {
    <LibraryClasses>
      Tpm2CommandLib|SecurityPkg/Library/Tpm2CommandLib/Tpm2CommandLib.inf
      Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibRouter/Tpm2DeviceLibRouterDxe.inf
      NULL|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2InstanceLibDTpm.inf
    <BuildOptions>
      #
      # specify GUID gEfiIfrNotInTPVPageGuid, this page will not
      # be showed in TPV page.
      #
      *_*_*_VFR_FLAGS   = -g 1947c034-062f-44c0-bcc4-19927afe9ea4
  }
  $(PLATFORM_PACKAGE)/Tcg/Tcg2PlatformDxe/Tcg2PlatformDxe.inf {
    <LibraryClasses>
      Tpm2CommandLib|SecurityPkg/Library/Tpm2CommandLib/Tpm2CommandLib.inf
      NULL|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2InstanceLibDTpm.inf
  }
!endif # gMinPlatformPkgTokenSpaceGuid.PcdTpm2Enable

  MdeModulePkg/Universal/SmbiosMeasurementDxe/SmbiosMeasurementDxe.inf

  SecurityPkg/Tcg/TcgDxe/TcgDxe.inf {
    <LibraryClasses>
      DebugLib|$(PLATFORM_FULL_PACKAGE)/Library/BaseDebugLibAllDebugPort/BaseDebugLibAllDebugPort.inf
      SerialIoUartDebugPropertyLib|$(PLATFORM_FULL_PACKAGE)/Library/SerialIoUartDebugPropertyLib/DxeSmmSerialIoUartDebugPropertyLib.inf
  }

  # module to update variable according to TPM HW state, the code could be in TcgDxe driver but better to be separated
  $(PLATFORM_FEATURES_PATH)/Tcg/TcgSetupDxe/TcgSetupDxe.inf
!endif # gPlatformModuleTokenSpaceGuid.PcdTpmEnable

!if gSiPkgTokenSpaceGuid.PcdAmtEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Amt/AmtSaveMebxConfigDxe/AmtSaveMebxConfigDxe.inf
  $(PLATFORM_FEATURES_PATH)/Amt/AmtPetAlertDxe/AmtPetAlertDxe.inf
  $(PLATFORM_FEATURES_PATH)/Amt/AsfTable/AsfTable.inf
  $(PLATFORM_FEATURES_PATH)/Amt/AmtWrapperDxe/AmtWrapperDxe.inf
!if gPlatformModuleTokenSpaceGuid.PcdEnableSecureErase == TRUE
  $(PLATFORM_FEATURES_PATH)/Amt/SecureEraseDxe/SecureEraseDxe.inf
!endif
!endif
  $(PLATFORM_FEATURES_PATH)/Me/MeExtMeasurement/Dxe/MeExtMeasurement.inf
  $(PLATFORM_FEATURES_PATH)/TrustedDeviceSetup/TrustedDeviceSetup.inf
#
# RST One Click switch module
#
!if gPlatformModuleTokenSpaceGuid.PcdRstOneClickEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Rst/RstOneClickEnable/RstOneClickEnable.inf
!endif

$(PLATFORM_FEATURES_PATH)/Rst/RstUefiDriverSupport/RstUefiDriverSupport.inf

#
# UsbDeviceMode XDCI
#
!if gPlatformModuleTokenSpaceGuid.PcdUsbFnEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Usb/UsbDeviceDxe/UsbDeviceDxe.inf
!endif



#
# Crash Log Support
#
$(PLATFORM_FEATURES_PATH)/CrashLogDxe/CrashLogDxe.inf

!if gPlatformModuleTokenSpaceGuid.PcdDnxSupportEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Dnx/DnxDxe/DnxDxe.inf
!endif

$(PLATFORM_FEATURES_PATH)/FastBoot/FastBootHandlerDxe/FastBootHandlerDxe.inf
$(PLATFORM_FEATURES_PATH)/FastBoot/FastBootSetupDxe/FastBootSetupDxe.inf

  $(PLATFORM_FEATURES_PATH)/Hsti/HstiResultDxe/HstiResultDxe.inf

#
# Hsti
#
$(PLATFORM_FEATURES_PATH)/Hsti/HstiIhvDxe/HstiIhvDxe.inf {
  <LibraryClasses>
    HstiLib|MdePkg/Library/DxeHstiLib/DxeHstiLib.inf
    Tpm2CommandLib|SecurityPkg/Library/Tpm2CommandLib/Tpm2CommandLib.inf
}

  $(PLATFORM_FEATURES_PATH)/Hsti/HstiIhvSmm/HstiIhvSmm.inf

!if gBoardModuleTokenSpaceGuid.PcdAdvancedFeatureEnable == TRUE
!if gBoardModuleTokenSpaceGuid.PcdSetupEnable == TRUE
!endif

$(PLATFORM_FULL_PACKAGE)/Platform/PciPlatform/Dxe/PciPlatform.inf {
  <LibraryClasses>
    DxeOpromPatchLib|$(PLATFORM_FULL_PACKAGE)/Library/DxeOpromPatchLib/DxeOpromPatchLib.inf
}

!if gPlatformModuleTokenSpaceGuid.PcdPciHotplugEnable == TRUE
  $(PLATFORM_FULL_PACKAGE)/Platform/PciHotPlug/PciHotPlug.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdUsbTypeCEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/UsbTypeC/UsbTypeCDxe/UsbTypeCDxe.inf
!endif

  $(PLATFORM_FULL_PACKAGE)/Platform/SavePegConfig/Dxe/SavePegConfig.inf

  $(PLATFORM_FULL_PACKAGE)/Platform/SaveTraceHubConfig/Dxe/SaveTraceHubConfig.inf

!if gSiPkgTokenSpaceGuid.PcdAcpiEnable == TRUE
!if gBoardModuleTokenSpaceGuid.PcdAcpiDebugFeatureEnable == TRUE
  Debugging/AcpiDebugFeaturePkg/AcpiDebugDxeSmm/AcpiDebugDxe.inf
!endif
!endif

!if gPlatformModuleTokenSpaceGuid.PcdVirtualKeyboardEnable == TRUE
  $(CLIENT_COMMON_PACKAGE)/Universal/VirtualKeyboardDxe/VirtualKeyboardDxe.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdEbcEnable == TRUE
  MdeModulePkg/Universal/EbcDxe/EbcDxe.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdAtaEnable == TRUE
!if gPlatformModuleTokenSpaceGuid.PcdHddPasswordEnable == TRUE
  SecurityPkg/HddPassword/HddPasswordDxe.inf {
    <BuildOptions>
      #
      # Specify GUID gEfiIfrBootMaintenanceGuid, to install HddPassword Configuration menu
      # into Boot Maintenance Manager menu
      #
      *_*_*_VFR_FLAGS   = -g b2dedc91-d59f-48d2-898a-12490c74a4e0
  }
!endif
!endif

!if gSiPkgTokenSpaceGuid.PcdAtaEnable == TRUE
!if gBoardModuleTokenSpaceGuid.PcdIntelRaidEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Sata/IntelUefiRaidDiskInfo/IntelUefiRaidDiskInfo.inf
!endif
!endif

  MdeModulePkg/Bus/Isa/Ps2KeyboardDxe/Ps2KeyboardDxe.inf
  !if gPlatformModuleTokenSpaceGuid.PcdMouseEnable == TRUE
    MdeModulePkg/Bus/Isa/Ps2MouseDxe/Ps2MouseDxe.inf
  !endif



!if gPlatformModuleTokenSpaceGuid.PcdGopOverrideDriverEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Gop/GopOverrideDriver/GopOverrideDriver.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdScsiEnable == TRUE
  MdeModulePkg/Bus/Scsi/ScsiBusDxe/ScsiBusDxe.inf
  MdeModulePkg/Bus/Scsi/ScsiDiskDxe/ScsiDiskDxe.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdAtaEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Sata/SataController/SataController.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdBootTimeEnable == TRUE
  $(CLIENT_COMMON_PACKAGE)/Responsiveness/BootTime/BootTimeDxe.inf
!endif

  $(PLATFORM_FEATURES_PATH)/Wdt/WdtAppDxe/WdtAppDxe.inf

!if gSiPkgTokenSpaceGuid.PcdEmbeddedEnable == 0x1
  $(CLIENT_COMMON_PACKAGE)/Sio/NuvotonNct6776fDxe/NuvotonNct6776f.inf
  $(CLIENT_COMMON_PACKAGE)/Sio/Nct6776fHwMonDxe/Nct6776fHwMon.inf
  $(PLATFORM_FEATURES_PATH)/LifeCycleState/LifeCycleState.inf
!endif

!endif  #PcdAdvancedFeatureEnable

!if gBoardModuleTokenSpaceGuid.PcdEcEnable == TRUE
  $(PLATFORM_FULL_PACKAGE)/EC/EC.inf
!endif

!if gBoardModuleTokenSpaceGuid.PcdIntelGopEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Gop/GopDebugDxe/GopDebugDxe.inf
!endif

  $(PLATFORM_FEATURES_PATH)/DashG/DxeDg1OpregionInit.inf


!if gPlatformModuleTokenSpaceGuid.PcdVtioEnable == TRUE
  $(PLATFORM_FULL_PACKAGE)/Vtio/Dxe/VtioDxe.inf
!endif

  $(CLIENT_COMMON_PACKAGE)/Universal/PlatformStatusCodeHandler/Smm/PlatformStatusCodeHandlerSmm.inf
  $(PLATFORM_FEATURES_PATH)/PlatformStatusCodeHandler/Smm/PlatformStatusCodeHandlerSmm.inf

!if gBoardModuleTokenSpaceGuid.PcdTerminalEnable == TRUE
!if gSiPkgTokenSpaceGuid.PcdSourceDebugEnable == FALSE
  $(CLIENT_COMMON_PACKAGE)/Universal/SpcrAcpiDxe/SpcrAcpiDxe.inf
!endif
!endif

!if gPlatformModuleTokenSpaceGuid.PcdUserIdentificationEnable == TRUE
  SecurityPkg/UserIdentification/UserIdentifyManagerDxe/UserIdentifyManagerDxe.inf
  SecurityPkg/UserIdentification/UserProfileManagerDxe/UserProfileManagerDxe.inf
  SecurityPkg/UserIdentification/PwdCredentialProviderDxe/PwdCredentialProviderDxe.inf
  SecurityPkg/UserIdentification/UsbCredentialProviderDxe/UsbCredentialProviderDxe.inf
!endif

$(PLATFORM_FEATURES_PATH)/Acpi/AcpiTables/SsdtIrmt/IrmtAcpiTables.inf

$(CLIENT_COMMON_PACKAGE)/Universal/PlatformStatusCodeHandler/RuntimeDxe/PlatformStatusCodeHandlerRuntimeDxe.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|$(PLATFORM_FULL_PACKAGE)/Library/BaseDebugLibAllDebugPort/BaseDebugLibAllDebugPort.inf
      SerialIoUartDebugPropertyLib|$(PLATFORM_FULL_PACKAGE)/Library/SerialIoUartDebugPropertyLib/DxeSmmSerialIoUartDebugPropertyLib.inf
!else
!if gSiPkgTokenSpaceGuid.PcdSiCatalogDebugEnable == TRUE
      DebugLib|$(PLATFORM_FULL_PACKAGE)/Library/BaseDebugLibAllDebugPort/BaseDebugLibAllDebugPort.inf
!endif
!endif
}
$(PLATFORM_FEATURES_PATH)/PlatformStatusCodeHandler/RuntimeDxe/PlatformStatusCodeHandlerRuntimeDxe.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|$(PLATFORM_FULL_PACKAGE)/Library/BaseDebugLibAllDebugPort/BaseDebugLibAllDebugPort.inf
      SerialIoUartDebugPropertyLib|$(PLATFORM_FULL_PACKAGE)/Library/SerialIoUartDebugPropertyLib/DxeSmmSerialIoUartDebugPropertyLib.inf
!else
!if gSiPkgTokenSpaceGuid.PcdSiCatalogDebugEnable == TRUE
      DebugLib|$(PLATFORM_FULL_PACKAGE)/Library/BaseDebugLibAllDebugPort/BaseDebugLibAllDebugPort.inf
!endif
!endif
}

#
# Build Options
#
!include $(C1S_PRODUCT_PATH)/SiPkgBuildOption.dsc
!include BoardPkgBuildOption.dsc

