#!/bin/bash

## @file
#
# @copyright
#  INTEL CONFIDENTIAL
#  Copyright 2017 - 2020 Intel Corporation.
#
#  The source code contained or described herein and all documents related to the
#  source code ("Material") are owned by Intel Corporation or its suppliers or
#  licensors. Title to the Material remains with Intel Corporation or its suppliers
#  and licensors. The Material may contain trade secrets and proprietary and
#  confidential information of Intel Corporation and its suppliers and licensors,
#  and is protected by worldwide copyright and trade secret laws and treaty
#  provisions. No part of the Material may be used, copied, reproduced, modified,
#  published, uploaded, posted, transmitted, distributed, or disclosed in any way
#  without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure or delivery
#  of the Materials, either expressly, by implication, inducement, estoppel or
#  otherwise. Any license under such intellectual property rights must be
#  express and approved by Intel in writing.
#
#  Unless otherwise agreed by Intel in writing, you may not remove or alter
#  this notice or any other notice embedded in Materials by Intel or
#  Intel's suppliers or licensors in any way.
#
#  This file contains a 'Sample Driver' and is licensed as such under the terms
#  of your license agreement with Intel or your vendor. This file may be modified
#  by the user, subject to the additional terms of the license agreement.
#
# @par Specification
##


#
# Build FitGen tools.
#
cd $WORKSPACE_CORE_SILICON/Tools
make
if [ $? -ne 0 ]; then
  echo "Build FitGen tools fail."
fi

#
# Build KeyEnroll tools.
#
if [ ! -d $WORKSPACE_CORE/BaseTools/Source/C/KeyEnroll ]; then
  cp -rf $WORKSPACE_COMMON/ClientCommonPkg/Tools/KeyEnroll $WORKSPACE_CORE/BaseTools/Source/C
#
# Create BinWrappers script for KeyEnroll.
#
  cp -f $WORKSPACE_CORE/BaseTools/BinWrappers/PosixLike/Split $WORKSPACE_CORE/BaseTools/BinWrappers/PosixLike/KeyEnroll
fi
cd $WORKSPACE_CORE/BaseTools/Source/C/KeyEnroll
make
if [ $? -ne 0 ]; then
  echo "Build KeyEnroll tools fail."
fi

#
# Add additional tools in PATH.
#
export PATH=$EDK_TOOLS_PATH/Source/C/bin:$PATH
export PATH=$WORKSPACE_PLATFORM/ClientCommonPkg/Tools/FCE:$PATH
export PATH=$WORKSPACE_PLATFORM/ClientCommonPkg/Tools/FMMT:$PATH
export PATH=$WORKSPACE_PLATFORM/$PLATFORM_PACKAGE/Tools/ToolScripts/SignFv:$PATH
export PATH=$WORKSPACE_PLATFORM/$PLATFORM_PACKAGE/Tools/ToolScripts/FitGen:$PATH
export PATH=$EDK_TOOLS_PATH/Source/C/bin:$PATH
export PATH=$WORKSPACE_PLATFORM/$PLATFORM_PACKAGE/Tools/ToolScripts/BpmGen:$PATH
