/** @file
  Tigerlake H RVP GPIO definition table for Pre-Memory Initialization

@copyright
  Copyright (c) 2019 - 2020 Intel Corporation. All rights reserved
  This software and associated documentation (if any) is furnished
  under a license and may only be used or copied in accordance
  with the terms of the license. Except as permitted by such
  license, no part of this software or documentation may be
  reproduced, stored in a retrieval system, or transmitted in any
  form or by any means without the express written consent of
  Intel Corporation.
  This file contains an 'Intel Peripheral Driver' and is
  licensed for Intel CPUs and chipsets under the terms of your
  license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the
  license agreement.
**/
#ifndef _TIGERLAKE_H_PREMEM_GPIO_TABLE_H_
#define _TIGERLAKE_H_PREMEM_GPIO_TABLE_H_

#include <Pins/GpioPinsVer2H.h>
#include <Library/GpioLib.h>
#include <Library/GpioConfig.h>
#include <PlatformDpInPcdConfig.h>

GLOBAL_REMOVE_IF_UNREFERENCED GPIO_INIT_CONFIG mGpioTablePreMemTglHDdr4[] =
{
  {GPIO_VER2_H_GPP_F3,  {GpioPadModeGpio, GpioHostOwnGpio, GpioDirOut,    GpioOutHigh,     GpioIntDis,               GpioPlatformReset,  GpioTermNone}},  //TC_RETIMER_FORCE_PWR
  {GPIO_VER2_H_GPP_B17, {GpioPadModeGpio, GpioHostOwnGpio, GpioDirOut,    GpioOutHigh,     GpioIntDis,               GpioPlatformReset,  GpioTermNone}},  //DGPU_PWREN_N
  //
  // Dp-In GPIO settings
  //
  {GPIO_VER2_H_GPP_H6,  {GpioPadModeGpio, GpioHostOwnGpio, GpioDirIn, GpioOutDefault, GpioIntDefault, GpioPlatformReset, GpioTermNone } },//DP_IN Detect Port 1 for BoardIdTglHDdr4SODimm
  {GPIO_VER2_H_GPP_H7,  {GpioPadModeGpio, GpioHostOwnGpio, GpioDirIn, GpioOutDefault, GpioIntDefault, GpioPlatformReset, GpioTermNone } },//DP_IN Detect Port 1 for BoardIdTglHDdr4SODimm
  {GPIO_VER2_H_GPP_H8,  {GpioPadModeGpio, GpioHostOwnGpio, GpioDirIn, GpioOutDefault, GpioIntDefault, GpioPlatformReset, GpioTermNone } },//DP_IN Detect Port 1 for BoardIdTglHDdr4SODimm
  {GPIO_VER2_H_GPP_H9,  {GpioPadModeGpio, GpioHostOwnGpio, GpioDirIn, GpioOutDefault, GpioIntDefault, GpioPlatformReset, GpioTermNone } },//DP_IN Detect Port 1 for BoardIdTglHDdr4SODimm
  {0x0}
};

GLOBAL_REMOVE_IF_UNREFERENCED GPIO_INIT_CONFIG mGpioTablePreMemTglHDdr4Simics[] =
{
  {GPIO_VER2_H_GPP_C11, {GpioPadModeGpio, GpioHostOwnAcpi, GpioDirOut,    GpioOutHigh,     GpioIntDis,               GpioPlatformReset,  GpioTermNone}},  //WWAN_FCP_OFF_N
  {GPIO_VER2_H_GPP_D15, {GpioPadModeGpio, GpioHostOwnAcpi, GpioDirOut,    GpioOutHigh,     GpioIntDis,               GpioPlatformReset,  GpioTermNone}},  //WWAN_DISABLE_N
  {GPIO_VER2_H_GPP_H23, {GpioPadModeGpio, GpioHostOwnAcpi, GpioDirOut,    GpioOutHigh,     GpioIntDis,               GpioPlatformReset,  GpioTermNone}},  //WWAN_PWREN
  {GPIO_VER2_H_GPP_B17, {GpioPadModeGpio, GpioHostOwnAcpi, GpioDirOut,    GpioOutLow,      GpioIntDis,               GpioPlatformReset,  GpioTermNone}},  //WWAN_PERST_N
 // {GPIO_VER2_H_GPP_C9,  {GpioPadModeGpio, GpioHostOwnAcpi, GpioDirInInv,  GpioOutDefault,GpioIntLevel|GpioIntSci,GpioHostDeepReset,  GpioTermNone,  GpioPadConfigUnlock  }},  //WWAN_WAKE_N
  {GPIO_VER2_H_GPP_C10, {GpioPadModeGpio, GpioHostOwnAcpi, GpioDirOut,    GpioOutLow,      GpioIntDis,               GpioPlatformReset,  GpioTermNone}},  //WWAN_RST_N
  {GPIO_VER2_H_GPP_F3,  {GpioPadModeGpio, GpioHostOwnGpio, GpioDirOut,    GpioOutHigh,     GpioIntDis,               GpioPlatformReset,  GpioTermNone}},  //TC_RETIMER_FORCE_PWR
  //
  // Dp-In GPIO settings
  //
  {GPIO_VER2_H_GPP_H6,  {GpioPadModeGpio, GpioHostOwnGpio, GpioDirIn, GpioOutDefault, GpioIntDefault, GpioPlatformReset, GpioTermNone } },//DP_IN Detect Port 1 for BoardIdTglHDdr4SODimm
  {GPIO_VER2_H_GPP_H7,  {GpioPadModeGpio, GpioHostOwnGpio, GpioDirIn, GpioOutDefault, GpioIntDefault, GpioPlatformReset, GpioTermNone } },//DP_IN Detect Port 1 for BoardIdTglHDdr4SODimm
  {GPIO_VER2_H_GPP_H8,  {GpioPadModeGpio, GpioHostOwnGpio, GpioDirIn, GpioOutDefault, GpioIntDefault, GpioPlatformReset, GpioTermNone } },//DP_IN Detect Port 1 for BoardIdTglHDdr4SODimm
  {GPIO_VER2_H_GPP_H9,  {GpioPadModeGpio, GpioHostOwnGpio, GpioDirIn, GpioOutDefault, GpioIntDefault, GpioPlatformReset, GpioTermNone } },//DP_IN Detect Port 1 for BoardIdTglHDdr4SODimm
  {0x0}
};

GLOBAL_REMOVE_IF_UNREFERENCED GPIO_INIT_CONFIG mGpioTableTglHDdr4WwanOnEarlyPreMem[] =
{
  {GPIO_VER2_H_GPP_H23, {GpioPadModeGpio, GpioHostOwnGpio, GpioDirOut,    GpioOutHigh,     GpioIntDis,               GpioResumeReset,    GpioTermNone,  GpioOutputStateUnlock}},  //WWAN_PWREN
  {GPIO_VER2_H_GPP_C11, {GpioPadModeGpio, GpioHostOwnGpio, GpioDirOut,    GpioOutHigh,     GpioIntDis,               GpioResumeReset,    GpioTermNone,  GpioOutputStateUnlock}},  //WWAN_FCP_OFF_N
  {GPIO_VER2_H_GPP_C10, {GpioPadModeGpio, GpioHostOwnGpio, GpioDirOut,    GpioOutHigh,     GpioIntDis,               GpioResumeReset,    GpioTermNone,  GpioOutputStateUnlock}},  //WWAN_RST_N
  {GPIO_VER2_H_GPP_B17, {GpioPadModeGpio, GpioHostOwnGpio, GpioDirOut,    GpioOutHigh,     GpioIntDis,               GpioPlatformReset,  GpioTermNone,  GpioOutputStateUnlock}},  //WWAN_PERST_N
  {GPIO_VER2_H_GPP_C9,  {GpioPadModeGpio, GpioHostOwnGpio, GpioDirInInv,  GpioOutDefault,  GpioIntLevel|GpioIntSci,  GpioHostDeepReset,  GpioTermNone,  GpioPadConfigUnlock}},    //WWAN_WAKE_N
  {GPIO_VER2_H_GPP_D15, {GpioPadModeGpio, GpioHostOwnGpio, GpioDirOut,    GpioOutHigh,     GpioIntDis,               GpioResumeReset,    GpioTermNone,  GpioOutputStateUnlock}},  //WWAN_DISABLE_N
};

GLOBAL_REMOVE_IF_UNREFERENCED GPIO_INIT_CONFIG mGpioTableTglHDdr4WwanOffEarlyPreMem[] =
{
  {GPIO_VER2_H_GPP_C10, {GpioPadModeGpio, GpioHostOwnGpio, GpioDirOut,    GpioOutLow,      GpioIntDis,               GpioResumeReset,    GpioTermNone,  GpioOutputStateUnlock}},  //WWAN_RST_N
  {GPIO_VER2_H_GPP_B17, {GpioPadModeGpio, GpioHostOwnGpio, GpioDirOut,    GpioOutLow,      GpioIntDis,               GpioResumeReset,    GpioTermNone,  GpioOutputStateUnlock}},  //WWAN_PERST_N
  {GPIO_VER2_H_GPP_C11, {GpioPadModeGpio, GpioHostOwnGpio, GpioDirOut,    GpioOutLow,      GpioIntDis,               GpioResumeReset,    GpioTermNone,  GpioOutputStateUnlock}},  //WWAN_FCP_OFF_N
};

GLOBAL_REMOVE_IF_UNREFERENCED GPIO_INIT_CONFIG mGpioTableTglHDdr4DgpuOnPreMem[] =
{
  {GPIO_VER2_H_GPP_B17, {GpioPadModeGpio, GpioHostOwnGpio, GpioDirOut,    GpioOutLow,      GpioIntDis,               GpioPlatformReset,  GpioTermNone}},  //DGPU_PWREN_N
};

GLOBAL_REMOVE_IF_UNREFERENCED DPIN_GPIO_DATA_ARRAY mDpInGpioTablePreMemTglHDdr4 =
{
  // Number Of Dp-In Ports
  4,
  // Dp-In Gpio Config Array of 4 element
  // DpInPortNumber | DpInSkipGpioChecking | DpInPresenceDetectLabel | DpInGpioPad
  {{ 0,               FALSE,                 LABEL_LOW,                GPIO_VER2_H_GPP_H6 },
  {  1,               FALSE,                 LABEL_LOW,                GPIO_VER2_H_GPP_H7 },
  {  2,               FALSE,                 LABEL_LOW,                GPIO_VER2_H_GPP_H8 },
  {  3,               FALSE,                 LABEL_LOW,                GPIO_VER2_H_GPP_H9 }}
};

#endif // _TIGERLAKE_H_PREMEM_GPIO_TABLE_H_
