/** @file
  PCH USB OverCurrent Port mapping tables

@copyright
  Copyright (c) 2018 - 2020 Intel Corporation. All rights reserved
  This software and associated documentation (if any) is furnished
  under a license and may only be used or copied in accordance
  with the terms of the license. Except as permitted by such
  license, no part of this software or documentation may be
  reproduced, stored in a retrieval system, or transmitted in any
  form or by any means without the express written consent of
  Intel Corporation.
  This file contains an 'Intel Peripheral Driver' and is
  licensed for Intel CPUs and chipsets under the terms of your
  license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the
  license agreement.
**/
#ifndef _PCH_USB_OC_MAPPING_TABLE_H_
#define _PCH_USB_OC_MAPPING_TABLE_H_

#include <PlatformBoardConfig.h>

// Tiger Lake U specific mapping table
extern USB_OC_MAP_TABLE mTglUUsb2OverCurrentMappingTable;
extern USB_OC_MAP_TABLE mTglUUsb3OverCurrentMappingTable;

// Tiger Lake U AEP specific mapping table
extern USB_OC_MAP_TABLE mTglUAepUsb2OverCurrentMappingTable;

// Tiger Lake U DG1 AEP specific mapping table
extern USB_OC_MAP_TABLE mTglUDg1AepUsb2OverCurrentMappingTable;

// Tiger Lake U GCS specific USB2 OC mapping
extern USB_OC_MAP_TABLE mTglUGcsUsb2OverCurrentMappingTable;
extern USB_OC_MAP_TABLE mTglUGcsUsb3OverCurrentMappingTable;

#endif // _PCH_USB_OC_MAPPING_TABLE_H_
