/** @file

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2016 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _TIGERLAKE_Y_CONFIG_PATCH_TABLE_H_
#define _TIGERLAKE_Y_CONFIG_PATCH_TABLE_H_

#include <Library/SetupInitLib.h>
#include <SetupVariable.h>
#include <Protocol/RetimerCapsuleUpdate.h>

CONFIG_PATCH_TABLE  mTigerlakeYLp4RvpSetupConfigPatchTable[] = {
//{-Type------------------Size-------------------------------------------Offset------------------------------------Data-------------},
  { SIZE_OF_FIELD(SETUP_DATA, TbtLegacyModeSupport),                   OFFSET_OF(SETUP_DATA, TbtLegacyModeSupport),                    0 },
  { SIZE_OF_FIELD(SETUP_DATA, AuxOriOverrideSupport),                  OFFSET_OF(SETUP_DATA, AuxOriOverrideSupport),                   1 },
  { SIZE_OF_FIELD(SETUP_DATA, HebcValueSupport),                       OFFSET_OF(SETUP_DATA, HebcValueSupport),                        1 },
  { SIZE_OF_FIELD(SETUP_DATA, PchI2cSensorDevicePort[SERIAL_IO_I2C0]), OFFSET_OF (SETUP_DATA, PchI2cSensorDevicePort[SERIAL_IO_I2C0]), SERIAL_IO_I2C_TOUCHPAD },
  { SIZE_OF_FIELD(SETUP_DATA, PchI2cSensorDevicePort[SERIAL_IO_I2C1]), OFFSET_OF (SETUP_DATA, PchI2cSensorDevicePort[SERIAL_IO_I2C1]), SERIAL_IO_I2C_TOUCHPANEL },
  { SIZE_OF_FIELD(SETUP_DATA, PchSpiSensorDevicePort[SERIAL_IO_SPI1]), OFFSET_OF (SETUP_DATA, PchSpiSensorDevicePort[SERIAL_IO_SPI1]), SERIAL_IO_SPI_FINGERPRINT },
  { SIZE_OF_FIELD(SETUP_DATA, MipiCam4Enable),                         OFFSET_OF(SETUP_DATA, MipiCam4Enable),                          1 },
  { SIZE_OF_FIELD(SETUP_DATA, MipiCam5Enable),                         OFFSET_OF(SETUP_DATA, MipiCam5Enable),                          1 }
};

CONFIG_PATCH_TABLE  mTigerlakeYLp4RvpPchSetupConfigPatchTable[] = {
//{-Type------------------Size-------------------------------------------Offset------------------------------------Data-------------},
  { SIZE_OF_FIELD(PCH_SETUP, PxDevSlp[0]),                        OFFSET_OF(PCH_SETUP, PxDevSlp[0]),                        1 },
  { SIZE_OF_FIELD(PCH_SETUP, PxDevSlp[1]),                        OFFSET_OF(PCH_SETUP, PxDevSlp[1]),                        1 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoSpi[SERIAL_IO_SPI0]),     OFFSET_OF(PCH_SETUP, PchSerialIoSpi[SERIAL_IO_SPI0]),     0 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoSpi[SERIAL_IO_SPI1]),     OFFSET_OF(PCH_SETUP, PchSerialIoSpi[SERIAL_IO_SPI1]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoSpi[SERIAL_IO_SPI2]),     OFFSET_OF(PCH_SETUP, PchSerialIoSpi[SERIAL_IO_SPI2]),     0 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoUart[SERIAL_IO_UART0]),   OFFSET_OF(PCH_SETUP, PchSerialIoUart[SERIAL_IO_UART0]),   0 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoUart[SERIAL_IO_UART1]),   OFFSET_OF(PCH_SETUP, PchSerialIoUart[SERIAL_IO_UART1]),   0 },
  { SIZE_OF_FIELD(PCH_SETUP, PchUartHwFlowCtrl[2]),               OFFSET_OF(PCH_SETUP, PchUartHwFlowCtrl[2]),               0 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C2]),     OFFSET_OF(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C2]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C3]),     OFFSET_OF(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C3]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C4]),     OFFSET_OF(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C4]),     0 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C5]),     OFFSET_OF(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C5]),     1 },
};

CONFIG_PATCH_TABLE  mTigerlakeYLp4RvpA0PchSetupConfigPatchTable[] = {
//{-Type------------------Size-------------------------------------------Offset------------------------------------Data-------------},
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortPTM[0]),                 OFFSET_OF(PCH_SETUP, PcieRootPortPTM[0]),                 0 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortPTM[1]),                 OFFSET_OF(PCH_SETUP, PcieRootPortPTM[1]),                 0 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortPTM[2]),                 OFFSET_OF(PCH_SETUP, PcieRootPortPTM[2]),                 0 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortPTM[3]),                 OFFSET_OF(PCH_SETUP, PcieRootPortPTM[3]),                 0 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortPTM[4]),                 OFFSET_OF(PCH_SETUP, PcieRootPortPTM[4]),                 0 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortPTM[5]),                 OFFSET_OF(PCH_SETUP, PcieRootPortPTM[5]),                 0 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortPTM[6]),                 OFFSET_OF(PCH_SETUP, PcieRootPortPTM[6]),                 0 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortPTM[7]),                 OFFSET_OF(PCH_SETUP, PcieRootPortPTM[7]),                 0 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortPTM[8]),                 OFFSET_OF(PCH_SETUP, PcieRootPortPTM[8]),                 0 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortPTM[9]),                 OFFSET_OF(PCH_SETUP, PcieRootPortPTM[9]),                 0 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortPTM[10]),                OFFSET_OF(PCH_SETUP, PcieRootPortPTM[10]),                0 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortPTM[11]),                OFFSET_OF(PCH_SETUP, PcieRootPortPTM[11]),                0 }
};

CONFIG_PATCH_TABLE  mTigerlakeYLp5RvpSaSetupConfigPatchTable[] = {
  //{-Type------------------Size-------------------------------------------Offset------------------------------------Data-------------},
  { SIZE_OF_FIELD(SA_SETUP, SkipCdClockInit),                      OFFSET_OF(SA_SETUP, SkipCdClockInit),                     1 },
  { SIZE_OF_FIELD(SA_SETUP, PcieRootPortLinkDownGpios),            OFFSET_OF(SA_SETUP, PcieRootPortLinkDownGpios),           0 },
  { SIZE_OF_FIELD(SA_SETUP, PcieRootPortPMCE[0]),                  OFFSET_OF(SA_SETUP, PcieRootPortPMCE[0]),                 0 },
  { SIZE_OF_FIELD(SA_SETUP, PcieRootPortPMCE[1]),                  OFFSET_OF(SA_SETUP, PcieRootPortPMCE[1]),                 0 },
  { SIZE_OF_FIELD(SA_SETUP, PcieRootPortPMCE[2]),                  OFFSET_OF(SA_SETUP, PcieRootPortPMCE[2]),                 0 },
  { SIZE_OF_FIELD(SA_SETUP, PcieRootPortPMCE[3]),                  OFFSET_OF(SA_SETUP, PcieRootPortPMCE[3]),                 0 },
  { SIZE_OF_FIELD (SA_SETUP, Lp5CccConfig),                        OFFSET_OF (SA_SETUP, Lp5CccConfig),                       0xFF },
};


CONFIG_PATCH_TABLE  mTigerlakeAxSaSetupConfigPatchTable_Y[] = {
//{-Type------------------Size-------------------------------------------Offset------------------------------------Data-------------},
  { SIZE_OF_FIELD (SA_SETUP, CpuCrashLogDevice),                    OFFSET_OF (SA_SETUP, CpuCrashLogDevice),                0 },
  { SIZE_OF_FIELD (SA_SETUP, SaGv),                                 OFFSET_OF (SA_SETUP, SaGv),                             0 },
  { SIZE_OF_FIELD (SA_SETUP, EnableVtd),                            OFFSET_OF (SA_SETUP, EnableVtd),                        0 },
  { SIZE_OF_FIELD (SA_SETUP, D3ColdEnable),                         OFFSET_OF (SA_SETUP, D3ColdEnable),                     0 }
};


CONFIG_PATCH_TABLE  mTigerlakeYLp4RvpSaSetupConfigPatchTable[] = {
//{-Type------------------Size-------------------------------------------Offset------------------------------------Data-------------},
  { SIZE_OF_FIELD(SA_SETUP, SkipCdClockInit),                      OFFSET_OF(SA_SETUP, SkipCdClockInit),                     1 },
  { SIZE_OF_FIELD(SA_SETUP, PcieRootPortLinkDownGpios),            OFFSET_OF(SA_SETUP, PcieRootPortLinkDownGpios),           0 },
  { SIZE_OF_FIELD(SA_SETUP, PcieRootPortPMCE[0]),                  OFFSET_OF(SA_SETUP, PcieRootPortPMCE[0]),                 0 },
  { SIZE_OF_FIELD(SA_SETUP, PcieRootPortPMCE[1]),                  OFFSET_OF(SA_SETUP, PcieRootPortPMCE[1]),                 0 },
  { SIZE_OF_FIELD(SA_SETUP, PcieRootPortPMCE[2]),                  OFFSET_OF(SA_SETUP, PcieRootPortPMCE[2]),                 0 },
  { SIZE_OF_FIELD(SA_SETUP, PcieRootPortPMCE[3]),                  OFFSET_OF(SA_SETUP, PcieRootPortPMCE[3]),                 0 }
};

///
///

CONFIG_PATCH_STRUCTURE mTigerlakeYLp4RvpConfigPatchStruct[] = {
  { L"Setup",    &gSetupVariableGuid,    sizeof(SETUP_DATA), mTigerlakeYLp4RvpSetupConfigPatchTable,    SIZE_OF_TABLE(mTigerlakeYLp4RvpSetupConfigPatchTable, CONFIG_PATCH_TABLE) },
  { L"SaSetup",  &gSaSetupVariableGuid,  sizeof(SA_SETUP),   mTigerlakeYLp4RvpSaSetupConfigPatchTable,  SIZE_OF_TABLE(mTigerlakeYLp4RvpSaSetupConfigPatchTable, CONFIG_PATCH_TABLE) },
///
///
  { L"PchSetup", &gPchSetupVariableGuid, sizeof(PCH_SETUP),  mTigerlakeYLp4RvpPchSetupConfigPatchTable, SIZE_OF_TABLE(mTigerlakeYLp4RvpPchSetupConfigPatchTable, CONFIG_PATCH_TABLE) },
  { L"MeSetup",  &gMeSetupVariableGuid,  sizeof(ME_SETUP),   NULL, 0 }
};

CONFIG_PATCH_STRUCTURE mTigerlakeYLp5RvpConfigPatchStruct[] = {
  { L"Setup",    &gSetupVariableGuid,    sizeof(SETUP_DATA), mTigerlakeYLp4RvpSetupConfigPatchTable,    SIZE_OF_TABLE(mTigerlakeYLp4RvpSetupConfigPatchTable, CONFIG_PATCH_TABLE) },
  ///
  ///
  { L"PchSetup", &gPchSetupVariableGuid, sizeof(PCH_SETUP),  mTigerlakeYLp4RvpPchSetupConfigPatchTable, SIZE_OF_TABLE(mTigerlakeYLp4RvpPchSetupConfigPatchTable, CONFIG_PATCH_TABLE) },
  { L"MeSetup",  &gMeSetupVariableGuid,  sizeof(ME_SETUP),   NULL, 0 },
  { L"SaSetup",  &gSaSetupVariableGuid,  sizeof(SA_SETUP),   mTigerlakeYLp5RvpSaSetupConfigPatchTable,  SIZE_OF_TABLE(mTigerlakeYLp5RvpSaSetupConfigPatchTable, CONFIG_PATCH_TABLE) },
};

CONFIG_PATCH_STRUCTURE mTigerlakeYLp4RvpA0ConfigPatchStruct[] = {
  { L"PchSetup", &gPchSetupVariableGuid, sizeof(PCH_SETUP),  mTigerlakeYLp4RvpA0PchSetupConfigPatchTable, SIZE_OF_TABLE(mTigerlakeYLp4RvpA0PchSetupConfigPatchTable, CONFIG_PATCH_TABLE) },
};

CONFIG_PATCH_STRUCTURE mTglAxSaSetupConfigPatchStruct_Y[] = {
  { L"SaSetup",  &gSaSetupVariableGuid,  sizeof(SA_SETUP),   mTigerlakeAxSaSetupConfigPatchTable_Y, SIZE_OF_TABLE(mTigerlakeAxSaSetupConfigPatchTable_Y, CONFIG_PATCH_TABLE) },
};

CONFIG_PATCH_TABLE  mTglPchZ0PchSetupConfigPatchTable_Y[] = {
//{-Type------------------Size-------------------------------------------Offset------------------------------------Data-------------},
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortAspm[0]),         OFFSET_OF(PCH_SETUP, PcieRootPortAspm[0]),            4 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortAspm[1]),         OFFSET_OF(PCH_SETUP, PcieRootPortAspm[1]),            4 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortAspm[2]),         OFFSET_OF(PCH_SETUP, PcieRootPortAspm[2]),            4 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortAspm[3]),         OFFSET_OF(PCH_SETUP, PcieRootPortAspm[3]),            4 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortAspm[4]),         OFFSET_OF(PCH_SETUP, PcieRootPortAspm[4]),            4 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortAspm[5]),         OFFSET_OF(PCH_SETUP, PcieRootPortAspm[5]),            4 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortAspm[6]),         OFFSET_OF(PCH_SETUP, PcieRootPortAspm[6]),            4 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortAspm[7]),         OFFSET_OF(PCH_SETUP, PcieRootPortAspm[7]),            4 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortAspm[8]),         OFFSET_OF(PCH_SETUP, PcieRootPortAspm[8]),            4 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortAspm[9]),         OFFSET_OF(PCH_SETUP, PcieRootPortAspm[9]),            4 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortAspm[10]),        OFFSET_OF(PCH_SETUP, PcieRootPortAspm[10]),           4 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortAspm[11]),        OFFSET_OF(PCH_SETUP, PcieRootPortAspm[11]),           4 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortL1SubStates[0]),  OFFSET_OF(PCH_SETUP, PcieRootPortL1SubStates[0]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortL1SubStates[1]),  OFFSET_OF(PCH_SETUP, PcieRootPortL1SubStates[1]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortL1SubStates[2]),  OFFSET_OF(PCH_SETUP, PcieRootPortL1SubStates[2]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortL1SubStates[3]),  OFFSET_OF(PCH_SETUP, PcieRootPortL1SubStates[3]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortL1SubStates[4]),  OFFSET_OF(PCH_SETUP, PcieRootPortL1SubStates[4]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortL1SubStates[5]),  OFFSET_OF(PCH_SETUP, PcieRootPortL1SubStates[5]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortL1SubStates[6]),  OFFSET_OF(PCH_SETUP, PcieRootPortL1SubStates[6]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortL1SubStates[7]),  OFFSET_OF(PCH_SETUP, PcieRootPortL1SubStates[7]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortL1SubStates[8]),  OFFSET_OF(PCH_SETUP, PcieRootPortL1SubStates[8]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortL1SubStates[9]),  OFFSET_OF(PCH_SETUP, PcieRootPortL1SubStates[9]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortL1SubStates[10]),  OFFSET_OF(PCH_SETUP, PcieRootPortL1SubStates[10]),   1 },
  { SIZE_OF_FIELD(PCH_SETUP, PcieRootPortL1SubStates[11]),  OFFSET_OF(PCH_SETUP, PcieRootPortL1SubStates[11]),   1 }
};

CONFIG_PATCH_STRUCTURE mTglPchZ0ConfigPatchStruct_Y[] = {
  { L"PchSetup", &gPchSetupVariableGuid, sizeof(PCH_SETUP),  mTglPchZ0PchSetupConfigPatchTable_Y, SIZE_OF_TABLE(mTglPchZ0PchSetupConfigPatchTable_Y, CONFIG_PATCH_TABLE) },
  { L"MeSetup",  &gMeSetupVariableGuid,  sizeof(ME_SETUP),   NULL, 0 }
};

/**
  Patch Table to support IOTG Skew
**/
CONFIG_PATCH_TABLE  mTigerlakeEmbeddedConfigPatchTable[] = {
//{-Type------------------Size-------------------------------------------Offset------------------------------------Data-------------},
  { SIZE_OF_FIELD(PCH_SETUP, IehMode),  OFFSET_OF(PCH_SETUP, IehMode),   1 },
  { SIZE_OF_FIELD(PCH_SETUP, EnableTcoTimer),  OFFSET_OF(PCH_SETUP, EnableTcoTimer),   1 }
};

CONFIG_PATCH_STRUCTURE mTigerlakeEmbeddedConfigPatchStruct[] = {
  { L"PchSetup", &gPchSetupVariableGuid, sizeof(PCH_SETUP),  mTigerlakeEmbeddedConfigPatchTable, SIZE_OF_TABLE(mTigerlakeEmbeddedConfigPatchTable, CONFIG_PATCH_TABLE) }
};

/**
  WA to enable BT audio offload for integrated bluetooth TGL LP A0/Z0
**/
CONFIG_PATCH_TABLE  mTglYA0ConfigPatchTable[] = {
//{-Type------------------Size-------------------------------------------Offset------------------------------------Data-------------},
  { SIZE_OF_FIELD(PCH_SETUP, CnviBtAudioOffload),               OFFSET_OF(PCH_SETUP, CnviBtAudioOffload),   1 },
  { SIZE_OF_FIELD(PCH_SETUP, PchHdAudioNhltEndpointBluetooth),  OFFSET_OF(PCH_SETUP, PchHdAudioNhltEndpointBluetooth),   1 },
  { SIZE_OF_FIELD(PCH_SETUP, PchHdAudioFeature[1]),             OFFSET_OF(PCH_SETUP, PchHdAudioFeature[1]),   1 },
  { SIZE_OF_FIELD(PCH_SETUP, PchHdAudioFeature[5]),             OFFSET_OF(PCH_SETUP, PchHdAudioFeature[5]),   1 }
};

CONFIG_PATCH_STRUCTURE mTglYA0ConfigPatchStruct[] = {
  { L"PchSetup", &gPchSetupVariableGuid, sizeof(PCH_SETUP),  mTglYA0ConfigPatchTable, SIZE_OF_TABLE(mTglYA0ConfigPatchTable, CONFIG_PATCH_TABLE) }
};

#endif // _TIGERLAKE_Y_CONFIG_PATCH_TABLE_H_
