/** @file
  PEI Boards Configurations for PreMem phase.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2015 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _BOARD_SA_CONFIG_PRE_MEM_H_
#define _BOARD_SA_CONFIG_PRE_MEM_H_

#include <Ppi/SiPolicy.h>
#include <Library/BoardConfigLib.h>

//
// LPDDR3 / LPDDR4 RVP boards (memory soldered down)
// Single SPD EEPROM at 0xA2 serves both C0D0 and C1D0 (LPDDR3/4 is 1DPC only)
//
#define DIMM_SMB_SPD_P0C0D0_STP 0xA2
#define DIMM_SMB_SPD_P0C0D1_STP 0xA0
#define DIMM_SMB_SPD_P0C1D0_STP 0xA2
#define DIMM_SMB_SPD_P0C1D1_STP 0xA0
#define SA_MRC_MAX_RCOMP_TARGETS  (5)

GLOBAL_REMOVE_IF_UNREFERENCED const UINT16 TglYRcompTargetZeroes[SA_MRC_MAX_RCOMP_TARGETS] = { 0, 0, 0, 0, 0 };

//
// Reference RCOMP resistors on motherboard - MRC will set automatically
//
GLOBAL_REMOVE_IF_UNREFERENCED const UINT16 TglYRcompResistorZero = 0;

//
// TGL Y board RCOMP target values for RdOdt, WrDS, WrDSCmd, WrDSCtl, WrDSClk - MRC will set automatically
//
GLOBAL_REMOVE_IF_UNREFERENCED const UINT16 RcompTargetTglY[SA_MRC_MAX_RCOMP_TARGETS] = { 0, 0, 0, 0, 0 };

// LPDDR4 Type-4 RVP DQS byte swizzling between CPU and DRAM
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 DqsMapCpu2DramBoardIdTglYLp4Type4Crb [2][8] = {
  { 5, 4, 0, 1, 6, 7, 3, 2 }, // Channel 0
  { 5, 4, 0, 1, 6, 7, 3, 2 }, // Channel 1
};

// LPDDR4 Type-4 RVP DQS byte swizzling between CPU and DRAM
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 DqsMapCpu2DramTglYLp4Type4[8][2] = {
  // Ch 0     1         2         3
  { 1, 0 }, { 1, 0 }, { 0, 1 }, { 0, 1 }, // Controller 0
  { 0, 1 }, { 1, 0 }, { 1, 0 }, { 0, 1 }  // Controller 1
};

// DQS Map for CPU2DRAM for TGL Y LP4x AEP board
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 DqsMapCpu2DramTglYAepLp4Type4[8][2] = {
  // Ch 0     1         2         3
  { 1, 0 }, { 1, 0 }, { 0, 1 }, { 1, 0 }, // Controller 0
  { 1, 0 }, { 0, 1 }, { 0, 1 }, { 0, 1 }  // Controller 1
};

// LPDDR5 Type-4 RVP DQS byte swizzling between CPU and DRAM
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 DqsMapCpu2DramTglYLp5Type4[8][2] = {
  // Ch 0     1         2         3
  { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, // Controller 0
  { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }  // Controller 1
};

// DQ map for CPU-DRAM for TGL Y LP5x RVP
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 DqMapCpu2DramTglYLp5Type4[8][2][8] = {
  //Controller 0
  {{  0,  2,  4,  1,  6,  7,  3,  5 },  //Byte 0
  { 13, 11,  8,  9, 10, 12, 15, 14 }}, //Byte 1
  {{  3,  4,  0,  6,  7,  5,  2,  1 },  //Byte 2
  { 14, 12, 15,  8, 13, 10,  9, 11 }}, //Byte 3
  {{  0,  7,  2,  1,  4,  3,  5,  6 },  //Byte 4
  { 13, 14, 12, 15,  8,  9, 11, 10 }}, //Byte 5
  {{  0,  2,  1,  3,  6,  4,  5,  7 },  //Byte 6
  { 15, 14, 13, 12, 11, 10,  8,  9 }}, //Byte 7
                                       //Controller 1
  {{  2,  1,  0,  3,  7,  4,  5,  6 },  //Byte 0
  { 13, 14, 12, 11,  9, 10, 15,  8 }}, //Byte 1
  {{  0,  1,  2,  3,  6,  4,  7,  5 },  //Byte 2
  { 13, 14,  9, 15,  8, 12, 10, 11 }}, //Byte 3
  {{  3,  7,  0,  6,  1,  2,  5,  4 },  //Byte 4
  { 12, 15, 14, 13,  9, 10,  8, 11 }}, //Byte 5
  {{  3,  1,  0,  2,  4,  7,  6,  5 },  //Byte 6
  { 12, 14, 15,  8, 11, 13,  9, 10 }}  //Byte 7
};

/*
// DQ map for CPU-DRAM for TGL Y LP4x AEP board
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 DqMapCpu2DramTglYAepLp4Type4[8][2][8] = {
  //Controller 0
  {{ 10, 12, 13, 9, 11, 8, 15, 14 },   // Byte 0
  { 3, 0, 1, 5, 4, 7, 6, 2 }},         // Byte 1
  {{ 8, 10, 13, 9, 12, 15, 11, 14 },   // Byte 2
  { 3, 5, 7, 2, 1, 0, 4, 6 }},         // Byte 3
  {{ 1, 0, 3, 2, 5, 4, 7, 6 },         // Byte 4
  { 15, 14, 12, 13, 9, 8, 11, 10 }},   // Byte 5
  {{ 8, 9, 10, 11, 14, 12, 15, 13 },   // Byte 6
  { 5, 6, 7, 4, 2, 3, 1, 0 }},         // Byte 7
  //Controller 1
  {{ 9, 8 , 10 , 11, 12, 13, 14, 15 }, // Byte 0
  { 6, 7, 4, 5, 1, 2, 3, 0 }},         // Byte 1
  {{ 0, 1, 3, 2, 7, 4, 5, 6 },         // Byte 2
  { 15, 14, 9, 12, 8, 13, 11, 10 }},   // Byte 3
  {{ 7, 5, 3, 6, 1, 0, 4, 2 },         // Byte 4
  { 12, 14, 15, 13, 8, 11, 9, 10 }},   // Byte 5
  {{ 3, 7, 1, 6, 5, 4, 2, 0 },         // Byte 6
  { 12, 11, 8, 14, 10, 9 , 15, 13 }}   // Byte 7
};
*/

/*
// LPDDR4 Type-4 RVP DQ swizzling between CPU and DRAM
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 DqMapCpu2DramTglYLp4Type4[8][2][8] = {
  //Controller 0
  {{ 11,  8, 10,  9, 12, 13, 15, 14 },   // Byte 0
   {  3,  1,  0,  2,  4,  5,  6,  7 }},  // Byte 1
  {{ 11, 10,  8, 13,  9, 14, 12, 15 },   // Byte 2
   {  2,  1,  0,  4,  3,  5,  7,  6 }},  // Byte 3
  {{  0,  1,  2,  3,  5,  4,  6,  7 },   // Byte 4
   { 15, 14, 13, 12,  8,  9, 11, 10 }},  // Byte 5
  {{  7,  1,  0,  3,  6,  5,  4,  2 },   // Byte 6
   { 13, 15, 14, 12, 10,  8,  9, 11 }},  // Byte 7
  //Controller 1
  {{  1,  0,  3,  2,  5,  4,  7,  6 },   // Byte 0
   {  15, 14, 12, 13, 10, 11, 9,  8 }},  // Byte 1
  {{  8, 10,  9, 11,  14, 13, 15, 12 },  // Byte 2
   {  0,  2,  7,  3,  6,  1,  5,  4 }},  // Byte 3
  {{ 10, 11,  9,  8, 13, 12, 14, 15 },   // Byte 4
   {  5,  7,  6,  4,  0,  3,  1,  2 }},  // Byte 5
  {{  0,  2,  1,  4,  5,  6,  7,  3 },   // Byte 6
   { 14, 13, 12,  8, 11, 15,  9, 10 }}   // Byte 7
};
*/

// LPDDR4 Type-4 RVP DQS byte swizzling between CPU and DRAM
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 DqsMapCpu2DramTglYLp4Type4Crb[8][2] = {
  // Ch 0     1         2         3
  { 1, 0 }, { 0, 1 }, { 0, 1 }, { 1, 0 }, // Controller 0
  { 1, 0 }, { 0, 1 }, { 0, 1 }, { 1, 0 }  // Controller 1
};

/*
// LPDDR4 Type-4 RVP (New package) DQ swizzling between CPU and DRAM
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 DqMapCpu2DramTglYLp4Type4Crb[8][2][8] = {
  //Controller 0
  {{  8,  9, 12, 11, 13, 15, 10, 14 },   // Byte 0
   {  4,  6,  0,  2,  5,  7,  1,  3 }},  // Byte 1
  {{  2,  3,  0,  6,  1,  7,  5,  4 },   // Byte 2
   { 15, 14, 13,  8, 12, 11,  9, 10 }},  // Byte 3
  {{  1,  0,  3,  2,  5,  4,  7,  6 },   // Byte 4
   { 14, 15, 12, 13,  8, 10,  9, 11 }},  // Byte 5
  {{  8, 10, 11,  9, 15, 12, 14, 13 },   // Byte 6
   {  4,  7,  6,  5,  2,  0,  1,  3 }},   // Byte 7
//Controller 1
  {{  8,  9, 10, 11, 13, 12, 15, 14 },   // Byte 0
   {  7,  6,  4,  5,  0,  2,  1,  3 }},  // Byte 1
  {{  1,  3,  0,  2,  6,  4,  5,  7 },   // Byte 2
   { 14, 15, 10, 12,  8, 13, 11,  9 }},  // Byte 3
  {{  1,  0,  2,  4,  5,  3,  7,  6 },   // Byte 4
   { 12, 14, 15, 13,  9, 10,  8, 11 }},  // Byte 5
  {{ 11,  9,  8, 13, 12, 14, 15, 10 },   // Byte 6
   {  4,  7,  5,  1,  2,  6,  3,  0 }}   // Byte 7
};
*/

//
// DQ byte mapping to CMD/CTL/CLK, from the CPU side
// Used for TGL-Y LPDDR4 Type-4 RVP
//
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 DqByteMapTglY[2][6][2] = {
  // Channel 0:
  {
    { 0x0F, 0xF0 }, // CLK0 goes to package 0 - Bytes[3:0], CLK1 goes to package 1 - Bytes[7:4]
    { 0x0F, 0xF0 }, // Cmd CAA goes to Bytes[3:0], Cmd CAB goes to Byte[7:4]
    { 0xFF, 0x00 }, // CTL (CS) goes to all bytes
    { 0x00, 0x00 }, // Unused in TGL MRC
    { 0x00, 0x00 }, // Unused in TGL MRC
    { 0x00, 0x00 }, // Unused in TGL MRC
  },
  // Channel 1:
  {
    { 0x0F, 0xF0 }, // CLK0 goes to package 0 - Bytes[3:0], CLK1 goes to package 1 - Bytes[7:4]
    { 0x0F, 0xF0 }, // Cmd CAA goes to Bytes[3:0], Cmd CAB goes to Byte[7:4]
    { 0xFF, 0x00 }, // CTL (CS) goes to all bytes
    { 0x00, 0x00 }, // Unused in TGL MRC
    { 0x00, 0x00 }, // Unused in TGL MRC
    { 0x00, 0x00 }, // Unused in TGL MRC
  }
};

//
// Display DDI settings for TGL-Y LP4
//
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 mTglYRowDisplayDdiConfig[16] = {
                                                                               DdiPortEdp,      // DDI Port A Config : DdiPortDisabled = No LFP is Connected, DdiPortEdp = eDP, DdiPortMipiDsi = MIPI DSI
                                                                               DdiPortDisabled, // DDI Port B Config : DdiPortDisabled = No LFP is Connected, DdiPortEdp = eDP, DdiPortMipiDsi = MIPI DSI
                                                                               DdiHpdDisable,   // DDI Port A HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdEnable,    // DDI Port B HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port C HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 1 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 2 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 3 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 4 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiDisable,      // DDI Port A DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDdcEnable,    // DDI Port B DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port C DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 1 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 2 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 3 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable       // DDI Port 4 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
};

//
// Display DDI settings for TGL-Y LP DDR5
//
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 mTglYLpDdr5RowDisplayDdiConfig[16] = {
                                                                               DdiPortEdp,      // DDI Port A Config : DdiPortDisabled = No LFP is Connected, DdiPortEdp = eDP, DdiPortMipiDsi = MIPI DSI
                                                                               DdiPortDisabled, // DDI Port B Config : DdiPortDisabled = No LFP is Connected, DdiPortEdp = eDP, DdiPortMipiDsi = MIPI DSI
                                                                               DdiHpdDisable,   // DDI Port A HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port B HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port C HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 1 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 2 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 3 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 4 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiDisable,      // DDI Port A DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port B DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port C DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 1 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 2 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 3 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable       // DDI Port 4 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
};

//
// Display DDI settings for TGL-Y LPDDR4 with MIPI enabled on DDI-A.
//
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 mTglYLpDdr4MipiDisplayDdiConfig[16] = {
                                                                               DdiPortMipiDsi,  // DDI Port A Config : DdiPortDisabled = No LFP is Connected, DdiPortEdp = eDP, DdiPortMipiDsi = MIPI DSI
                                                                               DdiPortDisabled, // DDI Port B Config : DdiPortDisabled = No LFP is Connected, DdiPortEdp = eDP, DdiPortMipiDsi = MIPI DSI
                                                                               DdiHpdDisable,   // DDI Port A HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdEnable,    // DDI Port B HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port C HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 1 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 2 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 3 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 4 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiDisable,      // DDI Port A DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDdcEnable,    // DDI Port B DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port C DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 1 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 2 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 3 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable       // DDI Port 4 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
};

//
// Display DDI settings for TGL-Y LP DDR5 with MIPI enabled on DDI-A.
//
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 mTglYLpDdr5MipiDisplayDdiConfig[16] = {
                                                                               DdiPortMipiDsi,  // DDI Port A Config : DdiPortDisabled = No LFP is Connected, DdiPortEdp = eDP, DdiPortMipiDsi = MIPI DSI
                                                                               DdiPortDisabled, // DDI Port B Config : DdiPortDisabled = No LFP is Connected, DdiPortEdp = eDP, DdiPortMipiDsi = MIPI DSI
                                                                               DdiHpdDisable,   // DDI Port A HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port B HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port C HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 1 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 2 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 3 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 4 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiDisable,      // DDI Port A DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port B DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port C DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 1 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 2 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 3 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable       // DDI Port 4 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
};

//
// Display DDI settings for TGL-Y LPDDR4/LPDDR5 with Dual MIPI enabled.
//
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 mTglYDualMipiDisplayDdiConfig[16] = {
                                                                               DdiPortMipiDsi,  // DDI Port A Config : DdiPortDisabled = No LFP is Connected, DdiPortEdp = eDP, DdiPortMipiDsi = MIPI DSI
                                                                               DdiPortMipiDsi,  // DDI Port B Config : DdiPortDisabled = No LFP is Connected, DdiPortEdp = eDP, DdiPortMipiDsi = MIPI DSI
                                                                               DdiHpdDisable,   // DDI Port A HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port B HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port C HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 1 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 2 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 3 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 4 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiDisable,      // DDI Port A DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port B DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port C DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 1 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 2 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 3 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable       // DDI Port 4 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
};

//
// Display DDI settings for TGL-Y LPDDR4 with dual eDP enabled.
//
GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 mTglYLpDdr4DualEdpDisplayDdiConfig[16] = {
                                                                               DdiPortEdp,      // DDI Port A Config : DdiPortDisabled = No LFP is Connected, DdiPortEdp = eDP, DdiPortMipiDsi = MIPI DSI
                                                                               DdiPortEdp,      // DDI Port B Config : DdiPortDisabled = No LFP is Connected, DdiPortEdp = eDP, DdiPortMipiDsi = MIPI DSI
                                                                               DdiHpdDisable,   // DDI Port A HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port B HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port C HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 1 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 2 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 3 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiHpdDisable,   // DDI Port 4 HPD : DdiHpdDisable = Disable, DdiHpdEnable = Enable HPD
                                                                               DdiDisable,      // DDI Port A DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port B DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port C DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 1 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 2 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable,      // DDI Port 3 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
                                                                               DdiDisable       // DDI Port 4 DDC : DdiDisable = Disable, DdiDdcEnable = Enable DDC
};


#endif // _BOARD_SA_CONFIG_PRE_MEM_H_
