/** @file
  PCH USB OverCurrent Port mapping tables

@copyright
 Copyright (c) 2018 - 2019 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
  under a license and may only be used or copied in accordance
  with the terms of the license. Except as permitted by such
  license, no part of this software or documentation may be
  reproduced, stored in a retrieval system, or transmitted in any
  form or by any means without the express written consent of
  Intel Corporation.
  This file contains an 'Intel Peripheral Driver' and is
  licensed for Intel CPUs and chipsets under the terms of your
  license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the
  license agreement.
**/

#include "PchUsbOcMappingTable.h"

// Tiger Lake Y ERB specific USB2 OC mapping
// Tiger Lake Y Lp4 specific USB2 OC mapping
USB_OC_MAP_TABLE mTglYLp4Usb2OverCurrentMappingTable = USB_OC_MAP_TABLE_INIT (
  4,              // Port 1
  USB_OC_SKIP,    // Port 2
  3,              // Port 3
  0,              // Port 4
  5,              // Port 5
  6,              // Port 6
  USB_OC_SKIP,    // Port 7
  USB_OC_SKIP,    // Port 8
  USB_OC_SKIP,    // Port 9
  USB_OC_SKIP     // Port 10
);

// Tiger Lake Y Lp4 specific USB3 OC mapping
USB_OC_MAP_TABLE mTglYLp4Usb3OverCurrentMappingTable = USB_OC_MAP_TABLE_INIT (
  0,              // Port 1
  0,              // Port 2
  USB_OC_SKIP,    // Port 3
  USB_OC_SKIP     // Port 4
);

// Tiger Lake Y AEP specific USB2 OC mapping
USB_OC_MAP_TABLE mTglYAepUsb2OverCurrentMappingTable = USB_OC_MAP_TABLE_INIT (
  4,              // Port 1
  USB_OC_SKIP,    // Port 2
  USB_OC_SKIP,    // Port 3
  USB_OC_SKIP,    // Port 4
  5,              // Port 5
  6,              // Port 6
  USB_OC_SKIP,    // Port 7
  USB_OC_SKIP,    // Port 8
  USB_OC_SKIP,    // Port 9
  USB_OC_SKIP     // Port 10
);
