#
# This script is called to auto generate MicrocodeVersion.data
# parsing Boardpkg.fdf to build slot mode microcode array
#
# FwVersion, Lsv, FwVersionString, SlotSize are inputed by Prep.bat
# or passed from NewGenCap.py script when generating microcode capsule
#
import os
import struct
import re
import sys

def DoAddPaddingData(File, SlotSize):
  with open(File, "rb") as fd:
    Binary = fd.read()
    if len(Binary) > SlotSize:
      print (("Microcode patch %s is larger than slot size(%d)\n") % (File, SlotSize))
      assert (False)
    elif len(Binary) < SlotSize:
      FileBackUp = File.replace(os.path.splitext(File)[1], "_backup" + os.path.splitext(File)[1])
      with open(FileBackUp, "wb") as backup:
        backup.write(Binary)
      Binary = Binary + b'\xff' * (SlotSize - len(Binary))

  with open(File, "wb") as fd:
    fd.write(Binary)

def GetRealFilePath(Path):
  if len(Path.split()) > 1:
    FilePath = Path.split()[-1]
  else:
    FilePath = Path
  index = 0
  while True:
    index1 = FilePath.find("$(", index)
    if index1 == -1:
      break
    index2 = FilePath.find(")",index1)
    FilePath = FilePath.replace(FilePath[index1:index2+1], os.environ[FilePath[index1+2:index2]])
    index = index2 + 1
  return FilePath

def GenMicrocodeVersionRawData(FwVersion, Lsv, VersionString, Output):
  RawData = b''
  RawData = RawData + struct.pack('<I', FwVersion)
  RawData = RawData + struct.pack('<I', Lsv)
  RawData = RawData + VersionString.encode('utf-16-le')
  RawData = RawData + b'\0\0'

  fd = open(Output, "wb")
  fd.write(RawData)
  fd.close()

def GetActivePlatformDsc():
  with open(os.path.join (os.environ["WORKSPACE"], "Conf", "target.txt"), "r") as fd:
    for line in fd.readlines():
      line = line.strip("\n").strip()
      if len(line) != 0 and len(line.split("=")) == 2 and line.split("=")[0].strip() == "ACTIVE_PLATFORM":
        return line.split("=")[1].strip().strip("\n")
  print ("Find ACTIVE_PLATFORM from Conf\\target.txt fail!\n")
  assert(False)

def GetFdfFromDsc(File):
  with open(File, "r") as fd:
    for line in fd.readlines():
      if line.find("FLASH_DEFINITION") != -1:
        return line.split("=")[1].strip().strip("\n")
  print ("Find FLASH_DEFINITION from % fail!\n" % (File))
  assert(False)

if __name__ == "__main__":
  if len(sys.argv) != 5 and len(sys.argv) != 6:
    print ("Usage: %s <FwVersion> <Lsv> <FwVersionString> <SlotSize> [Fdf]" % (sys.argv[0]))
    quit()

  FwVersion = int(sys.argv[1], 16)
  Lsv = int(sys.argv[2], 16)
  FwVersionString = sys.argv[3].strip('"')
  SlotSize = int(sys.argv[4], 16)

  #
  # The sys.argv[5] is passed from NewGenCap.py script when generating Microcode capsule
  #
  if len(sys.argv) == 6:
    Fdf = sys.argv[5]
  else:
    Fdf = os.path.basename(GetRealFilePath(GetFdfFromDsc(GetActivePlatformDsc())))

  with open(Fdf) as fd:
    data = fd.read()

  result = re.findall(r"FILE *RAW *= *197DB236-F856-4924-90F8-CDF12FB875F3", data)
  #
  # assumption: just one fv for microcode
  #
  assert(len(result) == 1)

  #
  # Find FILE RAW section according 197DB236-F856-4924-90F8-CDF12FB875F3 GUID
  #
  index1 = data.find(result[0])
  index2 = data.find("}", index1)
  count = data[index1:index2].count("{") - 1
  while count > 0:
    index2 = data.find("}", index2 + 1)
  index2 = index2 + 1

  for line in data[index1:index2].split("\n"):
    line = line.strip("\n").strip()

    if line.find("#") != -1:
      index1 = line.find("#")
      index2 = len(line)
      line = line.replace(line[index1:index2],"")

    if len(line) == 0:
      continue

    line = line.strip("\n").strip()
    if line[-4:] not in [".pdb", ".mcb", ".bin"]:
      continue

    if SlotSize != 0:
      DoAddPaddingData(os.path.join(os.environ["WORKSPACE_PLATFORM"], GetRealFilePath(line)), SlotSize)

  #
  # generate MicrocodeVersion.data
  #
  GenMicrocodeVersionRawData (
    FwVersion,
    Lsv,
    FwVersionString,
    os.path.join(os.getcwd(), "Binaries", "Microcode", "MicrocodeVersion.data")
    )
