@REM @file
@REM
@REM @copyright
@REM  INTEL CONFIDENTIAL
@REM  Copyright 2017 - 2020 Intel Corporation.
@REM
@REM  The source code contained or described herein and all documents related to the
@REM  source code ("Material") are owned by Intel Corporation or its suppliers or
@REM  licensors. Title to the Material remains with Intel Corporation or its suppliers
@REM  and licensors. The Material may contain trade secrets and proprietary and
@REM  confidential information of Intel Corporation and its suppliers and licensors,
@REM  and is protected by worldwide copyright and trade secret laws and treaty
@REM  provisions. No part of the Material may be used, copied, reproduced, modified,
@REM  published, uploaded, posted, transmitted, distributed, or disclosed in any way
@REM  without Intel's prior express written permission.
@REM
@REM  No license under any patent, copyright, trade secret or other intellectual
@REM  property right is granted to or conferred upon you by disclosure or delivery
@REM  of the Materials, either expressly, by implication, inducement, estoppel or
@REM  otherwise. Any license under such intellectual property rights must be
@REM  express and approved by Intel in writing.
@REM
@REM  Unless otherwise agreed by Intel in writing, you may not remove or alter
@REM  this notice or any other notice embedded in Materials by Intel or
@REM  Intel's suppliers or licensors in any way.
@REM
@REM  This file contains a 'Sample Driver' and is licensed as such under the terms
@REM  of your license agreement with Intel or your vendor. This file may be modified
@REM  by the user, subject to the additional terms of the license agreement.
@REM
@REM @par Specification Reference:
@REM

@REM #
@REM #  Module Name:
@REM #
@REM #    postbuild.bat
@REM #
@REM #  Abstract:
@REM #
@REM #    Post build script.
@REM #
@REM #--*/

echo on

@set SCRIPT_ERROR=0

setlocal ENABLEDELAYEDEXPANSION
@echo Flash Map File %FLASHMAP_FDF%
@set PREMEM_FV_ADDRESS=

@if not defined PYTHON_COMMAND (
  set PYTHON_COMMAND=py -3
)

@if not defined WORKSPACE (
  echo.
  echo !!! ERROR !!! WORKSPACE must be defined before executing postbuild.bat !!!
  echo.
  set SCRIPT_ERROR=1
  goto :EOF
)

@if not defined WORKSPACE_PLATFORM (
  echo.
  echo !!! ERROR !!! WORKSPACE_PLATFORM must be defined before executing postbuild.bat !!!
  echo.
  set SCRIPT_ERROR=1
  goto :EOF
)

pushd %WORKSPACE%

@if not %CD% == %WORKSPACE% (
  echo.
  echo !!! ERROR !!! postbuild.bat is not executed under %WORKSPACE%
  echo.
  set SCRIPT_ERROR=1
  goto :EOF
)

@REM
REM Post-build FitGen
@REM
@set BIOS_INFO_GUID=4A4CA1C6-871C-45bb-8801-6910A7AA5807
@set STARTUP_AC_MODULE_GUID=26fdaa3d-b7ed-4714-8509-eecf1593800d
@set MICROCODE_ARRAY_FFS_GUID=197DB236-F856-4924-90F8-CDF12FB875F3

findstr %STARTUP_AC_MODULE_GUID% %BUILD_DIR%\FV\FvFwBinaries.inf > NUL
@if %errorlevel% NEQ 0 goto NoStartupAcm
set STARTUP_AC_PARA=-S %STARTUP_AC_MODULE_GUID%

:NoStartupAcm

@REM
REM Run FCE tool to write default setup variable to FD image
@REM
@if %SETUP_ENABLE% EQU FALSE (
  goto NoSetup
)
copy /y %BUILD_DIR%\FV\ClientBios.fd %BUILD_DIR%\FV\ClientBios_FcePre.fd
REM Prepend FvSetupData to enable processing
copy /y /b %BUILD_DIR%\FV\FvSetupData.fv + %BUILD_DIR%\FV\ClientBios.fd %BUILD_DIR%\FV\ClientSetup_Pre.fd
@REM UQI 0006 005C 0078 0030 0034 0039 0046 is for PlatId question prompt (STR_PLATID_PROMPT) UQI string value.
@REM First 0006 is the length of string; Next six byte values are mapped to STR_PLATID_PROMPT string value (\x049F) defined in %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Setup\UqiList.uni.
%EDK_TOOLS_BIN%\FCE.exe ^
read ^
-i %BUILD_DIR%\FV\ClientSetup_Pre.fd ^
0006 005C 0078 0030 0034 0039 0046 > %BUILD_DIR%\FV\ClientBios.fd.config
@if %errorlevel% NEQ 0 (
  set SCRIPT_ERROR=1
  goto EndPostBuild
)

REM Place FFS file in FvPreMemory
%EDK_TOOLS_BIN%\FCE.exe ^
update ^
-i %BUILD_DIR%\FV\ClientSetup_Pre.fd ^
-s %BUILD_DIR%\FV\ClientBios.fd.config ^
-o %BUILD_DIR%\FV\ClientSetup.fd ^
-g FC8FE6B5-CD9B-411E-BD8F-31824D0CDE3D ^
-a
@if %errorlevel% NEQ 0 (
  set SCRIPT_ERROR=1
  goto EndPostBuild
)

REM Strip FvSetupData back out of the image
@if not exist %BUILD_DIR%\FV\ClientSetup.fd (
  @echo Error: %BUILD_DIR%\FV\ClientSetup.fd not found
  set SCRIPT_ERROR=1
  goto EndPostBuild
)

split -f %BUILD_DIR%\FV\ClientSetup.fd -s 0x100000
@if %errorlevel% NEQ 0 (
  set SCRIPT_ERROR=1
  goto EndPostBuild
)
del %BUILD_DIR%\FV\ClientSetup.fd1
move /y %BUILD_DIR%\FV\ClientSetup.fd2 %BUILD_DIR%\FV\ClientBios_FcePost.fd

copy /y %BUILD_DIR%\FV\ClientBios_FcePost.fd %BUILD_DIR%\FV\ClientBios.fd

:NoSetup

@rem
@rem Capsule update fault tolerance support begin
@rem
@rem gObbSha256HashFileGuid
@set OBB_HASH_FILE_GUID=F57757FC-2603-404F-AAE2-34C6232388E8
@set OBB_HASH_TMP_FOLDER=%BUILD_DIR%\FV\ObbDigestTmp
@if %FSP_WRAPPER_BUILD% EQU TRUE (

  @rem
  @rem Get PcdFlashFvPreMemoryOffset from FlashmapInclude.fdf
  @rem
  @for /f "tokens=4" %%i in ('findstr /c:"gMinPlatformPkgTokenSpaceGuid\.PcdFlashFvPreMemoryOffset" %FLASHMAP_FDF%') do (set PREMEM_FV_ADDRESS=%%i)

  @if not exist %OBB_HASH_TMP_FOLDER% mkdir %OBB_HASH_TMP_FOLDER%
  @rem
  @rem Calculate FvMain SHA256 digest and replace DummySha256Digest.bin with it.
  @rem
  call %OPENSSL_PATH%\openssl.exe dgst -binary -sha256 %BUILD_DIR%\FV\FVADVANCED.Fv > %OBB_HASH_TMP_FOLDER%\ObbDigest.bin
  @rem
  @rem Prepare ObbDigest.ffs
  @rem
  call %EDK_TOOLS_BIN%\GenSec.exe -s EFI_SECTION_USER_INTERFACE -n "ObbDigest" -o %OBB_HASH_TMP_FOLDER%\ObbDigest.ui
  call %EDK_TOOLS_BIN%\GenSec.exe -s EFI_SECTION_RAW %OBB_HASH_TMP_FOLDER%\ObbDigest.bin -o %OBB_HASH_TMP_FOLDER%\ObbDigest.raw
  call %EDK_TOOLS_BIN%\GenFfs.exe -t EFI_FV_FILETYPE_FREEFORM -g %OBB_HASH_FILE_GUID% -o %OBB_HASH_TMP_FOLDER%\ObbDigest.ffs -i %OBB_HASH_TMP_FOLDER%\ObbDigest.raw -i %OBB_HASH_TMP_FOLDER%\ObbDigest.ui
  @rem Extract FvRecovery portion in order to save decoding time and use fixed FV-id in FMMT
  call split -f %BUILD_DIR%\FV\ClientBios.fd -s !PREMEM_FV_ADDRESS! -o %OBB_HASH_TMP_FOLDER%\ClientBios1.fd -t %OBB_HASH_TMP_FOLDER%\ClientBios2.fd
  @rem
  @rem Replace ObbDigest.ffs in ClientBios2.fd (FvRecovery) with the actual one
  @rem
  call %EDK_TOOLS_BIN%\FMMT.exe -r %OBB_HASH_TMP_FOLDER%\ClientBios2.fd FV0 ObbDigest %OBB_HASH_TMP_FOLDER%\ObbDigest.ffs %OBB_HASH_TMP_FOLDER%\ClientBios2_digest.fd
  copy /y /b %OBB_HASH_TMP_FOLDER%\ClientBios1.fd + %OBB_HASH_TMP_FOLDER%\ClientBios2_digest.fd %OBB_HASH_TMP_FOLDER%\ClientBios.fd
  move /y %OBB_HASH_TMP_FOLDER%\ClientBios.fd %BUILD_DIR%\FV\ClientBios.fd
  if exist %OBB_HASH_TMP_FOLDER% rmdir /q /s %OBB_HASH_TMP_FOLDER%
)
@rem
@rem Capsule update fault tolerance support end
@rem

@rem
@rem ChasmFalls Resiliency support begin
@rem
@rem gIbbSha256HashFileGuid
@set IBB_HASH_FILE_GUID=f53fc14b-025c-4477-9b48-7a1b19f80f30
@set OBBR_HASH_FILE_GUID=318d30b7-f669-4af2-ade1-e3f84d097bb3
@set OBBR_DIGEST_HASH_FILE_GUID=7ed53efb-bb3d-4066-b3ed-8262e2d21e70
@set HASH_TMP_FOLDER=%BUILD_DIR%\FV\BgslTmp
@set BIOS_GUARD_UPDATE_PACKAGE_PATH=%WORKSPACE_PLATFORM%\TigerLakePlatSamplePkg\InternalOnly\ToolScripts\BiosGuard\UpdatePackage\
@if %RESILIENCY_BUILD% EQU TRUE (
  @if not exist %HASH_TMP_FOLDER% mkdir %HASH_TMP_FOLDER%
  @rem
  @rem Generate SPI_to_SPI sync/rollback BIOS Guard script.
  @rem
  call %BIOS_GUARD_UPDATE_PACKAGE_PATH%\BuildBGUP_SPI.bat -p script_BuildBGUP_template_Pri_Sec_Sync.bgsl
  python %BIOS_GUARD_UPDATE_PACKAGE_PATH%\BiosGuardCapsule.py -i update_package.BIOS_Guard -o capsule_update_package.BIOS_Guard
  copy /b capsule_update_package.BIOS_Guard + update_package_bgupc.biosguard %HASH_TMP_FOLDER%\IbbBgsl.bin
  @rem
  @rem Generate OBB_to_SPI BIOS Guard script.
  @rem
  split -f %BUILD_DIR%\FV\ClientBios.fd -s 0x660000 -o %HASH_TMP_FOLDER%\OBBx.bin -t %HASH_TMP_FOLDER%\IBBx.bin
  split -f %HASH_TMP_FOLDER%\OBBx.bin -s 0x60000 -t %HASH_TMP_FOLDER%\OBB.bin -o %HASH_TMP_FOLDER%\Remaining.bin

  call %BIOS_GUARD_UPDATE_PACKAGE_PATH%\BuildBGUP_SPI.bat -d %HASH_TMP_FOLDER%\Obb.bin -p script_BuildBGUP_OBBR_template.bgsl
  python %BIOS_GUARD_UPDATE_PACKAGE_PATH%\BiosGuardCapsule.py -i update_package.BIOS_Guard -o capsule_update_package.BIOS_Guard
  copy /b capsule_update_package.BIOS_Guard + update_package_bgupc.biosguard %HASH_TMP_FOLDER%\ObbRBgsl.bin
  call %OPENSSL_PATH%\openssl.exe dgst -binary -sha256 %HASH_TMP_FOLDER%\Obb.bin > %HASH_TMP_FOLDER%\ObbRDigest.bin
  @rem
  @rem Prepare IbbBgsl.ffs and ObbRBgsl.ffs
  @rem
  call %EDK_TOOLS_BIN%\GenSec.exe -s EFI_SECTION_USER_INTERFACE -n "IbbBgsl" -o %HASH_TMP_FOLDER%\IbbBgsl.ui
  call %EDK_TOOLS_BIN%\GenSec.exe -s EFI_SECTION_RAW %HASH_TMP_FOLDER%\IbbBgsl.bin -o %HASH_TMP_FOLDER%\IbbBgsl.raw
  call %EDK_TOOLS_BIN%\GenFfs.exe -t EFI_FV_FILETYPE_FREEFORM -g %IBB_HASH_FILE_GUID% -o %HASH_TMP_FOLDER%\IbbBgsl.ffs -i %HASH_TMP_FOLDER%\IbbBgsl.raw -i %HASH_TMP_FOLDER%\IbbBgsl.ui
  call %EDK_TOOLS_BIN%\GenSec.exe -s EFI_SECTION_USER_INTERFACE -n "ObbRBgsl" -o %HASH_TMP_FOLDER%\ObbRBgsl.ui
  call %EDK_TOOLS_BIN%\GenSec.exe -s EFI_SECTION_RAW %HASH_TMP_FOLDER%\ObbRBgsl.bin -o %HASH_TMP_FOLDER%\ObbRBgsl.raw
  call %EDK_TOOLS_BIN%\GenFfs.exe -t EFI_FV_FILETYPE_FREEFORM -g %OBBR_HASH_FILE_GUID% -o %HASH_TMP_FOLDER%\ObbRBgsl.ffs -i %HASH_TMP_FOLDER%\ObbRBgsl.raw -i %HASH_TMP_FOLDER%\ObbRBgsl.ui
  call %EDK_TOOLS_BIN%\GenSec.exe -s EFI_SECTION_USER_INTERFACE -n "ObbRDigest" -o %HASH_TMP_FOLDER%\ObbRDigest.ui
  call %EDK_TOOLS_BIN%\GenSec.exe -s EFI_SECTION_RAW %HASH_TMP_FOLDER%\ObbRDigest.bin -o %HASH_TMP_FOLDER%\ObbRDigest.raw
  call %EDK_TOOLS_BIN%\GenFfs.exe -t EFI_FV_FILETYPE_FREEFORM -g %OBBR_DIGEST_HASH_FILE_GUID% -o %HASH_TMP_FOLDER%\ObbRDigest.ffs -i %HASH_TMP_FOLDER%\ObbRDigest.raw -i %HASH_TMP_FOLDER%\ObbRDigest.ui
  @rem Extract FvRecovery portion in order to save decoding time and use fixed FV-id in FMMT
  call split -f %BUILD_DIR%\FV\ClientBios.fd -s !PREMEM_FV_ADDRESS! -o %HASH_TMP_FOLDER%\ClientBios1.fd -t %HASH_TMP_FOLDER%\ClientBios2.fd
  @rem
  @rem Replace ObbDigest.ffs in ClientBios2.fd (FvRecovery) with the actual one
  @rem
  call %EDK_TOOLS_BIN%\FMMT.exe -r %HASH_TMP_FOLDER%\ClientBios2.fd FV0 IbbBgsl %HASH_TMP_FOLDER%\IbbBgsl.ffs %HASH_TMP_FOLDER%\ClientBios2_digest.fd
  call %EDK_TOOLS_BIN%\FMMT.exe -r %HASH_TMP_FOLDER%\ClientBios2.fd FV0 ObbRBgsl %HASH_TMP_FOLDER%\ObbRBgsl.ffs %HASH_TMP_FOLDER%\ClientBios2_digest.fd
  call %EDK_TOOLS_BIN%\FMMT.exe -r %HASH_TMP_FOLDER%\ClientBios2.fd FV0 ObbRDigest %HASH_TMP_FOLDER%\ObbRDigest.ffs %HASH_TMP_FOLDER%\ClientBios2_digest.fd
  copy /y /b %HASH_TMP_FOLDER%\ClientBios1.fd + %HASH_TMP_FOLDER%\ClientBios2_digest.fd %HASH_TMP_FOLDER%\ClientBios.fd
  move /y %HASH_TMP_FOLDER%\ClientBios.fd %BUILD_DIR%\FV\ClientBios.fd
  if exist %HASH_TMP_FOLDER% rmdir /q /s %HASH_TMP_FOLDER%
  )
)
@rem
@rem ChasmFalls Rresiliency support end
@rem

@REM
REM Run FitGen tool to generate FIT
@REM
copy %BUILD_DIR%\FV\ClientBios.fd %BUILD_DIR%\FV\ClientBios_FitPre.fd /Y

@REM
@REM FitGen parameter usage reference:
@REM   -D It is FD file instead of FV file.
@REM   -F <FitTablePointerOffset>
@REM   -L <MicrocodeSlotSize> <MicrocodeFfsGuid>
@REM   -I <BiosInfoGuid>
@REM   -NA No 0x800 aligned Microcode requirement. No -NA means Microcode is 0x800 aligned.
@REM   -O RecordType <RecordDataAddress RecordDataSize>|<RESERVE RecordDataSize>
@REM   -P RecordType <IndexPort DataPort Width Bit Index>
@REM
@REM For slot mode, the SLOT_SIZE envir variable already defined in prep.bat script
@REM
%EDK_TOOLS_BIN%\FitGen.exe ^
-D ^
%BUILD_DIR%\FV\ClientBios.fd ^
%BUILD_DIR%\FV\ClientBios.fd ^
-F 0x40 ^
-NA ^
-L %SLOT_SIZE% %MICROCODE_ARRAY_FFS_GUID% ^
-I %BIOS_INFO_GUID% ^
%STARTUP_AC_PARA% ^
-O 0x0C RESERVE 0x600 ^
-O 0x0B RESERVE 0x400 ^
-P 0xA 0x70 0x71 0x1 0x4 0x2a

@if %errorlevel% NEQ 0 (
 echo Error: FitGen failure
 set SCRIPT_ERROR=1
 goto EndPostBuild
)

copy /b %BUILD_DIR%\FV\ClientBios.fd %BUILD_DIR%\FV\ClientBios_Post_Fit.fd /Y

:SkipGenFitTable

@if exist %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\InternalOnly\ToolScripts\KeyEnroll\MsEnrollRestricted.bat (
  call %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\InternalOnly\ToolScripts\KeyEnroll\MsEnrollRestricted.bat %WORKSPACE_ROOT%\%BUILD_DIR%
)

@REM
REM Remove MinPlatformPkg module instances that are overridden in TigerLakeBoardPkg
@REM
copy %BUILD_DIR%\FV\ClientBios.fd %BUILD_DIR%\FV\ClientBios_FmmtPre.fd /Y

@set MODULE_REMOVER_CMD=py -3 %WORKSPACE_PLATFORM%\%PLATFORM_BOARD_PACKAGE%\module_remover.py
@set FMMT_PATH=%EDK_TOOLS_BIN%\FMMT.exe

@set MODULE_LIST=UiApp

%MODULE_REMOVER_CMD% %FMMT_PATH% %BUILD_DIR%\FV\ClientBios.fd %MODULE_LIST%
@if %errorlevel% NEQ 0 (
  @echo Failure in running FMMT by module remover.
  set SCRIPT_ERROR=1
  goto EndPostBuild
)

@if %STARTUP_ACM_ENABLE% EQU FALSE (
  goto :NoAcm
)

@REM
@echo Create BTG keymanifest and Boot Policy Manifest
@REM

@rem
if exist %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\Tools\ToolScripts\BpmGen\postbuildBpmGen.bat (
  call %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\Tools\ToolScripts\BpmGen\postbuildBpmGen.bat ClientBios  ClientBios
  if %SCRIPT_ERROR% NEQ 0 goto :NoAcm
)

@rem NOTE: postbuildBpmGen.bat will copy the updated .fd with KEYM/BPM as ClientBios.fd (passed as second parameter)
@rem
@rem The invocation to the BpmGen tool should be the last step of the build process, with no further modifications to the BIOS
@rem binary; any change will invalidate the reference hashes computed by BpmGen and required for verified boot flows.
@rem The only exception to this case being: replacing the pre-production ACM binaries with production signed ACM when creating
@rem the Prod_*.rom BIOS binaries.

:NoAcm

if not exist %WORKSPACE_ROM% mkdir %WORKSPACE_ROM%

@echo ---Create ROM and Simics images---
call %WORKSPACE_PLATFORM%\%PLATFORM_FULL_PACKAGE%\Tools\RomImage\SetupRomDirs.bat


:EndPostBuild
@set STARTUP_AC_MODULE_GUID=
@set BIOS_INFO_GUID=
@set STARTUP_AC_PARA=
@popd
endlocal && set SCRIPT_ERROR=%SCRIPT_ERROR%
