Scope(\_SB.PC00.I2C3) {

  Device(PA01)
  {
      Name(_HID, "MCHP1930")
      Name(_UID, 1)
  
      //
      // Lowest power D-State supported by the device is D3
      //
      Name (_S0W, 3)
  
      //
      // Status:
      // Device is present, enabled, and functioning properly
      //
      Method(_STA, 0x0, NotSerialized)
      {
          If (E3EN)
          {
            Return(0xf)
          }
          Else
          {
            Return(0)
          }
          
      }
  
      Method(_INI) {
        //SHPO(GPIO_CNL_LP_GPP_C23,1) // set gpio ownership to driver(0=ACPI mode, 1=GPIO mode)
      }
  
      //
      // Current Resources Settings
      //
      Method(_CRS, 0x0, NotSerialized)
      {
          Name(RBUF, ResourceTemplate()
          {          
                  I2CSerialBus(0x10,                  // 7-bit Slave Address
                              ControllerInitiated,    // Slave or master?
                              400000,                 // Connection Speed in hz
                              AddressingMode7Bit,     // 7-bit or 10-bit addressing?
                              "\\_SB.PC00.I2C3",      // I2C Controller to which PAC is connected
                              0,                      // Resource Index
                              ResourceConsumer)       // Consumer or Producer?

          })
          Return(RBUF)
      }


      // 
      // _DSM - Device Specific Method
      // 
      // This method returns configuration information that tells the driver
      // which devices each line in the PAC193x is wired to monitor.
      // Names of the monitored devices must come from the Microsoft-defined
      // power rail taxonomy.
      //
      // The UUID for the Microchip PAC193x's DSM is {033771E0-1705-47B4-9535-D1BBE14D9A09}.
      // This is unique to the device, and must match what the Windows PAC193x driver expects.
      //
      // Returns:
      //         Either: A Buffer (for Functions 0 and 2, or an error)
      //                 A Package containing EMI resources (rail/resistor pairs)
      //
      // Input Arguments (per _DSM standard):
      //
      //     Arg0: UUID - Function Identifier 
      //     Arg1: Integer - Revision 
      //     Arg2: Integer - Function Index 
      //     Arg3: Package - Parameters (not used in our implementation)
      // 
      Function(_DSM, {BuffObj, PkgObj}, {BuffObj, IntObj, IntObj, PkgObj})
      { 
      
          //
          //  Is our UUID being invoked?
          //
          if(LNotEqual(Arg0, ToUUID("033771E0-1705-47B4-9535-D1BBE14D9A09")))
          {
          
              //
              // It's NOT our UUID -- Just return a NULL for error
              //
              return(Buffer() {0x0}) 
          }
      
          //
          // Switch based on the function number requested...
          //
          switch(ToInteger(Arg2))
          {
              //
              // Function zero returns a bit-mask of supported functions
              //
              case(0) 
              {
                  //
                  // Revision 0 is the only revision presently defined
                  //
                  if(LEqual(Arg1, 0x00)) 
                  {
                      //
                      // Functions 0,1, and 2 are supported
                      //
                      return(Buffer() {0x03}) 
                  }
              
                  break;
              }
      
              //
              // Function one returns the Channel Info Package
              //
              case(1)
              {
                  // 
                  // Revision 0 is the only revision presently defined.
                  // 
                  If(LEqual(Arg1, 0x0)) 
                  { 
                      //
                      // Return channel info with alternating names and resistor values.
                      //
                      // NOTE:  TODO:  The supplied values ARE ONLY EXAMPLES.
                      //               Change to match wiring on platform.
        							//
        							//               See Channel 3 in the example for how to set
        							//               a given channel to be "unused".
                      // 
                      Name(PBUF, Package() 
                      { 
                        //
                        // Power
                        // Rail                   Resistor
                        // Name                 Value(mohm)
                        //
                        "VCCSTG",           10,        // Channel 1
                        "VCCIN",   	    	  1,         // Channel 2
                        "VCCIN_AUX",	      1,         // Channel 3
                        "VCCST",     	      10         // Channel 4
                      }) 
                  
                      return(PBUF) 
                  } 

                  break;
              }
          } // switch(Arg2)

          //
          // Return an error (a buffer with a value of zero) 
          // if we didn't return anything else above
          //
          return(Buffer() {0x0}) 

      } // _DSM 
  }
        
  Device(PA02)
  {
      Name(_HID, "MCHP1930")
      Name(_UID, 2)
  
      //
      // Lowest power D-State supported by the device is D3
      //
      Name (_S0W, 3)
  
      //
      // Status:
      // Device is present, enabled, and functioning properly
      //
      Method(_STA, 0x0, NotSerialized)
      {
          If (E3EN)
          {
            Return(0xf)
          }
          Else
          {
            Return(0)
          }
          
      }
  
      //
      // Current Resources Settings
      //
      Method(_CRS, 0x0, NotSerialized)
      {

          Name(RBUF, ResourceTemplate()
          {          
                  I2CSerialBus(0x11,                  // 7-bit Slave Address
                              ControllerInitiated,    // Slave or master?
                              400000,                 // Connection Speed in hz
                              AddressingMode7Bit,     // 7-bit or 10-bit addressing?
                              "\\_SB.PC00.I2C3",      // I2C Controller to which PAC is connected
                              0,                      // Resource Index
                              ResourceConsumer)       // Consumer or Producer?
          })
          Return(RBUF)               
      }

      // 
      // _DSM - Device Specific Method
      // 
      // This method returns configuration information that tells the driver
      // which devices each line in the PAC193x is wired to monitor.
      // Names of the monitored devices must come from the Microsoft-defined
      // power rail taxonomy.
      //
      // The UUID for the Microchip PAC193x's DSM is {033771E0-1705-47B4-9535-D1BBE14D9A09}.
      // This is unique to the device, and must match what the Windows PAC193x driver expects.
      //
      // Returns:
      //         Either: A Buffer (for Functions 0 and 2, or an error)
      //                 A Package containing EMI resources (rail/resistor pairs)
      //
      // Input Arguments (per _DSM standard):
      //
      //     Arg0: UUID - Function Identifier 
      //     Arg1: Integer - Revision 
      //     Arg2: Integer - Function Index 
      //     Arg3: Package - Parameters (not used in our implementation)
      // 
      Function(_DSM, {BuffObj, PkgObj}, {BuffObj, IntObj, IntObj, PkgObj})
      { 
      
          //
          //  Is our UUID being invoked?
          //
          if(LNotEqual(Arg0, ToUUID("033771E0-1705-47B4-9535-D1BBE14D9A09")))
          {
          
              //
              // It's NOT our UUID -- Just return a NULL for error
              //
              return(Buffer() {0x0}) 
          }
      
          //
          // Switch based on the function number requested...
          //
          switch(ToInteger(Arg2))
          {
              //
              // Function zero returns a bit-mask of supported functions
              //
              case(0) 
              {
                  //
                  // Revision 0 is the only revision presently defined
                  //
                  if(LEqual(Arg1, 0x00)) 
                  {
                      //
                      // Functions 0,1, and 2 are supported
                      //
                      return(Buffer() {0x03}) 
                  }
              
                  break;
              }
      
              //
              // Function one returns the Channel Info Package
              //
              case(1)
              {
                  // 
                  // Revision 0 is the only revision presently defined.
                  // 
                  If(LEqual(Arg1, 0x0)) 
                  { 
                      //
                      // Return channel info with alternating names and resistor values.
                      //
                      // NOTE:  TODO:  The supplied values ARE ONLY EXAMPLES.
                      //               Change to match wiring on platform.
        							//
        							//               See Channel 3 in the example for how to set
        							//               a given channel to be "unused".
                      // 
                      Name(PBUF, Package() 
                      { 
                        //
                        // Power
                        // Rail                     Resistor
                        // Name                   Value(mohm)
                        //
                        "5VAUX",    		    2,          // Channel 1
                        "3VDX_EDP",    		  10,         // Channel 2
                        "3V_TOUCH",        	10,         // Channel 3
                        "VCCPGPPR_1P8",    	10          // Channel 4 
                      }) 
                  
                      return(PBUF) 
                  } 

                  break;
              }

          } // switch(Arg2)

          //
          // Return an error (a buffer with a value of zero) 
          // if we didn't return anything else above
          //
          return(Buffer() {0x0}) 

      } // _DSM 
  }

  Device(PA03)
  {
      Name(_HID, "MCHP1930")
      Name(_UID, 3)
  
      //
      // Lowest power D-State supported by the device is D3
      //
      Name (_S0W, 3)
  
      //
      // Status:
      // Device is present, enabled, and functioning properly
      //
      Method(_STA, 0x0, NotSerialized)
      {
          If (E3EN)
          {
            Return(0xf)
          }
          Else
          {
            Return(0)
          }
          
      }
  
      //
      // Current Resources Settings
      //
      Method(_CRS, 0x0, NotSerialized)
      {

          Name(RBUF, ResourceTemplate()
          {          
                  I2CSerialBus(0x12,                  // 7-bit Slave Address
                              ControllerInitiated,    // Slave or master?
                              400000,                 // Connection Speed in hz
                              AddressingMode7Bit,     // 7-bit or 10-bit addressing?
                              "\\_SB.PC00.I2C3",      // I2C Controller to which PAC is connected
                              0,                      // Resource Index
                              ResourceConsumer)       // Consumer or Producer?
          })
      
          Return(RBUF)
      }

      // 
      // _DSM - Device Specific Method
      // 
      // This method returns configuration information that tells the driver
      // which devices each line in the PAC193x is wired to monitor.
      // Names of the monitored devices must come from the Microsoft-defined
      // power rail taxonomy.
      //
      // The UUID for the Microchip PAC193x's DSM is {033771E0-1705-47B4-9535-D1BBE14D9A09}.
      // This is unique to the device, and must match what the Windows PAC193x driver expects.
      //
      // Returns:
      //         Either: A Buffer (for Functions 0 and 2, or an error)
      //                 A Package containing EMI resources (rail/resistor pairs)
      //
      // Input Arguments (per _DSM standard):
      //
      //     Arg0: UUID - Function Identifier 
      //     Arg1: Integer - Revision 
      //     Arg2: Integer - Function Index 
      //     Arg3: Package - Parameters (not used in our implementation)
      // 
      Function(_DSM, {BuffObj, PkgObj}, {BuffObj, IntObj, IntObj, PkgObj})
      { 
      
          //
          //  Is our UUID being invoked?
          //
          if(LNotEqual(Arg0, ToUUID("033771E0-1705-47B4-9535-D1BBE14D9A09")))
          {
          
              //
              // It's NOT our UUID -- Just return a NULL for error
              //
              return(Buffer() {0x0}) 
          }
      
          //
          // Switch based on the function number requested...
          //
          switch(ToInteger(Arg2))
          {
              //
              // Function zero returns a bit-mask of supported functions
              //
              case(0) 
              {
                  //
                  // Revision 0 is the only revision presently defined
                  //
                  if(LEqual(Arg1, 0x00)) 
                  {
                      //
                      // Functions 0,1, and 2 are supported
                      //
                      return(Buffer() {0x03}) 
                  }
              
                  break;
              }
      
              //
              // Function one returns the Channel Info Package
              //
              case(1)
              {
                  // 
                  // Revision 0 is the only revision presently defined.
                  // 
                  If(LEqual(Arg1, 0x0)) 
                  { 
                      //
                      // Return channel info with alternating names and resistor values.
                      //
                      // NOTE:  TODO:  The supplied values ARE ONLY EXAMPLES.
                      //               Change to match wiring on platform.
        							//
        							//               See Channel 3 in the example for how to set
        							//               a given channel to be "unused".
                      // 
                      Name(PBUF, Package() 
                      { 
                        //
                        // Power
                        // Rail                         Resistor
                        // Name                       Value(mohm)
                        //
                        "3VALW",		          10,        // Channel 1
                        "V_BL",   	          10,        // Channel 2
                        "3VDX_WLAN",   	      10,        // Channel 3
                        "1P8VAUX", 	          10         // Channel 4
                      }) 
                  
                      return(PBUF) 
                  } 

                  break;
              }
          } // switch(Arg2)

          //
          // Return an error (a buffer with a value of zero) 
          // if we didn't return anything else above
          //
          return(Buffer() {0x0}) 

      } // _DSM 
  }
		
	Device(PA04)
  {
      Name(_HID, "MCHP1930")
      Name(_UID, 4)
  
      //
      // Lowest power D-State supported by the device is D3
      //
      Name (_S0W, 3)
  
      //
      // Status:
      // Device is present, enabled, and functioning properly
      //
      Method(_STA, 0x0, NotSerialized)
      {
          If (E3EN)
          {
            Return(0xf)
          }
          Else
          {
            Return(0)
          }
          
      }
  
      //
      // Current Resources Settings
      //
      Method(_CRS, 0x0, NotSerialized)
      {

          Name(RBUF, ResourceTemplate()
          {          
                  I2CSerialBus(0x13,                  // 7-bit Slave Address
                              ControllerInitiated,    // Slave or master?
                              400000,                 // Connection Speed in hz
                              AddressingMode7Bit,     // 7-bit or 10-bit addressing?
                              "\\_SB.PC00.I2C3",      // I2C Controller to which PAC is connected
                              0,                      // Resource Index
                              ResourceConsumer)       // Consumer or Producer?
          })
      
          Return(RBUF)
      }

      // 
      // _DSM - Device Specific Method
      // 
      // This method returns configuration information that tells the driver
      // which devices each line in the PAC193x is wired to monitor.
      // Names of the monitored devices must come from the Microsoft-defined
      // power rail taxonomy.
      //
      // The UUID for the Microchip PAC193x's DSM is {033771E0-1705-47B4-9535-D1BBE14D9A09}.
      // This is unique to the device, and must match what the Windows PAC193x driver expects.
      //
      // Returns:
      //         Either: A Buffer (for Functions 0 and 2, or an error)
      //                 A Package containing EMI resources (rail/resistor pairs)
      //
      // Input Arguments (per _DSM standard):
      //
      //     Arg0: UUID - Function Identifier 
      //     Arg1: Integer - Revision 
      //     Arg2: Integer - Function Index 
      //     Arg3: Package - Parameters (not used in our implementation)
      // 
      Function(_DSM, {BuffObj, PkgObj}, {BuffObj, IntObj, IntObj, PkgObj})
      { 
      
          //
          //  Is our UUID being invoked?
          //
          if(LNotEqual(Arg0, ToUUID("033771E0-1705-47B4-9535-D1BBE14D9A09")))
          {
          
              //
              // It's NOT our UUID -- Just return a NULL for error
              //
              return(Buffer() {0x0}) 
          }
      
          //
          // Switch based on the function number requested...
          //
          switch(ToInteger(Arg2))
          {
              //
              // Function zero returns a bit-mask of supported functions
              //
              case(0) 
              {
                  //
                  // Revision 0 is the only revision presently defined
                  //
                  if(LEqual(Arg1, 0x00)) 
                  {
                      //
                      // Functions 0,1, and 2 are supported
                      //
                      return(Buffer() {0x03}) 
                  }
              
                  break;
              }
      
              //
              // Function one returns the Channel Info Package
              //
              case(1)
              {
                  // 
                  // Revision 0 is the only revision presently defined.
                  // 
                  If(LEqual(Arg1, 0x0)) 
                  { 
                      //
                      // Return channel info with alternating names and resistor values.
                      //
                      // NOTE:  TODO:  The supplied values ARE ONLY EXAMPLES.
                      //               Change to match wiring on platform.
        							//
        							//               See Channel 3 in the example for how to set
        							//               a given channel to be "unused".
                      // 
                      Name(PBUF, Package() 
                      { 
                        //
                        // Power
                        // Rail                         Resistor
                        // Name                       Value(mohm)
                        //
                        "CHARGER",         	  10,        // Channel 1
                        "CHG2",  		          10,        // Channel 2
                        "VCCPRIM_1P8",    		10,        // Channel 3
                        "3VDX_SSD",       	  10         // Channel 4
                      }) 
                  
                      return(PBUF) 
                  } 

                  break;
              }

          } // switch(Arg2)

          //
          // Return an error (a buffer with a value of zero) 
          // if we didn't return anything else above
          //
          return(Buffer() {0x0}) 

      } // _DSM 
  }
		
  Device(PA05)
  {
      Name(_HID, "MCHP1930")
      Name(_UID, 5)
  
      //
      // Lowest power D-State supported by the device is D3
      //
      Name (_S0W, 3)
  
      //
      // Status:
      // Device is present, enabled, and functioning properly
      //
      Method(_STA, 0x0, NotSerialized)
      {
          If (E3EN)
          {
            Return(0xf)
          }
          Else
          {
            Return(0)
          }
          
      }
  
      //
      // Current Resources Settings
      //
      Method(_CRS, 0x0, NotSerialized)
      {

          Name(RBUF, ResourceTemplate()
          {          
                  I2CSerialBus(0x14,                  // 7-bit Slave Address
                              ControllerInitiated,    // Slave or master?
                              400000,                 // Connection Speed in hz
                              AddressingMode7Bit,     // 7-bit or 10-bit addressing?
                              "\\_SB.PC00.I2C3",      // I2C Controller to which PAC is connected
                              0,                      // Resource Index
                              ResourceConsumer)       // Consumer or Producer?
          })
      
          Return(RBUF)
      }

      // 
      // _DSM - Device Specific Method
      // 
      // This method returns configuration information that tells the driver
      // which devices each line in the PAC193x is wired to monitor.
      // Names of the monitored devices must come from the Microsoft-defined
      // power rail taxonomy.
      //
      // The UUID for the Microchip PAC193x's DSM is {033771E0-1705-47B4-9535-D1BBE14D9A09}.
      // This is unique to the device, and must match what the Windows PAC193x driver expects.
      //
      // Returns:
      //         Either: A Buffer (for Functions 0 and 2, or an error)
      //                 A Package containing EMI resources (rail/resistor pairs)
      //
      // Input Arguments (per _DSM standard):
      //
      //     Arg0: UUID - Function Identifier 
      //     Arg1: Integer - Revision 
      //     Arg2: Integer - Function Index 
      //     Arg3: Package - Parameters (not used in our implementation)
      // 
      Function(_DSM, {BuffObj, PkgObj}, {BuffObj, IntObj, IntObj, PkgObj})
      { 
      
          //
          //  Is our UUID being invoked?
          //
          if(LNotEqual(Arg0, ToUUID("033771E0-1705-47B4-9535-D1BBE14D9A09")))
          {
          
              //
              // It's NOT our UUID -- Just return a NULL for error
              //
              return(Buffer() {0x0}) 
          }
      
          //
          // Switch based on the function number requested...
          //
          switch(ToInteger(Arg2))
          {
              //
              // Function zero returns a bit-mask of supported functions
              //
              case(0) 
              {
                  //
                  // Revision 0 is the only revision presently defined
                  //
                  if(LEqual(Arg1, 0x00)) 
                  {
                      //
                      // Functions 0,1, and 2 are supported
                      //
                      return(Buffer() {0x03}) 
                  }
              
                  break;
              }
      
              //
              // Function one returns the Channel Info Package
              //
              case(1)
              {
                  // 
                  // Revision 0 is the only revision presently defined.
                  // 
                  If(LEqual(Arg1, 0x0)) 
                  { 
                      //
                      // Return channel info with alternating names and resistor values.
                      //
                      // NOTE:  TODO:  The supplied values ARE ONLY EXAMPLES.
                      //               Change to match wiring on platform.
        							//
        							//               See Channel 3 in the example for how to set
        							//               a given channel to be "unused".
                      // 
                      Name(PBUF, Package() 
                      { 
                        //
                        // Power
                        // Rail                         Resistor
                        // Name                       Value(mohm)
                        //
                        "1P8_CODEC",   	      10,        // Channel 1
                        "1.1VSUS_MEM",   		   2,        // Channel 2
                        "3P3_DSW_PRIM",     	10,        // Channel 3
                        "1.8VSUS_MEM",       	10         // Channel 4
                      }) 
                  
                      return(PBUF) 
                  } 

                  break;
              }
          } // switch(Arg2)

          //
          // Return an error (a buffer with a value of zero) 
          // if we didn't return anything else above
          //
          return(Buffer() {0x0}) 

      } // _DSM 
  }
	

}