/** @file
  File name:    CUNIT_BOXTYPE.h
  Input File:   BXTP_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in CUNIT_BOXTYPE.h, which is used for non-tool-generated
  data

  Includes register defines specific to a project.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2005 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

  @par Specification
**/
#ifndef _CUNIT_BOXTYPE_H_
#define _CUNIT_BOXTYPE_H_

#include "DataTypes.h"

#if USE_64_BIT_VARIABLES
#define UINTX UINT64
#else
#define UINTX UINT32
#endif

#define DEVICE_ID_VENDOR_ID_0_0_0_PCI_CUNIT_BOXTYPE_REG    0x00000000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Hardwired to Intels VENDOR ID value
    //
    // Bits[15:0], RO, default = 0x8086
    //
    UINTX vendor_id : 16;
    //
    // These  bits  are fuse backed.
    //
    // Bits[20:16], RO/V, default = 0x10
    //
    UINTX device_id_fuse : 5;
    //
    // These bits are tied to a Cunit parameter DEVICE_ID_STRAP1.
    //
    // Bits[22:21], RO, default = 0x3
    //
    UINTX device_id_strap1 : 2;
    //
    // The reset default value of this register is tied to the parameter DEVICE_ID_STRAP2.
    // These  bits  can  be  rewritten  from SETIDVALUE message 1st DW data byte 2  byte3
    //
    // Bits[31:23], RW/V, default = 0x15
    //
    UINTX device_id_strap2 : 9;
  } Bits;
  UINTX Data;
} DEVICE_ID_VENDOR_ID_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define PCI_STATUS_COMMAND_0_0_0_PCI_CUNIT_BOXTYPE_REG     0x00000004
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PCI Status and PCI Command. Hardwired to 32 h00000007
    //
    // Bits[31:0], RO, default = 0x7
    //
    UINTX pci_status_and_command : 32;
  } Bits;
  UINTX Data;
} PCI_STATUS_COMMAND_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define REVISION_ID_CLASS_CODE_0_0_0_PCI_CUNIT_BOXTYPE_REG 0x00000008
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These  bits  can  be  rewritten  from SETIDVALUE message 1st DW data byte 0
    //
    // Bits[7:0], RW/V, default = 0x0
    //
    UINTX revision_id_strap : 8;
    //
    // Hardwired to 8 h00
    //
    // Bits[15:8], RO, default = 0x0
    //
    UINTX class_code0 : 8;
    //
    // Hardwired 16 h0600
    //
    // Bits[31:16], RO, default = 0x600
    //
    UINTX class_code1 : 16;
  } Bits;
  UINTX Data;
} REVISION_ID_CLASS_CODE_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define MASTER_LATENCY_TIME_0_0_0_PCI_CUNIT_BOXTYPE_REG    0x0000000C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[7:0], RO, default = 0x0
    //
    UINTX reserved_0 : 8;
    //
    // Header Type   hardwired to 0
    //
    // Bits[15:8], RO, default = 0x0
    //
    UINTX master_latency_timer : 8;
    //
    // Header Type
    //
    // Bits[23:16], RO, default = 0x80
    //
    UINTX header_type : 8;
    //
    // Reserved
    //
    // Bits[31:24], RO, default = 0x0
    //
    UINTX reserved_1 : 8;
  } Bits;
  UINTX Data;
} MASTER_LATENCY_TIME_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TMBAR_LO_0_0_1_PCI_CUNIT_BOXTYPE_REG               0x00000010
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This register represents the lower 32bits of PCI CFG register for that defines
    // the DPTF MMIO address space.
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX mios : 1;
    //
    // Hardwired to 10 to indicate 64bit address.
    //
    // Bits[2:1], RO, default = 0x2
    //
    UINTX mt : 2;
    //
    // Hardwired to 0 to prevent prefetching.
    //
    // Bits[3:3], RO, default = 0x0
    //
    UINTX pm : 1;
    //
    // Hardwired to 0s to indicate at least 32KB address range.
    //
    // Bits[14:4], RO, default = 0x0
    //
    UINTX adm : 11;
    //
    // This field corresponds to bits 31 to 15 of the base address TMBAR address space.
    // BIOS will program this register resulting in a base address for a 32KB block of
    // contiguous memory address space. This register ensures that a naturally aligned
    // 32KB space is allocated within total addressable memory space. The DPTF driver
    // uses this base address to program all Thermal and Throttling control register
    // set.
    //
    // Bits[31:15], RW, default = 0x0
    //
    UINTX tmmba : 17;
  } Bits;
  UINTX Data;
} TMBAR_LO_0_0_1_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TMBAR_HI_0_0_1_PCI_CUNIT_BOXTYPE_REG               0x00000014
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This register represents the lower 32bits of PCI CFG register for that defines
    // the DPTF MMIO address space.
    //
    // Bits[6:0], RW, default = 0x0
    //
    UINTX tmmba : 7;
    //
    // Must be set to 0 since addressing above 512GB is not supported.
    //
    // Bits[31:7], RW, default = 0x0
    //
    UINTX rsvdrw : 25;
  } Bits;
  UINTX Data;
} TMBAR_HI_0_0_1_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define SVID_SID_0_0_0_PCI_CUNIT_BOXTYPE_REG               0x0000002C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PCI Subsystem Vendor ID: This field shouldbe programmed by BIOS during bootup
    // to indicate the vendor of the system board.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX subsystem_vendor_id : 16;
    //
    // PCI Subsystem ID: This field should be programmed during BIOS initialization.
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX subsystem_id : 16;
  } Bits;
  UINTX Data;
} SVID_SID_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CAPPTR_0_0_0_PCI_CUNIT_BOXTYPE_REG                 0x00000034
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Pointer to first capabilities register
    //
    // Bits[7:0], RO, default = 0xE0
    //
    UINTX base_addr : 8;
    //
    // Reserved
    //
    // Bits[31:8], RO, default = 0x0
    //
    UINTX reserved_0 : 24;
  } Bits;
  UINTX Data;
} CAPPTR_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define MCHBAR_LO_0_0_0_PCI_CUNIT_BOXTYPE_REG              0x00000048
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 0: MCHBAR is disabled and does not claim any memory  1: MCHBAR memory mapped accesses
    // are claimed and decoded appropriately  Encoding Description  0b MCHBAR is disabled
    //  1b MCHBAR is enabled
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX mchbaren : 1;
    //
    // Reserved
    //
    // Bits[3:1], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
    //
    // Hardwired to 0 to indicate size of BAR 32kB
    //
    // Bits[14:4], RO, default = 0x0
    //
    UINTX base_addr_not_implemented : 11;
    //
    // Number of implemented bits used to indicated size of BAR 32kB
    //
    // Bits[31:15], RW, default = 0x0
    //
    UINTX base_addr : 17;
  } Bits;
  UINTX Data;
} MCHBAR_LO_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define MCHBAR_HI_0_0_0_PCI_CUNIT_BOXTYPE_REG              0x0000004C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Number of implemented bits used to indicated size of BAR 32kB
    //
    // Bits[6:0], RW, default = 0x0
    //
    UINTX base_addr : 7;
    //
    // Reserved
    //
    // Bits[31:7], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} MCHBAR_HI_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define GGC_0_0_0_PCI_CUNIT_BOXTYPE_REG                    0x00000050
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This lock bit only impacts the Display copy of this register. In the Cunit all
    // register protection is implemented with SAI policy groups. This bit is maintained
    // in the Cunit for software observability. Diplay description: This bit locks all
    // other writeable bits in this register.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX ggclck : 1;
    //
    // IGD VGA Disable  0: Enable. Device 2 IGD claims VGA memory and IO cycles the SubClass
    // Code within Device 2 Class Code register is 00.  1: Disable. Device 2 IGD does
    // not claim VGA cycles Mem and IO and the Sub Class Code field within Device 2 function
    // 0 Class Code register is 80.  BIOS Requirement: BIOS must not set this bit to
    // 0 if the GMS field bits 7:3 of this register preallocates no memory.  This bit
    // MUST be set to 1 if Device 2 is disabled DEVEN_0_0_0_PCI.D2F0EN  0.
    //
    // Bits[1:1], RW/V, default = 0x0
    //
    UINTX ivd : 1;
    //
    // Enables the use of the iGFX enbines for Versatile Acceleration.  1  iGFX engines
    // are in Versatile Acceleration Mode. Device 2 Class Code is 048000h.  0  iGFX engines
    // are in iGFX Mode. Device 2 Class Code is 030000h.
    //
    // Bits[2:2], RO, default = 0x0
    //
    UINTX vamen : 1;
    //
    // Reserved
    //
    // Bits[5:3], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
    //
    // This field is used to select the amount of Main Memory that is preallocated to
    // support the Internal Graphics Translation Table. The BIOS ensures that memory
    // is preallocated only when Internal graphics is enabled.  GSM is assumed to be
    // a contiguous physical DRAM space with DSM and BIOS needs to allocate a contiguous
    // memory chunk. Hardware will derive the base of GSM from DSM only using the GSM
    // size programmed in the register.  Hardware functionality in case of programming
    // this value to Reserved is not guaranteed.  0x0:No Preallocated Memory  0x1:2MB
    // of Preallocated Memory  0x2:4MB of Preallocated Memory  0x3:8MB of Preallocated
    // Memory
    //
    // Bits[7:6], RW, default = 0x0
    //
    UINTX ggms : 2;
    //
    // This field is used to select the amount of Main Memory that is preallocated to
    // support the Internal Graphics device in VGA nonlinear and Native linear modes.
    // The BIOS ensures that memory is preallocated only when Internal graphics is enabled.
    //  This register is also Intel TXT lockable.  Hardware does not clear or set any
    // of these bits automatically based on IGD being disabled/enabled.  BIOS Requirement:
    // BIOS must not set this field to 0h if IVD bit 1 of this register is 0.  0x00:0MB
    //  0x01:32MB  0x02:64MB  0x03:96MB  0x04:128MB  0x05:160MB  0x06:192MB  0x07:224MB
    //  0x08:256MB  0x09:288MB  0x0A:320MB  0x0B:352MB  0x0C:384MB  0x0D:416MB  0x0E:448MB
    //  0x0F:480MB  0x10:512MB  0x20:...1024MB...  0x30:...1536MB...  0x3F:...2016MB
    //  0x400xFF:Illegal value
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX gms : 8;
    //
    // Reserved
    //
    // Bits[31:16], RO, default = 0x0
    //
    UINTX reserved_1 : 16;
  } Bits;
  UINTX Data;
} GGC_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DEVEN_0_0_0_PCI_CUNIT_BOXTYPE_REG                  0x00000054
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bus 0 Device 0 Function 0 may not be disabled and is therefore hardwired to 1.
    //
    // Bits[0:0], RO, default = 0x1
    //
    UINTX d0f0en : 1;
    //
    // 0:      Bus 0 Device 0 Function 1 is disabled and hidden  1:      Bus 0 Device
    // 0 Function 1 is enabled and visible  This bit will be set to 0b and remain 0b
    // if BDF0.0.1 capability is disabled.
    //
    // Bits[1:1], RW/V, default = 0x1
    //
    UINTX d0f1en : 1;
    //
    // Reserved
    //
    // Bits[2:2], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:3], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // 0:      Bus 0 Device 2 Function 0 is disabled and hidden  1:      Bus 0 Device
    // 2 Function 0 is enabled and visible  This bit will be set to 0b and remain 0b
    // if BDF0.2.0 capability is disabled.
    //
    // Bits[4:4], RW/V, default = 0x1
    //
    UINTX d2f0en : 1;
    //
    // 0:      Bus 0 Device 3 Function 0 is disabled and hidden  1:      Bus 0 Device
    // 3 Function 0 is enabled and visible  This bit will be set to 0b and remain 0b
    // if BDF0.3.0 capability is disabled.
    //
    // Bits[5:5], RW/V, default = 0x1
    //
    UINTX d3f0en : 1;
    //
    // Reserved
    //
    // Bits[31:6], RO, default = 0x0
    //
    UINTX reserved_1 : 26;
  } Bits;
  UINTX Data;
} DEVEN_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define PAVPC_0_0_0_PCI_CUNIT_BOXTYPE_REG                  0x00000058
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field enables Protected Content Memory within Graphics Stolen Memory. This
    // memory is the same as the WOPCM area whose size is defined by bit 5 of this register.
    // This register is locked when PAVPLCK is set. A value of 0 in this field indicates
    // that Protected Content Memory is disabled and cannot be programmed in this manner
    //  when PAVP is enabled. A value of 1 in this field indicates that Protected Content
    // Memory is enabled and is the only programming option available when PAVP is enabled.
    // Note that the SNB legacy Lite mode programming of PCME bit  0 is not supported.
    // For nonPAVP3 Mode even for Lite mode configuration this bit should be programmed
    // to 1 and HVYMODESEL  0. This bit should always be programmed to 1 if bits 1 and
    // 2 PAVPE and PAVP lock bits are both set. With perApp Memory configuration support
    // the range check for the WOPCM memory area should always happen when this bit is
    // set regardless of Lite or Serpent mode or PAVP2 or PAVP3 mode programming.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX pcme : 1;
    //
    // 0: PAVP functionality is disabled.  1: PAVP functionality is enabled.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX pavpe : 1;
    //
    // This lock bit only impacts the Display copy of this register. In the Cunit all
    // register protection is implemented with SAI policy groups. This bit is maintained
    // in the Cunit for software observability. Diplay description: This bit locks all
    // writeable contents in this register when set including itself. Only a hardware
    // reset can unlock the register again. This lock bit needs to be set only if PAVP
    // is enabled bit 1 of this register is asserted.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX pavplck : 1;
    //
    // This bit is applicable only for PAVP2 operation mode with a chicken bit also set
    // or for PAVP3 mode only if the perApp memory config is disabled due to the clearing
    // of an additional chicken bit 9 in the Crypto Function Control_1 register address
    // 0x320F0.  0: Lite Mode NonSerpent mode  1: Serpent Mode  For chickenbit enabled
    // PAVP3 mode this one type boot time programming has been replaced by perApp programming
    // through the Media Crypto Copy command. Note that PAVP2 or PAVP3 mode selection
    // is done by programming bit 8 of the MFX_MODE  Video Mode register.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hvymodsel : 1;
    //
    // Override of Unsolicited Connection State Attack and Terminate.  0: Disable Override.
    // Attack Terminate allowed.  1: Enable Override. Attack Terminate disallowed.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX ovtattack : 1;
    //
    // These bits are reserved for future use.
    //
    // Bits[5:5], RO, default = 0x0
    //
    UINTX rsvd1 : 1;
    //
    // ASMF method enabled  0b Disabled default.   1b Enabled.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX asmfen : 1;
    //
    // These bits are reserved for future use.
    //
    // Bits[19:7], RO, default = 0x0
    //
    UINTX rsvd2 : 13;
    //
    // Sizes supported in BDW: 1M 2M 4M and 8M. Base value programmed from Top of Stolen
    // Memory itself defines the size of the WOPCM. Separate WOPCM size programming is
    // redundant information and not required. Default 1M size programming. 4M recommended
    // for BDW.
    //
    // Bits[31:20], RW, default = 0x0
    //
    UINTX pcmbase : 12;
  } Bits;
  UINTX Data;
} PAVPC_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define PCIEXBAR_LO_0_0_0_PCI_CUNIT_BOXTYPE_REG            0x00000060
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 0: The PCIEXBAR register is disabled. Memory read and write transactions proceed
    // s if there were no PCIEXBAR register. PCIEXBAR bits 38:26 are R/W with no functionality
    // behind them.  1: The PCIEXBAR register is enabled. Memory read and write transactions
    // whose address bits 38:26 match PCIEXBAR will be translated to configuration reads
    // and writes within the Uncore. These Translated cycles are routed as shown in the
    // above table.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX pciexbaren : 1;
    //
    // Length of the region.  Reserved and set to 0 indicating a fixed 256 MB region.
    //
    // Bits[2:1], RO, default = 0x0
    //
    UINTX length : 2;
    //
    // Reserved
    //
    // Bits[25:3], RO, default = 0x0
    //
    UINTX reserved_0 : 23;
    //
    // Reserved.  Unused by SoC since PCIEXBAR is a fixed 256MB region in SoCs.
    //
    // Bits[26:26], RO, default = 0x0
    //
    UINTX admsk64 : 1;
    //
    // Reserved.  Unused by SoC since PCIEXBAR is a fixed 256MB region in SoCs.
    //
    // Bits[27:27], RO, default = 0x0
    //
    UINTX admsk128 : 1;
    //
    // PCIEXBAR: PCIEXBAR[38:28] is PCIEXBAR_HI[6:0]PCIEXBAR_LO[31:28]. Describes bits
    // [38:28] of the base address of the contiguous 256MB region for PCI Express Enhanced
    // Configuration region.   If bits [38:28] of the request address matches the PCIEXBAR[38:28]
    // then the request targets the PCI Express Enhanced Configuration Space region.
    //  A posted memory operation from an IDI agent will be treated as a nonposted operation
    // by the Tunit and Aunit.
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX pciexbar : 4;
  } Bits;
  UINTX Data;
} PCIEXBAR_LO_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define PCIEXBAR_HI_0_0_0_PCI_CUNIT_BOXTYPE_REG            0x00000064
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PCIEXBAR: PCIEXBAR[38:28] is PCIEXBAR_HI[6:0]PCIEXBAR_LO[31:28]. Describes bits
    // [38:28] of the base address of the contiguous 256MB region for PCI Express Enhanced
    // Configuration region.   If bits [38:28] of the request address matches the PCIEXBAR[38:28]
    // then the request targets the PCI Express Enhanced Configuration Space region.
    //  A posted memory operation from an IDI agent will be treated as a nonposted operation
    // by the Tunit and Aunit.
    //
    // Bits[6:0], RW, default = 0x0
    //
    UINTX pciexbar_hi : 7;
    //
    // Reserved
    //
    // Bits[31:7], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} PCIEXBAR_HI_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TOUUD_LO_0_0_0_PCI_CUNIT_BOXTYPE_REG               0x000000A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This lock bit only impacts the Display copy of this register. In the Cunit all
    // register protection is implemented with SAI policy groups. This bit is maintained
    // in the Cunit for software observability. Diplay description: This bit will lock
    // all writeable settings in this register including itself client definition.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX lock_reserved : 1;
    //
    // Reserved should return 0s on read
    //
    // Bits[19:1], RO, default = 0x0
    //
    UINTX reserved_0 : 19;
    //
    // This register contains bits 38  to 20 of an address one byte above the maximum
    // DRAM memory above 4G that is usable by the operating system. Configuration software
    // must set this value to TOM minus all ME stolen memory if reclaim is disabled.
    // If reclaim is enabled this value must be set to reclaim limit 1MB aligned since
    // reclaim limit  1byte is 1MB aligned. Address bits 19:0 are assumed to be 000_0000h
    // for the purposes of address comparison. The Host interface positively decodes
    // an address towards DRAM if the incoming address is less than the value programmed
    // in this register and greater than 4GB.  Note: for 40bit addressing have to add
    // a bit to this field
    //
    // Bits[31:20], RW, default = 0x0
    //
    UINTX touud : 12;
  } Bits;
  UINTX Data;
} TOUUD_LO_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TOUUD_HI_0_0_0_PCI_CUNIT_BOXTYPE_REG               0x000000AC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This register contains bits 38  to 20 of an address one byte above the maximum
    // DRAM memory above 4G that is usable by the operating system. Configuration software
    // must set this value to TOM minus all ME stolen memory if reclaim is disabled.
    // If reclaim is enabled this value must be set to reclaim limit 1MB aligned since
    // reclaim limit  1byte is 1MB aligned. Address bits 19:0 are assumed to be 000_0000h
    // for the purposes of address comparison. The Host interface positively decodes
    // an address towards DRAM if the incoming address is less than the value programmed
    // in this register and greater than 4GB.  Note: for 40bit addressing have to add
    // a bit to this field
    //
    // Bits[6:0], RW, default = 0x0
    //
    UINTX touud_hi : 7;
    //
    // Reserved
    //
    // Bits[31:7], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} TOUUD_HI_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define BDSM_0_0_0_PCI_CUNIT_BOXTYPE_REG                   0x000000B0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This lock bit only impacts the Display copy of this register. In the Cunit all
    // register protection is implemented with SAI policy groups. This bit is maintained
    // in the Cunit for software observability. Diplay description: This bit will lock
    // all writeable settings in this register including itself.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX lock : 1;
    //
    // Reserved
    //
    // Bits[19:1], RO, default = 0x0
    //
    UINTX reserved_0 : 19;
    //
    // This register contains the base address of graphics data stolen DRAM memory. BIOS
    // determines the base of graphics data stolen memory by subtracting the graphics
    // data stolen memory size PCI Device 0 offset 52 bits 7:4 from TOLUD PCI Device
    // 0 offset BC bits 31:20.
    //
    // Bits[31:20], RW, default = 0x0
    //
    UINTX bdsm : 12;
  } Bits;
  UINTX Data;
} BDSM_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define BGSM_0_0_0_PCI_CUNIT_BOXTYPE_REG                   0x000000B4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This lock bit only impacts the Display copy of this register. In the Cunit all
    // register protection is implemented with SAI policy groups. This bit is maintained
    // in the Cunit for software observability. Diplay description: This bit will lock
    // all writeable settings in this register including itself.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX lock : 1;
    //
    // Reserved
    //
    // Bits[19:1], RO, default = 0x0
    //
    UINTX reserved_0 : 19;
    //
    // This register contains the base address of stolen DRAM memory for the GTT. BIOS
    // determines the base of GTT stolen memory by subtracting the GTT graphics stolen
    // memory size PCI Device 0 offset 52 bits 11:8 from the Graphics Base of  Data Stolen
    // Memory PCI Device 0 offset B0 bits 31:20.
    //
    // Bits[31:20], RW, default = 0x0
    //
    UINTX bgsm : 12;
  } Bits;
  UINTX Data;
} BGSM_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TSEGMB_0_0_0_PCI_CUNIT_BOXTYPE_REG                 0x000000B8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This lock bit only impacts the Display copy of this register. In the Cunit all
    // register protection is implemented with SAI policy groups. This bit is maintained
    // in the Cunit for software observability. Diplay description: This bit will lock
    // all writeable settings in this register including itself.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX lock : 1;
    //
    // Reserved
    //
    // Bits[19:1], RO, default = 0x0
    //
    UINTX reserved_0 : 19;
    //
    // Base address of TSEG DRAM memory.  BIOS determines the base of TSEG memory which
    // must be at or below Graphics Base of GTT Stolen Memory BGSM.  SMM range starts
    // at this base and ends at BGSM1.  Incoming Request Address [31:20] will be compared
    // with TSEGMB[31:20] and BGSM[31:20] to determine if the request targets the SMM
    // range.  The comparison check is as follows: Address[31:20]  TSEGMB[31:20]  Address[31:20]
    //  BGSM[31:20]  Address[38:32]  0.  If the check passes the request targets the
    // SMM range.  If the protection for the range is enabled then the request SAI is
    // compared against allowed SAIs specified by BSMRRAC and BSMRWAC registers to determine
    // if access is allowed.
    //
    // Bits[31:20], RW, default = 0x1
    //
    UINTX tsegmb : 12;
  } Bits;
  UINTX Data;
} TSEGMB_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TOLUD_0_0_0_PCI_CUNIT_BOXTYPE_REG                  0x000000BC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX lock : 1;
    //
    // Reserved
    //
    // Bits[19:1], RO, default = 0x0
    //
    UINTX reserved_0 : 19;
    //
    // Defines the top of lower usable DRAM which ends at the preceding byte.  Lower
    // MMIO Address range starts at this address and continues up to the 4GB Address
    // 0xFFFF_FFFF.  Bits 31:20 are compared with incoming request Address[31:20] to
    // determine whether the request targets lower usable DRAM range or the lower MMIO
    // range.  If Request Address[31:20]  TOLUD[31:20] and Request Address[38:32]  0
    // then the Request Address falls in the Lower MMIO Address range.
    //
    // Bits[31:20], RW, default = 0x1
    //
    UINTX tolud : 12;
  } Bits;
  UINTX Data;
} TOLUD_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define SKPD_0_0_0_PCI_CUNIT_BOXTYPE_REG                   0x000000DC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 1 DWORD of data storage.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX skpd : 32;
  } Bits;
  UINTX Data;
} SKPD_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CAPID0_CAPCTRL0_0_0_0_PCI_CUNIT_BOXTYPE_REG        0x000000E0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field has the value 1001b to identify the CAP_ID assigned by the PCI SIG
    // for vendor dependent capability pointers.
    //
    // Bits[7:0], RO, default = 0x9
    //
    UINTX cap_id : 8;
    //
    // This field is hardwired to 00h indicating the end of the capabilities linked list.
    //
    // Bits[15:8], RO, default = 0x0
    //
    UINTX next_cap : 8;
    //
    // This field has the value 0Ch to indicate the structure length 12 bytes.  Are these
    // the right values for us  Check with SCA  NOTE: merged these two registrers 0xE0
    // and 0xE2/CAPCTRL0
    //
    // Bits[23:16], RO, default = 0xC
    //
    UINTX capidlen : 8;
    //
    // This field has the value 0001b to identify the first revision of the CAPID register
    // definition.
    //
    // Bits[27:24], RO, default = 0x1
    //
    UINTX capid_ver : 4;
    //
    // Reserved
    //
    // Bits[31:28], RO, default = 0x0
    //
    UINTX reserved_0 : 4;
  } Bits;
  UINTX Data;
} CAPID0_CAPCTRL0_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CAPID0_A_0_0_0_PCI_CUNIT_BOXTYPE_REG               0x000000E4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved for future capabilities
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX spare7_0 : 8;
    //
    // Controls the value of Dev2 GFX device ID. This functionality is not needed on
    // BXT because Dev2 supports receiving the SetIDValue message for changing device
    // ID. Hardwared to 2b00.  Identifier assigned to the core/primary PCI device.The
    // corresponding two bit capability ID  programming is:  00: Desktop  01: Mobile
    //  10: Server  11: Marketing Spare
    //
    // Bits[9:8], RO, default = 0x0
    //
    UINTX cdid : 2;
    //
    // Controls if there is an override of Dev2 GFX device ID. This functionality is
    // not needed on BXT because Dev2 supports receiving the SetIDValue message for changing
    // device ID. Hardwired to 1b0.   0b Disable ability to override DID  For production
    //  1b Enable ability to override DID  For debug and samples only
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX didoe : 1;
    //
    // 0: There is a graphics engine within this CPU. Internal Graphics Device Device
    // 2 is enabled and all of its memory and I/O spaces are accessable. Configuration
    // cycles to Device 2 will be completed within the CPU. All nonSMM memory and IO
    // accesses to VGA will be handled based on Memory and IO enables of Device 2 and
    // IO registers within Device 2 and VGA Enable of the PCI to PCI bridge control register
    // in Devices 1 and 6 If PCI Express GFX attach is supported. A selected amount of
    // Graphics Memory space is preallocated from the main memory based on Graphics Mode
    // Select GMS in the GGC Register. Graphics Memory is preallocated above TSEG Memory.
    //  1: There is no graphics engine within this CPU. Internal Graphics Device Device
    // 2 and all of its memory and I/O functions are disabled. Configuration cycle targeted
    // to Device 2 will be passed on to DMI. In addition all clocks to internal graphics
    // logic are turned off. All nonSMM memory and IO accesses to VGA will be handled
    // based on VGA Enable of the PCI to PCI bridge control register in Devices 1 and
    // 6. DEVEN [4:3] Device 0 offset 54h have no meaning. Device 2 Functions 0 and 1
    // are disabled and hidden.
    //
    // Bits[11:11], RW/Fuse, default = 0x0
    //
    UINTX igd : 1;
    //
    // Fuse backed spare.
    //
    // Bits[12:12], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare12 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[13:13], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare13 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[14:14], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare14 : 1;
    //
    // 0: DPTF Camarillo associated memory spaces are accessible.  1: DPTF Camarillo
    // associated memory and IO spaces are disabled.  DEVEN_0_0_0_PCI field for DPTF
    // can not be set.
    //
    // Bits[15:15], RW/Fuse, default = 0x0
    //
    UINTX cdd : 1;
    //
    // Fuse backed spare.
    //
    // Bits[16:16], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare16 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[17:17], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare17 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[18:18], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare18 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[19:19], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare19 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[20:20], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare20 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[21:21], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare21 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[22:22], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare22 : 1;
    //
    // 0: Enable VTd  1: Disable VTd
    //
    // Bits[23:23], RW/Fuse, default = 0x0
    //
    UINTX vtdd : 1;
    //
    // Reserved for future capabilities.
    //
    // Bits[31:24], RW, default = 0x0
    //
    UINTX spare31_24 : 8;
  } Bits;
  UINTX Data;
} CAPID0_A_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CAPID0_B_0_0_0_PCI_CUNIT_BOXTYPE_REG               0x000000E8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved for future capabilities.
    //
    // Bits[23:0], RW, default = 0x0
    //
    UINTX spare23_0 : 24;
    //
    // 0: Enable SVM mode  1: Disable SVM mode
    //
    // Bits[24:24], RW/Fuse, default = 0x0
    //
    UINTX svmdis : 1;
    //
    // Fuse backed spares potentially to be used for PKGTYP encoding.
    //
    // Bits[25:25], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare_25 : 1;
    //
    // Fuse backed spares potentially to be used for PKGTYP encoding.
    //
    // Bits[26:26], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare_26 : 1;
    //
    // Fuse backed spares potentially to be used for PKGTYP encoding.
    //
    // Bits[27:27], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare_27 : 1;
    //
    // Fuse backed spares potentially to be used for PKGTYP encoding.
    //
    // Bits[28:28], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare_28 : 1;
    //
    // Fuse backed spares potentially to be used for PKGTYP encoding.
    //
    // Bits[29:29], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare_29 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[30:30], RW/Fuse, default = 0x0
    //
    UINTX fuse_spare_30 : 1;
    //
    // 0: Imaging Unit associated memory spaces are accessible.  1: Imaging Unit associated
    // memory and IO spaces are disabled.  DEVEN_0_0_0_PCI field for Iunit can not be
    // set.
    //
    // Bits[31:31], RW/Fuse, default = 0x0
    //
    UINTX imgu_dis : 1;
  } Bits;
  UINTX Data;
} CAPID0_B_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define MANUFACTURER_ID_0_0_0_PCI_CUNIT_BOXTYPE_REG        0x000000F4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Manufacturing Stepping ID MSID  These  bits  can  be  rewritten  from SETIDVALUE
    // message 2nd DW data byte 2
    //
    // Bits[7:0], RW/V, default = 0x0
    //
    UINTX msid : 8;
    //
    // Manufacturing ID MID  These  bits  can  be  rewritten  from SETIDVALUE message
    // 2nd DW data byte 1
    //
    // Bits[15:8], RW/V, default = 0x0
    //
    UINTX mid : 8;
    //
    // Process Portion of Process ID  These  bits  can  be  rewritten  from SETIDVALUE
    // message 2nd DW data byte 0
    //
    // Bits[23:16], RW/V, default = 0x0
    //
    UINTX process_portion_of_process_id : 8;
    //
    // DOT Portion of Process ID  These  bits  can  be  rewritten  from SETIDVALUE message
    // 2nd DW data byte 3 lower  nibble
    //
    // Bits[27:24], RW/V, default = 0x0
    //
    UINTX dot_portion_of_process_id : 4;
    //
    // Reserved  These  bits  can  be  rewritten  from SETIDVALUE message 2nd DW data
    //  byte 3  upper  nibble
    //
    // Bits[31:28], RW/V, default = 0x0
    //
    UINTX reserved_0 : 4;
  } Bits;
  UINTX Data;
} MANUFACTURER_ID_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DEBUP0_0_0_0_PCI_CUNIT_BOXTYPE_REG                 0x000000F8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Spare RW bits for future
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX spare_rw : 32;
  } Bits;
  UINTX Data;
} DEBUP0_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DEBUP1_0_0_0_PCI_CUNIT_BOXTYPE_REG                 0x000000FC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Spare RW bits for future
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX spare_rw : 32;
  } Bits;
  UINTX Data;
} DEBUP1_0_0_0_PCI_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_LOCAL_CONTROL_MODE_CUNIT_BOXTYPE_REG          0x00004104
#ifndef ASM_INC
typedef union {
  struct {
    //
    // When set disables local clock gating in the Cunit
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX c_clkgate_disable : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved_0 : 31;
  } Bits;
  UINTX Data;
} C_CR_LOCAL_CONTROL_MODE_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_PGCB_PWRGATE_PCE_CUNIT_BOXTYPE_REG            0x00004108
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PMC Request Enable: If set then IP will PG when idle and the PMC requests power
    // gating by asserting pmc_ip_sw_pg_req_b signal.  Hardwired to 1b0 since the Cunit
    // does not support  SW controlled PGing.
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX pmcre : 1;
    //
    // I3 Enable: if set then IP will PG when idle and the D0i3 register D0i3C[2]  1
    // is set.   Note: If bits[2:1] 11 then the IP would PG whenever either PMCSR  11
    // or the D0i3C.i3 bit is set.  Hardwired to 1b0 since the Cunit does not support
    // D0i3.
    //
    // Bits[1:1], RO, default = 0x0
    //
    UINTX i3e : 1;
    //
    // D3Hot Enable: If set then IP will PG when idle and the PMCSR[1:0] register is
    // the IP11.  Hardwired to 1b0 since the Cunit does not support D0i3.
    //
    // Bits[2:2], RO, default = 0x0
    //
    UINTX d3he : 1;
    //
    // Sleep Enable: If clear then IP will never assert Sleep to the retention flops.
    // If set then IP may assert Sleep during PGing. Note that some platforms may default
    // this bit to 0 others to 1.
    //
    // Bits[3:3], RW, default = 0x1
    //
    UINTX se : 1;
    //
    // Reserved
    //
    // Bits[4:4], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Hardware Autonomous Enable: If set then the IP may request a PG whenever it is
    // idle.   Note: If this bit is set then bits[2:0] must be 000.
    //
    // Bits[5:5], RW, default = 0x1
    //
    UINTX hae : 1;
    //
    // Reserved
    //
    // Bits[31:6], RO, default = 0x0
    //
    UINTX reserved_1 : 26;
  } Bits;
  UINTX Data;
} C_CR_PGCB_PWRGATE_PCE_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_PGCB_PG_IDLE_TIMER_CUNIT_BOXTYPE_REG          0x0000410C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Power Gate Hysterisis Timer This is the min time from which all internal Idle
    // conditions have been observed to when PGCB actually starts the power gating sequence.
    //
    // Bits[3:0], RW, default = 0x2
    //
    UINTX pg_timer : 4;
    //
    // This will feed into the cfg_pgcb_clkgate_disabled input of PGCB clock gate component
    // and when asserted, prevents the PGCB clock trunk from ever gating.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX pgcb_clkgating_disable : 1;
    //
    // Reserved
    //
    // Bits[31:5], RO, default = 0x0
    //
    UINTX reserved_0 : 27;
  } Bits;
  UINTX Data;
} C_CR_PGCB_PG_IDLE_TIMER_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_PGCB_CLKGATE_DIS_CUNIT_BOXTYPE_REG            0x00004110
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Disable IOSFSB clk gating
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX sbclkgating_disable : 1;
    //
    // Disable IOSFPri clk gating
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX priclkgating_disable : 1;
    //
    // Reserved
    //
    // Bits[15:2], RO, default = 0x0
    //
    UINTX reserved_0 : 14;
    //
    // Disable IOSFSB trunk gating
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX sbclk_force_trunk : 1;
    //
    // Disable IOSFPri trunk gating
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX priclk_force_trunk : 1;
    //
    // Reserved
    //
    // Bits[31:18], RO, default = 0x0
    //
    UINTX reserved_1 : 14;
  } Bits;
  UINTX Data;
} C_CR_PGCB_CLKGATE_DIS_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_PGCB_CG_IDLE_TIMER_CUNIT_BOXTYPE_REG          0x00004114
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IOSFSB idle timer
    //
    // Bits[3:0], RW, default = 0x4
    //
    UINTX sbclk_idle_timer : 4;
    //
    // IOSFPri idle timer
    //
    // Bits[7:4], RW, default = 0x4
    //
    UINTX priclk_idle_timer : 4;
    //
    // Reserved
    //
    // Bits[31:8], RO, default = 0x0
    //
    UINTX reserved_0 : 24;
  } Bits;
  UINTX Data;
} C_CR_PGCB_CG_IDLE_TIMER_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_SECURITY_STAT0_CUNIT_BOXTYPE_REG              0x00004118
#ifndef ASM_INC
typedef union {
  struct {
    //
    // First SAI violation detected
    //
    // Bits[0:0], RW/V, default = 0x0
    //
    UINTX vio_more_than_0 : 1;
    //
    // More than one SAI violation detected
    //
    // Bits[1:1], RW/V, default = 0x0
    //
    UINTX vio_more_than_1 : 1;
    //
    // Reserved
    //
    // Bits[7:2], RO, default = 0x0
    //
    UINTX reserved_0 : 6;
    //
    // SAI bits that triggered the violation
    //
    // Bits[15:8], RW/V, default = 0x0
    //
    UINTX vio_sai : 8;
    //
    // Toggles sending of SAI violation messages on sideband
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX sai_vio_msg_enable : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved_1 : 15;
  } Bits;
  UINTX Data;
} C_CR_SECURITY_STAT0_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_SECURITY_STAT1_CUNIT_BOXTYPE_REG              0x0000411C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Opcode that triggered the violation
    //
    // Bits[7:0], RW/V, default = 0x0
    //
    UINTX vio_opc : 8;
    //
    // Port that sent the violation
    //
    // Bits[15:8], RW/V, default = 0x0
    //
    UINTX vio_src_port : 8;
    //
    // Address that triggered the violation
    //
    // Bits[31:16], RW/V, default = 0x0
    //
    UINTX vio_addr : 16;
  } Bits;
  UINTX Data;
} C_CR_SECURITY_STAT1_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_BIOSWR_CP_CUNIT_BOXTYPE_REG                   0x00004120
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[63:0], RW, default = 0x40061210202
    //
    UINTX sai : 64;
  } Bits;
  UINTX Data;
} C_CR_BIOSWR_CP_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_BIOSWR_RAC_CUNIT_BOXTYPE_REG                  0x00004128
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[63:0], RW, default = 0xC00632D0217
    //
    UINTX sai : 64;
  } Bits;
  UINTX Data;
} C_CR_BIOSWR_RAC_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_BIOSWR_WAC_CUNIT_BOXTYPE_REG                  0x00004130
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[63:0], RW, default = 0xC00212C0212
    //
    UINTX sai : 64;
  } Bits;
  UINTX Data;
} C_CR_BIOSWR_WAC_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_P_U_CODERDWR_CP_CUNIT_BOXTYPE_REG             0x00004138
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[63:0], RW, default = 0x40021200202
    //
    UINTX sai : 64;
  } Bits;
  UINTX Data;
} C_CR_P_U_CODERDWR_CP_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_P_U_CODERDWR_RAC_CUNIT_BOXTYPE_REG            0x00004140
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[63:0], RW, default = 0x400212C0202
    //
    UINTX sai : 64;
  } Bits;
  UINTX Data;
} C_CR_P_U_CODERDWR_RAC_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_P_U_CODERDWR_WAC_CUNIT_BOXTYPE_REG            0x00004148
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[63:0], RW, default = 0x400212C0202
    //
    UINTX sai : 64;
  } Bits;
  UINTX Data;
} C_CR_P_U_CODERDWR_WAC_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_P_U_CODEWR_ALLRD_CP_CUNIT_BOXTYPE_REG         0x00004150
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[63:0], RW, default = 0x40021200202
    //
    UINTX sai : 64;
  } Bits;
  UINTX Data;
} C_CR_P_U_CODEWR_ALLRD_CP_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_P_U_CODEWR_ALLRD_RAC_CUNIT_BOXTYPE_REG        0x00004158
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[63:0], RW, default = 0xC00632D0217
    //
    UINTX sai : 64;
  } Bits;
  UINTX Data;
} C_CR_P_U_CODEWR_ALLRD_RAC_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_P_U_CODEWR_ALLRD_WAC_CUNIT_BOXTYPE_REG        0x00004160
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[63:0], RW, default = 0x400212C0202
    //
    UINTX sai : 64;
  } Bits;
  UINTX Data;
} C_CR_P_U_CODEWR_ALLRD_WAC_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_IA_UNTRUSTED_CP_CUNIT_BOXTYPE_REG             0x00004168
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[63:0], RW, default = 0x40021200202
    //
    UINTX sai : 64;
  } Bits;
  UINTX Data;
} C_CR_IA_UNTRUSTED_CP_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_IA_UNTRUSTED_RAC_CUNIT_BOXTYPE_REG            0x00004170
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[63:0], RW, default = 0xC00632D0217
    //
    UINTX sai : 64;
  } Bits;
  UINTX Data;
} C_CR_IA_UNTRUSTED_RAC_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_IA_UNTRUSTED_WAC_CUNIT_BOXTYPE_REG            0x00004178
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[63:0], RW, default = 0xC00632D0217
    //
    UINTX sai : 64;
  } Bits;
  UINTX Data;
} C_CR_IA_UNTRUSTED_WAC_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_SECURITY_CP_0_0_0_MCHBAR_CUNIT_BOXTYPE_REG    0x00006000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[63:0], RO, default = 0x0
    //
    UINTX sai : 64;
  } Bits;
  UINTX Data;
} C_CR_SECURITY_CP_0_0_0_MCHBAR_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_SECURITY_RAC_0_0_0_MCHBAR_CUNIT_BOXTYPE_REG   0x00006008
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[63:0], RO, default = 0xC00612D0202
    //
    UINTX sai : 64;
  } Bits;
  UINTX Data;
} C_CR_SECURITY_RAC_0_0_0_MCHBAR_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define C_CR_SECURITY_WAC_0_0_0_MCHBAR_CUNIT_BOXTYPE_REG   0x00006010
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[63:0], RO, default = 0xC00612D0202
    //
    UINTX sai : 64;
  } Bits;
  UINTX Data;
} C_CR_SECURITY_WAC_0_0_0_MCHBAR_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DEFVTDBAR_0_0_0_MCHBAR_C_CUNIT_BOXTYPE_REG         0x00006C80
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 0: DEFVTDBAR is disabled and does not claim any memory  1: DEFVTDBAR memory mapped
    // accesses are claimed and decoded appropriately  This bit will remain 0 if VTd
    // capability is disabled.
    //
    // Bits[0:0], RW/L, default = 0x0
    //
    UINTX defvtdbaren : 1;
    //
    // This lock bit only impacts the Display copy of this register. In the Cunit all
    // register protection is implemented with SAI policy groups. This bit is maintained
    // in the Cunit for software observability. Diplay description: Locks the contents
    // of the register including itself.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX lock : 1;
    //
    // Reserved
    //
    // Bits[11:2], RO, default = 0x0
    //
    UINTX reserved_0 : 10;
    //
    // If DEFVTDBAR is enabled this field corresponds to bits 38:12 of the base address
    // default IOMMU VTd configuration space.  BIOS will program this register resulting
    // in a base address for a 4KB block of contiguous memory address space.  This register
    // ensures that a naturally aligned 4KB space is allocated within the first 512GB
    // of addressable memory space.  System Software uses this base address to program
    // the default VTd IOMMU register set.  If DEFVTDBAR is enabled and incoming Request
    // Address[38:12] matches DEFVTDBAR[38:12] the request targets the Default VTd BAR.
    //
    // Bits[38:12], RW, default = 0x0
    //
    UINTX defvtdbar : 27;
    //
    // Reserved for future growth to 40bit addressing in uServer.  Will always be 0 in
    // WLV/BXT
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX defvtdbar_40_bit : 1;
    //
    // Reserved
    //
    // Bits[63:40], RO, default = 0x0
    //
    UINTX reserved_1 : 24;
  } Bits;
  UINTX Data;
} DEFVTDBAR_0_0_0_MCHBAR_C_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define GFXVTDBAR_0_0_0_MCHBAR_C_CUNIT_BOXTYPE_REG         0x00006C88
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 0: GFXVTBAR is disabled and does not claim any memory  1: GFXVTBAR memory mapped
    // accesses are claimed and decoded appropriately  This bit will remain 0 if VTd
    // capability is disabled.
    //
    // Bits[0:0], RW/L, default = 0x0
    //
    UINTX gfxvtbaren : 1;
    //
    // This lock bit only impacts the Display copy of this register. In the Cunit all
    // register protection is implemented with SAI policy groups. This bit is maintained
    // in the Cunit for software observability. Diplay description: Locks the contents
    // of the register including itself.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX lock : 1;
    //
    // Reserved
    //
    // Bits[11:2], RO, default = 0x0
    //
    UINTX reserved_0 : 10;
    //
    // This field corresponds to bits 39 to 12 of the base address GFXVT configuration
    // space. BIOS will program this register resulting in a base address for a 4KB block
    // of contiguous memory address space. This register ensures that a naturally aligned
    // 4KB space is allocated within the first 512GB of addressable memory space. System
    // Software uses this base address to program the GFXVT register set. All the Bits
    // in this register are locked in LT mode.
    //
    // Bits[38:12], RW, default = 0x0
    //
    UINTX gfxvtbar : 27;
    //
    // Reserved
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_1 : 25;
  } Bits;
  UINTX Data;
} GFXVTDBAR_0_0_0_MCHBAR_C_CUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC


#endif // _CUNIT_BOXTYPE_H_
