/** @file
  File name:    MmrcProjectDefinitionsGenerated.h
  Input File:   BXTP_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in MmrcProjectDefinitions.h, which is used for non-tool-generated
  data

  Includes all hard defines specific to a project. Things like
  the maximum number of channels, ranks, DIMMs, etc, should be included
  here. This file needs to be included by most MMRC components,
  including Mmrc.h.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2005 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

  @par Specification
**/
#ifndef _MMRCPROJECTDEFINITIONSGENERATED_H_
#define _MMRCPROJECTDEFINITIONSGENERATED_H_

//
// All boxtypes supported by the MRC. Boxtypes are distinct components of silicon.
//
#define DUNIT_BOXTYPE                                      0x00
#define CPGC_BOXTYPE                                       0x01
#define DQ_BOXTYPE                                         0x02
#define CCC_BOXTYPE                                        0x03
#define SAI_BOXTYPE                                        0x04
#define ADPLL_BOXTYPE                                      0x05
#define LDO_BOXTYPE                                        0x06
#define DPLVUG_BOXTYPE                                     0x07
#define DPIC_BOXTYPE                                       0x08
#define DQDPIC_BOXTYPE                                     0x09
#define DQDPLVUG_BOXTYPE                                   0x0A
#define CUNIT_BOXTYPE                                      0x0B
#define PUNIT_BOXTYPE                                      0x0C
#define MLMC_BOXTYPE                                       0x0D
#define AUNIT_BOXTYPE                                      0x0E
#define P2SB_BOXTYPE                                       0x0F
#define BUNIT_BOXTYPE                                      0x10
//
// Maximum Box Types across blueprints
//
#define MAX_BOXES                                          0x11
//
// Maximum IO Levels across blueprints
//
#define MAX_IO_LEVELS                                      0x03
//
// Maximum Box Types for BLUEPRINT_LPDDR34
//
#define BOXES_BLUEPRINT_LPDDR34                            0x11
//
// Maximum Box Types for BLUEPRINT_DDR3
//
#define BOXES_BLUEPRINT_DDR3                               0x11
//
// Maximum length of the boxtype strings
//
#define MAX_BOXNAME_LENGTH                                 17
//
// Register access methods (sideband, PCI, etc)
//
#define eSB                                                0
#define ePCI                                               1
#define eBAR                                               2
#define eACCESS_METHOD_ERROR                               3
//
// Maximum number of GetSets Sheets
//
#define MAX_GETSETS                                        2
//
// Maximum number of blueprints
//
#define MAX_BLUEPRINTS                                     2
//
// Number assignments for each blueprint
//
#define BLUEPRINT_LPDDR34                                  0
#define BLUEPRINT_DDR3                                     1
//
// Maximum number of Instances
//
#define MAX_INSTANCE_PORTS                                 50
//
// Maximum Instance Ports for BLUEPRINT_LPDDR34
//
#define INSTANCE_PORTS_BLUEPRINT_LPDDR34                   50
//
// Maximum Instance Ports for BLUEPRINT_DDR3
//
#define INSTANCE_PORTS_BLUEPRINT_DDR3                      46
//
// Maximum string length of all register names and fieldnames.
//
#define MAX_REGISTER_NAME_LENGTH                           0x0036
//
// This project contains 64 bit variables.
//
#define USE_64_BIT_VARIABLES                               1
//
// Channels
//
#define MAX_CHANNELS                                       4
//
// DIMMS Per Channel
//
#define MAX_DIMMS                                          1
//
// Ranks Per Channel
//
#define MAX_RANKS                                          2
//
// Strobelanes Per Module
//
#define MAX_STROBELANES_PER_DQ_MODULE                      2
//
// DQ Modules Per Channel
//
#define MAX_DQ_MODULES                                     5
//
// Width of the entire bus in bits (i.e. 64 for non-ECC and 72 for ECC)
//
#define MAX_BUS_WIDTH                                      72
//
// Max Strobes Per Channel
//
#define MAX_STROBES                                        9
//
// Max Strobes Per Channel when ECC is disabled
//
#define MAX_STROBES_NON_ECC                                (MAX_STROBES-1)
//
// Bytelanes Per Module
//
#define MAX_BYTELANES_PER_DQ_MODULE                        2
//
// Number of Memory Controllers per CPU socket
//
#define MAX_DUNITS                                         4
//
// Max number of ranks for a single DIMM
//
#define MAX_RANKS_PER_DIMM                                 2
//
// Number of commands sent to the DRAMs during JEDEC init.
//
#define MR_COUNT                                           3
//
// Is DDR3 supported on this project?
//
#define DDR3_SUPPORT                                       1
//
// Is DDR4 supported on this project?
//
#define DDR4_SUPPORT                                       0
//
// Is DDRT supported on this project?
//
#define DDRT_SUPPORT                                       0
//
// Is LPDDR3 supported on this project?
//
#define LPDDR3_SUPPORT                                     1
//
// Is LPDDR4 supported on this project?
//
#define LPDDR4_SUPPORT                                     1
//
// Is WIO2 supported on this project?
//
#define WIO2_SUPPORT                                       1
//
// Which version of CPGC is used on this project? AVN = 99, ANN/CHV = 100, BXT = 200
//
#define CPGC_VERSION                                       200
//
// Max Number of values for the Axis Y
//
#define MAX_ELEMENTS_DIM_Y                                 64
//
// Max Number of values for the Axis X
//
#define MAX_ELEMENTS_DIM_X                                 128
//
// If disabled, the MRC codebase being used will supply its own GetSet functions and data structures.
//
#define USE_GET_SET_FROM_SPREADSHEET                       1
//
// Number of memory confiurations supported. For example - if LPDDR3 1600 and LPDDR4 3200 are the only configurations supported, this would be 2.
//
#define MAX_CONFIGS                                        18
//
// Maximum number of DRAM densities supported (i.e 4Gb, 8Gb, 16Gb = 3)
//
#define MAX_DENSITIES                                      5
//
// Number of knobs per algo
//
#define MAX_KNOBS                                          1
//
// Number of DQ per BL
//
#define MAX_BITS                                           8
//
// Command groups per channel.
//
#define MAX_CMDS                                           2
//
// Control Groups Per Channel.
//
#define MAX_CTLS                                           2
//
// Clock Groups Per Channel.
//
#define MAX_CLKS                                           2
//
// Major Version
//
#define VERSION_MAJOR                                      89
//
// Minor Version
//
#define VERSION_MINOR                                      24
//
// Print MRC functions as they execute
//
#define CAPSULESTRINGS                                     0
//
//
//
#define ERROR_MESSAGES                                     1
//
// Use CPGC for training
//
#define CPGC_API                                           1
//
// Lowest address bit for rank selection during training
//
#define RANK_SHIFT_BIT                                     25
//
// Debug message output to serial or console
//
#define DEBUG_MSG                                          1
//
// Enable training algorithms
//
#define TRAINING_ALGOS                                     1
//
// Number of Samples to take for Rcvn/FWL.
//
#define NUMSAMPLES                                         8
//
// Number of consecutive samples to pass for RCVN/FWL.
//
#define SAMPLETHRESH                                       5
//
// Dithering check for stability for RCVN/FWL.
//
#define DITHER                                             5
//
// Receive enable training
//
#define RECEIVE_ENABLE                                     1
//
// Number of 2x for LP3
//
#define RCVN_PREAMBLE_CNTR_LP3                             1
//
// Number of 2x for LP4
//
#define RCVN_PREAMBLE_CNTR_LP4                             2
//
// Number of 2x for DDR3
//
#define RCVN_PREAMBLE_CNTR_DDR3                            1
//
// Number of ps for LP3
//
#define RCVN_PREAMBLE_OFFSET_LP3                           0
//
// Number of ps for LP4
//
#define RCVN_PREAMBLE_OFFSET_LP4                           0
//
// Number of ps for DDR3
//
#define RCVN_PREAMBLE_OFFSET_DDR3                          0
//
// Starting point for the half clock during receive enable.
//
#define RCVN_INITIAL2XVAL_LP3                              12
//
// Starting point for the half clock during receive enable.
//
#define RCVN_INITIAL2XVAL_LP4                              13
//
// Starting point for the half clock during receive enable.
//
#define RCVN_INITIAL2XVAL_DDR3                             14
//
// Enable Rank-2-Rank Training for LP3
//
#define RCVN_RANK2RANK_ON_LP3                              0
//
// Enable Rank-2-Rank Training for LP4
//
#define RCVN_RANK2RANK_ON_LP4                              0
//
// Enable Rank-2-Rank Training for DDR3
//
#define RCVN_RANK2RANK_ON_DDR3                             0
//
// Large Step size as percentage of the Half Clock.
//
#define RCVN_LARGE_STEP                                    25
//
// Step size during second phase of receive enable
//
#define RCVN_MEDIUM_STEP                                   5
//
// Step size during final phase of receive enable
//
#define RCVN_SMALL_STEP                                    1
//
// Fine write leveling training
//
#define FINE_WRITE_LEVELING                                1
//
// Enable Rank-2-Rank Training for LP3
//
#define FWL_RANK2RANK_ON_LP3                               0
//
// Enable Rank-2-Rank Training for LP4
//
#define FWL_RANK2RANK_ON_LP4                               0
//
// Large Step size as percentage of the Half Clock.
//
#define FWL_LARGE_STEP                                     25
//
// Step size during second phase of receive enable
//
#define FWL_MEDIUM_STEP                                    5
//
// Step size during final phase of receive enable
//
#define FWL_SMALL_STEP                                     1
//
// Coarse write leveling training
//
#define COARSE_WRITE_LEVELING                              1
//
// Number of cks to push out DQS
//
#define CWL_CLK_PUSHOUT                                    3
//
// Step size for each DQ Testing (LP4)
//
#define CWL_DQ_STEP                                        5
//
// Early Command Training
//
#define EARLY_COMMAND_TRAINING                             1
//
// Vref to perform ECT.
//
#define ECT_LP4_VREF                                       0x60
//
// Width and Height of the search matrix.
//
#define ECT_TILE_WIDTH                                     9
//
// Use CPGC or DRAM_CMD to enter CBT mode (LP3 Only CA-2N Mode)
//
#define ECT_ENTERCBT_CPGC                                  1
//
// Enable the pushout of the CCC flag
//
#define PUSHOUT_CCC                                        1
//
// Pushout by the number of 2x clcoks.
//
#define PUSHOUT_VALUE                                      2
//
// Early Read Training
//
#define EARLY_READ_TRAINING                                1
//
// After finding final edge, amount of dithering to test.
//
#define ERT_DITHER                                         0
//
// Nominal RdVref for ERT training.
//
#define ERT_VREF_LPDDR4                                    0xA
//
// Nominal RdVref for ERT training.
//
#define ERT_VREF_LPDDR3                                    0x1f
//
// Nominal RdVref for ERT training.
//
#define ERT_VREF_DDR3                                      0x1f
//
// Larger step size to find edge.
//
#define ERT_LARGESTEP                                      10
//
// Medium step size to find edge.
//
#define ERT_MEDIUMSTEP                                     5
//
// Small step size to find edge.
//
#define ERT_SMALLSTEP                                      1
//
// Victim/aggressor read training
//
#define READ_TRAINING                                      1
//
// P/N Independent Training
//
#define RT_PN_ENABLED                                      1
//
// If no PBD set to 0xFF else use format RANK_SHARED|KNOB_SHARED | BIT_SHARED | BIT_CONTROL
//
#define RT_BIT_SHARING                                     RANK_SHARED|KNOB_SHARED | BIT_CONTROL|CALCULATE_BIT
//
//
//
#define RT_BYTE_SHARING                                    BIT_SHARED|KNOB_SHARED
//
//
//
#define RT_PERBIT_ENABLED                                  1
//
//
//
#define RT_NUM_EYEMASKS                                    2
//
//
//
#define RT_EYEMASK0_PI                                     15
//
//
//
#define MAX_POWER_KNOBS                                    1
//
//
//
#define RT_EYEMASK_VREF                                    3
//
//
//
#define RT_EYEMASK1_PI                                     15
//
//
//
#define RT_STEP1_VREFMIN                                   0
//
//
//
#define RT_STEP1_VREFMAX                                   63
//
//
//
#define RT_STEP1_VREFSTEP                                  2
//
//
//
#define RT_STEP1_VREFSTART_LP3                             25
//
//
//
#define RT_STEP1_VREFSTART_LP4                             0
//
//
//
#define RT_STEP1_VREFSTART_DDR3                            25
//
//
//
#define RT_STEP1_3_PISTEPLARGE                             1
//
//
//
#define RT_STEP1_3_PISTEPMEDIUM                            0
//
//
//
#define RT_STEP1_3_PISTEPSMALL                             0
//
//
//
#define RT_CTLE_MIN                                        0
//
//
//
#define RT_CTLE_MAX                                        0
//
//
//
#define RT_CTLE_STEP                                       2
//
//
//
#define RT_CTLE_ENABLE                                     0
//
//
//
#define RT_STEP2_VREFMIN                                   0
//
//
//
#define RT_STEP2_VREFMAX                                   63
//
//
//
#define RT_STEP2_VREFSTEP                                  5
//
//
//
#define RT_STEP3_VREFSAMPLES                               3
//
// Pi/VREF center estimate weight
//
#define RT_STEP1_PICENTER_MINWEIGHT                        2
//
//
//
#define RT_STEP1_PICENTER_MIDWEIGHT                        3
//
//
//
#define RT_STEP1_PICENTER_MAXWEIGHT                        5
//
//
//
#define RT_CTLE_SHARED                                     RANK_SHARED|KNOB_SHARED | BIT_SHARED | BIT_CONTROL
//
//
//
#define RT_STEP2_PISAMPLES                                 3
//
// Advance Write Training
//
#define WRITE_TRAINING                                     1
//
//
//
#define WT_PERBIT_ENABLED                                  1
//
// 0xff
//
#define WT_BIT_SHARING                                     RANK_SHARED|KNOB_SHARED | BIT_CONTROL
//
//
//
#define WT_BYTE_SHARING                                    BIT_SHARED|KNOB_SHARED
//
//
//
#define WT_NUM_EYEMASKS                                    2
//
//
//
#define WT_EYEMASK0_PI                                     40
//
//
//
#define WT_EYEMASK_VREF                                    3
//
//
//
#define WT_EYEMASK1_PI                                     1
//
// No Vref Control
//
#define WT_STEP1_VREFMIN_DDR3                              0
//
// Vref Control
//
#define WT_STEP1_VREFMIN_LP3                               0
//
// 10th of percange of VDDQ; THESE ARE NOT USED
//
#define WT_STEP1_VREFMIN_LP4                               100
//
// No Vref Control
//
#define WT_STEP1_VREFSTEP_DDR3                             1
//
// Vref Control
//
#define WT_STEP1_VREFSTEP_LP3                              2
//
// 10th of percange of VDDQ
//
#define WT_STEP1_VREFSTEP_LP4                              8
//
// NO Vref Control
//
#define WT_STEP1_VREFMAX_DDR3                              1
//
// Vref Control
//
#define WT_STEP1_VREFMAX_LP3                               63
//
// 10th of percange of VDDQ; THESE ARE NOT USED
//
#define WT_STEP1_VREFMAX_LP4                               420
//
// No Vref Control
//
#define WT_STEP1_VREFSTART_DDR3                            0
//
// Vref Control
//
#define WT_STEP1_VREFSTART_LP3                             0
//
// 10th of percange of VDDQ; THESE ARE NOT USED
//
#define WT_STEP1_VREFSTART_LP4                             420
//
// 10th of percange of VDDQ
//
#define WT_STEP1_VREFSTEP                                  8
//
// 10th of percange of VDDQ; THESE ARE NOT USED
//
#define WT_STEP1_VREFMAX                                   420
//
// 10th of percange of VDDQ; THESE ARE NOT USED
//
#define WT_STEP1_VREFSTART                                 420
//
//
//
#define WT_STEP1_3_PISTEPLARGE                             1
//
//
//
#define WT_STEP1_3_PISTEPMEDIUM                            0
//
//
//
#define WT_STEP1_3_PISTEPSMALL                             0
//
//
//
#define WT_STEP2_VREFMIN                                   400
//
//
//
#define WT_STEP2_VREFMAX                                   4
//
// No Vref Control
//
#define WT_STEP2_VREFSTEP_DDR3                             1
//
// Vref Control
//
#define WT_STEP2_VREFSTEP_LP3                              5
//
// Vref Control
//
#define WT_STEP2_VREFSTEP_LP4                              421
//
//
//
#define WT_STEP3_VREFSAMPLES                               3
//
//
//
#define WT_STEP1_PICENTER_MINWEIGHT                        2
//
//
//
#define WT_STEP1_PICENTER_MIDWEIGHT                        3
//
//
//
#define WT_STEP1_PICENTER_MAXWEIGHT                        5
//
//
//
#define WT_VREFOVERRIDE_VALUE                              37
//
//
//
#define WT_VREF_OVERRIDE_ENABLE                            1
//
//
//
#define VDDQ                                               1100
//
//
//
#define LDO_TARGET                                         850
//
//
//
#define LDO_ENABLED                                        0
//
//
//
#define RON                                                35
//
//
//
#define ODT                                                999999
//
//
//
#define RTWT_SIM                                           0
//
//
//
#define PERIODIC_TRAINING                                  1
//
// Enable RMT Support
//
#define RMT                                                1
//
//  OKAY to DELETE ** set to 0 on release code ** Peter put here just for sim purposes
//
#define RMT_WRITE_CHECKPOINT                               0
//
// default RMT burst length
//
#define RMT_NUMBURSTS                                      13
//
// default RMT loop count
//
#define RMT_LOOPCOUNT                                      10
//
// Loopcount for production RMT test
//
#define RMT_PRODUCTION_LOOPCOUNT                           7
//
// Numbursts for production RMT test
//
#define RMT_PRODUCTION_NUMBURSTS                           7
//
// CPGC RMT Logging Enable
//
#define RMT_BIT_ERROR_LOGGING_ENABLE                       0
//
// Loopcount for PPV RMT test
//
#define RMT_PPV_LOOPCOUNT                                  7
//
// Numbursts for PPV RMT test
//
#define RMT_PPV_NUMBURSTS                                  13
//
// Enable Per-Bit margin
//
#define RMT_PER_BIT_MARGIN                                 1
//
// max # of retries (w/JEDEC) if fail after RMT test
//
#define POST_RMT_RETRIES                                   5
//
// jump to other training postcode from RMT command loop
//
#define RMT_JUMP_POSTCODES                                 1
//
// Enable or disable support of the production RMT margin check
//
#define RMT_PRODUCTION_MODE_SUPPORT                        1
//
// Late command training
//
#define COMMAND_TRAINING                                   1
//
// Test all memory at the end of MRC
//
#define MEMORY_TEST                                        0
//
// Initialize ECC at the end of MRC
//
#define ECC_SCRUB                                          0
//
// Display all DDRIO delays at the end of MRC
//
#define PHYVIEW_TABLE                                      1
//
// Display memory controller timings
//
#define TIMING_TABLE                                       1
//
// Display function calls
//
#define MRC_FLOW                                           0
//
// Enable BDAT table for publishing memory information in ACPI
//
#define BDAT                                               0
//
// Detect DIMMs via SPD reads
//
#define DETECT_DIMMS                                       0
//
// Enable PUNIT communication via mailbox
//
#define PUNIT_MAILBOX                                      0
//
// Use ODT input table from KIT team
//
#define ODT_TABLE                                          0
//
// Are minus 1 selects supported on this project?
//
#define TX_DQS_MINUS1_SUPPORT                              0
//
// Are minus 1 selects supported on this project?
//
#define TX_DQ_MINUS1_SUPPORT                               0
//
// Display register names with dumping
//
#define DUMP_REGISTER_NAMES                                0
//
// Display register fields when dumping registers
//
#define DUMP_REGISTER_FIELDS                               0
//
// Display all descriptions when dumping them
//
#define DUMP_REGISTER_DESCRIPTIONS                         0
//
// Enable to use new receive enable and fine write leveling algos. These save code space.
//
#define SPACE_OPTIMIZED_ALGOS                              1
//
// Min receive VREF
//
#define RX_VREF_MIN                                        0
//
// Max receive VREF
//
#define RX_VREF_MAX                                        30
//
// Receive VREF step
//
#define RX_VREF_STEP                                       3
//
// Min transmit VREF
//
#define TX_VREF_MIN                                        0
//
// Max transmit VREF
//
#define TX_VREF_MAX                                        63
//
// Transmit VREF step
//
#define TX_VREF_STEP                                       3
//
// Enable Stack size reduction by commented out unused variable
//
#define STACK_SIZE_REDUCE_EN                               1
//
// Enable flag internal validation SV Hooks
//
#define MEM_SV_HOOKS                                       0
//
// Minimum allowable pulse width for RCVN and FWL in 1/16 clock increments. i.e. 4 = 1/4 clock.
//
#define MIN_PULSE_WIDTH                                    2
//
// When running Rd/Wr training, use per-bit algo.
//
#define NEW_RTWT_ALGO                                      1
//
//
//
#define CPGC_BASED_READWRITES                              1
//
//
//
#define CPGC_BASED_WRITES                                  1
//
//
//
#define CPGC_BASED_READS                                   0
//
//
//
#define CPGC_BASE_EARLYREADS                               0
//
//
//
#define EARLYMPR_1DSWEEP                                   1
//
//
//
#define RX_PI_MIN_WIDTH                                    20
//
//
//
#define CTLE_MIN                                           0
//
//
//
#define CTLE_MAX                                           3
//
//
//
#define CTLE_STEP                                          1
//
//
//
#define RT_VREF_MIN                                        0
//
//
//
#define RT_VREF_MAX                                        30
//
//
//
#define RT_VREF_STEP                                       3
//
//
//
#define NUM_CONS_MIN_EWS                                   3
//
//
//
#define NUM_FINAL_VREF_SAMPLES                             7
//
//
//
#define RX_PI_MIN_EYEWIDTH                                 15
//
//
//
#define TX_PI_MIN_EYEWIDTH                                 15
//
// When doing VREF Sweep, starting value
//
#define RT_VREF_SWEEPMIN                                   0
//
//
//
#define RT_VREF_SWEEPMAX                                   30
//
//
//
#define RT_VREF_SWEEPSTEP                                  5
//
// Pi/VREF center estimate weight
//
#define MIN_WEIGHT                                         2
//
//
//
#define MID_WEIGHT                                         3
//
//
//
#define MAX_WEIGHT                                         5
//
// When doing VREF Sweep, starting value
//
#define WT_VREF_SWEEPMIN                                   0
//
//
//
#define WT_VREF_SWEEPMAX                                   30
//
//
//
#define WT_VREF_SWEEPSTEP                                  5
//
// When determing Vref Center, number of PI columns
//
#define MAX_PI_SAMPLES                                     3
//
// When determing Pi center, number Vref rows
//
#define NUM_CONS_VREFS                                     3
//
//
//
#define RX_PI_MIN                                          0
//
//
//
#define RX_PI_MAX                                          64
//
//
//
#define RX_PI_STEP                                         1
//
//
//
#define MAX_PI                                             63
//
//
//
#define RTWT_SIM                                           0
//
//
//
#define BXT_PO                                             0
//
// Tile Search Step Size
//
#define ECT_STEP_SIZE                                      5
//
// Tile Search Width
//
#define ECT_TSWIDTH                                        9
//
// Tile Search Shedding Percentage
//
#define ECT_TS_SHEDDING_PERCENT                            50
//
// Tile Search Value Limit for each Loop (To prevent overflowing integers)
//
#define ECT_TS_VAL_LIMIT                                   255
//
//
//
#define RCVN_PREAM_CLK_SUBTRACT                            3
//
//
//
#define VOC_TRAINING                                       1
//
//
//
#define VOC_LP4_VrefRMin_LDO_ENABLE                        93
//
//
//
#define VOC_LP4_VrefRMax_LDO_ENABLE                        429
//
// Voltage ; LDO on = LP4 only
//
#define VOC_LP4_VrefRMin_LDO_DISABLE                       238
//
// Voltage ; LDO on = LP4 only
//
#define VOC_LP4_VrefRMax_LDO_DISABLE                       742
//
// Voltage
//
#define VOC_LP3_VrefRMin                                   238
//
// Voltage
//
#define VOC_LP3_VrefRMax                                   742
//
// Voltage
//
#define VOC_DDR3L_VrefRMin                                 238
//
// Voltage
//
#define VOC_DDR3L_VrefRMax                                 742
//
//
//
#define VOC_Rext                                           105
//
//
//
#define VOC_VREF_MAX                                       63
//
//
//
#define VOC_VREF_STEP_SIZE                                 1
//
//
//
#define VOC_LP4_PullUpRon_LDO_ENABLE                       140
//
//
//
#define VOC_LP4_PullDnRon_LDO_ENABLE                       40
//
//
//
#define VOC_LP4_PullUpRon_LDO_DISABLE                      140
//
//
//
#define VOC_LP4_PullDnRon_LDO_DISABLE                      40
//
//
//
#define VOC_LP3_PullUpRon                                  40
//
//
//
#define VOC_LP3_PullDnRon                                  40
//
//
//
#define VOC_DDR3L_PullUpRon                                40
//
//
//
#define VOC_DDR3L_PullDnRon                                40
//
//
//
#define VOC_LP4_SegmentsEnabled_LDO_ENABLE                 2
//
//
//
#define VOC_LP4_SegmentsEnabled_LDO_DISABLE                2
//
//
//
#define VOC_LP3_SegmentsEnabled                            2
//
//
//
#define VOC_DDR3L_SegmentsEnabled                          2
//
// Enable or disable debug messages related to Max PI setup.
//
#define MAXPIDLL_DEBUG_PRINT                               0
//
//
//
#define RDCMD2RDVLD_TRAINING                               1
//
// Does this DDRIO have an analog DLL?
//
#define ANALOG_DLL_SUPPORT_BLUEPRINT_LPDDR34               0
//
// Does this project have a digital DLL?
//
#define DIGITAL_DLL_SUPPORT_BLUEPRINT_LPDDR34              1
//
// Number of delay types which use clock crossings. Sometimes this is 1 in the case of only having a PI delay. Other projects have a coarse and a fine delay, so this would be 2.
//
#define NUM_CC_DEPENDENT_ELEMENTS_BLUEPRINT_LPDDR34        1
//
// Does this DDRIO have an analog DLL?
//
#define ANALOG_DLL_SUPPORT_BLUEPRINT_DDR3                  0
//
// Does this project have a digital DLL?
//
#define DIGITAL_DLL_SUPPORT_BLUEPRINT_DDR3                 1
//
// Number of delay types which use clock crossings. Sometimes this is 1 in the case of only having a PI delay. Other projects have a coarse and a fine delay, so this would be 2.
//
#define NUM_CC_DEPENDENT_ELEMENTS_BLUEPRINT_DDR3           1
//
// Definitions for register initialization sequence that tell the common MMRC libraries
// how to program a register, whether the offset is 8 or 16 bits, etc.
//
#define xxxxx1xx                                           0x00 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxxxx1xR                                           0x01 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxxxx1Sx                                           0x02 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxxxx1SR                                           0x03 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxxxx2xx                                           0x04 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxxxx2xR                                           0x05 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxxxx2Sx                                           0x06 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxxxx2SR                                           0x07 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxxxE1xx                                           0x08 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxxxE1xR                                           0x09 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxxxE1Sx                                           0x0A //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxxxE1SR                                           0x0B //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxxxE2xx                                           0x0C //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxxxE2xR                                           0x0D //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxxxE2Sx                                           0x0E //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxxxE2SR                                           0x0F //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxxMx1xx                                           0x10 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxxMx1xR                                           0x11 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxxMx1Sx                                           0x12 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxxMx1SR                                           0x13 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxxMx2xx                                           0x14 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxxMx2xR                                           0x15 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxxMx2Sx                                           0x16 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxxMx2SR                                           0x17 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxxME1xx                                           0x18 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxxME1xR                                           0x19 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxxME1Sx                                           0x1A //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxxME1SR                                           0x1B //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxxME2xx                                           0x1C //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxxME2xR                                           0x1D //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxxME2Sx                                           0x1E //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxxME2SR                                           0x1F //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxNxx1xx                                           0x20 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxNxx1xR                                           0x21 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxNxx1Sx                                           0x22 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxNxx1SR                                           0x23 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxNxx2xx                                           0x24 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxNxx2xR                                           0x25 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxNxx2Sx                                           0x26 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxNxx2SR                                           0x27 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxNxE1xx                                           0x28 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxNxE1xR                                           0x29 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxNxE1Sx                                           0x2A //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxNxE1SR                                           0x2B //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxNxE2xx                                           0x2C //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxNxE2xR                                           0x2D //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxNxE2Sx                                           0x2E //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxNxE2SR                                           0x2F //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxNMx1xx                                           0x30 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxNMx1xR                                           0x31 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxNMx1Sx                                           0x32 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxNMx1SR                                           0x33 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxNMx2xx                                           0x34 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxNMx2xR                                           0x35 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxNMx2Sx                                           0x36 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxNMx2SR                                           0x37 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxNME1xx                                           0x38 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxNME1xR                                           0x39 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxNME1Sx                                           0x3A //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxNME1SR                                           0x3B //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxNME2xx                                           0x3C //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxNME2xR                                           0x3D //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxNME2Sx                                           0x3E //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxNME2SR                                           0x3F //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBxxx1xx                                           0x40 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBxxx1xR                                           0x41 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBxxx1Sx                                           0x42 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBxxx1SR                                           0x43 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBxxx2xx                                           0x44 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBxxx2xR                                           0x45 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBxxx2Sx                                           0x46 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBxxx2SR                                           0x47 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBxxE1xx                                           0x48 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBxxE1xR                                           0x49 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBxxE1Sx                                           0x4A //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBxxE1SR                                           0x4B //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBxxE2xx                                           0x4C //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBxxE2xR                                           0x4D //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBxxE2Sx                                           0x4E //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBxxE2SR                                           0x4F //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBxMx1xx                                           0x50 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBxMx1xR                                           0x51 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBxMx1Sx                                           0x52 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBxMx1SR                                           0x53 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBxMx2xx                                           0x54 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBxMx2xR                                           0x55 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBxMx2Sx                                           0x56 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBxMx2SR                                           0x57 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBxME1xx                                           0x58 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBxME1xR                                           0x59 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBxME1Sx                                           0x5A //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBxME1SR                                           0x5B //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBxME2xx                                           0x5C //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBxME2xR                                           0x5D //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBxME2Sx                                           0x5E //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBxME2SR                                           0x5F //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBNxx1xx                                           0x60 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBNxx1xR                                           0x61 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBNxx1Sx                                           0x62 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBNxx1SR                                           0x63 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBNxx2xx                                           0x64 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBNxx2xR                                           0x65 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBNxx2Sx                                           0x66 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBNxx2SR                                           0x67 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBNxE1xx                                           0x68 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBNxE1xR                                           0x69 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBNxE1Sx                                           0x6A //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBNxE1SR                                           0x6B //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBNxE2xx                                           0x6C //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBNxE2xR                                           0x6D //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBNxE2Sx                                           0x6E //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBNxE2SR                                           0x6F //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBNMx1xx                                           0x70 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBNMx1xR                                           0x71 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBNMx1Sx                                           0x72 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBNMx1SR                                           0x73 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBNMx2xx                                           0x74 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBNMx2xR                                           0x75 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBNMx2Sx                                           0x76 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBNMx2SR                                           0x77 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBNME1xx                                           0x78 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBNME1xR                                           0x79 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBNME1Sx                                           0x7A //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBNME1SR                                           0x7B //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBNME2xx                                           0x7C //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBNME2xR                                           0x7D //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBNME2Sx                                           0x7E //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBNME2SR                                           0x7F //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define Dxxxx1xx                                           0x80 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define Dxxxx1xR                                           0x81 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define Dxxxx1Sx                                           0x82 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define Dxxxx1SR                                           0x83 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define Dxxxx2xx                                           0x84 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define Dxxxx2xR                                           0x85 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define Dxxxx2Sx                                           0x86 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define Dxxxx2SR                                           0x87 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxxxE1xx                                           0x88 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxxxE1xR                                           0x89 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxxxE1Sx                                           0x8A //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxxxE1SR                                           0x8B //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxxxE2xx                                           0x8C //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxxxE2xR                                           0x8D //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxxxE2Sx                                           0x8E //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxxxE2SR                                           0x8F //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxxMx1xx                                           0x90 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxxMx1xR                                           0x91 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxxMx1Sx                                           0x92 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxxMx1SR                                           0x93 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxxMx2xx                                           0x94 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxxMx2xR                                           0x95 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxxMx2Sx                                           0x96 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxxMx2SR                                           0x97 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxxME1xx                                           0x98 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxxME1xR                                           0x99 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxxME1Sx                                           0x9A //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxxME1SR                                           0x9B //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxxME2xx                                           0x9C //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxxME2xR                                           0x9D //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxxME2Sx                                           0x9E //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxxME2SR                                           0x9F //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxNxx1xx                                           0xA0 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxNxx1xR                                           0xA1 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxNxx1Sx                                           0xA2 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxNxx1SR                                           0xA3 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxNxx2xx                                           0xA4 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxNxx2xR                                           0xA5 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxNxx2Sx                                           0xA6 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxNxx2SR                                           0xA7 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxNxE1xx                                           0xA8 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxNxE1xR                                           0xA9 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxNxE1Sx                                           0xAA //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxNxE1SR                                           0xAB //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxNxE2xx                                           0xAC //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxNxE2xR                                           0xAD //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxNxE2Sx                                           0xAE //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxNxE2SR                                           0xAF //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxNMx1xx                                           0xB0 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxNMx1xR                                           0xB1 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxNMx1Sx                                           0xB2 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxNMx1SR                                           0xB3 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxNMx2xx                                           0xB4 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxNMx2xR                                           0xB5 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxNMx2Sx                                           0xB6 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxNMx2SR                                           0xB7 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxNME1xx                                           0xB8 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxNME1xR                                           0xB9 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxNME1Sx                                           0xBA //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxNME1SR                                           0xBB //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxNME2xx                                           0xBC //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxNME2xR                                           0xBD //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxNME2Sx                                           0xBE //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxNME2SR                                           0xBF //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBxxx1xx                                           0xC0 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBxxx1xR                                           0xC1 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBxxx1Sx                                           0xC2 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBxxx1SR                                           0xC3 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBxxx2xx                                           0xC4 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBxxx2xR                                           0xC5 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBxxx2Sx                                           0xC6 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBxxx2SR                                           0xC7 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBxxE1xx                                           0xC8 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBxxE1xR                                           0xC9 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBxxE1Sx                                           0xCA //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBxxE1SR                                           0xCB //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBxxE2xx                                           0xCC //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBxxE2xR                                           0xCD //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBxxE2Sx                                           0xCE //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBxxE2SR                                           0xCF //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBxMx1xx                                           0xD0 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBxMx1xR                                           0xD1 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBxMx1Sx                                           0xD2 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBxMx1SR                                           0xD3 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBxMx2xx                                           0xD4 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBxMx2xR                                           0xD5 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBxMx2Sx                                           0xD6 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBxMx2SR                                           0xD7 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBxME1xx                                           0xD8 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBxME1xR                                           0xD9 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBxME1Sx                                           0xDA //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBxME1SR                                           0xDB //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBxME2xx                                           0xDC //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBxME2xR                                           0xDD //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBxME2Sx                                           0xDE //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBxME2SR                                           0xDF //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBNxx1xx                                           0xE0 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBNxx1xR                                           0xE1 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBNxx1Sx                                           0xE2 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBNxx1SR                                           0xE3 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBNxx2xx                                           0xE4 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBNxx2xR                                           0xE5 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBNxx2Sx                                           0xE6 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBNxx2SR                                           0xE7 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBNxE1xx                                           0xE8 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBNxE1xR                                           0xE9 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBNxE1Sx                                           0xEA //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBNxE1SR                                           0xEB //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBNxE2xx                                           0xEC //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBNxE2xR                                           0xED //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBNxE2Sx                                           0xEE //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBNxE2SR                                           0xEF //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBNMx1xx                                           0xF0 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBNMx1xR                                           0xF1 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBNMx1Sx                                           0xF2 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBNMx1SR                                           0xF3 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBNMx2xx                                           0xF4 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBNMx2xR                                           0xF5 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBNMx2Sx                                           0xF6 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBNMx2SR                                           0xF7 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBNME1xx                                           0xF8 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBNME1xR                                           0xF9 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBNME1Sx                                           0xFA //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBNME1SR                                           0xFB //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBNME2xx                                           0xFC //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBNME2xR                                           0xFD //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBNME2Sx                                           0xFE //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBNME2SR                                           0xFF //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxxxxxxx                                           0x00 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=FALSE InstanceDependent=FALSE StringPresent=FALSE
#define xxxxxxxS                                           0x01 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=FALSE InstanceDependent=FALSE StringPresent=TRUE
#define xxxxxxIx                                           0x02 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=FALSE InstanceDependent=TRUE StringPresent=FALSE
#define xxxxxxIS                                           0x03 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=FALSE InstanceDependent=TRUE StringPresent=TRUE
#define xxxxxCxx                                           0x04 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=TRUE InstanceDependent=FALSE StringPresent=FALSE
#define xxxxxCxS                                           0x05 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=TRUE InstanceDependent=FALSE StringPresent=TRUE
#define xxxxxCIx                                           0x06 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=TRUE InstanceDependent=TRUE StringPresent=FALSE
#define xxxxxCIS                                           0x07 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=TRUE InstanceDependent=TRUE StringPresent=TRUE
//
// Max number of DLLs supported (analog plus digital).
//
#define MAX_DLL_COUNT                                      1
//
// Number of DLLs supported (analog plus digital) for BLUEPRINT_LPDDR34
//
#define DLL_COUNT_BLUEPRINT_LPDDR34                        1
//
// Number of DLLs supported (analog plus digital) for BLUEPRINT_DDR3
//
#define DLL_COUNT_BLUEPRINT_DDR3                           1
//
// Max number of registers needed to be cached for the GetSet functions.
//
#define MAX_NUM_CACHE_ELEMENTS                             50
#define MAX_NUM_CACHE_ELEMENTS_PB                          3
#define MAX_NUM_CACHE_ELEMENTS_NON_SR                      23
#define MAX_NUM_CACHE_ELEMENTS_NON_SR_PB                   1
//
// Number of registers needed to be cached for BLUEPRINT_LPDDR34
//
#define NUM_CACHE_ELEMENTS_BLUEPRINT_LPDDR34               40
//
// Number of registers needed to be cached for BLUEPRINT_DDR3
//
#define NUM_CACHE_ELEMENTS_BLUEPRINT_DDR3                  50
//
// Max number of delay types (i.e. receive enable, TX DQS, etc).
//
#define MAX_NUM_ALGOS                                      20
//
// Max number of delay types for BLUEPRINT_LPDDR34
//
#define NUM_ALGOS_BLUEPRINT_LPDDR34                        13
//
// Max number of delay types for BLUEPRINT_DDR3
//
#define NUM_ALGOS_BLUEPRINT_DDR3                           20
//
// Max number of delay elements per delay type.
//
#define MAX_NUM_DELAY_ELEMENTS                             3
//
// Number of delay elements per delay type for BLUEPRINT_LPDDR34
//
#define NUM_DELAY_ELEMENTS_BLUEPRINT_LPDDR34               3
//
// Number of delay elements per delay type for BLUEPRINT_DDR3
//
#define NUM_DELAY_ELEMENTS_BLUEPRINT_DDR3                  3
//
// Max number of clock crossing (deadband) elements per delay type.
//
#define MAX_NUM_CC_ELEMENTS                                3
//
// Max number of clock crossing (deadband) ranges.
//
#define MAX_NUM_CC_RANGES                                  12
//
// Number of clock crossing (deadband) elements per delay type for BLUEPRINT_LPDDR34
//
#define NUM_CC_ELEMENTS_BLUEPRINT_LPDDR34                  3
//
// Number of clock crossing (deadband) ranges for BLUEPRINT_LPDDR34
//
#define NUM_CC_RANGES_BLUEPRINT_LPDDR34                    12
//
// Number of clock crossing (deadband) elements per delay type for BLUEPRINT_DDR3
//
#define NUM_CC_ELEMENTS_BLUEPRINT_DDR3                     3
//
// Number of clock crossing (deadband) ranges for BLUEPRINT_DDR3
//
#define NUM_CC_RANGES_BLUEPRINT_DDR3                       12
//
// Max number of elements (delay and CC) per delay type.
//
#define MAX_NUM_ELEMENTS_PER_ALGO                          6
//
// Number of elements (delay and CC) per delay type for BLUEPRINT_LPDDR34
//
#define NUM_ELEMENTS_PER_ALGO_BLUEPRINT_LPDDR34            6
//
// Number of elements (delay and CC) per delay type for BLUEPRINT_DDR3
//
#define NUM_ELEMENTS_PER_ALGO_BLUEPRINT_DDR3               6
//
// Max number of elements in the Signal Info Array
//
#define MAX_SIGNAL_INFO_ELEMENTS                           105
//
// Number of elements in the Signal Info Array for BLUEPRINT_LPDDR34
//
#define SIGNAL_INFO_ELEMENTS_BLUEPRINT_LPDDR34             70
//
// Number of elements in the Signal Info Array for BLUEPRINT_DDR3
//
#define SIGNAL_INFO_ELEMENTS_BLUEPRINT_DDR3                105
//
// Max number of frequencies supported by DVFS (dynamic voltage and frequency scaling).
//
#define MAX_NUM_DVFS                                       1
//
// Number of frequencies supported by DVFS (dynamic voltage and frequency scaling) for BLUEPRINT_LPDDR34
//
#define NUM_DVFS_BLUEPRINT_LPDDR34                         1
//
// Number of frequencies supported by DVFS (dynamic voltage and frequency scaling) for BLUEPRINT_DDR3
//
#define NUM_DVFS_BLUEPRINT_DDR3                            1
//
// Indices of each delay type.
//
#define ClkCh0                                             0x3000
#define ClkCh1                                             0x3001
#define CmdCh0                                             0x3002
#define CmdCh1                                             0x3003
#define CtlCh0                                             0x3004
#define CtlCh1                                             0x3005
#define RxDqsNDelay_dq                                     0x3006
#define RxDqsPDelay_dq                                     0x3007
#define TxDqDelay_Actual                                   0x3008
#define TxDqDrive                                          0x3009
#define TxDqsDelay_dq                                      0x300A
#define RecEnDelay_dq                                      0x300B
#define RecEnPiCode_dq                                     0x300C
#define RxDqsNDelay_Ecc                                    0x300D
#define RxDqsPDelay_Ecc                                    0x300E
#define TxDqDelay_Actual_Ecc                               0x300F
#define TxDqDrive_Ecc                                      0x3010
#define TxDqsDelay_Ecc                                     0x3011
#define RecEnDelay_Ecc                                     0x3012
#define RecEnPiCode_Ecc                                    0x3013
//
// Indices of each delay type for BLUEPRINT_LPDDR34
//
#define ClkCh0_BLUEPRINT_LPDDR34                           0x1000
#define ClkCh1_BLUEPRINT_LPDDR34                           0x1001
#define CmdCh0_BLUEPRINT_LPDDR34                           0x1002
#define CmdCh1_BLUEPRINT_LPDDR34                           0x1003
#define CtlCh0_BLUEPRINT_LPDDR34                           0x1004
#define CtlCh1_BLUEPRINT_LPDDR34                           0x1005
#define RxDqsNDelay_dq_BLUEPRINT_LPDDR34                   0x1006
#define RxDqsPDelay_dq_BLUEPRINT_LPDDR34                   0x1007
#define TxDqDelay_Actual_BLUEPRINT_LPDDR34                 0x1008
#define TxDqDrive_BLUEPRINT_LPDDR34                        0x1009
#define TxDqsDelay_dq_BLUEPRINT_LPDDR34                    0x100A
#define RecEnDelay_dq_BLUEPRINT_LPDDR34                    0x100B
#define RecEnPiCode_dq_BLUEPRINT_LPDDR34                   0x100C
//
// Indices of each delay type for BLUEPRINT_DDR3
//
#define ClkCh0_BLUEPRINT_DDR3                              0x1000
#define ClkCh1_BLUEPRINT_DDR3                              0x1001
#define CmdCh0_BLUEPRINT_DDR3                              0x1002
#define CmdCh1_BLUEPRINT_DDR3                              0x1003
#define CtlCh0_BLUEPRINT_DDR3                              0x1004
#define CtlCh1_BLUEPRINT_DDR3                              0x1005
#define RxDqsNDelay_dq_BLUEPRINT_DDR3                      0x1006
#define RxDqsNDelay_Ecc_BLUEPRINT_DDR3                     0x1007
#define RxDqsPDelay_dq_BLUEPRINT_DDR3                      0x1008
#define RxDqsPDelay_Ecc_BLUEPRINT_DDR3                     0x1009
#define TxDqDelay_Actual_BLUEPRINT_DDR3                    0x100A
#define TxDqDelay_Actual_Ecc_BLUEPRINT_DDR3                0x100B
#define TxDqDrive_BLUEPRINT_DDR3                           0x100C
#define TxDqDrive_Ecc_BLUEPRINT_DDR3                       0x100D
#define TxDqsDelay_dq_BLUEPRINT_DDR3                       0x100E
#define TxDqsDelay_Ecc_BLUEPRINT_DDR3                      0x100F
#define RecEnDelay_dq_BLUEPRINT_DDR3                       0x1010
#define RecEnDelay_Ecc_BLUEPRINT_DDR3                      0x1011
#define RecEnPiCode_dq_BLUEPRINT_DDR3                      0x1012
#define RecEnPiCode_Ecc_BLUEPRINT_DDR3                     0x1013
//
// These are signal groups. Subtract 0x4000 from each to get the right index for each group.
//
#define R                                                  0x4000
//
// Max number of group signals
//
#define MAX_NUM_GROUP                                      1
//
// These are signal groups. Subtract 0x1000 from each to get the first delay type in each group for BLUEPRINT_LPDDR34
//
#define R_BLUEPRINT_LPDDR34                                0x200B
//
// These are signal groups. Subtract 0x1000 from each to get the first delay type in each group for BLUEPRINT_DDR3
//
#define R_BLUEPRINT_DDR3                                   0x2010
//
// Index for unique get/set calls which aren't tied to a particular delay/cc type.
//
#define CaVref_Actual                                      0x5000
#define CkeAll                                             0x5001
#define CkeCh0                                             0x5002
#define CkeCh1                                             0x5003
#define MmrcCkGrp0                                         0x5004
#define MmrcCmdAll                                         0x5005
#define MmrcCmdGrp0                                        0x5006
#define MmrcCtlAll                                         0x5007
#define MmrcCtlGrp0                                        0x5008
#define CURRENT_INDEX                                      0x5009
#define DQS_CNT_RESET                                      0x500A
#define FifoReset                                          0x500B
#define INITIAL_INDEX                                      0x500C
#define MuxcodeMax                                         0x500D
#define MuxcodeMin                                         0x500E
#define OdtEnOff                                           0x500F
#define OdtSegEnOff                                        0x5010
#define R2RRcvnEn                                          0x5011
#define R2RRxDqsEn                                         0x5012
#define R2RTxDqEn                                          0x5013
#define R2RTxDqsEn                                         0x5014
#define RDCMD2RDVLD_PLUS1SEL                               0x5015
#define RDCMD2RDVLD_REG                                    0x5016
#define RdRk2RkLatency                                     0x5017
#define MmrcRecEnDelay                                     0x5018
#define RecEnSmp                                           0x5019
#define RecEnSmp_dq                                        0x501A
#define MmrcRxDqBitDelay                                   0x501B
#define MmrcRxDqsDelay                                     0x501C
#define MmrcRxDqsNDelay                                    0x501D
#define MmrcRxDqsPDelay                                    0x501E
#define RxVocEnDq                                          0x501F
#define RxVocEnDqs                                         0x5020
#define RxVocSmp                                           0x5021
#define RxVocValAll                                        0x5022
#define MmrcRxVref                                         0x5023
#define RxVref_dq                                          0x5024
#define TrrdrGetSet                                        0x5025
#define TwwdrGetSet                                        0x5026
#define MmrcTxCaVref                                       0x5027
#define MmrcTxDqBitDelay                                   0x5028
#define MmrcTxDqDelay                                      0x5029
#define MmrcTxDqsDelay                                     0x502A
#define MmrcTxVref                                         0x502B
#define TxVref_Actual                                      0x502C
#define WrLvlSmp                                           0x502D
#define WrLvlSmp_dq                                        0x502E
#define WrPtrEn                                            0x502F
#define WrRk2RkLatency                                     0x5030
#define RxVocVal0                                          0x5031
#define RxVocVal1                                          0x5032
#define RxVocVal2                                          0x5033
#define RxVocVal3                                          0x5034
#define RxVocVal4                                          0x5035
#define RxVocVal5                                          0x5036
#define RxVocVal6                                          0x5037
#define RxVocVal7                                          0x5038
#define DQS_CNT_RESET_Ecc                                  0x5039
#define FifoReset_Ecc                                      0x503A
#define MuxcodeMax_Ecc                                     0x503B
#define MuxcodeMin_Ecc                                     0x503C
#define OdtEnOff_Ecc                                       0x503D
#define OdtSegEnOff_Ecc                                    0x503E
#define R2RRcvnEn_Ecc                                      0x503F
#define R2RRxDqsEn_Ecc                                     0x5040
#define R2RTxDqEn_Ecc                                      0x5041
#define R2RTxDqsEn_Ecc                                     0x5042
#define RdRk2RkLatency_Ecc                                 0x5043
#define RecEnSmp_Ecc                                       0x5044
#define RxVocEnDq_Ecc                                      0x5045
#define RxVocEnDqs_Ecc                                     0x5046
#define RxVocSmp_Ecc                                       0x5047
#define RxVref_Ecc                                         0x5048
#define TimingMode                                         0x5049
#define WrLvlSmp_Ecc                                       0x504A
#define WrPtrEn_Ecc                                        0x504B
#define WrRk2RkLatency_Ecc                                 0x504C
#define RxVocVal0_Ecc                                      0x504D
#define RxVocVal1_Ecc                                      0x504E
#define RxVocVal2_Ecc                                      0x504F
#define RxVocVal3_Ecc                                      0x5050
#define RxVocVal4_Ecc                                      0x5051
#define RxVocVal5_Ecc                                      0x5052
#define RxVocVal6_Ecc                                      0x5053
#define RxVocVal7_Ecc                                      0x5054
//
// Max number of unique signals
//
#define MAX_NUM_UNIQUE                                     85
//
// Index for unique get/set calls which aren't tied to a particular delay/cc type for BLUEPRINT_LPDDR34
//
#define CaVref_Actual_BLUEPRINT_LPDDR34                    78
#define CkeAll_BLUEPRINT_LPDDR34                           79
#define CkeCh0_BLUEPRINT_LPDDR34                           80
#define CkeCh1_BLUEPRINT_LPDDR34                           81
#define CkGrp0_BLUEPRINT_LPDDR34                           82
#define CmdAll_BLUEPRINT_LPDDR34                           83
#define CmdGrp0_BLUEPRINT_LPDDR34                          84
#define CtlAll_BLUEPRINT_LPDDR34                           85
#define CtlGrp0_BLUEPRINT_LPDDR34                          86
#define CURRENT_INDEX_BLUEPRINT_LPDDR34                    87
#define DQS_CNT_RESET_BLUEPRINT_LPDDR34                    88
#define FifoReset_BLUEPRINT_LPDDR34                        89
#define INITIAL_INDEX_BLUEPRINT_LPDDR34                    90
#define MuxcodeMax_BLUEPRINT_LPDDR34                       91
#define MuxcodeMin_BLUEPRINT_LPDDR34                       92
#define OdtEnOff_BLUEPRINT_LPDDR34                         93
#define OdtSegEnOff_BLUEPRINT_LPDDR34                      94
#define R2RRcvnEn_BLUEPRINT_LPDDR34                        95
#define R2RRxDqsEn_BLUEPRINT_LPDDR34                       96
#define R2RTxDqEn_BLUEPRINT_LPDDR34                        97
#define R2RTxDqsEn_BLUEPRINT_LPDDR34                       98
#define RDCMD2RDVLD_PLUS1SEL_BLUEPRINT_LPDDR34             99
#define RDCMD2RDVLD_REG_BLUEPRINT_LPDDR34                  100
#define RdRk2RkLatency_BLUEPRINT_LPDDR34                   101
#define RecEnDelay_BLUEPRINT_LPDDR34                       102
#define RecEnSmp_BLUEPRINT_LPDDR34                         103
#define RecEnSmp_dq_BLUEPRINT_LPDDR34                      104
#define RxDqBitDelay_BLUEPRINT_LPDDR34                     105
#define RxDqsDelay_BLUEPRINT_LPDDR34                       106
#define RxDqsNDelay_BLUEPRINT_LPDDR34                      107
#define RxDqsPDelay_BLUEPRINT_LPDDR34                      108
#define RxVocEnDq_BLUEPRINT_LPDDR34                        109
#define RxVocEnDqs_BLUEPRINT_LPDDR34                       110
#define RxVocSmp_BLUEPRINT_LPDDR34                         111
#define RxVocValAll_BLUEPRINT_LPDDR34                      112
#define RxVref_BLUEPRINT_LPDDR34                           113
#define RxVref_dq_BLUEPRINT_LPDDR34                        114
#define TrrdrGetSet_BLUEPRINT_LPDDR34                      115
#define TwwdrGetSet_BLUEPRINT_LPDDR34                      116
#define TxCaVref_BLUEPRINT_LPDDR34                         117
#define TxDqBitDelay_BLUEPRINT_LPDDR34                     118
#define TxDqDelay_BLUEPRINT_LPDDR34                        119
#define TxDqsDelay_BLUEPRINT_LPDDR34                       120
#define TxVref_BLUEPRINT_LPDDR34                           121
#define TxVref_Actual_BLUEPRINT_LPDDR34                    122
#define WrLvlSmp_BLUEPRINT_LPDDR34                         123
#define WrLvlSmp_dq_BLUEPRINT_LPDDR34                      124
#define WrPtrEn_BLUEPRINT_LPDDR34                          125
#define WrRk2RkLatency_BLUEPRINT_LPDDR34                   126
#define RxVocVal0_BLUEPRINT_LPDDR34                        127
#define RxVocVal1_BLUEPRINT_LPDDR34                        128
#define RxVocVal2_BLUEPRINT_LPDDR34                        129
#define RxVocVal3_BLUEPRINT_LPDDR34                        130
#define RxVocVal4_BLUEPRINT_LPDDR34                        131
#define RxVocVal5_BLUEPRINT_LPDDR34                        132
#define RxVocVal6_BLUEPRINT_LPDDR34                        133
#define RxVocVal7_BLUEPRINT_LPDDR34                        134
//
// Index for unique get/set calls which aren't tied to a particular delay/cc type for BLUEPRINT_DDR3
//
#define CaVref_Actual_BLUEPRINT_DDR3                       120
#define CkeAll_BLUEPRINT_DDR3                              121
#define CkeCh0_BLUEPRINT_DDR3                              122
#define CkeCh1_BLUEPRINT_DDR3                              123
#define CkGrp0_BLUEPRINT_DDR3                              124
#define CmdAll_BLUEPRINT_DDR3                              125
#define CmdGrp0_BLUEPRINT_DDR3                             126
#define CtlAll_BLUEPRINT_DDR3                              127
#define CtlGrp0_BLUEPRINT_DDR3                             128
#define CURRENT_INDEX_BLUEPRINT_DDR3                       129
#define DQS_CNT_RESET_BLUEPRINT_DDR3                       130
#define DQS_CNT_RESET_Ecc_BLUEPRINT_DDR3                   131
#define FifoReset_BLUEPRINT_DDR3                           132
#define FifoReset_Ecc_BLUEPRINT_DDR3                       133
#define INITIAL_INDEX_BLUEPRINT_DDR3                       134
#define MuxcodeMax_BLUEPRINT_DDR3                          135
#define MuxcodeMax_Ecc_BLUEPRINT_DDR3                      136
#define MuxcodeMin_BLUEPRINT_DDR3                          137
#define MuxcodeMin_Ecc_BLUEPRINT_DDR3                      138
#define OdtEnOff_BLUEPRINT_DDR3                            139
#define OdtEnOff_Ecc_BLUEPRINT_DDR3                        140
#define OdtSegEnOff_BLUEPRINT_DDR3                         141
#define OdtSegEnOff_Ecc_BLUEPRINT_DDR3                     142
#define R2RRcvnEn_BLUEPRINT_DDR3                           143
#define R2RRcvnEn_Ecc_BLUEPRINT_DDR3                       144
#define R2RRxDqsEn_BLUEPRINT_DDR3                          145
#define R2RRxDqsEn_Ecc_BLUEPRINT_DDR3                      146
#define R2RTxDqEn_BLUEPRINT_DDR3                           147
#define R2RTxDqEn_Ecc_BLUEPRINT_DDR3                       148
#define R2RTxDqsEn_BLUEPRINT_DDR3                          149
#define R2RTxDqsEn_Ecc_BLUEPRINT_DDR3                      150
#define RDCMD2RDVLD_PLUS1SEL_BLUEPRINT_DDR3                151
#define RDCMD2RDVLD_REG_BLUEPRINT_DDR3                     152
#define RdRk2RkLatency_BLUEPRINT_DDR3                      153
#define RdRk2RkLatency_Ecc_BLUEPRINT_DDR3                  154
#define RecEnDelay_BLUEPRINT_DDR3                          155
#define RecEnSmp_BLUEPRINT_DDR3                            156
#define RecEnSmp_dq_BLUEPRINT_DDR3                         157
#define RecEnSmp_Ecc_BLUEPRINT_DDR3                        158
#define RxDqBitDelay_BLUEPRINT_DDR3                        159
#define RxDqsDelay_BLUEPRINT_DDR3                          160
#define RxDqsNDelay_BLUEPRINT_DDR3                         161
#define RxDqsPDelay_BLUEPRINT_DDR3                         162
#define RxVocEnDq_BLUEPRINT_DDR3                           163
#define RxVocEnDq_Ecc_BLUEPRINT_DDR3                       164
#define RxVocEnDqs_BLUEPRINT_DDR3                          165
#define RxVocEnDqs_Ecc_BLUEPRINT_DDR3                      166
#define RxVocSmp_BLUEPRINT_DDR3                            167
#define RxVocSmp_Ecc_BLUEPRINT_DDR3                        168
#define RxVocValAll_BLUEPRINT_DDR3                         169
#define RxVref_BLUEPRINT_DDR3                              170
#define RxVref_dq_BLUEPRINT_DDR3                           171
#define RxVref_Ecc_BLUEPRINT_DDR3                          172
#define TimingMode_BLUEPRINT_DDR3                          173
#define TrrdrGetSet_BLUEPRINT_DDR3                         174
#define TwwdrGetSet_BLUEPRINT_DDR3                         175
#define TxCaVref_BLUEPRINT_DDR3                            176
#define TxDqBitDelay_BLUEPRINT_DDR3                        177
#define TxDqDelay_BLUEPRINT_DDR3                           178
#define TxDqsDelay_BLUEPRINT_DDR3                          179
#define TxVref_BLUEPRINT_DDR3                              180
#define TxVref_Actual_BLUEPRINT_DDR3                       181
#define WrLvlSmp_BLUEPRINT_DDR3                            182
#define WrLvlSmp_dq_BLUEPRINT_DDR3                         183
#define WrLvlSmp_Ecc_BLUEPRINT_DDR3                        184
#define WrPtrEn_BLUEPRINT_DDR3                             185
#define WrPtrEn_Ecc_BLUEPRINT_DDR3                         186
#define WrRk2RkLatency_BLUEPRINT_DDR3                      187
#define WrRk2RkLatency_Ecc_BLUEPRINT_DDR3                  188
#define RxVocVal0_BLUEPRINT_DDR3                           189
#define RxVocVal0_Ecc_BLUEPRINT_DDR3                       190
#define RxVocVal1_BLUEPRINT_DDR3                           191
#define RxVocVal1_Ecc_BLUEPRINT_DDR3                       192
#define RxVocVal2_BLUEPRINT_DDR3                           193
#define RxVocVal2_Ecc_BLUEPRINT_DDR3                       194
#define RxVocVal3_BLUEPRINT_DDR3                           195
#define RxVocVal3_Ecc_BLUEPRINT_DDR3                       196
#define RxVocVal4_BLUEPRINT_DDR3                           197
#define RxVocVal4_Ecc_BLUEPRINT_DDR3                       198
#define RxVocVal5_BLUEPRINT_DDR3                           199
#define RxVocVal5_Ecc_BLUEPRINT_DDR3                       200
#define RxVocVal6_BLUEPRINT_DDR3                           201
#define RxVocVal6_Ecc_BLUEPRINT_DDR3                       202
#define RxVocVal7_BLUEPRINT_DDR3                           203
#define RxVocVal7_Ecc_BLUEPRINT_DDR3                       204
//
// External functions that need to be called for GetSet elements which require and external function to read/write the element.
//
#define CkeAll_FUNC                                        0
#define CkGrp0_FUNC                                        1
#define CmdAll_FUNC                                        2
#define CmdGrp0_FUNC                                       3
#define CtlAll_FUNC                                        4
#define CtlGrp0_FUNC                                       5
#define RecEnDelay_FUNC                                    6
#define RecEnSmp_FUNC                                      7
#define RxDqsDelay_FUNC                                    8
#define RxDqsNDelay_FUNC                                   9
#define RxDqsPDelay_FUNC                                   10
#define RxVocValAll_FUNC                                   11
#define RxVref_FUNC                                        12
#define TxCaVref_FUNC                                      13
#define TxDqBitDelay_FUNC                                  14
#define TxDqDelay_FUNC                                     15
#define TxDqsDelay_FUNC                                    16
#define TxVref_FUNC                                        17
#define WrLvlSmp_FUNC                                      18
#define TimingMode_FUNC                                    19
//
// External functions for BLUEPRINT_LPDDR34
//
#define CkeAll_FUNC_BLUEPRINT_LPDDR34                      0
#define CkGrp0_FUNC_BLUEPRINT_LPDDR34                      1
#define CmdAll_FUNC_BLUEPRINT_LPDDR34                      2
#define CmdGrp0_FUNC_BLUEPRINT_LPDDR34                     3
#define CtlAll_FUNC_BLUEPRINT_LPDDR34                      4
#define CtlGrp0_FUNC_BLUEPRINT_LPDDR34                     5
#define RecEnDelay_FUNC_BLUEPRINT_LPDDR34                  6
#define RecEnSmp_FUNC_BLUEPRINT_LPDDR34                    7
#define RxDqsDelay_FUNC_BLUEPRINT_LPDDR34                  8
#define RxDqsNDelay_FUNC_BLUEPRINT_LPDDR34                 9
#define RxDqsPDelay_FUNC_BLUEPRINT_LPDDR34                 10
#define RxVocValAll_FUNC_BLUEPRINT_LPDDR34                 11
#define RxVref_FUNC_BLUEPRINT_LPDDR34                      12
#define TxCaVref_FUNC_BLUEPRINT_LPDDR34                    13
#define TxDqBitDelay_FUNC_BLUEPRINT_LPDDR34                14
#define TxDqDelay_FUNC_BLUEPRINT_LPDDR34                   15
#define TxDqsDelay_FUNC_BLUEPRINT_LPDDR34                  16
#define TxVref_FUNC_BLUEPRINT_LPDDR34                      17
#define WrLvlSmp_FUNC_BLUEPRINT_LPDDR34                    18
//
// External functions for BLUEPRINT_DDR3
//
#define CkeAll_FUNC_BLUEPRINT_DDR3                         0
#define CkGrp0_FUNC_BLUEPRINT_DDR3                         1
#define CmdAll_FUNC_BLUEPRINT_DDR3                         2
#define CmdGrp0_FUNC_BLUEPRINT_DDR3                        3
#define CtlAll_FUNC_BLUEPRINT_DDR3                         4
#define CtlGrp0_FUNC_BLUEPRINT_DDR3                        5
#define RecEnDelay_FUNC_BLUEPRINT_DDR3                     6
#define RecEnSmp_FUNC_BLUEPRINT_DDR3                       7
#define RxDqsDelay_FUNC_BLUEPRINT_DDR3                     8
#define RxDqsNDelay_FUNC_BLUEPRINT_DDR3                    9
#define RxDqsPDelay_FUNC_BLUEPRINT_DDR3                    10
#define RxVocValAll_FUNC_BLUEPRINT_DDR3                    11
#define RxVref_FUNC_BLUEPRINT_DDR3                         12
#define TimingMode_FUNC_BLUEPRINT_DDR3                     13
#define TxCaVref_FUNC_BLUEPRINT_DDR3                       14
#define TxDqBitDelay_FUNC_BLUEPRINT_DDR3                   15
#define TxDqDelay_FUNC_BLUEPRINT_DDR3                      16
#define TxDqsDelay_FUNC_BLUEPRINT_DDR3                     17
#define TxVref_FUNC_BLUEPRINT_DDR3                         18
#define WrLvlSmp_FUNC_BLUEPRINT_DDR3                       19
//
// Max number of elements (delay and CC) per delay type.
//
#define MAX_NUM_ELEMENTS                                   205
//
// Number of elements (delay and CC) per delay type for BLUEPRINT_LPDDR34
//
#define NUM_ELEMENTS_BLUEPRINT_LPDDR34                     135
//
// Number of elements (delay and CC) per delay type for BLUEPRINT_DDR3
//
#define NUM_ELEMENTS_BLUEPRINT_DDR3                        205
//
// Total different PFCT variations supported by this project.
//
#define NUM_PLAT                                           6
#define NUM_FREQ                                           10
#define NUM_CONF                                           2
#define NUM_TYPE                                           5
//
// Macros for converting PFCT combinations from the generated tool output into correct bitmasks for the Init sequence.
//
#define P(p)                                               CONV1(p)
#define F(f)                                               CONV2(f)
#define C(c)                                               CONV1(c)
#define T(t)                                               CONV1(t)
#define PF(p,f)                                            CONV2((((p) << NUM_FREQ) + (f)))
#define PT(p,t)                                            CONV2((((p) << NUM_TYPE) + (t)))
#define PC(p,c)                                            CONV1((((p) << NUM_CONF) + (c)))
#define FT(f,t)                                            CONV2((((f) << NUM_TYPE) + (t)))
#define FC(f,c)                                            CONV2((((f) << NUM_CONF) + (c)))
#define CT(c,t)                                            CONV1((((c) << NUM_TYPE) + (t)))
#define PFT(p,f,t)                                         CONV3((((p) << (NUM_FREQ + NUM_TYPE)) + ((f) << NUM_TYPE) + (t)))
#define PFC(p,f,c)                                         CONV3((((p) << (NUM_FREQ + NUM_CONF)) + ((f) << NUM_CONF) + (c)))
#define PCT(p,c,t)                                         CONV2((((p) << (NUM_CONF + NUM_TYPE)) + ((c) << NUM_TYPE) + (t)))
#define FCT(f,c,t)                                         CONV3((((f) << (NUM_CONF + NUM_TYPE)) + ((c) << NUM_TYPE) + (t)))
#define PFCT(p,f,c,t)                                      CONV3((((p) << (NUM_FREQ + NUM_CONF + NUM_TYPE)) + ((f) << (NUM_CONF + NUM_TYPE)) + ((c) << NUM_TYPE) + (t)))
//
// Supported Platforms
//
#define P_NONE                                             0
#define P_SIM                                              BIT0
#define P_EMU                                              BIT1
#define P_SIL_MD                                           BIT2
#define P_SIL_UD                                           BIT3
#define P_SIL_SD                                           BIT4
#define P_SIL                                              BIT5
#define P_ALL                                              0xFFFF
//
// Supported Frequencies
//
#define F_NONE                                             0
#define F_800                                              BIT0
#define F_1066                                             BIT1
#define F_1333                                             BIT2
#define F_1600                                             BIT3
#define F_1866                                             BIT4
#define F_2133                                             BIT5
#define F_2400                                             BIT6
#define F_2666                                             BIT7
#define F_3200                                             BIT8
#define F_2933                                             BIT9
#define F_ALL                                              0xFFFF
//
// Supported Configurations
//
#define C_NONE                                             0
#define C_PO                                               BIT0
#define C_POR                                              BIT1
#define C_ALL                                              0xFFFF
//
// Supported Types
//
#define T_NONE                                             0
#define T_LPDDR3                                           BIT0
#define T_LPDDR4                                           BIT1
#define T_DDR3                                             BIT2
#define T_WIO2                                             BIT3
#define T_DDR4                                             BIT4
#define T_ALL                                              0xFFFF
//
// Supported Boot Paths
//
#define S0                                                 BIT0
#define S0W                                                BIT1
#define S0C                                                BIT2
#define S5                                                 BIT3
#define FB                                                 BIT4
#define S3                                                 BIT5
#define EM                                                 BIT6
#define CSE                                                BIT7
#define RS                                                 BIT8
#define A0                                                 BIT9
#define ALL_PATHS                                          0xFF
//
// Max number of subtasks
//
#define MAX_SUBTASKS                                       2

//
// All possible actions for the init phase of MMRC.
//
#define SET                                                0
#define DELAY                                              1
#define SET_DELAY                                          2
#define FORCE_SET                                          3
#define POLL                                               4
#define GET                                                5
#define SUBTASK                                            6
#define ACTION_ERROR                                       7
//
// Offsets into InitData[] for each init block. Total size = 16282 bytes.
//
#define InitPunit                                          0
#define PollPunit                                          (InitPunit + 28)
#define sai_init_seq                                       (PollPunit + 15)
#define modmem_init_lpddrgrp1xm_seq                        (sai_init_seq + 55)
#define modmem_init_lpddrgrp1p5_seq                        (modmem_init_lpddrgrp1xm_seq + 258)
#define modmem_init_lpddrgrp2m_seq                         (modmem_init_lpddrgrp1p5_seq + 389)
#define modmem_init_lpddrgrp3m_seq                         (modmem_init_lpddrgrp2m_seq + 517)
#define modmem_init_lpddrgrp3_seq                          (modmem_init_lpddrgrp3m_seq + 931)
#define modmem_init_lpddrgrp3p75_seq                       (modmem_init_lpddrgrp3_seq + 3600)
#define modmem_init_lpddrgrp4m_seq                         (modmem_init_lpddrgrp3p75_seq + 7)
#define modmem_bxtp_ldo_offsetcomp_seq                     (modmem_init_lpddrgrp4m_seq + 51)
#define modmem_init_lpddrgrp2p5_seq                        (modmem_bxtp_ldo_offsetcomp_seq + 9)
#define modmem_bxtp_ldo_offsetcomp_poll_seq                (modmem_init_lpddrgrp2p5_seq + 106)
#define modmem_init_lpddrgrp4_seq                          (modmem_bxtp_ldo_offsetcomp_poll_seq + 15)
#define modmem_init_lpddrgrp4p5_seq                        (modmem_init_lpddrgrp4_seq + 189)
#define modmem_init_lpddrgrp5m_seq                         (modmem_init_lpddrgrp4p5_seq + 99)
#define modmem_init_lpddrgrp5_seq                          (modmem_init_lpddrgrp5m_seq + 440)
#define modmem_init_lpddrgrp5p25_seq                       (modmem_init_lpddrgrp5_seq + 117)
#define modmem_init_lpddrgrp5p5m_seq                       (modmem_init_lpddrgrp5p25_seq + 42)
#define PhyConfigComplete                                  (modmem_init_lpddrgrp5p5m_seq + 595)
#define DunitResetComplete                                 (PhyConfigComplete + 8)
#define wake_dunit                                         (DunitResetComplete + 8)
#define modmem_init_lpddrgrp5p5_seq                        (wake_dunit + 19)
#define modmem_init_lpddrgrp6_seq                          (modmem_init_lpddrgrp5p5_seq + 29)
#define modmem_init_lpddrgrp6p5_seq                        (modmem_init_lpddrgrp6_seq + 49)
#define modmem_init_lpddrgrp7_seq                          (modmem_init_lpddrgrp6p5_seq + 21)
#define modmem_init_lpddrgrp7p5_seq                        (modmem_init_lpddrgrp7_seq + 142)
#define modmem_init_lpddrgrp7p75_seq                       (modmem_init_lpddrgrp7p5_seq + 21)
#define modmem_init_lpddrgrp7p75_lp4seq                    (modmem_init_lpddrgrp7p75_seq + 197)
#define modmem_init_lpddrgrp8m_seq                         (modmem_init_lpddrgrp7p75_lp4seq + 20)
#define modmem_init_lpddrgrp0_seq                          (modmem_init_lpddrgrp8m_seq + 63)
#define modmem_init_lpddrgrp10m_seq                        (modmem_init_lpddrgrp0_seq + 9)
#define InitDunit                                          (modmem_init_lpddrgrp10m_seq + 20)
#define InitDunitWake                                      (InitDunit + 219)
#define PrepareForTraining                                 (InitDunitWake + 21)
#define CPGC_ONE_TIME_INIT                                 (PrepareForTraining + 55)
#define modmem_init_dramreset_seq_sim                      (CPGC_ONE_TIME_INIT + 534)
#define modmem_init_dramreset_seq                          (modmem_init_dramreset_seq_sim + 101)
#define ProgramSelfRefresh                                 (modmem_init_dramreset_seq + 101)
#define ProgramFinalSettings                               (ProgramSelfRefresh + 15)
#define TrainingDone                                       (ProgramFinalSettings + 494)
#define modmem_init_lpddrgrp11m_seq                        (TrainingDone + 31)
#define modmem_init_lpddrgrp12m_seq                        (modmem_init_lpddrgrp11m_seq + 351)
#define CPGCModeComplete                                   (modmem_init_lpddrgrp12m_seq + 50)
#define SetECCBonus                                        (CPGCModeComplete + 8)
#define SetMrcDone                                         (SetECCBonus + 9)
#define InitDunitWakeS0set                                 (SetMrcDone + 15)
#define InitDunitWakeS0poll                                (InitDunitWakeS0set + 8)
#define modmem_init_lpddrgrp10_seq                         (InitDunitWakeS0poll + 8)
#define modmem_lp4_freq_switch_seq1                        (modmem_init_lpddrgrp10_seq + 15)
#define modmem_lp4_freq_switch_seq2                        (modmem_lp4_freq_switch_seq1 + 94)
#define modmem_lp4_freq_switch_seq2a                       (modmem_lp4_freq_switch_seq2 + 96)
#define modmem_lp4_freq_switch_seq3                        (modmem_lp4_freq_switch_seq2a + 109)
#define modmem_init_dramreset_seq_lp4_a                    (modmem_lp4_freq_switch_seq3 + 50)
#define modmem_init_dramreset_seq_lp4_b                    (modmem_init_dramreset_seq_lp4_a + 21)
#define modmem_init_dramreset_seq_lp4_c                    (modmem_init_dramreset_seq_lp4_b + 9)
#define modmem_init_dramreset_seq_lp4_d                    (modmem_init_dramreset_seq_lp4_c + 9)
#define maxpi_dll_init                                     (modmem_init_dramreset_seq_lp4_d + 9)
#define maxpi_override_coarse_init                         (maxpi_dll_init + 39)
#define maxpi_set_codes                                    (maxpi_override_coarse_init + 101)
#define maxpi_get_codes                                    (maxpi_set_codes + 71)
#define maxpi_override_coarse_final                        (maxpi_get_codes + 61)
#define WEAK_ODT_SET                                       (maxpi_override_coarse_final + 169)
#define ECC_PHY_INIT                                       (WEAK_ODT_SET + 14)
#define modmem_init_progcmdckctl_seq                       (ECC_PHY_INIT + 15)
#define DunitFreqChangePart1                               (modmem_init_progcmdckctl_seq + 385)
#define ChangePHYFreq                                      (DunitFreqChangePart1 + 62)
#define DunitFreqChangePart3                               (ChangePHYFreq + 1)
#define SetICBitDone                                       (DunitFreqChangePart3 + 56)
#define ProgramECCEnable                                   (SetICBitDone + 7)
#define ReadFuses                                          (ProgramECCEnable + 7)
#define EnableScrambling                                   (ReadFuses + 7)
#define SetMrcDoneRemove                                   (EnableScrambling + 7)
#define ReadBarAddress                                     (SetMrcDoneRemove + 7)
#define WriteMchBarAddress                                 (ReadBarAddress + 37)
#define WriteBarAddress                                    (WriteMchBarAddress + 7)
#define SetSliceChannel                                    (WriteBarAddress + 21)
#define LockAunitSliceChannel                              (SetSliceChannel + 104)
#define DisableDynamicSr                                   (LockAunitSliceChannel + 9)
#define ReadPunit                                          (DisableDynamicSr + 37)
#define SetPunitMemDone                                    (ReadPunit + 16)
#define RESETDRAMS                                         (SetPunitMemDone + 8)
#define ECCClockGate                                       (RESETDRAMS + 9)
#define HALF_CFG_PWR_GATE                                  (ECCClockGate + 11)
#define SwitchTo2N                                         (HALF_CFG_PWR_GATE + 79)
#define SwitchTo1N                                         (SwitchTo2N + 45)
#define WRLVLMODE                                          (SwitchTo1N + 45)
#define DiffAmpOverride                                    (WRLVLMODE + 13)
#define DiffAmpRestore                                     (DiffAmpOverride + 123)
#define SEND_DRAM_CMD                                      (DiffAmpRestore + 23)
#define CPGC_RUN_KIRK                                      (SEND_DRAM_CMD + 8)
#define xyz                                                (CPGC_RUN_KIRK + 46)
#define FORCEODT_ON                                        (xyz + 7)
#define FORCEODT_OFF                                       (FORCEODT_ON + 1)
#define FORCEODT_REL                                       (FORCEODT_OFF + 1)
#define READTRAINING_EXIT                                  (FORCEODT_REL + 1)
#define CPGC_DISABLE                                       (READTRAINING_EXIT + 1)
#define SetAunitSliceChannel                               (CPGC_DISABLE + 19)
#define CPGC_RUN_TEST_L                                    (SetAunitSliceChannel + 1)
#define CPGC_SETUP_ERT                                     (CPGC_RUN_TEST_L + 188)
#define CPGC_EXIT_ERT                                      (CPGC_SETUP_ERT + 14)
#define CPGC_RUN_DIRECT                                    (CPGC_EXIT_ERT + 14)
#define CPGC_CHECK_ERRORS                                  (CPGC_RUN_DIRECT + 34)
#define CPGC_SETUP_DPAT0                                   (CPGC_CHECK_ERRORS + 8)
#define CPGC_RUN_TEST                                      (CPGC_SETUP_DPAT0 + 8)
#define CPGC_ENABLE                                        (CPGC_RUN_TEST + 182)
#define CPGC_RESETUP_WRITE_READ                            (CPGC_ENABLE + 32)
#define DQ_DB_REGION_PROGRAM                               (CPGC_RESETUP_WRITE_READ + 44)
#define CPGC_SETUP_VA                                      (DQ_DB_REGION_PROGRAM + 25)
#define CPGC_LOOPS                                         (CPGC_SETUP_VA + 153)
#define DRIVE_CKE                                          (CPGC_LOOPS + 13)
#define CPGC_STOP_TEST                                     (DRIVE_CKE + 7)
#define DQCALRD                                            (CPGC_STOP_TEST + 23)
#define ENABLE_CKE_OVERRIDE                                (DQCALRD + 7)
#define PRECHARGEALL                                       (ENABLE_CKE_OVERRIDE + 7)
#define CPGC_TARGET_BANK                                   (PRECHARGEALL + 22)
#define CPGC_FIXVAR                                        (CPGC_TARGET_BANK + 14)
#define CPGC_FIXVAR_REVERT                                 (CPGC_FIXVAR + 14)
#define CPGC_MRS                                           (CPGC_FIXVAR_REVERT + 27)
#define CPGC_CADB1                                         (CPGC_MRS + 150)
#define CPGC_DESELECT_DIS                                  (CPGC_CADB1 + 293)
#define CPGC_DESELECT_EN                                   (CPGC_DESELECT_DIS + 69)
#define CPGC_CADB1_BUFA                                    (CPGC_DESELECT_EN + 47)
#define CPGC_CADB1_BUFB                                    (CPGC_CADB1_BUFA + 57)
#define CPGC_CWL_PATTERN                                   (CPGC_CADB1_BUFB + 57)
#define CPGC_EXIT_MRS                                      (CPGC_CWL_PATTERN + 15)
#define CPGC_CADB_MODE                                     (CPGC_EXIT_MRS + 15)
#define CPGC_RESETUP_TRAFFIC                               (CPGC_CADB_MODE + 29)
#define CPGC_DPAT_MODE                                     (CPGC_RESETUP_TRAFFIC + 19)
#define CPGC_LDO_CADB                                      (CPGC_DPAT_MODE + 22)
#define CPGC_LDO_DPAT                                      (CPGC_LDO_CADB + 89)
#define CPGC_LDO_CADB_LFSR                                 (CPGC_LDO_DPAT + 97)
#define CPGC_LDO_DPAT_LFSR                                 (CPGC_LDO_CADB_LFSR + 89)
#define EARLY_READ_TRAINING_ENTRY                          (CPGC_LDO_DPAT_LFSR + 97)
#define EARLY_READ_TRAINING_EXIT                           (EARLY_READ_TRAINING_ENTRY + 1)
#define FINEWRITELEVEL_ENTRY                               (EARLY_READ_TRAINING_EXIT + 7)
#define FINEWRITELEVEL_SHAPE                               (FINEWRITELEVEL_ENTRY + 31)
#define FINEWRITELEVEL_EXIT                                (FINEWRITELEVEL_SHAPE + 50)
#define ENTER_CA_TRAINING                                  (FINEWRITELEVEL_EXIT + 31)
#define ENTER_CA_TRAINING_CCC                              (ENTER_CA_TRAINING + 372)
#define EXIT_CA_TRAINING                                   (ENTER_CA_TRAINING_CCC + 7)
#define EXIT_CA_TRAINING_CCC                               (EXIT_CA_TRAINING + 121)
#define ECT_ENTRY                                          (EXIT_CA_TRAINING_CCC + 13)
#define ECT_ENTRY_CCC                                      (ECT_ENTRY + 26)
#define RCVEN_ENTRY                                        (ECT_ENTRY_CCC + 26)
#define RCVEN_EXIT                                         (RCVEN_ENTRY + 221)
#define VOC_TRAINING_ENTRY                                 (RCVEN_EXIT + 29)
#define VOC_GET_LDO_ENABLE                                 (VOC_TRAINING_ENTRY + 371)
#define VOC_PHY_ENTRY                                      (VOC_GET_LDO_ENABLE + 8)
#define VOC_COMP_VREF_AND_INIT                             (VOC_PHY_ENTRY + 97)
#define VOC_GET_RCOMP_PUP_VALUE                            (VOC_COMP_VREF_AND_INIT + 27)
#define VOC_GET_RCOMP_PDN_VALUE                            (VOC_GET_RCOMP_PUP_VALUE + 7)
#define VOC_SET_ODT_RCOMP_OVERRIDE                         (VOC_GET_RCOMP_PDN_VALUE + 7)
#define VOC_ENABLE_WLMODE                                  (VOC_SET_ODT_RCOMP_OVERRIDE + 29)
#define VOC_DISABLE_WLMODE                                 (VOC_ENABLE_WLMODE + 13)
#define VOC_TRAINING_EXIT                                  (VOC_DISABLE_WLMODE + 13)
#define PERIODIC_TRAINING_START                            (VOC_TRAINING_EXIT + 163)
#define PERIODIC_TRAINING_READ                             (PERIODIC_TRAINING_START + 129)
#define PERIODIC_TRAINING_MNT_DIS                          (PERIODIC_TRAINING_READ + 14)
#define PERIODIC_TRAINING_EN                               (PERIODIC_TRAINING_MNT_DIS + 58)
#define CPGC_GET_TEST_RESULT                               (PERIODIC_TRAINING_EN + 19)
#define CPGC_SET_CHUNK_MASK                                (CPGC_GET_TEST_RESULT + 43)
#define CPGC_STOP_CLEAR_ERR                                (CPGC_SET_CHUNK_MASK + 8)
#define CPGC_START_TEST                                    (CPGC_STOP_CLEAR_ERR + 23)
#define gen_rxpbden_set                                    (CPGC_START_TEST + 12)
#define CPGC_ECC_EN                                        (gen_rxpbden_set + 20)
#define MEM_INIT                                           (CPGC_ECC_EN + 20)
#define MNTEN_SET                                          (MEM_INIT + 26)
#define MNTEN_CLR                                          (MNTEN_SET + 7)
#define READTRAINING_ENTRY                                 (MNTEN_CLR + 7)
//
// All dynamic register names. Each of these will be written to during the Init phase of MMRC.
//
#define DYN_PUNIT_BOXTYPE_P_CR_DDR_THERM_THRT_CTRL_0_0_0_MCHBAR 0
#define DYN_PUNIT_BOXTYPE_P_CR_MC_BIOS_REQ_0_0_0_MCHBAR    1
#define DYN_CCC_BOXTYPE_DIGCTL                             2
#define DYN_CCC_BOXTYPE_CH1_DIGCTL                         3
#define DYN_DQ_BOXTYPE_DIGCTL                              4
#define DYN_CCC_BOXTYPE_WRDQSCTL                           5
#define DYN_CCC_BOXTYPE_WRDQSCTL_1                         6
#define DYN_CCC_BOXTYPE_WRDQSCTL_2                         7
#define DYN_CCC_BOXTYPE_WRDQSCTL_3                         8
#define DYN_CCC_BOXTYPE_WRDQSCTL_4                         9
#define DYN_CCC_BOXTYPE_WRDQSCTL_5                         10
#define DYN_CCC_BOXTYPE_WRDQSCTL_6                         11
#define DYN_CCC_BOXTYPE_WRDQSCTL_7                         12
#define DYN_CCC_BOXTYPE_RDVLDCTL                           13
#define DYN_CCC_BOXTYPE_RDVLDCTL_1                         14
#define DYN_CCC_BOXTYPE_RDVLDCTL_2                         15
#define DYN_CCC_BOXTYPE_RDVLDCTL_3                         16
#define DYN_CCC_BOXTYPE_RDVLDCTL_4                         17
#define DYN_CCC_BOXTYPE_RDVLDCTL_5                         18
#define DYN_CCC_BOXTYPE_RDVLDCTL_6                         19
#define DYN_CCC_BOXTYPE_RDVLDCTL_7                         20
#define DYN_CCC_BOXTYPE_RK2RKCTL0                          21
#define DYN_CCC_BOXTYPE_RK2RKCTL0_1                        22
#define DYN_CCC_BOXTYPE_RK2RKCTL0_2                        23
#define DYN_CCC_BOXTYPE_RK2RKCTL0_3                        24
#define DYN_CCC_BOXTYPE_RK2RKCTL0_4                        25
#define DYN_CCC_BOXTYPE_RXDLLRDCMDCTL0                     26
#define DYN_CCC_BOXTYPE_RXDLLRDCMDCTL0_1                   27
#define DYN_CCC_BOXTYPE_RXDLLRDCMDCTL0_2                   28
#define DYN_CCC_BOXTYPE_RXDLLRDCMDCTL0_3                   29
#define DYN_CCC_BOXTYPE_RXDLLRDCMDCTL0_4                   30
#define DYN_CCC_BOXTYPE_RXDLLRDCMDCTL0_5                   31
#define DYN_CCC_BOXTYPE_RXDLLRDCMDCTL0_6                   32
#define DYN_DQ_BOXTYPE_WRDQSCTL_CC                         33
#define DYN_DQ_BOXTYPE_WRDQSCTL_CC_1                       34
#define DYN_DQ_BOXTYPE_WRDQSCTL_CC_2                       35
#define DYN_DQ_BOXTYPE_WRDQSCTL_CC_3                       36
#define DYN_DQ_BOXTYPE_WRDQSCTL_CC_4                       37
#define DYN_DQ_BOXTYPE_WRDQSCTL_CC_5                       38
#define DYN_DQ_BOXTYPE_WRDQSCTL_CC_6                       39
#define DYN_DQ_BOXTYPE_WRDQSCTL_CC_7                       40
#define DYN_DQ_BOXTYPE_WRDQSCTL_BL                         41
#define DYN_DQ_BOXTYPE_WRDQSCTL_BL_1                       42
#define DYN_DQ_BOXTYPE_WRDQSCTL_BL_2                       43
#define DYN_DQ_BOXTYPE_WRDQSCTL_BL_3                       44
#define DYN_DQ_BOXTYPE_WRDQSCTL_BL_4                       45
#define DYN_DQ_BOXTYPE_WRDQSCTL_BL_5                       46
#define DYN_DQ_BOXTYPE_WRDQSCTL_BL_6                       47
#define DYN_DQ_BOXTYPE_WRDQSCTL_BL_7                       48
#define DYN_DQ_BOXTYPE_RDVLDCTL                            49
#define DYN_DQ_BOXTYPE_RDVLDCTL_1                          50
#define DYN_DQ_BOXTYPE_RDVLDCTL_2                          51
#define DYN_DQ_BOXTYPE_RDVLDCTL_3                          52
#define DYN_DQ_BOXTYPE_RDVLDCTL_4                          53
#define DYN_DQ_BOXTYPE_RDVLDCTL_5                          54
#define DYN_DQ_BOXTYPE_RDVLDCTL_6                          55
#define DYN_DQ_BOXTYPE_RDVLDCTL_7                          56
#define DYN_DQ_BOXTYPE_RK2RKCTL0                           57
#define DYN_DQ_BOXTYPE_RK2RKCTL0_1                         58
#define DYN_DQ_BOXTYPE_RK2RKCTL0_2                         59
#define DYN_DQ_BOXTYPE_RK2RKCTL0_3                         60
#define DYN_DQ_BOXTYPE_RK2RKCTL0_4                         61
#define DYN_DQ_BOXTYPE_RK2RKCTL0_5                         62
#define DYN_DQ_BOXTYPE_RXDLLRDCMDCTL0                      63
#define DYN_DQ_BOXTYPE_RXDLLRDCMDCTL0_1                    64
#define DYN_DQ_BOXTYPE_RXDLLRDCMDCTL0_2                    65
#define DYN_DQ_BOXTYPE_RXDLLRDCMDCTL0_3                    66
#define DYN_DQ_BOXTYPE_RXDLLRDCMDCTL0_4                    67
#define DYN_DQ_BOXTYPE_RXDLLRDCMDCTL0_5                    68
#define DYN_DQ_BOXTYPE_RXDLLRDCMDCTL0_6                    69
#define DYN_CCC_BOXTYPE_RXODTSEGCTL                        70
#define DYN_CCC_BOXTYPE_RXODTSEGCTL_1                      71
#define DYN_CCC_BOXTYPE_RXODTSEGCTL_2                      72
#define DYN_CCC_BOXTYPE_RXODTSEGCTL_3                      73
#define DYN_CCC_BOXTYPE_RXODTSEGCTL_4                      74
#define DYN_CCC_BOXTYPE_RXODTSEGCTL_5                      75
#define DYN_CCC_BOXTYPE_RXODTSEGCTL_6                      76
#define DYN_CCC_BOXTYPE_RXODTCTL                           77
#define DYN_CCC_BOXTYPE_RXODTCTL_1                         78
#define DYN_CCC_BOXTYPE_RXODTCTL_2                         79
#define DYN_CCC_BOXTYPE_RXODTCTL_3                         80
#define DYN_CCC_BOXTYPE_RXODTCTL_4                         81
#define DYN_CCC_BOXTYPE_RXODTCTL_5                         82
#define DYN_CCC_BOXTYPE_RXODTCTL_6                         83
#define DYN_CCC_BOXTYPE_RCVENCTL                           84
#define DYN_CCC_BOXTYPE_RCVENCTL_1                         85
#define DYN_CCC_BOXTYPE_RCVENCTL_2                         86
#define DYN_CCC_BOXTYPE_RCVENCTL_3                         87
#define DYN_CCC_BOXTYPE_RCVENCTL_4                         88
#define DYN_CCC_BOXTYPE_RCVENCTL_5                         89
#define DYN_CCC_BOXTYPE_RCVENCTL_6                         90
#define DYN_CCC_BOXTYPE_DIFFAMPCTL                         91
#define DYN_CCC_BOXTYPE_DIFFAMPCTL_1                       92
#define DYN_CCC_BOXTYPE_DIFFAMPCTL_2                       93
#define DYN_CCC_BOXTYPE_DIFFAMPCTL_3                       94
#define DYN_CCC_BOXTYPE_DIFFAMPCTL_4                       95
#define DYN_CCC_BOXTYPE_DIFFAMPCTL_5                       96
#define DYN_CCC_BOXTYPE_DIFFAMPCTL_6                       97
#define DYN_CCC_BOXTYPE_DIFFAMPCTL_7                       98
#define DYN_CCC_BOXTYPE_DIFFAMPCTL_8                       99
#define DYN_CCC_BOXTYPE_DIFFAMPCTL_9                       100
#define DYN_CCC_BOXTYPE_DIFFAMPCTL_10                      101
#define DYN_CCC_BOXTYPE_DIFFAMPCTL_11                      102
#define DYN_CCC_BOXTYPE_DIFFAMPCTL_12                      103
#define DYN_DQ_BOXTYPE_FIFOPTRCTL                          104
#define DYN_DQ_BOXTYPE_FIFOPTRCTL_1                        105
#define DYN_DQ_BOXTYPE_FIFOPTRCTL_2                        106
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL13                    107
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL13_1                  108
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL13_2                  109
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL13_3                  110
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL13_4                  111
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL13_5                  112
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL13_6                  113
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL02                    114
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL02_1                  115
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL02_2                  116
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL02_3                  117
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL02_4                  118
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL02_5                  119
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL02_6                  120
#define DYN_DQ_BOXTYPE_RXODTCTL_BL13                       121
#define DYN_DQ_BOXTYPE_RXODTCTL_BL13_1                     122
#define DYN_DQ_BOXTYPE_RXODTCTL_BL13_2                     123
#define DYN_DQ_BOXTYPE_RXODTCTL_BL13_3                     124
#define DYN_DQ_BOXTYPE_RXODTCTL_BL13_4                     125
#define DYN_DQ_BOXTYPE_RXODTCTL_BL13_5                     126
#define DYN_DQ_BOXTYPE_RXODTCTL_BL13_6                     127
#define DYN_DQ_BOXTYPE_RXODTCTL_DQ                         128
#define DYN_DQ_BOXTYPE_RXODTCTL_DQ_1                       129
#define DYN_DQ_BOXTYPE_RXODTCTL_DQ_2                       130
#define DYN_DQ_BOXTYPE_RXODTCTL_DQ_3                       131
#define DYN_DQ_BOXTYPE_RXODTCTL_DQ_4                       132
#define DYN_DQ_BOXTYPE_RXODTCTL_DQ_5                       133
#define DYN_DQ_BOXTYPE_RXODTCTL_DQ_6                       134
#define DYN_DQ_BOXTYPE_RCVENCTL_BL13                       135
#define DYN_DQ_BOXTYPE_RCVENCTL_BL13_1                     136
#define DYN_DQ_BOXTYPE_RCVENCTL_BL13_2                     137
#define DYN_DQ_BOXTYPE_RCVENCTL_BL13_3                     138
#define DYN_DQ_BOXTYPE_RCVENCTL_BL13_4                     139
#define DYN_DQ_BOXTYPE_RCVENCTL_BL13_5                     140
#define DYN_DQ_BOXTYPE_RCVENCTL_BL13_6                     141
#define DYN_DQ_BOXTYPE_RCVENCTL_BL02                       142
#define DYN_DQ_BOXTYPE_RCVENCTL_BL02_1                     143
#define DYN_DQ_BOXTYPE_RCVENCTL_BL02_2                     144
#define DYN_DQ_BOXTYPE_RCVENCTL_BL02_3                     145
#define DYN_DQ_BOXTYPE_RCVENCTL_BL02_4                     146
#define DYN_DQ_BOXTYPE_RCVENCTL_BL02_5                     147
#define DYN_DQ_BOXTYPE_RCVENCTL_BL02_6                     148
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL13                     149
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL13_1                   150
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL13_2                   151
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL13_3                   152
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL13_4                   153
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL13_5                   154
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL13_6                   155
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL13_7                   156
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL13_8                   157
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL13_9                   158
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL13_10                  159
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL13_11                  160
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL02                     161
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL02_1                   162
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL02_2                   163
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL02_3                   164
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL02_4                   165
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL02_5                   166
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL02_6                   167
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL02_7                   168
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL02_8                   169
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL02_9                   170
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL02_10                  171
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL02_11                  172
#define DYN_DQDPLVUG_BOXTYPE_PTCTL0                        173
#define DYN_DQDPLVUG_BOXTYPE_PTCTL0_1                      174
#define DYN_DQDPLVUG_BOXTYPE_PTCTL0_2                      175
#define DYN_DQDPLVUG_BOXTYPE_PTCTL0_3                      176
#define DYN_DQDPLVUG_BOXTYPE_PTCTL0_4                      177
#define DYN_DQDPLVUG_BOXTYPE_PTCTL0_5                      178
#define DYN_DPLVUG_BOXTYPE_DPIC_GRCOMP_CFG3                179
#define DYN_DPIC_BOXTYPE_PLLCTL                            180
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR1                181
#define DYN_DQDPLVUG_BOXTYPE_DPIC_LRCOMP_OVR1              182
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR1_1              183
#define DYN_DQDPLVUG_BOXTYPE_DPIC_LRCOMP_OVR1_1            184
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR1_2              185
#define DYN_DQDPLVUG_BOXTYPE_DPIC_LRCOMP_OVR1_2            186
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR1_3              187
#define DYN_DQDPLVUG_BOXTYPE_DPIC_LRCOMP_OVR1_3            188
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR2                189
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR2_1              190
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR2_2              191
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR2_3              192
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR3                193
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR3_1              194
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR3_2              195
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR3_3              196
#define DYN_DUNIT_BOXTYPE_D_CR_DRP0                        197
#define DYN_DUNIT_BOXTYPE_D_CR_DRP0_1                      198
#define DYN_DUNIT_BOXTYPE_D_CR_DTR0A                       199
#define DYN_DUNIT_BOXTYPE_D_CR_DRP0_2                      200
#define DYN_DUNIT_BOXTYPE_D_CR_DTR1A                       201
#define DYN_DUNIT_BOXTYPE_D_CR_DTR2A                       202
#define DYN_DUNIT_BOXTYPE_D_CR_DTR3A                       203
#define DYN_DUNIT_BOXTYPE_D_CR_DTR4A                       204
#define DYN_DUNIT_BOXTYPE_D_CR_DTR5A                       205
#define DYN_DUNIT_BOXTYPE_D_CR_DTR6A                       206
#define DYN_DUNIT_BOXTYPE_D_CR_DTR7A                       207
#define DYN_DUNIT_BOXTYPE_D_CR_DTR8A                       208
#define DYN_DUNIT_BOXTYPE_D_CR_SSKPD0                      209
#define DYN_DUNIT_BOXTYPE_D_CR_BONUS0                      210
#define DYN_DUNIT_BOXTYPE_D_CR_BONUS1                      211
#define DYN_DUNIT_BOXTYPE_D_CR_MR4_DESWIZZLE               212
#define DYN_DUNIT_BOXTYPE_D_CR_DOCRA                       213
#define DYN_DUNIT_BOXTYPE_D_CR_DOCRA_1                     214
#define DYN_DUNIT_BOXTYPE_D_CR_DOCRA_2                     215
#define DYN_DUNIT_BOXTYPE_D_CR_DRMC                        216
#define DYN_DUNIT_BOXTYPE_D_CR_BGF_CTL                     217
#define DYN_DUNIT_BOXTYPE_D_CR_BGF_CTL_1                   218
#define DYN_DUNIT_BOXTYPE_D_CR_BGF_CTL_2                   219
#define DYN_DUNIT_BOXTYPE_D_CR_DRMC_1                      220
#define DYN_DUNIT_BOXTYPE_D_CR_DRMC_2                      221
#define DYN_DUNIT_BOXTYPE_D_CR_DRFC                        222
#define DYN_DUNIT_BOXTYPE_D_CR_DRFC_1                      223
#define DYN_DUNIT_BOXTYPE_D_CR_DRP0_3                      224
#define DYN_DUNIT_BOXTYPE_D_CR_DPMC1                       225
#define DYN_DUNIT_BOXTYPE_D_CR_DSCH                        226
#define DYN_DUNIT_BOXTYPE_D_CR_BGF_CUSTOM_TSV_CMD_PATTERN  227
#define DYN_DUNIT_BOXTYPE_D_CR_BGF_CUSTOM_TSV_CMD_INIT     228
#define DYN_DUNIT_BOXTYPE_D_CR_BGF_CUSTOM_TSV_DATA_PATTERN 229
#define DYN_DUNIT_BOXTYPE_D_CR_BGF_CUSTOM_TSV_DATA_INIT    230
#define DYN_DUNIT_BOXTYPE_D_CR_TQCTL                       231
#define DYN_DUNIT_BOXTYPE_D_CR_TQCTL_1                     232
#define DYN_DUNIT_BOXTYPE_D_CR_TQOFFSET                    233
#define DYN_DUNIT_BOXTYPE_D_CR_BGF_CTL_3                   234
#define DYN_DUNIT_BOXTYPE_D_CR_BGF_CTL_4                   235
#define DYN_DUNIT_BOXTYPE_D_CR_BGF_CTL_5                   236
#define DYN_DUNIT_BOXTYPE_D_CR_DQS_RETRAINING_CTL          237
#define DYN_CCC_BOXTYPE_RDVLDCTL_8                         238
#define DYN_DQ_BOXTYPE_RDVLDCTL_8                          239
#define DYN_PUNIT_BOXTYPE_P_CR_MC_BIOS_REQ_0_0_0_MCHBAR_1  240
#define DYN_DUNIT_BOXTYPE_D_CR_DRMC_3                      241
#define DYN_DQ_BOXTYPE_DLLCOMP_FBMUXSEL                    242
#define DYN_CCC_BOXTYPE_DLLCOMP_FBMUXSEL1                  243
#define DYN_DQ_BOXTYPE_DLLCOMP_FINECODE                    244
#define DYN_CCC_BOXTYPE_DLLCOMP_FINECODE                   245
#define DYN_DQ_BOXTYPE_DLLCOMP_COARSECODE                  246
#define DYN_CCC_BOXTYPE_DLLCOMP_COARSECODE1                247
#define DYN_CCC_BOXTYPE_DLLCOMP_COARSECODE0_CH0            248
#define DYN_CCC_BOXTYPE_DLLCOMP_COARSECODE0_CH0_1          249
#define DYN_CCC_BOXTYPE_DLLCOMP_COARSECODE0_CH1            250
#define DYN_CCC_BOXTYPE_DLLCOMP_COARSECODE0_CH1_1          251
#define DYN_CCC_BOXTYPE_DLLCOMP_COARSECODE0_ECC            252
#define DYN_CCC_BOXTYPE_DLLCOMP_COARSECODE0_ECC_1          253
#define DYN_DQ_BOXTYPE_DLLCOMP_COARSECODE_1                254
#define DYN_DQ_BOXTYPE_DLLCOMP_COARSECODE_2                255
#define DYN_DUNIT_BOXTYPE_D_CR_BGF_CTL_6                   256
#define DYN_DUNIT_BOXTYPE_D_CR_DRP0_4                      257
#define DYN_DUNIT_BOXTYPE_D_CR_SCRAMCTRL                   258
#define DYN_CUNIT_BOXTYPE_MCHBAR_LO_0_0_0_PCI              259
#define DYN_P2SB_BOXTYPE_SBREG_BAR                         260
#define DYN_AUNIT_BOXTYPE_A_CR_SLICE_CHANNEL_HASH_0_0_0_MCHBAR 261
#define DYN_AUNIT_BOXTYPE_A_CR_SLICE_CHANNEL_HASH_0_0_0_MCHBAR_1 262
#define DYN_AUNIT_BOXTYPE_A_CR_SLICE_CHANNEL_HASH_0_0_0_MCHBAR_2 263
#define DYN_AUNIT_BOXTYPE_A_CR_ASYM_MEM_REGION0_0_0_0_MCHBAR 264
#define DYN_AUNIT_BOXTYPE_A_CR_ASYM_MEM_REGION1_0_0_0_MCHBAR 265
#define DYN_AUNIT_BOXTYPE_A_CR_ASYM_2WAY_MEM_REGION_0_0_0_MCHBAR 266
#define DYN_BUNIT_BOXTYPE_B_CR_ASYM_MEM_REGION0_0_0_0_MCHBAR 267
#define DYN_BUNIT_BOXTYPE_B_CR_ASYM_MEM_REGION1_0_0_0_MCHBAR 268
#define DYN_BUNIT_BOXTYPE_B_CR_ASYM_2WAY_MEM_REGION_0_0_0_MCHBAR 269
#define DYN_DQ_BOXTYPE_RXPBDBLCTL0                         270
#define DYN_DQ_BOXTYPE_WRLVL                               271
#define DYN_CCC_BOXTYPE_WRLVL                              272
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL13_12                  273
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL02_12                  274
#define DYN_CCC_BOXTYPE_DIFFAMPCTL_13                      275
#define DYN_DUNIT_BOXTYPE_D_CR_DRAM_CMD                    276
#define DYN_CPGC_BOXTYPE_CPGC_ERR_CTL                      277
#define DYN_CPGC_BOXTYPE_CPGC_ERR_LNEN_HI                  278
#define DYN_CPGC_BOXTYPE_CPGC_DPAT_UNISEQ_0_               279
#define DYN_CPGC_BOXTYPE_CPGC2_BASE_REPEATS                280
#define DYN_CPGC_BOXTYPE_CPGC2_BLOCK_REPEATS               281
#define DYN_CPGC_BOXTYPE_CPGC_DPAT_XTRA_LFSR_CFG           282
#define DYN_CPGC_BOXTYPE_CPGC_DPAT_CFG                     283
#define DYN_CPGC_BOXTYPE_CPGC2_BASE_REPEATS_1              284
#define DYN_CPGC_BOXTYPE_CPGC2_BLOCK_REPEATS_1             285
#define DYN_DUNIT_BOXTYPE_D_CR_DRMC_4                      286
#define DYN_DUNIT_BOXTYPE_D_CR_DRMC_5                      287
#define DYN_DUNIT_BOXTYPE_D_CR_DRAM_CMD_1                  288
#define DYN_CPGC_BOXTYPE_CPGC_SEQ_BANK_L2P_MAPPING_A       289
#define DYN_CPGC_BOXTYPE_CPGC_SEQ_RANK_L2P_MAPPING         290
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFA_0_                 291
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFA_1_                 292
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFB_1_                 293
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFA_2_                 294
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFA_3_                 295
#define DYN_CPGC_BOXTYPE_CPGC2_ADDRESS_SIZE                296
#define DYN_CPGC_BOXTYPE_CPGC2_ADDRESS_CONTROL             297
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFA_0__1               298
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFA_1__1               299
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFA_2__1               300
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFA_3__1               301
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFA_4_                 302
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFA_5_                 303
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFA_6_                 304
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFA_7_                 305
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFB_0_                 306
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFB_1__1               307
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFB_2_                 308
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFB_3_                 309
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFB_4_                 310
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFB_5_                 311
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFB_6_                 312
#define DYN_CPGC_BOXTYPE_CPGC_CADB_BUFB_7_                 313
#define DYN_CPGC_BOXTYPE_CPGC_DPAT_UNISEQ_0__1             314
#define DYN_CPGC_BOXTYPE_CPGC_DPAT_UNISEQ_1_               315
#define DYN_CPGC_BOXTYPE_CPGC_CADB_CFG                     316
#define DYN_CPGC_BOXTYPE_CPGC_CADB_UNISEQ0_PBUF            317
#define DYN_CPGC_BOXTYPE_CPGC_CADB_UNISEQ1_PBUF            318
#define DYN_CPGC_BOXTYPE_CPGC_CADB_UNISEQ2_PBUF            319
#define DYN_CPGC_BOXTYPE_CPGC2_ALGORITHM_INSTRUCTION_0_    320
#define DYN_CPGC_BOXTYPE_CPGC_DPAT_UNISEQ_0__2             321
#define DYN_CPGC_BOXTYPE_CPGC_DPAT_UNISEQ_1__1             322
#define DYN_CPGC_BOXTYPE_CPGC_DPAT_CFG_1                   323
#define DYN_DQ_BOXTYPE_U32_WRDQCTL                         324
#define DYN_DQ_BOXTYPE_U32_WRDQSCTL_CC                     325
#define DYN_DQ_BOXTYPE_U32_WRDQSCTL_BL                     326
#define DYN_CCC_BOXTYPE_U32_WRDQCTL                        327
#define DYN_CCC_BOXTYPE_U32_WRDQSCTL                       328
#define DYN_CPGC_BOXTYPE_CPGC_DPAT_INV_DC_MASK_LO          329
#define DYN_DUNIT_BOXTYPE_D_CR_DRMC_6                      330
#define DYN_DQ_BOXTYPE_U32_WKPUPPDNCTL                     331
#define DYN_CCC_BOXTYPE_U32_WKPUPPDNCTL                    332
#define DYN_DQ_BOXTYPE_RXODTCTL_BL13_7                     333
#define DYN_CCC_BOXTYPE_RXODTSEGCTL_7                      334
#define DYN_DQ_BOXTYPE_RXODTCTL_DQ_7                       335
#define DYN_DQ_BOXTYPE_WKPUPPDNCTL                         336
#define DYN_DPLVUG_BOXTYPE_DPIC_GRCOMP_VREF_0              337
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR1_4              338
#define DYN_DQDPLVUG_BOXTYPE_DPIC_LRCOMP_OVR1_4            339
#define DYN_DQDPLVUG_BOXTYPE_DPIC_LRCOMP_OVR1_5            340
#define DYN_DQDPLVUG_BOXTYPE_DPIC_LRCOMP_OVR1_6            341
#define DYN_DQDPLVUG_BOXTYPE_DPIC_LRCOMP_OVR1_7            342
#define DYN_DQDPLVUG_BOXTYPE_DPIC_LRCOMP_OVR1_8            343
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR1_5              344
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR2_4              345
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_OVR3_4              346
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_PUPDOVR             347
#define DYN_DQDPLVUG_BOXTYPE_DPIC_LRCOMP_PUPDOVR           348
#define DYN_DPLVUG_BOXTYPE_DPIC_LRCOMP_PUPDOVR_1           349
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL02_7                  350
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL02_13                  351
#define DYN_DQ_BOXTYPE_RXODTSEGCTL_BL13_7                  352
#define DYN_DQ_BOXTYPE_DIFFAMPCTL_BL13_13                  353
#define DYN_CCC_BOXTYPE_DIFFAMPCTL_14                      354
#define DYN_DPLVUG_BOXTYPE_DPIC_GRCOMP_VREF_0_1            355
#define DYN_DPLVUG_BOXTYPE_DPIC_GRCOMP_VREF_1              356
#define DYN_DQ_BOXTYPE_RXODTCTL_DQ_8                       357
#define DYN_CCC_BOXTYPE_RXODTSEGCTL_8                      358
#define DYN_CCC_BOXTYPE_RXODTCTL_7                         359
#define DYN_DQ_BOXTYPE_RXODTCTL_BL13_8                     360
#define DYN_DQ_BOXTYPE_VREFCTL0                            361
#define DYN_CCC_BOXTYPE_VREFCTL2                           362
#define DYN_DUNIT_BOXTYPE_D_CR_DRMC_7                      363
#define DYN_DUNIT_BOXTYPE_D_CR_DQS_RETRAINING_CTL_1        364
#define DYN_DQDPLVUG_BOXTYPE_PTCTL0_6                      365
#define DYN_DUNIT_BOXTYPE_D_CR_TQCTL_2                     366
#define DYN_DUNIT_BOXTYPE_D_CR_DCAL                        367
#define DYN_DUNIT_BOXTYPE_D_CR_DRFC_2                      368
#define DYN_DUNIT_BOXTYPE_D_CR_DPMC0                       369
#define DYN_DUNIT_BOXTYPE_D_CR_DPMC1_1                     370
#define DYN_DUNIT_BOXTYPE_D_CR_DQS_RETRAINING_CTL_2        371
#define DYN_DUNIT_BOXTYPE_D_CR_DTR4A_1                     372
#define DYN_DUNIT_BOXTYPE_D_CR_DTR6A_1                     373
#define DYN_DQDPLVUG_BOXTYPE_PTCTL0_7                      374
#define DYN_CPGC_BOXTYPE_CPGC_ERR_CTL_1                    375
#define DYN_DQ_BOXTYPE_TXPBDCTL1                           376
#define DYN_CCC_BOXTYPE_TXPBDCTL1                          377
#define DYN_CCC_BOXTYPE_ECC_TXPBDCTL1                      378
#define DYN_CPGC_BOXTYPE_CPGC2_ADDRESS_SIZE_1              379
//
// All dynamic field names. These must be populated with real values prior to executing MmrcEntry().
//
#ifdef MEM_SV_HOOKS
#define DDR3L_REFRESH_RATE_VALUE                           0
#define FM_CH3                                             1
#define FM_CH2                                             2
#define FM_CH1                                             3
#define FM_CH0                                             4
#define PUNIT_REQ_TYPE                                     5
#define PUNIT_REQ_DATA                                     6
#define TEMP                                               7
#define str_m                                              8
#define BXT_P_POST_A0                                      9
#define BXT_P_A0                                           10
#define RSVD                                               11
#define WRPREAM0EN                                         12
#define WL                                                 13
#define pream                                              14
#define RL                                                 15
#define CH1_CLK_DISABLE                                    16
#define CH1_CLK_ENABLE                                     17
#define DQSDRVENPREAM0                                     18
#define RANK1_ENABLED                                      19
#define ECCEN_BXT_P_POST_A0                                20
#define INVPH0TO180_DDR3_VAL                               21
#define SLICE_0_MASTER                                     22
#define SLICE_1_MASTER                                     23
#define GCOMP_CH_EN                                        24
#define ECCEN                                              25
#define TEMPVAR                                            26
#define SS_TEMP_VAR_UPGRP0                                 27
#define SS_TEMP_VAR_DNGRP0                                 28
#define SS_TEMP_VAR_UPGRP1                                 29
#define SS_TEMP_VAR_DNGRP1                                 30
#define SS_TEMP_VAR_UPGRP2                                 31
#define SS_TEMP_VAR_DNGRP2                                 32
#define SS_TEMP_VAR_UPGRP3                                 33
#define SS_TEMP_VAR_DNGRP3                                 34
#define SS_TEMP_VAR_UPGRP4                                 35
#define SS_TEMP_VAR_DNGRP4                                 36
#define SS_TEMP_VAR_UPGRP5                                 37
#define SS_TEMP_VAR_DNGRP5                                 38
#define DRAMDEVICE_PR                                      39
#define ADDRDEC                                            40
#define CASWIZZLE                                          41
#define TCKSRX                                             42
#define TXSDLL                                             43
#define TXSR                                               44
#define TRCD                                               45
#define TRPPB                                              46
#define DDEN                                               47
#define DWID                                               48
#define RANK0_ENABLED                                      49
#define TXP                                                50
#define TZQCL                                              51
#define TZQCS                                              52
#define TZQLAT                                             53
#define NRFCAB                                             54
#define TCKE                                               55
#define NREFI                                              56
#define TRTP                                               57
#define TWTP                                               58
#define TCWL                                               59
#define TCCDMW                                             60
#define TFAW                                               61
#define TWRDR                                              62
#define TRWDR                                              63
#define TWWDR                                              64
#define TRRDR                                              65
#define TRRD                                               66
#define TDERATE_INC                                        67
#define TWWSR                                              68
#define TRRSR                                              69
#define TWRSR                                              70
#define TRWSR                                              71
#define TCKCKEL                                            72
#define MNTDLY                                             73
#define TPSTMRRBLK                                         74
#define TPREMRBLK                                          75
#define TRPAB                                              76
#define TPSTMRWBLK                                         77
#define TWRPDEN                                            78
#define TRDPDEN                                            79
#define TRAS                                               80
#define TCKESR                                             81
#define LPMDRES                                            82
#define TLPCKDLY                                           83
#define TCKLPDLY                                           84
#define PWDDLY                                             85
#define SSKPD0                                             86
#define SSKPD1                                             87
#define BONUS0                                             88
#define BONUS1                                             89
#define MR4_BIT2_SEL                                       90
#define MR4_BIT1_SEL                                       91
#define MR4_BIT0_SEL                                       92
#define MR4_BYTE_SEL                                       93
#define MR4_BIT0_SEL2                                      94
#define MR4_BIT1_SEL2                                      95
#define MR4_BIT2_SEL2                                      96
#define MR4_BYTE_SEL2                                      97
#define WRODTSTOP                                          98
#define RDODTSTART                                         99
#define R0WRODTCTL                                         100
#define R1WRODTCTL                                         101
#define R0RDODTCTL                                         102
#define R1RDODTCTL                                         103
#define CKEVAL_VAR                                         104
#define SPIDCMDCLK_RATIO                                   105
#define SPIDDATA_RATIO_WIO2                                106
#define MINREFRATE                                         107
#define REFWMPNC                                           108
#define REFWMHI                                            109
#define BAHEN                                              110
#define RSIEN                                              111
#define CMDTRIST                                           112
#define PCLSTO                                             113
#define BLKRDBF_ADD_RDDATA                                 114
#define BLKRDBF                                            115
#define SPID_EARLY_RDDATA_VALID                            116
#define BGF_EARLY_RDDATA_VALID                             117
#define PATTERN_CMDSPID_TO_SABY2_TSVS                      118
#define PATTERN_SABY2_TO_CMDSPID_TSVS                      119
#define INIT_CMDSPID_TO_SABY2_TSVS                         120
#define INIT_SABY2_TO_CMDSPID_TSVS                         121
#define PATTERN_DATASPID_TO_SABY2_TSVS                     122
#define PATTERN_SABY2_TO_DATASPID_TSVS                     123
#define INIT_DATASPID_TO_SABY2_TSVS                        124
#define INIT_SABY2_TO_DATASPID_TSVS                        125
#define TQPOLLPER                                          126
#define SRTEN                                              127
#define MR_VALUE                                           128
#define SACLKBY2_RATIO                                     129
#define BXT_A0_WA                                          130
#define DQS_RETRAIN_INT                                    131
#define DQS_OSC_RT                                         132
#define PRTEN                                              133
#define MUX_MAX                                            134
#define MUX_MIN                                            135
#define FINE_MAX                                           136
#define FINE_MIN                                           137
#define COARSE_MAX                                         138
#define COARSE_MIN                                         139
#define FINE_SOFT_MAX                                      140
#define FINE_SOFT_MIN                                      141
#define SS_TEMP_VAR                                        142
#define WEAK_ODT_CONFIG                                    143
#define BGF_RUN_SAVE                                       144
#define FUSESTAT                                           145
#define SCRAMBLER_KEY                                      146
#define MCHBAR                                             147
#define P2SBBAR                                            148
#define ECBASE_LO                                          149
#define ECBASE_EN                                          150
#define ECBASE_HI                                          151
#define SYM_SLICE1_CHANNEL_ENABLED                         152
#define SYM_SLICE0_CHANNEL_ENABLED                         153
#define SLICE_1_DISABLED                                   154
#define SLICE_0_MEM_DISABLED                               155
#define CHANNEL_HASH_MASK                                  156
#define AUNIT_INTERLEAVED_MODE                             157
#define SLICE_HASH_MASK                                    158
#define SLICE0_ASYM_ENABLE                                 159
#define SLICE0_ASYM_CHANNEL_SELECT                         160
#define SLICE0_ASYM_LIMIT                                  161
#define SLICE0_ASYM_BASE                                   162
#define SLICE1_ASYM_ENABLE                                 163
#define SLICE1_ASYM_CHANNEL_SELECT                         164
#define SLICE1_ASYM_LIMIT                                  165
#define SLICE1_ASYM_BASE                                   166
#define ASYM_2WAY_INTERLEAVE_ENABLE                        167
#define ASYM_2WAY_LIMIT                                    168
#define ASYM_2WAY_BASE                                     169
#define ASYM_2WAY_INTLV_MODE                               170
#define DDR_CONFIG_LIMITATION                              171
#define SABY2CLK                                           172
#define S0_Fixes0                                          173
#define CMD_RDPTROFFSET_ADJUST                             174
#define WRLVLMODEVAR                                       175
#define CC_DQS_OVR_VAL                                     176
#define CC_DQS_OVR_SEL                                     177
#define CC_DQDM_OVR_VAL                                    178
#define CC_DQDM_OVR_SEL                                    179
#define BL_DQS_OVR_VAL                                     180
#define BL_DQS_OVR_SEL                                     181
#define BL_DQDM_OVR_VAL                                    182
#define BL_DQDM_OVR_SEL                                    183
#define DQDM_OVR_SEL_ECC                                   184
#define DQS_OVR_SEL_ECC                                    185
#define DQDM_OVR_ECC                                       186
#define DQS_OVR_ECC                                        187
#define DRAM_CMD_BL                                        188
#define RANK                                               189
#define RDDCMD                                             190
#define REG_DATA                                           191
#define ERROR_STATUS                                       192
#define CHUNK_ERR_MASK                                     193
#define CHUNK_ERR_MASK_LP                                  194
#define BYTEGRP_ERR_STAT                                   195
#define CHUNK_ERR_STAT                                     196
#define LANE_ERR_STAT_LO                                   197
#define LANE_ERR_STAT_HI                                   198
#define ECC_ERR_STAT                                       199
#define ECC_LANE_ERR_STAT                                  200
#define ERR_COUNT0                                         201
#define ERR_COUNT1                                         202
#define ERR_COUNT2                                         203
#define ERR_COUNT3                                         204
#define ERR_COUNT4                                         205
#define ERR_COUNT5                                         206
#define ERR_COUNT6                                         207
#define ERR_COUNT7                                         208
#define ERR_COUNT8                                         209
#define NUM_BURSTS_EXP                                     210
#define NUM_LOOPS_EXP                                      211
#define LANE_ROTATE_RATE                                   212
#define RELOAD_LFSR_SEED_RATE                              213
#define SAVE_LFSR_SEED_RATE                                214
#define RANK_INDEX                                         215
#define TARGET_BANK                                        216
#define TARGET_RANK                                        217
#define ROW_COL_ADDR                                       218
#define NUM_COLS                                           219
#define NUM_ROWS                                           220
#define ADD_ROTATE_RPT                                     221
#define CADB_BUFA0_BANK                                    222
#define CADB_BUFA0_ROW_COL                                 223
#define CADB_BUFA1_BANK                                    224
#define CADB_BUFA1_ROW_COL                                 225
#define CADB_BUFA2_BANK                                    226
#define CADB_BUFA2_ROW_COL                                 227
#define CADB_BUFA3_BANK                                    228
#define CADB_BUFA3_ROW_COL                                 229
#define CADB_BUFA4_BANK                                    230
#define CADB_BUFA4_ROW_COL                                 231
#define CADB_BUFA5_BANK                                    232
#define CADB_BUFA5_ROW_COL                                 233
#define CADB_BUFA6_BANK                                    234
#define CADB_BUFA6_ROW_COL                                 235
#define CADB_BUFA7_BANK                                    236
#define CADB_BUFA7_ROW_COL                                 237
#define CADB_BUFB0_CMD                                     238
#define CADB_BUFB1_CMD                                     239
#define CADB_BUFB2_CMD                                     240
#define CADB_BUFB3_CMD                                     241
#define CADB_BUFB4_CMD                                     242
#define CADB_BUFB5_CMD                                     243
#define CADB_BUFB6_CMD                                     244
#define CADB_BUFB7_CMD                                     245
#define AGG_PATTERN                                        246
#define VIC_PATTERN                                        247
#define UNIMODE                                            248
#define PATTERN0                                           249
#define PATTERN1                                           250
#define PATTERN2                                           251
#define INSTR_LAST                                         252
#define INSTR_POINTER                                      253
#define ORIG_WRDQCTL                                       254
#define ORIG_WRDQSCTL_CC                                   255
#define ORIG_WRDQSCTL_BB                                   256
#define ORIG_CC_WRDQCTL                                    257
#define ORIG_CC_WRDQSCTL                                   258
#define CAVREF                                             259
#define ORIG_DQ_WKCTL                                      260
#define ORIG_CC_WKCTL                                      261
#define CC_DQSRXODTENOVRVAL                                262
#define CC_DQSRXODTENOVRSEL                                263
#define CC_RXODTENOVRVAL                                   264
#define CC_RXODTENOVRSEL                                   265
#define RXODTSEGOVRVAL_ecc                                 266
#define RXODTSEGOVRSEL_ecc                                 267
#define BL_DQSRXODTENOVRVAL                                268
#define BL_DQSRXODTENOVRSEL                                269
#define BL_RXODTENOVRVAL                                   270
#define BL_RXODTENOVRSEL                                   271
#define LVL_CC_WEAKPUPSTATIC                               272
#define LVL_CC_WEAKPUP                                     273
#define LVL_CC_WEAKPDNSTATIC                               274
#define LVL_CC_WEAKPDN                                     275
#define LVL_BL_WEAKPUPSTATIC                               276
#define LVL_BL_WEAKPUP                                     277
#define LVL_BL_WEAKPDNSTATIC                               278
#define LVL_BL_WEAKPDN                                     279
#define RCOMP_Up_GRP0_dq0                                  280
#define RCOMP_Dn_GRP0_dq0                                  281
#define RCOMP_Up_GRP1_dq0                                  282
#define RCOMP_Dn_GRP1_dq0                                  283
#define RCOMP_Up_GRP0_dq1                                  284
#define RCOMP_Dn_GRP0_dq1                                  285
#define RCOMP_Up_GRP1_dq1                                  286
#define RCOMP_Dn_GRP1_dq1                                  287
#define RCOMP_Up_GRP0_dq2                                  288
#define RCOMP_Dn_GRP0_dq2                                  289
#define RCOMP_Up_GRP1_dq2                                  290
#define RCOMP_Dn_GRP1_dq2                                  291
#define RCOMP_Up_GRP0_dq3                                  292
#define RCOMP_Dn_GRP0_dq3                                  293
#define RCOMP_Up_GRP1_dq3                                  294
#define RCOMP_Dn_GRP1_dq3                                  295
#define RCOMP_Up_GRP0                                      296
#define RCOMP_Dn_GRP0                                      297
#define RCOMP_Up_GRP1                                      298
#define RCOMP_Dn_GRP1                                      299
#define RCOMP_Up_GRP2                                      300
#define RCOMP_Dn_GRP2                                      301
#define RCOMP_Up_GRP3                                      302
#define RCOMP_Dn_GRP3                                      303
#define RCOMP_Up_GRP4                                      304
#define RCOMP_Dn_GRP4                                      305
#define RCOMP_Up_GRP5                                      306
#define RCOMP_Dn_GRP5                                      307
#define RCOMP_OVR_Up_En                                    308
#define RCOMP_OVR_Dn_En                                    309
#define RCOMP_OVR_Up_En_dq                                 310
#define RCOMP_OVR_Dn_En_dq                                 311
#define RCOMP_Seg_Ovr_Val_bl                               312
#define RCOMP_Seg_Ovr_En_bl                                313
#define DIFF_Ovr_Val_bl                                    314
#define DIFF_Ovr_Val_sel_bl                                315
#define comp_vref_0                                        316
#define comp_vref_1                                        317
#define comp_vref_2                                        318
#define comp_vref_3                                        319
#define comp_vref_4                                        320
#define comp_vref_5                                        321
#define RX_ODTEN_OVR_SEL_bl                                322
#define RX_ODTEN_OVR_VAL_bl                                323
#define ECC_RX_ODTEN_OVR_SEL_bl                            324
#define ECC_RX_ODTEN_OVR_VAL_bl                            325
#define RXBLVREFCTL                                        326
#define VOC_LDO_ENABLE                                     327
#define VOC_RCOMP_PUP                                      328
#define VOC_RCOMP_PDN                                      329
#define TQPOLLEN_SAVE                                      330
#define SRXZQC_SAVE                                        331
#define ZQDIS_SAVE                                         332
#define OREFDIS_SAVE                                       333
#define DYNSREN_SAVE                                       334
#define DISPWRDN_SAVE                                      335
#define DQS_RETAIN_EN_SAVE                                 336
#define RDCMD2RDVLD                                        337
#define PTLDCODE                                           338
#define MR0_0                                              339
#define MR1_0                                              340
#define MR2_0                                              341
#define MR0_1                                              342
#define MR1_1                                              343
#define MR2_1                                              344
#define DYNVAR_MAX                                         345
#else
#define DDR3L_REFRESH_RATE_VALUE                           0
#define FM_CH3                                             1
#define FM_CH2                                             2
#define FM_CH1                                             3
#define FM_CH0                                             4
#define PUNIT_REQ_TYPE                                     5
#define PUNIT_REQ_DATA                                     6
#define TEMP                                               7
#define str_m                                              8
#define BXT_P_POST_A0                                      9
#define BXT_P_A0                                           10
#define RSVD                                               11
#define WRPREAM0EN                                         12
#define WL                                                 13
#define pream                                              14
#define RL                                                 15
#define CH1_CLK_DISABLE                                    16
#define CH1_CLK_ENABLE                                     17
#define DQSDRVENPREAM0                                     18
#define RANK1_ENABLED                                      19
#define ECCEN_BXT_P_POST_A0                                20
#define INVPH0TO180_DDR3_VAL                               21
#define SLICE_0_MASTER                                     22
#define SLICE_1_MASTER                                     23
#define GCOMP_CH_EN                                        24
#define ECCEN                                              25
#define TEMPVAR                                            26
#define SS_TEMP_VAR_UPGRP0                                 27
#define SS_TEMP_VAR_DNGRP0                                 28
#define SS_TEMP_VAR_UPGRP1                                 29
#define SS_TEMP_VAR_DNGRP1                                 30
#define SS_TEMP_VAR_UPGRP2                                 31
#define SS_TEMP_VAR_DNGRP2                                 32
#define SS_TEMP_VAR_UPGRP3                                 33
#define SS_TEMP_VAR_DNGRP3                                 34
#define SS_TEMP_VAR_UPGRP4                                 35
#define SS_TEMP_VAR_DNGRP4                                 36
#define SS_TEMP_VAR_UPGRP5                                 37
#define SS_TEMP_VAR_DNGRP5                                 38
#define DRAMDEVICE_PR                                      39
#define ADDRDEC                                            40
#define CASWIZZLE                                          41
#define TCKSRX                                             42
#define TXSDLL                                             43
#define TXSR                                               44
#define TRCD                                               45
#define TRPPB                                              46
#define DDEN                                               47
#define DWID                                               48
#define RANK0_ENABLED                                      49
#define TXP                                                50
#define TZQCL                                              51
#define TZQCS                                              52
#define TZQLAT                                             53
#define NRFCAB                                             54
#define TCKE                                               55
#define NREFI                                              56
#define TRTP                                               57
#define TWTP                                               58
#define TCWL                                               59
#define TCCDMW                                             60
#define TFAW                                               61
#define TWRDR                                              62
#define TRWDR                                              63
#define TWWDR                                              64
#define TRRDR                                              65
#define TRRD                                               66
#define TDERATE_INC                                        67
#define TWWSR                                              68
#define TRRSR                                              69
#define TWRSR                                              70
#define TRWSR                                              71
#define TCKCKEL                                            72
#define MNTDLY                                             73
#define TPSTMRRBLK                                         74
#define TPREMRBLK                                          75
#define TRPAB                                              76
#define TPSTMRWBLK                                         77
#define TWRPDEN                                            78
#define TRDPDEN                                            79
#define TRAS                                               80
#define TCKESR                                             81
#define LPMDRES                                            82
#define TLPCKDLY                                           83
#define TCKLPDLY                                           84
#define PWDDLY                                             85
#define SSKPD0                                             86
#define SSKPD1                                             87
#define BONUS0                                             88
#define BONUS1                                             89
#define MR4_BIT2_SEL                                       90
#define MR4_BIT1_SEL                                       91
#define MR4_BIT0_SEL                                       92
#define MR4_BYTE_SEL                                       93
#define MR4_BIT0_SEL2                                      94
#define MR4_BIT1_SEL2                                      95
#define MR4_BIT2_SEL2                                      96
#define MR4_BYTE_SEL2                                      97
#define WRODTSTOP                                          98
#define RDODTSTART                                         99
#define R0WRODTCTL                                         100
#define R1WRODTCTL                                         101
#define R0RDODTCTL                                         102
#define R1RDODTCTL                                         103
#define CKEVAL_VAR                                         104
#define SPIDCMDCLK_RATIO                                   105
#define SPIDDATA_RATIO_WIO2                                106
#define MINREFRATE                                         107
#define REFWMPNC                                           108
#define REFWMHI                                            109
#define BAHEN                                              110
#define RSIEN                                              111
#define CMDTRIST                                           112
#define PCLSTO                                             113
#define BLKRDBF_ADD_RDDATA                                 114
#define BLKRDBF                                            115
#define SPID_EARLY_RDDATA_VALID                            116
#define BGF_EARLY_RDDATA_VALID                             117
#define PATTERN_CMDSPID_TO_SABY2_TSVS                      118
#define PATTERN_SABY2_TO_CMDSPID_TSVS                      119
#define INIT_CMDSPID_TO_SABY2_TSVS                         120
#define INIT_SABY2_TO_CMDSPID_TSVS                         121
#define PATTERN_DATASPID_TO_SABY2_TSVS                     122
#define PATTERN_SABY2_TO_DATASPID_TSVS                     123
#define INIT_DATASPID_TO_SABY2_TSVS                        124
#define INIT_SABY2_TO_DATASPID_TSVS                        125
#define TQPOLLPER                                          126
#define SRTEN                                              127
#define MR_VALUE                                           128
#define SACLKBY2_RATIO                                     129
#define BXT_A0_WA                                          130
#define DQS_RETRAIN_INT                                    131
#define DQS_OSC_RT                                         132
#define PRTEN                                              133
#define MUX_MAX                                            134
#define MUX_MIN                                            135
#define FINE_MAX                                           136
#define FINE_MIN                                           137
#define COARSE_MAX                                         138
#define COARSE_MIN                                         139
#define FINE_SOFT_MAX                                      140
#define FINE_SOFT_MIN                                      141
#define SS_TEMP_VAR                                        142
#define WEAK_ODT_CONFIG                                    143
#define BGF_RUN_SAVE                                       144
#define FUSESTAT                                           145
#define SCRAMBLER_KEY                                      146
#define MCHBAR                                             147
#define P2SBBAR                                            148
#define ECBASE_LO                                          149
#define ECBASE_EN                                          150
#define ECBASE_HI                                          151
#define SYM_SLICE1_CHANNEL_ENABLED                         152
#define SYM_SLICE0_CHANNEL_ENABLED                         153
#define SLICE_1_DISABLED                                   154
#define SLICE_0_MEM_DISABLED                               155
#define CHANNEL_HASH_MASK                                  156
#define AUNIT_INTERLEAVED_MODE                             157
#define SLICE_HASH_MASK                                    158
#define SLICE0_ASYM_ENABLE                                 159
#define SLICE0_ASYM_CHANNEL_SELECT                         160
#define SLICE0_ASYM_LIMIT                                  161
#define SLICE0_ASYM_BASE                                   162
#define SLICE1_ASYM_ENABLE                                 163
#define SLICE1_ASYM_CHANNEL_SELECT                         164
#define SLICE1_ASYM_LIMIT                                  165
#define SLICE1_ASYM_BASE                                   166
#define ASYM_2WAY_INTERLEAVE_ENABLE                        167
#define ASYM_2WAY_LIMIT                                    168
#define ASYM_2WAY_BASE                                     169
#define ASYM_2WAY_INTLV_MODE                               170
#define DDR_CONFIG_LIMITATION                              171
#define SABY2CLK                                           172
#define S0_Fixes0                                          173
#define CMD_RDPTROFFSET_ADJUST                             174
#define WRLVLMODEVAR                                       175
#define CC_DQS_OVR_VAL                                     176
#define CC_DQS_OVR_SEL                                     177
#define CC_DQDM_OVR_VAL                                    178
#define CC_DQDM_OVR_SEL                                    179
#define BL_DQS_OVR_VAL                                     180
#define BL_DQS_OVR_SEL                                     181
#define BL_DQDM_OVR_VAL                                    182
#define BL_DQDM_OVR_SEL                                    183
#define DQDM_OVR_SEL_ECC                                   184
#define DQS_OVR_SEL_ECC                                    185
#define DQDM_OVR_ECC                                       186
#define DQS_OVR_ECC                                        187
#define DRAM_CMD_BL                                        188
#define RANK                                               189
#define RDDCMD                                             190
#define REG_DATA                                           191
#define ERROR_STATUS                                       192
#define CHUNK_ERR_MASK                                     193
#define CHUNK_ERR_MASK_LP                                  194
#define BYTEGRP_ERR_STAT                                   195
#define CHUNK_ERR_STAT                                     196
#define LANE_ERR_STAT_LO                                   197
#define LANE_ERR_STAT_HI                                   198
#define ECC_ERR_STAT                                       199
#define ECC_LANE_ERR_STAT                                  200
#define ERR_COUNT0                                         201
#define ERR_COUNT1                                         202
#define ERR_COUNT2                                         203
#define ERR_COUNT3                                         204
#define ERR_COUNT4                                         205
#define ERR_COUNT5                                         206
#define ERR_COUNT6                                         207
#define ERR_COUNT7                                         208
#define ERR_COUNT8                                         209
#define NUM_BURSTS_EXP                                     210
#define NUM_LOOPS_EXP                                      211
#define LANE_ROTATE_RATE                                   212
#define RELOAD_LFSR_SEED_RATE                              213
#define SAVE_LFSR_SEED_RATE                                214
#define RANK_INDEX                                         215
#define TARGET_BANK                                        216
#define TARGET_RANK                                        217
#define ROW_COL_ADDR                                       218
#define NUM_COLS                                           219
#define NUM_ROWS                                           220
#define ADD_ROTATE_RPT                                     221
#define CADB_BUFA0_BANK                                    222
#define CADB_BUFA0_ROW_COL                                 223
#define CADB_BUFA1_BANK                                    224
#define CADB_BUFA1_ROW_COL                                 225
#define CADB_BUFA2_BANK                                    226
#define CADB_BUFA2_ROW_COL                                 227
#define CADB_BUFA3_BANK                                    228
#define CADB_BUFA3_ROW_COL                                 229
#define CADB_BUFA4_BANK                                    230
#define CADB_BUFA4_ROW_COL                                 231
#define CADB_BUFA5_BANK                                    232
#define CADB_BUFA5_ROW_COL                                 233
#define CADB_BUFA6_BANK                                    234
#define CADB_BUFA6_ROW_COL                                 235
#define CADB_BUFA7_BANK                                    236
#define CADB_BUFA7_ROW_COL                                 237
#define CADB_BUFB0_CMD                                     238
#define CADB_BUFB1_CMD                                     239
#define CADB_BUFB2_CMD                                     240
#define CADB_BUFB3_CMD                                     241
#define CADB_BUFB4_CMD                                     242
#define CADB_BUFB5_CMD                                     243
#define CADB_BUFB6_CMD                                     244
#define CADB_BUFB7_CMD                                     245
#define AGG_PATTERN                                        246
#define VIC_PATTERN                                        247
#define UNIMODE                                            248
#define PATTERN0                                           249
#define PATTERN1                                           250
#define PATTERN2                                           251
#define INSTR_LAST                                         252
#define INSTR_POINTER                                      253
#define ORIG_WRDQCTL                                       254
#define ORIG_WRDQSCTL_CC                                   255
#define ORIG_WRDQSCTL_BB                                   256
#define ORIG_CC_WRDQCTL                                    257
#define ORIG_CC_WRDQSCTL                                   258
#define CAVREF                                             259
#define ORIG_DQ_WKCTL                                      260
#define ORIG_CC_WKCTL                                      261
#define CC_DQSRXODTENOVRVAL                                262
#define CC_DQSRXODTENOVRSEL                                263
#define CC_RXODTENOVRVAL                                   264
#define CC_RXODTENOVRSEL                                   265
#define RXODTSEGOVRVAL_ecc                                 266
#define RXODTSEGOVRSEL_ecc                                 267
#define BL_DQSRXODTENOVRVAL                                268
#define BL_DQSRXODTENOVRSEL                                269
#define BL_RXODTENOVRVAL                                   270
#define BL_RXODTENOVRSEL                                   271
#define LVL_CC_WEAKPUPSTATIC                               272
#define LVL_CC_WEAKPUP                                     273
#define LVL_CC_WEAKPDNSTATIC                               274
#define LVL_CC_WEAKPDN                                     275
#define LVL_BL_WEAKPUPSTATIC                               276
#define LVL_BL_WEAKPUP                                     277
#define LVL_BL_WEAKPDNSTATIC                               278
#define LVL_BL_WEAKPDN                                     279
#define RCOMP_Up_GRP0_dq0                                  280
#define RCOMP_Dn_GRP0_dq0                                  281
#define RCOMP_Up_GRP1_dq0                                  282
#define RCOMP_Dn_GRP1_dq0                                  283
#define RCOMP_Up_GRP0_dq1                                  284
#define RCOMP_Dn_GRP0_dq1                                  285
#define RCOMP_Up_GRP1_dq1                                  286
#define RCOMP_Dn_GRP1_dq1                                  287
#define RCOMP_Up_GRP0_dq2                                  288
#define RCOMP_Dn_GRP0_dq2                                  289
#define RCOMP_Up_GRP1_dq2                                  290
#define RCOMP_Dn_GRP1_dq2                                  291
#define RCOMP_Up_GRP0_dq3                                  292
#define RCOMP_Dn_GRP0_dq3                                  293
#define RCOMP_Up_GRP1_dq3                                  294
#define RCOMP_Dn_GRP1_dq3                                  295
#define RCOMP_Up_GRP0                                      296
#define RCOMP_Dn_GRP0                                      297
#define RCOMP_Up_GRP1                                      298
#define RCOMP_Dn_GRP1                                      299
#define RCOMP_Up_GRP2                                      300
#define RCOMP_Dn_GRP2                                      301
#define RCOMP_Up_GRP3                                      302
#define RCOMP_Dn_GRP3                                      303
#define RCOMP_Up_GRP4                                      304
#define RCOMP_Dn_GRP4                                      305
#define RCOMP_Up_GRP5                                      306
#define RCOMP_Dn_GRP5                                      307
#define RCOMP_OVR_Up_En                                    308
#define RCOMP_OVR_Dn_En                                    309
#define RCOMP_OVR_Up_En_dq                                 310
#define RCOMP_OVR_Dn_En_dq                                 311
#define RCOMP_Seg_Ovr_Val_bl                               312
#define RCOMP_Seg_Ovr_En_bl                                313
#define DIFF_Ovr_Val_bl                                    314
#define DIFF_Ovr_Val_sel_bl                                315
#define comp_vref_0                                        316
#define comp_vref_1                                        317
#define comp_vref_2                                        318
#define comp_vref_3                                        319
#define comp_vref_4                                        320
#define comp_vref_5                                        321
#define RX_ODTEN_OVR_SEL_bl                                322
#define RX_ODTEN_OVR_VAL_bl                                323
#define ECC_RX_ODTEN_OVR_SEL_bl                            324
#define ECC_RX_ODTEN_OVR_VAL_bl                            325
#define RXBLVREFCTL                                        326
#define VOC_LDO_ENABLE                                     327
#define VOC_RCOMP_PUP                                      328
#define VOC_RCOMP_PDN                                      329
#define TQPOLLEN_SAVE                                      330
#define SRXZQC_SAVE                                        331
#define ZQDIS_SAVE                                         332
#define OREFDIS_SAVE                                       333
#define DYNSREN_SAVE                                       334
#define DISPWRDN_SAVE                                      335
#define DQS_RETAIN_EN_SAVE                                 336
#define RDCMD2RDVLD                                        337
#define PTLDCODE                                           338
#define MR0_0                                              339
#define MR1_0                                              340
#define MR2_0                                              341
#define MR0_1                                              342
#define MR1_1                                              343
#define MR2_1                                              344
#define DYNVAR_MAX                                         345
#endif // MEM_SV_HOOKS

#include "DQ_BOXTYPE.h"
#include "DUNIT_BOXTYPE.h"
#include "CCC_BOXTYPE.h"
#include "DQDPIC_BOXTYPE.h"
#include "DPIC_BOXTYPE.h"
#include "DQDPLVUG_BOXTYPE.h"
#include "ADPLL_BOXTYPE.h"
#include "CPGC_BOXTYPE.h"
#include "LDO_BOXTYPE.h"
#include "DPLVUG_BOXTYPE.h"
#include "SAI_BOXTYPE.h"
#include "MLMC_BOXTYPE.h"
#include "P2SB_BOXTYPE.h"
#include "AUNIT_BOXTYPE.h"
#include "BUNIT_BOXTYPE.h"
#include "CUNIT_BOXTYPE.h"
#include "PUNIT_BOXTYPE.h"


#endif // _MMRCPROJECTDEFINITIONSGENERATED_H_
