/** @file
  File name:    PUNIT.h
  Input File:   BXTE_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in PUNIT.h, which is used for non-tool-generated
  data

  Includes register defines specific to a project.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2005 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

  @par Specification
**/
#ifndef _PUNIT_H_
#define _PUNIT_H_

#include "DataTypes.h"

#if USE_64_BIT_VARIABLES
#define UINTX UINT64
#else
#define UINTX UINT32
#endif

#define P_CR_THERMAL_MAILBOX_DATA0_0_0_0_MCHBAR_PUNIT_REG  0x00007000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field contains the data associated with specific commands.  This register
    // represents the lower 32b of the interface.
    //
    // Bits[31:0], RW/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_THERMAL_MAILBOX_DATA0_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_THERMAL_MAILBOX_DATA1_0_0_0_MCHBAR_PUNIT_REG  0x00007004
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field contains the data associated with specific commands.  This register
    // represents the upper 32b of the interface.
    //
    // Bits[31:0], RW/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_THERMAL_MAILBOX_DATA1_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_THERMAL_MAILBOX_INTERFACE_0_0_0_MCHBAR_PUNIT_REG 0x00007008
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field contains the SW request command or the PCODE response code, depending
    // on the setting of RUN_BUSY.  It is the command when RUN_BUSY=1 and response code
    // when RUN_BUSY=0
    //
    // Bits[7:0], RW/V, default = 0x0
    //
    UINTX command : 8;
    //
    // Software may write to the mailbox registers only when RUN_BUSY is cleared (0b).
    //  Setting RUN_BUSY to 1b will create a Fast Path event to Pcode.  After setting
    // this bit, SW will poll this bit until it is cleared.  Pcode will clear the RUN_BUSY
    // after updating the mailbox registers with the result and completion code.
    //
    // Bits[28:8], RW/V, default = 0x0
    //
    UINTX addr_cntl : 21;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[30:29], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Software may write to the mailbox registers only when RUN_BUSY is cleared (0b).
    //  Setting RUN_BUSY to 1b will create a Fast Path event to Pcode.  After setting
    // this bit, SW will poll this bit until it is cleared.  Pcode will clear the RUN_BUSY
    // after updating the mailbox registers with the result and completion code.
    //
    // Bits[31:31], RW/1S/V, default = 0x0
    //
    UINTX run_busy : 1;
  } Bits;
  UINTX Data;
} P_CR_THERMAL_MAILBOX_INTERFACE_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_THERMAL_DEVICE_IRQ_0_0_0_MCHBAR_PUNIT_REG     0x0000700C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IRQ vector number for the thermal / power device.  This field controls the event
    // vector issues to the IOAPIC.   It must be configured by BIOS for INTA support.
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX irq : 8;
    //
    // Reserved
    //
    // Bits[30:8], RO, default = 0x0
    //
    UINTX reserved : 23;
    //
    // Bit used to lock P_CR_INTR_LAT_0_0_1_PCI.INTPIN
    //
    // Bits[31:31], RW/L, default = 0x0
    //
    UINTX lock : 1;
  } Bits;
  UINTX Data;
} P_CR_THERMAL_DEVICE_IRQ_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_PKG_THERM_INTERRUPT_0_0_0_MCHBAR_PUNIT_REG    0x00007010
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Controls the generation of a thermal interrupt whenever the Thermal Threshold
    // 1 Temperature is crossed.  Interrupts are generated when the threshold is crossed
    // in either direction.
    //
    // Bits[0:0], RW/V, default = 0x0
    //
    UINTX threshold1_int_enable : 1;
    //
    // Controls the generation of a thermal interrupt whenever the Thermal Threshold
    // 2 Temperature is crossed.  Interrupts are generated when the threshold is crossed
    // in either direction.
    //
    // Bits[1:1], RW/V, default = 0x0
    //
    UINTX threshold2_int_enable : 1;
    //
    // Enable thermal interrupt generation when the processor has detected a critical
    // thermal event that requires immediate servicing.  This event is intended to be
    // an alert indicating thermal control failure and is an early warning of thermal
    // runaway.
    //
    // Bits[2:2], RW/V, default = 0x0
    //
    UINTX critical_thermal_int_enable : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:3], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 5;
    //
    // Threshold temperature in degrees Celsius.  Reported in a signed, 2's complement
    // format with the LSB representing 1'C resolution (S8.7.0).  E.g., a reading of
    // 0x28 == 40'C.  This threshold is managed relative to the filtered temperature.
    //
    // Bits[15:8], RW/V, default = 0x0
    //
    UINTX threshold1_temp : 8;
    //
    // Threshold temperature in degrees Celsius.  Reported in a signed, 2's complement
    // format with the LSB representing 1'C resolution (S8.7.0).  E.g., a reading of
    // 0x28 == 40'C.  This threshold is managed relative to the filtered temperature.
    //
    // Bits[23:16], RW/V, default = 0x0
    //
    UINTX threshold2_temp : 8;
    //
    // The value in this field defines the RC time constant for thermal filtering.
    // Bit format is 'xx.yyyyy'.  Time window in seconds is described as:
    // Time Window = 0.976ms * (float)((1+xx/4) * (2^yyyyy))
    // E.g., for an RC time constant of 109ms, program 0b1100110
    // A value of zero indicates no filtering.
    //
    // Bits[30:24], RW/V, default = 0x0
    //
    UINTX time_window : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:31], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
  } Bits;
  UINTX Data;
} P_CR_PKG_THERM_INTERRUPT_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_PROCESSING_SYSTEM_FREQ_CAPABILITIES_0_0_0_MCHBAR_PUNIT_REG 0x00007014
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Efficient ratio
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX min_ratio : 8;
    //
    // min ratio
    //
    // Bits[15:8], RO/V, default = 0x0
    //
    UINTX efficient_ratio : 8;
    //
    // max ratio
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX max_ratio : 8;
    //
    // Reserved1
    //
    // Bits[31:24], RO/V, default = 0x0
    //
    UINTX last_resolved_ratio : 8;
  } Bits;
  UINTX Data;
} P_CR_PROCESSING_SYSTEM_FREQ_CAPABILITIES_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_PKG_THERM_STATUS_0_0_0_MCHBAR_PUNIT_REG       0x0000701C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Indicates that the current filtered temperature (bits 23:16 of this register)
    // is greater than or equal to the Threshold1 defined in the pkg_therm_interrupt
    // configuration register.
    //
    // Bits[0:0], RO/V, default = 0x0
    //
    UINTX threshold1_status : 1;
    //
    // Sticky log bit that indicates temperature has crossed the software programmable
    // thermal threshold1 in either falling or rising directions.
    //
    // Bits[1:1], RW/0C/V, default = 0x0
    //
    UINTX threshold1_log : 1;
    //
    // Indicates that the current filtered temperature (bits 23:16 of this register)
    // is greater than or equal to the Threshold2 defined in the pkg_therm_interrupt
    // configuration register.
    //
    // Bits[2:2], RO/V, default = 0x0
    //
    UINTX threshold2_status : 1;
    //
    // Sticky log bit that indicates temperature has crossed the software programmable
    // thermal threshold2 in either falling or rising directions.
    //
    // Bits[3:3], RW/0C/V, default = 0x0
    //
    UINTX threshold2_log : 1;
    //
    // Status bit indicating that the processor is operating outside of its thermal specification.
    //
    // Bits[4:4], RO/V, default = 0x0
    //
    UINTX critical_thermal_event_status : 1;
    //
    // Sticky log bit indicating that the processor has operated out of its thermal specification
    // since the last time SW cleared this bit. Set by HW on a 0 to 1 transition of critical_thermal_event_status.
    //
    // Bits[5:5], RW/0C/V, default = 0x0
    //
    UINTX critical_thermal_event_log : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 10;
    //
    // Virtual maximum SOC temperature in degrees Celsius. Caculated as a maximum of
    // all on-die thermal sensor readings and filtered accoring to the time constant
    // described in pkg_therm_interrupt.  Data format is signed, 2's complement with
    // the LSB representing 1'C resolution (S8.7.0).
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX temperature : 8;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:24], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 8;
  } Bits;
  UINTX Data;
} P_CR_PKG_THERM_STATUS_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_MEM_MR4_TEMPERATURE_DEV0_0_0_0_MCHBAR_PUNIT_REG 0x00007020
#ifndef ASM_INC
typedef union {
  struct {
    //
    // MR4 Device temperature of Rank_0  for WIO2 LPDDR3 and LPDDR4 .  This field is
    // updated b either LPDDR Dunit or WIO2 Dunit after each read of MR4. For LPDDRx
    // this is temperature status of the 1st rank in a channel
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX mr4_rank_0 : 3;
    //
    // MR4 Device temperature of Rank_1  only LPDDR3 and LPDDR4 not WIO2 .  This field
    // is updated LPDDR Dunit after each read of MR4 if a 2nd rank is populated.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX mr4_rank_1 : 3;
    //
    // Reserved
    //
    // Bits[31:6], RO, default = 0x0
    //
    UINTX reserved_0 : 26;
  } Bits;
  UINTX Data;
} P_CR_MEM_MR4_TEMPERATURE_DEV0_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_MEM_MR4_TEMPERATURE_DEV1_0_0_0_MCHBAR_PUNIT_REG 0x00007024
#ifndef ASM_INC
typedef union {
  struct {
    //
    // MR4 Device temperature of Rank_0  for WIO2 LPDDR3 and LPDDR4 .  This field is
    // updated b either LPDDR Dunit or WIO2 Dunit after each read of MR4. For LPDDRx
    // this is temperature status of the 1st rank in a channel
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX mr4_rank_0 : 3;
    //
    // MR4 Device temperature of Rank_1  only LPDDR3 and LPDDR4 not WIO2 .  This field
    // is updated LPDDR Dunit after each read of MR4 if a 2nd rank is populated.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX mr4_rank_1 : 3;
    //
    // Reserved
    //
    // Bits[31:6], RO, default = 0x0
    //
    UINTX reserved_0 : 26;
  } Bits;
  UINTX Data;
} P_CR_MEM_MR4_TEMPERATURE_DEV1_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_MEM_MR4_TEMPERATURE_DEV2_0_0_0_MCHBAR_PUNIT_REG 0x00007028
#ifndef ASM_INC
typedef union {
  struct {
    //
    // MR4 Device temperature of Rank_0  for WIO2 LPDDR3 and LPDDR4 .  This field is
    // updated b either LPDDR Dunit or WIO2 Dunit after each read of MR4. For LPDDRx
    // this is temperature status of the 1st rank in a channel
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX mr4_rank_0 : 3;
    //
    // MR4 Device temperature of Rank_1  only LPDDR3 and LPDDR4 not WIO2 .  This field
    // is updated LPDDR Dunit after each read of MR4 if a 2nd rank is populated.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX mr4_rank_1 : 3;
    //
    // Reserved
    //
    // Bits[31:6], RO, default = 0x0
    //
    UINTX reserved_0 : 26;
  } Bits;
  UINTX Data;
} P_CR_MEM_MR4_TEMPERATURE_DEV2_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_DDR_THERM_THRT_CTRL_0_0_0_MCHBAR_PUNIT_REG    0x00007030
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Configurable threshold of far memory MR4 value at and above which thermal throttling
    // is activated.  Fort standard LPDDR DRAM that is only capable to Tcasemax of 85C
    // this field should be configured to 3b011
    //
    // Bits[2:0], RW/V, default = 0x0
    //
    UINTX fm_therm_thrt_threshold : 3;
    //
    // When enabled thorttling is activated if far memory MR4 value is at and above FM_THERM_THRT_THRESHOLD.
    //  Fort standard LPDDR DRAM that is only capable to Tcasemax of 85C this enable
    // bit should be set.
    //
    // Bits[3:3], RW/V, default = 0x0
    //
    UINTX fm_therm_thrt_enable : 1;
    //
    // Configurable threshold of near memory MR4 value at and above which thermal throttling
    // is activated.
    //
    // Bits[6:4], RW/V, default = 0x0
    //
    UINTX nm_therm_thrt_threshold : 3;
    //
    // When enabled throttling is activated if near memory MR4 value is at and above
    // NM_THERM_THRT_THRESHOLD
    //
    // Bits[7:7], RW/V, default = 0x0
    //
    UINTX nm_therm_thrt_enable : 1;
    //
    // Configure memory throttling behavior -
    //          0: use instanous MR4 status for FM/NM_THERM_THRT_THRESHOLD
    //          1: use time-filtered MR4 status for FM/NM_THERM_THRT_THRESHOLD
    //
    // Bits[8:8], RW/V, default = 0x0
    //
    UINTX mem_thrt_cfg : 1;
    //
    // When enabled, memory traffic is throttled if near or far memory MR4 value >= NM/FM_THERM_THRT_THRESHOLD
    //
    // Bits[9:9], RW/V, default = 0x0
    //
    UINTX mem_thrt_enable : 1;
    //
    // RESERVED
    //
    // Bits[15:10], RO, default = 0x0
    //
    UINTX reserved_0 : 6;
    //
    // Must be 0x1 for DNV -
    //         1: memory is throttled if required based on OLTT/CLTT thermal status
    //         0: OLTT/CLTT memory throttle will not be used
    //
    // Bits[16:16], RW/V, default = 0x0
    //
    UINTX xltt_mem_thrt_enable : 1;
    //
    // RESERVED
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved_1 : 15;
  } Bits;
  UINTX Data;
} P_CR_DDR_THERM_THRT_CTRL_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_DDR_THERM_INTERRUPT_0_0_0_MCHBAR_PUNIT_REG    0x00007034
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Configurable far memory threshold1 value for far memory thermal interrupt generation
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX far_mem_mr4_threshold1 : 3;
    //
    // Enable thermal interrupt generation whenever the virtual maximum far memory MR4
    // has crossed THRESHOLD1.  Interrupts are triggered when the filtered MR4 temperature
    // crosses in both rising and falling directions.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX far_mem_mr4_threshold1_int_enable : 1;
    //
    // Configurable far memory threshold2 value for far memory thermal interrupt generation
    //
    // Bits[6:4], RW, default = 0x0
    //
    UINTX far_mem_mr4_threshold2 : 3;
    //
    // Enable thermal interrupt generation whenever the virtual maximum far memory MR4
    // has crossed THRESHOLD2.  Interrupts are triggered when the filtered MR4 temperature
    // crosses in both rising and falling directions.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX far_mem_mr4_threshold2_int_enable : 1;
    //
    // Configurable near memory threshold1 value for near memory thermal interrupt generation
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX near_mem_mr4_threshold1 : 3;
    //
    // Enable thermal interrupt generation whenever the virtual maximum near memory MR4
    // has crossed THRESHOLD1.  Interrupts are triggered when the filtered MR4 temperature
    // crosses in both rising and falling directions.
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX near_mem_mr4_threshold1_int_enable : 1;
    //
    // Configurable near memory threshold2 value for near memory thermal interrupt generation
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX near_mem_mr4_threshold2 : 3;
    //
    // Enable thermal interrupt generation whenever the virtual maximum near memory MR4
    // has crossed THRESHOLD2.  Interrupts are triggered when the filtered MR4 temperature
    // crosses in both rising and falling directions.
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX near_mem_mr4_threshold2_int_enable : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 8;
    //
    // The value in this field defines the RC time constant for thermal filtering.
    // Bit format is 'xx.yyyyy'.  Time window in seconds is described as:
    // Time Window = 0.976ms * (float)((1+xx/4) * (2^yyyyy))
    // E.g., for an RC time constant of 109ms, program 0b1100110
    // A value of zero indicates no filtering.
    //
    // Bits[30:24], RW, default = 0x0
    //
    UINTX time_window : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:31], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
  } Bits;
  UINTX Data;
} P_CR_DDR_THERM_INTERRUPT_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_DDR_THERM_STATUS_0_0_0_MCHBAR_PUNIT_REG       0x00007038
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Status bit is set when the virtual maximum far memory MR4 reading is greater than
    // or equal to THRESHOLD1.  It is cleared when temperature is less than THRESHOLD1
    //
    // Bits[0:0], RO/V, default = 0x0
    //
    UINTX far_mem_mr4_threshold1_status : 1;
    //
    // Indicates that the virtual maximum far memory MR4 has crossed THRESHOLD1 since
    // the last time this register was cleared.  The bit is set when the threshold is
    // crossed in either direction.  Software may clear this bit.
    //
    // Bits[1:1], RW/0C/V, default = 0x0
    //
    UINTX far_mem_mr4_threshold1_log : 1;
    //
    // Status bit is set when the virtual maximum far memory MR4 reading is greater than
    // or equal to THRESHOLD2.  It is cleared when temperature is less than THRESHOLD2
    //
    // Bits[2:2], RO/V, default = 0x0
    //
    UINTX far_mem_mr4_threshold2_status : 1;
    //
    // Indicates that the virtual maximum far memory MR4 has crossed THRESHOLD2 since
    // the last time this register was cleared.  The bit is set when the threshold is
    // crossed in either direction.  Software may clear this bit.
    //
    // Bits[3:3], RW/0C/V, default = 0x0
    //
    UINTX far_mem_mr4_threshold2_log : 1;
    //
    // Status bit is set when the virtual maximum near memory MR4 reading is greater
    // than or equal to THRESHOLD1.  It is cleared when temperature is less than THRESHOLD1
    //
    // Bits[4:4], RO/V, default = 0x0
    //
    UINTX near_mem_mr4_threshold1_status : 1;
    //
    // Indicates that the virtual maximum near memory MR4 has crossed THRESHOLD1 since
    // the last time this register was cleared.  The bit is set when the threshold is
    // crossed in either direction.  Software may clear this bit.
    //
    // Bits[5:5], RW/0C/V, default = 0x0
    //
    UINTX near_mem_mr4_threshold1_log : 1;
    //
    // Status bit is set when the virtual maximum near memory MR4 reading is greater
    // than or equal to THRESHOLD2.  It is cleared when temperature is less than THRESHOLD2
    //
    // Bits[6:6], RO/V, default = 0x0
    //
    UINTX near_mem_mr4_threshold2_status : 1;
    //
    // Indicates that the virtual maximum near memory MR4 has crossed THRESHOLD2 since
    // the last time this register was cleared.  The bit is set when the threshold is
    // crossed in either direction.  Software may clear this bit.
    //
    // Bits[7:7], RW/0C/V, default = 0x0
    //
    UINTX near_mem_mr4_threshold2_log : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:8], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 8;
    //
    // Virtual maximum far memory MR4 reading.  Caculated as a maximum of all far memory
    // MR4 readingsand filtered accoring to the time constant described in ddr_therm_interrupt.
    //
    // Bits[18:16], RO/V, default = 0x0
    //
    UINTX far_mem_mr4 : 3;
    //
    // Virtual maximum near memory MR4 reading.  Caculated as a maximum of all near memory
    // MR4 readingsand filtered accoring to the time constant described in ddr_therm_interrupt.
    //
    // Bits[21:19], RO/V, default = 0x0
    //
    UINTX near_mem_mr4 : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 10;
  } Bits;
  UINTX Data;
} P_CR_DDR_THERM_STATUS_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_DDR_RAPL_LIMIT_0_0_0_MCHBAR_PUNIT_REG         0x00007040
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Power Limit[0] for DDR domain. UnitsWatts Format11.3 Resolution0.125W Range02047.875W.
    //
    // Bits[14:0], RW/L, default = 0x0
    //
    UINTX limit1_power : 15;
    //
    // Power Limit[0] enable bit for DDR domain.
    //
    // Bits[15:15], RW/L, default = 0x0
    //
    UINTX limit1_enable : 1;
    //
    // Reserved
    //
    // Bits[16:16], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Power Limit[0] time window Y value for DDR domain. Actual time_window for RAPL
    // is: 1/1024 seconds  1x/4  2y
    //
    // Bits[21:17], RW/L, default = 0x0
    //
    UINTX limit1_time_window_y : 5;
    //
    // Power Limit[0] time window X value for DDR domain. Actual time_window for RAPL
    // is: 1/1024 seconds  1x/4  2y
    //
    // Bits[23:22], RW/L, default = 0x0
    //
    UINTX limit1_time_window_x : 2;
    //
    // Reserved
    //
    // Bits[31:24], RO, default = 0x0
    //
    UINTX reserved_1 : 8;
    //
    // Power Limit[1] for DDR domain. UnitsWatts Format11.3 Resolution0.125W Range02047.875W.
    //
    // Bits[46:32], RW/L, default = 0x0
    //
    UINTX limit2_power : 15;
    //
    // Power Limit[1] enable bit for DDR domain.
    //
    // Bits[47:47], RW/L, default = 0x0
    //
    UINTX limit2_enable : 1;
    //
    // Reserved
    //
    // Bits[48:48], RO, default = 0x0
    //
    UINTX reserved_2 : 1;
    //
    // Power Limit[1] time window Y value for DDR domain. Actual time_window for RAPL
    // is: 1/1024 seconds  1x/4  2y
    //
    // Bits[53:49], RW/L, default = 0x0
    //
    UINTX limit2_time_window_y : 5;
    //
    // Power Limit[1] time window X value for DDR domain. Actual time_window for RAPL
    // is: 1/1024 seconds  1x/4  2y
    //
    // Bits[55:54], RW/L, default = 0x0
    //
    UINTX limit2_time_window_x : 2;
    //
    // Reserved
    //
    // Bits[62:56], RO, default = 0x0
    //
    UINTX reserved_3 : 7;
    //
    // When set this entire register becomes readonly. This bit will typically be set
    // by BIOS during boot.
    //
    // Bits[63:63], RW/KL, default = 0x0
    //
    UINTX locked : 1;
  } Bits;
  UINTX Data;
} P_CR_DDR_RAPL_LIMIT_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_DDR_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_REG      0x00007048
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Total Joules of energy consumed by all DIMMs: Format  18.14 Resolution  61uJ Range
    //  0 to 2.62e5 J.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX joules : 32;
  } Bits;
  UINTX Data;
} P_CR_DDR_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_DDR_RAPL_PERF_STATUS_0_0_0_MCHBAR_PUNIT_REG   0x0000704C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Throttle duration due to RAPL sum across all channels in units of 1/1024 seconds.
    // This data can serve as a proxy for the potential performance impacts of RAPL on
    // memory accesses. This is a real time accumulator that is based on iMC counters
    // at QCLK granularity thus this register is more accurate than PACKAGE_RAPL_PERF_STATUS.
    //
    // Bits[31:0], RW, default = 0x58F0
    //
    UINTX duration : 32;
  } Bits;
  UINTX Data;
} P_CR_DDR_RAPL_PERF_STATUS_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_PACKAGE_RAPL_PERF_STATUS_0_0_0_MCHBAR_PUNIT_REG 0x00007050
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Counter of the time units within which RAPL was limiting Pstates. If limitation
    // occurred anywhere within the time window of 1/1024 seconds the count will be incremented
    // limitation on accuracy. This data can serve as a proxy for the potential performance
    // impacts of RAPL on cores performance.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX counts : 32;
  } Bits;
  UINTX Data;
} P_CR_PACKAGE_RAPL_PERF_STATUS_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_PRIMARY_PLANE_TURBO_PLCY_0_0_0_MCHBAR_PUNIT_REG 0x00007054
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Priority Level. A higher number implies a higher priority.
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX priptp : 5;
    //
    // Reserved
    //
    // Bits[31:5], RO, default = 0x0
    //
    UINTX reserved_0 : 27;
  } Bits;
  UINTX Data;
} P_CR_PRIMARY_PLANE_TURBO_PLCY_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_SECONDARY_PLANE_TURBO_PLCY_0_0_0_MCHBAR_PUNIT_REG 0x00007058
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Priority Level. A higher number implies a higher priority.
    //
    // Bits[4:0], RW, default = 0x10
    //
    UINTX secptp : 5;
    //
    // Reserved
    //
    // Bits[31:5], RO, default = 0x0
    //
    UINTX reserved_0 : 27;
  } Bits;
  UINTX Data;
} P_CR_SECONDARY_PLANE_TURBO_PLCY_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_PRIMARY_PLANE_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_REG 0x0000705C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Energy Value
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_PRIMARY_PLANE_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_SECONDARY_PLANE_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_REG 0x00007060
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Energy Value
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_SECONDARY_PLANE_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_PACKAGE_POWER_SKU_UNIT_0_0_0_MCHBAR_PUNIT_REG 0x00007068
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Power Units used for power control registers.   The actual unit value is calculated
    // by 1 W / Power2PWR_UNIT.  The default value of 0110b corresponds to 1/256 W.
    //
    // Bits[3:0], RW, default = 0x8
    //
    UINTX pwr_unit : 4;
    //
    // Reserved
    //
    // Bits[7:4], RO, default = 0x0
    //
    UINTX reserved_0 : 4;
    //
    // Energy Units used for power control registers.  The actual unit value is calculated
    // by 1 J / Power2ENERGY_UNIT.  The default value of 14 corresponds to Ux.14 number.
    //
    // Bits[12:8], RW, default = 0xE
    //
    UINTX energy_unit : 5;
    //
    // Reserved
    //
    // Bits[15:13], RO, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // Time Units used for power control registers.   The actual unit value is calculated
    // by 1 s / Power2TIME_UNIT.  The default value of Ah corresponds to 976 usec.
    //
    // Bits[19:16], RW, default = 0xA
    //
    UINTX time_unit : 4;
    //
    // Reserved
    //
    // Bits[23:20], RO, default = 0x0
    //
    UINTX reserved_2 : 4;
    //
    //
    //       Specifies the number of decimal bits in which current units in this register
    // are specified.
    //       0: steps of 1A
    //       1: steps of 0.5 Amps
    //       2: steps of 0.25 A etc...
    //
    // Bits[27:24], RW, default = 0x3
    //
    UINTX current_unit : 4;
    //
    //
    //       Specifies the number of decimal bits in which current units in this register
    // are specified.
    //       0: steps of 1Ohm
    //       1: steps of 0.5 Ohms
    //       2: steps of 0.25 Ohms etc...
    //
    // Bits[31:28], RW, default = 0x3
    //
    UINTX resistance_unit : 4;
  } Bits;
  UINTX Data;
} P_CR_PACKAGE_POWER_SKU_UNIT_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_PACKAGE_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_REG  0x0000706C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Energy Value
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_PACKAGE_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_GT_PERF_STATUS_0_0_0_MCHBAR_PUNIT_REG         0x00007070
#ifndef ASM_INC
typedef union {
  struct {
    //
    // RP-State Voltage GT Target Voltage in U1.7 Volts
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX rp_state_voltage : 8;
    //
    // Ratio of the current RP-state. When the graphics engine is in RC6, this field
    // reflects the last ratio in use
    //
    // Bits[16:8], RO/V, default = 0x0
    //
    UINTX rp_state_ratio_unslice : 9;
    //
    // Ratio of the current RP-state. When the graphics engine is in RC6, this field
    // reflects the last ratio in use
    //
    // Bits[25:17], RO/V, default = 0x0
    //
    UINTX rp_state_ratio_slice : 9;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:26], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 6;
  } Bits;
  UINTX Data;
} P_CR_GT_PERF_STATUS_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_TEMPERATURE_TARGET_0_0_0_MCHBAR_PUNIT_REG     0x00007074
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[7:0], RO, default = 0x0
    //
    UINTX reserved_0 : 8;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:8], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 8;
    //
    // Tjmax a.k.a. Throttle Temperature TCC activation temperature or Prochot Temperature
    // or REF_TEMP  This is the maximum junction temperature at which thermal throttling
    // aka thermal monitor is activated. Punit FW updates this register based on FUSE_TJMAX.This
    // field is read only by all other SW
    //
    // Bits[23:16], RO/V, default = 0x5A
    //
    UINTX ref_temp : 8;
    //
    // This field allows platform SW to configure a Tjmax_offset such that thermal throttling
    // is activated at fused_Tjmax  Tjmax_TCC_offset.Punit FW reads this field to control
    // thermal throttling activation at temperature lower than fused Tjmax
    //
    // Bits[30:24], RW, default = 0x0
    //
    UINTX tj_max_tcc_offset : 7;
    //
    // Reserved
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
  } Bits;
  UINTX Data;
} P_CR_TEMPERATURE_TARGET_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_BIOS_RESET_CPL_0_0_0_MCHBAR_PUNIT_REG         0x00007078
#ifndef ASM_INC
typedef union {
  struct {
    //
    // reset complete
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX rst_cpl : 1;
    //
    // reset complete
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX rst_cpl1 : 1;
    //
    // reset complete
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX rst_cpl2 : 1;
    //
    // reset complete
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX rst_cpl3 : 1;
    //
    // reset complete
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX rst_cpl4 : 1;
    //
    // reset complete
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX rst_cpl5 : 1;
    //
    // reset complete
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX rst_cpl6 : 1;
    //
    // reset complete
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX rst_cpl7 : 1;
    //
    // pcode complete
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX pcode_init_done : 1;
    //
    // pcode complete
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX pcode_init_done1 : 1;
    //
    // pcode complete
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX pcode_init_done2 : 1;
    //
    // pcode complete
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX pcode_init_done3 : 1;
    //
    // pcode complete
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX pcode_init_done4 : 1;
    //
    // pcode complete
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX pcode_init_done5 : 1;
    //
    // pcode complete
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX pcode_init_done6 : 1;
    //
    // pcode complete
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX pcode_init_done7 : 1;
    //
    // reserved
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX reserved0 : 16;
  } Bits;
  UINTX Data;
} P_CR_BIOS_RESET_CPL_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_BIOS_MAILBOX_DATA_0_0_0_MCHBAR_PUNIT_REG      0x00007080
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field contains the data associated with specific commands.
    //
    // Bits[31:0], RW/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_BIOS_MAILBOX_DATA_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_BIOS_MAILBOX_INTERFACE_0_0_0_MCHBAR_PUNIT_REG 0x00007084
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field contains the SW request command or the PCODE response code depending
    // on the setting of RUN_BUSY.  Command Encodings  01h MAILBOX_BIOS_CMD_READ_PCS
    //  02h MAILBOX_BIOS_CMD_WRITE_PCS  Error Code Encodings  00h MAILBOX_BIOS_ERROR_NONE
    //  01h MAILBOX_BIOS_ERROR_INVALID_COMMAND
    //
    // Bits[7:0], RW/V, default = 0x0
    //
    UINTX command : 8;
    //
    // This field contains the address associated with specific commands.
    //
    // Bits[28:8], RW/V, default = 0x0
    //
    UINTX address : 21;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[30:29], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // SW may write to the two mailbox registers only when RUN_BUSY is cleared 0b. Setting
    // RUN_BUSY to 1b will create a Fast Path event. After setting this bit SW will poll
    // this bit until it is cleared.  PCODE will clear RUN_BUSY after updating the mailbox
    // registers with the result and error code.
    //
    // Bits[31:31], RW/1S/V, default = 0x0
    //
    UINTX run_busy : 1;
  } Bits;
  UINTX Data;
} P_CR_BIOS_MAILBOX_INTERFACE_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_CORE_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_REG 0x00007088
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Minimum supported core frequency
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX min_supported_freq : 8;
    //
    // Efficient core frequency
    //
    // Bits[15:8], RO/V, default = 0x0
    //
    UINTX efficient_freq : 8;
    //
    // Max Supported core frequency
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX max_supported_freq : 8;
    //
    // Last resolved core frequency
    //
    // Bits[31:24], RO/V, default = 0x0
    //
    UINTX last_resolved_freq : 8;
  } Bits;
  UINTX Data;
} P_CR_CORE_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_GRAPHICS_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_REG 0x0000708C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Minimum supported gfx frequency
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX min_supported_freq : 8;
    //
    // Efficient gfx frequency
    //
    // Bits[15:8], RO/V, default = 0x0
    //
    UINTX efficient_freq : 8;
    //
    // Max Supported gfx frequency
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX max_supported_freq : 8;
    //
    // Last resolved gfx frequency
    //
    // Bits[31:24], RO/V, default = 0x0
    //
    UINTX last_resolved_freq : 8;
  } Bits;
  UINTX Data;
} P_CR_GRAPHICS_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_SYSTEM_AGENT_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_REG 0x00007090
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX reserved_0 : 8;
    //
    // Reserved
    //
    // Bits[15:8], RO/V, default = 0x0
    //
    UINTX reserved_1 : 8;
    //
    // Reserved
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX reserved_2 : 8;
    //
    // Last resolved system agent ratio
    //
    // Bits[31:24], RO/V, default = 0x0
    //
    UINTX last_resolved_ratio : 8;
  } Bits;
  UINTX Data;
} P_CR_SYSTEM_AGENT_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_FAR_MEMORY_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_REG 0x00007094
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX reserved_0 : 8;
    //
    // Reserved
    //
    // Bits[15:8], RO/V, default = 0x0
    //
    UINTX reserved_1 : 8;
    //
    // Reserved
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX reserved_2 : 8;
    //
    // Last resolved far memory LPDDR ratio
    //
    // Bits[31:24], RO/V, default = 0x0
    //
    UINTX last_resolved_ratio : 8;
  } Bits;
  UINTX Data;
} P_CR_FAR_MEMORY_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_NEAR_MEMORY_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_REG 0x00007098
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX reserved_0 : 8;
    //
    // Reserved
    //
    // Bits[15:8], RO/V, default = 0x0
    //
    UINTX reserved_1 : 8;
    //
    // Reserved
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX reserved_2 : 8;
    //
    // Last resolved near memory WIO ratio
    //
    // Bits[31:24], RO/V, default = 0x0
    //
    UINTX last_resolved_ratio : 8;
  } Bits;
  UINTX Data;
} P_CR_NEAR_MEMORY_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_PACKAGE_POWER_SKU_0_0_0_MCHBAR_PUNIT_REG      0x000070A0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The TDP package power setting allowed for the SKU. The TDP setting is typical
    // not guaranteed.  The default value for this field is determined by fuses.  The
    // units for this value are defined in PACKAGE_POWER_SKU_MSR[PWR_UNIT].
    //
    // Bits[14:0], RW, default = 0x118
    //
    UINTX pkg_tdp : 15;
    //
    // Reserved
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // The minimal package power setting allowed for the SKU. Lower values will be clamped
    // to this value. The minimum setting is typical not guaranteed.  The default value
    // for this field is determined by fuses.  The units for this value are defined in
    // PACKAGE_POWER_SKU_MSR[PWR_UNIT].
    //
    // Bits[30:16], RW, default = 0x60
    //
    UINTX pkg_min_pwr : 15;
    //
    // Reserved
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // The maximal package power setting allowed for the SKU. Higher values will be clamped
    // to this value. The maximum setting is typical not guaranteed.  The default value
    // for this field is determined by fuses.  The units for this value are defined in
    // PACKAGE_POWER_SKU_MSR[PWR_UNIT].
    //
    // Bits[46:32], RW, default = 0x240
    //
    UINTX pkg_max_pwr : 15;
    //
    // Reserved
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX reserved_2 : 1;
    //
    // The maximal time window allowed for the SKU. Higher values will be clamped to
    // this value.  x  PKG_MAX_WIN[54:53]  y  PKG_MAX_WIN[52:48]  The timing interval
    // window is Floating Point number given by 1.x  power2y.  The unit of measurement
    // is defined in PACKAGE_POWER_SKU_UNIT_MSR[TIME_UNIT].
    //
    // Bits[54:48], RW, default = 0x12
    //
    UINTX pkg_max_win : 7;
    //
    // Reserved
    //
    // Bits[63:55], RO, default = 0x0
    //
    UINTX reserved_3 : 9;
  } Bits;
  UINTX Data;
} P_CR_PACKAGE_POWER_SKU_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_PACKAGE_RAPL_LIMIT_0_0_0_MCHBAR_PUNIT_REG     0x000070A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field indicates the power limitation 1. The default value is loaded from
    // fuses.  The unit of measurement is defined in PACKAGE_POWER_SKU_UNIT_MSR[PWR_UNIT].
    //
    // Bits[14:0], RW/L, default = 0x0
    //
    UINTX pkg_pwr_lim_1 : 15;
    //
    // This bit enables/disables PKG_PWR_LIM_1.  0b Package Power Limit 1 is Disabled
    //  1b Package Power Limit 1 is Enabled
    //
    // Bits[15:15], RW/L, default = 0x0
    //
    UINTX pkg_pwr_lim_1_en : 1;
    //
    // Package Clamping limitation 1  Allow going below P1.  0b PBM is limited between
    // P1 and P0.  1b PBM can go below P1.
    //
    // Bits[16:16], RW/L, default = 0x0
    //
    UINTX pkg_clmp_lim_1 : 1;
    //
    // x  PKG_PWR_LIM_1_TIME[23:22]  y  PKG_PWR_LIM_1_TIME[21:17]  The timing interval
    // window is Floating Point number given by 1.x  power2y.  The unit of measurement
    // is defined in PACKAGE_POWER_SKU_UNIT_MSR[TIME_UNIT].  The maximal time window
    // is bounded by PACKAGE_POWER_SKU_MSR[PKG_MAX_WIN]. The minimum time window is 1
    // unit of measurement as defined above.
    //
    // Bits[23:17], RW/L, default = 0x0
    //
    UINTX pkg_pwr_lim_1_time : 7;
    //
    // Reserved
    //
    // Bits[31:24], RO, default = 0x0
    //
    UINTX reserved_0 : 8;
    //
    // This field indicates the power limitation 2.   The unit of measurement is defined
    // in PACKAGE_POWER_SKU_UNIT_MSR[PWR_UNIT].
    //
    // Bits[46:32], RW/L, default = 0x0
    //
    UINTX pkg_pwr_lim_2 : 15;
    //
    // This bit enables/disables PKG_PWR_LIM_2.  0b Package Power Limit 2 is Disabled
    //  1b Package Power Limit 2 is Enabled
    //
    // Bits[47:47], RW/L, default = 0x0
    //
    UINTX pkg_pwr_lim_2_en : 1;
    //
    // Package Clamping limitation 2  Allow going below P1.  0b PBM is limited between
    // P1 and P0.  1b PBM can go below P1.
    //
    // Bits[48:48], RW/L, default = 0x0
    //
    UINTX pkg_clmp_lim_2 : 1;
    //
    // x  PKG_PWR_LIM_2_TIME[55:54]  y  PKG_PWR_LIM_2_TIME[53:49]  The timing interval
    // window is Floating Point number given by 1.x  power2y.  The unit of measurement
    // is defined in PACKAGE_POWER_SKU_UNIT_MSR[TIME_UNIT].  The maximal time window
    // is bounded by PACKAGE_POWER_SKU_MSR[PKG_MAX_WIN].  The minimum time window is
    // 1 unit of measurement as defined above.
    //
    // Bits[55:49], RW/L, default = 0x0
    //
    UINTX pkg_pwr_lim_2_time : 7;
    //
    // Reserved
    //
    // Bits[62:56], RO, default = 0x0
    //
    UINTX reserved_1 : 7;
    //
    // When set all settings in this register are locked and are treated as Read Only.
    //  This bit will typically set by BIOS during boot time or resume from Sx.
    //
    // Bits[63:63], RW/KL, default = 0x0
    //
    UINTX pkg_pwr_lim_lock : 1;
  } Bits;
  UINTX Data;
} P_CR_PACKAGE_RAPL_LIMIT_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_IA_PERF_LIMIT_REASONS_0_0_0_MCHBAR_PUNIT_REG  0x000070B0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // requency is limited due to external PROCHOT assertion, if supported on Broxton.
    //
    // Bits[0:0], RO/V, default = 0x0
    //
    UINTX prochot_status : 1;
    //
    // Frequency is limited due to thermal excursion.
    //
    // Bits[1:1], RO/V, default = 0x0
    //
    UINTX thermal_status : 1;
    //
    // requency is limited due to a package-level PL1 excursion.
    //
    // Bits[2:2], RO/V, default = 0x0
    //
    UINTX pl1_status : 1;
    //
    // requency is limited due to a package-level PL2 excursion.
    //
    // Bits[3:3], RO/V, default = 0x0
    //
    UINTX pl2_status : 1;
    //
    // Spare4
    //
    // Bits[4:4], RO/V, default = 0x0
    //
    UINTX spare4_status : 1;
    //
    // Spare5
    //
    // Bits[5:5], RO/V, default = 0x0
    //
    UINTX spare5_status : 1;
    //
    // Spare6
    //
    // Bits[6:6], RO/V, default = 0x0
    //
    UINTX spare6_status : 1;
    //
    // Frequency is limited due to Dev2 driver override.
    //
    // Bits[7:7], RO/V, default = 0x0
    //
    UINTX dev2_status : 1;
    //
    // Frequency is limited due to Dev3 driver override.
    //
    // Bits[8:8], RO/V, default = 0x0
    //
    UINTX dev3_status : 1;
    //
    // requency is limited due to autonomous utilization-based P-state control, if supported
    // on Broxton
    //
    // Bits[9:9], RO/V, default = 0x0
    //
    UINTX ia_utilization_status : 1;
    //
    // requency is limited due to a VR thermal excursion.
    //
    // Bits[10:10], RO/V, default = 0x0
    //
    UINTX vr_thermalert_status : 1;
    //
    // Frequency is limited due to effective multi-core turbo constraints, if applicable
    // on Broxton.
    //
    // Bits[11:11], RO/V, default = 0x0
    //
    UINTX multi_core_turbo_status : 1;
    //
    // Frequency is limited due to a package-level EDP constraint.
    //
    // Bits[12:12], RO/V, default = 0x0
    //
    UINTX edp_status : 1;
    //
    // Frequency is limited due to ratio change transition attenuation (MCT, prevents
    // frequent ratio changes due to core C-state entry/exit).
    //
    // Bits[13:13], RO/V, default = 0x0
    //
    UINTX mct_status : 1;
    //
    // Frequency is limited below the maximum efficiency frequency.
    //
    // Bits[14:14], RO/V, default = 0x0
    //
    UINTX max_efficiency_freq_status : 1;
    //
    // Frequency is limited below the operating system or driver Quality-of-Service floor.
    //
    // Bits[15:15], RO/V, default = 0x0
    //
    UINTX qos_status : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[16:16], RW/0C/V, default = 0x0
    //
    UINTX prochot_log : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[17:17], RW/0C/V, default = 0x0
    //
    UINTX thermal_log : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[18:18], RW/0C/V, default = 0x0
    //
    UINTX pl1_log : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[19:19], RW/0C/V, default = 0x0
    //
    UINTX pl2_log : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[20:20], RW/0C/V, default = 0x0
    //
    UINTX spare4_log : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[21:21], RW/0C/V, default = 0x0
    //
    UINTX spare5_log : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[22:22], RW/0C/V, default = 0x0
    //
    UINTX spare6_log : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[23:23], RW/0C/V, default = 0x0
    //
    UINTX dev2_log : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[24:24], RW/0C/V, default = 0x0
    //
    UINTX dev3_log : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[25:25], RW/0C/V, default = 0x0
    //
    UINTX ia_utilization_log : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[26:26], RW/0C/V, default = 0x0
    //
    UINTX vr_thermalert_log : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[27:27], RW/0C/V, default = 0x0
    //
    UINTX multi_core_turbo_log : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[28:28], RW/0C/V, default = 0x0
    //
    UINTX edp_log : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[29:29], RW/0C/V, default = 0x0
    //
    UINTX mct_log : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[30:30], RW/0C/V, default = 0x0
    //
    UINTX max_efficiency_freq_log : 1;
    //
    // set by pcode, cleared by SW
    //
    // Bits[31:31], RW/0C/V, default = 0x0
    //
    UINTX qos_log : 1;
  } Bits;
  UINTX Data;
} P_CR_IA_PERF_LIMIT_REASONS_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_IA_C0_RESIDENCY_0_0_0_MCHBAR_PUNIT_REG  0x000070C0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Residency data
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_TELEM_IA_C0_RESIDENCY_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_GT_C0_RESIDENCY_0_0_0_MCHBAR_PUNIT_REG  0x000070C4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Residency data
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_TELEM_GT_C0_RESIDENCY_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_IUNIT_C0_RESIDENCY_0_0_0_MCHBAR_PUNIT_REG 0x000070C8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Residency data
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_TELEM_IUNIT_C0_RESIDENCY_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_IA_FREQ_ACCUMULATOR_0_0_0_MCHBAR_PUNIT_REG 0x000070CC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Residency data
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_TELEM_IA_FREQ_ACCUMULATOR_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_GT_FREQ_ACCUMULATOR_0_0_0_MCHBAR_PUNIT_REG 0x000070D0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Residency data
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_TELEM_GT_FREQ_ACCUMULATOR_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_IUNIT_FREQ_ACCUMULATOR_0_0_0_MCHBAR_PUNIT_REG 0x000070D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Residency data
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_TELEM_IUNIT_FREQ_ACCUMULATOR_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_NEAR_MEMORY_ACTIVE_0_0_0_MCHBAR_PUNIT_REG 0x000070E0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Residency data
    //
    // Bits[63:0], RO/V, default = 0x0
    //
    UINTX data : 64;
  } Bits;
  UINTX Data;
} P_CR_TELEM_NEAR_MEMORY_ACTIVE_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_FAR_MEMORY_ACTIVE_0_0_0_MCHBAR_PUNIT_REG 0x000070E8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Residency data
    //
    // Bits[63:0], RO/V, default = 0x0
    //
    UINTX data : 64;
  } Bits;
  UINTX Data;
} P_CR_TELEM_FAR_MEMORY_ACTIVE_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_PACKAGE_TEMPERATURES_0_0_0_MCHBAR_PUNIT_REG   0x000070F4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Virtual max temperature of all IA cores in degrees C.  Reported in a signed, 2's
    // complement format with the LSB representing 1'C resolution (S8.7.0).  Raw, unfiltered
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX ia_temperature : 8;
    //
    // Graphics domain max temperature in degrees C.  Reported in a signed, 2's complement
    // format with the LSB representing 1'C resolution (S8.7.0).  Raw, unfiltered
    //
    // Bits[15:8], RO/V, default = 0x0
    //
    UINTX gt_temperature : 8;
    //
    // Camera domain max temperature in degrees C.  Reported in a signed, 2's complement
    // format with the LSB representing 1'C resolution (S8.7.0).  Raw, unfiltered
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX isp_temperature : 8;
    //
    // System agent domain max temperature in degrees C.  Reported in a signed, 2's complement
    // format with the LSB representing 1'C resolution (S8.7.0).  Raw, unfiltered
    //
    // Bits[31:24], RO/V, default = 0x0
    //
    UINTX sa_temperature : 8;
  } Bits;
  UINTX Data;
} P_CR_PACKAGE_TEMPERATURES_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_THERMAL_LIMIT_CONTROL_0_0_0_MCHBAR_PUNIT_REG  0x00007104
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Maximum SOC temperature allowed.  Described in a signed, 2's complement format
    // with the LSB representing 1'C resolution (S8.7.0).  If the setting is higher than
    // the processor's factory configured maximum temperature as described in the TEMPERATURE_TARGET
    // MSR, this field is ignored.  This field may be updated at any time.
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX thermal_limit_temp : 8;
    //
    // When set, it enables run-time thermal limit control to the THERMAL_LIMIT_TEMP
    // described in this register.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX enable : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 23;
  } Bits;
  UINTX Data;
} P_CR_THERMAL_LIMIT_CONTROL_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_MEMSS_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_REG 0x00007108
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX lp3_freq_low : 6;
    //
    // N/A
    //
    // Bits[11:6], RW, default = 0x0
    //
    UINTX lp3_freq_high : 6;
    //
    // N/A
    //
    // Bits[17:12], RW, default = 0x0
    //
    UINTX lp4_freq_low : 6;
    //
    // N/A
    //
    // Bits[23:18], RW, default = 0x0
    //
    UINTX lp4_freq_high : 6;
    //
    // N/A
    //
    // Bits[29:24], RW, default = 0x0
    //
    UINTX wio_freq : 6;
    //
    // N/A
    //
    // Bits[31:30], RW, default = 0x0
    //
    UINTX num_nm_ch : 2;
  } Bits;
  UINTX Data;
} P_CR_MEMSS_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_MC_BIOS_REQ_0_0_0_MCHBAR_PUNIT_REG            0x00007114
#ifndef ASM_INC
typedef union {
  struct {
    //
    // N/A
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX req_data : 6;
    //
    // N/A
    //
    // Bits[8:6], RW, default = 0x0
    //
    UINTX req_type : 3;
    //
    // N/A
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX req_type_special : 1;
    //
    // N/A
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // N/A
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX wio_only : 1;
    //
    // N/A
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX fm_ch0_active : 1;
    //
    // N/A
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX fm_ch1_active : 1;
    //
    // N/A
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX fm_ch2_active : 1;
    //
    // N/A
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX fm_ch3_active : 1;
    //
    // N/A
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX phy_config_complete : 1;
    //
    // N/A
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX dunit_reset_complete : 1;
    //
    // N/A
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX cpgc_mode_complete : 1;
    //
    // N/A
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX mem_init_done : 1;
    //
    // N/A
    //
    // Bits[30:20], RW, default = 0x0
    //
    UINTX reserved_1 : 11;
    //
    // N/A
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX run_busy : 1;
  } Bits;
  UINTX Data;
} P_CR_MC_BIOS_REQ_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_PP1_C0_CORE_CLOCK_0_0_0_MCHBAR_PUNIT_REG      0x00007160
#ifndef ASM_INC
typedef union {
  struct {
    //
    // data
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_PP1_C0_CORE_CLOCK_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_CORE_EXISTS_VECTOR_0_0_0_MCHBAR_PUNIT_REG     0x00007164
#ifndef ASM_INC
typedef union {
  struct {
    //
    // core0 exists
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX core0_exists : 1;
    //
    // core1 exists
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX core1_exists : 1;
    //
    // core2 exists
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX core2_exists : 1;
    //
    // core3 exists
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX core3_exists : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:4], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 28;
  } Bits;
  UINTX Data;
} P_CR_CORE_EXISTS_VECTOR_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_CORE_DISABLE_MASK_0_0_0_MCHBAR_PUNIT_REG      0x00007168
#ifndef ASM_INC
typedef union {
  struct {
    //
    // core0 disable mask
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX core0_disable_mask : 1;
    //
    // core1 disable mask
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX core1_disable_mask : 1;
    //
    // core2 disable mask
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX core2_disable_mask : 1;
    //
    // core3 disable mask
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX core3_disable_mask : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:4], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 28;
  } Bits;
  UINTX Data;
} P_CR_CORE_DISABLE_MASK_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC

#define P_CR_PL3_CONTROL_0_0_0_MCHBAR_PUNIT_REG            0x000071F0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PL3 or PAppMax power level.  A power reading above this will be interpreted as
    // a violation (in increments of 1/8th Watt)
    //
    // Bits[14:0], RW/L, default = 0x0
    //
    UINTX power_limit : 15;
    //
    // 0 => Algorithm disabled, 1 => Algorithm enabled
    //
    // Bits[15:15], RW/L, default = 0x0
    //
    UINTX pl3_enable : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[16:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Duration over which duty cycle control will be maintained.  (xxYYYY format)
    //
    // Bits[23:17], RW/L, default = 0x0
    //
    UINTX time_window : 7;
    //
    // Expressed in percentage(%).  Clipped to a max value of 100%.
    //
    // Bits[30:24], RW/L, default = 0x0
    //
    UINTX duty_cycle : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:31], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Power Limit 'PL4' or Pmax power limit in the units as described PACAKGE_POWER_SKU_UNIT
    // MSR
    //
    // Bits[46:32], RW/L, default = 0x0
    //
    UINTX pmax : 15;
    //
    // 0 => Algorithm disabled, 1 => Algorithm enabled
    //
    // Bits[47:47], RW/L, default = 0x0
    //
    UINTX pl4_enable : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[62:48], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 15;
    //
    // Lock this MMIO  until next reset: 0 - unlocked, 1 - locked
    //
    // Bits[63:63], RW/KL, default = 0x0
    //
    UINTX lock : 1;
  } Bits;
  UINTX Data;
} P_CR_PL3_CONTROL_0_0_0_MCHBAR_PUNIT_STRUCT;
#endif // ASM_INC


#endif // _PUNIT_H_
