﻿# *************************************************************************
#                                                                        **
#                  I N T E L ( MWG ) P R O P R I E T A R Y          	 **
#                                                                        **
#     COPYRIGHT (c)  2016 BY  INTEL  CORPORATION.  ALL RIGHTS            **
#     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY        **
#     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A      **
#     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER      **
#     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,      **
#     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT      **
#     THE PRIOR WRITTEN PERMISSION OF INTEL  CORPORATION.                **
#                                                                        **
# *************************************************************************

# *************************************************************************
#  File: triage.ps1
# 
#  Description: Script to collect post tracing logs for Intel Bluetooth 
#  driver
# 
# *************************************************************************
param (
    [string]$path = $null
 )

.".\scripts\common.ps1"

if ($path -eq "help")
{
	Get-Content .\usage.txt | foreach {Write-Output $_}
} 
else
{
	write-host "Collecting triage logs. This may take several minutes. Please wait..."
	if(-Not [string]::IsNullOrEmpty($path))
	{
		#Use path
		$file = New-Item -type Directory $path -Force
		if(Test-Path $path)
		{
			$ThePath = CreateSessionFolder($path)
			$NewPath = [string]$ThePath[0]
			GetTriageLogs($NewPath)
		}	
	}
	else
	{
		$ThePath = CreateSessionFolder($global:DefaultLogFolderPath)
		$NewPath = [string]$ThePath[0]
		GetTriageLogs($NewPath)
	}

	Write-Host-Success "Done. Triage logs are copied to $NewPath"
}
# SIG # Begin signature block
# MIIliQYJKoZIhvcNAQcCoIIlejCCJXYCAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCBROd0vvdr45/Wd
# vts/RG/qWrq9ehmLAPMjCVXkQyySuaCCIJwwggPuMIIDV6ADAgECAhB+k+v7fMZO
# WepLmnfUBvw7MA0GCSqGSIb3DQEBBQUAMIGLMQswCQYDVQQGEwJaQTEVMBMGA1UE
# CBMMV2VzdGVybiBDYXBlMRQwEgYDVQQHEwtEdXJiYW52aWxsZTEPMA0GA1UEChMG
# VGhhd3RlMR0wGwYDVQQLExRUaGF3dGUgQ2VydGlmaWNhdGlvbjEfMB0GA1UEAxMW
# VGhhd3RlIFRpbWVzdGFtcGluZyBDQTAeFw0xMjEyMjEwMDAwMDBaFw0yMDEyMzAy
# MzU5NTlaMF4xCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3Jh
# dGlvbjEwMC4GA1UEAxMnU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNlcyBD
# QSAtIEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsayzSVRLlxwS
# CtgleZEiVypv3LgmxENza8K/LlBa+xTCdo5DASVDtKHiRfTot3vDdMwi17SUAAL3
# Te2/tLdEJGvNX0U70UTOQxJzF4KLabQry5kerHIbJk1xH7Ex3ftRYQJTpqr1SSwF
# eEWlL4nO55nn/oziVz89xpLcSvh7M+R5CvvwdYhBnP/FA1GZqtdsn5Nph2Upg4XC
# YBTEyMk7FNrAgfAfDXTekiKryvf7dHwn5vdKG3+nw54trorqpuaqJxZ9YfeYcRG8
# 4lChS+Vd+uUOpyyfqmUg09iW6Mh8pU5IRP8Z4kQHkgvXaISAXWp4ZEXNYEZ+VMET
# fMV58cnBcQIDAQABo4H6MIH3MB0GA1UdDgQWBBRfmvVuXMzMdJrU3X3vP9vsTIAu
# 3TAyBggrBgEFBQcBAQQmMCQwIgYIKwYBBQUHMAGGFmh0dHA6Ly9vY3NwLnRoYXd0
# ZS5jb20wEgYDVR0TAQH/BAgwBgEB/wIBADA/BgNVHR8EODA2MDSgMqAwhi5odHRw
# Oi8vY3JsLnRoYXd0ZS5jb20vVGhhd3RlVGltZXN0YW1waW5nQ0EuY3JsMBMGA1Ud
# JQQMMAoGCCsGAQUFBwMIMA4GA1UdDwEB/wQEAwIBBjAoBgNVHREEITAfpB0wGzEZ
# MBcGA1UEAxMQVGltZVN0YW1wLTIwNDgtMTANBgkqhkiG9w0BAQUFAAOBgQADCZuP
# ee9/WTCq72i1+uMJHbtPggZdN1+mUp8WjeockglEbvVt61h8MOj5aY0jcwsSb0ep
# rjkR+Cqxm7Aaw47rWZYArc4MTbLQMaYIXCp6/OJ6HVdMqGUY6XlAYiWWbsfHN2qD
# IQiOQerd2Vc/HXdJhyoWBl6mOGoiEqNRGYN+tjCCBKMwggOLoAMCAQICEA7P9DjI
# /r81bgTYapgbGlAwDQYJKoZIhvcNAQEFBQAwXjELMAkGA1UEBhMCVVMxHTAbBgNV
# BAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1hbnRlYyBUaW1l
# IFN0YW1waW5nIFNlcnZpY2VzIENBIC0gRzIwHhcNMTIxMDE4MDAwMDAwWhcNMjAx
# MjI5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
# cG9yYXRpb24xNDAyBgNVBAMTK1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vydmlj
# ZXMgU2lnbmVyIC0gRzQwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCi
# Yws5RLi7I6dESbsO/6HwYQpTk7CY260sD0rFbv+GPFNVDxXOBD8r/amWltm+YXkL
# W8lMhnbl4ENLIpXuwitDwZ/YaLSOQE/uhTi5EcUj8mRY8BUyb05Xoa6IpALXKh7N
# S+HdY9UXiTJbsF6ZWqidKFAOF+6W22E7RVEdzxJWC5JH/Kuu9mY9R6xwcueS51/N
# ELnEg2SUGb0lgOHo0iKl0LoCeqF3k1tlw+4XdLxBhircCEyMkoyRLZ53RB9o1qh0
# d9sOWzKLVoszvdljyEmdOsXF6jML0vGjG/SLvtmzV4s73gSneiKyJK4ux3DFvk6D
# Jgj7C72pT5kI4RAocqrNAgMBAAGjggFXMIIBUzAMBgNVHRMBAf8EAjAAMBYGA1Ud
# JQEB/wQMMAoGCCsGAQUFBwMIMA4GA1UdDwEB/wQEAwIHgDBzBggrBgEFBQcBAQRn
# MGUwKgYIKwYBBQUHMAGGHmh0dHA6Ly90cy1vY3NwLndzLnN5bWFudGVjLmNvbTA3
# BggrBgEFBQcwAoYraHR0cDovL3RzLWFpYS53cy5zeW1hbnRlYy5jb20vdHNzLWNh
# LWcyLmNlcjA8BgNVHR8ENTAzMDGgL6AthitodHRwOi8vdHMtY3JsLndzLnN5bWFu
# dGVjLmNvbS90c3MtY2EtZzIuY3JsMCgGA1UdEQQhMB+kHTAbMRkwFwYDVQQDExBU
# aW1lU3RhbXAtMjA0OC0yMB0GA1UdDgQWBBRGxmmjDkoUHtVM2lJjFz9eNrwN5jAf
# BgNVHSMEGDAWgBRfmvVuXMzMdJrU3X3vP9vsTIAu3TANBgkqhkiG9w0BAQUFAAOC
# AQEAeDu0kSoATPCPYjA3eKOEJwdvGLLeJdyg1JQDqoZOJZ+aQAMc3c7jecshaAba
# tjK0bb/0LCZjM+RJZG0N5sNnDvcFpDVsfIkWxumy37Lp3SDGcQ/NlXTctlzevTcf
# Q3jmeLXNKAQgo6rxS8SIKZEOgNER/N1cdm5PXg5FRkFuDbDqOJqxOtoJcRD8HHm0
# gHusafT9nLYMFivxf1sJPZtb4hbKE4FtAC44DagpjyzhsvRaqQGvFZwsL0kb2yK7
# w/54lFHDhrGCiF3wPbRRoXkzKy57udwgCRNx62oZW8/opTBXLIlJP7nPf8m/PiJo
# Y1OavWl0rMUdPH+S4MO8HNgEdTCCBUwwggM0oAMCAQICEzMAAAA12NVZWwZxQSsA
# AAAAADUwDQYJKoZIhvcNAQEFBQAwfzELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
# c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
# b3Jwb3JhdGlvbjEpMCcGA1UEAxMgTWljcm9zb2Z0IENvZGUgVmVyaWZpY2F0aW9u
# IFJvb3QwHhcNMTMwODE1MjAyNjMwWhcNMjMwODE1MjAzNjMwWjBvMQswCQYDVQQG
# EwJTRTEUMBIGA1UEChMLQWRkVHJ1c3QgQUIxJjAkBgNVBAsTHUFkZFRydXN0IEV4
# dGVybmFsIFRUUCBOZXR3b3JrMSIwIAYDVQQDExlBZGRUcnVzdCBFeHRlcm5hbCBD
# QSBSb290MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAt/caM+byAAQt
# OeBOW+0fvGwPzbX6I7bO3psRM5ekKUx9k5+9SryT7QMa44/P5W1QWtaXKZRagLBJ
# etsulf24yr83OC0ePpFBrXBWx/BPP+gynnTKyJBU6cZfD3idmkA8Dqxhql4Uj56H
# oWpQ3NeaTq8Fs6ZxlJxxs1BgCscTnTgHhgKo6ahpJhiQq0ywTyOrOk+E2N/On+Fp
# b7vXQtdrROTHre5tQV9yWnEIN7N5ZaRZoJQ39wAvDcKSctrQOHLbFKhFxF0qfbe0
# 1sTurM0TRLfJK91DACX6YblpalgjEbenM49WdVn1zSnXRrcKK2W200JvFbK4e/vv
# 6V1T1TRaJwIDAQABo4HQMIHNMBMGA1UdJQQMMAoGCCsGAQUFBwMDMBIGA1UdEwEB
# /wQIMAYBAf8CAQIwHQYDVR0OBBYEFK29mHo0tCb3+sQmVO8DveAky1QaMAsGA1Ud
# DwQEAwIBhjAfBgNVHSMEGDAWgBRi+wohW39DbhHaCVRQa/XSlnHxnjBVBgNVHR8E
# TjBMMEqgSKBGhkRodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9k
# dWN0cy9NaWNyb3NvZnRDb2RlVmVyaWZSb290LmNybDANBgkqhkiG9w0BAQUFAAOC
# AgEANiui8uEzH+ST9/JphcZkDsmbYy/kcDeY/ZTse8/4oUJG+e1qTo00aTYFVXoe
# u62MmUKWBuklqCaEvsG/Fql8qlsEt/3RwPQCvijt9XfHm/469ujBe9OCq/oUTs8r
# z+XVtUhAsaOPg4utKyVTq6Y0zvJD908s6d0eTlq2uug7EJkkALxQ/Xj25SOoiZST
# 97dBMDdKV7fmRNnJ35kFqkT8dK+CZMwHywG2CcMu4+gyp7SfQXjHoYQ2VGLy7BUK
# yOrQhPjx4Gv0VhJfleD83bd2k/4pSiXpBADxtBEOyYSe2xd99R6ljjYpGTptbEZL
# 16twJCiNBaPZ1STy+KDRPII51KiCDmk6gQn8BvDHWTOENpMGQZEjLCKlpwErULQo
# rttGsFkbhrObh+hJTjkLbRTfTAMwHh9fdK71W1kDU+yYFuDQYjV1G0i4fRPleki4
# d1KkB5glOwabek5qb0SGTxRPJ3knPVBzQUycQT7dKQxzscf7H3YMF2UE69JQEJJB
# SezkBn02FURvib9pfflNQME6mLagfjHSta7K+1PVP1CGzV6TO21dfJo/P/epJViE
# 3RFJAKLHyJ433XeObXGL4FuBNF1Uusz1k0eIbefvW+Io5IAbQOQPKtF/IxVlWqyZ
# lEM/RlUm1sT6iJXikZqjLQuF3qyM4PlncJ9xeQIx92GiKcQwggV0MIIEXKADAgEC
# AhAnZu5W60nzjqvXcKL8hN4iMA0GCSqGSIb3DQEBDAUAMG8xCzAJBgNVBAYTAlNF
# MRQwEgYDVQQKEwtBZGRUcnVzdCBBQjEmMCQGA1UECxMdQWRkVHJ1c3QgRXh0ZXJu
# YWwgVFRQIE5ldHdvcmsxIjAgBgNVBAMTGUFkZFRydXN0IEV4dGVybmFsIENBIFJv
# b3QwHhcNMDAwNTMwMTA0ODM4WhcNMjAwNTMwMTA0ODM4WjCBhTELMAkGA1UEBhMC
# R0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UEBxMHU2FsZm9y
# ZDEaMBgGA1UEChMRQ09NT0RPIENBIExpbWl0ZWQxKzApBgNVBAMTIkNPTU9ETyBS
# U0EgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwggIiMA0GCSqGSIb3DQEBAQUAA4IC
# DwAwggIKAoICAQCR6FSS0gpWsawNJN3Fz0RndJkrN6N9I3AAcbxT38T6KhKPS38Q
# Vr2fcHK3YX/JSw8Xpz3jsARh7v8Rl8f0hj4K+j5c+ZPmNHrZFGvnnLOFoIJ6dq9x
# kNfs/Q36nGz637CC9BR++b7Epi9Pf5l/tfxnQ3K9DADWietrLNPtj5gcFKt+5eNu
# /Nio5JIk2kNrYrhV/erBvGy2i/MOjZrkm2xpmfh4SDBF1a3hDTxFYPwyllEnvGfD
# yi62a+pGx8cgoLEfZd5ICLqkTqnyg0Y3hOvozIFIQ2dOciqbXL1MGyiKXCJ7tKuY
# 2e7gUYPDCUZObT6Z+pUX2nwzV0E8jVHtC7ZcryxjGt9XyD+86V3Em69FmeKjWiS0
# uqlWPc9vqv9JWL7wqP/0uK3pN/u6uPQLOvnoQ0IeidiEyxPx2bvhiWC4jChWrBQd
# nArncevPDt09qZahSL0896+1DSJMwBGB7FY79tOi4lu3sgQiUpWAk2nojkxl8ZED
# LXB0AuqLZxUpaVICu9ffUGpVRr+goyhhf3DQw6KqLCGqR84onAZFdr+CGCe01a60
# y1Dma/RMhnEw6abfFobg2P9A3fvQQoh/ozM6LlweQRGBY84YcWsr7KaKtzFcOmpH
# 4MN5WdYgGq/yapiqcrxXStJLnbsQ/LBMQeXtHT1eKJ2czL+zUdqnR+WEUwIDAQAB
# o4H0MIHxMB8GA1UdIwQYMBaAFK29mHo0tCb3+sQmVO8DveAky1QaMB0GA1UdDgQW
# BBS7r34CPfqm8TyEjq3uOJjs2TIy1DAOBgNVHQ8BAf8EBAMCAYYwDwYDVR0TAQH/
# BAUwAwEB/zARBgNVHSAECjAIMAYGBFUdIAAwRAYDVR0fBD0wOzA5oDegNYYzaHR0
# cDovL2NybC51c2VydHJ1c3QuY29tL0FkZFRydXN0RXh0ZXJuYWxDQVJvb3QuY3Js
# MDUGCCsGAQUFBwEBBCkwJzAlBggrBgEFBQcwAYYZaHR0cDovL29jc3AudXNlcnRy
# dXN0LmNvbTANBgkqhkiG9w0BAQwFAAOCAQEAZL+D8V+ahdDNuKEpVw3oWvfR6T7y
# dgRu8VJwux48/00NdGrMgYIl08OgKl1M9bqLoW3EVAl1x+MnDl2EeTdAE3f1tKwc
# 0DurFxLW7zQYfivpedOrV0UMryj60NvlUJWIu9+FV2l9kthSynOBvxzz5rhuZhEF
# sx6ULX+RlZJZ8UzOo5FxTHxHDDsLGfahsWyGPlyqxC6Cy/kHlrpITZDylMipc6Lr
# Bnsjnd6i801Vn3phRZgYaMdeQGsj9Xl674y1a4u3b0b0e/E9SwTYk4BZWuBBJB2y
# jxVgWEfb725G/RX12V+as9vYuORAs82XOa6Fux2OvNyHm9Gm7/E7bxA4bzCCBeow
# ggPSoAMCAQICE1YAAAidKVOniKW4iGkAAAAACJ0wDQYJKoZIhvcNAQELBQAwczEL
# MAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRQwEgYDVQQHEwtTYW50YSBDbGFyYTEa
# MBgGA1UEChMRSW50ZWwgQ29ycG9yYXRpb24xJTAjBgNVBAMTHEludGVsIEV4dGVy
# bmFsIElzc3VpbmcgQ0EgN0IwHhcNMTgxMTE5MTk0OTQzWhcNMjAxMTE4MTk0OTQz
# WjB/MQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExFDASBgNVBAcTC1NhbnRhIENs
# YXJhMRowGAYDVQQKExFJbnRlbCBDb3Jwb3JhdGlvbjExMC8GA1UEAxMoSW50ZWwo
# UikgV2lyZWxlc3MgQ29ubmVjdGl2aXR5IFNvbHV0aW9uczCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBAPobAwB8a0o/aofFGLcWheioa0oUydsWBdJt3jV/
# MEkXPllWhmeQtPaZDT4kG1YTG+rhdIx0Cu83m2P4PWgeqi2ExYY+fLAFdAIqhc7v
# J+P3Pd6IABwPLKtuSL6AlR6YYOTPN6VkcMYfSMG6PNU5KP6ksxAPa980J5EGsYmc
# oXFpzoCZZfVmfP6/VNFYIK8OILD9FFvRoJdwG8IYYaJvB0DnPBkQjqrHjcLAQMqb
# WjwjkvYo2caZIsims67kvfy/EmsZmQxj4Cfzq0H6LibuObSz6uRa5Sd6wEnUBQrr
# ucb8fI3/MdOBxmUzON5os55iPo64qFABa8u12uOEI+OFdfECAwEAAaOCAWkwggFl
# MB0GA1UdDgQWBBQZ0bJy899nFIWDp6F74fnraqKKJDAfBgNVHSMEGDAWgBSywGem
# Vo0neRB0w/XFpYlm1vEuNjA3BgNVHR8EMDAuMCygKqAohiZodHRwOi8vcGtpLmlu
# dGVsLmNvbS9jcmwvSW50ZWxDQTdCLmNybDBmBggrBgEFBQcBAQRaMFgwMgYIKwYB
# BQUHMAKGJmh0dHA6Ly9wa2kuaW50ZWwuY29tL2NydC9JbnRlbENBN0IuY3J0MCIG
# CCsGAQUFBzABhhZodHRwOi8vT0NTUC5pbnRlbC5jb20vMAwGA1UdEwEB/wQCMAAw
# CwYDVR0PBAQDAgeAMD0GCSsGAQQBgjcVBwQwMC4GJisGAQQBgjcVCIbDjHWEmeVR
# g/2BKIWOn1OCkcAJZ4WJ9mSF6ZJQAgFkAgESMBMGA1UdJQQMMAoGCCsGAQUFBwMD
# MBMGA1UdIAQMMAowCAYGZ4EMAQQBMA0GCSqGSIb3DQEBCwUAA4ICAQC4U0jdi5hd
# 9+q1kP9uS+fFkw7ZjBaGnJ8fWDwJLMEdJy3bO4PBR+J9R/lTYAjkbCOY2LRjYwej
# NULVAeiMsLsLqaTHi3Gz704/naCveOHXJi5MHKob4W4I+ShuBVg3UGoQ3sQU7BTj
# xGANuWmav6Gd4Tins5+vlKXNC1e6nBVJjsEXZrsgDZeOW69WohmZklV4jlCEMssq
# vk/5+yiL7ON5Rv6L9khPjpEBSoYWeE8xptyte4OESB296VnL5mu/H6M2hmet4U5Q
# cz28s+Fl/cZaafHEPS9sf5AffdU0rZakem70p+ngxhlABXNdZ6YcedLGRqcYD1ZI
# hbocidZ9D4u3YMhbDQcjbzS42WH9xX8V5pkuydneBUz8m6XYcmHhU3QkwqRYzoaC
# fYOzxgVkrunvjQ7R7g7tYrrf27eImhxrCd1Pp1cHfnVHnt49Nt7IbKIlS15Vj8ph
# Ili52ag1W8TwdDr4HphbKN7FsPrg36z6S9+FbvRi7XpFSULPdy9QaWsmosfMPhdz
# zujhJKDTNTSwj1m5kIvEAvzdI++65z/NbKw9VPANumlaYFw5x4NXOJdjgq4xbsrH
# J0BVZTVhvMHe55hrg7uwyGLow+dAhKKKiF9IRH5TKHN/epIdgMxSzXJOLdLIXvdu
# C7gRJ7OEAbPredxzYQYQLW+ONT53wxZSMjCCB0kwggUxoAMCAQICEAabXpkncoTI
# dn8TaKfesPMwDQYJKoZIhvcNAQEMBQAwgYUxCzAJBgNVBAYTAkdCMRswGQYDVQQI
# ExJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNVBAcTB1NhbGZvcmQxGjAYBgNVBAoT
# EUNPTU9ETyBDQSBMaW1pdGVkMSswKQYDVQQDEyJDT01PRE8gUlNBIENlcnRpZmlj
# YXRpb24gQXV0aG9yaXR5MB4XDTE1MTAyODAwMDAwMFoXDTIxMDYxNzIzNTk1OVow
# czELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRQwEgYDVQQHEwtTYW50YSBDbGFy
# YTEaMBgGA1UEChMRSW50ZWwgQ29ycG9yYXRpb24xJTAjBgNVBAMTHEludGVsIEV4
# dGVybmFsIElzc3VpbmcgQ0EgN0IwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIK
# AoICAQC6Wm/xXxoLVBASupDWousOXqw9zhWFmkoRymR/IoppFlfPIDokgNe74FPc
# qUvPbIGxvhqiAeBFe2wMZtRPj24i7fNSmKJ6NTeKbOy4MYZJZynHtLOIcNCZHivE
# EvfuHvO8JI4RhgOT0nkL567cWjGpoueACfpaklFnMO87sfSx/U6rGmgl59tVYHN7
# Fb8ATJBCnilmD3o8432gQpmQnjVcgxzlSN9BfLOe6Zcqw/oDRiOpJsJl8ZXiV02m
# qoCziVG3MpZDJfQvkPgOzM94dHUNri+doaAL/B1NI8aGtt1hx6a/lxHtFQxA4/3l
# EC2ds8Hv7etkeReMBq5pkutGAyrUIdFZ+vw26ZcWRnkoM6NZKxn0FeZwPEqJssk+
# jXdI1Ap8rEXlRClcE/PITY4mnvBUhQDtn+vuz+ITwbqt06rVRK20dB6rAN0Hcl6c
# prSQ4/ZGoQBUV8gmF+NIc9GYaNGRrKw6duxL4zaFkxliwCFIaAuKxZQlHSjVAtQH
# 6f5QU4ORE2xhAAf8QPeXzY8yew16NwwIo/vsXvqNc+O6xJLQcfT7HGGVbVdbHmYt
# aiB+VTC7rIlfynHtXBOOBoUgckbMIf0OYxDfHEc/EtL5UEsEG99v0sybjlcFIJWv
# Y1aLIVAJz5Xvnzb3K3v/gHFQr31Lmp7Q90QYsGAalKOKMAie6wIDAQABo4IBxDCC
# AcAwHwYDVR0jBBgwFoAUu69+Aj36pvE8hI6t7jiY7NkyMtQwHQYDVR0OBBYEFLLA
# Z6ZWjSd5EHTD9cWliWbW8S42MA4GA1UdDwEB/wQEAwIBhjASBgNVHRMBAf8ECDAG
# AQH/AgEAMD4GA1UdJQQ3MDUGCCsGAQUFBwMDBggrBgEFBQcDBAYIKwYBBQUHAwgG
# CisGAQQBgjcKAwwGCSsGAQQBgjcVBTAiBgNVHSAEGzAZMA0GCyqGSIb4TQEFAWkB
# MAgGBmeBDAEEATBMBgNVHR8ERTBDMEGgP6A9hjtodHRwOi8vY3JsLmNvbW9kb2Nh
# LmNvbS9DT01PRE9SU0FDZXJ0aWZpY2F0aW9uQXV0aG9yaXR5LmNybDBxBggrBgEF
# BQcBAQRlMGMwOwYIKwYBBQUHMAKGL2h0dHA6Ly9jcnQuY29tb2RvY2EuY29tL0NP
# TU9ET1JTQUFkZFRydXN0Q0EuY3J0MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5j
# b21vZG9jYS5jb20wNQYDVR0eBC4wLKAqMAuBCWludGVsLmNvbTAboBkGCisGAQQB
# gjcUAgOgCwwJaW50ZWwuY29tMA0GCSqGSIb3DQEBDAUAA4ICAQA1uwPqzJtgGhPQ
# dVKOgJVFTp6/bsC7ZKrDbrECHUZeL+gvSMyEEPetmTv/+oVoKbDTfDHiGrR7wWbi
# pTvHKRiYNa5jAahFIJVh2xBNuQ1r05lkzl+LuGwTRqBuWg0+55DrtzGhIfWN3jt7
# aTbxCAC5qr8cVmFW18ySPynU2WvYIi8OVvVq0UbogI85epI8Z0i34voZDzdn4t8p
# LQKqQygurixGQiS+bbtqiEmmTCDf5WVP+uHBvnHV+F71nWaSsjtk4eiurJlVF73b
# G9+gk08/VvI7g9XSt8EIWlJAQuM+kSD3NbSR8E3hNGlIecDtMMmTGoTVchmPbYA5
# 9FmrIBbY+f9wJiN77MUAMyJ8PSA67bQovHqBDOcLwT98MAxOULhnD9dkF7fDxSCF
# yo/O1SYqElS5/yL4qCc8yg6FNxTuAuUvZhViY4dqXs8p07iReLdhchd7wRmmGAgi
# 2tCRJfYGCQkmsC2sgIh0M1/H4ETBMJl22HexRwHvaZIr7a5YKWOgNY7kHbcE8do6
# sjKAsci88OcPcQB6MzoG6KTYednZU82b/rJoW4iEhWsHcdBPkwoHYAM0CNJzvxQa
# 3+PHBBstmZ6THJWzh5hCWhyRY1I5io9KKsJMe3BpOjzx+y//DgqHlOQBas+btB+j
# DqnqKtyvK4xEAf06WH0yeKIZ1cl0xTGCBEMwggQ/AgEBMIGKMHMxCzAJBgNVBAYT
# AlVTMQswCQYDVQQIEwJDQTEUMBIGA1UEBxMLU2FudGEgQ2xhcmExGjAYBgNVBAoT
# EUludGVsIENvcnBvcmF0aW9uMSUwIwYDVQQDExxJbnRlbCBFeHRlcm5hbCBJc3N1
# aW5nIENBIDdCAhNWAAAInSlTp4iluIhpAAAAAAidMA0GCWCGSAFlAwQCAQUAoHww
# EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIA5Q9/z5
# xdRXudVUiqVTJP3SpgZEWxZINGZw60GjjXgCMA0GCSqGSIb3DQEBAQUABIIBAIQc
# g8+rKZUUPvNglaEDc1WG1CijcPXKvWx724hMOti4nreqPf3hxBcBxY2t3Qi6FLxn
# l54no18NMkCr4Nx8W3nhiVLpfM5iqhnWxpfqGyv2IE74feyJSRlWvNGm1HSuZELp
# xeX4Wn8CoNAtX/GNsk35N1OkyQJk0Npr8NLf80mBqcD64bSVQCcvr6+Qyui4Rwtx
# HsE3Sd9tXzcB6h0jSpiHXo9+/7pgwbEOQBBl/Mqau5qraKHQUCaOrV5XXc64XAq6
# 5OaQ7ycHsBkVMWk4lwHuYiWWkYhNSqObO49z+/z9vUfT0GuvSvKjgSqlkORoCHT0
# 4r/8Rs3l4C+a/i4TYaihggILMIICBwYJKoZIhvcNAQkGMYIB+DCCAfQCAQEwcjBe
# MQswCQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
# BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2VydmljZXMgQ0EgLSBHMgIQ
# Ds/0OMj+vzVuBNhqmBsaUDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqG
# SIb3DQEHATAcBgkqhkiG9w0BCQUxDxcNMTkwNzEyMDUwMjQ3WjAjBgkqhkiG9w0B
# CQQxFgQU6vMLD9NmfffRTKHQs73Bf/7vmFowDQYJKoZIhvcNAQEBBQAEggEAR6sG
# SnaXqIekx9L2V+0zb/B/S+ubFR24aWCw/YDWrZZJlvdJZa4rso2S0cz2NowWl6eg
# nT++ZiQF0qHwiHjht2LxJ1SO7v+GHlugNakSkOlrD8nJIUmkBP6It4QE187RHNMc
# jZZklOXd+bEJC72C539ASH0bFgB0B9iJ4kfqWT858mwUQSjDryE6ZCAl2JU1z168
# cHdt5HAt1R7XuQCw+1bS/s1tiCVgboWvFsV5YvwAFH4TW4oKpd84Evd9djJvQ1Q0
# 4S5Er715h2DaeZvN9YZDr4yitSHxfEbclQARexfXc6SJwYCvuMqqjJjt4z8RgB7v
# qovQbcBVZ/WmYRKX2w==
# SIG # End signature block
