/** @file
  This file contains all the definitions of various API-IDs, callback IDs etc.

Copyright (c) 2017, Intel Mobile Communications GmbH. All rights reserved.<BR>
This program and the accompanying materials
are licensed and made available under the terms and conditions of the BSD License
which accompanies this distribution.  The full text of the license may be found at
http://opensource.org/licenses/bsd-license.php

THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,
WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.

**/

#define OS_BLE_DATA_SIZE					256
#define CB_PARAM_OFFSET 					4
#define CONNECTED_AS_SERVER				 	0x01
#define CONNECTED_AS_CLIENT 				0x02
#define HCI2ILE_SIZE_OF_LOCAL_NAME			31
#define HCI2ILE_CMD_OPCODE 					0xFC80
#define HCI2ILE_EVENT_CODE 					0xFF
#define HCI2ILE_EVENT_ID					0x40
#define HCI2ILE_SIZE_OF_BD_ADDR				6
#define HCI_CMD 1
#define HCI_ACL 2
#define HCI_SCO 3
#define HCI_EVT 4
#define HCI_EVENT_CMD_CMPL								0x0E


/***************************************
API-ID
****************************************/
/* GAP API Subcategories from 0x00 to 0x63 */
#define HCI2ILE_SET_ADVERTISEMENT_DATA					0x02
#define HCI2ILE_REMOVE_ADVERTISEMENT_DATA				0x03
#define HCI2ILE_START_DISCOVERABLE						0x04
#define HCI2ILE_STOP_DISCOVERABLE						0x05
#define HCI2ILE_SET_LOCAL_DEVICE_NAME					0x06
#define HCI2ILE_START_SCAN								0x07
#define HCI2ILE_STOP_SCAN								0x08
#define HCI2ILE_CONNECT									0x09
#define HCI2ILE_DISCONNECT								0x0A
#define HCI2ILE_ADD_TO_WHITELIST						0x0B
#define HCI2ILE_REMOVE_FROM_WHITELIST					0x0C
#define HCI2ILE_CLEAR_WHITELIST							0x0D
#define HCI2ILE_CREATE_BOND								0x0E
#define HCI2ILE_SEND_PASSKEY							0x0F
#define HCI2ILE_SEND_AUTHORIZATION						0x10
#define HCI2ILE_SMP_REGISTER							0x11
#define HCI2ILE_GET_ATTRIBUTE_MTU						0x12
#define HCI2ILE_SET_ATTRIBUTE_MTU						0x13
#define HCI2ILE_UPDATE_CONN_PARAMS						0x14
#define HCI2ILE_L2CAP_COC_REGISTER						0x15
#define HCI2ILE_L2CAP_COC_CONNECT_REQ					0x16
#define HCI2ILE_L2CAP_COC_DISCONNECT_REQ				0x17
#define HCI2ILE_L2CAP_COC_SEND_DATA						0x18
#define HCI2ILE_REMOVE_BOND								0x19
#define HCI2ILE_SET_IO_CAPABILITIES						0x1A
#define HCI2ILE_REGISTER_FOR_LINK_STATE_CHANGE_EVENTS	0x1B
#define HCI2ILE_SET_SCAN_RESPONSE_DATA					0x1C
#define HCI2ILE_REMOVE_SCAN_RESPONSE_DATA				0x1D
#define HCI2ILE_START_DISCOVERABLE_EX					0x1E
#define HCI2ILE_START_SCAN_EX							0x1F
#define HCI2ILE_SET_DATA_LEN							0x20
#define HCI2ILE_SMP_SEND_NC_RESULT						0x21
#define HCI2ILE_CONNECT_EX								0x22
#define HCI2ILE_CREATE_BOND_EX							0x23
#define HCI2ILE_TEST_ADD_TO_RESOLVING_LIST				0x24
#define HCI2ILE_TEST_REMOVE_FROM_RESOLVING_LIST			0x25
#define HCI2ILE_REGISTER_STORAGE						0x26
#define HCI2ILE_KEY_RESPONSE							0x27

#define HCI2ILE_TEST_CONFIGURE_DEBUG_TRACE				0x50
#define HCI2ILE TEST_SECURE_CONNECTION_DEBUG_MODE		0x51

/* GATT Server API Subcategories from 0x64 to 0x95 */
#define HCI2ILE_ADD_SERICE								0x64
#define HCI2ILE_ADD_CHARACTERISTIC						0x65
#define HCI2ILE_ADD_DESCRIPTOR							0x66
#define HCI2ILE_START_SERVICE							0x67
#define HCI2ILE_REMOVE_SERVICE							0x68
#define HCI2ILE_SEND_ATTRIBUTE_READ_RSP					0x69
#define HCI2ILE_SEND_ATTRIBUTE_WRITE_RSP				0x6A
#define HCI2ILE_SEND_NOTIFICATION						0x6B
#define HCI2ILE_ADD_INCLUDED_SERVICE					0x6C

/* GATT Client API Subcategories from 0x96 to 0xC7 */
#define HCI2ILE_DISCOVER_PRIMARY_SERVICE				0x96
#define HCI2ILE_DISCOVER_INCLUDED_SERVICE				0x97
#define HCI2ILE_DISCOVER_CHARACTERISTIC					0x98
#define HCI2ILE_DISCOVER_DESCRIPTOR						0x99
#define HCI2ILE_READ_ATTRIBUTE_VALUE					0x9A
#define HCI2ILE_WRITE_ATTRIBUTE_VALUE					0x9B
#define HCI2ILE_REGISTER_NOTIFICATION					0x9C
#define HCI2ILE_READ_MULTI_ATTRIBUTE_VALUE				0x9D
#define HCI2ILE_READ_BY_TYPE_ATTRIBUTE					0x9E

/*Test API Subcategories from 0xC8 to 0xF9 */
#define HCI2ILE_TEST_GATT_MTU_EXCHANGE					0xC8
#define HCI2ILE_TEST_READ_AUTHENTICATED_PAYLOAD_TOUT	0xC9
#define HCI2ILE_TEST_WRITE_AUTHENTICATED_PAYLOAD_TOUT	0xCA
#define HCI2ILE_TEST_ENABLE_PRIVACY						0xCB
#define HCI2ILE_SEND_HCI_COMMAND						0xCC
#define HCI2ILE_TEST_SET_BD_ADDRESS						0xCD
#define HCI2ILE_GET_BDADDR								0xCE
#define HCI2ILE_TEST_TRIGER_PANIC						0xCF
#define HCI2ILE_SEND_VSHCI_COMMAND						0xD0

/*****************************************************************
Callback ID to uniquely map each callback event
******************************************************************/
#define HCI2ILE_CB_ID_ON_ERROR_CB						0x01
#define HCI2ILE_CB_ID_ON_MTU_CHANGED					0x02
#define HCI2ILE_CB_ID_ON_SERVICE_ADDED					0x03
#define HCI2ILE_CB_ID_ON_CHARACTERISTIC_ADDED			0x04
#define HCI2ILE_CB_ID_ON_DESCRIPTOR_ADDED				0x05
#define HCI2ILE_CB_ID_ON_SERVICE_STARTED 				0x06
#define HCI2ILE_CB_ID_ON_PRIMARY_SERVICE_DISCOVERED		0x07
#define HCI2ILE_CB_ID_ON_INCLUDED_SERVICE_DISCOVERED	0x08
#define HCI2ILE_CB_ID_ON_CHARACTERISTIC_DISCOVERED		0x09
#define HCI2ILE_CB_ID_ON_DESCRIPTOR_DISCOVERED			0x0A
#define HCI2ILE_CB_ID_ON_ATTRIBUTE_READ					0x0B
#define HCI2ILE_CB_ID_ON_ATTRIBUTE_WRITE				0x0C
#define HCI2ILE_CB_ID_ON_NOTIFICATION					0x0D
#define HCI2ILE_CB_ID_ON_NOTIFICATION_REGISTERED		0x0E
#define HCI2ILE_CB_ID_ON_CONNECTED						0x0F
#define HCI2ILE_CB_ID_ON_DISCONNECTED 					0x10
#define HCI2ILE_CB_ID_ON_ATTRIBUTE_READ_REQ				0x11
#define HCI2ILE_CB_ID_ON_ATTRIBUTE_WRITE_REQ			0x12
#define HCI2ILE_CB_ID_ON_EXEC_WRITE_REQ					0x13
#define HCI2ILE_CB_ID_ON_INDICATION_CONFIRMATION 		0x14
#define HCI2ILE_CB_ID_SCAN_RESULTS_CB					0x15
#define HCI2ILE_CB_ID_SCAN_COMPLETED_CB					0x16
#define HCI2ILE_CB_ID_STACK_INITIALIZED_CB				0x17
#define HCI2ILE_CB_ID_BONDING_COMPLETED_CB				0x18
#define HCI2ILE_CB_ID_DATA_SIGNING_COMPLETED			0x19
#define HCI2ILE_CB_ID_SMP_CB 	 						0x1A
#define HCI2ILE_CB_ID_LC_REGISTER_CB					0x1B
#define HCI2ILE_CB_ID_LC_AUTHORISATION_CB				0x1C
#define HCI2ILE_CB_ID_LC_CONNECTION_CMPL_CB				0x1D
#define HCI2ILE_CB_ID_LC_FLOW_CONTROL_CB				0x1E
#define HCI2ILE_CB_ID_LC_RECV_DATA_CB					0x1F
#define HCI2ILE_CB_ID_LC_DISCONNECTION_CMPL_CB			0x20
#define HCI2ILE_CB_ID_ON_INCLUDED_SERVICE_ADDED			0x21
#define HCI2ILE_CB_ID_ON_SERVICE_REMOVED				0x22
#define HCI2ILE_CB_ID_ON_DATA_LEN_CHANGE_EVT_CB			0x23
#define HCI2ILE_CB_ID_ON_STORAGE_REGISTER_REQ_CB		0x24
#define HCI2ILE_CB_ID_ON_KEY_REQ_CB						0x25
#define HCI2ILE_CB_ID_ON_KEY_UPDATE_CB					0x26
#define HCI2ILE_CB_ID_ON_LINK_ENC_CHANGED_CB			0x27
#define HCI2ILE_CB_ID_ON_VSC_CB							0x28
#define HCI2ILE_CB_ID_ON_CONN_PARAM_CHANGED_CB			0x29

#define HCI2ILE_CB_ID_ON_READ_AUTH_PAYLOAD_TIMEOUT_CB	0x80

/*******************************
Maximum length of HCI commands
*******************************/
#define HCI2ILE_MAX_LENTH_REGISTER_APPLICATION		0x00
#define HCI2ILE_MAX_LENTH_DEREGISTER_APPLICATION	0x01
#define HCI2ILE_MAX_LENTH_SET_ADVERTISEMENT_DATA	0x02
#define HCI2ILE_MAX_LENTH_REMOVE_ADVERTISEMENT_DATA	0x03
#define HCI2ILE_MAX_LENTH_START_DISCOVERABLE		0x04
#define HCI2ILE_MAX_LENTH_STOP_DISCOVERABLE			0x05
#define HCI2ILE_MAX_LENTH_SET_LOCAL_DEVICE_NAME		0x06
#define HCI2ILE_MAX_LENTH_START_SCAN				0x07
#define HCI2ILE_MAX_LENTH_STOP_SCAN					0x08
#define HCI2ILE_MAX_LENTH_CONNECT					0x09
#define HCI2ILE_MAX_LENTH_DISCONNECT				0x0A
#define HCI2ILE_MAX_LENTH_ADD_TO_WHITELIST			0x0B
#define HCI2ILE_MAX_LENTH_REMOVE_FROM_WHITELIST		0x0C
#define HCI2ILE_MAX_LENTH_CLEAR_WHITELIST			0x0D
#define HCI2ILE_MAX_LENTH_CREATE_BOND				0x0E
#define HCI2ILE_MAX_LENTH_SEND_PASSKEY				0x0F
#define HCI2ILE_MAX_LENTH_SEND_AUTHORIZATION		0x10
#define HCI2ILE_MAX_LENTH_SMP_REGISTER				0x11
#define HCI2ILE_MAX_LENTH_SIGN_DATA					0x12
#define HCI2ILE_MAX_LENTH_GET_ATTRIBUTE_MTU			0x13
#define HCI2ILE_MAX_LENTH_SET_ATTRIBUTE_MTU			0x14
#define HCI2ILE_MAX_LENTH_UPDATE_CONN_PARAMS		0x15
/*gatt server api subcategories*/
#define HCI2ILE_MAX_LENTH_ADD_SERICE				0x64
#define HCI2ILE_MAX_LENTH_ADD_CHARACTERISTIC		0x65
#define HCI2ILE_MAX_LENTH_ADD_DESCRIPTOR			0x66
#define HCI2ILE_MAX_LENTH_START_SERVICE				0x67
#define HCI2ILE_MAX_LENTH_REMOVE_SERVICE			0x68
#define HCI2ILE_MAX_LENTH_SEND_ATTRIBUTE_READ_RSP	0x69
#define HCI2ILE_MAX_LENTH_SEND_ATTRIBUTE_WRITE_RSP	0x6A
#define HCI2ILE_MAX_LENTH_SEND_NOTIFICATION			0x6B
/*gatt client api subcategories*/
#define HCI2ILE_MAX_LENTH_DISCOVER_PRIMARY_SERVICE	0x96
#define HCI2ILE_MAX_LENTH_DISCOVER_INCLUDED_SERVICE	0x97
#define HCI2ILE_MAX_LENTH_DISCOVER_CHARACTERISTIC	0x98
#define HCI2ILE_MAX_LENTH_READ_ATTRIBUTE_VALUE		0x99
#define HCI2ILE_MAX_LENTH_WRITE_ATTRIBUTE_VALUE		0x9A
#define HCI2ILE_MAX_LENTH_REGISTER_NOTIFICATION		0x9B
/*test api subcategories*/
#define HCI2ILE_MAX_LENTH_TEST_GATT_MTU_EXCHANGE				0xC8
#define HCI2ILE_MAX_LENTH_TEST_READ_AUTHENTICATED_PAYLOAD_TOUT	0xC9
#define HCI2ILE_MAX_LENTH_TEST_WRITE_AUTHENTICATED_PAYLOAD_TOUT	0xCA
#define HCI2ILE_MAX_LENTH_TEST_ENABLE_PRIVACY					0xCB
#define HCI2ILE_MAX_LENTH_SEND_HCI_COMMAND						0xCC

/*******************************
Length of HCI callbacks
*******************************/			
#define HCI2ILE_SIZE_OF_BUFFER(len)						(sizeof(UINT16) + sizeof(UINT16) + len)
#define HCI2ILE_LENGTH_CONNECT_CB					(DBG_EVT_HEADER + (2 * HCI2ILE_SIZE_OF_BD_ADDR) + 6)
#define HCI2ILE_LENGTH_DISCONNECT_CB				(DBG_EVT_HEADER + 3)
#define HCI2ILE_LENGTH_SCAN_RESULT_CB				(DBG_EVT_HEADER + HCI2ILE_SIZE_OF_BD_ADDR + HCI2ILE_SIZE_OF_LOCAL_NAME + 10) // + adv_lenght
#define HCI2ILE_LENGTH_SCAN_COMPLETED_CB			(DBG_EVT_HEADER + 2)
#define HCI2ILE_LENGTH_SMP_CB						(DBG_EVT_HEADER + HCI2ILE_SIZE_OF_BD_ADDR + 4) // + length
#define HCI2ILE_LENGTH_PRIMARY_SERVICE_DIS_CB		(DBG_EVT_HEADER + 9) // + uuid->length
#define HCI2ILE_LENGTH_INCLUDED_SERVICE_DIS_CB		(DBG_EVT_HEADER + 11) // +uuid->length
#define HCI2ILE_LENGTH_CHAR_DISCOVERY_CB			(DBG_EVT_HEADER + 10) // + uuid->length
#define HCI2ILE_LENGTH_DESC_DISCOVERY_CB			(DBG_EVT_HEADER + 7) // + uuid->lenght
#define HCI2ILE_LENGTH_ATTRIBUTE_WRITE_REQ_CB		(DBG_EVT_HEADER + 7) // + buffer->length
#define HCI2ILE_LENGTH_ATTRIBUTE_READ_REQ_CB		(DBG_EVT_HEADER + 7)
#define HCI2ILE_LENGTH_ATTRIBUTE_WRITE_CB			(DBG_EVT_HEADER + 8) // + buffer->length
#define HCI2ILE_LENGTH_ATTRIBUTE_READ_CB			(DBG_EVT_HEADER + 6) // + buffer->length
#define HCI2ILE_LENGTH_NOTIFICATION_REGISTERED_CB	(DBG_EVT_HEADER + 5)
#define HCI2ILE_LENGTH_ATT_MTU_CHANGED_CB			(DBG_EVT_HEADER + 4)
#define HCI2ILE_LENGTH_SERVICE_ADDED_CB				(DBG_EVT_HEADER + 5) // + uuid->length
#define HCI2ILE_LENGTH_INCLUDED_SERVICE_ADDED_CB	(DBG_EVT_HEADER + 5) // + uuid->lenght
#define HCI2ILE_LENGTH_SERVICE_REMOVED_CB			(DBG_EVT_HEADER + 6)
#define HCI2ILE_LENGTH_CHAR_ADDED_CB				(DBG_EVT_HEADER + 5) // + uuid->length
#define HCI2ILE_LENGTH_DESC_ADDED_CB				(DBG_EVT_HEADER + 5) // + uuid->length
#define HCI2ILE_LENGTH_SERVICE_STARTED_CB			(DBG_EVT_HEADER + 5) // + uuid->length
#define HCI2ILE_LENGTH_NOTIFICATION_CB				(DBG_EVT_HEADER + 5) // + buufer->length
#define HCI2ILE_LENGTH_INDICATION_CONFIRMATION_CB	(DBG_EVT_HEADER + 4)
#define HCI2ILE_LENGTH_BONDING_COMPLETED_CB			(DBG_EVT_HEADER + (2 * HCI2ILE_SIZE_OF_BD_ADDR) + 5)
#define HCI2ILE_LENGTH_LINK_ENC_CHANGE_CB			(DBG_EVT_HEADER + 4)
#define HCI2ILE_LENGTH_READ_AUTHPAYLOAD_TIMEDOUT_CB	(DBG_EVT_HEADER + 4)
#define HCI2ILE_LENGTH_VSC_CB						(DBG_EVT_HEADER + 1)
#define HCI2ILE_LENGTH_DATA_LEN_CHANGE_EVT_CB		(DBG_EVT_HEADER + 10)
#define HCI2ILE_LENGTH_STACK_INITIALIZED_CB			(DBG_EVT_HEADER + 2)
#define HCI2ILE_LENGTH_ON_CONN_PARAM_CHANGED_CB		(DBG_EVT_HEADER + 9)

/* For L2CAP COC callbacks */

#define HCI2ILE_LENGTH_LC_REGISTER_CB				(DBG_EVT_HEADER + 4)
#define HCI2ILE_LENGTH_LC_AUTH_CB					(DBG_EVT_HEADER + 4)
#define HCI2ILE_LENGTH_LC_CONNECTION_COMPLETED_CB	(DBG_EVT_HEADER + 9)
#define HCI2ILE_LENGTH_LC_FLOW_CONTROL_CB			(DBG_EVT_HEADER + 4)
#define HCI2ILE_LENGTH_LC_RECV_DATA_CB				(DBG_EVT_HEADER + 5) // + buffer_length
#define HCI2ILE_LENGTH_LC_DISCONNECTION_COMPLETE_CB	(DBG_EVT_HEADER + 4)
#define HCI2ILE_LENGTH_STORAGE_REG_REQUEST_CB		(DBG_EVT_HEADER + 1)

#define HCI2ILE_LENGTH_KEY_REQUEST_CB				(DBG_EVT_HEADER + HCI2ILE_SIZE_OF_BD_ADDR + 3)
#define HCI2ILE_LENGTH_KEY_UPDATE_CB				(DBG_EVT_HEADER + HCI2ILE_SIZE_OF_BD_ADDR + 4) // + length
#define HCI2ILE_BOND_INFO_LEN						(120)
#define HCI2ILE_LENGTH_BONDING_INFO_CB				(DBG_EVT_HEADER + HCI2ILE_BOND_INFO_LEN + 10)
#define HCI2ILE_LENGTH_CLEAR_KEY_CB					(DBG_EVT_HEADER + HCI2ILE_SIZE_OF_BD_ADDR + 4)










/**************end of file*******************/
